/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;

public class AlarmInfoPanel
extends guiPanel {
    private static final long serialVersionUID = -8046233980788354678L;
    public static final int LAYOUT_VERTICAL = 0;
    public static final int LAYOUT_HORIZONTAL = 1;
    private final guiCheckBox d_enableAlarmCB;
    private ValueField<UnitDouble> d_setpointFld;
    private final guiCheckBox d_initStateCB;
    private final guiCheckBox d_latchCB;
    private final int d_layout;

    public AlarmInfoPanel(IQuantity iQuantity) {
        this(iQuantity, 0);
    }

    public AlarmInfoPanel(IQuantity iQuantity, int n) {
        this(iQuantity.get().unitType, n);
    }

    public AlarmInfoPanel(int n) {
        this(n, 0);
    }

    public AlarmInfoPanel(int n, int n2) {
        super(new GridBagLayout());
        this.d_layout = n2;
        this.d_enableAlarmCB = new guiCheckBox(Intl.intl("Enable Setpoint:"));
        this.d_setpointFld = ValueFields.udFld(UnitSystem.getSource(n));
        this.d_initStateCB = new guiCheckBox(Intl.intl("Initially activated"));
        this.d_latchCB = new guiCheckBox(Intl.intl("Trigger only once"));
        this.loadTripFlags(1);
        this.addComponents();
    }

    private void addComponents() {
        LinkStatus.link((AbstractButton)this.d_enableAlarmCB, this.d_setpointFld, this.d_initStateCB, this.d_latchCB);
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        if (this.d_layout == 0) {
            gridBagHelper.addRow(this.d_enableAlarmCB, this.d_setpointFld, 0);
            gridBagHelper.addIdentRow(this.d_latchCB, 0);
            gridBagHelper.addIdentRow(this.d_initStateCB, 0);
        } else {
            gridBagHelper.addRow(this.d_enableAlarmCB, this.d_setpointFld, this.d_latchCB, this.d_initStateCB);
        }
        gridBagHelper.finalizeRows();
    }

    public void setCurrentMsr(IQuantity iQuantity) {
        this.reinitSetpoint(iQuantity.get().unitType);
    }

    public void setCurrentUnitType(int n) {
        this.reinitSetpoint(n);
    }

    private void reinitSetpoint(int n) {
        IUnitSrc iUnitSrc = UnitSystem.getSource(n);
        ValueFields.setUnitSource(this.d_setpointFld, iUnitSrc);
        this.removeAll();
        this.addComponents();
        this.invalidate();
        this.validate();
    }

    public void load(IQuantity iQuantity, AlarmInfo alarmInfo) {
        this.load(iQuantity.get().unitType, alarmInfo);
    }

    public void load(int n, AlarmInfo alarmInfo) {
        this.d_enableAlarmCB.setSelected(alarmInfo != null);
        if (alarmInfo != null) {
            this.reinitSetpoint(n);
            this.d_setpointFld.setValue(alarmInfo.setpoint);
            this.d_initStateCB.setSelected(TripFlags.initiallyOn(alarmInfo.tripFlags));
            this.d_latchCB.setSelected(TripFlags.latch(alarmInfo.tripFlags));
        }
    }

    public AlarmInfo save() {
        if (!this.d_enableAlarmCB.isSelected()) {
            return null;
        }
        int n = 0;
        if (this.d_initStateCB.isSelected()) {
            n |= 2;
        }
        if (this.d_latchCB.isSelected()) {
            n |= 1;
        }
        return new AlarmInfo((UnitDouble)this.d_setpointFld.getValue(), n);
    }

    private void loadTripFlags(int n) {
        this.d_initStateCB.setSelected(TripFlags.initiallyOn(n));
        this.d_latchCB.setSelected(TripFlags.latch(n));
    }
}

