/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.util.Arrays;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TripFlagsPanel;

public abstract class ADevcEditor<T extends IDevice>
implements IDevcEditor<T> {
    @Override
    public AlarmInfoPanel createAlarmPanel() {
        IMeasurer iMeasurer;
        Object t = this.create();
        if (t instanceof IMeasurer && (iMeasurer = (IMeasurer)t).getNumMeasurements() == 1) {
            return new AlarmInfoPanel(iMeasurer.getQuantity(0), 0);
        }
        return null;
    }

    @Override
    public TripFlagsPanel createTripPanel() {
        return new TripFlagsPanel();
    }

    @Override
    public ControlSelPnl createCtrlInputPanel(PyroMod pyroMod, NamePnl namePnl) {
        Object t = this.create();
        if (t instanceof ISignalSink && ((ISignalSink)t).getInputPin() instanceof OneLogicInPin) {
            String string = t instanceof IFreezable ? Intl.intl("Freeze Output:") : null;
            String string2 = t instanceof IFreezable ? Intl.intl("Freezes the output of the device when a control activates.") : null;
            ControlSelPnl controlSelPnl = new ControlSelPnl(pyroMod.getControls(), string, string2);
            if (namePnl != null) {
                t.setName(namePnl.save());
                controlSelPnl.setNameSrc(namePnl.getNameField(), Arrays.asList(t));
            }
            return controlSelPnl;
        }
        return null;
    }
}

