/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Property;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.Util;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.IGridBagAdder;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnl;
import pyrosim.gui.controls.NewControlDlg;
import pyrosim.gui.controls.TextFldNameSource;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Pair;

public class ControlSelPnl
implements IGridBagAdder {
    public static final String NEW_ENTRY = Intl.intl("<New...>");
    public final ControlBridge NULL_ENTRY = new ControlBridge("");
    private Function<Stream<? extends INamed>, Stream<String>> d_nameSource;
    private Collection<? extends INamed> d_nameSrcs = Collections.EMPTY_LIST;
    private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;
    private final guiLabel d_lbl;
    private final ControlComboBox d_cb;
    private final guiLabel d_descLbl;
    public static final Composite.IObjectProp<OneLogicInPin, ControlBridge> CTRL_PROP = new Composite.AObjectProp<OneLogicInPin, ControlBridge>(OneLogicInPin.class){

        @Override
        public Object get(OneLogicInPin oneLogicInPin) {
            Set<? extends IOutPin> set = oneLogicInPin.getConnections();
            return set.isEmpty() ? null : set.iterator().next();
        }

        @Override
        public void set(OneLogicInPin oneLogicInPin, ControlBridge controlBridge) {
            oneLogicInPin.disconnectAll();
            if (controlBridge != null) {
                oneLogicInPin.connect(controlBridge.getOutputPins().get(0));
            }
        }
    };

    public ControlSelPnl(ControlMgr controlMgr) {
        this(controlMgr, null, null);
    }

    public ControlSelPnl(ControlMgr controlMgr, String string, String string2) {
        this.d_cb = new ControlComboBox(controlMgr);
        this.d_lbl = new guiLabel(string == null ? Intl.intl("Activation:") : string);
        if (string2 != null) {
            this.d_lbl.setToolTipText(string2);
        }
        this.d_nameSource = stream -> stream.map(iNamed -> iNamed.getName());
        this.d_descLbl = new guiLabel();
        this.d_descLbl.setPreferredSize(new Dimension(20, this.d_cb.getPreferredSize().height));
        this.d_descLbl.setCursor(Cursor.getPredefinedCursor(12));
        this.d_descLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!ControlSelPnl.this.d_descLbl.isEnabled()) {
                    return;
                }
                ControlBridge controlBridge = (ControlBridge)ControlSelPnl.this.d_cb.getSelectedItem();
                if (controlBridge != ControlSelPnl.this.NULL_ENTRY) {
                    ControlSelPnl.this.editControl(controlBridge);
                    ControlSelPnl.this.updateFromSelection();
                }
            }
        });
        this.d_cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ControlSelPnl.this.updateFromSelection();
            }
        });
        this.updateNullDesc();
        this.updateFromSelection();
    }

    private Pair<List<String>, ControlDesc.SinkType> getSinkNames(ControlBridge controlBridge) {
        Object object;
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        DepSnapshot depSnapshot = pyroMod.getDependencies(controlBridge);
        Set<ISignalSink> set = depSnapshot.findAllDependents(ISignalSink.class, (Object)controlBridge);
        set.removeAll(this.d_nameSrcs);
        Object object2 = !set.isEmpty() && !this.d_nameSrcs.isEmpty() ? ((object = ControlDesc.getSinkType(set)) == this.d_sinkType ? object : ControlDesc.SinkType.ACTIVATE) : (!set.isEmpty() ? ControlDesc.getSinkType(set) : (!this.d_nameSrcs.isEmpty() ? this.d_sinkType : ControlDesc.SinkType.ACTIVATE));
        object = new ArrayList(set.size() + this.d_nameSrcs.size());
        for (ISignalSink iSignalSink : set) {
            if (!(iSignalSink instanceof INamed)) continue;
            ((ArrayList)object).add(((INamed)((Object)iSignalSink)).getName());
        }
        ((Stream)this.d_nameSource.apply(this.d_nameSrcs.stream()).sequential()).forEach(arg_0 -> ControlSelPnl.lambda$getSinkNames$332((ArrayList)object, arg_0));
        return new Pair<Object, ControlDesc.SinkType>(object, (ControlDesc.SinkType)((Object)object2));
    }

    private void editControl(final ControlBridge controlBridge) {
        guiDialog guiDialog2 = new guiDialog((Window)PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("Edit %s"), controlBridge.getName()), 9);
        guiDialog2.setResizable(true);
        final ControlPnl controlPnl = new ControlPnl();
        guiDialog2.getDialogPane().add((Component)controlPnl, "Center");
        Pair<List<String>, ControlDesc.SinkType> pair = this.getSinkNames(controlBridge);
        controlPnl.init(controlBridge, (Collection)pair.v1, (ControlDesc.SinkType)((Object)pair.v2));
        if (guiDialog2.doModal() == 1) {
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    controlPnl.commit(controlBridge);
                }
            };
            PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Control"));
        }
    }

    public void setSourceObjs(Collection<? extends INamed> collection) {
        this.d_nameSrcs = collection;
        this.d_sinkType = ControlDesc.getSinkType(this.d_nameSrcs);
        this.updateNullDesc();
    }

    private void updateNullDesc() {
        this.NULL_ENTRY.setName(this.d_sinkType.strings.defaultDesc);
        this.d_cb.regen();
    }

    public void setNameSrc(JTextComponent jTextComponent, Collection<? extends INamed> collection) {
        this.setNameSrc(new TextFldNameSource(jTextComponent), collection);
    }

    public void setNameSrc(Function<Stream<? extends INamed>, Stream<String>> function, Collection<? extends INamed> collection) {
        this.d_nameSource = function;
        this.setSourceObjs(collection);
    }

    @Override
    public void add(GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(this.d_lbl, this.d_cb, this.d_descLbl, 1.0, 0);
    }

    public int add(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagUtil.add(container, this.d_lbl, n, n2, 1, 1, n3, n4, n5, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_cb, ++n, n2, 1, 1, n3, 0, n5, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_descLbl, ++n, n2, 5, 1, n3, 0, n5, n6, 2, 1.0, 0.0, 17);
        return ++n2;
    }

    public ControlComboBox getComboBox() {
        return this.d_cb;
    }

    public void setSelectedComboItem(Object object) {
        this.d_cb.setSelectedItem(object);
    }

    public void resetCombo() {
        this.d_cb.setSelectedItem(this.NULL_ENTRY);
    }

    private String convertFromHTML(String string) {
        string = string.replace("&lt;", "<");
        string = string.replace("&gt;", ">");
        string = string.replace("<br>", " ");
        string = string.replace("  ", " ");
        return string;
    }

    private void updateFromSelection() {
        ControlDesc controlDesc;
        String string = "";
        ControlBridge controlBridge = (ControlBridge)this.d_cb.getSelectedItem();
        if (controlBridge != null && controlBridge != this.NULL_ENTRY) {
            controlDesc = new ControlDesc(false, false);
            controlDesc.load(controlBridge.getInputPin());
            string = controlDesc.formatMessage(this.d_sinkType);
        }
        this.d_descLbl.setText("<html><a href=\"BLAH\">" + string + "</a></html>");
        controlDesc = string.trim().length() > 0 ? "<html>" + string + "</html>" : null;
        this.d_descLbl.setToolTipText((String)((Object)controlDesc));
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.d_descLbl.setEnabled(this.d_cb.isEnabled() && this.d_cb.getSelectedItem() != this.NULL_ENTRY && this.d_cb.getSelectedItem() != null);
    }

    public void setEnabled(boolean bl) {
        this.d_lbl.setEnabled(bl);
        this.d_cb.setEnabled(bl);
        if (!bl && this.d_cb.getSelectedItem() != null) {
            this.d_cb.setSelectedItem(this.NULL_ENTRY);
        }
        this.updateEnabled();
    }

    public boolean isEnabled() {
        return this.d_lbl.isEnabled() || this.d_cb.isEnabled() || this.d_descLbl.isEnabled();
    }

    public void selectAlwaysOn() {
        this.d_cb.setSelectedItem(this.NULL_ENTRY);
    }

    public boolean validateData(Component component, ISignalSink iSignalSink, boolean bl, boolean bl2) {
        ControlBridge controlBridge = (ControlBridge)this.d_cb.getSelectedItem();
        if (controlBridge == null) {
            return true;
        }
        if (Util.containsCycle(iSignalSink, controlBridge)) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(component, String.format(Intl.intl("The device cannot be controlled by the control %s because it creates a cyclic definition."), controlBridge.getName()));
            }
            return false;
        }
        return true;
    }

    public boolean save(Collection<OneLogicInPin> collection) {
        ControlBridge controlBridge = (ControlBridge)this.d_cb.getSelectedItem();
        if (controlBridge == null) {
            return false;
        }
        for (OneLogicInPin oneLogicInPin : collection) {
            oneLogicInPin.disconnectAll();
            if (controlBridge == this.NULL_ENTRY) continue;
            oneLogicInPin.connect(controlBridge.getOutputPins().get(0));
        }
        return true;
    }

    public void load(Collection<OneLogicInPin> collection) {
        if (collection.isEmpty()) {
            return;
        }
        Iterator<OneLogicInPin> iterator = collection.iterator();
        IInPin iInPin = iterator.next();
        while (iterator.hasNext()) {
            if (iterator.next().equals(iInPin)) continue;
            this.d_cb.setSelectedItem(null);
            return;
        }
        Set<ISignalSource> set = iInPin.getConnectedSources();
        if (!set.isEmpty()) {
            ISignalSource iSignalSource = set.iterator().next();
            assert (iSignalSource instanceof ControlBridge);
            this.d_cb.setSelectedItem((ControlBridge)iSignalSource);
        } else {
            this.d_cb.setSelectedItem(this.NULL_ENTRY);
        }
    }

    public void load(Property<ControlBridge> property) {
        if (!property.isUniform()) {
            this.d_cb.setSelectedItem(null);
        } else if (property.get() == null) {
            this.d_cb.setSelectedItem(this.NULL_ENTRY);
        } else {
            this.d_cb.setSelectedItem(property.get());
        }
    }

    public Property<ControlBridge> save() {
        ControlBridge controlBridge = (ControlBridge)this.d_cb.getSelectedItem();
        if (controlBridge == null) {
            return Property.nonUniform();
        }
        if (controlBridge == this.NULL_ENTRY) {
            return Property.of(null);
        }
        return Property.of(controlBridge);
    }

    public static <T extends ISignalSink> Composite.IObjectProp<T, ControlBridge> getControlProp(Class<T> clazz) {
        return new Composite.AObjectProp<T, ControlBridge>(clazz){

            @Override
            public Object get(T t) {
                Set<ISignalSource> set = t.getInputPin().getConnectedSources();
                return set.stream().filter(iSignalSource -> iSignalSource instanceof ControlBridge).findFirst().orElse(null);
            }

            @Override
            public void set(T t, ControlBridge controlBridge) {
                boolean bl = true;
                if (controlBridge == null) {
                    bl = !t.getInputPin().getConnections().isEmpty();
                }
                t.getInputPin().disconnectAll();
                if (controlBridge != null) {
                    t.getInputPin().connect(controlBridge.getOutputPins().get(0));
                }
                if (bl && t instanceof IPyroObject) {
                    t.changedEvt(new Object[0]);
                }
            }
        };
    }

    private static /* synthetic */ void lambda$getSinkNames$332(ArrayList arrayList, String string) {
        arrayList.add(string);
    }

    private class ControlComboBox
    extends PyroComboBox<ControlBridge> {
        private static final long serialVersionUID = 5043899586548986712L;

        public ControlComboBox(ControlMgr controlMgr) {
            super(controlMgr, ControlBridge.class);
            super.setSelectedItem(ControlSelPnl.this.NULL_ENTRY);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object == NEW_ENTRY) {
                this.newControl();
            } else if (object == null || ControlBridge.class.isInstance(object)) {
                super.setSelectedItem(object);
            }
        }

        private void newControl() {
            NewControlDlg newControlDlg = new NewControlDlg((ControlMgr)this.getManager());
            if (newControlDlg.doModal() == 1) {
                guiDialog guiDialog2 = new guiDialog((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("New Control"), 9);
                guiDialog2.setResizable(true);
                ControlPnl controlPnl = new ControlPnl();
                guiDialog2.getDialogPane().add((Component)controlPnl, "Center");
                ControlBridge controlBridge = new ControlBridge(newControlDlg.getName());
                Pair pair = ControlSelPnl.this.getSinkNames(controlBridge);
                controlPnl.init(controlBridge, (Collection)pair.v1, (ControlDesc.SinkType)((Object)pair.v2));
                if (guiDialog2.doModal() == 1) {
                    controlBridge = controlPnl.commit(controlBridge);
                    AddTask addTask = new AddTask(this.getManager(), new IPyroObject[]{controlBridge});
                    PyroSim.getApp().getMediator().getTaskManager().exec(addTask, Intl.intl("New Control"));
                    this.setSelectedItem(controlBridge);
                }
            }
        }

        @Override
        protected Collection<?> getObjList() {
            Collection<?> collection = this.getDefaultList();
            ArrayList<Object> arrayList = new ArrayList<Object>(collection.size() + 3);
            arrayList.add(NEW_ENTRY);
            arrayList.add(new JSeparator());
            arrayList.add(ControlSelPnl.this.NULL_ENTRY);
            arrayList.addAll(collection);
            return arrayList;
        }

        public void regen() {
            this.updateList();
        }
    }

    public static interface INameSource
    extends Function<Stream<? extends INamed>, Stream<String>> {
    }
}

