/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.gui.ResizableWindow;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.io.fds.DefaultFieldRenderer;
import pyrosim.io.fds.FDSGrammar;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordCollector;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.FDSWarningReport;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.FDS6Parser;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.io.StringPrintWriter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.Task;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class ControlPnl
extends guiPanel
implements IEditor<ControlBridge> {
    private static final long serialVersionUID = -6642987861153912507L;
    private static final int INDENT = 18;
    private final ActionPnl d_actionPnl;
    private final InputPnl d_inputTypePnl;
    private final StatementPnl d_statementPnl;
    private List<ISignalSink> d_originalSinks = Collections.EMPTY_LIST;
    private PopupWindow d_currentPopup = null;

    public ControlPnl() {
        this(true);
    }

    public ControlPnl(boolean bl) {
        super(new GridBagLayout());
        this.d_actionPnl = new ActionPnl();
        this.d_inputTypePnl = new InputPnl();
        this.d_statementPnl = new StatementPnl(this, bl);
        int n = 0;
        GridBagUtil.add(this, this.d_inputTypePnl, 0, ++n, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_actionPnl, 0, ++n, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_statementPnl, 0, ++n, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlPnl.this.updatePanels();
            }
        };
        this.d_actionPnl.addListener(actionListener);
        this.d_inputTypePnl.addListener(actionListener);
        this.d_actionPnl.d_createBtn.setSelected(true);
        this.d_inputTypePnl.d_timeBtn.setSelected(true);
        this.updatePanels();
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public ControlBridge preview(ControlBridge controlBridge) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.savePin(controlBridge);
        return controlBridge;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateAvailOptions();
    }

    private void updateAvailOptions() {
        boolean bl = this.d_statementPnl.isDataValid(-1, -1, 1);
        this.d_inputTypePnl.d_detectorBtn.setEnabled(this.isEnabled() && bl);
        if (this.isEnabled() && !bl) {
            this.d_inputTypePnl.d_detectorBtn.setToolTipText(Intl.intl("No detectors or triggering devices are currently in the model."));
        } else {
            this.d_inputTypePnl.d_detectorBtn.setToolTipText(null);
        }
        boolean bl2 = this.d_statementPnl.isDataValid(-1, -1, 2);
        this.d_inputTypePnl.d_thermostatBtn.setEnabled(this.isEnabled() && bl2);
        if (this.isEnabled() && !bl2) {
            this.d_inputTypePnl.d_thermostatBtn.setToolTipText(Intl.intl("No device input for a deadband is currently in model."));
        } else {
            this.d_inputTypePnl.d_thermostatBtn.setToolTipText(null);
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(ControlBridge controlBridge) {
        this.init(controlBridge, null, null);
    }

    public void init(ControlBridge controlBridge, Collection<String> collection, ControlDesc.SinkType sinkType) {
        this.setEnabled(controlBridge != null);
        if (controlBridge != null) {
            this.load(controlBridge, collection, sinkType);
        }
        this.setModified(false);
    }

    private void load(ControlBridge controlBridge, Collection<String> collection, ControlDesc.SinkType sinkType) {
        if (collection != null) {
            this.d_statementPnl.d_desc.setSinkNames(collection);
        } else if (controlBridge.getDomain() != null) {
            DepSnapshot depSnapshot = ((PyroMod)controlBridge.getDomain()).getDependencies(controlBridge);
            Set<Dependency> set = depSnapshot.getDependents(controlBridge);
            this.d_originalSinks = new ArrayList<ISignalSink>(set.size());
            for (Dependency dependency : set) {
                if (!(dependency.source instanceof IInPin)) continue;
                this.d_originalSinks.add(((IInPin)dependency.source).getAttachedSink());
            }
            sinkType = ControlDesc.getSinkType(this.d_originalSinks);
            this.d_statementPnl.d_desc.setSinks(this.d_originalSinks);
        }
        this.setSinkType(sinkType);
        this.d_statementPnl.load(controlBridge.getInputPin());
        this.d_actionPnl.setValue(((StatementPnl)this.d_statementPnl).d_desc.d_action);
        this.d_inputTypePnl.setValue(((StatementPnl)this.d_statementPnl).d_desc.d_input);
        this.updatePanels();
    }

    private void setSinkType(ControlDesc.SinkType sinkType) {
        this.d_statementPnl.setSinkType(sinkType);
        this.d_actionPnl.setSinkType(sinkType);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.d_currentPopup != null;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (this.d_currentPopup != null && !this.d_currentPopup.validateData(bl, bl2)) {
            return false;
        }
        int n = this.d_inputTypePnl.getValue();
        if (n == 1 || n == 2) {
            Object object;
            Collection<? extends ISignalSink> collection = Collections.unmodifiableCollection(((StatementPnl)this.d_statementPnl).d_desc.d_dstObjs);
            List<Object> list = null;
            if (n == 1) {
                list = ((StatementPnl)this.d_statementPnl).d_desc.d_srcDetectors.stream().map(iLogicOutPin -> iLogicOutPin.getAttachedSource()).filter(iSignalSource -> iSignalSource instanceof ISignalSink).map(iSignalSource -> (ISignalSink)((Object)iSignalSource)).collect(Collectors.toList());
            } else if (n == 2 && (object = ((StatementPnl)this.d_statementPnl).d_desc.d_srcMeasurer.getAttachedSource()) instanceof ISignalSink) {
                list = Arrays.asList((ISignalSink)object);
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            for (ISignalSink iSignalSink : collection) {
                for (ISignalSink iSignalSink2 : list) {
                    if (!Util.containsCycle(iSignalSink, iSignalSink2)) continue;
                    if (bl) {
                        guiDialog.showInvalidEntryMessage(this, Intl.intl("Controls cannot create cyclic definitions."));
                    }
                    return false;
                }
            }
        }
        return super.validateData(bl, bl2);
    }

    @Override
    public ControlBridge commit(final ControlBridge controlBridge) {
        Object object;
        AbstractCollection abstractCollection;
        if (this.d_currentPopup != null) {
            this.d_currentPopup.commit();
            this.d_currentPopup.setVisible(false);
        }
        boolean bl = false;
        LinkedIdentityHashSet<? extends ISignalSink> linkedIdentityHashSet = Collections.EMPTY_SET;
        if (((StatementPnl)this.d_statementPnl).d_desc.d_dstObjNames == null) {
            linkedIdentityHashSet = new LinkedIdentityHashSet<ISignalSink>(((StatementPnl)this.d_statementPnl).d_desc.d_dstObjs);
            abstractCollection = new ArrayList();
            for (ISignalSink iSignalSink : linkedIdentityHashSet) {
                ISignalSource iSignalSource;
                if (iSignalSink.getInputPin().getConnections().isEmpty() || (iSignalSource = iSignalSink.getInputPin().getConnectedSources().iterator().next()) == controlBridge) continue;
                abstractCollection.add(iSignalSink);
            }
            if (!abstractCollection.isEmpty()) {
                object = String.format(Intl.intl("WARNING: Some of the selected activation objects already have\ndifferent controls assigned to them. Would to like to assign\n\"%s\" to them instead?"), controlBridge.getName());
                int n = JOptionPane.showConfirmDialog(this, object, Intl.intl("Reassign Activation Logic"), 1);
                if (n != 0 && n != 1) {
                    return controlBridge;
                }
                if (n == 1) {
                    linkedIdentityHashSet.removeAll(abstractCollection);
                    bl = true;
                }
            }
        }
        abstractCollection = linkedIdentityHashSet;
        object = new AOneTimeTask((Set)((Object)abstractCollection)){
            final /* synthetic */ Set val$modObjs;
            {
                this.val$modObjs = set;
            }

            @Override
            public void run() {
                ControlPnl.this.savePin(controlBridge);
                if (((StatementPnl)((ControlPnl)ControlPnl.this).d_statementPnl).d_desc.d_dstObjNames == null) {
                    for (ISignalSink iSignalSink : ControlPnl.this.d_originalSinks) {
                        if (this.val$modObjs.contains(iSignalSink)) continue;
                        iSignalSink.getInputPin().disconnectAll();
                        iSignalSink.changedEvt(new Object[0]);
                    }
                    for (ISignalSink iSignalSink : this.val$modObjs) {
                        iSignalSink.getInputPin().disconnectAll();
                        iSignalSink.getInputPin().connect(controlBridge.getOutputPins().get(0));
                        iSignalSink.changedEvt(new Object[0]);
                    }
                }
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec((Task)object, Intl.intl("Edit Control"));
        this.setModified(false);
        if (bl) {
            this.init(controlBridge);
        }
        return controlBridge;
    }

    private void savePin(ControlBridge controlBridge) {
        IOutPin iOutPin = this.d_statementPnl.save();
        controlBridge.getInputPin().disconnectAll();
        if (iOutPin != null) {
            controlBridge.getInputPin().connect(iOutPin);
            if (iOutPin.getAttachedSource() instanceof IControl) {
                ((IControl)iOutPin.getAttachedSource()).setName(controlBridge.getName());
            }
        }
        controlBridge.changedEvt(new Object[0]);
    }

    private void updatePanels() {
        this.d_actionPnl.setInput(this.d_inputTypePnl.getValue());
        this.d_statementPnl.setData(this.d_actionPnl.getValue(), this.d_inputTypePnl.getValue());
    }

    private static class MultiSelectHelperWindow<T>
    extends PopupWindow {
        private static final long serialVersionUID = -8784523385840655311L;
        private TableModel<T> d_tableModel;
        private guiTable d_table;
        private JButton d_okBtn;
        private JButton d_clearBtn;
        private JButton d_selAllBtn;
        private Callback<T> d_callback;

        public MultiSelectHelperWindow() {
        }

        public MultiSelectHelperWindow(Frame frame) {
            super(frame);
        }

        public MultiSelectHelperWindow(Window window) {
            super(window);
        }

        public boolean isEmpty() {
            return this.d_tableModel.getRowCount() == 0;
        }

        public void initAllObjs(Collection<? extends T> collection) {
            this.d_tableModel = new TableModel<T>(collection);
            if (this.d_tableModel.getRowCount() > 0) {
                guiPanel guiPanel2;
                JComponent jComponent;
                this.d_table = new guiTable(this.d_tableModel, 0);
                guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 0);
                this.d_table.setTableHeader(null);
                this.d_table.setShowVerticalLines(false);
                this.d_table.setColumnSelectionAllowed(false);
                this.d_table.setSelectionMode(0);
                TableCellRenderer tableCellRenderer = this.d_table.getCellRenderer(0, 0);
                Component component = tableCellRenderer.getTableCellRendererComponent(this.d_table, Boolean.FALSE, false, false, 0, 0);
                int n = component.getPreferredSize().width + 20;
                this.d_table.getColumnModel().getColumn(0).setMaxWidth(n);
                this.d_table.getColumnModel().getColumn(0).setMinWidth(n);
                this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, 100));
                this.d_okBtn = new JButton(Intl.intl("OK"));
                this.d_clearBtn = new JButton(Intl.intl("Clear"));
                this.d_clearBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        d_tableModel.clearSel();
                    }
                });
                this.d_selAllBtn = new JButton(Intl.intl("Select All"));
                this.d_selAllBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        d_tableModel.selectAll();
                    }
                });
                this.d_clearBtn.setPreferredSize(new Dimension(this.d_clearBtn.getPreferredSize().width, this.d_clearBtn.getPreferredSize().height - 4));
                this.d_selAllBtn.setPreferredSize(new Dimension(this.d_selAllBtn.getPreferredSize().width, this.d_selAllBtn.getPreferredSize().height - 4));
                Comparator<Object> comparator = new Comparator<Object>(){

                    @Override
                    public int compare(Object object, Object object2) {
                        return ControlDesc.getName(object).compareToIgnoreCase(ControlDesc.getName(object2));
                    }
                };
                if (this.d_table.getRowCount() > 8) {
                    jComponent = new guiTextField();
                    jComponent.addKeyListener(new KeyAdapter((guiTextField)jComponent, comparator){
                        final /* synthetic */ guiTextField val$findFld;
                        final /* synthetic */ Comparator val$comparator;
                        {
                            this.val$findFld = guiTextField2;
                            this.val$comparator = comparator;
                        }

                        @Override
                        public void keyReleased(KeyEvent keyEvent) {
                            String string = this.val$findFld.getText();
                            if (keyEvent.getKeyCode() == 10) {
                                int n = d_table.getSelectedRow();
                                if (n >= 0) {
                                    boolean bl = (Boolean)d_table.getValueAt(n, 0);
                                    d_table.setValueAt(!bl, n, 0);
                                }
                                this.val$findFld.setSelectionStart(0);
                                this.val$findFld.setSelectionEnd(string.length());
                            } else {
                                int n = d_tableModel.d_objCache.findGeneric(string, this.val$comparator);
                                if (n < 0) {
                                    n = -n - 1;
                                }
                                if (n >= d_table.getRowCount()) {
                                    n = d_table.getRowCount() - 1;
                                }
                                d_table.setRowSelectionInterval(n, n);
                                Rectangle rectangle = d_table.getCellRect(n, -1, true);
                                rectangle.height = ((MultiSelectHelperWindow)this).d_table.getVisibleRect().height;
                                d_table.scrollRectToVisible(rectangle);
                            }
                        }
                    });
                    guiPanel2 = new guiPanel(new BorderLayout());
                    guiPanel2.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
                    guiPanel2.add(jComponent);
                    this.add((Component)guiPanel2, "North");
                }
                jComponent = new guiLabel("");
                this.d_tableModel.addTableModelListener(new TableModelListener((guiLabel)jComponent){
                    final /* synthetic */ guiLabel val$numSelLbl;
                    {
                        this.val$numSelLbl = guiLabel2;
                    }

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        this.updateSelLabel(this.val$numSelLbl);
                    }
                });
                this.updateSelLabel((guiLabel)jComponent);
                guiPanel2 = new guiPanel(new GridBagLayout());
                int n2 = 0;
                GridBagUtil.add(guiPanel2, this.d_clearBtn, 0, ++n2, 1, 1, 6, 0, 3, 6, 0, 0.0, 0.0, 17);
                GridBagUtil.add(guiPanel2, this.d_selAllBtn, 1, n2, 1, 1, 6, 0, 3, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(guiPanel2, jComponent, 0, ++n2, 2, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(guiPanel2, this.d_okBtn, 0, ++n2, 2, 1, 0, 0, 0, 0, 0, 1.0, 0.0, 13);
                this.add((Component)guiTableEditor2, "Center");
                this.add((Component)guiPanel2, "South");
            } else {
                this.add((Component)new guiLabel(Intl.intl("There are currently no objects in the model.")), "Center");
            }
            this.pack();
        }

        private void updateSelLabel(guiLabel guiLabel2) {
            String string = "";
            int n = 0;
            for (Integer n2 : ((TableModel)this.d_tableModel).d_selObjs) {
                if (n2 < 0) continue;
                Object t = ((TableModel)this.d_tableModel).d_objCache.get(n2);
                if (n++ != 0) {
                    string = string + ", ";
                }
                string = string + ControlDesc.getName(t);
                if (n != 10) continue;
                break;
            }
            if (n < ((TableModel)this.d_tableModel).d_selObjs.size()) {
                string = string + ", ...";
            }
            guiLabel2.setText(String.format(Intl.intl("Number selected: %d"), ((TableModel)this.d_tableModel).d_selObjs.size()));
            guiLabel2.setToolTipText(string);
        }

        public void init(Point point, Collection<? extends T> collection, final Callback<T> callback) {
            this.d_callback = callback;
            this.d_tableModel.load(collection);
            for (ActionListener actionListener : this.d_okBtn.getActionListeners()) {
                this.d_okBtn.removeActionListener(actionListener);
            }
            this.d_okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    callback.select(d_tableModel.save());
                    this.setVisible(false);
                }
            });
            this.setLocation(point);
            this.setVisible(true);
        }

        @Override
        public void commit() {
            this.d_callback.select(this.d_tableModel.save());
        }

        private static class TableModel<T>
        extends AbstractTableModel {
            private static final long serialVersionUID = 8101300018625206497L;
            private static final int COL_ENABLED = 0;
            private static final int COL_DETECTOR = 1;
            private static final int NUM_COLS = 2;
            private final SortCache<T> d_objCache;
            private final Set<Integer> d_selObjs;

            public TableModel(Collection<? extends T> collection) {
                this.d_objCache = new SortCache<T>(collection);
                this.d_selObjs = new TreeSet<Integer>();
            }

            public void selectAll() {
                for (int i = 0; i < this.d_objCache.size(); ++i) {
                    this.d_selObjs.add(i);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void clearSel() {
                this.d_selObjs.clear();
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void load(Collection<? extends T> collection) {
                this.d_selObjs.clear();
                for (T t : collection) {
                    int n = this.d_objCache.indexOf(t);
                    this.d_selObjs.add(n);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public List<T> save() {
                ArrayList<T> arrayList = new ArrayList<T>(this.d_selObjs.size());
                for (Integer n : this.d_selObjs) {
                    if (n == -1) continue;
                    arrayList.add(this.d_objCache.get(n));
                }
                return arrayList;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return this.d_objCache.size();
            }

            @Override
            public String getColumnName(int n) {
                return "";
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return this.d_selObjs.contains(n) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 1: {
                        return ControlDesc.getName(this.d_objCache.get(n));
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (object == null) {
                    return;
                }
                switch (n2) {
                    case 0: {
                        if (((Boolean)object).booleanValue()) {
                            this.d_selObjs.add(n);
                            break;
                        }
                        this.d_selObjs.remove(n);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, n));
            }
        }

        private static interface Callback<T> {
            public void select(List<T> var1);
        }
    }

    private static class ListHelperWindow
    extends PopupWindow {
        private static final long serialVersionUID = 4745659433631625480L;
        private Callback d_callback;
        private JList optionsList;
        private int[] itemVals;
        private int initialSel;

        public ListHelperWindow() {
        }

        public ListHelperWindow(Frame frame) {
            super(frame);
        }

        public ListHelperWindow(Window window) {
            super(window);
        }

        public void init(Point point, boolean bl, int n, int[] nArray, final String[] stringArray, Callback callback) {
            assert (nArray.length == stringArray.length);
            this.d_callback = callback;
            this.itemVals = nArray;
            this.initialSel = n;
            this.optionsList = new JList<String>(stringArray);
            JScrollPane jScrollPane = new JScrollPane(this.optionsList);
            this.optionsList.setSelectionMode(0);
            int n2 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                n2 = i;
                break;
            }
            this.optionsList.setSelectedIndex(n2);
            this.optionsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.commitSelection();
                    }
                }
            });
            this.optionsList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                        this.commitSelection();
                    }
                }
            });
            this.getContentPane().add((Component)jScrollPane, "Center");
            if (bl && nArray.length > 8) {
                final Comparator<String> comparator = new Comparator<String>(){

                    @Override
                    public int compare(String string, String string2) {
                        return string.compareToIgnoreCase(string2);
                    }
                };
                final guiTextField guiTextField2 = new guiTextField();
                guiTextField2.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            this.commitSelection();
                        } else {
                            String string = guiTextField2.getText();
                            int n = Arrays.binarySearch(stringArray, string, comparator);
                            if (n < 0) {
                                n = -n - 1;
                            }
                            if (n >= stringArray.length) {
                                n = stringArray.length - 1;
                            }
                            optionsList.setSelectedIndex(n);
                            Rectangle rectangle = optionsList.getCellBounds(n, n);
                            rectangle.height = ((ListHelperWindow)this).optionsList.getVisibleRect().height;
                            optionsList.scrollRectToVisible(rectangle);
                        }
                    }
                });
                guiPanel guiPanel2 = new guiPanel(new BorderLayout());
                guiPanel2.add(guiTextField2);
                guiPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
                this.add((Component)guiPanel2, "North");
            }
            this.requestFocus();
            this.pack();
            this.setLocation(point);
            this.setVisible(true);
        }

        private void commitSelection() {
            this.commit();
            this.setVisible(false);
        }

        @Override
        public void commit() {
            int n = this.optionsList.getSelectedIndex();
            int n2 = n >= 0 ? this.itemVals[n] : this.initialSel;
            this.d_callback.select(n2);
        }

        public static interface Callback {
            public void select(int var1);
        }
    }

    private static class ValueFieldHelperWindow<T>
    extends PopupWindow {
        private static final long serialVersionUID = -1443765057610622078L;
        private ValueField<T> d_fld;
        private Callback<T> d_callback;

        public ValueFieldHelperWindow() {
        }

        public ValueFieldHelperWindow(Frame frame) {
            super(frame);
        }

        public ValueFieldHelperWindow(Window window) {
            super(window);
        }

        @Override
        public void commit() {
            this.d_callback.select(this.d_fld.getValue());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return this.d_fld.validateData(bl, bl2);
        }

        public void init(Point point, ValueField<T> valueField, Callback<T> callback) {
            this.d_fld = valueField;
            this.d_callback = callback;
            valueField.setColumns(12);
            Consumer<EventObject> consumer = eventObject -> {
                callback.select(valueField.getValue());
                this.setVisible(false);
            };
            Consumer<EventObject> consumer2 = eventObject -> this.setVisible(false);
            valueField.addValueListener(ValueField.VAL_COMMIT, propertyChangeEvent -> consumer.accept(propertyChangeEvent));
            valueField.setDefaultCommand(consumer);
            valueField.addValueListener(ValueField.VAL_CANCEL, propertyChangeEvent -> consumer2.accept(propertyChangeEvent));
            this.getContentPane().add(valueField, "Center");
            this.pack();
            this.setLocation(point);
            this.setVisible(true);
        }

        public static interface Callback<T> {
            public void select(T var1);
        }
    }

    private static abstract class PopupWindow
    extends ResizableWindow
    implements Validateable {
        private static final long serialVersionUID = 8961210174042159198L;
        private MouseAdapter d_parentMouseListener;

        public PopupWindow() {
            this.init();
        }

        public PopupWindow(Frame frame) {
            super((Window)frame);
            this.init();
        }

        public PopupWindow(Window window) {
            super(window);
            this.init();
        }

        protected ControlPnl findPanel() {
            Container container = this.getParent();
            return container != null ? this.findPanel(container) : null;
        }

        private ControlPnl findPanel(Container container) {
            for (Component component : container.getComponents()) {
                ControlPnl controlPnl;
                if (component instanceof ControlPnl) {
                    return (ControlPnl)component;
                }
                if (!(component instanceof Container) || (controlPnl = this.findPanel((Container)component)) == null) continue;
                return controlPnl;
            }
            return null;
        }

        public abstract void commit();

        public boolean validateData() {
            return this.validateData(true, true);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return true;
        }

        private List<Component> getParentComponents() {
            Container container = this.getParent();
            if (container != null) {
                ArrayList<Component> arrayList = new ArrayList<Component>();
                arrayList.add(container);
                this.getComponents(container, arrayList);
                return arrayList;
            }
            return Collections.EMPTY_LIST;
        }

        private void getComponents(Container container, List<Component> list) {
            for (Component component : container.getComponents()) {
                list.add(component);
                if (!(component instanceof Container)) continue;
                this.getComponents((Container)component, list);
            }
        }

        private void init() {
            this.d_parentMouseListener = new ParentMouseListener();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.setVisible(false);
                }
            };
            this.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        }

        @Override
        public void setVisible(boolean bl) {
            ControlPnl controlPnl = this.findPanel();
            if (bl) {
                for (Component component : this.getParentComponents()) {
                    component.addMouseListener(this.d_parentMouseListener);
                }
                if (controlPnl != null) {
                    controlPnl.d_currentPopup = this;
                }
            }
            super.setVisible(bl);
            if (!bl) {
                if (controlPnl != null) {
                    controlPnl.d_currentPopup = null;
                }
                for (Component component : this.getParentComponents()) {
                    component.removeMouseListener(this.d_parentMouseListener);
                }
                this.dispose();
            }
        }

        private class ParentMouseListener
        extends MouseAdapter {
            private ParentMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof guiDialog.OkBtn || mouseEvent.getComponent() instanceof guiDialog.ApplyBtn) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PopupWindow.this.setVisible(false);
                    }
                });
            }
        }
    }

    private static class StatementPnl
    extends guiPanel {
        private static final long serialVersionUID = -7029267888767815815L;
        private static final String CUSTOM_CARD = Intl.intl("Custom");
        private static final String TIME_CARD = Intl.intl("Time");
        private final ControlPnl d_ctrlPnl;
        private boolean d_modified = false;
        private final JEditorPane d_editor;
        private final JTextArea d_customEditor;
        private final DocumentListener d_customListener;
        private final JScrollPane d_customSP;
        private final TimeActivationPanel d_timePnl;
        private final guiPanel d_customPnl;
        private final guiCheckBox d_linkWithModelCB;
        private final ControlDesc d_desc;
        private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;
        private Set<ISignalSink> d_sinks = null;
        private Set<ILogicOutPin> d_logicPins = null;
        private SortCache<IDoubleOutPin> d_msrPins = null;
        private List<String> d_customCtrlNames = null;

        public StatementPnl(ControlPnl controlPnl, boolean bl) {
            super(new GridBagLayout());
            this.d_ctrlPnl = controlPnl;
            this.d_desc = new ControlDesc(true, bl);
            this.d_editor = new JEditorPane("text/html", "");
            this.d_editor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    this.hyperlinkSelected(hyperlinkEvent);
                }
            });
            this.d_editor.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.d_editor);
            this.d_linkWithModelCB = new guiCheckBox("<html>" + Intl.intl("Synchronize entered controls with model<br>(PyroSim may slightly alter the controls).") + "</html>");
            this.d_customPnl = new guiPanel(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Enter FDS CTRL Records:"));
            this.d_customEditor = new JTextArea();
            this.d_customEditor.setEditable(true);
            this.d_customEditor.setFont(this.d_editor.getFont());
            this.d_customSP = new JScrollPane(this.d_customEditor);
            GridBagUtil.add(this.d_customPnl, this.d_linkWithModelCB, 0, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_customPnl, guiLabel2, 0, 1, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_customPnl, this.d_customSP, 0, 2, 1, 1, 6, 0, 6, 0, 1, 1.0, 1.0, 10);
            this.d_timePnl = new TimeActivationPanel();
            GridBagUtil.add(this, this.d_customPnl, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.75, 10);
            GridBagUtil.add(this, jScrollPane, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.25, 10);
            GridBagUtil.add(this, this.d_timePnl, 0, 2, 1, 1, 6, 0, 0, 0, 1, 1.0, 0.75, 10);
            jScrollPane.setPreferredSize(new Dimension(300, 150));
            this.d_customSP.setPreferredSize(new Dimension(200, 150));
            this.d_timePnl.setPreferredSize(new Dimension(200, 150));
            this.d_customListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                private void changed() {
                    int n;
                    d_customCtrlNames = null;
                    List list = this.getCustomCtrlNames();
                    if (((StatementPnl)this).d_desc.d_customCtrlName != null && (n = theUtil.binarySearch(list, ((StatementPnl)this).d_desc.d_customCtrlName, StatementPnl.newNameComparator())) < 0) {
                        d_desc.setCustomCtrlName(null);
                        this.changed();
                    }
                    if (((StatementPnl)this).d_desc.d_customCtrlName == null && list.size() > 0) {
                        d_desc.setCustomCtrlName((String)list.iterator().next());
                        this.changed();
                    }
                    this.changed();
                }
            };
            this.d_customEditor.getDocument().addDocumentListener(this.d_customListener);
        }

        private static Comparator<String> newNameComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            };
        }

        private static boolean isValidCustomRec(FDSRecord fDSRecord) {
            return fDSRecord.getType().equals("CTRL") || fDSRecord.getType().equals("RAMP") || fDSRecord.getType().equals("TABL") || fDSRecord.getType().equals("DEVC") && "TIME".equals(fDSRecord.getString("QUANTITY"));
        }

        private void showSimplifiedWarnings(FDSWarningReport fDSWarningReport) {
            WarningReport<FDSParseWarning> warningReport = new WarningReport<FDSParseWarning>(FDSParseWarning.class, new int[]{2, 0}, new String[]{Intl.intl("Line"), Intl.intl("Warning")}, 2);
            for (FDSParseWarning fDSParseWarning : fDSWarningReport.getWarnings()) {
                warningReport.addWarning(fDSParseWarning);
            }
            WarningDlg warningDlg = WarningDlg.create(this, Intl.intl("FDS Warnings"), Intl.intl("The following table lists some problems reading the FDS controls."), warningReport);
            warningDlg.doModal();
        }

        private IOutPin parseCustomControl(boolean bl) {
            if (this.d_desc.d_input != 3) {
                return null;
            }
            if (this.d_desc.d_customCtrlName == null) {
                if (bl) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one CTRL record with a valid ID must be specified."), Intl.intl("No CTRL Found"), 0);
                }
                return null;
            }
            if (!this.d_linkWithModelCB.isSelected()) {
                ManualCtrl manualCtrl = new ManualCtrl(this.d_customEditor.getText(), this.d_desc.d_customCtrlName);
                return manualCtrl.getOutputPins().get(0);
            }
            FDSWarningReport fDSWarningReport = new FDSWarningReport();
            try {
                Cloneable cloneable2;
                List<FDSParseRecord> list = this.getCustomRecords(fDSWarningReport);
                if (bl && !fDSWarningReport.isEmpty()) {
                    this.showSimplifiedWarnings(fDSWarningReport);
                }
                for (Cloneable cloneable2 : list) {
                    if (StatementPnl.isValidCustomRec(cloneable2)) continue;
                    if (bl) {
                        JOptionPane.showMessageDialog(this, Intl.intl("Only enter records of type CTRL and RAMP.  You may additionally specify\nDEVC records if the QUANTITY is \"TIME\"."), Intl.intl("Invalid Custom Records"), 0);
                    }
                    return null;
                }
                FDS6Parser fDS6Parser = new FDS6Parser();
                cloneable2 = new PyroMod();
                FDSParseResult fDSParseResult = fDS6Parser.parseRecords(list, (PyroMod)cloneable2, PyroSim.getApp().getMediator());
                if (bl && !fDSParseResult.warningReport.isEmpty()) {
                    this.showSimplifiedWarnings(fDSParseResult.warningReport);
                }
                ControlBridge controlBridge = null;
                for (ControlBridge controlBridge2 : theUtil.filter(fDSParseResult.extractedObjs, ControlBridge.class)) {
                    if (!controlBridge2.getName().equals(this.d_desc.d_customCtrlName)) continue;
                    controlBridge = controlBridge2;
                    break;
                }
                if (controlBridge == null || controlBridge.getInputPin().getConnections().isEmpty()) {
                    if (bl) {
                        JOptionPane.showMessageDialog(this, String.format(Intl.intl("The specified CTRL, \"%s\", is invalid."), this.d_desc.d_customCtrlName), Intl.intl("Specified CTRL Invalid"), 0);
                    }
                    return null;
                }
                return controlBridge.getInputPin().getConnections().iterator().next();
            }
            catch (Exception exception) {
                if (bl) {
                    JOptionPane.showMessageDialog(this, exception.getMessage(), Intl.intl("FDS Format Error"), 0);
                }
                return null;
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.d_desc.validateData(this, this.d_sinkType, bl, bl2)) {
                return false;
            }
            if (this.d_desc.d_input == 3) {
                IOutPin iOutPin = this.parseCustomControl(bl);
                return iOutPin != null;
            }
            return true;
        }

        private void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_sinkType = sinkType;
            this.d_timePnl.setSinkType(sinkType);
        }

        public void load(IInPin iInPin) {
            Object object;
            Object object2;
            ISignalSource iSignalSource;
            this.d_desc.load(iInPin);
            if (this.d_desc.d_action == 2 && this.d_desc.d_input == 0) {
                assert (iInPin.getConnections().size() == 1);
                iSignalSource = iInPin.getConnectedSources().iterator().next();
                assert (iSignalSource instanceof CustomCtrl);
                object2 = (CustomCtrl)iSignalSource;
                assert (((CustomCtrl)object2).getInputPin().getConnections().size() == 1);
                object = ((CustomCtrl)object2).getInputPin().getConnectedSources().iterator().next();
                assert (object instanceof Clock);
                this.d_timePnl.load((CustomCtrl)object2, false, new UnitDouble(0.0, SI.SECOND));
            }
            if (iInPin.getConnections().size() == 1) {
                iSignalSource = iInPin.getConnectedSources().iterator().next();
                if (iSignalSource instanceof ManualCtrl) {
                    this.d_linkWithModelCB.setSelected(false);
                    object2 = (ManualCtrl)iSignalSource;
                    this.d_desc.setCustomCtrlName(((AControl)object2).getName());
                    this.d_customEditor.getDocument().removeDocumentListener(this.d_customListener);
                    this.d_customEditor.setText(((ManualCtrl)object2).getFDSText());
                    this.d_customEditor.getDocument().addDocumentListener(this.d_customListener);
                } else {
                    FDSRenderRecord fDSRenderRecord2;
                    this.d_linkWithModelCB.setSelected(true);
                    object2 = new FDS6Renderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps());
                    object = new FDSRecordCollector(((FDSRenderer)object2).getProps());
                    ((FDSRenderer)object2).renderObjects((IFDSRecordRenderer)object, Arrays.asList(iInPin.getAttachedSink()), Collections.EMPTY_MAP);
                    StringPrintWriter stringPrintWriter = new StringPrintWriter();
                    for (FDSRenderRecord fDSRenderRecord2 : ((FDSRecordCollector)object).getRecords()) {
                        if (!StatementPnl.isValidCustomRec(fDSRenderRecord2)) continue;
                        fDSRenderRecord2.renderRecord(stringPrintWriter, ((FDSRenderer)object2).getProps(), DefaultFieldRenderer.INSTANCE);
                    }
                    String string = stringPrintWriter.toString();
                    this.d_customEditor.setText(string);
                    fDSRenderRecord2 = iSignalSource instanceof INamed ? ((INamed)((Object)iSignalSource)).getName() : null;
                    this.d_desc.setCustomCtrlName((String)((Object)fDSRenderRecord2));
                }
            } else {
                this.d_linkWithModelCB.setSelected(false);
                this.d_customEditor.setText("");
                this.d_desc.setCustomCtrlName(null);
            }
        }

        public IOutPin save() {
            IOutPin iOutPin = this.d_desc.save();
            if (iOutPin != null) {
                return iOutPin;
            }
            if (this.d_desc.d_input == 0 && this.d_desc.d_action == 2) {
                return this.d_timePnl.save();
            }
            if (this.d_desc.d_input == 3) {
                return this.parseCustomControl(false);
            }
            return null;
        }

        public boolean isDataValid(int n, int n2, int n3) {
            if (n3 == 1) {
                return !this.getLogicPins().isEmpty();
            }
            if (n3 == 2) {
                return this.getMsrPins().size() > 0;
            }
            return true;
        }

        private void changed() {
            this.updateMessage();
            this.setModified(true);
        }

        private void setData(int n, int n2) {
            this.d_desc.setData(n, n2);
            this.d_customPnl.setVisible(n2 == 3);
            this.d_timePnl.setVisible(n2 == 0 && n == 2);
            this.changed();
            this.updateMessage();
        }

        @Override
        public boolean isModified() {
            return super.isModified() || this.d_modified;
        }

        @Override
        public void setModified(boolean bl) {
            this.d_modified = bl;
            super.setModified(bl);
        }

        private void updateMessage() {
            String string = this.d_desc.formatMessage(this.d_sinkType);
            this.d_editor.setText(string);
            this.d_editor.setEnabled(this.d_desc.d_input != 3 || !this.getCustomCtrlNames().isEmpty());
        }

        private void hyperlinkSelected(HyperlinkEvent hyperlinkEvent) {
            if (!this.isEnabled()) {
                return;
            }
            String string = hyperlinkEvent.getDescription();
            Rectangle rectangle = null;
            if (hyperlinkEvent.getSourceElement() == null) {
                return;
            }
            try {
                rectangle = this.d_editor.modelToView(hyperlinkEvent.getSourceElement().getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (rectangle == null) {
                return;
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Point point = new Point(this.d_editor.getLocationOnScreen());
                point.x += rectangle.x;
                point.y += rectangle.y + rectangle.height;
                if (string.equals("LOGIC")) {
                    this.selectLogic(point);
                } else if (string.equals("ACTIVATE")) {
                    this.selectActivate(point);
                } else if (string.equals("N")) {
                    this.selectN(point);
                } else if (string.equals("T")) {
                    this.selectT(point);
                } else if (string.equals("DBLOWERV")) {
                    this.selectDBBound(point, true);
                } else if (string.equals("DBUPPERV")) {
                    this.selectDBBound(point, false);
                } else if (string.equals("DBLOWERL")) {
                    this.selectDBLogic(point, true);
                } else if (string.equals("DBUPPERL")) {
                    this.selectDBLogic(point, false);
                } else if (string.equals("DETSOURCES")) {
                    this.selectDetectorSources(point);
                } else if (string.equals("MSRSOURCES")) {
                    this.selectMeasurerSource(point);
                } else if (string.equals("SINKS")) {
                    this.selectSinks(point);
                } else if (string.equals("DELAY")) {
                    this.selectDelay(point);
                } else if (string.equals("CUSTOMINPUT")) {
                    this.selectCustomInput(point);
                }
            }
        }

        private Set<ISignalSink> getSinks() {
            if (this.d_sinks != null) {
                return this.d_sinks;
            }
            this.beginWaitCursor();
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.d_sinks = new TreeSet<ISignalSink>(new Comparator<ISignalSink>(){

                @Override
                public int compare(ISignalSink iSignalSink, ISignalSink iSignalSink2) {
                    int n = ControlDesc.getName(iSignalSink).compareToIgnoreCase(ControlDesc.getName(iSignalSink2));
                    if (n != 0) {
                        return n;
                    }
                    return Integer.compare(System.identityHashCode(iSignalSink), System.identityHashCode(iSignalSink2));
                }
            });
            for (ISignalSink iSignalSink : Hierarchy.flatten(pyroMod.getMembers(), ISignalSink.class)) {
                if (iSignalSink instanceof IControl || iSignalSink instanceof IHvacObject || !(iSignalSink.getInputPin() instanceof ILogicInPin)) continue;
                this.d_sinks.add(iSignalSink);
            }
            this.endWaitCursor();
            return this.d_sinks;
        }

        private void selectSinks(Point point) {
            if (this.d_desc.d_dstObjNames != null) {
                return;
            }
            Set<ISignalSink> set = this.getSinks();
            if (set.isEmpty()) {
                return;
            }
            MultiSelectHelperWindow multiSelectHelperWindow = this.createHelperWindow(MultiSelectHelperWindow.class);
            multiSelectHelperWindow.initAllObjs(set);
            multiSelectHelperWindow.init(point, this.d_desc.d_dstObjs, new MultiSelectHelperWindow.Callback<ISignalSink>(){

                @Override
                public void select(List<ISignalSink> list) {
                    ControlDesc.SinkType sinkType = ControlDesc.getSinkType(list);
                    d_desc.setSinks(list);
                    d_ctrlPnl.setSinkType(sinkType);
                    this.changed();
                }
            });
        }

        private Set<ILogicOutPin> getLogicPins() {
            if (this.d_logicPins != null) {
                return this.d_logicPins;
            }
            this.beginWaitCursor();
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.d_logicPins = new TreeSet<ILogicOutPin>(new Comparator<ILogicOutPin>(){

                @Override
                public int compare(ILogicOutPin iLogicOutPin, ILogicOutPin iLogicOutPin2) {
                    return ControlDesc.getName(iLogicOutPin).compareToIgnoreCase(ControlDesc.getName(iLogicOutPin2));
                }
            });
            for (IDevice iDevice : pyroMod.getDevices().flatten()) {
                if (!(iDevice instanceof ISignalSource)) continue;
                for (IOutPin iOutPin : ((ISignalSource)((Object)iDevice)).getOutputPins()) {
                    if (!(iOutPin instanceof ILogicOutPin)) continue;
                    this.d_logicPins.add((ILogicOutPin)iOutPin);
                }
            }
            this.endWaitCursor();
            return this.d_logicPins;
        }

        private void selectDetectorSources(Point point) {
            Set<ILogicOutPin> set = this.getLogicPins();
            if (set.isEmpty()) {
                return;
            }
            MultiSelectHelperWindow multiSelectHelperWindow = this.createHelperWindow(MultiSelectHelperWindow.class);
            multiSelectHelperWindow.initAllObjs(set);
            multiSelectHelperWindow.init(point, this.d_desc.d_srcDetectors, new MultiSelectHelperWindow.Callback<ILogicOutPin>(){

                @Override
                public void select(List<ILogicOutPin> list) {
                    d_desc.setSources(list);
                    this.changed();
                }
            });
        }

        private SortCache<IDoubleOutPin> getMsrPins() {
            if (this.d_msrPins != null) {
                return this.d_msrPins;
            }
            this.beginWaitCursor();
            ArrayList<IDoubleOutPin> arrayList = new ArrayList<IDoubleOutPin>();
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            for (IDevice iDevice : pyroMod.getDevices().flatten()) {
                if (!(iDevice instanceof ISignalSource)) continue;
                for (IOutPin iOutPin : ((ISignalSource)((Object)iDevice)).getOutputPins()) {
                    if (!(iOutPin instanceof IDoubleOutPin)) continue;
                    arrayList.add((IDoubleOutPin)iOutPin);
                }
            }
            this.d_msrPins = new SortCache<IDoubleOutPin>(arrayList, new Comparator<IDoubleOutPin>(){

                @Override
                public int compare(IDoubleOutPin iDoubleOutPin, IDoubleOutPin iDoubleOutPin2) {
                    return ControlDesc.getName(iDoubleOutPin).compareToIgnoreCase(ControlDesc.getName(iDoubleOutPin2));
                }
            });
            this.endWaitCursor();
            return this.d_msrPins;
        }

        private void selectMeasurerSource(Point point) {
            int n;
            final SortCache<IDoubleOutPin> sortCache = this.getMsrPins();
            if (sortCache.size() == 0) {
                return;
            }
            ListHelperWindow listHelperWindow = this.newListHelperWindow();
            int[] nArray = new int[sortCache.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            String[] stringArray = new String[sortCache.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = ControlDesc.getName(sortCache.get(n));
            }
            n = this.d_desc.d_srcMeasurer == null ? -1 : sortCache.indexOf(this.d_desc.d_srcMeasurer);
            listHelperWindow.init(point, true, n, nArray, stringArray, new ListHelperWindow.Callback(){

                @Override
                public void select(int n) {
                    IDoubleOutPin iDoubleOutPin = n >= 0 ? (IDoubleOutPin)sortCache.get(n) : null;
                    d_desc.setSourceMeasurer(iDoubleOutPin);
                    this.changed();
                }
            });
        }

        private List<FDSParseRecord> getCustomRecords(FDSWarningReport fDSWarningReport) throws FDSParseException {
            return FDSGrammar.parse(this.d_customEditor.getText(), null, fDSWarningReport, FDS6Const.getRecordSpecs(), "TAIL");
        }

        private List<String> getCustomCtrlNames() {
            if (this.d_customCtrlNames != null) {
                return this.d_customCtrlNames;
            }
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            });
            try {
                FDSWarningReport fDSWarningReport = new FDSWarningReport();
                ArrayList<String> arrayList = new ArrayList<String>();
                HashSet hashSet = new HashSet();
                List<FDSParseRecord> list = this.getCustomRecords(fDSWarningReport);
                for (FDSParseRecord object : list) {
                    String string;
                    if (object.getType().equals("CTRL")) {
                        List list2;
                        string = object.getString("ID");
                        if (string != null) {
                            arrayList.add(string);
                        }
                        if ((list2 = object.getList("INPUT_ID", true)) == null) continue;
                        hashSet.addAll(list2);
                        continue;
                    }
                    if (!object.getType().equals("DEVC") || !"TIME".equals(object.getString("QUANTITY")) || (string = object.getString("ID")) == null) continue;
                    arrayList.add(string);
                }
                for (String string : arrayList) {
                    if (hashSet.contains(string)) continue;
                    treeSet.add(string);
                }
            }
            catch (Exception exception) {
                return Collections.EMPTY_LIST;
            }
            this.d_customCtrlNames = new ArrayList<String>(treeSet);
            return this.d_customCtrlNames;
        }

        private void selectCustomInput(Point point) {
            List<String> list = this.getCustomCtrlNames();
            final String[] stringArray = list.toArray(new String[list.size()]);
            int[] nArray = new int[list.size()];
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = i;
                if (!stringArray[i].equals(this.d_desc.d_customCtrlName)) continue;
                n = i;
            }
            ListHelperWindow listHelperWindow = this.newListHelperWindow();
            listHelperWindow.init(point, true, n, nArray, stringArray, new ListHelperWindow.Callback(){

                @Override
                public void select(int n) {
                    if (n == -1) {
                        d_desc.setCustomCtrlName(null);
                    } else {
                        d_desc.setCustomCtrlName(stringArray[n]);
                    }
                    this.changed();
                }
            });
        }

        private void selectDelay(Point point) {
            ValueFieldHelperWindow<UnitDouble> valueFieldHelperWindow = this.newVFHelperWindow();
            ValueField<UnitDouble> valueField = ValueFields.udFld(this.d_desc.d_delay, UnitDoubleVR.above(0.0, SI.SECOND, true), UnitSystem.getSource(2));
            valueFieldHelperWindow.init(point, valueField, new ValueFieldHelperWindow.Callback<UnitDouble>(){

                @Override
                public void select(UnitDouble unitDouble) {
                    d_desc.setDelay(unitDouble);
                    this.changed();
                }
            });
        }

        private void selectDBLogic(Point point, final boolean bl) {
            ListHelperWindow listHelperWindow = this.newListHelperWindow();
            String[] stringArray = new String[]{this.d_sinkType.strings.on, this.d_sinkType.strings.off};
            int[] nArray = new int[]{1, 0};
            boolean bl2 = bl ? !this.d_desc.d_dbUpper : this.d_desc.d_dbUpper;
            int n = bl2 ? 1 : 0;
            listHelperWindow.init(point, false, n, nArray, stringArray, new ListHelperWindow.Callback(){

                @Override
                public void select(int n) {
                    boolean bl2 = n == 1;
                    d_desc.setDBLogic(bl2, bl);
                    this.changed();
                }
            });
        }

        private void selectDBBound(Point point, final boolean bl) {
            ValueFieldHelperWindow<UnitDouble> valueFieldHelperWindow = this.newVFHelperWindow();
            UnitDouble unitDouble = bl ? this.d_desc.d_dbRange[0] : this.d_desc.d_dbRange[1];
            ValueField<UnitDouble> valueField = ValueFields.udFld(unitDouble, UnitSystem.getSource(this.d_desc.d_dbRangeType));
            valueFieldHelperWindow.init(point, valueField, new ValueFieldHelperWindow.Callback<UnitDouble>(){

                @Override
                public void select(UnitDouble unitDouble) {
                    d_desc.setDBBound(unitDouble, bl);
                    this.changed();
                }
            });
        }

        private void selectLogic(Point point) {
            ListHelperWindow listHelperWindow = this.newListHelperWindow();
            String[] stringArray = new String[]{Intl.intl("any"), Intl.intl("all"), Intl.intl("at least n"), Intl.intl("no more than n"), Intl.intl("exactly n")};
            int[] nArray = new int[]{0, 1, 2, 3, 4};
            listHelperWindow.init(point, false, this.d_desc.d_logicType, nArray, stringArray, new ListHelperWindow.Callback(){

                @Override
                public void select(int n) {
                    d_desc.setLogicType(n);
                    this.changed();
                }
            });
        }

        private void selectActivate(Point point) {
            ListHelperWindow listHelperWindow = this.newListHelperWindow();
            String[] stringArray = new String[]{Intl.intl("activate"), Intl.intl("deactivate")};
            int[] nArray = new int[]{1, 0};
            listHelperWindow.init(point, false, this.d_desc.d_sourceActivates ? 1 : 0, nArray, stringArray, new ListHelperWindow.Callback(){

                @Override
                public void select(int n) {
                    d_desc.setSourceActivates(n == 1);
                    this.changed();
                }
            });
        }

        private void selectN(Point point) {
            ValueFieldHelperWindow<Integer> valueFieldHelperWindow = this.newVFHelperWindow();
            ValueField<Integer> valueField = ValueFields.intFld(this.d_desc.d_n, IntVR.above(1, true));
            valueFieldHelperWindow.init(point, valueField, new ValueFieldHelperWindow.Callback<Integer>(){

                @Override
                public void select(Integer n) {
                    d_desc.setN(n);
                    this.changed();
                }
            });
        }

        private void selectT(Point point) {
            ValueFieldHelperWindow<UnitDouble> valueFieldHelperWindow = this.newVFHelperWindow();
            ValueField<UnitDouble> valueField = ValueFields.udFld(new UnitDouble(0.0, SI.SECOND), UnitSystem.getSource(2));
            valueField.setNullAllowed(true);
            ValueFields.getFormat(valueField).alias(null, ControlDesc.TBEGIN);
            valueField.setValue(this.d_desc.d_t);
            valueFieldHelperWindow.init(point, valueField, new ValueFieldHelperWindow.Callback<UnitDouble>(){

                @Override
                public void select(UnitDouble unitDouble) {
                    d_desc.setT(unitDouble);
                    this.changed();
                }
            });
        }

        private <T> ValueFieldHelperWindow<T> newVFHelperWindow() {
            return this.createHelperWindow(ValueFieldHelperWindow.class);
        }

        private ListHelperWindow newListHelperWindow() {
            return this.createHelperWindow(ListHelperWindow.class);
        }

        private PopupWindow newHelperWindow() {
            return this.createHelperWindow(PopupWindow.class);
        }

        private <T extends PopupWindow> T createHelperWindow(Class<T> clazz) {
            Component component = Utils.findParentWindow(this);
            try {
                if (component instanceof Frame) {
                    return (T)((PopupWindow)clazz.getConstructor(Frame.class).newInstance((Frame)component));
                }
                if (component instanceof Window) {
                    return (T)((PopupWindow)clazz.getConstructor(Window.class).newInstance((Window)component));
                }
                return (T)((PopupWindow)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static class TimeActivationPanel
    extends guiPanel {
        private static final long serialVersionUID = 7479791470275231189L;
        private final guiTable d_table;
        private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;

        public TimeActivationPanel() {
            Unit unit = PyroSim.getApp().getUnitSystem().getTimeUnit();
            String[] stringArray = new String[]{String.format(Intl.intl("Time (%s)"), unit), Intl.intl("Event")};
            Class[] classArray = new Class[]{UnitDouble.class, String.class};
            this.d_table = guiTableUtil.fixedColumnTable(stringArray, classArray);
            guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 0);
            this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(unit));
            this.d_table.setColumnOptions(1, new Activation(true), new Activation(false));
            this.setLayout(new BorderLayout());
            this.add((Component)guiTableEditor2, "Center");
        }

        private Map<UnitDouble, Boolean> parseTimes() {
            TreeMap<UnitDouble, Boolean> treeMap = new TreeMap<UnitDouble, Boolean>();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                UnitDouble unitDouble = (UnitDouble)this.d_table.getValueAt(i, 0);
                Activation activation = (Activation)this.d_table.getValueAt(i, 1);
                if (unitDouble == null || activation == null) continue;
                treeMap.put(unitDouble, activation.value);
            }
            return treeMap;
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!this.isVisible()) {
                return true;
            }
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            Map<UnitDouble, Boolean> map = this.parseTimes();
            if (map.isEmpty()) {
                if (bl) {
                    JOptionPane.showMessageDialog(Utils.findParentWindow(this), Intl.intl("You must enter at least one timed event."), Intl.intl("Missing Time Events"), 0);
                }
                return false;
            }
            return true;
        }

        public void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_sinkType = sinkType;
            this.repaint();
        }

        public void load(CustomCtrl customCtrl, boolean bl, UnitDouble unitDouble) {
            boolean bl2 = customCtrl.getInitialState() ^ bl;
            int n = 0;
            this.d_table.clearRows();
            for (UnitDouble unitDouble2 : customCtrl.getTripValues()) {
                boolean bl3 = !bl2;
                UnitDouble unitDouble3 = unitDouble2.add(unitDouble);
                this.d_table.getModel().setValueAt(unitDouble3, n, 0);
                this.d_table.getModel().setValueAt(new Activation(bl3), n, 1);
                ++n;
                bl2 = bl3;
            }
            this.d_table.repaint();
        }

        public ILogicOutPin save() {
            boolean bl;
            Map<UnitDouble, Boolean> map = this.parseTimes();
            if (map.isEmpty()) {
                return null;
            }
            Iterator<Map.Entry<UnitDouble, Boolean>> iterator = map.entrySet().iterator();
            boolean bl2 = iterator.next().getValue();
            while (iterator.hasNext()) {
                Map.Entry<UnitDouble, Boolean> entry = iterator.next();
                if (entry.getValue() == bl2) {
                    iterator.remove();
                    continue;
                }
                bl2 = entry.getValue();
            }
            boolean bl3 = bl = map.values().iterator().next() == false;
            if (map.size() == 1) {
                Timer timer = new Timer(map.keySet().iterator().next(), bl);
                return (ILogicOutPin)timer.getOutputPins().get(0);
            }
            CustomCtrl customCtrl = new CustomCtrl(bl, map.keySet());
            Clock clock = Clock.INSTANCE;
            customCtrl.getInputPin().connect(clock.getOutputPins().get(0));
            return (ILogicOutPin)customCtrl.getOutputPins().get(0);
        }

        private class Activation {
            public final boolean value;

            public Activation(boolean bl) {
                this.value = bl;
            }

            public String toString() {
                return this.value ? ((TimeActivationPanel)TimeActivationPanel.this).d_sinkType.strings.activate : ((TimeActivationPanel)TimeActivationPanel.this).d_sinkType.strings.deactivate;
            }
        }
    }

    private static class InputPnl
    extends guiPanel {
        private static final long serialVersionUID = -6224895310993658138L;
        private guiRadioButton d_timeBtn = new guiRadioButton(Intl.intl("Time"));
        private guiRadioButton d_detectorBtn = new guiRadioButton(Intl.intl("Detector"));
        private guiRadioButton d_thermostatBtn = new guiRadioButton(Intl.intl("Deadband Control (e.g. Thermostat)"));
        private guiRadioButton d_customBtn = new guiRadioButton(Intl.intl("Custom"));

        public InputPnl() {
            super(new GridBagLayout());
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Input Type"));
            new guiButtonGroup(this.d_timeBtn, this.d_detectorBtn, this.d_thermostatBtn, this.d_customBtn);
            this.d_timeBtn.setSelected(true);
            int n = 0;
            GridBagUtil.add(this, titleSeparator, 0, ++n, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_timeBtn, 0, ++n, 2, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_detectorBtn, 0, ++n, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thermostatBtn, 0, ++n, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_customBtn, 0, ++n, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void addListener(ActionListener actionListener) {
            this.d_timeBtn.addActionListener(actionListener);
            this.d_detectorBtn.addActionListener(actionListener);
            this.d_thermostatBtn.addActionListener(actionListener);
            this.d_customBtn.addActionListener(actionListener);
        }

        public void setValue(int n) {
            switch (n) {
                case 0: {
                    this.d_timeBtn.setSelected(true);
                    break;
                }
                case 1: {
                    this.d_detectorBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.d_thermostatBtn.setSelected(true);
                    break;
                }
                default: {
                    this.d_customBtn.setSelected(true);
                }
            }
        }

        public int getValue() {
            if (this.d_timeBtn.isSelected()) {
                return 0;
            }
            if (this.d_detectorBtn.isSelected()) {
                return 1;
            }
            if (this.d_thermostatBtn.isSelected()) {
                return 2;
            }
            return 3;
        }
    }

    private static class ActionPnl
    extends guiPanel {
        private static final long serialVersionUID = -3606489502740766100L;
        private guiRadioButton d_createBtn = new guiRadioButton();
        private guiRadioButton d_removeBtn = new guiRadioButton();
        private guiRadioButton d_multipleBtn = new guiRadioButton(Intl.intl("Multiple"));

        public ActionPnl() {
            super(new GridBagLayout());
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Action to Perform"));
            new guiButtonGroup(this.d_createBtn, this.d_removeBtn, this.d_multipleBtn);
            int n = 0;
            GridBagUtil.add(this, titleSeparator, 0, ++n, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_createBtn, 0, ++n, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_removeBtn, 0, ++n, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_multipleBtn, 0, ++n, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void setInput(int n) {
            this.setVisible(n != 3 && n != 2);
            if (this.isVisible()) {
                this.d_createBtn.setVisible(n == 0 || n == 1);
                this.d_removeBtn.setVisible(this.d_createBtn.isVisible());
                this.d_multipleBtn.setVisible(n == 0 || n == 2);
                if (!this.d_multipleBtn.isVisible() && this.d_multipleBtn.isSelected()) {
                    this.d_createBtn.setSelected(true);
                } else if (!this.d_createBtn.isVisible() && this.d_createBtn.isSelected()) {
                    this.d_multipleBtn.setSelected(true);
                } else if (!this.d_removeBtn.isVisible() && this.d_removeBtn.isSelected()) {
                    this.d_multipleBtn.setSelected(true);
                }
            }
        }

        public void addListener(ActionListener actionListener) {
            this.d_createBtn.addActionListener(actionListener);
            this.d_removeBtn.addActionListener(actionListener);
            this.d_multipleBtn.addActionListener(actionListener);
        }

        private void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_createBtn.setText(sinkType.strings.activate);
            this.d_removeBtn.setText(sinkType.strings.deactivate);
        }

        public void setValue(int n) {
            switch (n) {
                case 0: {
                    this.d_createBtn.setSelected(true);
                    break;
                }
                case 1: {
                    this.d_removeBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.d_multipleBtn.setSelected(true);
                }
            }
        }

        public int getValue() {
            if (this.d_createBtn.isSelected()) {
                return 0;
            }
            if (this.d_removeBtn.isSelected()) {
                return 1;
            }
            if (this.d_multipleBtn.isSelected()) {
                return 2;
            }
            return -1;
        }
    }
}

