/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.controls.ControlPnl;
import pyrosim.gui.controls.NewControlDlg;
import thunderheadeng.gui.guiAction;

public class ControlDlg
extends ManagerDlg<ControlBridge, ControlMgr> {
    private static final long serialVersionUID = 4918905546175464825L;
    private final ControlPnl d_controlPnl;
    private ControlMgr d_mgr;
    private final Action[] d_actions;
    private final Action d_new = new NewAction();
    private final Action d_rename = new RenameAction<ControlBridge, ControlMgr>(this, Intl.intl("control"));
    private final Action d_delete = new ManagerDlg.DeleteAction();

    public ControlDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Activation Controls"), false);
        this.d_actions = new Action[]{this.d_new, this.d_rename, this.d_delete};
        this.d_controlPnl = new ControlPnl();
        this.setResizable(true);
    }

    private void updateActions() {
        int n = this.getList().getSelectedIx();
        this.d_new.setEnabled(this.d_mgr != null);
        this.d_rename.setEnabled(this.d_mgr != null && n > -1);
        this.d_delete.setEnabled(this.d_mgr != null && n > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(ControlMgr controlMgr, ControlBridge controlBridge) {
        this.d_mgr = controlMgr;
        ((RenameAction)this.d_rename).init(controlMgr);
        super.init(this.d_mgr, this.d_controlPnl, this.d_actions, controlBridge);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 5944064610703301296L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewControlDlg newControlDlg;
            if (!ControlDlg.this.preSave()) {
                return;
            }
            int n = ControlDlg.this.getList().getSelectedIx();
            ControlBridge controlBridge = null;
            if (n >= 0) {
                controlBridge = (ControlBridge)ControlDlg.this.getList().getItem(n);
            }
            if ((newControlDlg = new NewControlDlg(ControlDlg.this.d_mgr)).doModal() == 1) {
                controlBridge = new ControlBridge(newControlDlg.getName());
                PyroMod pyroMod = (PyroMod)ControlDlg.this.d_mgr.getDomain();
                AddTask addTask = new AddTask((IPyroObject)ControlDlg.this.d_mgr, new IPyroObject[]{controlBridge});
                SelectTask selectTask = new SelectTask(pyroMod, controlBridge);
                selectTask.addTask(addTask);
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Control"));
                ControlDlg.this.getList().updateModelView(ControlDlg.this.d_mgr);
                ControlDlg.this.getList().select(controlBridge);
                ControlDlg.this.d_controlPnl.getEditorPanel().setModified(false);
                ControlDlg.this.updateActions();
            }
        }
    }
}

