/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ADblCompareOp;
import pyrosim.domain.controls.AIntCompareOp;
import pyrosim.domain.controls.ALogicOp;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DblGreaterThanOp;
import pyrosim.domain.controls.DeadbandCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.IntEqualOp;
import pyrosim.domain.controls.IntGreaterThanOp;
import pyrosim.domain.controls.IntLessThanOp;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.controls.OrOp;
import pyrosim.domain.controls.SumOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IIntegerOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import thunderheadeng.gui.Utils;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class ControlDesc {
    public static final int ACTION_ACTIVATE = 0;
    public static final int ACTION_DEACTIVATE = 1;
    public static final int ACTION_MULTIPLE = 2;
    public static final int INPUT_TIME = 0;
    public static final int INPUT_DEVICE = 1;
    public static final int INPUT_DEADBAND = 2;
    public static final int INPUT_CUSTOM = 3;
    public static final int LOGIC_OR = 0;
    public static final int LOGIC_AND = 1;
    public static final int LOGIC_GE = 2;
    public static final int LOGIC_LE = 3;
    public static final int LOGIC_EQ = 4;
    public static final String TBEGIN = Intl.intl("TBEGIN");
    public static final String HREF_SINKS = "SINKS";
    public static final String HREF_LOGIC = "LOGIC";
    public static final String HREF_DETSOURCES = "DETSOURCES";
    public static final String HREF_ACTIVATE = "ACTIVATE";
    public static final String HREF_N = "N";
    public static final String HREF_T = "T";
    public static final String HREF_DBLOWERV = "DBLOWERV";
    public static final String HREF_DBUPPERV = "DBUPPERV";
    public static final String HREF_DBLOWERL = "DBLOWERL";
    public static final String HREF_DBUPPERL = "DBUPPERL";
    public static final String HREF_MSRSOURCE = "MSRSOURCES";
    public static final String HREF_DELAY = "DELAY";
    public static final String HREF_CUSTOMINPUT = "CUSTOMINPUT";
    private final boolean d_editable;
    private final boolean d_displaySinks;
    public int d_action;
    public int d_input;
    public Collection<String> d_dstObjNames = null;
    public Collection<? extends ISignalSink> d_dstObjs = Collections.EMPTY_LIST;
    public List<? extends ILogicOutPin> d_srcDetectors = Collections.EMPTY_LIST;
    public int d_logicType = 0;
    public int d_n = 1;
    public boolean d_sourceActivates = true;
    public UnitDouble d_delay = new UnitDouble(0.0, SI.SECOND);
    public UnitDouble d_t = null;
    public IDoubleOutPin d_srcMeasurer = null;
    public boolean d_dbUpper = true;
    public UnitDouble[] d_dbRange = new UnitDouble[]{new UnitDouble(23.0, SI.CELSIUS), new UnitDouble(27.0, SI.CELSIUS)};
    public int d_dbRangeType = 1;
    public String d_customCtrlName = null;

    public ControlDesc(boolean bl, boolean bl2) {
        this.d_editable = bl;
        this.d_displaySinks = bl2;
    }

    private void changed() {
    }

    public static String getName(Object object) {
        if (object instanceof IOutPin) {
            return ControlDesc.getName((IOutPin)object);
        }
        if (object instanceof INamed) {
            return ((INamed)object).getName();
        }
        return object.toString();
    }

    public static String getName(IOutPin iOutPin) {
        if (iOutPin.getAttachedSource() == null || !(iOutPin.getAttachedSource() instanceof INamed)) {
            return iOutPin.getName();
        }
        ISignalSource iSignalSource = iOutPin.getAttachedSource();
        String string = ((INamed)((Object)iSignalSource)).getName();
        int n = ControlDesc.countAlikePins(iSignalSource, iOutPin);
        if (n <= 1) {
            return string;
        }
        return string + "->" + iOutPin.getName();
    }

    private static int countAlikePins(ISignalSource iSignalSource, IOutPin iOutPin) {
        int n = 0;
        Class clazz = iOutPin instanceof ILogicOutPin ? ILogicOutPin.class : (iOutPin instanceof IIntegerOutPin ? IIntegerOutPin.class : IDoubleOutPin.class);
        for (IOutPin iOutPin2 : iSignalSource.getOutputPins()) {
            if (!clazz.isInstance(iOutPin2)) continue;
            ++n;
        }
        return n;
    }

    public void setData(int n, int n2) {
        this.d_action = n;
        this.d_input = n2;
    }

    public void setCustomCtrlName(String string) {
        this.d_customCtrlName = string;
        this.changed();
    }

    public void setDelay(UnitDouble unitDouble) {
        this.d_delay = unitDouble;
        this.changed();
    }

    public void setDBBound(UnitDouble unitDouble, boolean bl) {
        if (bl) {
            this.d_dbRange[0] = unitDouble;
        } else {
            this.d_dbRange[1] = unitDouble;
        }
        this.changed();
    }

    public void setDBLogic(boolean bl, boolean bl2) {
        this.d_dbUpper = bl2 ? !bl : bl;
        this.changed();
    }

    public void setLogicType(int n) {
        this.d_logicType = n;
        this.changed();
    }

    public void setN(int n) {
        this.d_n = n;
        this.changed();
    }

    public void setT(UnitDouble unitDouble) {
        this.d_t = unitDouble;
        this.changed();
    }

    public void setSourceMeasurer(IDoubleOutPin iDoubleOutPin) {
        this.d_srcMeasurer = iDoubleOutPin;
        if (iDoubleOutPin != null) {
            this.d_dbRangeType = iDoubleOutPin.getUnitType();
            Unit unit = PyroSim.getApp().getUnitSystem().getUnit(this.d_dbRangeType);
            this.d_dbRange[0] = this.d_dbRange[0].reinterpret(unit);
            this.d_dbRange[1] = this.d_dbRange[1].reinterpret(unit);
        }
        this.changed();
    }

    public void setSourceActivates(boolean bl) {
        this.d_sourceActivates = bl;
        this.changed();
    }

    public void setSources(List<? extends ILogicOutPin> list) {
        this.d_srcDetectors = list;
        this.changed();
    }

    public void setSinks(Collection<? extends ISignalSink> collection) {
        this.d_dstObjNames = null;
        this.d_dstObjs = collection;
        this.changed();
    }

    public void setSinkNames(Collection<String> collection) {
        this.d_dstObjNames = collection;
        this.d_dstObjs = Collections.EMPTY_LIST;
        this.changed();
    }

    private <T> String getListStr(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return Intl.intl("&lt;nothing&gt;");
        }
        String string = "&lt;";
        int n = 0;
        int n2 = Math.min(2, collection.size());
        for (T t : collection) {
            if (n != 0) {
                string = string + ", ";
            }
            string = string + ControlDesc.getName(t);
            if (++n < n2) continue;
            break;
        }
        if (collection.size() > 2) {
            string = string + ", ...";
        }
        string = string + "&gt;";
        return string;
    }

    private String getCustomInputStr() {
        if (this.d_customCtrlName == null) {
            return Intl.intl("&lt;nothing&gt;");
        }
        return this.d_customCtrlName;
    }

    private String getSinksStr() {
        if (!this.d_displaySinks) {
            return "";
        }
        Collection<Object> collection = this.d_dstObjNames != null ? this.d_dstObjNames : this.d_dstObjs;
        return this.getListStr(collection);
    }

    private String getInputDetectorsStr() {
        return this.getListStr(this.d_srcDetectors);
    }

    private String getInputMeasurerStr() {
        if (this.d_srcMeasurer == null) {
            return Intl.intl("&lt;nothing&gt;");
        }
        return ControlDesc.getName(this.d_srcMeasurer);
    }

    private String format(String string, Object ... objectArray) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Pattern pattern = Pattern.compile("\\<\\%([0-9]+)\\>");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            int n = Integer.parseInt(string2);
            if (this.d_editable) {
                matcher.appendReplacement(stringBuffer, "<a href=\"%" + n + "\\$s\">%" + (n + 1) + "\\$s</a>");
                continue;
            }
            matcher.appendReplacement(stringBuffer, "%" + (n + 1) + "\\$s");
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        pattern = Pattern.compile("\\<\\%([0-9]+)([^\\>.]+)\\>");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(1);
            String string3 = matcher.group(2);
            int n = Integer.parseInt(string2);
            if (this.d_editable) {
                matcher.appendReplacement(stringBuffer, "<a href=\"%" + n + "\\$s\">" + string3 + "</a>");
                continue;
            }
            matcher.appendReplacement(stringBuffer, string3);
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return String.format(string, objectArray);
    }

    public String formatMessage(SinkType sinkType) {
        String[] stringArray = sinkType.strings.values;
        String string = "";
        if (this.d_input != 3) {
            if (this.d_input == 1) {
                String string2 = this.getSinksStr();
                String string3 = this.getInputDetectorsStr();
                if (this.d_srcDetectors.size() <= 1) {
                    if (this.d_action == 0 && this.d_sourceActivates) {
                        string = this.format(stringArray[0], HREF_SINKS, string2, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                    } else if (this.d_action == 0 && !this.d_sourceActivates) {
                        string = this.format(stringArray[1], HREF_SINKS, string2, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                    } else if (this.d_action == 1 && this.d_sourceActivates) {
                        string = this.format(stringArray[2], HREF_SINKS, string2, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                    } else if (this.d_action == 1 && !this.d_sourceActivates) {
                        string = this.format(stringArray[3], HREF_SINKS, string2, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                    }
                } else if (this.d_action == 0 && this.d_logicType == 0 && this.d_sourceActivates) {
                    string = this.format(stringArray[4], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 0 && !this.d_sourceActivates) {
                    string = this.format(stringArray[5], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 1 && this.d_sourceActivates) {
                    string = this.format(stringArray[6], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 1 && !this.d_sourceActivates) {
                    string = this.format(stringArray[7], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 3 && this.d_sourceActivates) {
                    string = this.format(stringArray[8], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 3 && !this.d_sourceActivates) {
                    string = this.format(stringArray[9], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 2 && this.d_sourceActivates) {
                    string = this.format(stringArray[10], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 2 && !this.d_sourceActivates) {
                    string = this.format(stringArray[11], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 4 && this.d_sourceActivates) {
                    string = this.format(stringArray[12], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 0 && this.d_logicType == 4 && !this.d_sourceActivates) {
                    string = this.format(stringArray[13], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 0 && this.d_sourceActivates) {
                    string = this.format(stringArray[14], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 0 && !this.d_sourceActivates) {
                    string = this.format(stringArray[15], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 1 && this.d_sourceActivates) {
                    string = this.format(stringArray[16], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 1 && !this.d_sourceActivates) {
                    string = this.format(stringArray[17], HREF_SINKS, string2, HREF_LOGIC, HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 3 && this.d_sourceActivates) {
                    string = this.format(stringArray[18], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 3 && !this.d_sourceActivates) {
                    string = this.format(stringArray[19], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 2 && this.d_sourceActivates) {
                    string = this.format(stringArray[20], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 2 && !this.d_sourceActivates) {
                    string = this.format(stringArray[21], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 4 && this.d_sourceActivates) {
                    string = this.format(stringArray[22], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                } else if (this.d_action == 1 && this.d_logicType == 4 && !this.d_sourceActivates) {
                    string = this.format(stringArray[23], HREF_SINKS, string2, HREF_LOGIC, HREF_N, Integer.toString(this.d_n), HREF_DETSOURCES, string3, HREF_ACTIVATE);
                }
                if (this.d_editable || this.d_delay.getValueNoUnit() > 0.0) {
                    String string4 = "<br>";
                    if (this.d_action == 1) {
                        string4 = string4 + this.format(stringArray[24], HREF_DELAY, Global.format(this.d_delay));
                    } else if (this.d_action == 0) {
                        string4 = string4 + this.format(stringArray[25], HREF_DELAY, Global.format(this.d_delay));
                    }
                    string = string + string4;
                }
            } else if (this.d_input == 0) {
                String string5 = this.getSinksStr();
                if (this.d_action == 0) {
                    string = this.format(stringArray[26], HREF_SINKS, string5, HREF_T, this.formatT());
                } else if (this.d_action == 1) {
                    string = this.format(stringArray[27], HREF_SINKS, string5, HREF_T, this.formatT());
                } else if (this.d_action == 2) {
                    string = this.d_editable ? this.format(stringArray[28], HREF_SINKS, string5) : this.format(stringArray[29], HREF_SINKS, string5);
                }
            } else if (this.d_input == 2) {
                String string6 = this.getSinksStr();
                String string7 = this.getInputMeasurerStr();
                string = this.d_dbUpper ? this.format(stringArray[30], HREF_DBLOWERL, HREF_SINKS, string6, HREF_MSRSOURCE, string7, HREF_DBLOWERV, Global.format(this.d_dbRange[0]), HREF_DBUPPERL, HREF_DBUPPERV, Global.format(this.d_dbRange[1])) : this.format(stringArray[31], HREF_DBLOWERL, HREF_SINKS, string6, HREF_MSRSOURCE, string7, HREF_DBLOWERV, Global.format(this.d_dbRange[0]), HREF_DBUPPERL, HREF_DBUPPERV, Global.format(this.d_dbRange[1]));
            }
        } else if (this.d_editable) {
            String string8 = this.getSinksStr();
            String string9 = this.getCustomInputStr();
            string = this.d_dstObjNames != null && this.d_dstObjNames.size() <= 1 || this.d_dstObjs.size() <= 1 ? this.format(stringArray[32], HREF_SINKS, string8, HREF_CUSTOMINPUT, string9) : this.format(stringArray[33], HREF_SINKS, string8, HREF_CUSTOMINPUT, string9);
        } else {
            string = stringArray[34];
        }
        return string;
    }

    private String formatT() {
        return this.d_t == null ? TBEGIN : Global.format(this.d_t);
    }

    public boolean validateData(Component component, SinkType sinkType, boolean bl, boolean bl2) {
        component = Utils.findParentWindow(component);
        if (this.d_input == 0) {
            if (this.d_action == 1 && this.d_t == null) {
                if (bl) {
                    JOptionPane.showMessageDialog(component, String.format(Intl.intl("%1$s may only be entered if the action type is %2$s."), TBEGIN, sinkType.strings.activate), Intl.intl("Invalid Entry"), 0);
                }
                return false;
            }
        } else if (this.d_input == 1) {
            if (this.d_srcDetectors.isEmpty()) {
                if (bl) {
                    JOptionPane.showMessageDialog(component, Intl.intl("You must select at least one source detector."), Intl.intl("No Source Detectors Selected"), 0);
                }
                return false;
            }
        } else if (this.d_input == 2) {
            if (this.d_srcMeasurer == null) {
                if (bl) {
                    JOptionPane.showMessageDialog(component, Intl.intl("You must select a source device."), Intl.intl("No Source Device Selected"), 0);
                }
                return false;
            }
            if (this.d_dbRange[0].compareTo(this.d_dbRange[1]) >= 0) {
                if (bl) {
                    JOptionPane.showMessageDialog(component, Intl.intl("The lower bound of the deadband must be less than the upper bound."), Intl.intl("Invalid Deadband Range"), 0);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public IOutPin save() {
        if (this.d_action == 0 && this.d_input == 0 && this.d_t == null) {
            return null;
        }
        IOutPin iOutPin = null;
        if (this.d_input == 0) {
            if (this.d_action == 0 || this.d_action == 1) {
                Timer timer = new Timer(this.d_t, this.d_action == 1);
                iOutPin = timer.getOutputPins().get(0);
            } else if (this.d_action == 2) {
                // empty if block
            }
        } else if (this.d_input == 1) {
            if (this.d_action == 0 || this.d_action == 1) {
                AControl aControl;
                boolean bl;
                boolean bl2 = bl = !this.d_sourceActivates;
                if (this.d_srcDetectors.size() > 1) {
                    int n = this.d_logicType;
                    if (n == 1 || n == 0) {
                        aControl = n == 1 ? new AndOp() : new OrOp();
                        for (IOutPin iOutPin2 : this.d_srcDetectors) {
                            void iOutPin22;
                            if (bl) {
                                NotOp notOp = new NotOp();
                                notOp.getInputPin().connect(iOutPin2);
                                IOutPin iOutPin3 = notOp.getOutputPins().get(0);
                            }
                            ((ALogicOp)aControl).getInputPin().connect((IOutPin)iOutPin22);
                        }
                        iOutPin = ((ALogicOp)aControl).getOutputPins().get(0);
                    } else {
                        aControl = null;
                        if (n == 2) {
                            aControl = new IntGreaterThanOp(this.d_n - 1);
                        } else if (n == 3) {
                            aControl = new IntLessThanOp(this.d_n + 1);
                        } else if (n == 4) {
                            aControl = new IntEqualOp(this.d_n);
                        }
                        if (aControl != null) {
                            SumOp sumOp = new SumOp();
                            for (IOutPin iOutPin4 : this.d_srcDetectors) {
                                void var7_17;
                                if (bl) {
                                    NotOp notOp = new NotOp();
                                    notOp.getInputPin().connect(iOutPin4);
                                    IOutPin iOutPin5 = notOp.getOutputPins().get(0);
                                }
                                sumOp.getInputPin().connect((IOutPin)var7_17);
                            }
                            ((AIntCompareOp)aControl).getInputPin().connect(sumOp.getOutputPins().get(0));
                            iOutPin = ((AIntCompareOp)aControl).getOutputPins().get(0);
                        }
                    }
                } else if (this.d_srcDetectors.size() == 1) {
                    iOutPin = this.d_srcDetectors.get(0);
                    if (bl) {
                        NotOp notOp = new NotOp();
                        notOp.getInputPin().connect(iOutPin);
                        iOutPin = notOp.getOutputPins().get(0);
                    }
                }
                if (iOutPin != null) {
                    LatchCtrl latchCtrl = new LatchCtrl();
                    latchCtrl.getInputPin().connect(iOutPin);
                    iOutPin = latchCtrl.getOutputPins().get(0);
                    if (this.d_delay.getValueNoUnit() > 0.0) {
                        aControl = new TimeDelayCtrl(this.d_delay);
                        ((TimeDelayCtrl)aControl).getInputPin().connect(iOutPin);
                        iOutPin = ((TimeDelayCtrl)aControl).getOutputPins().get(0);
                    }
                    if (this.d_action == 1) {
                        aControl = new NotOp();
                        ((NotOp)aControl).getInputPin().connect(iOutPin);
                        iOutPin = ((NotOp)aControl).getOutputPins().get(0);
                    }
                }
            }
        } else if (this.d_input == 2 && this.d_srcMeasurer != null) {
            int n = this.d_dbUpper ? 1 : 0;
            DeadbandCtrl deadbandCtrl = new DeadbandCtrl(n, this.d_dbRange[0], this.d_dbRange[1]);
            deadbandCtrl.getInputPin().connect(this.d_srcMeasurer);
            iOutPin = deadbandCtrl.getOutputPins().get(0);
        } else if (this.d_input == 3) {
            // empty if block
        }
        return iOutPin;
    }

    /*
     * WARNING - void declaration
     */
    public void load(IInPin iInPin) {
        if (iInPin.getConnections().isEmpty()) {
            this.d_action = 0;
            this.d_input = 0;
            this.setT(null);
            return;
        }
        boolean bl = true;
        DupAccumulation dupAccumulation = this.accumulateDuplicates(iInPin.getConnections());
        int n = dupAccumulation.getAccumType();
        if (n == 3) {
            if (dupAccumulation.d_nextInputs.size() == 1) {
                ILogicOutPin iLogicOutPin;
                ISignalSource iSignalSource = ((IOutPin)dupAccumulation.d_nextInputs.iterator().next()).getAttachedSource();
                if (iSignalSource instanceof ADblCompareOp) {
                    ISignalSource iSignalSource2;
                    ADblCompareOp aDblCompareOp = (ADblCompareOp)iSignalSource;
                    if (aDblCompareOp.getInputPin().getConnectedSources().size() == 1 && (iSignalSource2 = aDblCompareOp.getInputPin().getConnectedSources().iterator().next()) instanceof Clock) {
                        int n2;
                        this.d_action = n2 = aDblCompareOp instanceof DblGreaterThanOp ? 0 : 1;
                        this.d_input = 0;
                        this.setT(aDblCompareOp.getN());
                        bl = false;
                    }
                } else if (iSignalSource instanceof Timer) {
                    Timer timer = (Timer)iSignalSource;
                    int n3 = TripFlags.initiallyOn(timer.getAlarmInfo().tripFlags) ? 1 : 0;
                    UnitDouble unitDouble = timer.getAlarmInfo().setpoint;
                    this.d_action = n3;
                    this.d_input = 0;
                    this.setT(unitDouble);
                    bl = false;
                } else if (iSignalSource instanceof CustomCtrl) {
                    ISignalSource iSignalSource3;
                    CustomCtrl customCtrl = (CustomCtrl)iSignalSource;
                    if (customCtrl.getInputPin().getConnectedSources().size() == 1 && (iSignalSource3 = customCtrl.getInputPin().getConnectedSources().iterator().next()) instanceof Clock) {
                        if (customCtrl.getTripValues().size() == 1) {
                            int n4;
                            this.d_action = n4 = customCtrl.getInitialState() ? 1 : 0;
                            this.d_input = 0;
                            this.setT(customCtrl.getTripValues().first());
                            bl = false;
                        } else if (customCtrl.getTripValues().size() > 1) {
                            this.d_action = 2;
                            this.d_input = 0;
                            bl = false;
                        }
                    }
                } else if (iSignalSource instanceof DeadbandCtrl) {
                    DeadbandCtrl deadbandCtrl = (DeadbandCtrl)iSignalSource;
                    if (deadbandCtrl.getInputPin().getConnections().size() == 1) {
                        IOutPin iOutPin = deadbandCtrl.getInputPin().getConnections().iterator().next();
                        this.d_action = 2;
                        this.d_input = 2;
                        this.setDBBound(deadbandCtrl.getLowerBound(), true);
                        this.setDBBound(deadbandCtrl.getUpperBound(), false);
                        if (deadbandCtrl.getTripDirection() == 0) {
                            this.setDBLogic(true, true);
                        } else if (deadbandCtrl.getTripDirection() == 1) {
                            this.setDBLogic(true, false);
                        }
                        this.setSourceMeasurer((IDoubleOutPin)iOutPin);
                        bl = false;
                    }
                } else if (iSignalSource instanceof IDevice && iSignalSource instanceof ISignalSource && !(iSignalSource instanceof Timer) && (iLogicOutPin = (ILogicOutPin)dupAccumulation.d_nextInputs.iterator().next()).latches()) {
                    this.d_action = 0;
                    this.d_input = 1;
                    this.setSources(Arrays.asList(iLogicOutPin));
                    bl = false;
                }
            }
        } else {
            boolean bl2;
            int n5 = 0;
            if (n == 1) {
                if (dupAccumulation.d_invertCount % 2 != 0) {
                    n5 = 1;
                }
                dupAccumulation = this.accumulateDuplicates(dupAccumulation.d_nextInputs);
                n = dupAccumulation.getAccumType();
            }
            this.d_action = n5;
            UnitDouble unitDouble = new UnitDouble(0.0, SI.SECOND);
            if (n == 2) {
                unitDouble = dupAccumulation.d_delay;
                dupAccumulation = this.accumulateDuplicates(dupAccumulation.d_nextInputs);
                n = dupAccumulation.getAccumType();
            }
            this.setDelay(unitDouble);
            this.d_input = 1;
            boolean bl3 = bl2 = n == 0;
            if (bl2) {
                n = (dupAccumulation = this.accumulateDuplicates(dupAccumulation.d_nextInputs)).getAccumType();
                if (n == 1 && dupAccumulation.d_invertCount % 2 != 0) {
                    ISignalSource iSignalSource;
                    if (dupAccumulation.d_nextInputs.size() == 1 && (iSignalSource = ((IOutPin)dupAccumulation.d_nextInputs.iterator().next()).getAttachedSource()) instanceof IDevice && !(iSignalSource instanceof Timer)) {
                        this.setSourceActivates(false);
                        this.setSources(Arrays.asList((ILogicOutPin)dupAccumulation.d_nextInputs.iterator().next()));
                        bl = false;
                    }
                } else if (dupAccumulation.d_nextInputs.size() > 0) {
                    ISignalSource iSignalSource = ((IOutPin)dupAccumulation.d_nextInputs.iterator().next()).getAttachedSource();
                    if (iSignalSource instanceof IDevice && !(iSignalSource instanceof Timer)) {
                        this.setSourceActivates(true);
                        this.setSources(Arrays.asList((ILogicOutPin)dupAccumulation.d_nextInputs.iterator().next()));
                        bl = false;
                    } else if (iSignalSource instanceof ALogicOp || iSignalSource instanceof AIntCompareOp) {
                        Set<? extends IOutPin> set = ((IControl)iSignalSource).getInputPin().getConnections();
                        if (iSignalSource instanceof AIntCompareOp) {
                            set = ((AIntCompareOp)iSignalSource).getInputPin().getConnections();
                            set = set.size() == 1 && set.iterator().next().getAttachedSource() instanceof SumOp ? ((SumOp)((IOutPin)set.iterator().next()).getAttachedSource()).getInputPin().getConnections() : Collections.EMPTY_SET;
                        }
                        if (set.size() > 0) {
                            ArrayList<ILogicOutPin> arrayList = new ArrayList<ILogicOutPin>();
                            int n6 = 0;
                            int n7 = 0;
                            for (IOutPin iOutPin : set) {
                                DupAccumulation dupAccumulation2 = this.accumulateDuplicates(Arrays.asList(iOutPin));
                                int n2 = dupAccumulation2.getAccumType();
                                if (n2 == 1 && dupAccumulation2.d_invertCount % 2 != 0) {
                                    ++n7;
                                } else if (n2 != 3) {
                                    ++n6;
                                }
                                if (!dupAccumulation2.d_nextInputs.isEmpty()) {
                                    IOutPin iOutPin2 = (IOutPin)dupAccumulation2.d_nextInputs.iterator().next();
                                    if (iOutPin2.getAttachedSource() instanceof IDevice && !(iOutPin2.getAttachedSource() instanceof Timer)) {
                                        arrayList.add((ILogicOutPin)dupAccumulation2.d_nextInputs.iterator().next());
                                        continue;
                                    }
                                    ++n6;
                                    continue;
                                }
                                ++n6;
                            }
                            if (n6 == 0 && (n7 == 0 || n7 == set.size())) {
                                this.setSourceActivates(n7 == 0);
                                this.setSources(arrayList);
                                int n9 = -1;
                                int n10 = -1;
                                if (iSignalSource instanceof AndOp) {
                                    n9 = 1;
                                } else if (iSignalSource instanceof OrOp) {
                                    n9 = 0;
                                } else if (iSignalSource instanceof IntGreaterThanOp) {
                                    n9 = 2;
                                    int n3 = ((AIntCompareOp)iSignalSource).getN() + 1;
                                } else if (iSignalSource instanceof IntLessThanOp) {
                                    n9 = 3;
                                    int n4 = ((AIntCompareOp)iSignalSource).getN() - 1;
                                } else if (iSignalSource instanceof IntEqualOp) {
                                    n9 = 4;
                                    int n8 = ((AIntCompareOp)iSignalSource).getN();
                                }
                                if (n9 != -1) {
                                    void var14_34;
                                    this.setLogicType(n9);
                                    if (var14_34 != -1) {
                                        this.setN((int)var14_34);
                                    }
                                    bl = false;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            this.d_input = 3;
        }
    }

    private DupAccumulation accumulateDuplicates(Collection<? extends IOutPin> collection) {
        DupAccumulation dupAccumulation = new DupAccumulation(collection);
        this.accumulateDuplicates(dupAccumulation);
        return dupAccumulation;
    }

    private void accumulateDuplicates(DupAccumulation dupAccumulation) {
        if (dupAccumulation.d_nextInputs.size() != 1) {
            return;
        }
        ISignalSource iSignalSource = ((IOutPin)dupAccumulation.d_nextInputs.iterator().next()).getAttachedSource();
        if (iSignalSource instanceof LatchCtrl) {
            if (dupAccumulation.getAccumType() != 3 && dupAccumulation.getAccumType() != 0) {
                return;
            }
            dupAccumulation.d_latch = true;
            dupAccumulation.d_nextInputs = ((IControl)iSignalSource).getInputPin().getConnections();
            this.accumulateDuplicates(dupAccumulation);
        } else if (iSignalSource instanceof NotOp) {
            if (dupAccumulation.getAccumType() != 3 && dupAccumulation.getAccumType() != 1) {
                return;
            }
            ++dupAccumulation.d_invertCount;
            dupAccumulation.d_nextInputs = ((IControl)iSignalSource).getInputPin().getConnections();
            this.accumulateDuplicates(dupAccumulation);
        } else if (iSignalSource instanceof TimeDelayCtrl) {
            if (dupAccumulation.getAccumType() != 3 && dupAccumulation.getAccumType() != 2) {
                return;
            }
            dupAccumulation.d_delay = dupAccumulation.d_delay.add(((TimeDelayCtrl)iSignalSource).getTimeDelay());
            dupAccumulation.d_nextInputs = ((IControl)iSignalSource).getInputPin().getConnections();
            this.accumulateDuplicates(dupAccumulation);
        }
    }

    public static SinkType getSinkType(Collection<?> collection) {
        return !collection.isEmpty() && collection.stream().allMatch(object -> object instanceof IFreezable) ? SinkType.FREEZE : SinkType.ACTIVATE;
    }

    private static Strings activate() {
        Strings strings = new Strings(Intl.intl("<Always On>"), Intl.intl("on"), Intl.intl("off"), Intl.intl("Activate"), Intl.intl("Deactivate"));
        String[] stringArray = strings.values;
        stringArray[0] = Intl.intl("Activate <%1> when <%3> <%5activates>.");
        stringArray[1] = Intl.intl("Activate <%1> when <%3> <%5deactivates>.");
        stringArray[2] = Intl.intl("Deactivate <%1> when <%3> <%5activates>.");
        stringArray[3] = Intl.intl("Deactivate <%1> when <%3> <%5deactivates>.");
        stringArray[4] = Intl.intl("Activate <%1> when <%3any of> <%4> <%6activates>.");
        stringArray[5] = Intl.intl("Activate <%1> when <%3any of> <%4> <%6deactivates>.");
        stringArray[6] = Intl.intl("Activate <%1> when <%3all of> <%4> <%6activate>.");
        stringArray[7] = Intl.intl("Activate <%1> when <%3all of> <%4> <%6deactivate>.");
        stringArray[8] = Intl.intl("Activate <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
        stringArray[9] = Intl.intl("Activate <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
        stringArray[10] = Intl.intl("Activate <%1> when <%3at least> <%4> of <%6> <%8activate>.");
        stringArray[11] = Intl.intl("Activate <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
        stringArray[12] = Intl.intl("Activate <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
        stringArray[13] = Intl.intl("Activate <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
        stringArray[14] = Intl.intl("Deactivate <%1> when <%3any of> <%4> <%6activates>.");
        stringArray[15] = Intl.intl("Deactivate <%1> when <%3any of> <%4> <%6deactivates>.");
        stringArray[16] = Intl.intl("Deactivate <%1> when <%3all of> <%4> <%6activate>.");
        stringArray[17] = Intl.intl("Deactivate <%1> when <%3all of> <%4> <%6deactivate>.");
        stringArray[18] = Intl.intl("Deactivate <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
        stringArray[19] = Intl.intl("Deactivate <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
        stringArray[20] = Intl.intl("Deactivate <%1> when <%3at least> <%4> of <%6> <%8activate>.");
        stringArray[21] = Intl.intl("Deactivate <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
        stringArray[22] = Intl.intl("Deactivate <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
        stringArray[23] = Intl.intl("Deactivate <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
        stringArray[24] = Intl.intl("Delay deactivation by <%1>.");
        stringArray[25] = Intl.intl("Delay activation by <%1>.");
        stringArray[26] = Intl.intl("Activate <%1> at t = <%3>.");
        stringArray[27] = Intl.intl("Deactivate <%1> at t = <%3>.");
        stringArray[28] = Intl.intl("Activate and deactivate <%1> based on the following sequence of events:");
        stringArray[29] = Intl.intl("Activate and deactivate <%1> based on multiple timed events.");
        stringArray[30] = Intl.intl("Turn <%1off> <%2> when <%4> falls below <%6> and turn <%8on> when %5$s rises above <%9>.");
        stringArray[31] = Intl.intl("Turn <%1on> <%2> when <%4> falls below <%6> and turn <%8off> when %5$s rises above <%9>.");
        stringArray[32] = Intl.intl("<%1> exists when <%3> is true.");
        stringArray[33] = Intl.intl("<%1> exist when <%3> is true.");
        stringArray[34] = Intl.intl("Activation is based on custom logic.");
        return strings;
    }

    private static Strings freeze() {
        Strings strings = new Strings(Intl.intl("<Never>"), Intl.intl("freeze"), Intl.intl("unfreeze"), Intl.intl("Freeze"), Intl.intl("Unfreeze"));
        String[] stringArray = strings.values;
        stringArray[0] = Intl.intl("Freeze <%1> when <%3> <%5activates>.");
        stringArray[1] = Intl.intl("Freeze <%1> when <%3> <%5deactivates>.");
        stringArray[2] = Intl.intl("Unfreeze <%1> when <%3> <%5activates>.");
        stringArray[3] = Intl.intl("Unfreeze <%1> when <%3> <%5deactivates>.");
        stringArray[4] = Intl.intl("Freeze <%1> when <%3any of> <%4> <%6activates>.");
        stringArray[5] = Intl.intl("Freeze <%1> when <%3any of> <%4> <%6deactivates>.");
        stringArray[6] = Intl.intl("Freeze <%1> when <%3all of> <%4> <%6activate>.");
        stringArray[7] = Intl.intl("Freeze <%1> when <%3all of> <%4> <%6deactivate>.");
        stringArray[8] = Intl.intl("Freeze <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
        stringArray[9] = Intl.intl("Freeze <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
        stringArray[10] = Intl.intl("Freeze <%1> when <%3at least> <%4> of <%6> <%8activate>.");
        stringArray[11] = Intl.intl("Freeze <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
        stringArray[12] = Intl.intl("Freeze <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
        stringArray[13] = Intl.intl("Freeze <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
        stringArray[14] = Intl.intl("Unfreeze <%1> when <%3any of> <%4> <%6activates>.");
        stringArray[15] = Intl.intl("Unfreeze <%1> when <%3any of> <%4> <%6deactivates>.");
        stringArray[16] = Intl.intl("Unfreeze <%1> when <%3all of> <%4> <%6activate>.");
        stringArray[17] = Intl.intl("Unfreeze <%1> when <%3all of> <%4> <%6deactivate>.");
        stringArray[18] = Intl.intl("Unfreeze <%1> when <%3no more than> <%4> of <%6> <%8activate>.");
        stringArray[19] = Intl.intl("Unfreeze <%1> when <%3no more than> <%4> of <%6> <%8deactivate>.");
        stringArray[20] = Intl.intl("Unfreeze <%1> when <%3at least> <%4> of <%6> <%8activate>.");
        stringArray[21] = Intl.intl("Unfreeze <%1> when <%3at least> <%4> of <%6> <%8deactivate>.");
        stringArray[22] = Intl.intl("Unfreeze <%1> when <%3exactly> <%4> of <%6> <%8activate>.");
        stringArray[23] = Intl.intl("Unfreeze <%1> when <%3exactly> <%4> of <%6> <%8deactivate>.");
        stringArray[24] = Intl.intl("Delay unfreezing by <%1>.");
        stringArray[25] = Intl.intl("Delay freezing by <%1>.");
        stringArray[26] = Intl.intl("Freeze <%1> at t = <%3>.");
        stringArray[27] = Intl.intl("Unfreeze <%1> at t = <%3>.");
        stringArray[28] = Intl.intl("Freeze and unfreeze <%1> based on the following sequence of events:");
        stringArray[29] = Intl.intl("Freeze and unfreeze <%1> based on multiple timed events.");
        stringArray[30] = Intl.intl("<%1Unfreeze> <%2> when <%4> falls below <%6> and <%8freeze> when %5$s rises above <%9>.");
        stringArray[31] = Intl.intl("<%1Freeze> <%2> when <%4> falls below <%6> and <%8unfreeze> when %5$s rises above <%9>.");
        stringArray[32] = Intl.intl("<%1> freezes when <%3> is true.");
        stringArray[33] = Intl.intl("<%1> freeze when <%3> is true.");
        stringArray[34] = Intl.intl("Freezing is based on custom logic.");
        return strings;
    }

    static /* synthetic */ Strings access$000() {
        return ControlDesc.activate();
    }

    static /* synthetic */ Strings access$100() {
        return ControlDesc.freeze();
    }

    public static class Strings {
        public final String defaultDesc;
        public final String on;
        public final String off;
        public final String activate;
        public final String deactivate;
        public final String[] values = new String[35];

        public Strings(String string, String string2, String string3, String string4, String string5) {
            this.defaultDesc = string;
            this.on = string2;
            this.off = string3;
            this.activate = string4;
            this.deactivate = string5;
        }
    }

    private static class DupAccumulation {
        private static final int ACCUM_LATCH = 0;
        private static final int ACCUM_INVERT = 1;
        private static final int ACCUM_TDELAY = 2;
        private static final int ACCUM_NONE = 3;
        private boolean d_latch = false;
        private int d_invertCount = 0;
        private UnitDouble d_delay = new UnitDouble(0.0, SI.SECOND);
        private Collection<? extends IOutPin> d_nextInputs;

        public DupAccumulation(Collection<? extends IOutPin> collection) {
            this.d_nextInputs = collection;
        }

        public int getAccumType() {
            if (this.d_latch) {
                return 0;
            }
            if (this.d_invertCount > 0) {
                return 1;
            }
            if (this.d_delay.getValueNoUnit() > 0.0) {
                return 2;
            }
            return 3;
        }
    }

    public static enum SinkType {
        ACTIVATE(ControlDesc.access$000()),
        FREEZE(ControlDesc.access$100());

        public final Strings strings;

        private SinkType(Strings strings) {
            this.strings = strings;
        }
    }
}

