/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;

public class SurfaceComboBox
extends PyroComboBox<Surface> {
    private static final long serialVersionUID = 7715103452632457968L;

    public SurfaceComboBox(SurfaceManager surfaceManager, Surface surface) {
        super((IPyroObject)surfaceManager, surface, Surface.class);
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new MaterialCellRenderer();
    }

    private class MaterialCellRenderer
    extends PyroComboBox.UniqueObjCBRenderer {
        private static final long serialVersionUID = 816828011858960319L;
        private Font d_predefFont = new Font("Sans Serif", 0, 11);
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        private MaterialCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            Surface surface = (Surface)object;
            if (surface == null) {
                return this;
            }
            if (surface.isPredefined()) {
                this.setFont(this.d_predefFont);
            } else {
                this.setFont(this.d_normalFont);
            }
            TVEntryPoint<Surface> tVEntryPoint = TVEntryPoints.ep(surface);
            if (tVEntryPoint != null) {
                Icon[] iconArray = tVEntryPoint.getIcons(PyroSim.getApp().getMediator(), surface);
                this.setIcon(iconArray[0]);
                this.setDisabledIcon(iconArray[1]);
            }
            this.setEnabled(SurfaceComboBox.this.isEnabled());
            return this;
        }
    }
}

