/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.theUtil;

public class QuantityComboBox
extends guiComboBox<IQuantity> {
    private static final long serialVersionUID = -4971250756057794463L;
    private final String d_nullName;
    private final Set<ObjectQuantity> d_importedObjMsrs = new LinkedHashSet<ObjectQuantity>();
    private boolean d_expandObjMsrs;
    private Predicate<Quantity> d_filter;

    public QuantityComboBox() {
        this(Filters.acceptAll(Quantity.class));
    }

    public QuantityComboBox(int n, QuantityType ... quantityTypeArray) {
        this(new QuantityUtil.TypeFilter(n, quantityTypeArray));
    }

    public QuantityComboBox(Predicate<Quantity> predicate) {
        this(null, predicate);
    }

    public QuantityComboBox(String string, Predicate<Quantity> predicate) {
        this.d_nullName = string;
        this.d_filter = predicate;
        this.setMaximumRowCount(12);
        this.d_expandObjMsrs = false;
        this.updateList((IQuantity)this.getSelectedItem());
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 39318149364329461L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                if (object instanceof Component) {
                    return (Component)object;
                }
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object == null) {
                    if (QuantityComboBox.this.d_nullName == null) {
                        return this;
                    }
                    string = QuantityComboBox.this.d_nullName;
                } else {
                    string = object instanceof IQuantity ? ((IQuantity)object).getDescription() : object.toString();
                }
                this.setText(string);
                return this;
            }
        });
        this.setMinimumSize(this.getPreferredSize());
    }

    public Predicate<Quantity> getFilter() {
        return this.d_filter;
    }

    public void setFilter(Predicate<Quantity> predicate) {
        if (predicate == this.d_filter) {
            return;
        }
        this.d_filter = predicate;
        this.updateList((IQuantity)this.getSelectedItem());
    }

    public void setObjectMsrsExpanded(boolean bl) {
        if (this.d_expandObjMsrs == bl) {
            return;
        }
        this.d_expandObjMsrs = bl;
        this.updateList((IQuantity)this.getSelectedItem());
    }

    protected void updateList(IQuantity iQuantity) {
        Object object;
        IQuantity iQuantity2 = (IQuantity)this.getSelectedItem();
        ArrayList arrayList = new ArrayList();
        if (this.d_nullName != null) {
            arrayList.add(null);
        }
        arrayList.addAll(this.getDefaultList());
        this.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray(new Object[arrayList.size()])));
        if (!arrayList.contains(iQuantity)) {
            iQuantity = null;
            for (Object e : arrayList) {
                if (!(e instanceof IQuantity)) continue;
                iQuantity = (IQuantity)e;
                break;
            }
            this.setSelectedItem(iQuantity);
        } else if (theUtil.equal(iQuantity, iQuantity2)) {
            object = this.getActionListeners();
            ItemListener[] itemListenerArray = this.getItemListeners();
            for (Object object2 : object) {
                this.removeActionListener((ActionListener)object2);
            }
            for (ItemListener itemListener : itemListenerArray) {
                this.removeItemListener(itemListener);
            }
            this.setSelectedItem(iQuantity);
            for (Object object2 : object) {
                this.addActionListener((ActionListener)object2);
            }
            for (ItemListener itemListener : itemListenerArray) {
                this.addItemListener(itemListener);
            }
        } else {
            this.setSelectedItem(iQuantity);
        }
        object = SwingUtilities.getWindowAncestor(this);
        if (object != null) {
            ((Window)object).pack();
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object instanceof ObjectQuantEntry) {
            ObjQuantDlg objQuantDlg = new ObjQuantDlg(this, (ObjectQuantEntry)object, this.d_filter);
            this.setPopupVisible(false);
            if (objQuantDlg.doModal() == 1) {
                this.setSelectedItem(objQuantDlg.saveData());
            }
        } else if (object instanceof ObjectQuantity) {
            if (this.d_importedObjMsrs.add((ObjectQuantity)object)) {
                this.updateList((ObjectQuantity)object);
            } else {
                super.setSelectedItem(object);
            }
        } else if (!(object instanceof Component)) {
            super.setSelectedItem(object);
        }
    }

    protected Collection<?> getDefaultList() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (this.d_expandObjMsrs) {
            List<ObjectQuantity> list = QuantityUtil.generateAllObjectQuanties(PyroSim.getApp().getMediator(), this.d_filter, true);
            linkedHashSet.addAll(list);
        } else {
            List<ObjectQuantEntry> list = this.getCollapsedObjectEntries();
            if (!list.isEmpty()) {
                linkedHashSet.addAll(list);
                linkedHashSet.add(new JSeparator());
            }
        }
        if (this.d_importedObjMsrs != null && !this.d_importedObjMsrs.isEmpty()) {
            linkedHashSet.addAll(this.d_importedObjMsrs);
            linkedHashSet.add(new JSeparator());
        }
        linkedHashSet.addAll(QuantityUtil.generateStaticQuantities(this.d_filter, true));
        return linkedHashSet;
    }

    private List<ObjectQuantEntry> getCollapsedObjectEntries() {
        Map<String, List<Quantity>> map = QuantityUtil.groupObjQuantities();
        Predicate<Quantity> predicate = new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity quantity) {
                for (int i = 0; i < quantity.getNumArgs(); ++i) {
                    Collection<? extends IPyroObject> collection = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), quantity, i);
                    if (!collection.isEmpty()) continue;
                    return false;
                }
                return true;
            }
        };
        Predicate<Quantity> predicate2 = this.d_filter.and(predicate);
        ArrayList<ObjectQuantEntry> arrayList = new ArrayList<ObjectQuantEntry>();
        for (Map.Entry<String, List<Quantity>> entry : map.entrySet()) {
            if (theUtil.filter((Collection)entry.getValue(), predicate2).isEmpty()) continue;
            Collection<Quantity> collection = QuantityUtil.sort((Collection<Quantity>)entry.getValue());
            ObjectQuantEntry objectQuantEntry = new ObjectQuantEntry(QuantityUtil.getDefaultQuantForCategory(entry.getKey()), collection.toArray(new Quantity[collection.size()]));
            arrayList.add(objectQuantEntry);
        }
        Collections.sort(arrayList, new ANameSorter<ObjectQuantEntry>(){

            @Override
            protected String getName(ObjectQuantEntry objectQuantEntry) {
                return objectQuantEntry.comboDesc;
            }
        });
        return arrayList;
    }

    private static class ObjQuantDlg
    extends guiDialog {
        private static final long serialVersionUID = 1891475417110161943L;
        private final guiComboBox<Quantity> d_quantCB;
        private final ObjectPanel d_objectPnl;

        public ObjQuantDlg(Component component, ObjectQuantEntry objectQuantEntry, Predicate<Quantity> predicate) {
            super(SwingUtilities.getWindowAncestor(component), Intl.intl("Choose Quantity"), 9);
            Predicate<Quantity> predicate2 = new Predicate<Quantity>(){

                @Override
                public boolean test(Quantity quantity) {
                    for (int i = 0; i < quantity.getNumArgs(); ++i) {
                        Collection<? extends IPyroObject> collection = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), quantity, i);
                        if (!collection.isEmpty()) continue;
                        return false;
                    }
                    return true;
                }
            };
            predicate = predicate.and(predicate2);
            this.d_quantCB = new guiComboBox<Quantity>((Collection<Quantity>)theUtil.filter(Arrays.asList(objectQuantEntry.quantities), predicate));
            this.d_quantCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -6557235785954199277L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof Quantity) {
                        Quantity quantity = (Quantity)((Object)object);
                        this.setText(quantity.name);
                    }
                    return component;
                }
            });
            this.d_objectPnl = new ObjectPanel();
            this.d_quantCB.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.d_objectPnl.update();
                    this.updateLayout();
                    this.pack();
                }
            });
            if (objectQuantEntry.preferredDefault != null) {
                this.d_quantCB.setSelectedItem((Object)objectQuantEntry.preferredDefault);
            }
            this.updateLayout();
        }

        private void updateLayout() {
            this.getDialogPane().removeAll();
            GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane(), true);
            gridBagHelper.addRow(Intl.intl("Quantity:"), this.d_quantCB);
            for (int i = 0; i < this.d_objectPnl.d_objectLabels.length; ++i) {
                gridBagHelper.addRow(this.d_objectPnl.d_objectLabels[i] + ":", this.d_objectPnl.d_objectCBs[i], 1.0);
            }
            gridBagHelper.finalizeRows();
        }

        public ObjectQuantity saveData() {
            Quantity quantity = this.d_quantCB.getSelectedItem();
            return quantity.create(this.d_objectPnl.saveData());
        }

        private class ObjectPanel
        extends guiPanel {
            private static final long serialVersionUID = -3976662525118510111L;
            private guiComboBox<? extends IPyroObject>[] d_objectCBs;
            private String[] d_objectLabels;

            public ObjectPanel() {
                this.update();
            }

            public void update() {
                int n;
                this.removeAll();
                GridBagHelper gridBagHelper = new GridBagHelper(this);
                Quantity quantity = (Quantity)((Object)ObjQuantDlg.this.d_quantCB.getSelectedItem());
                int n2 = this.d_objectCBs == null ? 0 : this.d_objectCBs.length;
                IPyroObject[] iPyroObjectArray = new IPyroObject[n2];
                if (n2 > 0) {
                    for (n = 0; n < this.d_objectCBs.length; ++n) {
                        iPyroObjectArray[n] = this.d_objectCBs[n].getSelectedItem();
                    }
                }
                this.d_objectCBs = new guiComboBox[quantity.getNumArgs()];
                this.d_objectLabels = new String[quantity.getNumArgs()];
                for (n = 0; n < quantity.getNumArgs(); ++n) {
                    Collection<? extends IPyroObject> collection = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), quantity, n);
                    this.d_objectCBs[n] = new guiComboBox<IPyroObject>((Collection<? extends IPyroObject>)Util.sort(collection));
                    this.d_objectCBs[n].setRenderer(new DefaultListCellRenderer(){
                        private static final long serialVersionUID = -8989509286590543699L;

                        @Override
                        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                            if (object instanceof INamed) {
                                this.setText(((INamed)object).getName());
                            }
                            return component;
                        }
                    });
                    if (n < iPyroObjectArray.length && collection.contains(iPyroObjectArray[n])) {
                        this.d_objectCBs[n].setSelectedItem(iPyroObjectArray[n]);
                    }
                    Class<? extends IPyroObject> clazz = quantity.requiredTypes[n];
                    this.d_objectLabels[n] = TVEntryPoints.ep(clazz).getCategoryName();
                }
                gridBagHelper.finalizeRows();
            }

            public IPyroObject[] saveData() {
                IPyroObject[] iPyroObjectArray = new IPyroObject[this.d_objectCBs.length];
                for (int i = 0; i < iPyroObjectArray.length; ++i) {
                    iPyroObjectArray[i] = this.d_objectCBs[i].getSelectedItem();
                }
                return iPyroObjectArray;
            }
        }
    }

    private static class ObjectQuantEntry {
        public final Quantity[] quantities;
        public final Quantity preferredDefault;
        public final String typeName;
        public final String comboDesc;

        public ObjectQuantEntry(Quantity quantity, Quantity ... quantityArray) {
            this.quantities = quantityArray;
            this.preferredDefault = quantity;
            assert (quantityArray[0].category != null);
            this.typeName = quantityArray[0].category;
            this.comboDesc = String.format(Intl.intl("[%s Quantity]..."), this.typeName);
        }

        public String toString() {
            return this.comboDesc;
        }
    }
}

