/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.function.Predicate;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.theUtil;

public class PyroComboBox<T extends IPyroObject>
extends guiComboBox<T>
implements IEventObserver {
    private static final long serialVersionUID = -5876637113437920205L;
    private final Class<T> d_objType;
    private final IPyroObject d_manager;
    private final String d_nullName;
    private Predicate<T> d_filter;
    private boolean d_includeImplicitObjs;

    public PyroComboBox(IPyroObject iPyroObject, Class<T> clazz) {
        this(iPyroObject, (IPyroObject)null, clazz);
        this.selectFirstInstance();
    }

    public PyroComboBox(IPyroObject iPyroObject, String string, Class<T> clazz) {
        this(iPyroObject, null, string, clazz);
        this.selectFirstInstance();
    }

    public PyroComboBox(IPyroObject iPyroObject, T t, Class<T> clazz) {
        this(iPyroObject, t, null, clazz);
    }

    public PyroComboBox(IPyroObject iPyroObject, T t, String string, Class<T> clazz) {
        this.d_manager = iPyroObject;
        this.d_objType = clazz;
        this.d_nullName = string;
        this.d_filter = Filters.acceptAll();
        this.setRenderer(this.createRenderer());
        Collection<?> collection = this.getObjList();
        this.setModel(this.createModel(collection.toArray(new Object[collection.size()])));
        this.setSelectedItem(t);
        if (iPyroObject.getDomain() != null) {
            ((PyroMod)iPyroObject.getDomain()).getEvents().addObserver(this);
        }
        this.setMinimumSize(this.getPreferredSize());
    }

    protected void selectFirstInstance() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object e = this.getModel().getElementAt(i);
            if (!this.d_objType.isInstance(e)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    protected ComboBoxModel createModel(Object[] objectArray) {
        return new DefaultComboBoxModel<Object>(objectArray);
    }

    public IPyroObject getManager() {
        return this.d_manager;
    }

    public Predicate<T> getFilter() {
        return this.d_filter;
    }

    public void setFilter(Predicate<T> predicate) {
        assert (predicate != null);
        this.d_filter = predicate;
        this.updateList();
    }

    protected ListCellRenderer createRenderer() {
        return new UniqueObjCBRenderer();
    }

    protected String getObjName(IPyroObject iPyroObject, T t) {
        return Util.getName(t);
    }

    protected Collection<?> getDefaultList() {
        ANameSorter aNameSorter = new ANameSorter<T>(){

            @Override
            protected String getName(T t) {
                return PyroComboBox.this.getObjName(PyroComboBox.this.d_manager, t);
            }
        };
        Collection<T> collection = Hierarchy.flatten(this.d_manager.getMembers(), this.d_objType, this.d_filter);
        Collection<T> collection2 = theUtil.sort(aNameSorter, collection);
        return collection2;
    }

    protected Collection<?> getObjList() {
        Collection<?> collection = this.getDefaultList();
        if (this.d_nullName != null) {
            ArrayList arrayList = new ArrayList(collection.size() + 1);
            arrayList.add(null);
            arrayList.addAll(collection);
            return arrayList;
        }
        return collection;
    }

    private T findFirstInstance(Collection<?> collection) {
        for (Object obj : collection) {
            if (!this.d_objType.isInstance(obj)) continue;
            return (T)((IPyroObject)this.d_objType.cast(obj));
        }
        return null;
    }

    private boolean isInList(Collection<?> collection, T t) {
        for (Object obj : collection) {
            if (t != obj) continue;
            return true;
        }
        return false;
    }

    protected void updateList() {
        IPyroObject iPyroObject = (IPyroObject)this.getSelectedItem();
        Collection<?> collection = this.getObjList();
        IPyroObject iPyroObject2 = iPyroObject == null || this.isInList(collection, iPyroObject) ? iPyroObject : this.findFirstInstance(collection);
        this.setModel(this.createModel(collection.toArray(new Object[collection.size()])));
        if (iPyroObject2 != iPyroObject) {
            this.setSelectedItem(iPyroObject2);
        } else {
            ActionListener[] actionListenerArray = this.getActionListeners();
            ItemListener[] itemListenerArray = this.getItemListeners();
            for (ActionListener eventListener : actionListenerArray) {
                this.removeActionListener(eventListener);
            }
            for (EventListener eventListener : itemListenerArray) {
                this.removeItemListener((ItemListener)eventListener);
            }
            this.setSelectedItem(iPyroObject2);
            for (EventListener eventListener : actionListenerArray) {
                this.addActionListener((ActionListener)eventListener);
            }
            for (EventListener eventListener : itemListenerArray) {
                this.addItemListener((ItemListener)eventListener);
            }
            this.setModified(false);
        }
    }

    @Override
    public void update(Events events) {
        if (!events.getAffectedChannels(this.d_objType, new Class[0]).isEmpty() || !events.getAffectedChannels(this.d_manager.getClass(), new Class[0]).isEmpty()) {
            this.updateList();
        }
    }

    protected class UniqueObjCBRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4890010126789220647L;

        protected UniqueObjCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object instanceof Component) {
                return (Component)object;
            }
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                if (PyroComboBox.this.d_nullName == null) {
                    return this;
                }
                string = PyroComboBox.this.d_nullName;
            } else {
                string = PyroComboBox.this.d_objType.isInstance(object) ? PyroComboBox.this.getObjName(PyroComboBox.this.d_manager, (IPyroObject)object) : object.toString();
            }
            this.setText(string);
            return this;
        }
    }
}

