/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.guiComboBox;

public class CompositeComboBox<T extends IPyroObject>
extends guiComboBox<Composite<T>> {
    private static final long serialVersionUID = 2459551803233136512L;
    private Composite<T> d_root;

    public CompositeComboBox(Composite<T> composite) {
        this.setRenderer(new CompositeListRenderer());
        this.d_root = composite;
        this.update();
    }

    public void setRoot(Composite<T> composite) {
        this.d_root = composite;
        this.update();
        this.repaint();
    }

    public void update() {
        Composite composite = (Composite)this.getSelectedItem();
        Collection<Composite> collection = Hierarchy.flatten(Arrays.asList(this.d_root), Composite.class);
        DefaultComboBoxModel<Composite> defaultComboBoxModel = new DefaultComboBoxModel<Composite>(collection.toArray(new Composite[collection.size()]));
        this.setModel(defaultComboBoxModel);
        if (composite != null) {
            this.setSelectedItem(composite);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 150) {
            dimension.width = 150;
        }
        return dimension;
    }

    public void setSelectedComposite(Composite<T> composite) {
        this.setSelectedItem(composite);
    }

    public Composite<T> getSelectedComposite() {
        return (Composite)this.getSelectedItem();
    }

    private int getDepth(Composite composite) {
        int n = 0;
        for (IPyroObject iPyroObject = composite; iPyroObject != this.d_root && iPyroObject != null; iPyroObject = iPyroObject.getParent()) {
            ++n;
        }
        return n;
    }

    private class CompositeListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4709447998906858843L;
        private static final int OFFSET = 16;

        private CompositeListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Composite) {
                Composite composite = (Composite)object;
                jLabel.setText(composite.getName());
                PyroMod pyroMod = (PyroMod)composite.getDomain();
                Icon[] iconArray = TVEntryPoints.ep(composite).getIcons(pyroMod, composite);
                jLabel.setIcon(iconArray[0]);
                jLabel.setDisabledIcon(iconArray[1]);
                int n2 = jLabel.getInsets().left + CompositeComboBox.this.getDepth(composite) * 16;
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, n2, 0, 0));
            }
            return jLabel;
        }
    }
}

