/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;

public class SurfacePanelEditCompDlg
extends guiDialog {
    private static final long serialVersionUID = 6170676201237742926L;
    private guiTableEditor d_editor;
    private guiTable d_table;
    private final Collection<SurfComposition.SurfLayer.SurfComponent> d_surfComp;
    private final MaterialManager d_matMgr;
    private final int d_rowLimit = 20;

    public SurfacePanelEditCompDlg(Collection<SurfComposition.SurfLayer.SurfComponent> collection, MaterialManager materialManager) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Composition"), 9);
        this.d_surfComp = collection;
        this.d_matMgr = materialManager;
        String[] stringArray = new String[]{Intl.intl("Mass Fraction"), Intl.intl("Material")};
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        this.d_table = guiTableUtil.fixedColumnTable(stringArray, new Class[]{Double.class, String.class});
        this.d_table.setRowLimit(20);
        List<Material> list = Util.sort(this.d_matMgr);
        String[] stringArray2 = new String[list.size()];
        int n = 0;
        for (Material material : list) {
            stringArray2[n++] = material.getName();
        }
        this.d_table.setColumnOptions(1, stringArray2);
        this.d_table.setNullValuesAllowed(false);
        this.d_editor = new guiTableEditor(this.d_table, 30);
        this.d_editor.setPreferredSize(new Dimension(410, 250));
        GridBagUtil.add(guiPanel2, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        this.d_editor.getTable().autoSizeColumns(200);
        this.loadData();
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastRampDlgSizeX.key.toString(), PyroPrefs.LastRampDlgSizeY.key.toString());
    }

    private boolean noDuplicates(TableModel tableModel) {
        int n = tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!tableModel.getValueAt(i, 1).equals(tableModel.getValueAt(j, 1))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean massFracOne(TableModel tableModel) {
        int n = tableModel.getRowCount();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += ((Double)tableModel.getValueAt(i, 0)).doubleValue();
        }
        return !(d < 0.999999) && !(d > 1.000001);
    }

    private void loadData() {
        if (this.d_surfComp == null) {
            return;
        }
        ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_table.getModel();
        int n = 0;
        for (SurfComposition.SurfLayer.SurfComponent surfComponent : this.d_surfComp) {
            Object[] objectArray = new Object[]{surfComponent.d_massFraction, surfComponent.d_material.getName()};
            resizableTableModel.insertRow(n++, objectArray);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        TableModel tableModel = this.d_editor.getTable().getModel();
        if (!this.noDuplicates(tableModel)) {
            String string = Intl.intl("Error: Duplicate materials are not permitted.");
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        if (!this.massFracOne(tableModel)) {
            String string = Intl.intl("Error: Mass fraction must add up to 1");
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    public Collection<SurfComposition.SurfLayer.SurfComponent> getSurfComponent() {
        int n = this.d_table.getRowCount();
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(n);
        for (int i = 0; i < n; ++i) {
            if (this.d_table.getValueAt(i, 0) == null || this.d_table.getValueAt(i, 1) == null) continue;
            double d = (Double)this.d_table.getValueAt(i, 0);
            Material material = (Material)this.d_matMgr.get((String)this.d_table.getValueAt(i, 1));
            arrayList.add(new SurfComposition.SurfLayer.SurfComponent(d, material));
        }
        return arrayList;
    }
}

