/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.LeakUtil;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.appearance.MaterialBtn;
import pyrosim.gui.boundcond.SurfacePanelEditCompDlg;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.comboboxes.ZoneComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.DefaultTableClipboard;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SurfacePanel
extends guiPanel
implements IEditor<Surface> {
    private static final long serialVersionUID = -5319937567981882745L;
    private final guiTextField d_surfID;
    private final guiTextField d_fyi;
    private final ColorButton d_color;
    private final MaterialBtn d_appearance;
    private final guiComboBox<String> d_profileListBox;
    private final JTabbedPane d_tabs;
    private final guiDialog d_parent;
    private final SurfacePanel d_surfPanel;
    private final BurnerPanel d_burnerPanel;
    private final SpecInjPanel d_specInjPanel;
    private final PartInjPanel d_partInjPanel;
    private final ThermalPanel d_thermalPanel;
    private final GeomPanel d_geomPanel;
    private final GeomPanelLayered d_GeomPanelLayered;
    private final AirFlowPanel d_airFlowPanel;
    private final ReactionPanel d_reactionPanel;
    private final LayersPanel d_layersPanel;
    private final LayersPropPanel d_layerPropPanel;
    private final ItemListener d_surfTypeItemListener;
    private final LeakPanel d_leakPanel;
    private final CustomFDSPanel d_advancedPanel;
    private final guiPanel d_inertDescPanel;
    private final guiPanel d_mirroredDescPanel;
    private final guiPanel d_hvacDescPanel;
    private final guiPanel d_openDescPanel;
    private final guiPanel d_adiabaticDescPanel;
    private final guiPanel d_periodicDescPanel;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final ChangeListener d_layeredGeomListener;
    private final SurfaceManager d_surfMgr;
    private final MaterialManager d_matMgr;
    private Surface d_currentSurf;
    private ExSpecList d_exSpecList;
    public static final String INERT = Intl.intl("Inert");
    public static final String BASIC = Intl.intl("Basic");
    public static final String ADIABATIC = Intl.intl("Adiabatic");
    public static final String MIRROR = Intl.intl("Mirror");
    public static final String OPEN = Intl.intl("Open");
    public static final String HVAC = Intl.intl("HVAC");
    public static final String PERIODIC = Intl.intl("Periodic");
    public static final String BURNER = Intl.intl("Burner");
    public static final String CONSTANT_TEMP = Intl.intl("Heater / Cooler");
    public static final String GENERAL = Intl.intl("General Surface");
    public static final String LAYERED = Intl.intl("Layered");
    public static final String SUPPLY = Intl.intl("Supply");
    public static final String EXHAUST = Intl.intl("Exhaust");
    public static final String AIR_FLOW = Intl.intl("Air Flow");
    public static final String AIR_DUCT = Intl.intl("Air Duct");
    public static final String LEAK = Intl.intl("Air Leak");
    public static final String SPECIES_INJECTION = Intl.intl("Species Injection");
    public static final String PARTICLE_INJECTION = Intl.intl("Particle Injection");
    public static final String HEAT_RELEASE = Intl.intl("Heat Release");
    public static final String GEOMETRY = Intl.intl("Geometry");
    public static final String TEMPERATURE = Intl.intl("Temperature");
    public static final String THERMAL = Intl.intl("Thermal");
    public static final String ADVANCED = Intl.intl("Advanced");
    public static final String LAYERS = Intl.intl("Material Layers");
    public static final String CALC_TEMP_OPT = Intl.intl("Temperature Calculated");
    public static final String ADIABATIC_OPT = Intl.intl("Adiabatic");
    public static final String FIXED_TEMP_OPT = Intl.intl("Fixed Temperature");
    public static final String NETFLUX_OPT = Intl.intl("Net Heat Flux");
    public static final String TOTALFLUX_OPT = Intl.intl("Total Heat Flux");

    public SurfacePanel(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_surfMgr = pyroMod.getSurfaceMgr();
        this.d_matMgr = pyroMod.getMaterialMgr();
        this.d_exSpecList = pyroMod.getExSpecList();
        this.d_surfPanel = this;
        this.setLayout(new GridBagLayout());
        this.d_parent = guiDialog2;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Surface ID:"));
        guiLabel2.setToolTipText("ID");
        this.d_surfID = new guiTextField();
        this.d_surfID.setEditable(false);
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Description:"));
        guiLabel3.setToolTipText("FYI");
        this.d_fyi = new guiTextField();
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Color:"));
        String string = "<html>" + Intl.intl("Specifies the color of objects using this surface in the absense<br>of an appearance and object color.") + "</html>";
        guiLabel4.setToolTipText(string);
        this.d_color = new ColorButton();
        this.d_color.setMinimumSize(this.d_color.getPreferredSize());
        this.d_color.addObserver(this.d_comm);
        guiLabel guiLabel5 = new guiLabel(Intl.intl("Appearance:"));
        String string2 = "<html>" + Intl.intl("Controls how objects using this surface appear in the 3D and 2D<br>views when appearances are enabled.") + "</html>";
        guiLabel5.setToolTipText(string2);
        this.d_appearance = new MaterialBtn(true);
        this.d_appearance.setMinimumSize(this.d_appearance.getPreferredSize());
        this.d_appearance.addObserver(new IObserver(){

            @Override
            public void update(IObservable iObservable, Object object) {
                SurfacePanel.this.d_comm.touch(object);
            }
        }, false);
        this.d_burnerPanel = new BurnerPanel();
        this.d_specInjPanel = new SpecInjPanel();
        this.d_partInjPanel = new PartInjPanel();
        this.d_airFlowPanel = new AirFlowPanel();
        this.d_reactionPanel = new ReactionPanel();
        this.d_layersPanel = new LayersPanel();
        this.d_layerPropPanel = new LayersPropPanel();
        this.d_leakPanel = new LeakPanel();
        this.d_thermalPanel = new ThermalPanel();
        this.d_geomPanel = new GeomPanel();
        this.d_GeomPanelLayered = new GeomPanelLayered();
        this.d_advancedPanel = new CustomFDSPanel(7);
        this.d_inertDescPanel = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(this.d_inertDescPanel, true);
        MultiLineLabel multiLineLabel = new MultiLineLabel(Intl.intl("The default FDS boundary condition representing a smooth wall with fixed temperature, TMPA, and emissivity, 0.9. Radiative and convective heat transfer is calculated."));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(2));
        multiLineLabel.setPreferredWidth(400);
        gridBagHelper.addRow(multiLineLabel);
        gridBagHelper.finalizeRows();
        this.d_openDescPanel = new guiPanel();
        gridBagHelper = new GridBagHelper(this.d_openDescPanel, true);
        multiLineLabel = new MultiLineLabel(Intl.intl("An FDS surface representing an opening on the boundary of the computational domain."));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(2));
        multiLineLabel.setPreferredWidth(400);
        gridBagHelper.addRow(multiLineLabel);
        gridBagHelper.finalizeRows();
        this.d_mirroredDescPanel = new guiPanel();
        gridBagHelper = new GridBagHelper(this.d_mirroredDescPanel, true);
        multiLineLabel = new MultiLineLabel(Intl.intl("An FDS surface used to denote a symmetry plane across which the flow is exactly opposite on the other side."));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(2));
        multiLineLabel.setPreferredWidth(400);
        gridBagHelper.addRow(multiLineLabel);
        gridBagHelper.finalizeRows();
        this.d_hvacDescPanel = new guiPanel();
        gridBagHelper = new GridBagHelper(this.d_hvacDescPanel, true);
        multiLineLabel = new MultiLineLabel(Intl.intl("An FDS surface used to denote vents that connect an HVAC system to the computational mesh."));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(2));
        multiLineLabel.setPreferredWidth(400);
        gridBagHelper.addRow(multiLineLabel);
        gridBagHelper.finalizeRows();
        this.d_adiabaticDescPanel = new guiPanel();
        gridBagHelper = new GridBagHelper(this.d_adiabaticDescPanel, true);
        multiLineLabel = new MultiLineLabel(Intl.intl("A surface where there is no net heat transfer. FDS internally calculates the wall temperature to assure the sum of the radiative and convective heat flux is zero."));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(2));
        multiLineLabel.setPreferredWidth(400);
        gridBagHelper.addRow(multiLineLabel);
        gridBagHelper.finalizeRows();
        this.d_periodicDescPanel = new guiPanel();
        gridBagHelper = new GridBagHelper(this.d_periodicDescPanel, true);
        multiLineLabel = new MultiLineLabel(Intl.intl("An FDS surface which can be used with vents on the boundary of the domain to define a periodic boundary condition."));
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(2));
        multiLineLabel.setPreferredWidth(400);
        gridBagHelper.addRow(multiLineLabel);
        gridBagHelper.finalizeRows();
        int n = 0;
        GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_surfID, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_fyi, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_color, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0);
        GridBagUtil.add(this, guiLabel5, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_appearance, 3, n++, 1, 1, 0, 0, 6, 12, 0, 1.0, 0.0);
        this.d_layeredGeomListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (SurfacePanel.this.d_tabs.getSelectedIndex() == -1) {
                    return;
                }
                if (SurfacePanel.this.d_tabs.getTitleAt(SurfacePanel.this.d_tabs.getSelectedIndex()).equals(GEOMETRY)) {
                    SurfacePanel.this.d_GeomPanelLayered.updateThicknessLbl();
                }
            }
        };
        this.d_surfTypeItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = itemEvent.getItem().toString();
                SurfacePanel.this.d_tabs.removeAll();
                SurfacePanel.this.d_tabs.removeChangeListener(SurfacePanel.this.d_layeredGeomListener);
                SurfacePanel.this.setModified(true);
                if (LAYERED.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(LAYERS, SurfacePanel.this.d_layersPanel);
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Surface Props"), SurfacePanel.this.d_layerPropPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_GeomPanelLayered);
                    SurfacePanel.this.d_tabs.addChangeListener(SurfacePanel.this.d_layeredGeomListener);
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Reaction"), SurfacePanel.this.d_reactionPanel);
                    SurfacePanel.this.d_reactionPanel.allowBurnAway(true);
                    SurfacePanel.this.d_tabs.addTab(SPECIES_INJECTION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(true, true);
                    SurfacePanel.this.d_thermalPanel.updateOptions(CALC_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof LayeredSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (EXHAUST.equals(string)) {
                    SurfacePanel.this.d_tabs.add(AIR_FLOW, SurfacePanel.this.d_airFlowPanel);
                    SurfacePanel.this.d_airFlowPanel.enableExSpecMassFlux(false);
                    SurfacePanel.this.d_airFlowPanel.setVelAboveZeroOnly(true);
                    SurfacePanel.this.d_airFlowPanel.setSurfaceDescription(string);
                    SurfacePanel.this.d_tabs.add(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_thermalPanel.updateOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof InFlowSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (SUPPLY.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(AIR_FLOW, SurfacePanel.this.d_airFlowPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(SPECIES_INJECTION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_airFlowPanel.updateBlower();
                    SurfacePanel.this.d_airFlowPanel.enableExSpecMassFlux(true);
                    SurfacePanel.this.d_airFlowPanel.setVelAboveZeroOnly(true);
                    SurfacePanel.this.d_airFlowPanel.setSurfaceDescription(string);
                    SurfacePanel.this.d_thermalPanel.updateOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof BlowerSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (CONSTANT_TEMP.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_thermalPanel.updateOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof ConstantTempSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (GENERAL.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(AIR_FLOW, SurfacePanel.this.d_airFlowPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_tabs.addTab(SPECIES_INJECTION, SurfacePanel.this.d_specInjPanel);
                    SurfacePanel.this.d_airFlowPanel.updateBlower();
                    SurfacePanel.this.d_tabs.addTab(HEAT_RELEASE, SurfacePanel.this.d_burnerPanel);
                    SurfacePanel.this.d_airFlowPanel.setVelAboveZeroOnly(true);
                    SurfacePanel.this.d_airFlowPanel.setSurfaceDescription(string);
                    SurfacePanel.this.d_thermalPanel.updateOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof GeneralSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (BURNER.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(HEAT_RELEASE, SurfacePanel.this.d_burnerPanel);
                    SurfacePanel.this.d_tabs.addTab(THERMAL, SurfacePanel.this.d_thermalPanel);
                    SurfacePanel.this.d_tabs.addTab(GEOMETRY, SurfacePanel.this.d_geomPanel);
                    SurfacePanel.this.d_tabs.addTab(PARTICLE_INJECTION, SurfacePanel.this.d_partInjPanel);
                    SurfacePanel.this.d_thermalPanel.updateOptions(FIXED_TEMP_OPT, ADIABATIC_OPT, NETFLUX_OPT, TOTALFLUX_OPT);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof BurnerSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (LEAK.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(LEAK, SurfacePanel.this.d_leakPanel);
                    if (SurfacePanel.this.d_currentSurf.getSurfDesc() instanceof LeakSurfDesc) {
                        SurfacePanel.this.setModified(false);
                    }
                } else if (INERT.equals(string) || BASIC.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_inertDescPanel);
                } else if (OPEN.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_openDescPanel);
                } else if (HVAC.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_hvacDescPanel);
                } else if (MIRROR.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_mirroredDescPanel);
                } else if (ADIABATIC.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_adiabaticDescPanel);
                } else if (PERIODIC.equals(string)) {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.d_periodicDescPanel);
                } else {
                    SurfacePanel.this.d_tabs.addTab(Intl.intl("Properties"), SurfacePanel.this.getEmptyPanel());
                }
                SurfacePanel.this.d_tabs.addTab(Intl.intl("Advanced"), SurfacePanel.this.d_advancedPanel);
            }
        };
        this.d_profileListBox = new guiComboBox<Object>((T[])new Object[]{BASIC, BURNER, GENERAL, CONSTANT_TEMP, SUPPLY, EXHAUST, LAYERED, LEAK});
        this.d_profileListBox.addItemListener(this.d_surfTypeItemListener);
        guiLabel guiLabel6 = new guiLabel(Intl.intl("Surface Type") + ":");
        GridBagUtil.add(this, guiLabel6, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_profileListBox, 1, n++, 3, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.add((Component)this.getEmptyPanel(), Intl.intl("Properties"));
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_burnerPanel, this.d_specInjPanel, this.d_partInjPanel, this.d_airFlowPanel, this.d_reactionPanel, this.d_layersPanel, this.d_layerPropPanel, this.d_leakPanel));
        GridBagUtil.add(this, this.d_tabs, 0, n++, 100, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public void init(Surface surface) {
        this.setEnabled(surface != null);
        this.d_tabs.setEnabled(surface != null);
        if (surface != null) {
            this.loadSurface(surface);
            this.d_surfID.setText(surface.getName());
            this.d_fyi.setText(surface.getFYI());
            this.d_color.setColor(surface.getColor());
            this.d_appearance.setMaterial(surface.getAppearance());
            boolean bl = surface.isPredefined();
            if (bl) {
                this.setEnabled(false);
            }
        }
        this.setModified(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    @Override
    public Surface preview(Surface surface) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveSurface(null, surface);
        return surface;
    }

    @Override
    public Surface commit(final Surface surface) {
        assert (!surface.isPredefined());
        final PyroMod pyroMod = PyroSim.getApp().getMediator();
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                SurfacePanel.this.saveSurface(pyroMod, surface);
            }
        };
        pyroMod.getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Surface"));
        this.setModified(false);
        return surface;
    }

    public void saveSurface(PyroMod pyroMod, Surface surface) {
        surface.setFYI(this.d_fyi.getText());
        surface.setColor(this.d_color.getColor());
        surface.setAppearance(this.d_appearance.getMaterial());
        String string = this.d_profileListBox.getSelectedItem();
        if (string == INERT) {
            surface.setSurfDesc(new SurfDescStatic.Inert());
        } else if (string == BASIC) {
            surface.setSurfDesc(Surface.newBasicDesc());
        } else if (string == EXHAUST) {
            surface.setSurfDesc(new InFlowSurfDesc(this.d_airFlowPanel.saveData(pyroMod), this.d_thermalPanel.saveData()));
        } else if (string == LAYERED) {
            Pair<List<SurfComposition.SurfLayer>, Double> pair = this.d_layersPanel.saveData();
            SurfComposition surfComposition = new SurfComposition(this.d_layerPropPanel.internalTemp(), this.d_layerPropPanel.tempRamp(), this.d_layerPropPanel.backing(), (Double)pair.v2, (List)pair.v1);
            surface.setSurfDesc(new LayeredSurfDesc(this.d_GeomPanelLayered.saveData(), this.d_reactionPanel.saveData(), surfComposition, this.d_specInjPanel.saveData(pyroMod), this.d_partInjPanel.saveData(), this.d_reactionPanel.burnAway(), this.d_layerPropPanel.leakPath(), this.d_thermalPanel.saveData()));
        } else if (string == LEAK) {
            surface.setSurfDesc(this.d_leakPanel.save());
        } else if (string == SUPPLY) {
            surface.setSurfDesc(new BlowerSurfDesc(this.d_thermalPanel.saveData(), this.d_airFlowPanel.saveData(pyroMod), this.d_partInjPanel.saveData(), this.d_geomPanel.saveData()));
        } else if (string == CONSTANT_TEMP) {
            surface.setSurfDesc(new ConstantTempSurfDesc(this.d_thermalPanel.saveData(), this.d_partInjPanel.saveData(), this.d_geomPanel.saveData()));
        } else if (string == GENERAL) {
            surface.setSurfDesc(new GeneralSurfDesc(this.d_thermalPanel.saveData(), this.d_partInjPanel.saveData(), this.d_specInjPanel.saveData(pyroMod), this.d_burnerPanel.getHeatRelease(), this.d_airFlowPanel.saveData(pyroMod), this.d_geomPanel.saveData()));
        } else if (string == BURNER) {
            surface.setSurfDesc(new BurnerSurfDesc(this.d_burnerPanel.getHeatRelease(), this.d_partInjPanel.saveData(), this.d_thermalPanel.saveData(), this.d_geomPanel.saveData()));
        }
        this.d_advancedPanel.save(Collections.singleton(surface));
    }

    private void loadSurface(Surface surface) {
        guiPanel guiPanel2 = (guiPanel)this.d_tabs.getSelectedComponent();
        this.d_tabs.removeAll();
        this.d_currentSurf = surface;
        this.clearPanels();
        ISurfDesc iSurfDesc = surface.getSurfDesc();
        this.d_profileListBox.setItems((String[])new String[]{BASIC, BURNER, GENERAL, CONSTANT_TEMP, SUPPLY, EXHAUST, LAYERED, LEAK});
        if (iSurfDesc instanceof SurfDescStatic) {
            guiPanel guiPanel3 = this.getEmptyPanel();
            if (iSurfDesc instanceof SurfDescStatic.Adiabatic) {
                guiPanel3 = this.d_adiabaticDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), guiPanel3);
                this.d_profileListBox.setItems((String[])new String[]{ADIABATIC, MIRROR, HVAC, OPEN, INERT, PERIODIC});
                this.d_profileListBox.setSelectedItem(ADIABATIC);
            } else if (iSurfDesc instanceof SurfDescStatic.Hvac) {
                guiPanel3 = this.d_hvacDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), guiPanel3);
                this.d_profileListBox.setItems((String[])new String[]{MIRROR, HVAC, OPEN, INERT, PERIODIC});
                this.d_profileListBox.setSelectedItem(HVAC);
            } else if (iSurfDesc instanceof SurfDescStatic.Mirror) {
                guiPanel3 = this.d_mirroredDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), guiPanel3);
                this.d_profileListBox.setItems((String[])new String[]{HVAC, MIRROR, OPEN, INERT, PERIODIC});
                this.d_profileListBox.setSelectedItem(MIRROR);
            } else if (iSurfDesc instanceof SurfDescStatic.Open) {
                guiPanel3 = this.d_openDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), guiPanel3);
                this.d_profileListBox.setItems((String[])new String[]{HVAC, MIRROR, OPEN, INERT, PERIODIC});
                this.d_profileListBox.setSelectedItem(OPEN);
            } else if (iSurfDesc instanceof SurfDescStatic.Periodic) {
                guiPanel3 = this.d_periodicDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), guiPanel3);
                this.d_profileListBox.setItems((String[])new String[]{HVAC, MIRROR, OPEN, INERT, PERIODIC});
                this.d_profileListBox.setSelectedItem(PERIODIC);
            } else {
                guiPanel3 = this.d_inertDescPanel;
                this.d_tabs.addTab(Intl.intl("Properties"), guiPanel3);
                if (surface.getName().equals("INERT")) {
                    this.d_profileListBox.setItems((String[])new String[]{HVAC, MIRROR, OPEN, INERT, PERIODIC});
                    this.d_profileListBox.setSelectedItem(INERT);
                }
                this.d_profileListBox.setSelectedItem(BASIC);
            }
        } else if (iSurfDesc instanceof LayeredSurfDesc) {
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)iSurfDesc;
            this.d_tabs.addTab(LAYERS, this.d_layersPanel);
            this.d_layersPanel.loadData(layeredSurfDesc.d_surfComp);
            this.d_layerPropPanel.loadData(layeredSurfDesc);
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(Intl.intl("Reaction"), this.d_reactionPanel);
            this.d_reactionPanel.loadData(layeredSurfDesc.d_iReac, layeredSurfDesc.d_burnAway);
            this.d_reactionPanel.allowBurnAway(true);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_GeomPanelLayered.loadData(layeredSurfDesc.d_geometry);
            this.d_tabs.addTab(SPECIES_INJECTION, this.d_specInjPanel);
            this.d_specInjPanel.loadData(layeredSurfDesc.d_specInj);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_partInjPanel.loadData(layeredSurfDesc.d_partInj);
            this.d_profileListBox.setSelectedItem(LAYERED);
            this.d_thermalPanel.loadData(layeredSurfDesc.d_temperature);
        } else if (iSurfDesc instanceof LeakSurfDesc) {
            this.d_tabs.addTab(LEAK, this.d_leakPanel);
            this.d_leakPanel.loadData((LeakSurfDesc)iSurfDesc);
            this.d_profileListBox.setSelectedItem(LEAK);
        } else if (iSurfDesc instanceof InFlowSurfDesc) {
            this.d_tabs.add(AIR_FLOW, this.d_airFlowPanel);
            this.d_airFlowPanel.loadData(((InFlowSurfDesc)surface.getSurfDesc()).d_airFlow, true);
            this.d_tabs.add(THERMAL, this.d_thermalPanel);
            this.d_profileListBox.setSelectedItem(EXHAUST);
            this.d_thermalPanel.loadData(((InFlowSurfDesc)surface.getSurfDesc()).d_temperature);
        } else if (iSurfDesc instanceof BlowerSurfDesc) {
            this.d_tabs.addTab(AIR_FLOW, this.d_airFlowPanel);
            BlowerSurfDesc blowerSurfDesc = (BlowerSurfDesc)iSurfDesc;
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(SPECIES_INJECTION, this.d_specInjPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_partInjPanel.loadData(blowerSurfDesc.d_partInj);
            this.d_airFlowPanel.loadData(blowerSurfDesc.d_airFlow, true);
            this.d_profileListBox.setSelectedItem(SUPPLY);
            this.d_thermalPanel.loadData(blowerSurfDesc.d_tempReg);
            this.d_geomPanel.loadData(blowerSurfDesc.d_geometry);
        } else if (iSurfDesc instanceof BurnerSurfDesc) {
            this.d_tabs.addTab(HEAT_RELEASE, this.d_burnerPanel);
            BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)surface.getSurfDesc();
            this.d_burnerPanel.loadData(burnerSurfDesc.d_heatRelease);
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_partInjPanel.loadData(burnerSurfDesc.d_partInj);
            this.d_profileListBox.setSelectedItem(BURNER);
            this.d_thermalPanel.loadData(burnerSurfDesc.d_temperature);
            this.d_geomPanel.loadData(burnerSurfDesc.d_geometry);
        } else if (iSurfDesc instanceof GeneralSurfDesc) {
            this.d_tabs.addTab(AIR_FLOW, this.d_airFlowPanel);
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_tabs.addTab(SPECIES_INJECTION, this.d_specInjPanel);
            this.d_tabs.addTab(HEAT_RELEASE, this.d_burnerPanel);
            this.d_airFlowPanel.loadData(((GeneralSurfDesc)surface.getSurfDesc()).d_airflow, false);
            this.d_geomPanel.loadData(((GeneralSurfDesc)surface.getSurfDesc()).d_geometry);
            this.d_specInjPanel.loadData(((GeneralSurfDesc)surface.getSurfDesc()).d_specInj);
            this.d_partInjPanel.loadData(((GeneralSurfDesc)surface.getSurfDesc()).d_partInj);
            this.d_burnerPanel.loadData(((GeneralSurfDesc)surface.getSurfDesc()).d_heatRelease);
            this.d_profileListBox.setSelectedItem(GENERAL);
            this.d_thermalPanel.loadData(((GeneralSurfDesc)surface.getSurfDesc()).d_tempReg);
        } else if (iSurfDesc instanceof ConstantTempSurfDesc) {
            this.d_tabs.addTab(THERMAL, this.d_thermalPanel);
            this.d_tabs.addTab(PARTICLE_INJECTION, this.d_partInjPanel);
            this.d_tabs.addTab(GEOMETRY, this.d_geomPanel);
            this.d_partInjPanel.loadData(((ConstantTempSurfDesc)surface.getSurfDesc()).d_partInj);
            this.d_geomPanel.loadData(((ConstantTempSurfDesc)surface.getSurfDesc()).d_geometry);
            this.d_profileListBox.setSelectedItem(CONSTANT_TEMP);
            this.d_thermalPanel.loadData(((ConstantTempSurfDesc)surface.getSurfDesc()).d_tempReg);
        } else {
            this.d_tabs.addTab(Intl.intl("Properties"), this.getEmptyPanel());
            this.d_profileListBox.setSelectedIndex(0);
        }
        this.d_tabs.addTab(Intl.intl("Advanced"), this.d_advancedPanel);
        this.d_advancedPanel.clear();
        this.d_advancedPanel.load(Collections.singleton(surface), new CustomFDSPanel.AdvPropWrapper<Boolean>(surface.isForceWrite(), 1));
        try {
            this.d_tabs.setSelectedComponent(guiPanel2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.d_profileListBox.revalidate();
    }

    private void clearPanels() {
        this.d_airFlowPanel.loadData(null, true);
        this.d_specInjPanel.loadData(null);
        this.d_partInjPanel.loadData(null);
        this.d_reactionPanel.loadData(null, false);
        this.d_layerPropPanel.loadData(null);
        this.d_layersPanel.loadData(null);
        this.d_burnerPanel.loadData(null);
        this.d_leakPanel.loadData(null);
        this.d_geomPanel.loadData(null);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private guiPanel getEmptyPanel() {
        guiPanel guiPanel2 = new guiPanel();
        return guiPanel2;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_tabs.indexOfComponent(this.d_partInjPanel) > -1 && this.d_partInjPanel.d_emitPartCB.isSelected() && this.d_partInjPanel.d_particleCombo.getSelectedItem() == null) {
            if (bl2) {
                this.d_tabs.setSelectedComponent(this.d_partInjPanel);
            }
            if (bl) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("A Particle Type must be chosen if Emit Particles is selected."));
            }
            return false;
        }
        if (this.d_tabs.indexOfComponent(this.d_specInjPanel) > -1 && !this.d_specInjPanel.isMassFracOK()) {
            if (bl2) {
                this.d_tabs.setSelectedComponent(this.d_specInjPanel);
            }
            if (bl) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("The values for mass fraction must add up to 1 or less."));
            }
            return false;
        }
        if (this.d_tabs.indexOfComponent(this.d_specInjPanel) > -1 && !this.d_specInjPanel.isRampTableSet()) {
            if (bl2) {
                this.d_tabs.setSelectedComponent(this.d_specInjPanel);
            }
            if (bl) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Included species cannot have empty ramp value tables."));
            }
            return false;
        }
        return true;
    }

    private TimeFunctionEditor newTimeFuncEditor() {
        return this.newTimeFuncEditor(Intl.intl("Ramp-Up Time"));
    }

    private TimeFunctionEditor newTimeFuncEditor(String string) {
        int n = 29;
        return new TimeFunctionEditor(string, n);
    }

    private static interface IAirflowConfig
    extends IPanelConfig<AirFlowPanel> {
        public boolean supportTotalMassFlux();
    }

    private static interface IPanelConfig<T> {
    }

    private static class BackingComboBox
    extends guiComboBox<String> {
        private static final long serialVersionUID = 1275890324314380067L;
        private static final String AIR_GAP = Intl.intl("Air Gap");
        private static final String EXPOSED = Intl.intl("Exposed");
        private static final String INSULATED = Intl.intl("Insulated");
        public final guiLabel d_airTempLab;
        public final ValueField<UnitDouble> d_airTempFld;

        public BackingComboBox(UnitSystem unitSystem) {
            super((T[])new String[]{AIR_GAP, EXPOSED, INSULATED});
            this.setMinimumSize(this.getPreferredSize());
            this.d_airTempLab = new guiLabel(Intl.intl("Gap Temperature:"));
            this.d_airTempFld = ValueFields.udFld(UnitSystem.getSource(1));
            ValueFields.getFormat(this.d_airTempFld).alias(null, "TMPA", "");
            this.d_airTempFld.setNullAllowed(true);
            this.d_airTempFld.setMinimumSize(this.d_airTempFld.getPreferredSize());
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    this.updateVisibility();
                }
            });
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.updateVisibility();
        }

        public void updateVisibility() {
            boolean bl = this.getSelectedItem() == AIR_GAP;
            this.d_airTempLab.setVisible(bl);
            this.d_airTempFld.setVisible(bl);
        }

        public Backing getBacking() {
            String string = (String)this.getSelectedItem();
            if (string == AIR_GAP) {
                return new Backing.AirGap((UnitDouble)this.d_airTempFld.getValue());
            }
            if (string == EXPOSED) {
                return Backing.EXPOSED;
            }
            return Backing.INSULATED;
        }

        public void setBacking(Backing backing) {
            if (backing instanceof Backing.AirGap) {
                this.setSelectedItem(AIR_GAP);
                this.d_airTempFld.setValue(((Backing.AirGap)backing).d_airTemp);
            } else if (backing instanceof Backing.Exposed) {
                this.setSelectedItem(EXPOSED);
            } else {
                this.setSelectedItem(INSULATED);
            }
        }
    }

    private class LayersPanel
    extends guiPanel {
        private static final long serialVersionUID = -888896091136552195L;
        private final guiTable d_table;
        private final guiCheckBox d_layerDivideCB;
        private final ValueField<Double> d_layerDivideFld;
        private final int d_rowLimit = 20;
        private final guiLabel d_messageLabel;

        public LayersPanel() {
            this.setLayout(new GridBagLayout());
            this.d_layerDivideCB = new guiCheckBox(Intl.intl("Layer Divide") + ":");
            this.d_layerDivideFld = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            LinkStatus.link((AbstractButton)this.d_layerDivideCB, this.d_layerDivideFld);
            this.d_messageLabel = new guiLabel("");
            this.d_messageLabel.setForeground(Color.red);
            if (!SurfacePanel.this.d_matMgr.flatten().isEmpty()) {
                this.d_table = new guiTable((TableModel)new SurfLayersTable(), 24);
            } else {
                this.d_table = new guiTable((TableModel)new SurfLayersTable(), 0);
                this.d_table.setEnabled(false);
            }
            Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
            this.d_table.setRowLimit(20);
            this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(unit));
            this.d_table.getColumnModel().getColumn(1).setCellEditor(new SurfCompCollectionEditor(SurfacePanel.this.d_surfMgr, SurfacePanel.this.d_matMgr));
            this.d_table.getColumnModel().getColumn(1).setCellRenderer(new SurfCompCollectionRenderer());
            this.d_table.setClipboard(1, (guiTableClipboard)new SurfCompCollectionClipboard());
            this.d_table.getColumnModel().getColumn(2).setCellEditor(new EditCompEditor());
            this.d_table.getColumnModel().getColumn(2).setCellRenderer(new EditCompRenderer());
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(40);
            this.d_table.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.d_table.getColumnModel().getColumn(2).setPreferredWidth(40);
            int n = this.d_table.autoSizeColumns(10);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(n, 10));
            guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 30);
            int n2 = 0;
            GridBagUtil.add(this, this.d_layerDivideCB, 0, n2, 1, 1, 12, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_layerDivideFld, 1, n2++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, new TitleSeparator(LAYERS), 0, n2++, 2, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, guiTableEditor2, 0, n2++, 2, 1, 0, 30, 6, 12, 1, 1.0, 1.0, 17);
            GridBagUtil.add(this, this.d_messageLabel, 0, n2++, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
        }

        public void loadData(SurfComposition surfComposition) {
            this.d_table.selectAll();
            this.d_table.removeSelectedRows();
            this.d_table.clearSelection();
            this.d_layerDivideCB.setSelected(false);
            if (surfComposition == null) {
                return;
            }
            this.d_layerDivideCB.setSelected(surfComposition.d_layerDivide != null);
            if (surfComposition.d_layerDivide != null) {
                this.d_layerDivideFld.setValue(surfComposition.d_layerDivide);
            }
            List<SurfComposition.SurfLayer> list = surfComposition.d_layers;
            ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_table.getModel();
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = new Object[]{list.get((int)i).d_thickness, new ArrayList<SurfComposition.SurfLayer.SurfComponent>(list.get(i).getComponents()), null};
                resizableTableModel.insertRow(i, objectArray);
            }
            if (PyroSim.getApp().getMediator().getMaterialMgr().flatten().isEmpty()) {
                this.d_messageLabel.setText(Intl.intl("No materials currently exist in the model."));
            } else {
                this.d_messageLabel.setText("");
            }
        }

        public Pair<List<SurfComposition.SurfLayer>, Double> saveData() {
            ArrayList<SurfComposition.SurfLayer> arrayList = new ArrayList<SurfComposition.SurfLayer>(this.d_table.getRowCount());
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                if (this.d_table.getValueAt(i, 0) == null || this.d_table.getValueAt(i, 1) == null) continue;
                arrayList.add(new SurfComposition.SurfLayer((UnitDouble)this.d_table.getValueAt(i, 0), (Collection)this.d_table.getValueAt(i, 1)));
            }
            Double d = this.d_layerDivideCB.isSelected() && (Double)this.d_layerDivideFld.getValue() <= (double)arrayList.size() ? (Double)this.d_layerDivideFld.getValue() : null;
            return new Pair(arrayList, d);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            int n = 0;
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                if (this.d_table.getValueAt(i, 0) == null) continue;
                ++n;
                if (this.d_table.getValueAt(i, 1) != null && (this.d_table.getValueAt(i, 0) != null || this.d_table.getValueAt(i, 1) == null)) continue;
                if (bl2) {
                    SurfacePanel.this.d_tabs.setSelectedComponent(SurfacePanel.this.d_layersPanel);
                }
                this.error(bl, Intl.intl("Blank fields are not allowed"));
                return false;
            }
            if (this.d_layerDivideCB.isSelected() && (Double)this.d_layerDivideFld.getValue() > (double)n) {
                if (bl) {
                    String string = String.format(Intl.intl("Layer Divide must be less than or equal to %d (the number of layers)."), n);
                    this.error(true, string);
                }
                return false;
            }
            return true;
        }

        private void error(boolean bl, String string) {
            if (bl) {
                JOptionPane.showMessageDialog(this, string, Intl.intl("Layer Error"), 0);
            }
        }

        private String sanitizeNameIfNeeded(String string) {
            String string2 = " ;,";
            boolean bl = false;
            for (char c : string2.toCharArray()) {
                if (string.indexOf(c) == -1) continue;
                bl = true;
                break;
            }
            return bl ? "\"" + string + "\"" : string;
        }

        private String renderSCCollection(JTable jTable, int n, int n2, Collection<SurfComposition.SurfLayer.SurfComponent> collection) {
            StringBuffer stringBuffer = new StringBuffer();
            if (collection != null && collection.size() > 0) {
                int n3 = 0;
                for (SurfComposition.SurfLayer.SurfComponent surfComponent : collection) {
                    if (n3 > 0) {
                        stringBuffer.append("; ");
                    }
                    stringBuffer.append(Global.format(surfComponent.d_massFraction) + " " + this.sanitizeNameIfNeeded(surfComponent.d_material.getName()));
                    n3 = 2;
                }
            }
            return stringBuffer.toString();
        }

        private Collection<SurfComposition.SurfLayer.SurfComponent> parseSCCollection(String string, MaterialManager materialManager) throws ParseException {
            String string2;
            Object object;
            ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
            List<String> list = CSVLineParser.parse(string, " ;", "\"");
            if (list.size() == 1 && (object = (Material)materialManager.get(string2 = list.get(0))) != null) {
                arrayList.add(new SurfComposition.SurfLayer.SurfComponent(1.0, (Material)object));
                return arrayList;
            }
            for (int i = 0; i < list.size() - 1; i += 2) {
                object = list.get(i);
                String string3 = list.get(i + 1);
                double d = Global.parseDouble((CharSequence)object);
                if (d <= 0.0 || d > 1.0) {
                    throw new ParseException(Intl.intl("Mass fraction must range from 0 to 1."), 0);
                }
                Material material = (Material)materialManager.get(string3);
                if (material == null) {
                    throw new ParseException(String.format(Intl.intl("%1$s is not a valid material."), string3), 0);
                }
                arrayList.add(new SurfComposition.SurfLayer.SurfComponent(d, material));
            }
            if (list.size() % 2 == 1) {
                String string4 = list.get(list.size() - 1);
                throw new ParseException(String.format(Intl.intl("A material is needed after the value %1$s."), string4), 0);
            }
            return arrayList;
        }

        private String renderUD(JTable jTable, int n, int n2, UnitDouble unitDouble) {
            if (unitDouble != null) {
                return Global.format(unitDouble.getValue(SurfacePanel.this.d_currentUS.getLengthUnit()));
            }
            return "";
        }

        private UnitDouble parseUD(String string) {
            Unit unit = SurfacePanel.this.d_currentUS.getLengthUnit();
            try {
                double d = Global.parseDouble(string);
                return new UnitDouble(d, unit);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private class EditCompEditor
        extends DefaultCellEditor
        implements TableCellEditor,
        ActionListener {
            private static final long serialVersionUID = -2409153443271011851L;
            private final JButton d_button;
            private int d_row;

            public EditCompEditor() {
                super(new JTextField());
                this.d_button = new JButton(Intl.intl("Edit") + "...");
                this.d_button.addActionListener(this);
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                this.d_row = n;
                this.d_button.setBackground(component.getBackground());
                return this.d_button;
            }

            @Override
            public Object getCellEditorValue() {
                return "";
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Collection<SurfComposition.SurfLayer.SurfComponent> collection = (Collection<SurfComposition.SurfLayer.SurfComponent>)LayersPanel.this.d_table.getValueAt(this.d_row, 1);
                SurfacePanelEditCompDlg surfacePanelEditCompDlg = new SurfacePanelEditCompDlg(collection, SurfacePanel.this.d_matMgr);
                if (surfacePanelEditCompDlg.doModal() == 1) {
                    collection = surfacePanelEditCompDlg.getSurfComponent();
                    this.stopCellEditing();
                    LayersPanel.this.d_table.setValueAt(collection, this.d_row, 1);
                    LayersPanel.this.d_table.setModified(true);
                } else {
                    this.cancelCellEditing();
                }
            }
        }

        private class EditCompRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 863885343655302852L;
            private final JButton d_button = new JButton(Intl.intl("Edit") + "...");

            private EditCompRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.d_button.setBackground(component.getBackground());
                return this.d_button;
            }
        }

        private class SurfCompCollectionEditor
        extends DefaultCellEditor
        implements TableCellEditor {
            private static final long serialVersionUID = -5465749326982964478L;
            private Collection<SurfComposition.SurfLayer.SurfComponent> d_list;
            private SurfaceManager d_surfMgr;
            private MaterialManager d_matMgr;

            public SurfCompCollectionEditor(SurfaceManager surfaceManager, MaterialManager materialManager) {
                super(new JTextField());
                ((JTextField)this.getComponent()).setHorizontalAlignment(4);
                this.d_surfMgr = surfaceManager;
                this.d_matMgr = materialManager;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                JTextField jTextField = (JTextField)this.getComponent();
                this.d_list = (Collection)object;
                jTextField.setText(LayersPanel.this.renderSCCollection(jTable, n, n2, this.d_list));
                return jTextField;
            }

            protected void showError(String string) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, SurfacePanel.this);
                if (window != null) {
                    guiDialog.showInvalidEntryMessage(window, string);
                }
            }

            @Override
            public boolean stopCellEditing() {
                JTextField jTextField = (JTextField)this.getComponent();
                Collection collection = null;
                try {
                    collection = LayersPanel.this.parseSCCollection(jTextField.getText(), this.d_matMgr);
                }
                catch (ParseException parseException) {
                    this.showError(parseException.getLocalizedMessage());
                    jTextField.grabFocus();
                    return false;
                }
                Collection<SurfComposition.SurfLayer.SurfComponent> collection2 = this.d_list;
                if (collection.size() < 1) {
                    this.d_list = null;
                } else {
                    double d = 0.0;
                    for (Iterator iterator : collection) {
                        d += ((SurfComposition.SurfLayer.SurfComponent)((Object)iterator)).d_massFraction;
                    }
                    if (!theUtil.eq(d, 1.0, 1.0E-6)) {
                        this.showError(Intl.intl("Mass fraction values must add up to 1."));
                        return false;
                    }
                    this.d_list = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(collection.size());
                    ArrayList arrayList = new ArrayList(collection.size());
                    for (Serializable serializable : collection) {
                        if (arrayList.contains(((SurfComposition.SurfLayer.SurfComponent)serializable).d_material)) continue;
                        arrayList.add(((SurfComposition.SurfLayer.SurfComponent)serializable).d_material);
                    }
                    if (arrayList.size() != collection.size()) {
                        Iterator iterator;
                        iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            Serializable serializable;
                            serializable = (Material)iterator.next();
                            double d2 = 0.0;
                            for (SurfComposition.SurfLayer.SurfComponent surfComponent : collection) {
                                if (!((Material)serializable).equals(surfComponent.d_material)) continue;
                                d2 += surfComponent.d_massFraction;
                            }
                            this.d_list.add(new SurfComposition.SurfLayer.SurfComponent(d2, (Material)serializable));
                        }
                    } else {
                        this.d_list = collection;
                    }
                    if (this.d_list.size() > 20) {
                        LayersPanel.this.d_messageLabel.setText(Intl.intl("No more than 20 materials are allowed."));
                        this.d_list = collection2;
                        return false;
                    }
                }
                return super.stopCellEditing();
            }

            @Override
            public Object getCellEditorValue() {
                return this.d_list;
            }
        }

        private class SurfCompCollectionRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 4314216411336090376L;

            public SurfCompCollectionRenderer() {
                this.setHorizontalAlignment(4);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Collection collection = (Collection)object;
                this.setText(LayersPanel.this.renderSCCollection(jTable, n, n2, collection));
                return component;
            }
        }

        private class SurfLayersTable
        extends guiDefaultTableModel {
            private static final long serialVersionUID = -8986329050233327583L;

            private SurfLayersTable() {
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return String.format(Intl.intl("Thickness (%s)"), SurfacePanel.this.d_currentUS.getLengthUnit().toString());
                    }
                    case 1: {
                        return Intl.intl("Material Composition");
                    }
                    case 2: {
                        return Intl.intl("Edit");
                    }
                }
                return null;
            }

            @Override
            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return UnitDouble.class;
                    }
                    case 1: {
                        return Collection.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                assert (false);
                return null;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }
        }

        private class SurfCompCollectionClipboard
        extends DefaultTableClipboard {
            private SurfCompCollectionClipboard() {
            }

            @Override
            public boolean pasteObject(guiTable guiTable2, Object object, int n, int n2) {
                assert (n2 == 1);
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    IFilteredCollection<SurfComposition.SurfLayer.SurfComponent> iFilteredCollection = theUtil.filter(collection, SurfComposition.SurfLayer.SurfComponent.class);
                    if (!iFilteredCollection.isExclusive()) {
                        return false;
                    }
                    PyroMod pyroMod = PyroSim.getApp().getMediator();
                    LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
                    for (SurfComposition.SurfLayer.SurfComponent object22 : iFilteredCollection) {
                        if (object22.d_material.getDomain() == pyroMod) continue;
                        linkedIdentityHashSet.add(object22.d_material);
                    }
                    Actions.UIPasteCallback uIPasteCallback = new Actions.UIPasteCallback(pyroMod){

                        @Override
                        public Actions.PasteOverwrite getReplaceModelObject(IPyroObject iPyroObject, IPyroObject iPyroObject2) throws CancellationException {
                            return Actions.PasteOverwrite.KEEP_EXISTING;
                        }
                    };
                    Actions.PasteInfo pasteInfo = Actions.taskInsertObjects(pyroMod, linkedIdentityHashSet, uIPasteCallback, 2);
                    for (Actions.PasteCommand pasteCommand : pasteInfo.commands.values()) {
                        if (pasteCommand.command == 1 && pasteCommand.param instanceof IPyroObject) continue;
                        return false;
                    }
                    pasteInfo.task.run();
                    ArrayList arrayList = new ArrayList(iFilteredCollection.size());
                    for (SurfComposition.SurfLayer.SurfComponent surfComponent : iFilteredCollection) {
                        Actions.PasteCommand pasteCommand = pasteInfo.commands.get(surfComponent.d_material);
                        if (pasteCommand != null) {
                            if (!(pasteCommand.param instanceof Material)) {
                                return false;
                            }
                            Material material = (Material)pasteCommand.param;
                            surfComponent = new SurfComposition.SurfLayer.SurfComponent(surfComponent.d_massFraction, material);
                        }
                        arrayList.add(surfComponent);
                    }
                    object = arrayList;
                }
                return super.pasteObject(guiTable2, object, n, n2);
            }
        }
    }

    private class LayersPropPanel
    extends guiPanel {
        private static final long serialVersionUID = 1720376837829116774L;
        private final ZonePathPanel d_leakPath = new ZonePathPanel(Intl.intl("Enable Leakage"), true);
        private final ValueField<UnitDouble> d_initInternTemp = ValueFields.udFld(UnitSystem.getSource(1));
        private final TimeFunctionEditor d_tempRampEditor;
        private final BackingComboBox d_backingCombo;

        public LayersPropPanel() {
            ValueFields.getFormat(this.d_initInternTemp).alias(null, "TMPA", "");
            this.d_initInternTemp.setNullAllowed(true);
            this.d_tempRampEditor = SurfacePanel.this.newTimeFuncEditor(Intl.intl("Temperature Ramp"));
            this.d_backingCombo = new BackingComboBox(SurfacePanel.this.d_currentUS);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_leakPath, GridBagHelper.REMAINING);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Temperature")));
            gridBagHelper.addIdentRow(Intl.intl("Initial Internal Temperature") + ":", this.d_initInternTemp, 1.0);
            gridBagHelper.addIdentRow(Intl.intl("Backing") + ":", this.d_backingCombo, 1.0, this.d_backingCombo.d_airTempLab, this.d_backingCombo.d_airTempFld);
            gridBagHelper.addIdentRow(this.d_tempRampEditor.getLabel(), this.d_tempRampEditor.getCombo(), 1.0, this.d_tempRampEditor.getEditor(), 1.0);
            gridBagHelper.finalizeRows();
        }

        public void loadData(LayeredSurfDesc layeredSurfDesc) {
            LayeredSurfDesc layeredSurfDesc2 = new LayeredSurfDesc();
            SurfComposition surfComposition = layeredSurfDesc2.d_surfComp;
            this.d_initInternTemp.setValue(surfComposition.d_initInnerTemp);
            this.d_backingCombo.setBacking(surfComposition.d_backing);
            this.d_leakPath.loadData(layeredSurfDesc2.d_leakPath);
            if (layeredSurfDesc == null) {
                return;
            }
            this.d_initInternTemp.setValue(layeredSurfDesc.d_surfComp.d_initInnerTemp);
            this.d_backingCombo.setBacking(layeredSurfDesc.d_surfComp.d_backing);
            this.d_leakPath.loadData(layeredSurfDesc.d_leakPath);
            this.d_tempRampEditor.loadFunction(layeredSurfDesc.d_surfComp.d_tempRamp);
        }

        public ZonePath leakPath() {
            return this.d_leakPath.saveData();
        }

        public UnitDouble internalTemp() {
            return (UnitDouble)this.d_initInternTemp.getValue();
        }

        public TimeFunction tempRamp() {
            return this.d_tempRampEditor.saveFunction();
        }

        public Backing backing() {
            return this.d_backingCombo.getBacking();
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.d_tempRampEditor.validateData(bl, bl2)) {
                return false;
            }
            return this.d_leakPath.validateLeakage(bl, bl2);
        }
    }

    private static class ZonePathPanel
    extends guiPanel {
        private static final long serialVersionUID = 8086116205197119986L;
        private final ZoneComboBox d_zone1;
        private final ZoneComboBox d_zone2;
        private final Component d_label;

        public ZonePathPanel(String string, boolean bl) {
            super(new GridBagLayout());
            ZoneMgr zoneMgr = PyroSim.getApp().getMediator().getZoneMgr();
            this.d_zone1 = new ZoneComboBox(zoneMgr);
            this.d_zone2 = new ZoneComboBox(zoneMgr);
            this.d_label = bl ? new guiCheckBox(string) : new guiLabel(string);
            guiLabel guiLabel2 = new guiLabel("<->");
            if (bl) {
                LinkStatus.link((AbstractButton)((guiCheckBox)this.d_label), this.d_zone1, this.d_zone2, guiLabel2);
            }
            GridBagUtil.add(this, this.d_label, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_zone1, 1, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 2, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_zone2, 3, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void loadData(ZonePath zonePath) {
            if (this.d_label instanceof guiCheckBox) {
                ((guiCheckBox)this.d_label).setSelected(zonePath != null);
            }
            if (zonePath == null) {
                this.d_zone1.setSelectedIndex(-1);
                this.d_zone2.setSelectedIndex(-1);
                return;
            }
            Zone[] zoneArray = zonePath.getZones();
            this.d_zone1.setSelectedItem(zoneArray[0]);
            this.d_zone2.setSelectedItem(zoneArray[1]);
        }

        public ZonePath saveData() {
            if (this.d_label instanceof guiCheckBox && !((guiCheckBox)this.d_label).isSelected()) {
                return null;
            }
            return new ZonePath((Zone)this.d_zone1.getSelectedItem(), (Zone)this.d_zone2.getSelectedItem());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.isEnabled() || this.d_label instanceof guiCheckBox && !((guiCheckBox)this.d_label).isSelected()) {
                return true;
            }
            Zone zone = (Zone)this.d_zone1.getSelectedItem();
            Zone zone2 = (Zone)this.d_zone2.getSelectedItem();
            if (zone != null && zone2 != null && zone == zone2) {
                if (bl) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("The selected zones must be different."), Intl.intl("Invalid Zones"), 0);
                }
                return false;
            }
            return true;
        }

        public boolean validateLeakage(boolean bl, boolean bl2) {
            int n;
            Leak leak;
            ZonePath zonePath = this.saveData();
            if (zonePath == null) {
                return true;
            }
            Zone[] zoneArray = zonePath.getZones();
            Zone zone = zoneArray[0];
            Zone zone2 = zoneArray[1];
            return zone == null || zone2 == null || !bl || (leak = LeakUtil.getLeak(PyroSim.getApp().getMediator(), zone, zone2)) != null || (n = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("No leakage area has been specified between zones %1$s and %2$s.\nWould you still like to save this leakage path?"), zone.getName(), zone2.getName()), Intl.intl("Warning"), 0, 2)) == 0;
        }
    }

    private static class LeakPanel
    extends guiPanel {
        private static final long serialVersionUID = -4136467863673605251L;
        private final ZonePathPanel d_leakPath = new ZonePathPanel(Intl.intl("Leak Path:"), false);

        public LeakPanel() {
            super(new GridBagLayout());
            GridBagUtil.add(this, this.d_leakPath, 0, 0, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(LeakSurfDesc leakSurfDesc) {
            if (leakSurfDesc == null) {
                this.d_leakPath.loadData(null);
                return;
            }
            this.d_leakPath.loadData(leakSurfDesc.d_leak);
        }

        public LeakSurfDesc save() {
            return new LeakSurfDesc(this.d_leakPath.saveData());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            return this.d_leakPath.validateLeakage(bl, bl2);
        }
    }

    private class GeomPanel
    extends guiPanel {
        private static final long serialVersionUID = -4216547888912977493L;
        protected final guiComboBox d_geomCombo;
        protected final CardLayout d_cards;
        protected final guiPanel d_cardPanel;
        protected final guiPanel d_defaultCard;
        protected final guiPanel d_cartesianCard;
        protected final guiPanel d_sphereCard;
        protected final guiPanel d_cylinderCard;

        public GeomPanel() {
            this.setLayout(new GridBagLayout());
            this.d_geomCombo = new guiComboBox<Object>((T[])new Object[]{IGeometry.DEFAULT.getName(), IGeometry.CARTESIAN.getName(), IGeometry.SPHERICAL.getName(), IGeometry.CYLINDRICAL.getName()});
            this.d_defaultCard = new guiPanel();
            this.d_cartesianCard = new CartesianOptionPanel();
            this.d_sphereCard = new SphereOptionPanel();
            this.d_cylinderCard = new CylinderOptionPanel();
            this.d_cards = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_geomCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    GeomPanel.this.d_cards.show(GeomPanel.this.d_cardPanel, (String)GeomPanel.this.d_geomCombo.getSelectedItem());
                }
            });
            this.d_cardPanel.add((Component)this.d_defaultCard, IGeometry.DEFAULT.getName());
            this.d_cardPanel.add((Component)this.d_cartesianCard, IGeometry.CARTESIAN.getName());
            this.d_cardPanel.add((Component)this.d_sphereCard, IGeometry.SPHERICAL.getName());
            this.d_cardPanel.add((Component)this.d_cylinderCard, IGeometry.CYLINDRICAL.getName());
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(new guiLabel(Intl.intl("Geometry:")), this.d_geomCombo);
            gridBagHelper.addFilledRow(new guiSeparator());
            GridBagUtil.add(this, this.d_cardPanel, 0, 2, 2, 3, 12, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(IGeometry iGeometry) {
            IGeometry.Default default_ = IGeometry.DEFAULT;
            this.forceLoad(default_);
            if (iGeometry == null) {
                return;
            }
            this.forceLoad(iGeometry);
        }

        private void forceLoad(IGeometry iGeometry) {
            if (iGeometry instanceof IGeometry.Cartesian) {
                this.d_geomCombo.setSelectedItem(IGeometry.CARTESIAN.getName());
                ((CartesianOptionPanel)this.d_cartesianCard).loadGeometry((IGeometry.Cartesian)iGeometry);
            } else if (iGeometry instanceof IGeometry.Cylindrical) {
                this.d_geomCombo.setSelectedItem(IGeometry.CYLINDRICAL.getName());
                ((CylinderOptionPanel)this.d_cylinderCard).loadGeometry((IGeometry.Cylindrical)iGeometry);
            } else if (iGeometry instanceof IGeometry.Spherical) {
                this.d_geomCombo.setSelectedItem(IGeometry.SPHERICAL.getName());
                ((SphereOptionPanel)this.d_sphereCard).loadGeometry((IGeometry.Spherical)iGeometry);
            } else {
                this.d_geomCombo.setSelectedItem(IGeometry.DEFAULT.getName());
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2);
        }

        public IGeometry saveData() {
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                return ((CartesianOptionPanel)this.d_cartesianCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                return ((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                return ((SphereOptionPanel)this.d_sphereCard).getGeometry();
            }
            return IGeometry.DEFAULT;
        }

        private class CylinderOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 80517855847721380L;
            private ValueField<UnitDouble> d_radius;
            private ValueField<UnitDouble> d_length;
            private guiCheckBox d_lengthCB;

            public CylinderOptionPanel() {
                super(new GridBagLayout());
                this.d_radius = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_lengthCB = new guiCheckBox(Intl.intl("Length:"));
                LinkStatus.link((AbstractButton)this.d_lengthCB, this.d_length);
                GridBagHelper gridBagHelper = new GridBagHelper(this, false);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Radius:")), this.d_radius);
                gridBagHelper.addRow(this.d_lengthCB, this.d_length);
                gridBagHelper.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cylindrical(null, (UnitDouble)this.d_radius.getValue(), this.getLength());
            }

            private Variant getLength() {
                return this.d_lengthCB.isSelected() ? Variant.constant((UnitDouble)this.d_length.getValue()) : Variant.DEFAULT;
            }

            public void loadGeometry(IGeometry.Cylindrical cylindrical) {
                this.d_radius.setValue(cylindrical.radius);
                if (cylindrical.lengthVar.isDefault()) {
                    this.d_lengthCB.setSelected(false);
                } else {
                    this.d_lengthCB.setSelected(true);
                    this.d_length.setValue(cylindrical.lengthVar.val);
                }
            }
        }

        private class SphereOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 6001552169751128600L;
            private ValueField<UnitDouble> d_radius;

            public SphereOptionPanel() {
                super(new GridBagLayout());
                this.d_radius = ValueFields.udFld(UnitSystem.getSource(0));
                GridBagHelper gridBagHelper = new GridBagHelper(this, false);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Radius:")), this.d_radius);
                gridBagHelper.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Spherical(null, (UnitDouble)this.d_radius.getValue());
            }

            public void loadGeometry(IGeometry.Spherical spherical) {
                this.d_radius.setValue(spherical.radius);
            }
        }

        private class CartesianOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = -2887564389888201359L;
            private ValueField<UnitDouble> d_length;
            private ValueField<UnitDouble> d_width;
            private ValueField<UnitDouble> d_thickness;

            public CartesianOptionPanel() {
                super(new GridBagLayout());
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_width = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_thickness = ValueFields.udFld(UnitSystem.getSource(0));
                GridBagHelper gridBagHelper = new GridBagHelper(this, false);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Length:")), this.d_length);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Width:")), this.d_width);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Half-Thickness:")), this.d_thickness);
                gridBagHelper.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cartesian((UnitDouble)this.d_length.getValue(), (UnitDouble)this.d_width.getValue(), (UnitDouble)this.d_thickness.getValue());
            }

            public void loadGeometry(IGeometry.Cartesian cartesian) {
                this.d_length.setValue(cartesian.length);
                this.d_width.setValue(cartesian.width);
                this.d_thickness.setValue(cartesian.thickness);
            }
        }
    }

    private class GeomPanelLayered
    extends guiPanel {
        private static final long serialVersionUID = -6304593908868597087L;
        protected final guiComboBox d_geomCombo;
        protected final CardLayout d_cards;
        protected final guiPanel d_cardPanel;
        protected final guiPanel d_defaultCard;
        protected final guiPanel d_cartesianCard;
        protected final guiPanel d_sphereCard;
        protected final guiPanel d_cylinderCard;
        private String d_selected;
        protected guiLabel d_thickLbl;

        public GeomPanelLayered() {
            this.setLayout(new GridBagLayout());
            this.d_geomCombo = new guiComboBox<Object>((T[])new Object[]{IGeometry.DEFAULT.getName(), IGeometry.CARTESIAN.getName(), IGeometry.SPHERICAL.getName(), IGeometry.CYLINDRICAL.getName()});
            this.d_thickLbl = new guiLabel();
            this.d_thickLbl.setFont(this.getFont().deriveFont(2));
            this.d_defaultCard = new guiPanel();
            this.d_cartesianCard = new CartesianOptionPanel();
            this.d_sphereCard = new SphereOptionPanel();
            this.d_cylinderCard = new CylinderOptionPanel();
            this.d_cards = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_geomCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    GeomPanelLayered.this.d_cards.show(GeomPanelLayered.this.d_cardPanel, (String)GeomPanelLayered.this.d_geomCombo.getSelectedItem());
                    GeomPanelLayered.this.updateCardData();
                    GeomPanelLayered.this.updateThicknessLbl();
                }
            });
            this.d_selected = IGeometry.DEFAULT.getName();
            this.d_geomCombo.setSelectedItem(this.d_selected);
            this.d_cardPanel.add((Component)this.d_defaultCard, IGeometry.DEFAULT.getName());
            this.d_cardPanel.add((Component)this.d_cartesianCard, IGeometry.CARTESIAN.getName());
            this.d_cardPanel.add((Component)this.d_sphereCard, IGeometry.SPHERICAL.getName());
            this.d_cardPanel.add((Component)this.d_cylinderCard, IGeometry.CYLINDRICAL.getName());
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(new guiLabel(Intl.intl("Geometry:")), this.d_geomCombo);
            gridBagHelper.addFilledRow(new guiSeparator());
            GridBagUtil.add(this, this.d_cardPanel, 0, 1, 2, 3, 12, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thickLbl, 0, 4, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void updateCardData() {
            if (this.d_selected.equals(IGeometry.CARTESIAN.getName())) {
                IGeometry iGeometry = ((CartesianOptionPanel)this.d_cartesianCard).getGeometry();
                UnitDouble unitDouble = ((IGeometry.Cartesian)iGeometry).length;
                ((CylinderOptionPanel)this.d_cylinderCard).setLength(unitDouble);
            } else if (this.d_selected.equals(IGeometry.SPHERICAL.getName())) {
                IGeometry iGeometry = ((SphereOptionPanel)this.d_sphereCard).getGeometry();
                UnitDouble unitDouble = ((IGeometry.Spherical)iGeometry).innerRadius;
                ((CylinderOptionPanel)this.d_cylinderCard).setInnerRadius(unitDouble);
            } else if (this.d_selected.equals(IGeometry.CYLINDRICAL.getName())) {
                IGeometry iGeometry = ((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
                UnitDouble unitDouble = ((IGeometry.Cylindrical)iGeometry).innerRadius;
                Variant variant = ((IGeometry.Cylindrical)iGeometry).lengthVar;
                if (variant.isConstant()) {
                    ((CartesianOptionPanel)this.d_cartesianCard).setLength((UnitDouble)variant.val);
                }
                ((SphereOptionPanel)this.d_sphereCard).setInnerRadius(unitDouble);
            }
            this.d_selected = (String)this.d_geomCombo.getSelectedItem();
        }

        public void updateThicknessLbl() {
            UnitDouble unitDouble = new UnitDouble(0.0, SurfacePanel.this.d_currentUS.getLengthUnit());
            DecimalFormat decimalFormat = new DecimalFormat("#,###,###,##0.000");
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.DEFAULT.getName())) {
                this.d_thickLbl.setText("");
            } else if (SurfacePanel.this.d_layersPanel.validateData(false, false)) {
                Object object;
                Pair<List<SurfComposition.SurfLayer>, Double> pair = SurfacePanel.this.d_layersPanel.saveData();
                for (SurfComposition.SurfLayer surfLayer : (List)pair.v1) {
                    unitDouble = unitDouble.add(surfLayer.d_thickness);
                }
                if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                    this.d_thickLbl.setText(String.format(Intl.intl("Total Half-Thickness: %s"), unitDouble.format(decimalFormat)));
                } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                    object = (IGeometry.Spherical)((SphereOptionPanel)this.d_sphereCard).getGeometry();
                    if (((IGeometry.Spherical)object).innerRadius != null) {
                        unitDouble = unitDouble.add(((IGeometry.Spherical)object).innerRadius);
                    }
                    this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), unitDouble.format(decimalFormat)));
                } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                    object = (IGeometry.Cylindrical)((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
                    if (((IGeometry.Cylindrical)object).innerRadius != null) {
                        unitDouble = unitDouble.add(((IGeometry.Cylindrical)object).innerRadius);
                    }
                    this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), unitDouble.format(decimalFormat)));
                }
            } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                this.d_thickLbl.setText(String.format(Intl.intl("Total Thickness: %s"), unitDouble.format(decimalFormat)));
            } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                IGeometry.Spherical spherical = (IGeometry.Spherical)((SphereOptionPanel)this.d_sphereCard).getGeometry();
                this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), spherical.innerRadius.format(decimalFormat)));
            } else if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                IGeometry.Cylindrical cylindrical = (IGeometry.Cylindrical)((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
                this.d_thickLbl.setText(String.format(Intl.intl("Total Radius: %s"), cylindrical.innerRadius.format(decimalFormat)));
            }
            this.repaint();
        }

        public void loadData(IGeometry iGeometry) {
            IGeometry.Default default_ = IGeometry.DEFAULT;
            this.forceLoad(default_);
            if (iGeometry == null) {
                return;
            }
            this.forceLoad(iGeometry);
        }

        private void forceLoad(IGeometry iGeometry) {
            if (iGeometry instanceof IGeometry.Cartesian) {
                this.d_selected = IGeometry.CARTESIAN.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
                ((CartesianOptionPanel)this.d_cartesianCard).loadGeometry((IGeometry.Cartesian)iGeometry);
            } else if (iGeometry instanceof IGeometry.Cylindrical) {
                this.d_selected = IGeometry.CYLINDRICAL.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
                ((CylinderOptionPanel)this.d_cylinderCard).loadGeometry((IGeometry.Cylindrical)iGeometry);
            } else if (iGeometry instanceof IGeometry.Spherical) {
                this.d_selected = IGeometry.SPHERICAL.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
                ((SphereOptionPanel)this.d_sphereCard).loadGeometry((IGeometry.Spherical)iGeometry);
            } else {
                this.d_selected = IGeometry.DEFAULT.getName();
                this.d_geomCombo.setSelectedItem(this.d_selected);
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2);
        }

        public IGeometry saveData() {
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CARTESIAN.getName())) {
                return ((CartesianOptionPanel)this.d_cartesianCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.CYLINDRICAL.getName())) {
                return ((CylinderOptionPanel)this.d_cylinderCard).getGeometry();
            }
            if (this.d_geomCombo.getSelectedItem().equals(IGeometry.SPHERICAL.getName())) {
                return ((SphereOptionPanel)this.d_sphereCard).getGeometry();
            }
            return IGeometry.DEFAULT;
        }

        private class CylinderOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 6780542549225340270L;
            private ValueField<UnitDouble> d_innerRadius;
            private ValueField<UnitDouble> d_length;
            private guiCheckBox d_lengthCB;

            public CylinderOptionPanel() {
                super(new GridBagLayout());
                this.d_innerRadius = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_innerRadius.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        SurfacePanel.this.d_GeomPanelLayered.updateThicknessLbl();
                    }
                });
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_lengthCB = new guiCheckBox(Intl.intl("Length"));
                LinkStatus.link((AbstractButton)this.d_lengthCB, this.d_length);
                GridBagHelper gridBagHelper = new GridBagHelper(this, false);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Inner Radius:")), this.d_innerRadius);
                gridBagHelper.addRow(this.d_lengthCB, this.d_length);
                gridBagHelper.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cylindrical((UnitDouble)this.d_innerRadius.getValue(), null, this.getLength());
            }

            private Variant getLength() {
                return this.d_lengthCB.isSelected() ? Variant.constant((UnitDouble)this.d_length.getValue()) : Variant.DEFAULT;
            }

            public void loadGeometry(IGeometry.Cylindrical cylindrical) {
                this.d_innerRadius.setValue(cylindrical.innerRadius);
                if (cylindrical.lengthVar.isDefault()) {
                    this.d_lengthCB.setSelected(false);
                } else {
                    this.d_lengthCB.setSelected(true);
                    this.d_length.setValue(cylindrical.lengthVar.val);
                }
            }

            public void setInnerRadius(UnitDouble unitDouble) {
                this.d_innerRadius.setValue(unitDouble);
            }

            public void setLength(UnitDouble unitDouble) {
                this.d_length.setValue(unitDouble);
            }
        }

        private class SphereOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = -6509577654014076105L;
            private ValueField<UnitDouble> d_innerRadius;

            public SphereOptionPanel() {
                super(new GridBagLayout());
                this.d_innerRadius = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_innerRadius.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        SurfacePanel.this.d_GeomPanelLayered.updateThicknessLbl();
                    }
                });
                GridBagHelper gridBagHelper = new GridBagHelper(this, false);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Inner Radius:")), this.d_innerRadius);
                gridBagHelper.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Spherical((UnitDouble)this.d_innerRadius.getValue(), null);
            }

            public void loadGeometry(IGeometry.Spherical spherical) {
                this.d_innerRadius.setValue(spherical.innerRadius);
            }

            public void setInnerRadius(UnitDouble unitDouble) {
                this.d_innerRadius.setValue(unitDouble);
            }
        }

        private class CartesianOptionPanel
        extends guiPanel {
            private static final long serialVersionUID = 579132339706118256L;
            private ValueField<UnitDouble> d_length;
            private ValueField<UnitDouble> d_width;

            public CartesianOptionPanel() {
                super(new GridBagLayout());
                this.d_length = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_width = ValueFields.udFld(UnitSystem.getSource(0));
                GridBagHelper gridBagHelper = new GridBagHelper(this, false);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Length:")), this.d_length);
                gridBagHelper.addRow(new guiLabel(Intl.intl("Width:")), this.d_width);
                gridBagHelper.finalizeRows();
            }

            public IGeometry getGeometry() {
                return new IGeometry.Cartesian((UnitDouble)this.d_length.getValue(), (UnitDouble)this.d_width.getValue());
            }

            public void loadGeometry(IGeometry.Cartesian cartesian) {
                this.d_length.setValue(cartesian.length);
                this.d_width.setValue(cartesian.width);
            }

            public void setLength(UnitDouble unitDouble) {
                this.d_length.setValue(unitDouble);
            }
        }
    }

    private class ReactionPanel
    extends guiPanel {
        private static final long serialVersionUID = -4713295931358534790L;
        private guiRadioButton d_matRB;
        private guiRadioButton d_manualRB;
        private guiRadioButton d_burnImRB;
        private guiRadioButton d_igniteAtRB;
        private ValueField<UnitDouble> d_igniteAt;
        private ValueField<UnitDouble> d_hov;
        private guiCheckBox d_hovCB;
        private HRPanel d_hrReactionPanel;
        private guiCheckBox d_burnAwayCB;

        public ReactionPanel() {
            this.setLayout(new GridBagLayout());
            this.d_matRB = new guiRadioButton(Intl.intl("Governed by Material"));
            this.d_manualRB = new guiRadioButton(Intl.intl("Governed Manually"));
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Ignition"));
            this.d_burnImRB = new guiRadioButton(Intl.intl("Burn Immediately"));
            this.d_igniteAtRB = new guiRadioButton(Intl.intl("Ignite at") + ":");
            this.d_igniteAt = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_hovCB = new guiCheckBox(Intl.intl("Heat of Vaporization") + ":");
            this.d_hov = ValueFields.udFld(UnitSystem.getSource(46));
            this.d_hrReactionPanel = new HRPanel(Intl.intl("Heat Release"));
            this.d_burnAwayCB = new guiCheckBox(Intl.intl("Allow obstruction to burn away"));
            guiPanel guiPanel2 = new guiPanel();
            guiPanel2.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.add(this, this.d_matRB, 0, n++, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_manualRB, 0, n++, 1, 1, 0, 12, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hrReactionPanel, 0, n++, 0, 1, 0, 30, 0, 12, 1, 1.0, 0.0);
            int n2 = 0;
            GridBagUtil.add(guiPanel2, titleSeparator, 0, n2++, 0, 1, 6, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_burnImRB, 0, n2++, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_igniteAtRB, 0, n2, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_igniteAt, 1, n2++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_hovCB, 0, n2, 1, 1, 0, 12, 6, 52, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_hov, 1, n2++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(guiPanel2);
            GridBagUtil.add(this, guiPanel2, 0, n++, 0, 1, -6, 30, 6, 12, 1, 1.0, 0.0);
            GridBagUtil.add(this, this.d_burnAwayCB, 0, n++, 4, 1, 0, 12, 12, 12, 0, 0.0, 0.0);
            GridBagUtil.addGlue(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_matRB);
            buttonGroup.add(this.d_manualRB);
            this.d_matRB.setSelected(true);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.d_burnImRB);
            buttonGroup2.add(this.d_igniteAtRB);
            this.d_burnImRB.setSelected(true);
            LinkStatus.link((AbstractButton)this.d_manualRB, this.d_hrReactionPanel);
            LinkStatus.link((AbstractButton)this.d_manualRB, guiPanel2);
            LinkStatus.link((AbstractButton)this.d_igniteAtRB, this.d_igniteAt);
            LinkStatus.link((AbstractButton)this.d_hovCB, this.d_hov);
        }

        public void loadData(Fuel.IReaction iReaction, boolean bl) {
            this.d_hrReactionPanel.loadData(null);
            this.d_matRB.setSelected(true);
            this.d_burnImRB.setSelected(true);
            this.d_igniteAt.setValue(new Fuel.ManualReac.TemperatureIgnite().d_temperature);
            this.d_hov.setValue(new Fuel.ManualReac().d_heatOfVap);
            this.d_burnAwayCB.setSelected(bl);
            if (iReaction == null) {
                return;
            }
            if (iReaction instanceof Fuel.MaterialReac) {
                this.d_matRB.setSelected(true);
                this.d_hrReactionPanel.loadData(new Fuel.ManualReac().d_heatRelease);
                this.d_burnImRB.setSelected(true);
            } else {
                Fuel.ManualReac manualReac = (Fuel.ManualReac)iReaction;
                this.d_manualRB.setSelected(true);
                this.d_hrReactionPanel.loadData(manualReac.d_heatRelease);
                if (manualReac.d_ignition instanceof Fuel.ManualReac.ImmediateIgnite) {
                    this.d_burnImRB.setSelected(true);
                } else {
                    this.d_igniteAtRB.setSelected(true);
                    this.d_igniteAt.setValue(((Fuel.ManualReac.TemperatureIgnite)manualReac.d_ignition).d_temperature);
                }
                if (manualReac.d_heatOfVap != null) {
                    this.d_hovCB.setSelected(true);
                    this.d_hov.setValue(manualReac.d_heatOfVap);
                } else {
                    this.d_hovCB.setSelected(false);
                }
            }
        }

        public Fuel.IReaction saveData() {
            UnitDouble unitDouble;
            if (this.d_matRB.isSelected()) {
                return new Fuel.MaterialReac();
            }
            UnitDouble unitDouble2 = unitDouble = this.d_hovCB.isSelected() ? (UnitDouble)this.d_hov.getValue() : null;
            if (this.d_burnImRB.isSelected()) {
                return new Fuel.ManualReac(this.d_hrReactionPanel.saveData(), unitDouble, new Fuel.ManualReac.ImmediateIgnite());
            }
            return new Fuel.ManualReac(this.d_hrReactionPanel.saveData(), unitDouble, new Fuel.ManualReac.TemperatureIgnite((UnitDouble)this.d_igniteAt.getValue()));
        }

        public boolean burnAway() {
            return this.d_burnAwayCB.isSelected();
        }

        public void allowBurnAway(boolean bl) {
            this.d_burnAwayCB.setVisible(bl);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_igniteAtRB.isSelected() && ((UnitDouble)this.d_igniteAt.getValue()).ge(new UnitDouble(5000.0, SI.KELVIN), 0.0)) {
                if (bl) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("FDS treats an ignition temperature >= 5000 K (4726.85 \u2103) equivalent to the Burn Immediately option.\nOn the Reaction tab, decrease the ignition temperature under 5000 K, or select the Burn Immediately option."), Intl.intl("The ignition temperature is too high"), 0);
                }
                return false;
            }
            return true;
        }
    }

    private class AirFlowPanel
    extends guiPanel {
        private static final long serialVersionUID = -2598076021382714315L;
        private guiRadioButton d_velRB;
        private guiRadioButton d_volumeFluxRB;
        private guiRadioButton d_massFluxTotalRB;
        private guiRadioButton d_exSpecMassFluxRB;
        private final ValueField<UnitDouble> d_vel;
        private final ValueField<UnitDouble> d_volumeFlux;
        private final ValueField<UnitDouble> d_massFluxTotal;
        private final ValueField<UnitDouble> d_velT;
        private final ValueField<UnitDouble> d_velBT;
        private final ValueField<UnitDouble> d_atmProfOrig;
        private ValueField<Double> d_atmProfExp;
        private guiComboBox d_windCombo;
        private final ComponentGroup d_windGroup;
        private final TimeFunctionEditor d_RampTimeEditor;
        private IAirflowConfig d_typeConfig;

        public AirFlowPanel() {
            this.setLayout(new GridBagLayout());
            this.d_velRB = new guiRadioButton(Intl.intl("Specify Velocity") + ":");
            this.d_vel = ValueFields.udFld(UnitSystem.getSource(8));
            this.d_volumeFluxRB = new guiRadioButton(Intl.intl("Specify Volume Flow") + ":");
            this.d_volumeFlux = ValueFields.udFld(UnitSystem.getSource(24));
            this.d_massFluxTotalRB = new guiRadioButton(Intl.intl("Specify Total Mass Flux") + ":");
            this.d_massFluxTotal = ValueFields.udFld(UnitSystem.getSource(44));
            this.d_massFluxTotal.setPreferredSize(new Dimension(150, 20));
            this.d_exSpecMassFluxRB = new guiRadioButton(Intl.intl("Specify Mass Flux of Individual Species"));
            this.d_velT = ValueFields.udFld(UnitSystem.getSource(8));
            this.d_velBT = ValueFields.udFld(UnitSystem.getSource(8));
            this.setColumns(6, this.d_velT, this.d_velBT);
            this.d_RampTimeEditor = SurfacePanel.this.newTimeFuncEditor();
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Atmospheric Profile Exponent") + ":");
            this.d_atmProfExp = ValueFields.doubleFld(0.3);
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Atmospheric Profile Origin") + ":");
            this.d_atmProfOrig = ValueFields.udFld(UnitSystem.getSource(0));
            this.d_windGroup = new ComponentGroup();
            this.d_windGroup.add(guiLabel2);
            this.d_windGroup.add(this.d_atmProfExp);
            this.d_windGroup.add(guiLabel3);
            this.d_windGroup.add(this.d_atmProfOrig);
            this.d_windGroup.setVisible(false);
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Wind Profile") + ":");
            String string = Intl.intl("Top Hat (Default)");
            String string2 = Intl.intl("Parabolic");
            final String string3 = Intl.intl("Atmospheric");
            String[] stringArray = new String[]{string, string2, string3};
            this.d_windCombo = new guiComboBox<String>((T[])stringArray);
            this.d_windCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = itemEvent.getItem().toString();
                    if (string3.equals(string)) {
                        AirFlowPanel.this.d_windGroup.setVisible(true);
                    } else {
                        AirFlowPanel.this.d_windGroup.setVisible(false);
                    }
                }
            });
            int n = 0;
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Normal Flow Rate"));
            GridBagUtil.add(this, titleSeparator, 0, n++, 10, 1, 12, 12, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_volumeFluxRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_volumeFlux, 2, n++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_velRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_vel, 2, n++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxTotalRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxTotal, 2, n++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_exSpecMassFluxRB, 0, n++, 10, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
            GridBagUtil.add(guiPanel2, this.d_velT, 0, 0, 1, 1, 0, 0, 0, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_velBT, 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, new guiLabel(Intl.intl("Tangential Velocity:")), 0, n, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiPanel2, 2, n++, 2, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_RampTimeEditor.addToPanel(this, 0, n++, 0, 12, 6, 12);
            GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_windCombo, 1, n++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, new JSeparator(0), 0, n++, 10, 1, 0, 12, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_atmProfExp, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_atmProfOrig, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_velRB);
            buttonGroup.add(this.d_volumeFluxRB);
            buttonGroup.add(this.d_massFluxTotalRB);
            buttonGroup.add(this.d_exSpecMassFluxRB);
            this.d_velRB.setSelected(true);
            LinkStatus.link((AbstractButton)this.d_velRB, this.d_vel);
            LinkStatus.link((AbstractButton)this.d_volumeFluxRB, this.d_volumeFlux);
            LinkStatus.link((AbstractButton)this.d_massFluxTotalRB, this.d_massFluxTotal);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AirFlowPanel.this.updateBlower();
                    AirFlowPanel.this.updateRampEditorEnabled();
                }
            };
            this.d_volumeFluxRB.addActionListener(actionListener);
            this.d_velRB.addActionListener(actionListener);
            this.d_massFluxTotalRB.addActionListener(actionListener);
            this.d_exSpecMassFluxRB.addActionListener(actionListener);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.d_RampTimeEditor.validateData(bl, bl2)) {
                return false;
            }
            if (bl) {
                String string;
                int n;
                PyroMod pyroMod = PyroSim.getApp().getMediator();
                SimParams simParams = pyroMod.getSimParams();
                SimParams.Environment environment = simParams.getEnvironment();
                UnitDouble unitDouble = environment.getGroundLevel();
                UnitDouble unitDouble2 = (UnitDouble)this.d_atmProfOrig.getValue();
                if (unitDouble2.compareTo(unitDouble) < 0 && (n = JOptionPane.showConfirmDialog(this, string = Intl.intl("Warning: Atmospheric profile origin below simulation\nparameter GROUND_LEVEL."), Intl.intl("Warning"), 2, 2)) == 2) {
                    return false;
                }
            }
            return true;
        }

        private void enableExSpecMassFlux(boolean bl) {
            if (!bl && this.d_exSpecMassFluxRB.isSelected()) {
                this.d_velRB.setSelected(true);
            }
            this.d_exSpecMassFluxRB.setVisible(bl);
        }

        public void setSurfaceDescription(String string) {
            if (SUPPLY.equals(string)) {
                this.d_massFluxTotalRB.setVisible(false);
                this.d_massFluxTotal.setVisible(false);
                if (this.d_massFluxTotalRB.isSelected()) {
                    this.d_velRB.setSelected(true);
                }
            } else {
                this.d_massFluxTotalRB.setVisible(true);
            }
        }

        private void setColumns(int n, Component ... componentArray) {
            for (Component component : componentArray) {
                if (!(component instanceof JTextField)) continue;
                ((JTextField)component).setColumns(n);
            }
        }

        public void updateBlower() {
            if (((String)SurfacePanel.this.d_profileListBox.getSelectedItem()).equals(SUPPLY) || ((String)SurfacePanel.this.d_profileListBox.getSelectedItem()).equals(GENERAL)) {
                if (this.d_exSpecMassFluxRB.isSelected()) {
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(true, false);
                } else {
                    SurfacePanel.this.d_specInjPanel.setInjectionOptions(false, true);
                }
            }
        }

        private void setVelAboveZeroOnly(boolean bl) {
            this.setVelAboveZero(this.d_vel, bl);
            this.setVelAboveZero(this.d_volumeFlux, bl);
            this.setVelAboveZero(this.d_massFluxTotal, bl);
        }

        private void setVelAboveZero(ValueField<UnitDouble> valueField, boolean bl) {
            UnitDoubleFormat unitDoubleFormat = (UnitDoubleFormat)valueField.getFormat();
            Unit unit = unitDoubleFormat.getUnitType().getUnit();
            String string = valueField.getText();
            valueField.setFilter(bl ? UnitDoubleVR.above(0.0, unit, true) : UnitDoubleVR.UNBOUNDED);
            valueField.setText(string);
        }

        public void updateRampEditorEnabled() {
            if (this.d_exSpecMassFluxRB.isSelected()) {
                this.d_RampTimeEditor.setEnabled(false);
            } else {
                this.d_RampTimeEditor.setEnabled(true);
            }
        }

        public void loadData(AirFlow airFlow, boolean bl) {
            AirFlow airFlow2 = new AirFlow();
            this.d_volumeFlux.setValue(new AirFlow.VolumeFlux().val);
            this.d_velT.setValue(((AirFlow.VolumeFlux)airFlow2.d_rate).tanVelU);
            this.d_velBT.setValue(((AirFlow.VolumeFlux)airFlow2.d_rate).tanVelV);
            this.d_vel.setValue(new AirFlow.NormalVel().val);
            this.d_massFluxTotal.setValue(new AirFlow.TotalMassFlux().val);
            this.d_atmProfExp.setValue(new AirFlow.AtmosphericProf().d_exponent);
            this.d_atmProfOrig.setValue(new AirFlow.AtmosphericProf().d_origin);
            this.d_velRB.setSelected(true);
            this.updateBlower();
            this.d_windCombo.setSelectedIndex(0);
            this.setVelAboveZeroOnly(bl);
            if (airFlow == null) {
                return;
            }
            if (airFlow.d_rate instanceof AirFlow.NormalVel) {
                this.d_velRB.setSelected(true);
                this.d_vel.setValue(((AirFlow.NormalVel)airFlow.d_rate).val);
            } else if (airFlow.d_rate instanceof AirFlow.VolumeFlux) {
                this.d_volumeFluxRB.setSelected(true);
                this.d_volumeFlux.setValue(((AirFlow.VolumeFlux)airFlow.d_rate).val);
            } else if (airFlow.d_rate instanceof AirFlow.TotalMassFlux) {
                this.d_massFluxTotalRB.setSelected(true);
                this.d_massFluxTotal.setValue(((AirFlow.TotalMassFlux)airFlow.d_rate).val);
            } else {
                this.d_exSpecMassFluxRB.setSelected(true);
            }
            if (SurfacePanel.this.d_profileListBox.getSelectedItem() != EXHAUST) {
                SurfacePanel.this.d_specInjPanel.loadData(airFlow.d_rate.specInj);
            }
            this.updateRampEditorEnabled();
            this.d_velT.setValue(airFlow.d_rate.tanVelU);
            this.d_velBT.setValue(airFlow.d_rate.tanVelV);
            this.d_RampTimeEditor.loadFunction(airFlow.d_rate.func);
            if (airFlow.d_profile instanceof AirFlow.ParabolicProf) {
                this.d_windCombo.setSelectedIndex(1);
                this.d_windGroup.setVisible(false);
            } else if (airFlow.d_profile instanceof AirFlow.AtmosphericProf) {
                this.d_windCombo.setSelectedIndex(2);
                this.d_windGroup.setVisible(true);
                AirFlow.AtmosphericProf atmosphericProf = (AirFlow.AtmosphericProf)airFlow.d_profile;
                this.d_atmProfExp.setValue(atmosphericProf.d_exponent);
                this.d_atmProfOrig.setValue(atmosphericProf.d_origin);
            } else {
                this.d_windCombo.setSelectedIndex(0);
                this.d_windGroup.setVisible(false);
            }
        }

        public AirFlow saveData(PyroMod pyroMod) {
            SpecInjList specInjList = null;
            if (SurfacePanel.this.d_profileListBox.getSelectedItem() != EXHAUST) {
                specInjList = SurfacePanel.this.d_specInjPanel.saveData(pyroMod);
            }
            TimeFunction<?> timeFunction = this.d_RampTimeEditor.isEnabled() ? this.d_RampTimeEditor.saveFunction() : TimeFunction.newDefault();
            UnitDouble unitDouble = (UnitDouble)this.d_velT.getValue();
            UnitDouble unitDouble2 = (UnitDouble)this.d_velBT.getValue();
            AirFlow.Rate rate = this.d_velRB.isSelected() ? new AirFlow.NormalVel((UnitDouble)this.d_vel.getValue(), unitDouble, unitDouble2, timeFunction, specInjList) : (this.d_volumeFluxRB.isSelected() ? new AirFlow.VolumeFlux((UnitDouble)this.d_volumeFlux.getValue(), unitDouble, unitDouble2, timeFunction, specInjList) : (this.d_massFluxTotalRB.isSelected() ? new AirFlow.TotalMassFlux((UnitDouble)this.d_massFluxTotal.getValue(), unitDouble, unitDouble2, timeFunction, specInjList) : new AirFlow.ExSpecMassFlux(unitDouble, unitDouble2, timeFunction, specInjList)));
            int n = this.d_windCombo.getSelectedIndex();
            AirFlow.IProfile iProfile = n == 1 ? new AirFlow.ParabolicProf() : (n == 2 ? new AirFlow.AtmosphericProf((Double)this.d_atmProfExp.getValue(), (UnitDouble)this.d_atmProfOrig.getValue()) : new AirFlow.TopHatProf());
            return new AirFlow(rate, iProfile);
        }
    }

    private class ThermalPanel
    extends guiPanel {
        private static final long serialVersionUID = 1360048921292861572L;
        private final guiRadioButton d_defaultHTModelRb;
        private final guiRadioButton d_logHTModelRb;
        private final guiRadioButton d_userHTModelRb;
        private final ValueField<UnitDouble> d_heatTransCoef;
        private final guiComboBox d_bcOptCombo;
        private final ValueField<UnitDouble> d_surfaceTemp;
        private final ValueField<UnitDouble> d_netFlux;
        private final ValueField<UnitDouble> d_convFlux;
        private final ValueField<Double> d_emissivity;
        private final TimeFunctionEditor d_rampTimeEditor;

        public ThermalPanel() {
            this.setLayout(new GridBagLayout());
            this.d_defaultHTModelRb = new guiRadioButton(Intl.intl("Default"));
            this.d_logHTModelRb = new guiRadioButton(Intl.intl("Logarithmic"));
            this.d_userHTModelRb = new guiRadioButton(Intl.intl("Specify Heat Transfer Coefficient"));
            new guiButtonGroup(this.d_defaultHTModelRb, this.d_logHTModelRb, this.d_userHTModelRb);
            this.d_defaultHTModelRb.setSelected(true);
            this.d_heatTransCoef = ValueFields.udFld(UnitSystem.getSource(81));
            LinkStatus.link((AbstractButton)this.d_userHTModelRb, this.d_heatTransCoef);
            this.d_userHTModelRb.addActionListener(actionEvent -> {
                if (this.d_heatTransCoef.isEmpty()) {
                    this.d_heatTransCoef.setValue(SIUS.newud(0.0, 81));
                }
                this.d_heatTransCoef.requestFocusInWindow();
            });
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Boundary Condition Model:"));
            this.d_bcOptCombo = new guiComboBox<Object>((T[])new Object[]{ADIABATIC_OPT, FIXED_TEMP_OPT, NETFLUX_OPT, TOTALFLUX_OPT});
            final guiLabel guiLabel3 = new guiLabel(Intl.intl("Surface Temperature"));
            final guiLabel guiLabel4 = new guiLabel(Intl.intl("Emissivity"));
            final guiLabel guiLabel5 = new guiLabel(Intl.intl("Net Heat Flux"));
            final guiLabel guiLabel6 = new guiLabel(Intl.intl("Convective Heat Flux"));
            this.d_surfaceTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_surfaceTemp.setNullAllowed(true);
            ValueFields.getFormat(this.d_surfaceTemp).alias(null, "", "TMPA");
            this.d_netFlux = ValueFields.udFld(UnitSystem.getSource(33));
            this.d_convFlux = ValueFields.udFld(UnitSystem.getSource(33));
            this.d_emissivity = ValueFields.doubleFld();
            this.d_rampTimeEditor = SurfacePanel.this.newTimeFuncEditor();
            this.d_bcOptCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiLabel3.setEnabled(false);
                    guiLabel4.setEnabled(false);
                    guiLabel5.setEnabled(false);
                    guiLabel6.setEnabled(false);
                    ThermalPanel.this.d_surfaceTemp.setEnabled(false);
                    ThermalPanel.this.d_emissivity.setEnabled(false);
                    ThermalPanel.this.d_netFlux.setEnabled(false);
                    ThermalPanel.this.d_convFlux.setEnabled(false);
                    ThermalPanel.this.d_rampTimeEditor.setEnabled(false);
                    if (ThermalPanel.this.d_bcOptCombo.getSelectedItem().equals(ADIABATIC_OPT)) {
                        ThermalPanel.this.d_emissivity.setValue(1.0);
                    } else if (ThermalPanel.this.d_bcOptCombo.getSelectedItem().equals(FIXED_TEMP_OPT)) {
                        guiLabel3.setEnabled(true);
                        guiLabel4.setEnabled(true);
                        ThermalPanel.this.d_surfaceTemp.setEnabled(true);
                        ThermalPanel.this.d_emissivity.setEnabled(true);
                    } else if (ThermalPanel.this.d_bcOptCombo.getSelectedItem().equals(NETFLUX_OPT)) {
                        guiLabel5.setEnabled(true);
                        guiLabel4.setEnabled(true);
                        ThermalPanel.this.d_netFlux.setEnabled(true);
                        ThermalPanel.this.d_emissivity.setEnabled(true);
                    } else if (ThermalPanel.this.d_bcOptCombo.getSelectedItem().equals(TOTALFLUX_OPT)) {
                        guiLabel6.setEnabled(true);
                        guiLabel3.setEnabled(true);
                        guiLabel4.setEnabled(true);
                        ThermalPanel.this.d_convFlux.setEnabled(true);
                        ThermalPanel.this.d_surfaceTemp.setEnabled(true);
                        ThermalPanel.this.d_emissivity.setEnabled(true);
                        ThermalPanel.this.d_rampTimeEditor.setEnabled(true);
                    } else if (ThermalPanel.this.d_bcOptCombo.getSelectedItem().equals(CALC_TEMP_OPT)) {
                        guiLabel4.setEnabled(true);
                        ThermalPanel.this.d_emissivity.setEnabled(true);
                    }
                }
            });
            this.loadData(null);
            int n = 0;
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Convective Heat Transfer Model"));
            GridBagUtil.add(this, titleSeparator, 0, n++, 0, 1, 12, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_defaultHTModelRb, 0, n++, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_logHTModelRb, 0, n++, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_userHTModelRb, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatTransCoef, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            TitleSeparator titleSeparator2 = new TitleSeparator(Intl.intl("Thermal Boundary Conditions"));
            GridBagUtil.add(this, titleSeparator2, 0, n++, 0, 1, 12, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_bcOptCombo, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_surfaceTemp, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel4, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_emissivity, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel5, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_netFlux, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel6, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_convFlux, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_rampTimeEditor.addToPanel(this, 0, n++, 0, 30, 6, 12);
            GridBagUtil.addGlue(this);
        }

        public void updateOptions(Object ... objectArray) {
            this.d_bcOptCombo.setItems(objectArray);
            this.loadData(null);
        }

        public void loadData(TempRegulation tempRegulation) {
            TempRegulation tempRegulation2 = null;
            if (this.d_bcOptCombo.contains(FIXED_TEMP_OPT)) {
                tempRegulation2 = TempRegulation.newFixedTempTR(null, 0.9, null, false);
            } else if (this.d_bcOptCombo.contains(CALC_TEMP_OPT)) {
                tempRegulation2 = TempRegulation.newCalcTempTR(0.9, null, false);
            } else if (this.d_bcOptCombo.contains(NETFLUX_OPT)) {
                tempRegulation2 = TempRegulation.newNetHeatFluxTR(new UnitDouble(0.0, SurfacePanel.this.d_currentUS.getUnit(33)), 0.9, null, false);
            } else if (this.d_bcOptCombo.contains(ADIABATIC_OPT)) {
                tempRegulation2 = TempRegulation.newAdiabaticTR(null, false);
            } else if (this.d_bcOptCombo.contains(TOTALFLUX_OPT)) {
                tempRegulation2 = TempRegulation.newFixedHeatFluxTR(new UnitDouble(0.0, SurfacePanel.this.d_currentUS.getUnit(1)), new UnitDouble(0.0, SurfacePanel.this.d_currentUS.getUnit(33)), null, 0.9, null, false);
            } else assert (false);
            this.forceLoad(tempRegulation2);
            if (tempRegulation == null) {
                return;
            }
            this.forceLoad(tempRegulation);
        }

        private void forceLoad(TempRegulation tempRegulation) {
            if (tempRegulation.d_logarithmic) {
                this.d_logHTModelRb.setSelected(true);
            } else if (tempRegulation.d_htCoef != null) {
                this.d_userHTModelRb.setSelected(true);
                this.d_heatTransCoef.setValue(tempRegulation.d_htCoef);
            } else {
                this.d_defaultHTModelRb.setSelected(true);
            }
            if (tempRegulation.isAdiabaticTR()) {
                this.d_bcOptCombo.setSelectedItem(ADIABATIC_OPT);
            } else if (tempRegulation.isNetHeatFluxTR()) {
                this.d_bcOptCombo.setSelectedItem(NETFLUX_OPT);
                this.d_netFlux.setValue(tempRegulation.d_thermalBCs.d_netHeatFlux);
                this.d_emissivity.setValue(tempRegulation.d_thermalBCs.d_emissivity);
            } else if (tempRegulation.isGrossFluxTR()) {
                this.d_bcOptCombo.setSelectedItem(TOTALFLUX_OPT);
                this.d_convFlux.setValue(tempRegulation.d_thermalBCs.d_heatFlux);
                this.d_surfaceTemp.setValue(tempRegulation.d_thermalBCs.d_temperature);
                this.d_emissivity.setValue(tempRegulation.d_thermalBCs.d_emissivity);
                this.d_rampTimeEditor.loadFunction(tempRegulation.d_thermalBCs.d_rampup);
            } else if (tempRegulation.isCalcTempTR()) {
                this.d_bcOptCombo.setSelectedItem(CALC_TEMP_OPT);
                this.d_emissivity.setValue(tempRegulation.d_thermalBCs.d_emissivity);
            } else if (tempRegulation.isFixedTempTR()) {
                this.d_bcOptCombo.setSelectedItem(FIXED_TEMP_OPT);
                this.d_surfaceTemp.setValue(tempRegulation.d_thermalBCs.d_temperature);
                this.d_emissivity.setValue(tempRegulation.d_thermalBCs.d_emissivity);
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2);
        }

        public TempRegulation saveData() {
            UnitDouble unitDouble = null;
            if (this.d_userHTModelRb.isSelected()) {
                unitDouble = (UnitDouble)this.d_heatTransCoef.getValue();
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(ADIABATIC_OPT)) {
                return TempRegulation.newAdiabaticTR(unitDouble, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(FIXED_TEMP_OPT)) {
                return TempRegulation.newFixedTempTR((UnitDouble)this.d_surfaceTemp.getValue(), (Double)this.d_emissivity.getValue(), unitDouble, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(CALC_TEMP_OPT)) {
                return TempRegulation.newCalcTempTR((Double)this.d_emissivity.getValue(), unitDouble, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(NETFLUX_OPT)) {
                return TempRegulation.newNetHeatFluxTR((UnitDouble)this.d_netFlux.getValue(), (Double)this.d_emissivity.getValue(), unitDouble, this.d_logHTModelRb.isSelected());
            }
            if (this.d_bcOptCombo.getSelectedItem().equals(TOTALFLUX_OPT)) {
                return TempRegulation.newFixedHeatFluxTR((UnitDouble)this.d_surfaceTemp.getValue(), (UnitDouble)this.d_convFlux.getValue(), this.d_rampTimeEditor.saveFunction(), (Double)this.d_emissivity.getValue(), unitDouble, this.d_logHTModelRb.isSelected());
            }
            return null;
        }
    }

    private class PartInjPanel
    extends guiPanel {
        private static final long serialVersionUID = 1785549285173004487L;
        private guiCheckBox d_emitPartCB;
        private ValueField<Integer> d_nppc;
        private final ValueField<UnitDouble> d_dtInsert;
        private final guiLabel d_massFluxLab;
        private final ValueField<UnitDouble> d_massFlux;
        private final TimeFunctionEditor d_mfFuncEditor;
        private final ParticleComboBox d_particleCombo;

        public PartInjPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_emitPartCB = new guiCheckBox(Intl.intl("Emit Particles"));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Particle Type") + ":");
            this.d_particleCombo = new ParticleComboBox(PyroSim.getApp().getMediator().getPartList(), null, null);
            JButton jButton = new JButton(Intl.intl("Edit Particles") + "...");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Number of Particles Per Cell") + ":");
            this.d_nppc = ValueFields.intFld(1);
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Insertion Interval:"));
            this.d_dtInsert = ValueFields.udFld(0.01, (Unit)SI.SECOND, UnitSystem.getSource(2));
            this.d_mfFuncEditor = SurfacePanel.this.newTimeFuncEditor();
            this.d_massFluxLab = new guiLabel(Intl.intl("Mass Flux") + ":");
            this.d_massFluxLab.setToolTipText("PARTICLE_MASS_FLUX");
            this.d_massFlux = ValueFields.udFld(UnitSystem.getSource(44));
            this.d_massFluxLab.setEnabled(false);
            this.d_massFlux.setEnabled(false);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JButton) {
                        Actions.editParticles((Particle)PartInjPanel.this.d_particleCombo.getSelectedItem());
                        if (PartInjPanel.this.d_particleCombo.getSelectedItem() == null && PartInjPanel.this.d_particleCombo.getItemCount() > 0) {
                            PartInjPanel.this.d_particleCombo.setSelectedIndex(0);
                        }
                    }
                    PartInjPanel.this.updateMassFluxStatus();
                }
            };
            GridBagUtil.add(this, this.d_emitPartCB, 0, n++, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_particleCombo, 2, n, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, jButton, 3, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_nppc, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel4, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dtInsert, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxLab, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFlux, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_mfFuncEditor.addToPanel(this, 0, n++, 0, 48, 6, 12);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_emitPartCB, guiLabel2, this.d_particleCombo, jButton, guiLabel3, this.d_nppc, guiLabel4, this.d_dtInsert, this.d_massFluxLab, this.d_massFlux);
            LinkStatus.link((AbstractButton)this.d_emitPartCB, this.d_mfFuncEditor.getComponents());
            this.d_emitPartCB.addActionListener(actionListener);
            this.d_particleCombo.addActionListener(actionListener);
            jButton.addActionListener(actionListener);
        }

        private void updateMassFluxStatus() {
            Particle particle = (Particle)this.d_particleCombo.getSelectedItem();
            boolean bl = this.d_emitPartCB.isSelected() && particle != null && !particle.isType(Particle.Type.TRACER);
            this.d_massFluxLab.setEnabled(bl);
            this.d_massFlux.setEnabled(bl);
            for (Component component : this.d_mfFuncEditor.getComponents()) {
                component.setEnabled(bl);
            }
        }

        public void loadData(ParticleInjection particleInjection) {
            this.d_nppc.setValue(new ParticleInjection().d_numPartsPerCell);
            TimeBasedValue<UnitDouble> timeBasedValue = new ParticleInjection().getMassFlux();
            this.d_massFlux.setValue(timeBasedValue != null ? timeBasedValue.val : null);
            this.d_mfFuncEditor.loadFunction(timeBasedValue != null ? timeBasedValue.func : TimeFunction.newDefault());
            if (particleInjection != null && particleInjection.getParticle() != null) {
                this.d_emitPartCB.setSelected(true);
                this.d_particleCombo.setSelectedItem(particleInjection.getParticle());
                this.d_nppc.setValue(particleInjection.d_numPartsPerCell);
                this.d_dtInsert.setValue(particleInjection.d_dtInsert);
                TimeBasedValue<UnitDouble> timeBasedValue2 = particleInjection.getMassFlux();
                if (timeBasedValue2 != null) {
                    this.d_massFlux.setValue(timeBasedValue2.val);
                    this.d_mfFuncEditor.loadFunction(timeBasedValue2.func);
                }
                this.updateMassFluxStatus();
            } else {
                this.d_emitPartCB.setSelected(false);
                for (int i = 0; i < this.d_particleCombo.getItemCount(); ++i) {
                    if (!((Particle)this.d_particleCombo.getItemAt(i)).isType(Particle.Type.TRACER)) continue;
                    this.d_particleCombo.setSelectedIndex(i);
                    break;
                }
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_mfFuncEditor.validateData(bl, bl2);
        }

        public ParticleInjection saveData() {
            if (this.d_emitPartCB.isSelected()) {
                TimeBasedValue<UnitDouble> timeBasedValue = null;
                if (this.d_massFlux.isEnabled()) {
                    UnitDouble unitDouble = (UnitDouble)this.d_massFlux.getValue();
                    timeBasedValue = new TimeBasedValue<UnitDouble>(unitDouble, this.d_mfFuncEditor.saveFunction());
                }
                return new ParticleInjection((Particle)this.d_particleCombo.getSelectedItem(), (Integer)this.d_nppc.getValue(), timeBasedValue, (UnitDouble)this.d_dtInsert.getValue());
            }
            return null;
        }
    }

    private class SpecInjPanel
    extends guiPanel {
        private static final long serialVersionUID = 8326897486652703918L;
        private final guiTableEditor d_editor;
        private final guiTable d_table;
        private final guiRadioButton d_massFracRB;
        private final guiRadioButton d_massFluxRB;
        private final String DEFAULT = TimeFunctionEditor.STR_DEFAULT;
        private final String TANH = TimeFunctionEditor.STR_TANH;
        private final String TSQUARED = TimeFunctionEditor.STR_TSQUARED;
        private final String CUSTOM = TimeFunctionEditor.STR_CUSTOM;
        private final String MASSFRAC = Intl.intl("Mass Fraction");
        private final String MASSFLUX = Intl.intl("Mass Flux");
        private Map<ExSpec, Integer> d_esMap;
        private ExSpec[] d_availExSpec;

        public SpecInjPanel() {
            this.setLayout(new GridBagLayout());
            this.d_esMap = null;
            this.d_availExSpec = null;
            this.d_massFracRB = new guiRadioButton(String.format(Intl.intl("Inject by Mass Fraction (%1$s)"), SurfacePanel.this.d_currentUS.getMassFractionUnit().toString()));
            this.d_massFluxRB = new guiRadioButton(String.format(Intl.intl("Inject by Mass Flux (%1$s)"), SurfacePanel.this.d_currentUS.getMLRPUA().toString()));
            this.d_massFracRB.setSelected(true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_massFluxRB);
            buttonGroup.add(this.d_massFracRB);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SpecInjPanel.this.d_massFracRB.isSelected()) {
                        SpecInjPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(SpecInjPanel.this.MASSFRAC + " (" + SurfacePanel.this.d_currentUS.getMassFractionUnit().toString() + ")");
                    } else {
                        SpecInjPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(SpecInjPanel.this.MASSFLUX + " (" + SurfacePanel.this.d_currentUS.getMLRPUA().toString() + ")");
                    }
                    SpecInjPanel.this.d_table.forceColumnUpdate();
                }
            };
            this.d_massFluxRB.addItemListener(itemListener);
            this.d_massFracRB.addItemListener(itemListener);
            final guiTable.UnitDoubleEditor unitDoubleEditor = new guiTable.UnitDoubleEditor(UnitSystem.getSource(2).getUnit(), UnitDoubleVR.above(0.0, SI.SECOND, true), false);
            final guiTable.UnitDoubleRenderer unitDoubleRenderer = new guiTable.UnitDoubleRenderer();
            final RampTableCell rampTableCell = new RampTableCell(this);
            this.d_table = new guiTable(new SpecInjTable(), 0){
                private static final long serialVersionUID = 4751308018369244416L;

                @Override
                public TableCellRenderer getCellRenderer(int n, int n2) {
                    if (n2 == 3) {
                        if (this.isRampType(n, n2)) {
                            return rampTableCell;
                        }
                        return unitDoubleRenderer;
                    }
                    return super.getCellRenderer(n, n2);
                }

                @Override
                public TableCellEditor getCellEditor(int n, int n2) {
                    if (n2 == 3) {
                        if (this.isRampType(n, n2)) {
                            return rampTableCell;
                        }
                        return unitDoubleEditor;
                    }
                    return super.getCellEditor(n, n2);
                }

                private boolean isRampType(int n, int n2) {
                    Object object = this.getValueAt(n, n2);
                    if (object instanceof Ramp) {
                        return true;
                    }
                    return object == null && SpecInjPanel.this.CUSTOM.equals(this.getValueAt(n, 2));
                }
            };
            this.d_table.getColumnModel().getColumn(0).setCellRenderer(new ExSpecRenderer());
            this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.guiDoubleEditor());
            this.d_table.getColumnModel().getColumn(1).setCellRenderer(new guiTable.guiDoubleRenderer());
            this.d_table.setColumnOptions(2, this.DEFAULT, this.TANH, this.TSQUARED, this.CUSTOM);
            this.d_table.setClipboard(3, (guiTableClipboard)new RampUpValueClipboard());
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(120);
            this.d_table.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.d_table.getColumnModel().getColumn(2).setPreferredWidth(50);
            this.d_table.getColumnModel().getColumn(3).setPreferredWidth(100);
            this.d_table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getColumn() != 2 && tableModelEvent.getColumn() != 3) {
                        return;
                    }
                    for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                        Object object;
                        String string = (String)SpecInjPanel.this.d_table.getValueAt(i, 2);
                        Object object2 = SpecInjPanel.this.d_table.getValueAt(i, 3);
                        if (tableModelEvent.getColumn() == 2) {
                            object = object2;
                            if (string == SpecInjPanel.this.CUSTOM && !(object2 instanceof Ramp)) {
                                object = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
                            } else if (string == SpecInjPanel.this.DEFAULT) {
                                object = TimeFunction.newDefault().val;
                            } else if (string != null && string != SpecInjPanel.this.CUSTOM && !(object2 instanceof UnitDouble)) {
                                object = SIUS.newud(1.0, 2);
                            }
                            if (Objects.equals(object, object2)) continue;
                            SpecInjPanel.this.d_table.setValueAt(object, i, 3);
                            continue;
                        }
                        if (tableModelEvent.getColumn() != 3) continue;
                        object = string;
                        if (object2 instanceof Ramp) {
                            object = SpecInjPanel.this.CUSTOM;
                        } else if (object2 instanceof UnitDouble && SpecInjPanel.this.CUSTOM.equals(string)) {
                            object = SpecInjPanel.this.TANH;
                        }
                        if (Objects.equals(object, string)) continue;
                        SpecInjPanel.this.d_table.setValueAt(object, i, 2);
                    }
                }
            });
            this.d_editor = new guiTableEditor(this.d_table, 0);
            this.d_table.autoSizeColumns(100);
            GridBagUtil.add(this, this.d_massFracRB, 0, 0, 2, 1, 12, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFluxRB, 0, 1, 2, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_editor, 0, 4, 10, 1, 12, 12, 12, 12, 1, 1.0, 1.0);
        }

        public void setInjectionOptions(boolean bl, boolean bl2) {
            assert (bl || bl2);
            this.d_massFluxRB.setEnabled(bl);
            this.d_massFracRB.setEnabled(bl2);
            boolean bl3 = true;
            if (bl && !bl2) {
                this.d_massFluxRB.setSelected(true);
                bl3 = false;
            } else if (!bl && bl2) {
                this.d_massFracRB.setSelected(true);
                bl3 = false;
            }
            this.d_massFluxRB.setVisible(bl3);
            this.d_massFracRB.setVisible(bl3);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            int n;
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (SurfacePanel.this.d_tabs.indexOfComponent(SurfacePanel.this.d_specInjPanel) > -1 && !this.isRampTableSet()) {
                if (bl2) {
                    SurfacePanel.this.d_tabs.setSelectedComponent(SurfacePanel.this.d_specInjPanel);
                }
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Included species cannot have empty ramp value tables."));
                }
                return false;
            }
            for (n = 0; n < this.d_table.getRowCount(); ++n) {
                if (this.d_table.getValueAt(n, 1) != null && this.d_table.getValueAt(n, 2) != null && this.d_table.getValueAt(n, 3) != null) continue;
                this.d_table.flagInvalidCell(n, -1, bl, bl2, Intl.intl("Empty cells are not allowed"));
                return false;
            }
            for (n = 0; n < this.d_table.getRowCount(); ++n) {
                Double d = (Double)this.d_table.getValueAt(n, 1);
                if (d == null || !(d < 0.0)) continue;
                if (bl2) {
                    SurfacePanel.this.d_surfPanel.d_tabs.setSelectedComponent(SurfacePanel.this.d_surfPanel.d_specInjPanel);
                    this.d_table.setRowSelectionInterval(n, n);
                    this.d_table.setColumnSelectionInterval(1, 1);
                }
                if (bl) {
                    guiDialog.showInvalidEntryMessage(SurfacePanel.this.d_surfPanel, Intl.intl("The value must be positive."));
                }
                return false;
            }
            return true;
        }

        public void loadData(SpecInjList specInjList) {
            this.d_table.selectAll();
            this.d_table.removeSelectedRows();
            this.d_massFracRB.setSelected(true);
            List<ExSpec> list = Util.sort(SurfacePanel.this.d_exSpecList);
            this.d_availExSpec = list.toArray(new ExSpec[list.size()]);
            this.d_esMap = new IdentityHashMap<ExSpec, Integer>();
            int n = 0;
            for (ExSpec exSpec : this.d_availExSpec) {
                this.d_table.setValueAt(exSpec, n, 0);
                this.d_table.setValueAt(0.0, n, 1);
                this.d_table.setValueAt(this.DEFAULT, n, 2);
                this.d_table.setValueAt(TimeFunction.newDefault().val, n, 3);
                this.d_esMap.put(exSpec, n++);
            }
            Unit unit = SurfacePanel.this.d_currentUS.getMassFractionUnit();
            Unit unit2 = SurfacePanel.this.d_currentUS.getUnit(45);
            if (specInjList == null || specInjList.getInjections() == null) {
                return;
            }
            if (specInjList.injType == 1) {
                this.d_table.getColumnModel().getColumn(1).setHeaderValue(this.MASSFRAC + " (" + unit + ")");
                this.d_massFracRB.setSelected(true);
            } else {
                this.d_massFluxRB.setSelected(true);
                this.d_table.getColumnModel().getColumn(1).setHeaderValue(this.MASSFLUX + " (" + unit2 + ")");
            }
            for (SpeciesInjection speciesInjection : specInjList.getInjections()) {
                int n2 = this.d_esMap.get(speciesInjection.species);
                double d = speciesInjection.val instanceof UnitDouble ? ((UnitDouble)speciesInjection.val).getValue(unit2) : ((Double)speciesInjection.val).doubleValue();
                this.d_table.setValueAt(d, n2, 1);
                TimeFunction timeFunction = speciesInjection.func;
                String string = null;
                Object ValType = timeFunction.val;
                if (TimeFunction.newDefault().equals(timeFunction)) {
                    string = this.DEFAULT;
                    ValType = TimeFunction.newDefault().val;
                } else if (timeFunction instanceof TimeFunction.Custom) {
                    string = this.CUSTOM;
                } else if (timeFunction instanceof TimeFunction.TanH) {
                    string = this.TANH;
                } else if (timeFunction instanceof TimeFunction.TSquared) {
                    string = this.TSQUARED;
                }
                this.d_table.setValueAt(string, n2, 2);
                this.d_table.setValueAt(ValType, n2, 3);
            }
        }

        public SpecInjList saveData(PyroMod pyroMod) {
            ArrayList<SpeciesInjection> arrayList = new ArrayList<SpeciesInjection>(this.d_table.getRowCount());
            int n = 0;
            if (this.d_massFracRB.isSelected()) {
                n = 1;
            }
            Unit unit = SurfacePanel.this.d_currentUS.getUnit(45);
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                Object object;
                TimeFunction timeFunction;
                double d = (Double)this.d_table.getValueAt(i, 1);
                Object object2 = this.d_table.getValueAt(i, 3);
                if (object2 instanceof Ramp) {
                    timeFunction = new TimeFunction.Custom((Ramp)object2);
                } else {
                    if (!(object2 instanceof UnitDouble)) continue;
                    object = this.d_table.getValueAt(i, 2);
                    timeFunction = this.TSQUARED.equals(object) ? new TimeFunction.TSquared((UnitDouble)object2) : (this.TANH.equals(object) ? new TimeFunction.TanH((UnitDouble)object2) : TimeFunction.newDefault());
                }
                if (d == 0.0 && ((TimeFunction)timeFunction).equals(TimeFunction.newDefault())) continue;
                object = (ExSpec)this.d_table.getValueAt(i, 0);
                Comparable comparable = n == 0 ? new UnitDouble(d, unit) : Double.valueOf(d);
                arrayList.add(new SpeciesInjection((ExSpec)object, comparable, timeFunction));
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            return new SpecInjList(n, arrayList);
        }

        public boolean isRampTableSet() {
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                Object object = this.d_table.getValueAt(i, 3);
                if ((!(object instanceof Ramp) || !((Ramp)object).getRecords().isEmpty()) && (!this.CUSTOM.equals(this.d_table.getValueAt(i, 2)) || object != null)) continue;
                return false;
            }
            return true;
        }

        public boolean isMassFracOK() {
            if (this.d_massFracRB.isSelected()) {
                double d = 0.0;
                for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                    d += ((Double)this.d_table.getValueAt(i, 1)).doubleValue();
                }
                if (d < 1.0E-8) {
                    return true;
                }
                if (d > 1.00000001) {
                    return false;
                }
            }
            return true;
        }

        private String renderUD(JTable jTable, int n, int n2, UnitDouble unitDouble, Unit unit) {
            if (unitDouble != null) {
                return "" + unitDouble.getValue(unit);
            }
            return "";
        }

        private UnitDouble parseUD(String string, Unit unit) {
            try {
                double d = Global.parseDouble(string);
                return new UnitDouble(d, unit);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        private UnitDouble getUDVal(TimeFunction timeFunction) {
            UnitDouble unitDouble = null;
            if (timeFunction instanceof TimeFunction.TanH) {
                unitDouble = (UnitDouble)((TimeFunction.TanH)timeFunction).val;
            } else if (timeFunction instanceof TimeFunction.TSquared) {
                unitDouble = (UnitDouble)((TimeFunction.TSquared)timeFunction).val;
            }
            return unitDouble;
        }

        private TimeFunction getDefaultValue(String string) {
            if (string.equals(this.CUSTOM)) {
                return new TimeFunction.Custom(new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28));
            }
            if (string.equals(this.TSQUARED)) {
                return new TimeFunction.TSquared();
            }
            if (string.equals(this.TANH)) {
                return new TimeFunction.TanH();
            }
            return TimeFunction.newDefault();
        }

        private class RampTableCell
        extends DefaultCellEditor
        implements TableCellEditor,
        TableCellRenderer {
            private static final long serialVersionUID = -8038458482938900162L;
            private final TimeFunctionEditor.RampAction d_rampAction;
            private final JButton d_editButton;
            private final DefaultTableCellRenderer d_defRend;
            private final JButton d_renderButton;

            public RampTableCell(Modifiable modifiable) {
                super(new JTextField());
                this.d_editButton = new JButton(Intl.intl("Edit Values..."));
                this.d_defRend = new DefaultTableCellRenderer();
                this.d_renderButton = new JButton(Intl.intl("Edit Values..."));
                this.d_rampAction = new TimeFunctionEditor.RampAction(modifiable){

                    @Override
                    protected void rampEdited(boolean bl) {
                        super.rampEdited(bl);
                        if (bl) {
                            RampTableCell.this.stopCellEditing();
                        } else {
                            RampTableCell.this.cancelCellEditing();
                        }
                    }
                };
                this.d_editButton.addActionListener(this.d_rampAction);
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                Ramp ramp = (Ramp)object;
                if (ramp == null) {
                    ramp = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
                }
                this.d_rampAction.setRamp(ramp);
                this.d_editButton.setBackground(component.getBackground());
                return this.d_editButton;
            }

            @Override
            public Object getCellEditorValue() {
                return this.d_rampAction.getRamp();
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = this.d_defRend.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.d_renderButton.setBackground(component.getBackground());
                return this.d_renderButton;
            }
        }

        private class ExSpecRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = -9106653071693324395L;

            private ExSpecRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setText(((ExSpec)object).getName());
                return component;
            }
        }

        private class SpecInjTable
        extends guiDefaultTableModel {
            private static final long serialVersionUID = -6046344371348853951L;

            private SpecInjTable() {
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return Intl.intl("Species");
                    }
                    case 1: {
                        if (SpecInjPanel.this.d_massFluxRB.isSelected()) {
                            return SpecInjPanel.this.MASSFLUX + " (" + SurfacePanel.this.d_currentUS.getMLRPUA().toString() + ")";
                        }
                        return SpecInjPanel.this.MASSFRAC + " (" + SurfacePanel.this.d_currentUS.getMassFractionUnit() + ")";
                    }
                    case 2: {
                        return Intl.intl("Ramp-Up Type");
                    }
                    case 3: {
                        return Intl.intl("Ramp Value");
                    }
                }
                return null;
            }

            @Override
            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return ExSpec.class;
                    }
                    case 1: {
                        return Double.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return Object.class;
                    }
                }
                assert (false);
                return null;
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                String string;
                if (n2 == 0) {
                    return false;
                }
                return n2 != 3 || (string = (String)SpecInjPanel.this.d_table.getValueAt(n, 2)) != null && !string.equals(SpecInjPanel.this.DEFAULT) && !string.equals("");
            }
        }

        private class RampUpValueClipboard
        extends DefaultTableClipboard {
            private RampUpValueClipboard() {
            }

            @Override
            public boolean pasteObject(guiTable guiTable2, Object object, int n, int n2) {
                if (object == null) {
                    return false;
                }
                if (object instanceof UnitDouble) {
                    return super.pasteObject(guiTable2, object, n, n2);
                }
                if (!(object instanceof Ramp)) {
                    String string = object.toString();
                    try {
                        UnitDouble unitDouble = Global.parseUnitDouble(string, UnitSystem.getSource(2).getUnit());
                        return super.pasteObject(guiTable2, unitDouble, n, n2);
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }
                Ramp ramp = (Ramp)object;
                PyroMod pyroMod = PyroSim.getApp().getMediator();
                DepSnapshot depSnapshot = new DepSnapshot(Collections.singleton(ramp));
                depSnapshot.takeSnapshot(ramp);
                ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
                for (IPyroObject object22 : depSnapshot.getAllDependedOn()) {
                    if (object22.getDomain() == pyroMod) continue;
                    arrayList.add(object22);
                }
                Actions.UIPasteCallback uIPasteCallback = new Actions.UIPasteCallback(pyroMod){

                    @Override
                    public Actions.PasteOverwrite getReplaceModelObject(IPyroObject iPyroObject, IPyroObject iPyroObject2) throws CancellationException {
                        return Actions.PasteOverwrite.KEEP_EXISTING;
                    }
                };
                Actions.PasteInfo pasteInfo = Actions.taskInsertObjects(pyroMod, arrayList, uIPasteCallback, 2);
                for (Actions.PasteCommand pasteCommand : pasteInfo.commands.values()) {
                    if (pasteCommand.command == 1 && pasteCommand.param instanceof IPyroObject) continue;
                    return false;
                }
                pasteInfo.task.run();
                for (IPyroObject iPyroObject : arrayList) {
                    Actions.PasteCommand pasteCommand = pasteInfo.commands.get(iPyroObject);
                    IPyroObject iPyroObject2 = (IPyroObject)pasteCommand.param;
                    for (Dependency dependency : depSnapshot.getDependents(iPyroObject)) {
                        if (dependency.source != ramp) continue;
                        ramp.taskReplaceDep(iPyroObject, iPyroObject2).run();
                    }
                }
                return super.pasteObject(guiTable2, ramp, n, n2);
            }
        }
    }

    private class HRPanel
    extends guiPanel {
        private static final long serialVersionUID = -6586194214395766727L;
        private JRadioButton d_hrrpuaRB;
        private JRadioButton d_mlrpuaRB;
        private ValueField<UnitDouble> d_hrrpua;
        private ValueField<UnitDouble> d_mlrpua;
        private ValueField<UnitDouble> d_extCoeff;
        private final TimeFunctionEditor d_RampTimeEditor;

        public HRPanel(String string) {
            this.setLayout(new GridBagLayout());
            int n = 0;
            TitleSeparator titleSeparator = new TitleSeparator(string);
            GridBagUtil.add(this, titleSeparator, 0, n++, 0, 1, 12, 12, 6, 0, 2, 1.0, 0.0, 17);
            this.d_hrrpuaRB = new JRadioButton(Intl.intl("Heat Release Rate Per Area (HRRPUA)") + ":");
            this.d_hrrpuaRB.setToolTipText("HRRPUA");
            this.d_hrrpua = ValueFields.udFld(UnitSystem.getSource(22));
            GridBagUtil.add(this, this.d_hrrpuaRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_hrrpua, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_mlrpuaRB = new JRadioButton(Intl.intl("Mass Loss Rate") + ":");
            this.d_mlrpuaRB.setToolTipText("MLRPUA");
            this.d_mlrpua = ValueFields.udFld(UnitSystem.getSource(44));
            GridBagUtil.add(this, this.d_mlrpuaRB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_mlrpua, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_RampTimeEditor = SurfacePanel.this.newTimeFuncEditor();
            this.d_RampTimeEditor.addToPanel(this, 0, n, 0, 30, 6, 12);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Extinguishing Coefficient") + ":");
            guiLabel2.setToolTipText("E_COEFFICIENT");
            this.d_extCoeff = ValueFields.udFld(UnitSystem.getSource(21));
            GridBagUtil.add(this, guiLabel2, 0, ++n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_extCoeff, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            this.d_hrrpuaRB.setSelected(true);
            this.d_mlrpua.setEnabled(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_hrrpuaRB);
            buttonGroup.add(this.d_mlrpuaRB);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    HRPanel.this.setModified(true);
                    HRPanel.this.getComm().touch(itemEvent);
                }
            };
            this.d_hrrpuaRB.addItemListener(itemListener);
            this.d_mlrpuaRB.addItemListener(itemListener);
            LinkStatus.link((AbstractButton)this.d_mlrpuaRB, this.d_mlrpua);
            LinkStatus.link((AbstractButton)this.d_hrrpuaRB, this.d_hrrpua);
        }

        public void loadData(HeatRelease heatRelease) {
            this.d_hrrpuaRB.setSelected(true);
            this.d_hrrpua.setValue(new HeatRelease.HRRType().val);
            this.d_mlrpua.setValue(new HeatRelease.MLRType().val);
            this.d_extCoeff.setValue(new HeatRelease().d_extingCoeff);
            if (heatRelease == null) {
                return;
            }
            if (heatRelease.d_type instanceof HeatRelease.HRRType) {
                this.d_hrrpuaRB.setSelected(true);
                this.d_hrrpua.setValue(heatRelease.d_type.val);
            } else {
                this.d_mlrpuaRB.setSelected(true);
                this.d_mlrpua.setValue(heatRelease.d_type.val);
            }
            this.d_RampTimeEditor.loadFunction(heatRelease.d_type.func);
            this.d_extCoeff.setValue(heatRelease.d_extingCoeff);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_RampTimeEditor.validateData(bl, bl2);
        }

        public HeatRelease saveData() {
            TimeFunction<?> timeFunction = this.d_RampTimeEditor.saveFunction();
            if (this.d_hrrpuaRB.isSelected()) {
                return new HeatRelease(new HeatRelease.HRRType((UnitDouble)this.d_hrrpua.getValue(), timeFunction), (UnitDouble)this.d_extCoeff.getValue());
            }
            return new HeatRelease(new HeatRelease.MLRType((UnitDouble)this.d_mlrpua.getValue(), timeFunction), (UnitDouble)this.d_extCoeff.getValue());
        }
    }

    private class BurnerPanel
    extends guiPanel {
        private static final long serialVersionUID = 1193142382148046525L;
        private final HRPanel d_hrPanel;

        public BurnerPanel() {
            this.setLayout(new GridBagLayout());
            this.d_hrPanel = new HRPanel(Intl.intl("Heat Release"));
            GridBagUtil.add(this, this.d_hrPanel, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public HeatRelease getHeatRelease() {
            return this.d_hrPanel.saveData();
        }

        public void loadData(HeatRelease heatRelease) {
            this.d_hrPanel.loadData(heatRelease);
        }
    }

    private static class SlipData {
        private final String FREE_SLIP = Intl.intl("Free Slip");
        private final String NO_SLIP = Intl.intl("No Slip");
        private final String ROUGH_SLIP = Intl.intl("Default Slip");
        private final guiComboBox<String> d_slipCB = new guiComboBox<Object>((T[])new Object[]{this.ROUGH_SLIP, this.FREE_SLIP, this.NO_SLIP});
        private final guiLabel d_roughnessLbl = new guiLabel(Intl.intl("Roughness:"));
        private final ValueField<UnitDouble> d_roughnessFld = ValueFields.udFld(UnitSystem.getSource(0));

        public SlipData() {
            this.d_slipCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        this.updateRoughVis();
                    }
                }
            });
            this.updateRoughVis();
        }

        private void updateRoughVis() {
            boolean bl = this.d_slipCB.getSelectedItem() == this.ROUGH_SLIP;
            this.d_roughnessLbl.setVisible(bl);
            this.d_roughnessFld.setVisible(bl);
        }

        public void add(GridBagHelper gridBagHelper) {
            gridBagHelper.addRow(Intl.intl("Tangential Boundary Condition:"), this.d_slipCB, this.d_roughnessLbl, this.d_roughnessFld, 1.0);
        }

        public void loadData(ISlip iSlip) {
            this.d_roughnessFld.setValue(new UnitDouble(0.0, SI.METER));
            if (iSlip instanceof ISlip.FreeSlip) {
                this.d_slipCB.setSelectedItem(this.FREE_SLIP);
            } else if (iSlip instanceof ISlip.NoSlip) {
                this.d_slipCB.setSelectedItem(this.NO_SLIP);
            } else if (iSlip instanceof ISlip.RoughSlip) {
                this.d_slipCB.setSelectedItem(this.ROUGH_SLIP);
                ISlip.RoughSlip roughSlip = (ISlip.RoughSlip)iSlip;
                this.d_roughnessFld.setValue(roughSlip.roughness);
            }
        }

        public ISlip saveData() {
            String string = this.d_slipCB.getSelectedItem();
            if (string == this.FREE_SLIP) {
                return ISlip.FREE_SLIP;
            }
            if (string == this.NO_SLIP) {
                return ISlip.NO_SLIP;
            }
            if (string == this.ROUGH_SLIP) {
                return new ISlip.RoughSlip((UnitDouble)this.d_roughnessFld.getValue());
            }
            assert (false);
            return null;
        }
    }
}

