/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.boundcond.NewSurfaceDlg;
import pyrosim.gui.boundcond.SurfacePanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class SurfaceManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -4241798481548645763L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private SurfaceManager d_surfMgr;
    private JFrame d_owner;

    public SurfaceManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Edit Surfaces"), true);
        this.d_owner = jFrame;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(Surface.class), new RenameAction(this, Intl.intl("surface")), new ManagerDlg.DeleteAction()};
        this.d_editor = new SurfacePanel(this);
    }

    private void updateActions() {
        boolean bl;
        int n = this.getList().getSelectedIx();
        if (n > -1) {
            Surface surface = (Surface)this.getList().getItem(n);
            bl = surface.isPredefined();
        } else {
            bl = false;
        }
        this.d_actions[0].setEnabled(this.d_surfMgr != null);
        this.d_actions[1].setEnabled(this.d_surfMgr != null);
        this.d_actions[2].setEnabled(this.d_surfMgr != null && n > -1 && !bl);
        this.d_actions[3].setEnabled(this.d_surfMgr != null && n > -1 && !bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(SurfaceManager surfaceManager, Surface surface) {
        this.d_surfMgr = surfaceManager;
        ((RenameAction)this.d_actions[2]).init(surfaceManager);
        super.init(this.d_surfMgr, this.d_editor, this.d_actions, surface);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -4464281587526765803L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SurfaceManagerDlg.this.preSave()) {
                return;
            }
            int n = SurfaceManagerDlg.this.getList().getSelectedIx();
            Surface surface = n >= 0 ? (Surface)SurfaceManagerDlg.this.getList().getItem(n) : null;
            NewSurfaceDlg newSurfaceDlg = new NewSurfaceDlg((Window)SurfaceManagerDlg.this, SurfaceManagerDlg.this.d_surfMgr, surface);
            PyroMod pyroMod = (PyroMod)SurfaceManagerDlg.this.d_surfMgr.getDomain();
            if (newSurfaceDlg.doModal() == 1) {
                Surface surface2 = newSurfaceDlg.getBaseMat();
                if (surface2 == null) {
                    surface2 = SurfaceManagerDlg.this.d_surfMgr.get(PredefSurf.INERT);
                }
                Surface surface3 = new Surface(newSurfaceDlg.getName(), surface2.getColor(), surface2.getAppearance(), surface2.getSurfDesc());
                surface3.setCustomFDSProps(surface2.getCustomFDSProps());
                AddTask addTask = new AddTask((IPyroObject)SurfaceManagerDlg.this.d_surfMgr, new IPyroObject[]{surface3});
                SelectTask selectTask = new SelectTask(pyroMod, surface3);
                selectTask.addTask(addTask);
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Surface"));
                SurfaceManagerDlg.this.getList().updateModelView(SurfaceManagerDlg.this.d_surfMgr);
                SurfaceManagerDlg.this.getList().select(surface3);
                SurfaceManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                SurfaceManagerDlg.this.updateActions();
            }
        }
    }
}

