/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JTabbedPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sourceforge.jeuclid.swing.JMathComponent;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.gui.boundcond.MaterialPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;

public class SolidPyrolysisReacDlg
extends guiDialog {
    private static final long serialVersionUID = 3098408654232113512L;
    private final RatePanel d_ratePanel;
    private final MaterialPanel.ByproductsPanel d_byproductsPanel;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();

    public SolidPyrolysisReacDlg(String string, MaterialPanel.ByproductsPanel byproductsPanel) {
        super((Window)Application.getApp().getActiveFrame(), string, 9);
        this.d_byproductsPanel = byproductsPanel;
        guiPanel guiPanel2 = this.getDialogPane();
        JTabbedPane jTabbedPane = new JTabbedPane();
        guiPanel2.add(jTabbedPane);
        this.d_ratePanel = new RatePanel();
        jTabbedPane.addTab(Intl.intl("Rate"), this.d_ratePanel);
        jTabbedPane.addTab(Intl.intl("Byproducts"), this.d_byproductsPanel);
    }

    public void loadByproducts(ReacByproducts reacByproducts, Material material) {
        this.d_byproductsPanel.loadData(reacByproducts, material);
    }

    public ReacByproducts saveByproducts() {
        return this.d_byproductsPanel.saveData();
    }

    public void loadRate(SolidReaction.Rate rate) {
        this.d_ratePanel.loadData(rate);
    }

    public SolidReaction.Rate saveRate() {
        return this.d_ratePanel.saveData();
    }

    private class RatePanel
    extends guiPanel {
        private static final long serialVersionUID = -7797851926745888581L;
        private final guiRadioButton d_aNeRB;
        private final guiRadioButton d_rateNtempRB;
        private final ValueField<UnitDouble> d_a;
        private final ValueField<UnitDouble> d_e;
        private final ValueField<UnitDouble> d_temp;
        private final ValueField<UnitDouble> d_heatingRate;
        private final ValueField<UnitDouble> d_pyrolysisRange;
        private final ValueField<UnitDouble> d_thresholdValue;
        private final ValueField<Double> d_massFracExp;
        private final ValueField<Double> d_thresholdTempExp;

        public RatePanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_aNeRB = new guiRadioButton(Intl.intl("Specify A and E"));
            this.d_aNeRB.setSelected(true);
            this.d_rateNtempRB = new guiRadioButton(Intl.intl("Match rate curve") + ":");
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Reference Temperature") + ":");
            this.d_temp = ValueFields.udFld(UnitSystem.getSource(1));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Heating Rate") + ":");
            this.d_heatingRate = ValueFields.udFld(UnitSystem.getSource(74));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Pyrolysis Range") + ":");
            this.d_pyrolysisRange = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_a = ValueFields.udFld(UnitSystem.getSource(50));
            guiLabel guiLabel5 = new guiLabel(Intl.intl("A (Pre-exponential Factor)") + ":");
            this.d_e = ValueFields.udFld(UnitSystem.getSource(54));
            guiLabel guiLabel6 = new guiLabel(Intl.intl("E (Activation Energy)") + ":");
            guiLabel guiLabel7 = new guiLabel(Intl.intl("<html>Mass Fraction Exponent (n<sub>s</sub>):</html>"));
            this.d_massFracExp = ValueFields.doubleFld();
            guiLabel guiLabel8 = new guiLabel(Intl.intl("<html>Exponent (n<sub>t</sub>):</html>"));
            this.d_thresholdTempExp = ValueFields.doubleFld();
            final guiLabel guiLabel9 = new guiLabel(Intl.intl("<html>Value (T<sub>thr</sub>):</html>"));
            this.d_thresholdValue = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_thresholdValue.setNullAllowed(true);
            JMathComponent jMathComponent = new JMathComponent(){
                private static final long serialVersionUID = -1752303893278533470L;

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(dimension.width, dimension.height + 10);
                }
            };
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Threshold Temperature"));
            GridBagUtil.add(this, (Component)jMathComponent, 0, n++, 5, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_rateNtempRB, 0, n++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_temp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatingRate, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_pyrolysisRange, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_aNeRB, 0, n++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel5, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_a, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel6, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_e, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel7, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_massFracExp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, titleSeparator, 0, n++, 2, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel8, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thresholdTempExp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel9, 0, n, 1, 1, 0, 30, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thresholdValue, 1, n++, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
            this.d_thresholdTempExp.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    try {
                        if (RatePanel.this.d_thresholdTempExp.validateData(false, false)) {
                            double d = (Double)RatePanel.this.d_thresholdTempExp.getValue();
                            boolean bl = d != 0.0;
                            guiLabel9.setEnabled(bl);
                            RatePanel.this.d_thresholdValue.setEnabled(bl);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_aNeRB);
            buttonGroup.add(this.d_rateNtempRB);
            LinkStatus.link((AbstractButton)this.d_aNeRB, guiLabel5, this.d_a, guiLabel6, this.d_e);
            LinkStatus.link((AbstractButton)this.d_rateNtempRB, guiLabel2, this.d_temp, guiLabel3, this.d_heatingRate, guiLabel4, this.d_pyrolysisRange);
            SolidReaction.Rate rate = new SolidReaction.Rate();
            this.d_massFracExp.setValue(rate.d_massFracExponent);
            this.d_thresholdTempExp.setValue(rate.d_tempExponent);
            this.d_thresholdValue.setValue(rate.d_thresholdTemp);
            this.d_a.setValue(new SolidReaction.Rate.AESpec().d_a);
            this.d_e.setValue(new SolidReaction.Rate.AESpec().d_e);
            this.d_temp.setValue(new SolidReaction.Rate.RefSpec().d_refTemp);
            this.d_heatingRate.setValue(new SolidReaction.Rate.RefSpec().d_heatingRate);
            this.d_pyrolysisRange.setValue(new SolidReaction.Rate.RefSpec().d_pyrolysisRange);
            if (rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                this.d_aNeRB.setSelected(true);
            } else {
                this.d_rateNtempRB.setSelected(true);
            }
            String string = "<mstyle mathcolor=\"blue\"><mo>A</mo></mstyle>";
            String string2 = "<mrow><mo>-</mo><mstyle mathcolor=\"blue\"><mo>E</mo></mstyle><mo> </mo></mrow>";
            String string3 = "<mstyle mathcolor=\"blue\"><msub><mo>n</mo><mo>s</mo></msub></mstyle>";
            String string4 = "<mfenced><mfrac><msub><mi>&#961;</mi><mrow><mo>s,i</mo></mrow></msub><msub><mi>&#961;</mi><mrow><mo>s0</mo></mrow></msub></mfrac></mfenced>";
            String string5 = "<msup>" + string4 + string3 + "</msup>";
            String string6 = "<mrow><mo>exp</mo><mfenced><mrow><mfrac>" + string2 + "<msub><mo>RT</mo><mo>s</mo></msub></mfrac></mrow></mfenced></mrow>";
            String string7 = "<mstyle mathcolor=\"blue\"><msub><mo>T</mo><mo>thr</mo></msub></mstyle>";
            String string8 = "<mstyle mathcolor=\"blue\"><msub><mo>n</mo><mo>t</mo></msub></mstyle>";
            String string9 = "<mrow><mo>max</mo><msup><mfenced open=\"[\" close=\"]\"><mo>0</mo><mrow><msub><mo>T</mo><mo>s</mo></msub><mo>-</mo>" + string7 + "</mrow></mfenced>" + string8 + "</msup></mrow>";
            jMathComponent.setContent("<mstyle mathsize=\"8mm\"><mrow>" + string5 + string + string6 + string9 + "</mrow></mstyle>");
        }

        public void loadData(SolidReaction.Rate rate) {
            this.d_massFracExp.setValue(rate.d_massFracExponent);
            this.d_thresholdTempExp.setValue(rate.d_tempExponent);
            if (rate.d_tempExponent != 0.0) {
                this.d_thresholdValue.setValue(rate.d_thresholdTemp);
            }
            if (rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                this.d_aNeRB.setSelected(true);
                this.d_a.setValue(((SolidReaction.Rate.AESpec)rate.d_spec).d_a);
                this.d_e.setValue(((SolidReaction.Rate.AESpec)rate.d_spec).d_e);
            } else {
                SolidReaction.Rate.RefSpec refSpec = (SolidReaction.Rate.RefSpec)rate.d_spec;
                this.d_rateNtempRB.setSelected(true);
                this.d_heatingRate.setValue(refSpec.d_heatingRate);
                this.d_pyrolysisRange.setValue(refSpec.d_pyrolysisRange);
                this.d_temp.setValue(refSpec.d_refTemp);
            }
        }

        public SolidReaction.Rate saveData() {
            SolidReaction.Rate.ISpecification iSpecification = this.d_aNeRB.isSelected() ? new SolidReaction.Rate.AESpec((UnitDouble)this.d_a.getValue(), (UnitDouble)this.d_e.getValue()) : new SolidReaction.Rate.RefSpec((UnitDouble)this.d_temp.getValue(), (UnitDouble)this.d_pyrolysisRange.getValue(), (UnitDouble)this.d_heatingRate.getValue());
            UnitDouble unitDouble = null;
            if (this.d_thresholdValue.isEnabled()) {
                unitDouble = (UnitDouble)this.d_thresholdValue.getValue();
            }
            return new SolidReaction.Rate((Double)this.d_massFracExp.getValue(), (Double)this.d_thresholdTempExp.getValue(), unitDouble, iSpecification);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_thresholdValue.isEnabled() && this.d_thresholdValue.getValue() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Threshold temperature value must be specified."));
                }
                return false;
            }
            return true;
        }
    }
}

