/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.gui.boundcond.SurfacePanel;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class NewSurfaceDlg
extends guiDialog {
    private static final long serialVersionUID = -785877814498679308L;
    private SurfaceManager d_surfMgr = null;
    private guiTextField d_name = null;
    private guiComboBox<Surface> d_baseMat = null;
    private guiComboBox<Surface> d_surfType = null;

    public NewSurfaceDlg(Window window, SurfaceManager surfaceManager, Surface surface) {
        super(window, Intl.intl("New Surface"), 9);
        Serializable serializable2;
        this.d_surfMgr = surfaceManager;
        this.d_baseMat = this.getSurfCombo(this.d_surfMgr, surface);
        boolean bl = false;
        for (Serializable serializable2 : this.d_surfMgr.flatten()) {
            if (((Surface)serializable2).isPredefined()) {
                this.d_baseMat.removeItem(serializable2);
                continue;
            }
            bl = true;
        }
        Surface surface2 = surfaceManager.get(PredefSurf.INERT);
        this.d_surfType = new guiComboBox();
        this.d_baseMat.setEnabled(bl);
        this.d_surfType.setRenderer(new typeCBRenderer());
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.BASIC, surface2.getColor(), null, Surface.newBasicDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.BURNER, new Color(1.0f, 0.0f, 0.0f), null, new BurnerSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.GENERAL, new Color(1.0f, 0.4f, 0.0f), null, new GeneralSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.CONSTANT_TEMP, new Color(1.0f, 0.4f, 0.0f), null, new ConstantTempSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.SUPPLY, new Color(0.1f, 0.8f, 0.1f), null, new BlowerSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.EXHAUST, new Color(0.1f, 0.5f, 0.1f), null, new InFlowSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.LAYERED, new Color(146, 202, 166), null, new LayeredSurfDesc()));
        this.d_surfType.addItem((Surface)new Surface(SurfacePanel.LEAK, new Color(127, 221, 255), null, new LeakSurfDesc(new ZonePath(null, null))));
        this.d_name = new guiTextField(this.generateUniqueName());
        serializable2 = this.getDialogPane();
        ((Container)serializable2).setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add((Container)serializable2, new guiLabel(Intl.intl("Surface Name") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add((Container)serializable2, this.d_name, 1, n++, 1, 1, 0, 0, 6, 0);
        if (bl) {
            guiRadioButton guiRadioButton2 = new guiRadioButton(Intl.intl("Surface Type") + ":");
            GridBagUtil.add((Container)serializable2, guiRadioButton2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add((Container)serializable2, this.d_surfType, 1, n++, 1, 1, 0, 0, 6, 0);
            guiRadioButton guiRadioButton3 = new guiRadioButton(Intl.intl("Template Surface") + ":");
            GridBagUtil.add((Container)serializable2, guiRadioButton3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add((Container)serializable2, this.d_baseMat, 1, n++, 1, 1, 0, 0, 6, 0);
            LinkStatus.link((AbstractButton)guiRadioButton3, this.d_baseMat);
            LinkStatus.link((AbstractButton)guiRadioButton2, this.d_surfType);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(guiRadioButton2);
            buttonGroup.add(guiRadioButton3);
            guiRadioButton2.setSelected(true);
        } else {
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Surface Type") + ":");
            GridBagUtil.add((Container)serializable2, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add((Container)serializable2, this.d_surfType, 1, n++, 1, 1, 0, 0, 6, 0);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        String string = this.d_name.getText();
        if (this.nameInUse(string)) {
            String string2 = Intl.intl("Surface name already in use.") + "\n" + Intl.intl("Each surface must have a unique name.");
            this.showMessageBox(string2);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String string3 = Intl.intl("You must name the surface.");
            this.showMessageBox(string3);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private guiComboBox<Surface> getSurfCombo(SurfaceManager surfaceManager, Surface surface) {
        SurfaceComboBox surfaceComboBox = new SurfaceComboBox(surfaceManager, surface);
        return surfaceComboBox;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public Surface getBaseMat() {
        if (this.d_baseMat.isEnabled()) {
            return this.d_baseMat.getSelectedItem();
        }
        if (this.d_surfType.isEnabled()) {
            return this.d_surfType.getSelectedItem();
        }
        return null;
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_surfMgr.getDomain()).getNames(Surface.class).generateName();
    }

    private boolean nameInUse(String string) {
        return ((PyroMod)this.d_surfMgr.getDomain()).getNames(Surface.class).isRegistered(string);
    }

    protected class typeCBRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6096926854130472386L;
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        protected typeCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Surface surface = (Surface)object;
            if (surface == null) {
                return this;
            }
            String string = ((Surface)object).getName();
            this.setText(string);
            this.setFont(this.d_normalFont);
            return this;
        }
    }
}

