/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.gui.boundcond.MaterialPanel;
import pyrosim.gui.comboboxes.MaterialComboBox;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class NewMaterialDlg
extends guiDialog {
    private static final long serialVersionUID = 2991484737392308368L;
    private MaterialManager d_matMgr = null;
    private guiTextField d_name = null;
    private guiComboBox<Material> d_baseMat = null;
    private guiComboBox<Material> d_surfType = null;

    public NewMaterialDlg(Window window, MaterialManager materialManager, Material material) {
        super(window, Intl.intl("New Material"), 9);
        this.d_matMgr = materialManager;
        this.d_baseMat = new MaterialComboBox(materialManager);
        if (material != null) {
            this.d_baseMat.setSelectedItem(material);
        }
        this.d_surfType = new guiComboBox();
        this.d_baseMat.setEnabled(!this.d_matMgr.flatten().isEmpty());
        this.d_surfType.setRenderer(new typeCBRenderer());
        this.d_surfType.addItem((Material)new Material(MaterialPanel.SOLID, new SolidPyrolysis(), new ThermalProps()));
        this.d_surfType.addItem((Material)new Material(MaterialPanel.LIQUID, new LiquidPyrolysis(), new ThermalProps()));
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Material Name") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_name, 1, n++, 1, 1, 0, 0, 6, 0);
        if (!this.d_matMgr.flatten().isEmpty()) {
            guiRadioButton guiRadioButton2 = new guiRadioButton(Intl.intl("Material Type") + ":");
            GridBagUtil.add(guiPanel2, guiRadioButton2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_surfType, 1, n++, 1, 1, 0, 0, 6, 0);
            guiRadioButton guiRadioButton3 = new guiRadioButton(Intl.intl("Template Material") + ":");
            GridBagUtil.add(guiPanel2, guiRadioButton3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_baseMat, 1, n++, 1, 1, 0, 0, 6, 0);
            LinkStatus.link((AbstractButton)guiRadioButton2, this.d_surfType);
            LinkStatus.link((AbstractButton)guiRadioButton3, this.d_baseMat);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(guiRadioButton2);
            buttonGroup.add(guiRadioButton3);
            guiRadioButton2.setSelected(true);
        } else {
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Material Type") + ":");
            GridBagUtil.add(guiPanel2, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_surfType, 1, n++, 1, 1, 0, 0, 6, 0);
            this.d_baseMat.setEnabled(false);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        String string = this.d_name.getText();
        if (this.nameInUse(string)) {
            String string2 = Intl.intl("Material name already in use.") + "\n" + Intl.intl("Each material must have a unique name.");
            this.showMessageBox(string2);
            this.requestFocusHack();
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            String string3 = Intl.intl("You must name the material.");
            this.showMessageBox(string3);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public Material getBaseMat() {
        if (this.d_baseMat.isEnabled()) {
            return this.d_baseMat.getSelectedItem();
        }
        if (this.d_surfType.isEnabled()) {
            return this.d_surfType.getSelectedItem();
        }
        return null;
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_matMgr.getDomain()).getNames(Material.class).generateName();
    }

    private boolean nameInUse(String string) {
        return ((PyroMod)this.d_matMgr.getDomain()).getNames(Material.class).isRegistered(string);
    }

    protected class typeCBRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8976321235312427298L;
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        protected typeCBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Material material = (Material)object;
            if (material == null) {
                return this;
            }
            String string = ((Material)object).getName();
            this.setText(string);
            this.setFont(this.d_normalFont);
            return this;
        }
    }
}

