/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.RampFuncDlg;
import pyrosim.gui.boundcond.SolidPyrolysisReacDlg;
import pyrosim.unitsystem.PyroUnitSrc;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.theUtil;

public class MaterialPanel
extends guiPanel
implements IEditor<Material> {
    private static final long serialVersionUID = 4894548341602977042L;
    private final guiTextField d_matID;
    private final guiTextField d_fyi;
    private final guiComboBox<String> d_profileListBox;
    private final JTabbedPane d_tabs;
    private final guiDialog d_parent;
    private final MaterialPanel d_matPanel;
    private final ThermPropsPanel d_thermPropsPanel;
    private final LiquidPyrolysisPanel d_liquidPyrolysisPanel;
    private final SolidPyrolysisPanel d_solidPyrolysisPanel;
    private final CustomFDSPanel d_advancedPnl;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final MaterialManager d_matMgr;
    private ExSpecList d_exSpecList;
    private Material d_currentMaterial;
    public static final String LIQUID = Intl.intl("Liquid Fuel");
    public static final String SOLID = Intl.intl("Solid");
    public static final String THERMAL_PROPERTIES = Intl.intl("Thermal Properties");
    public static final String PYROLYSIS = Intl.intl("Pyrolysis");

    public MaterialPanel(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_matMgr = pyroMod.getMaterialMgr();
        this.d_exSpecList = pyroMod.getExSpecList();
        this.d_matPanel = this;
        this.setLayout(new GridBagLayout());
        this.d_parent = guiDialog2;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Material ID:"));
        this.d_matID = new guiTextField();
        this.d_matID.setEditable(false);
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Description:"));
        this.d_fyi = new guiTextField();
        this.d_fyi.setToolTipText("FYI");
        this.d_thermPropsPanel = new ThermPropsPanel();
        this.d_liquidPyrolysisPanel = new LiquidPyrolysisPanel();
        this.d_solidPyrolysisPanel = new SolidPyrolysisPanel();
        this.d_advancedPnl = new CustomFDSPanel(7);
        int n = 0;
        GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_matID, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_fyi, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        this.d_profileListBox = new guiComboBox<Object>((T[])new Object[]{SOLID, LIQUID});
        this.d_profileListBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = itemEvent.getItem().toString();
                int n = MaterialPanel.this.d_tabs.getSelectedIndex();
                MaterialPanel.this.d_tabs.removeAll();
                MaterialPanel.this.setModified(true);
                if (string.equals(LIQUID)) {
                    MaterialPanel.this.d_tabs.addTab(THERMAL_PROPERTIES, MaterialPanel.this.d_thermPropsPanel);
                    MaterialPanel.this.d_tabs.addTab(PYROLYSIS, MaterialPanel.this.d_liquidPyrolysisPanel);
                } else if (string.equals(SOLID)) {
                    MaterialPanel.this.d_tabs.addTab(THERMAL_PROPERTIES, MaterialPanel.this.d_thermPropsPanel);
                    MaterialPanel.this.d_tabs.addTab(PYROLYSIS, MaterialPanel.this.d_solidPyrolysisPanel);
                } else {
                    MaterialPanel.this.d_tabs.addTab(Intl.intl("Properties"), MaterialPanel.this.getEmptyPanel());
                }
                MaterialPanel.this.d_tabs.addTab(Intl.intl("Advanced"), MaterialPanel.this.d_advancedPnl);
                if (MaterialPanel.this.d_tabs.getTabCount() > 1) {
                    MaterialPanel.this.d_tabs.setSelectedIndex(n);
                }
            }
        });
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Material Type") + ":");
        GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_profileListBox, 1, n++, 3, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(Intl.intl("Properties"), this.getEmptyPanel());
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_thermPropsPanel, this.d_liquidPyrolysisPanel, this.d_solidPyrolysisPanel, this.d_advancedPnl));
        GridBagUtil.add(this, this.d_tabs, 0, n++, 100, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public void init(Material material) {
        this.setEnabled(material != null);
        if (material != null) {
            this.loadSurface(material);
            this.d_matID.setText(material.getName());
            this.d_fyi.setText(material.getFYI());
        }
        this.setModified(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    @Override
    public Material preview(Material material) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveMaterial(material);
        return material;
    }

    @Override
    public Material commit(final Material material) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                MaterialPanel.this.saveMaterial(material);
                material.setFYI(MaterialPanel.this.d_fyi.getText());
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Material"));
        this.setModified(false);
        return material;
    }

    private void saveMaterial(Material material) {
        String string = this.d_profileListBox.getSelectedItem();
        if (string == SOLID) {
            material.setThermalProps(this.d_thermPropsPanel.saveData());
            material.setPyrolysis(this.d_solidPyrolysisPanel.saveData());
        } else if (string == LIQUID) {
            material.setThermalProps(this.d_thermPropsPanel.saveData());
            material.setPyrolysis(this.d_liquidPyrolysisPanel.saveData());
        }
        this.d_advancedPnl.save(Collections.singleton(material));
    }

    private void loadSurface(Material material) {
        int n = this.d_tabs.getSelectedIndex();
        this.d_tabs.removeAll();
        this.d_currentMaterial = material;
        this.clearPanels();
        if (material.isSolid()) {
            this.d_tabs.add(THERMAL_PROPERTIES, this.d_thermPropsPanel);
            this.d_thermPropsPanel.loadData(material.getThermalProps());
            this.d_tabs.add(PYROLYSIS, this.d_solidPyrolysisPanel);
            this.d_solidPyrolysisPanel.loadData((SolidPyrolysis)material.getPyrolysis());
            this.d_profileListBox.setSelectedItem(SOLID);
        } else {
            this.d_tabs.add(THERMAL_PROPERTIES, this.d_thermPropsPanel);
            this.d_thermPropsPanel.loadData(material.getThermalProps());
            this.d_tabs.addTab(PYROLYSIS, this.d_liquidPyrolysisPanel);
            this.d_liquidPyrolysisPanel.loadData((LiquidPyrolysis)material.getPyrolysis());
            this.d_profileListBox.setSelectedItem(LIQUID);
        }
        this.d_tabs.add(Intl.intl("Advanced"), this.d_advancedPnl);
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(material), new CustomFDSPanel.AdvPropWrapper<Boolean>(material.isForceWrite(), 1));
        if (this.d_tabs.getTabCount() > 1) {
            this.d_tabs.setSelectedIndex(n);
        }
    }

    private void clearPanels() {
        this.d_thermPropsPanel.loadData(null);
        this.d_liquidPyrolysisPanel.loadData(null);
        this.d_solidPyrolysisPanel.loadData(null);
        this.d_advancedPnl.clear();
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private guiPanel getEmptyPanel() {
        guiPanel guiPanel2 = new guiPanel();
        return guiPanel2;
    }

    private class RampAction
    implements ActionListener {
        private IRampInput d_defInput;
        private int d_valUnit;
        private String d_valDesc;
        public Ramp d_holdRamp;

        public RampAction(IRampInput iRampInput, int n, String string) {
            this.d_defInput = iRampInput;
            this.d_valUnit = n;
            this.d_holdRamp = null;
            this.d_valDesc = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Ramp ramp = this.d_holdRamp != null ? this.d_holdRamp : new Ramp(Collections.EMPTY_LIST, this.d_defInput, this.d_valUnit);
            assert (ramp != null);
            RampFuncDlg rampFuncDlg = new RampFuncDlg(ramp.getDefaultInput(), this.d_valUnit, this.d_valDesc, null);
            rampFuncDlg.loadData(ramp);
            if (rampFuncDlg.doModal() == 1) {
                Ramp ramp2 = rampFuncDlg.getRamp();
                if (ramp == null && ramp2 != null || ramp != null && ramp2 == null || ramp != null && ramp2 != null && !ramp.equals(ramp2)) {
                    this.d_holdRamp = ramp2;
                    MaterialPanel.this.setModified(true);
                }
            }
        }
    }

    private class SolidPyrolysisPanel
    extends guiPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = 8606409129533740805L;
        private final ValueField<UnitDouble> d_heatOfComb;
        private final guiCheckBox d_heatOfCombCB;
        private final JList d_list;
        private final JScrollPane d_jsp;
        private guiLabel d_reacLab;
        private guiLabel d_dispByprodLab;
        private guiLabel[] d_dispByprodLabList;
        private ByproductsPanel d_byproductsPanel;
        private guiPanel d_reacDispl;
        private final JButton d_addButton;
        private final JButton d_deleteButton;
        private final JButton d_editButton;
        private final JMathComponent d_equation;

        public SolidPyrolysisPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_heatOfCombCB = new guiCheckBox(Intl.intl("Heat of Combustion") + ":");
            this.d_heatOfComb = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_heatOfComb.setNullAllowed(false);
            GridBagUtil.add(this, this.d_heatOfCombCB, 0, n, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatOfComb, 2, n++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            this.d_heatOfCombCB.addActionListener(actionEvent -> {
                if (this.d_heatOfComb.isEmpty()) {
                    this.d_heatOfComb.setValue(SIUS.newud(0.0, 48));
                }
                this.d_heatOfComb.requestFocusInWindow();
            });
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Reactions"));
            GridBagUtil.add(this, titleSeparator, 0, n++, 4, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 17);
            this.d_list = new JList();
            this.d_list.addListSelectionListener(this);
            this.d_list.setSelectionMode(0);
            this.d_list.setModel(new DefaultListModel());
            this.d_list.setCellRenderer(new ListRenderer());
            this.d_jsp = new JScrollPane(this.d_list);
            this.d_jsp.setVerticalScrollBarPolicy(22);
            this.d_jsp.setPreferredSize(new Dimension(80, 120));
            guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
            this.d_reacDispl = new guiPanel();
            GridBagUtil.add(this, guiPanel2, 0, n, 1, 1, 0, 12, 6, 0, 3, 0.0, 1.0, 17);
            GridBagUtil.add(this, this.d_reacDispl, 1, n, 3, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 18);
            guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
            GridBagUtil.add(guiPanel2, this.d_jsp, 0, 0, 1, 1, 0, 0, 12, 12, 1, 1.0, 1.0);
            GridBagUtil.add(guiPanel2, guiPanel3, 0, 1, 1, 1, 0, 0, 0, 12, 1, 1.0, 0.0);
            this.d_addButton = new JButton(Intl.intl("Add") + "...");
            this.d_deleteButton = new JButton(Intl.intl("Delete") + "...");
            this.d_editButton = new JButton(Intl.intl("Edit") + "...");
            GridBagUtil.add(guiPanel3, Box.createGlue(), 0, 100, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0);
            GridBagUtil.add(guiPanel3, this.d_addButton, 0, 0, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
            GridBagUtil.add(guiPanel3, this.d_deleteButton, 0, 1, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
            GridBagUtil.add(guiPanel3, this.d_editButton, 0, 2, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
            this.d_reacDispl.setLayout(new GridBagLayout());
            int n2 = 0;
            this.d_reacLab = new guiLabel("Reac Name");
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Rate") + ":");
            this.d_equation = new JMathComponent(){
                private static final long serialVersionUID = 6987145753942876915L;

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(dimension.width, dimension.height + 10);
                }
            };
            this.d_dispByprodLab = new guiLabel(Intl.intl("Byproducts") + ":");
            this.d_dispByprodLabList = new guiLabel[4];
            this.d_dispByprodLabList[0] = new guiLabel("");
            this.d_dispByprodLabList[1] = new guiLabel("");
            this.d_dispByprodLabList[2] = new guiLabel("");
            this.d_dispByprodLabList[3] = new guiLabel("");
            GridBagUtil.add(this.d_reacDispl, this.d_reacLab, 0, n2++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, guiLabel2, 0, n2++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, (Component)this.d_equation, 0, n2++, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLab, 0, n2, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[0], 1, n2++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[1], 1, n2++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[2], 1, n2++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[3], 1, n2++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_reacDispl);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_heatOfCombCB, this.d_heatOfComb);
            this.d_byproductsPanel = new ByproductsPanel(true);
            this.d_addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Intl.intl("Edit Pyrolysis Reaction ");
                    if (!SolidPyrolysisPanel.this.d_list.isSelectionEmpty()) {
                        string = string + Intl.intl("- Reaction ") + (SolidPyrolysisPanel.this.d_list.getModel().getSize() + 1);
                    }
                    SolidPyrolysisReacDlg solidPyrolysisReacDlg = new SolidPyrolysisReacDlg(string, SolidPyrolysisPanel.this.d_byproductsPanel);
                    solidPyrolysisReacDlg.loadByproducts(null, MaterialPanel.this.d_currentMaterial);
                    if (solidPyrolysisReacDlg.doModal() == 1) {
                        SolidReaction solidReaction = new SolidReaction(solidPyrolysisReacDlg.saveRate(), solidPyrolysisReacDlg.saveByproducts());
                        ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).addElement(solidReaction);
                        SolidPyrolysisPanel.this.d_list.setSelectedValue(solidReaction, false);
                        MaterialPanel.this.d_matPanel.setModified(true);
                        SolidPyrolysisPanel.this.updateAction();
                    }
                }
            });
            this.d_editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SolidPyrolysisPanel.this.d_list.getSelectedIndex();
                    String string = Intl.intl("Edit Pyrolysis Reaction ");
                    if (SolidPyrolysisPanel.this.d_list.getModel().getSize() > 1) {
                        string = string + Intl.intl("- Reaction ") + (n + 1);
                    }
                    SolidReaction solidReaction = (SolidReaction)SolidPyrolysisPanel.this.d_list.getSelectedValue();
                    SolidPyrolysisReacDlg solidPyrolysisReacDlg = new SolidPyrolysisReacDlg(string, SolidPyrolysisPanel.this.d_byproductsPanel);
                    solidPyrolysisReacDlg.loadByproducts(solidReaction.d_byproducts, MaterialPanel.this.d_currentMaterial);
                    solidPyrolysisReacDlg.loadRate(solidReaction.d_rate);
                    if (solidPyrolysisReacDlg.doModal() == 1) {
                        SolidReaction solidReaction2 = new SolidReaction(solidPyrolysisReacDlg.saveRate(), solidPyrolysisReacDlg.saveByproducts());
                        ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).removeElementAt(n);
                        ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).add(n, solidReaction2);
                        SolidPyrolysisPanel.this.d_list.setSelectedValue(solidReaction2, false);
                        MaterialPanel.this.d_matPanel.setModified(true);
                        SolidPyrolysisPanel.this.updateAction();
                    }
                }
            });
            this.d_deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SolidPyrolysisPanel.this.d_list.getSelectedIndex();
                    int n2 = SolidPyrolysisPanel.this.d_list.getModel().getSize();
                    String string = Intl.intl("Reaction ");
                    if (n2 > 1) {
                        string = Intl.intl("Reaction ") + (n + 1);
                    }
                    String string2 = Intl.intl("Delete reaction") + ": " + string;
                    int n3 = JOptionPane.showConfirmDialog(MaterialPanel.this.d_matPanel, string2, Intl.intl("Confirm Delete"), 2);
                    if (n3 != 0) {
                        return;
                    }
                    ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).removeElementAt(n);
                    if (n2 > 1) {
                        SolidPyrolysisPanel.this.d_list.setSelectedIndex(n - 1);
                    }
                    MaterialPanel.this.d_matPanel.setModified(true);
                    SolidPyrolysisPanel.this.updateAction();
                }
            });
            this.updateAction();
        }

        public void loadData(SolidPyrolysis solidPyrolysis) {
            SolidPyrolysis solidPyrolysis2 = new SolidPyrolysis();
            this.d_heatOfCombCB.setSelected(false);
            this.d_heatOfComb.setValue(solidPyrolysis2.d_heatOfCombustion);
            Unit unit = ((PyroUnitSrc)((UnitDoubleFormat)this.d_heatOfComb.getFormat()).getUnitType()).getUnit();
            if (solidPyrolysis2.d_heatOfCombustion != null && solidPyrolysis2.d_heatOfCombustion.getValue(unit) > 0.0) {
                this.d_heatOfCombCB.setSelected(true);
            }
            ((DefaultListModel)this.d_list.getModel()).removeAllElements();
            this.d_reacDispl.setVisible(false);
            if (solidPyrolysis == null) {
                return;
            }
            if (solidPyrolysis.d_heatOfCombustion != null && solidPyrolysis.d_heatOfCombustion.getValue(unit) > 0.0) {
                this.d_heatOfCombCB.setSelected(true);
            }
            this.d_heatOfComb.setValue(solidPyrolysis.d_heatOfCombustion);
            for (SolidReaction solidReaction : solidPyrolysis.getReactions()) {
                ((DefaultListModel)this.d_list.getModel()).addElement(solidReaction);
            }
            int n = this.d_list.getModel().getSize();
            if (n > 0) {
                this.d_list.setSelectedIndex(0);
            }
            this.updateAction();
        }

        public SolidPyrolysis saveData() {
            UnitDouble unitDouble = null;
            if (this.d_heatOfCombCB.isSelected()) {
                unitDouble = (UnitDouble)this.d_heatOfComb.getValue();
            }
            Enumeration enumeration = ((DefaultListModel)this.d_list.getModel()).elements();
            ArrayList<SolidReaction> arrayList = new ArrayList<SolidReaction>(this.d_list.getModel().getSize());
            while (enumeration.hasMoreElements()) {
                arrayList.add((SolidReaction)enumeration.nextElement());
            }
            return new SolidPyrolysis(unitDouble, arrayList);
        }

        public void updateAction() {
            this.d_addButton.setEnabled(this.d_list.getModel().getSize() < 10);
            this.d_deleteButton.setEnabled(this.d_list.getSelectedIndex() > -1);
            this.d_editButton.setEnabled(this.d_list.getSelectedIndex() > -1);
        }

        /*
         * WARNING - void declaration
         */
        public void updateReacDisplay() {
            int n = this.d_list.getSelectedIndex();
            this.d_reacDispl.setVisible(false);
            if (n > -1) {
                void var10_13;
                String string;
                Object object2;
                this.d_reacDispl.setVisible(true);
                int n2 = this.d_list.getModel().getSize();
                String string2 = Intl.intl("Reaction ");
                if (n2 > 1) {
                    string2 = Intl.intl("Reaction ") + (n + 1);
                }
                this.d_reacLab.setText(string2);
                SolidReaction solidReaction = (SolidReaction)((DefaultListModel)this.d_list.getModel()).getElementAt(n);
                this.d_dispByprodLab.setVisible(false);
                int n3 = 0;
                this.d_dispByprodLabList[0].setVisible(false);
                this.d_dispByprodLabList[1].setVisible(false);
                this.d_dispByprodLabList[2].setVisible(false);
                this.d_dispByprodLabList[3].setVisible(false);
                int n4 = this.d_dispByprodLabList.length;
                UnitDouble unitDouble = solidReaction.d_byproducts.d_heat;
                Unit unit = MaterialPanel.this.d_currentUS.getHeatOfCombustion();
                if (unitDouble != null) {
                    object2 = "" + unitDouble.getValue(unit);
                    object2 = (String)object2 + " " + unit.toString();
                    this.d_dispByprodLabList[n3].setVisible(true);
                    this.d_dispByprodLabList[n3++].setText((String)object2);
                    this.d_dispByprodLab.setVisible(true);
                }
                for (ReacByproducts.Residue object3 : solidReaction.d_byproducts.getResidues()) {
                    if (n3 >= n4) break;
                    string = "" + object3.d_fraction + " " + object3.d_type.getName();
                    this.d_dispByprodLabList[n3].setVisible(true);
                    this.d_dispByprodLabList[n3++].setText(string);
                    this.d_dispByprodLab.setVisible(true);
                }
                object2 = "A";
                String string3 = "E";
                string = "<mstyle mathcolor=\"blue\"><mo>";
                String string4 = "<mrow><mo>-</mo><mstyle mathcolor=\"blue\"><mo>";
                if (solidReaction.d_rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                    object2 = "" + ((SolidReaction.Rate.AESpec)solidReaction.d_rate.d_spec).d_a.getValue(MaterialPanel.this.d_currentUS.getUnit(50));
                    String string5 = "" + ((SolidReaction.Rate.AESpec)solidReaction.d_rate.d_spec).d_e.getValue(MaterialPanel.this.d_currentUS.getActivationEnergy());
                }
                string = string + (String)object2 + "</mo></mstyle>";
                string4 = string4 + (String)var10_13 + "</mo></mstyle><mo> </mo></mrow>";
                String string6 = "<mstyle mathcolor=\"blue\"><mo>" + solidReaction.d_rate.d_massFracExponent + "</mo></mstyle>";
                String string7 = "<mfenced><mfrac><msub><mi>&#961;</mi><mrow><mo>s,i</mo></mrow></msub><msub><mi>&#961;</mi><mrow><mo>s</mo><mi>0</mi></mrow></msub></mfrac></mfenced>";
                String string8 = "<msup>" + string7 + string6 + "</msup>";
                String string9 = "<mrow><mo>exp</mo><mfenced><mrow><mfrac>" + string4 + "<msub><mo>RT</mo><mo>s</mo></msub></mfrac></mrow></mfenced></mrow>";
                String string10 = "";
                if (solidReaction.d_rate.d_tempExponent != 0.0) {
                    String string11 = "<mstyle mathcolor=\"blue\"><mo>" + solidReaction.d_rate.d_thresholdTemp.getValue(MaterialPanel.this.d_currentUS.getTempUnit()) + "</mo></mstyle>";
                    String string12 = "<mstyle mathcolor=\"blue\"><mo>" + solidReaction.d_rate.d_tempExponent + "</mo></mstyle>";
                    string10 = "<mrow><mo>max</mo><msup><mfenced open=\"[\" close=\"]\"><mo>0</mo><mrow><msub><mo>T</mo><mo>s</mo></msub><mo>-</mo>" + string11 + "</mrow></mfenced>" + string12 + "</msup></mrow>";
                }
                this.d_equation.setContent("<mstyle mathsize=\"4mm\"><mrow>" + string8 + string + string9 + string10 + "</mrow></mstyle>");
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.updateReacDisplay();
            this.updateAction();
        }

        public class ListRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 6888896668195028998L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                String string = "";
                if (SolidPyrolysisPanel.this.d_list.getModel().getSize() > 1) {
                    string = "" + (n + 1);
                }
                ((JLabel)component).setText(Intl.intl("Reaction ") + string);
                return component;
            }
        }
    }

    public class ByproductsPanel
    extends guiPanel {
        private static final long serialVersionUID = 4255621731721815087L;
        private final guiCheckBox d_heatCB;
        private final guiRadioButton d_endo;
        private final guiRadioButton d_exo;
        private final ValueField<UnitDouble> d_heat;
        private boolean d_isSolid;
        private final guiTable d_table;

        public ByproductsPanel(boolean bl) {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_isSolid = bl;
            guiLabel guiLabel2 = null;
            if (this.d_isSolid) {
                this.d_heatCB = new guiCheckBox(Intl.intl("Heat of Reaction") + ":");
                this.d_heat = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(47), UnitSystem.getSource(47));
                this.d_heat.setNullAllowed(false);
                this.d_heatCB.addActionListener(actionEvent -> {
                    if (this.d_heat.isEmpty()) {
                        this.d_heat.setValue(SIUS.newud(0.0, 48));
                    }
                    this.d_heat.requestFocusInWindow();
                });
            } else {
                this.d_heatCB = null;
                guiLabel2 = new guiLabel(Intl.intl("Heat of Vaporization") + ":");
                this.d_heat = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(46), UnitSystem.getSource(46));
            }
            this.d_endo = new guiRadioButton(Intl.intl("Endothermic"));
            this.d_exo = new guiRadioButton(Intl.intl("Exothermic"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_endo);
            buttonGroup.add(this.d_exo);
            JComponent jComponent = this.d_heatCB != null ? this.d_heatCB : guiLabel2;
            GridBagUtil.add(this, jComponent, 0, n, 2, 1, 12, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heat, 2, n, 1, 1, 12, 0, 6, 6, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_endo, 4, n, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_exo, 5, n++, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            String[] stringArray = new String[]{Intl.intl("Composition"), Intl.intl("Residue")};
            Class[] classArray = new Class[]{Double.class, AliasedVal.class};
            this.d_table = guiTableUtil.fixedColumnTable(stringArray, classArray);
            this.setTableOpts();
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.d_table.getColumnModel().getColumn(1).setPreferredWidth(120);
            int n2 = this.d_table.autoSizeColumns(10);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(n2, 10));
            guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 30);
            GridBagUtil.add(this, guiTableEditor2, 0, n++, 6, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
            GridBagUtil.addGlue(this);
            if (this.d_heatCB != null) {
                LinkStatus.link((AbstractButton)this.d_heatCB, this.d_heat, this.d_endo, this.d_exo);
            }
        }

        private void setTableOpts() {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            List<Material> list = Util.sort(pyroMod.getMaterialMgr());
            List<ExSpec> list2 = Util.sort(pyroMod.getExSpecList());
            ArrayList<AliasedVal<NamedPyroObject>> arrayList = new ArrayList<AliasedVal<NamedPyroObject>>();
            for (Material namedPyroObject : list) {
                if (namedPyroObject.equals(MaterialPanel.this.d_currentMaterial)) continue;
                arrayList.add(new AliasedVal<Material>(namedPyroObject));
            }
            for (ExSpec exSpec : list2) {
                arrayList.add(new AliasedVal<ExSpec>(exSpec));
            }
            this.d_table.setColumnOptions(1, arrayList);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            double d = 0.0;
            ArrayList<NamedPyroObject> arrayList = new ArrayList<NamedPyroObject>();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                Double d2 = (Double)this.d_table.getValueAt(i, 0);
                AliasedVal aliasedVal = (AliasedVal)this.d_table.getValueAt(i, 1);
                if (d2 == null && aliasedVal == null) continue;
                if (d2 == null || d2 < 0.0) {
                    this.procWarning(bl, bl2, Intl.intl("All yield fractions must be greater than zero."));
                    return false;
                }
                if (aliasedVal == null) {
                    this.procWarning(bl, bl2, Intl.intl("All yield values must correspond to a valid residue."));
                    return false;
                }
                NamedPyroObject namedPyroObject = (NamedPyroObject)aliasedVal.value;
                if (arrayList.contains(namedPyroObject)) {
                    this.procWarning(bl, bl2, String.format(Intl.intl("All residues must be unique. The duplicate residue %s at row %d has been ignored for redundancy."), namedPyroObject.getName(), i + 1));
                    continue;
                }
                d += d2.doubleValue();
                arrayList.add(namedPyroObject);
            }
            if (d > 1.0) {
                this.procWarning(bl, bl2, Intl.intl("All yield values must sum to one or less."));
                return false;
            }
            return true;
        }

        private void procWarning(boolean bl, boolean bl2, String string) {
            if (!this.d_isSolid && bl2) {
                MaterialPanel.this.d_tabs.setSelectedComponent(MaterialPanel.this.d_liquidPyrolysisPanel);
            }
            if (bl) {
                guiDialog.showInvalidEntryMessage(this, string);
            }
        }

        public void loadData(ReacByproducts reacByproducts, Material material) {
            if (this.d_heatCB != null) {
                this.d_heatCB.setSelected(false);
            }
            if (this.d_heatCB != null) {
                this.d_heatCB.setSelected(false);
            }
            this.d_endo.setSelected(true);
            this.d_table.selectAll();
            this.d_table.removeSelectedRows();
            this.d_table.clearSelection();
            this.setTableOpts();
            if (reacByproducts == null) {
                return;
            }
            ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_table.getModel();
            int n = 0;
            for (Serializable serializable : reacByproducts.getResidues()) {
                Object[] objectArray = new Object[]{serializable.d_fraction, new AliasedVal<NamedPyroObject>(serializable.d_type)};
                resizableTableModel.insertRow(n++, objectArray);
            }
            Unit unit = ((UnitDoubleFormat)this.d_heat.getFormat()).getUnitType().getUnit();
            if (reacByproducts.d_heat != null) {
                Serializable serializable;
                if (this.d_heatCB != null) {
                    this.d_heatCB.setSelected(true);
                }
                if (reacByproducts.d_heat.getValue(unit) < 0.0) {
                    serializable = reacByproducts.d_heat.negate();
                    this.d_exo.setSelected(true);
                } else {
                    serializable = reacByproducts.d_heat;
                    this.d_endo.setSelected(true);
                }
                this.d_heat.setValue(serializable);
            } else {
                this.d_heat.setValue(new UnitDouble(0.0, unit));
            }
        }

        public ReacByproducts saveData() {
            UnitDouble unitDouble = null;
            if (this.d_heatCB == null || this.d_heatCB.isSelected()) {
                unitDouble = (UnitDouble)this.d_heat.getValue();
                if (this.d_exo.isSelected()) {
                    unitDouble = unitDouble.negate();
                }
            }
            ArrayList<Material> arrayList = new ArrayList<Material>();
            ArrayList<ExSpec> arrayList2 = new ArrayList<ExSpec>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            ArrayList<NamedPyroObject> arrayList5 = new ArrayList<NamedPyroObject>();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                if (this.d_table.getValueAt(i, 0) == null || this.d_table.getValueAt(i, 1) == null) continue;
                double d = (Double)this.d_table.getValueAt(i, 0);
                NamedPyroObject namedPyroObject = (NamedPyroObject)((AliasedVal)this.d_table.getValueAt((int)i, (int)1)).value;
                if (!(d > 0.0) || namedPyroObject == null || arrayList5.contains(namedPyroObject)) continue;
                if (namedPyroObject instanceof ExSpec) {
                    arrayList2.add((ExSpec)namedPyroObject);
                    arrayList4.add(d);
                }
                if (namedPyroObject instanceof Material) {
                    arrayList.add((Material)namedPyroObject);
                    arrayList3.add(d);
                }
                arrayList5.add(namedPyroObject);
            }
            return new ReacByproducts(arrayList3, arrayList, arrayList4, arrayList2, unitDouble);
        }

        private class AliasedVal<ValType>
        implements Serializable {
            private static final long serialVersionUID = 7935159083378466645L;
            public final ValType value;
            public final String alias;

            public AliasedVal(ValType ValType) {
                this.value = ValType;
                String string = "";
                if (ValType instanceof ExSpec) {
                    string = "[" + Intl.intl("Species:") + " SPEC] ";
                } else if (ValType instanceof Material) {
                    string = "[" + Intl.intl("Material:") + " MAT] ";
                }
                this.alias = string + ((NamedPyroObject)ValType).getName();
            }

            public String toString() {
                return this.alias;
            }

            public boolean equals(Object object) {
                return object == this || object instanceof AliasedVal && theUtil.equal(((AliasedVal)object).value, this.value);
            }
        }
    }

    private class LiquidPyrolysisPanel
    extends guiPanel {
        private static final long serialVersionUID = -5577229301363921584L;
        private final ValueField<UnitDouble> d_boilTemp;
        private final guiCheckBox d_heatOfCombustCB;
        private final ValueField<UnitDouble> d_heatOfCombust;
        private final ByproductsPanel d_byproductsPanel;

        public LiquidPyrolysisPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_boilTemp = ValueFields.udFld(UnitSystem.getSource(1));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Boiling Temperature") + ":");
            this.d_heatOfCombustCB = new guiCheckBox(Intl.intl("Heat of Combustion:"));
            this.d_heatOfCombust = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_heatOfCombust.setNullAllowed(false);
            this.d_heatOfCombustCB.addActionListener(actionEvent -> {
                if (this.d_heatOfCombust.isEmpty()) {
                    this.d_heatOfCombust.setValue(SIUS.newud(0.0, 48));
                }
                this.d_heatOfCombust.requestFocusInWindow();
            });
            LinkStatus.link((AbstractButton)this.d_heatOfCombustCB, this.d_heatOfCombust);
            GridBagUtil.add(this, this.d_heatOfCombustCB, 0, n, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatOfCombust, 2, n++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_boilTemp, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Byproducts"));
            GridBagUtil.add(this, titleSeparator, 0, n++, 4, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 17);
            this.d_byproductsPanel = new ByproductsPanel(false);
            GridBagUtil.add(this, this.d_byproductsPanel, 0, n++, 4, 1, -12, 18, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(LiquidPyrolysis liquidPyrolysis) {
            LiquidPyrolysis liquidPyrolysis2 = new LiquidPyrolysis();
            this.d_heatOfCombustCB.setSelected(liquidPyrolysis2.d_heatOfCombust != null);
            this.d_heatOfCombust.setValue(liquidPyrolysis2.d_heatOfCombust);
            this.d_boilTemp.setValue(liquidPyrolysis2.d_reaction.d_rate.d_boilingTemp);
            this.d_byproductsPanel.loadData(liquidPyrolysis2.d_reaction.d_byproducts, MaterialPanel.this.d_currentMaterial);
            if (liquidPyrolysis == null) {
                return;
            }
            this.d_heatOfCombustCB.setSelected(liquidPyrolysis.d_heatOfCombust != null);
            this.d_heatOfCombust.setValue(liquidPyrolysis.d_heatOfCombust);
            this.d_boilTemp.setValue(liquidPyrolysis.d_reaction.d_rate.d_boilingTemp);
            this.d_byproductsPanel.loadData(liquidPyrolysis.d_reaction.d_byproducts, MaterialPanel.this.d_currentMaterial);
        }

        public LiquidPyrolysis saveData() {
            UnitDouble unitDouble = this.d_heatOfCombustCB.isSelected() ? (UnitDouble)this.d_heatOfCombust.getValue() : null;
            return new LiquidPyrolysis(unitDouble, new LiquidReaction(new LiquidReaction.Rate((UnitDouble)this.d_boilTemp.getValue()), this.d_byproductsPanel.saveData()));
        }
    }

    private class ThermPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 8205694290246682343L;
        private final ValueField<UnitDouble> d_density;
        private final ValueField<UnitDouble> d_specHeat;
        private final ValueField<UnitDouble> d_conductivity;
        private final ValueField<UnitDouble> d_absCoef;
        private final ValueField<Double> d_emissivity;
        private final JButton d_specHeatButton;
        private final JButton d_conductivityButton;
        private final RampAction d_specHeatAction;
        private final RampAction d_condAction;
        private final String d_constantID = Intl.intl("Constant");
        private final String d_fromTableID = Intl.intl("Custom");
        private final guiComboBox d_specHeatComboBox;
        private final guiComboBox d_condComboBox;
        private final guiPanel d_specHeatPanel;
        private final guiPanel d_condPanel;

        public ThermPropsPanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            this.d_density = ValueFields.udFld(UnitSystem.getSource(4));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Density") + ":");
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_density, 2, n++, 1, 1, 12, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_specHeat = ValueFields.udFld(UnitSystem.getSource(11));
            this.d_specHeatButton = new JButton(Intl.intl("Edit table") + "...");
            this.d_specHeatAction = new RampAction(RampInputs.HEAT, 11, Intl.intl("Specific heat"));
            this.d_specHeatButton.addActionListener(this.d_specHeatAction);
            this.d_specHeatPanel = new guiPanel();
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Specific Heat"));
            this.d_specHeatPanel.setLayout(new GridBagLayout());
            this.d_specHeatPanel.add(this.d_specHeat);
            this.d_specHeatComboBox = new guiComboBox<Object>((T[])new Object[]{this.d_constantID, this.d_fromTableID});
            this.d_specHeatComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = itemEvent.getItem().toString();
                    ThermPropsPanel.this.d_specHeatPanel.removeAll();
                    if (string.equals(ThermPropsPanel.this.d_constantID)) {
                        ThermPropsPanel.this.d_specHeatPanel.add(ThermPropsPanel.this.d_specHeat);
                    } else {
                        ThermPropsPanel.this.d_specHeatPanel.add(ThermPropsPanel.this.d_specHeatButton);
                    }
                    ThermPropsPanel.this.validate();
                }
            });
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specHeatComboBox, 1, n, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specHeatPanel, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_conductivity = ValueFields.udFld(UnitSystem.getSource(19));
            this.d_conductivityButton = new JButton(Intl.intl("Edit table") + "...");
            this.d_condAction = new RampAction(RampInputs.HEAT, 19, Intl.intl("Conductivity"));
            this.d_conductivityButton.addActionListener(this.d_condAction);
            this.d_condPanel = new guiPanel();
            this.d_condPanel.setLayout(new GridBagLayout());
            this.d_condPanel.add(this.d_conductivity);
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Conductivity"));
            this.d_condComboBox = new guiComboBox<Object>((T[])new Object[]{this.d_constantID, this.d_fromTableID});
            this.d_condComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = itemEvent.getItem().toString();
                    ThermPropsPanel.this.d_condPanel.removeAll();
                    if (string.equals(ThermPropsPanel.this.d_constantID)) {
                        ThermPropsPanel.this.d_condPanel.add(ThermPropsPanel.this.d_conductivity);
                    } else {
                        ThermPropsPanel.this.d_condPanel.add(ThermPropsPanel.this.d_conductivityButton);
                    }
                    ThermPropsPanel.this.validate();
                }
            });
            GridBagUtil.add(this, guiLabel4, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_condComboBox, 1, n, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_condPanel, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_emissivity = ValueFields.doubleFld();
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Emissivity") + ":");
            GridBagUtil.add(this, guiLabel5, 0, n, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_emissivity, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_absCoef = ValueFields.udFld(UnitSystem.getSource(13));
            guiLabel guiLabel6 = new guiLabel(Intl.intl("Absorption Coefficient") + ":");
            GridBagUtil.add(this, guiLabel6, 0, n, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_absCoef, 2, n++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(ThermalProps thermalProps) {
            ThermalProps thermalProps2 = new ThermalProps();
            this.d_density.setValue(thermalProps2.d_density);
            this.d_specHeatAction.d_holdRamp = null;
            this.d_specHeatComboBox.setSelectedIndex(0);
            this.d_specHeatPanel.removeAll();
            this.d_specHeatPanel.add(this.d_specHeat);
            this.d_specHeat.setValue(((IHeatBasedValue.Constant)thermalProps2.d_specificHeat).value);
            this.d_condAction.d_holdRamp = null;
            this.d_condComboBox.setSelectedIndex(0);
            this.d_condPanel.removeAll();
            this.d_condPanel.add(this.d_conductivity);
            this.d_conductivity.setValue(((IHeatBasedValue.Constant)thermalProps2.d_conductivity).value);
            this.d_emissivity.setValue(thermalProps2.d_emissivity);
            this.d_absCoef.setValue(thermalProps2.d_absorptionCoeff);
            if (thermalProps == null) {
                return;
            }
            this.d_density.setValue(thermalProps.d_density);
            if (thermalProps.d_specificHeat instanceof IHeatBasedValue.Constant) {
                this.d_specHeat.setValue(((IHeatBasedValue.Constant)thermalProps.d_specificHeat).value);
            } else {
                this.d_specHeatAction.d_holdRamp = ((IHeatBasedValue.Custom)thermalProps.d_specificHeat).value;
                this.d_specHeatComboBox.setSelectedIndex(1);
                this.d_specHeatPanel.removeAll();
                this.d_specHeatPanel.add(this.d_specHeatButton);
            }
            if (thermalProps.d_conductivity instanceof IHeatBasedValue.Constant) {
                this.d_conductivity.setValue(((IHeatBasedValue.Constant)thermalProps.d_conductivity).value);
            } else {
                this.d_condAction.d_holdRamp = ((IHeatBasedValue.Custom)thermalProps.d_conductivity).value;
                this.d_condComboBox.setSelectedIndex(1);
                this.d_condPanel.removeAll();
                this.d_condPanel.add(this.d_conductivityButton);
            }
            this.d_emissivity.setValue(thermalProps.d_emissivity);
            this.d_absCoef.setValue(thermalProps.d_absorptionCoeff);
        }

        public ThermalProps saveData() {
            IHeatBasedValue iHeatBasedValue = null;
            IHeatBasedValue iHeatBasedValue2 = null;
            iHeatBasedValue2 = this.d_specHeatComboBox.getSelectedIndex() == 0 ? new IHeatBasedValue.Constant((UnitDouble)this.d_specHeat.getValue()) : new IHeatBasedValue.Custom(this.d_specHeatAction.d_holdRamp);
            iHeatBasedValue = this.d_condComboBox.getSelectedIndex() == 0 ? new IHeatBasedValue.Constant((UnitDouble)this.d_conductivity.getValue()) : new IHeatBasedValue.Custom(this.d_condAction.d_holdRamp);
            return new ThermalProps(iHeatBasedValue, (UnitDouble)this.d_density.getValue(), iHeatBasedValue2, (Double)this.d_emissivity.getValue(), (UnitDouble)this.d_absCoef.getValue());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            return this.validateRampData(Intl.intl("Specific Heat"), this.d_specHeatComboBox, this.d_specHeatButton, this.d_specHeatAction, bl, bl2) && this.validateRampData(Intl.intl("Conductivity"), this.d_condComboBox, this.d_conductivityButton, this.d_condAction, bl, bl2);
        }

        private boolean validateRampData(String string, guiComboBox guiComboBox2, JButton jButton, RampAction rampAction, boolean bl, boolean bl2) {
            if (guiComboBox2.getSelectedIndex() == 1 && rampAction.d_holdRamp == null && jButton.isEnabled() && jButton.isVisible()) {
                if (bl) {
                    String string2 = String.format(Intl.intl("Custom %s table must not be empty."), string);
                    guiDialog.showInvalidEntryMessage(this, string2);
                }
                if (bl2) {
                    jButton.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

