/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.boundcond.MaterialPanel;
import pyrosim.gui.boundcond.NewMaterialDlg;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class MaterialManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -6174319026326721262L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private MaterialManager d_matMgr;
    private JFrame d_owner;

    public MaterialManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Edit Materials"), true);
        this.d_owner = jFrame;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(Material.class), new RenameAction(this, Intl.intl("material")), new ManagerDlg.DeleteAction()};
        this.d_editor = new MaterialPanel(this);
    }

    private void updateActions() {
        int n = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_matMgr != null);
        this.d_actions[2].setEnabled(this.d_matMgr != null && n > -1);
        this.d_actions[3].setEnabled(this.d_matMgr != null && n > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(MaterialManager materialManager, Material material) {
        this.d_matMgr = materialManager;
        ((RenameAction)this.d_actions[2]).init(materialManager);
        super.init(this.d_matMgr, this.d_editor, this.d_actions, material);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 61273074678084049L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MaterialManagerDlg.this.preSave()) {
                return;
            }
            int n = MaterialManagerDlg.this.getList().getSelectedIx();
            Material material = n >= 0 ? (Material)MaterialManagerDlg.this.getList().getItem(n) : null;
            NewMaterialDlg newMaterialDlg = new NewMaterialDlg((Window)MaterialManagerDlg.this, MaterialManagerDlg.this.d_matMgr, material);
            PyroMod pyroMod = (PyroMod)MaterialManagerDlg.this.d_matMgr.getDomain();
            if (newMaterialDlg.doModal() == 1) {
                Material material2 = newMaterialDlg.getBaseMat();
                if (material2 == null) {
                    return;
                }
                Material material3 = new Material(newMaterialDlg.getName(), material2.getPyrolysis(), material2.getThermalProps());
                material3.setCustomFDSProps(material2.getCustomFDSProps());
                AddTask addTask = new AddTask((IPyroObject)MaterialManagerDlg.this.d_matMgr, new IPyroObject[]{material3});
                SelectTask selectTask = new SelectTask(pyroMod, material3);
                selectTask.addTask(addTask);
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Material"));
                MaterialManagerDlg.this.getList().updateModelView(MaterialManagerDlg.this.d_matMgr);
                MaterialManagerDlg.this.getList().select(material3);
                MaterialManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                MaterialManagerDlg.this.updateActions();
            }
        }
    }
}

