/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.appearance.ImageBtnListener;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class MaterialDlg
extends guiDialog
implements IEventObserver,
DlgListener {
    private static final long serialVersionUID = 2884804570534305967L;
    public static final String MATERIAL_DLG_VIEW = "MaterialDlg.View";
    public static final String LIST_OPTION = "list option";
    public static final String ICONS_OPTION = "icons option";
    private List<Material> d_materials;
    private Material d_choice;
    private final MaterialDB d_texDB;
    private final EditorPnl d_editor;
    private final IconsPanel d_iconsPanel;
    private final JButton d_removeBtn;

    public MaterialDlg(JFrame jFrame, String string, MaterialDB materialDB, Material material, boolean bl) {
        super((Window)jFrame, string, 11);
        super.setResizable(true);
        this.d_choice = null;
        this.d_texDB = materialDB;
        this.d_editor = new EditorPnl();
        this.d_removeBtn = new JButton(new RemoveAction());
        JButton jButton = new JButton(new ImportAction());
        this.d_iconsPanel = new IconsPanel(this.d_editor);
        this.d_iconsPanel.setPreferredSize(new Dimension(200, 400));
        JSplitPane jSplitPane = new JSplitPane(1, this.d_iconsPanel, this.d_editor);
        guiPanel guiPanel2 = super.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, jSplitPane, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        GridBagUtil.add(guiPanel2, jButton, 0, 1, 1, 1, 12, 12, 0, 0, 0, 0.0, 0.0);
        GridBagUtil.add(guiPanel2, this.d_removeBtn, 1, 1, 1, 1, 12, 6, 0, 0, 0, 0.0, 0.0);
        this.addDlgListener(this);
        CloseListener closeListener = new CloseListener();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(keyStroke);
        this.getRootPane().registerKeyboardAction(closeListener, keyStroke, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeListener);
        this.d_iconsPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Material material = (Material)itemEvent.getItem();
                if (material == MaterialDlg.this.d_choice) {
                    return;
                }
                if (MaterialDlg.this.d_choice != null && MaterialDlg.this.d_editor.isModified()) {
                    switch (MaterialDlg.this.showConfirm()) {
                        case 0: {
                            boolean bl = MaterialDlg.this.handleYes();
                            if (!bl) {
                                MaterialDlg.this.setChoice(MaterialDlg.this.d_choice);
                                break;
                            }
                        }
                        case 1: {
                            MaterialDlg.this.setChoice(material);
                            break;
                        }
                        default: {
                            MaterialDlg.this.setChoice(MaterialDlg.this.d_choice);
                            break;
                        }
                    }
                } else {
                    MaterialDlg.this.setChoice(material);
                }
            }
        });
        this.updateMaterialsList(bl);
        this.setChoice(material);
    }

    @Override
    public int doModal() {
        PyroSim.getApp().getMediator().getEvents().addObserver(this);
        int n = super.doModal();
        PyroSim.getApp().getMediator().getEvents().removeObserver(this);
        return n;
    }

    @Override
    public boolean doModeless() {
        PyroSim.getApp().getMediator().getEvents().addObserver(this);
        boolean bl = super.doModeless();
        PyroSim.getApp().getMediator().getEvents().removeObserver(this);
        return bl;
    }

    protected final boolean preSave() {
        if (this.d_editor.isModified()) {
            int n = this.showConfirm();
            if (n == 1) {
                this.d_editor.init(this.d_choice);
            } else if (n == 0) {
                if (!this.handleYes()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public int showConfirm() {
        Material material = this.d_choice;
        String string = String.format(Intl.intl("Save changes to: %s?"), material.getName());
        return JOptionPane.showConfirmDialog(this, string);
    }

    protected boolean handleYes() {
        if (!this.d_editor.validateData(true, true)) {
            this.setChoice(this.d_choice);
            return false;
        }
        this.d_editor.commit(this.d_choice, false);
        return true;
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void applyPressed() {
        if (this.d_editor.isModified()) {
            this.d_editor.commit(this.d_choice, false);
            this.d_iconsPanel.repaint();
        }
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.setChoice(this.d_choice);
                        this.setVisible(false);
                        break;
                    }
                    this.setChoice(this.d_choice);
                    break;
                }
                case 1: {
                    this.setChoice(this.d_choice);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.setChoice(this.d_choice);
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    public Material getSelectedEntry() {
        return this.d_choice;
    }

    private void setChoice(Material material) {
        this.d_choice = material;
        this.d_removeBtn.setEnabled(this.d_choice != null);
        this.d_iconsPanel.setSelectedItem(material);
        this.d_editor.init(material);
    }

    protected void showException(Exception exception, String string) {
        PyroGuiUtil.showError(this, Intl.intl("Error"), string, (Throwable)exception);
    }

    protected void updateMaterialsList(boolean bl) {
        this.d_materials = new ArrayList(this.d_texDB.flatten());
        if (bl) {
            this.d_materials.add(null);
        }
        this.sortMaterials();
        this.d_iconsPanel.update(this.d_materials);
    }

    private void sortMaterials() {
        Collections.sort(this.d_materials, new Comparator<Material>(){

            @Override
            public int compare(Material material, Material material2) {
                if (material == null && material2 == null) {
                    return 0;
                }
                if (material == null) {
                    return -1;
                }
                if (material2 == null) {
                    return 1;
                }
                return material.getName().compareToIgnoreCase(material2.getName());
            }
        });
    }

    @Override
    public void update(Events events) {
        IEventRecord<Material> iEventRecord = events.getEvents(Material.class, new Class[0]);
        if (!iEventRecord.isModified()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Material material = this.d_choice;
        for (Material material2 : iEventRecord.getAddedObjs()) {
            if (material == null) {
                material = material2;
            }
            this.d_materials.add(material2);
            bl2 = true;
            bl = true;
        }
        for (Material material2 : iEventRecord.getRemovedObjs()) {
            if (material2.equals(this.d_choice)) {
                material = null;
            }
            this.d_materials.remove(material2);
            bl2 = true;
        }
        if (bl) {
            this.sortMaterials();
        }
        if (bl2) {
            this.d_iconsPanel.update(this.d_materials);
            this.repaint();
        }
        this.setChoice(material);
    }

    private class RemoveAction
    extends guiAction {
        private static final long serialVersionUID = 3516972269513761812L;

        public RemoveAction() {
            super(Intl.intl("Remove") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            if (MaterialDlg.this.d_choice == null) {
                return;
            }
            String string = MaterialDlg.this.d_choice.getName();
            if (MaterialDlg.this.d_texDB.isPermanent(MaterialDlg.this.d_choice)) {
                object2 = String.format(Intl.intl("Permanently remove database appearance: %s?<br><b>NOTE:</b> This operation cannot be undone."), string);
                object2 = "<html>" + (String)object2 + "</html>";
                int n = JOptionPane.showConfirmDialog(null, object2, (String)(object = Intl.intl("Remove Appearance?")), 0, 2);
                if (n != 0) {
                    return;
                }
            }
            if ((object2 = Actions.getDeleteTask((PyroMod)MaterialDlg.this.d_texDB.getDomain(), Arrays.asList(MaterialDlg.this.d_choice))) == null) {
                return;
            }
            if (MaterialDlg.this.d_texDB.isPermanent(MaterialDlg.this.d_choice)) {
                object = object2;
                object2 = new AOneTimeTask((Task)object){
                    final /* synthetic */ Task val$undoableTsk;
                    {
                        this.val$undoableTsk = task;
                    }

                    @Override
                    public void run() {
                        this.val$undoableTsk.run();
                    }
                };
            }
            object = PyroSim.getApp().getMediator();
            ((PyroMod)object).getTaskManager().exec((Task)object2, Intl.intl("Remove Appearance"), 1);
        }
    }

    private class ImportAction
    extends guiAction {
        private static final long serialVersionUID = 4515572153163001586L;

        public ImportAction() {
            super(Intl.intl("Import") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            guiFileChooser guiFileChooser2 = PyroSim.getFilenames().getFileChooser(MaterialDlg.this.d_texDB.getFileFilters());
            guiFileChooser2.setMultiSelectionEnabled(true);
            if (guiFileChooser2.showOpenDialog(MaterialDlg.this) != 0) {
                return;
            }
            final File[] fileArray = guiFileChooser2.getSelectedFiles();
            final ArrayList arrayList = new ArrayList(fileArray.length);
            final ArrayList arrayList2 = new ArrayList();
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    try {
                        for (File file : fileArray) {
                            IImage iImage = ImageManager.getImage(file.getAbsolutePath(), 3, 0);
                            String string = FilenameManager.splitFilename(file.getName())[0];
                            Texture texture = Texture.repeated(iImage, "uvset");
                            MatAttrs matAttrs = new MatAttrs(Color.WHITE, texture, 1.0);
                            Material material = new Material(string, matAttrs);
                            MaterialDlg.this.d_texDB.add(material);
                            MaterialDlg.this.d_texDB.importToDB(material);
                            arrayList.add(material);
                        }
                    }
                    catch (Exception exception) {
                        arrayList2.add(exception);
                    }
                }
            };
            pyroMod.getTaskManager().exec((Task)aOneTimeTask, Intl.intl("Import Appearances"), 1);
            if (!arrayList2.isEmpty()) {
                MaterialDlg.this.showException((Exception)arrayList2.get(0), Intl.intl("Error importing appearance."));
            }
        }
    }

    private static class TiledPanel
    extends guiPanel {
        private static final long serialVersionUID = 5351990684840771048L;
        private final MatChannel d_channel;
        private Material d_choice;

        public TiledPanel(MatChannel matChannel) {
            this.d_channel = matChannel;
        }

        public void setMaterial(Material material) {
            this.d_choice = material;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = this.getBounds();
            if (this.d_choice == null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = Intl.intl("No Material");
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                int n = rectangle.width / 2 - (int)(rectangle2D.getWidth() / 2.0);
                int n2 = rectangle.height / 2 - (int)(rectangle2D.getHeight() / 2.0);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(string, n, n2);
            } else if (this.d_choice.getAttributes().getTexture(this.d_channel) != null) {
                Texture texture = this.d_choice.getAttributes().getTexture(this.d_channel);
                BufferedImage bufferedImage = PyroGuiUtil.getBufferedImage(texture.image);
                if (bufferedImage == null) {
                    return;
                }
                int n = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                int n4 = (rectangle.width + n - 1) / n;
                int n5 = (rectangle.height + n3 - 1) / n3;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        graphics2D.drawImage(bufferedImage, null, i * n, j * n3);
                    }
                }
            } else {
                Color color = this.d_choice.getAttributes().getColor(this.d_channel);
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private static class ImagePanel
    extends guiPanel {
        private static final long serialVersionUID = -4248122173336772028L;
        private Material d_choice;
        private final MatChannel d_channel;

        public ImagePanel(MatChannel matChannel) {
            this.d_channel = matChannel;
        }

        public void setMaterial(Material material) {
            this.d_choice = material;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = this.getBounds();
            if (this.d_choice == null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = Intl.intl("No Material");
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                int n = rectangle.width / 2 - (int)(rectangle2D.getWidth() / 2.0);
                int n2 = rectangle.height / 2 - (int)(rectangle2D.getHeight() / 2.0);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(string, n, n2);
            } else if (this.d_choice.getAttributes().getTexture(this.d_channel) != null) {
                Texture texture = this.d_choice.getAttributes().getTexture(this.d_channel);
                BufferedImage bufferedImage = PyroGuiUtil.getBufferedImage(texture.image);
                if (bufferedImage == null) {
                    return;
                }
                int n = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                double d = Math.min(1.0, (double)this.getWidth() / (double)n);
                double d2 = Math.min(1.0, (double)this.getHeight() / (double)n3);
                double d3 = Math.min(d, d2);
                double d4 = d3 * (double)n;
                double d5 = d3 * (double)n3;
                double d6 = Math.max(0.0, ((double)this.getWidth() - d4) / 2.0);
                double d7 = Math.max(0.0, ((double)this.getHeight() - d5) / 2.0);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(d6, d7);
                affineTransform.scale(d3, d3);
                graphics2D.drawImage(bufferedImage, affineTransform, this);
            } else {
                Color color = this.d_choice.getAttributes().getColor(this.d_channel);
                double d = 128.0;
                double d8 = 128.0;
                double d9 = (double)this.getWidth() * 0.5;
                double d10 = (double)this.getHeight() * 0.5;
                graphics2D.setColor(color);
                graphics2D.fillRect((int)Math.round(d9 - d * 0.5), (int)Math.round(d10 - d8 * 0.5), (int)d, (int)d8);
            }
        }
    }

    private static class EditorPnl
    extends guiPanel
    implements Observer {
        private static final long serialVersionUID = -2568401929296596028L;
        private final guiLabel d_title;
        private final guiRadioButton d_colorRB;
        private final guiRadioButton d_imgRB;
        private final ColorButton d_colorBtn;
        private final ImageBtn d_imgBtn;
        private final ImageBtnListener d_imgBtnLnr;
        private final ValueField<UnitDouble> d_opacityFld;
        private final ValueField<UnitDouble> d_wid;
        private final ValueField<UnitDouble> d_ht;
        private final ImagePanel d_preview = new ImagePanel(MatChannel.DIFFUSE);
        private final TiledPanel d_tiled;
        private Material d_previewObj;

        public EditorPnl() {
            this.d_preview.setPreferredSize(new Dimension(400, 300));
            this.d_tiled = new TiledPanel(MatChannel.DIFFUSE);
            this.d_tiled.setPreferredSize(new Dimension(400, 300));
            this.d_title = new guiLabel();
            this.d_title.setFont(new Font("Sans Serif", 1, 11));
            this.d_colorRB = new guiRadioButton(Intl.intl("Color:"));
            this.d_imgRB = new guiRadioButton(Intl.intl("Texture Image:"));
            this.d_imgRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!this.chooseImage()) {
                        d_colorRB.setSelected(true);
                    }
                }
            });
            new guiButtonGroup(this.d_colorRB, this.d_imgRB);
            this.d_colorBtn = new ColorButton(1);
            this.d_colorBtn.addObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    this.setModified(true);
                }
            });
            this.d_imgBtn = new ImageBtn();
            this.d_imgBtn.addObserver(new IObserver(){

                @Override
                public void update(IObservable iObservable, Object object) {
                    this.setModified(true);
                }
            }, false);
            this.d_imgBtnLnr = new ImageBtnListener();
            this.d_imgBtn.addActionListener(this.d_imgBtnLnr);
            IUnitSrc iUnitSrc = UnitSystem.getSource(0);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Width:"));
            this.d_wid = ValueFields.udFld(iUnitSrc);
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Height:"));
            this.d_ht = ValueFields.udFld(iUnitSrc);
            this.d_wid.setMinimumSize(this.d_wid.getPreferredSize());
            this.d_ht.setMinimumSize(this.d_ht.getPreferredSize());
            IUnitSrc iUnitSrc2 = UnitSystem.getSource(84);
            this.d_opacityFld = ValueFields.udFld(iUnitSrc2, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            LinkStatus.link((AbstractButton)this.d_colorRB, this.d_colorBtn);
            LinkStatus.link((AbstractButton)this.d_imgRB, this.d_imgBtn, this.d_wid, this.d_ht, guiLabel2, guiLabel3);
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.setTabPlacement(3);
            jTabbedPane.add(Intl.intl("Image"), this.d_preview);
            jTabbedPane.add(Intl.intl("Tiled"), this.d_tiled);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(Intl.intl("Name:"), this.d_title, 0);
            gridBagHelper.addRow(this.d_colorRB, this.d_colorBtn, 0);
            gridBagHelper.addRow(this.d_imgRB, this.d_imgBtn, 0);
            gridBagHelper.indent();
            gridBagHelper.addRow(guiLabel2, this.d_wid, 0);
            gridBagHelper.addRow(guiLabel3, this.d_ht, 0);
            gridBagHelper.unindent();
            gridBagHelper.addRow(Intl.intl("Opacity:"), this.d_opacityFld, 0);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Preview")));
            gridBagHelper.addIdentRow(jTabbedPane, new double[]{1.0, 1.0}, new int[]{0, 0});
            gridBagHelper.finalizeRows();
            this.d_comm.addObserver(this);
        }

        private boolean chooseImage() {
            if (this.d_imgBtn.getImage() != null) {
                return true;
            }
            return this.d_imgBtnLnr.chooseNewImage(this.d_imgBtn);
        }

        @Override
        public void update(Observable observable, Object object) {
            if (this.d_previewObj != null && this.validateData(false, false)) {
                this.commit(this.d_previewObj, true);
                this.d_preview.repaint();
                this.d_tiled.repaint();
            }
        }

        public void init(Material material) {
            this.d_previewObj = material != null ? material.clone() : null;
            this.setEnabled(material != null && material.getAttributes() instanceof MatAttrs);
            if (material == null) {
                this.d_title.setText(Intl.intl("no material"));
                this.d_wid.setValue(new UnitDouble(0.0, SI.METER));
                this.d_ht.setValue(new UnitDouble(0.0, SI.METER));
                this.d_colorBtn.setSelected(true);
                this.d_colorBtn.setColor(Color.WHITE);
                this.d_opacityFld.setValue(new UnitDouble(100.0, NonSI.PERCENT));
                this.d_imgBtn.setImage(null);
            } else {
                String string = material.getName();
                this.d_title.setText(string);
                this.d_wid.setValue(material.getWidth());
                this.d_ht.setValue(material.getHeight());
                IMatAttrs iMatAttrs = material.getAttributes();
                Texture texture = iMatAttrs.getTexture(MatChannel.DIFFUSE);
                this.d_colorBtn.setColor(iMatAttrs.getColor(MatChannel.DIFFUSE));
                if (texture == null) {
                    this.d_colorRB.setSelected(true);
                    this.d_imgBtn.setImage(null);
                } else {
                    this.d_imgRB.setSelected(true);
                    this.d_imgBtn.setImage(texture.image);
                }
                double d = 1.0;
                if (texture == null) {
                    d *= (double)iMatAttrs.getColor(MatChannel.DIFFUSE).getAlpha() / 255.0;
                }
                this.d_opacityFld.setValue(new UnitDouble(d *= (double)iMatAttrs.getColor(MatChannel.OPACITY).getRed() / 255.0, Unit.ONE));
            }
            this.d_preview.setMaterial(this.d_previewObj);
            this.d_tiled.setMaterial(this.d_previewObj);
            this.setModified(false);
        }

        public void commit(final Material material, boolean bl) {
            if (bl) {
                this.apply(material);
                return;
            }
            final PyroMod pyroMod = PyroSim.getApp().getMediator();
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    try {
                        this.apply(material);
                        pyroMod.getAppearances().updateFile(material);
                    }
                    catch (IOException iOException) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PyroGuiUtil.showError(this, Intl.intl("Error"), Intl.intl("Error saving appearance to file."), (Throwable)iOException);
                            }
                        });
                    }
                }
            };
            pyroMod.getTaskManager().exec((Task)aOneTimeTask, Intl.intl("Edit Appearance"), 1);
        }

        private void apply(Material material) {
            Object object;
            MatAttrs matAttrs = (MatAttrs)material.getAttributes();
            material.setSize((UnitDouble)this.d_wid.getValue(), (UnitDouble)this.d_ht.getValue());
            Texture texture = matAttrs.getTexture(MatChannel.DIFFUSE);
            Texture texture2 = null;
            if (this.d_imgRB.isSelected() && this.d_imgBtn.getImage() != null) {
                object = texture != null ? texture.uvSet : "uvset";
                texture2 = Texture.repeated(this.d_imgBtn.getImage(), (String)object);
            }
            object = this.d_colorBtn.getColor();
            object = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), 255);
            int n = (int)(((UnitDouble)this.d_opacityFld.getValue()).getValue(Unit.ONE) * 255.0);
            Color color = new Color(n, n, n, 255);
            matAttrs = matAttrs.apply(IMatAttrs.OPACITY_COLOR, color, IMatAttrs.DIFFUSE_COLOR, object, IMatAttrs.DIFFUSE_TEXTURE, texture2);
            material.setAttributes(matAttrs);
        }
    }

    private static class FlowPanel
    extends guiPanel
    implements IconView,
    ItemListener {
        private static final long serialVersionUID = 7909428469657713465L;
        private final guiPanel d_changeTrackPnl;
        private final List<ItemListener> d_listeners;

        public FlowPanel(guiPanel guiPanel2) {
            super(new FlowLayout(0));
            this.d_changeTrackPnl = guiPanel2;
            this.d_changeTrackPnl.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    this.updateModified();
                }
            });
            this.setBackground(UIManager.getDefaults().getColor("List.background"));
            this.d_listeners = new ArrayList<ItemListener>();
        }

        private void updateModified() {
            for (MaterialButton materialButton : this.getButtons()) {
                materialButton.setModified(materialButton.isSelected() && this.d_changeTrackPnl.isModified());
            }
        }

        @Override
        public Object[] getSelectedObjects() {
            Object[] objectArray;
            MaterialButton materialButton = (MaterialButton)this.getSelectedButton().v1;
            if (materialButton != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = materialButton.d_ti;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = null;
            }
            return objectArray;
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.d_listeners.add(itemListener);
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            this.d_listeners.remove(itemListener);
        }

        @Override
        public JComponent getPanel() {
            JScrollPane jScrollPane = new JScrollPane(this){
                private static final long serialVersionUID = -8464848771729576789L;

                @Override
                public void setBounds(int n, int n2, int n3, int n4) {
                    int n5;
                    int n6;
                    int n7;
                    super.setBounds(n, n2, n3, n4);
                    int n8 = this.getButtons().size();
                    int n9 = ((FlowLayout)this.getLayout()).getHgap();
                    int n10 = ((FlowLayout)this.getLayout()).getVgap();
                    int n11 = n3;
                    int n12 = 0;
                    int n13 = 0;
                    if (this.getComponentCount() != 0) {
                        Component component = this.getComponent(0);
                        Dimension dimension = component.getPreferredSize();
                        n12 = (int)dimension.getWidth();
                        n13 = (int)dimension.getHeight();
                    }
                    if ((n7 = (n11 - n9) / (n12 + n9)) < 1) {
                        n7 = 1;
                    }
                    if ((n6 = n8 / n7) * n7 != n8) {
                        ++n6;
                    }
                    if ((n5 = n6 * n13 + (n6 + 1) * n10) > n4) {
                        n11 = n3 - this.getVerticalScrollBar().getPreferredSize().width;
                        n7 = (n11 - n9) / (n12 + n9);
                        if (n7 < 1) {
                            n7 = 1;
                        }
                        if ((n6 = n8 / n7) * n7 != n8) {
                            ++n6;
                        }
                        n5 = n6 * n13 + (n6 + 1) * n10;
                    }
                    int n14 = n7 * n12 + (n7 + 1) * n9;
                    this.setPreferredSize(new Dimension(n14, n5));
                }
            };
            jScrollPane.setHorizontalScrollBarPolicy(31);
            return jScrollPane;
        }

        @Override
        public void update(List<Material> list) {
            this.removeAll();
            ButtonGroup buttonGroup = new ButtonGroup();
            for (Material material : list) {
                MaterialButton materialButton = new MaterialButton(material);
                materialButton.addItemListener(this);
                this.add(materialButton);
                buttonGroup.add(materialButton);
            }
        }

        @Override
        public void updateSel(Material material) {
            for (MaterialButton materialButton : this.getButtons()) {
                if (!theUtil.equal(materialButton.d_ti, material)) continue;
                IListenerStripper iListenerStripper = PyroGuiUtil.stripListeners(materialButton);
                materialButton.setSelected(true);
                iListenerStripper.restore();
                Rectangle rectangle = materialButton.getBounds();
                this.scrollRectToVisible(rectangle);
                break;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                MaterialButton materialButton = (MaterialButton)itemEvent.getItem();
                Material material = materialButton != null ? materialButton.d_ti : null;
                ItemEvent itemEvent2 = new ItemEvent(this, itemEvent.getID(), material, itemEvent.getStateChange());
                for (ItemListener itemListener : this.d_listeners) {
                    itemListener.itemStateChanged(itemEvent2);
                }
            }
        }

        private Pair<MaterialButton, Integer> getSelectedButton() {
            int n = 0;
            for (MaterialButton materialButton : this.getButtons()) {
                if (materialButton.isSelected()) {
                    return new Pair<MaterialButton, Integer>(materialButton, n);
                }
                ++n;
            }
            return new Pair<Object, Integer>(null, -1);
        }

        private List<MaterialButton> getButtons() {
            ArrayList<MaterialButton> arrayList = new ArrayList<MaterialButton>();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof MaterialButton)) continue;
                MaterialButton materialButton = (MaterialButton)component;
                arrayList.add(materialButton);
            }
            return arrayList;
        }

        private static class MaterialButton
        extends JToggleButton {
            private static final long serialVersionUID = -8285533984506071661L;
            private final Material d_ti;

            public MaterialButton(Material material) {
                this.d_ti = material;
                PyroGuiUtil.initButton((AbstractButton)this, material, 32, 32);
            }

            public void setModified(boolean bl) {
                if (bl) {
                    this.setFont(this.getFont().deriveFont(2));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
            }
        }
    }

    private static class ListPanel
    extends guiPanel
    implements IconView {
        private static final long serialVersionUID = 299773869766294421L;
        private final guiPanel d_changeTrackPnl;
        private final JList d_selList;

        public ListPanel(guiPanel guiPanel2) {
            super(new GridBagLayout());
            this.d_changeTrackPnl = guiPanel2;
            this.d_changeTrackPnl.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    this.repaint();
                }
            });
            this.d_selList = new JList();
        }

        @Override
        public Object[] getSelectedObjects() {
            return new Object[]{this.d_selList.getSelectedValue()};
        }

        @Override
        public JComponent getPanel() {
            return new JScrollPane(this);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            this.d_selList.addListSelectionListener(new SelListener(itemListener));
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            for (ListSelectionListener listSelectionListener : this.d_selList.getListSelectionListeners()) {
                if (!(listSelectionListener instanceof SelListener) || ((SelListener)listSelectionListener).ilistener != itemListener) continue;
                this.d_selList.removeListSelectionListener(listSelectionListener);
                break;
            }
        }

        @Override
        public void update(List<Material> list) {
            this.remove(this.d_selList);
            this.d_selList.setListData(new Vector<Material>(list));
            this.d_selList.setSelectionMode(0);
            this.d_selList.setCellRenderer(new MaterialListCellRenderer());
            GridBagUtil.add(this, this.d_selList, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        }

        @Override
        public void updateSel(Material material) {
            IListenerStripper iListenerStripper = PyroGuiUtil.stripListeners(this.d_selList);
            if (material == null && this.d_selList.getModel().getSize() > 0 && this.d_selList.getModel().getElementAt(0) == null) {
                this.d_selList.setSelectedIndex(0);
            } else {
                this.d_selList.setSelectedValue(material, true);
            }
            iListenerStripper.restore();
        }

        private class MaterialListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = -213431178399783403L;

            private MaterialListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Material material = (Material)object;
                Font font = this.getFont();
                if (material == null) {
                    font = font.deriveFont(1);
                    string = Intl.intl("<No Material>");
                } else {
                    string = material.getName();
                }
                if (ListPanel.this.d_changeTrackPnl.isModified() && bl) {
                    font = font.deriveFont(2);
                }
                Icon[] iconArray = PyroGuiUtil.getIcons((Material)object, 32, 32, 0, guiUtil.ImageFilter.NORMAL);
                this.setIcon(iconArray[0]);
                this.setFont(font);
                this.setText(string);
                return this;
            }
        }

        private class SelListener
        implements ListSelectionListener {
            public final ItemListener ilistener;

            public SelListener(ItemListener itemListener) {
                this.ilistener = itemListener;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Material material = (Material)ListPanel.this.d_selList.getSelectedValue();
                ItemEvent itemEvent = new ItemEvent(ListPanel.this, 701, material, 1);
                this.ilistener.itemStateChanged(itemEvent);
            }
        }
    }

    private static interface IconView
    extends ItemSelectable {
        public void update(List<Material> var1);

        public void updateSel(Material var1);

        public JComponent getPanel();
    }

    private static class IconsPanel
    extends guiPanel
    implements ItemSelectable {
        private static final long serialVersionUID = 3019442386619546185L;
        private final CardLayout d_cards;
        private final guiPanel d_cardPanel;
        private final List<View> d_views;
        private View d_currView;
        private List<Material> d_materials = Collections.EMPTY_LIST;

        public IconsPanel(guiPanel guiPanel2) {
            this.d_views = Arrays.asList(new View(Intl.intl("List"), new ListPanel(guiPanel2), MaterialDlg.LIST_OPTION), new View(Intl.intl("Icons"), new FlowPanel(guiPanel2), MaterialDlg.ICONS_OPTION));
            this.d_cards = new CardLayout(0, 0);
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            for (final View object : this.d_views) {
                buttonGroup.add(object.btn);
                object.btn.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            this.selectedPanel(object);
                        }
                    }
                });
                JComponent jComponent = object.iv.getPanel();
                this.d_cardPanel.add((Component)jComponent, object.pref);
                this.d_cards.addLayoutComponent(jComponent, object.pref);
                GridBagUtil.add(this, object.btn, n++, 0, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0);
            }
            GridBagUtil.add(this, this.d_cardPanel, 0, 1, 2, 1, 12, 6, 6, 6, 1, 1.0, 1.0);
            this.d_currView = this.d_views.get(0);
            String string = Application.getApp().getPreference(MaterialDlg.MATERIAL_DLG_VIEW);
            for (View view : this.d_views) {
                if (!view.pref.equals(string)) continue;
                view.btn.setSelected(true);
                break;
            }
            this.selectedPanel(this.d_currView);
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
            for (View view : this.d_views) {
                view.iv.addItemListener(itemListener);
            }
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
            for (View view : this.d_views) {
                view.iv.removeItemListener(itemListener);
            }
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.d_currView.iv.getSelectedObjects();
        }

        private void selectedPanel(View view) {
            Object[] objectArray;
            if (this.d_currView != null) {
                objectArray = this.d_currView.iv.getSelectedObjects();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = null;
            }
            Object[] objectArray3 = objectArray;
            this.d_currView = view;
            this.update(this.d_materials);
            this.setSelectedItem((Material)objectArray3[0]);
            this.d_cards.show(this.d_cardPanel, this.d_currView.pref);
            Application.getApp().setPreference(MaterialDlg.MATERIAL_DLG_VIEW, this.d_currView.pref);
        }

        public void update(List<Material> list) {
            this.d_materials = list;
            this.d_currView.iv.update(this.d_materials);
        }

        public void setSelectedItem(Material material) {
            this.d_currView.iv.updateSel(material);
        }

        private class View {
            public final guiRadioButton btn;
            public final IconView iv;
            public final String pref;

            public View(String string, IconView iconView, String string2) {
                this.btn = new guiRadioButton(string);
                this.iv = iconView;
                this.pref = string2;
            }
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.close();
        }

        private void close() {
            MaterialDlg.this.d_status = 16;
            MaterialDlg.this.fireButtonPressed(16);
        }
    }
}

