/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.Material;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.appearance.MaterialDlg;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class MaterialBtn
extends JButton
implements Modifiable,
IObservable,
ActionListener {
    private static final long serialVersionUID = 8564764994813162520L;
    private final boolean d_allowNull;
    private final ObservableProxy d_helper;
    private boolean d_modified;
    private WeakReference<Material> d_material;
    private boolean d_multiple;

    public MaterialBtn(boolean bl) {
        super(Intl.intl("<multiple>"));
        Insets insets = this.getMargin();
        this.setMargin(new Insets(insets.top, 3, insets.bottom, 3));
        this.setPreferredSize(this.getPreferredSize());
        this.setText("");
        this.d_allowNull = bl;
        PyroGuiUtil.initButton((AbstractButton)this, (Material)null);
        this.d_helper = new ObservableProxy(this);
        this.d_modified = false;
        this.d_material = new WeakReference<Object>(null);
        this.d_multiple = false;
        this.addActionListener(this);
    }

    @Override
    public void addObserver(IObserver iObserver, boolean bl) {
        this.d_helper.addObserver(iObserver, bl);
    }

    @Override
    public void deleteObserver(IObserver iObserver) {
        this.d_helper.deleteObserver(iObserver);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        if (this.d_modified == bl) {
            return;
        }
        this.d_modified = bl;
        if (this.d_modified) {
            this.d_helper.setChanged(true);
        }
    }

    public Material getMaterial() {
        return (Material)this.d_material.get();
    }

    public void setMaterial(Material material) {
        this.set(material, false);
    }

    public boolean isMultiple() {
        return this.d_multiple;
    }

    public void setMultiple() {
        this.set(null, true);
    }

    private void set(Material material, boolean bl) {
        if (!this.isDifferent(material, bl)) {
            return;
        }
        this.d_material = new WeakReference<Material>(material);
        this.d_multiple = bl;
        this.updateInfo();
        this.setModified(false);
        this.repaint();
    }

    private boolean isDifferent(Material material, boolean bl) {
        if (bl) {
            return !this.d_multiple;
        }
        return this.d_multiple || this.getMaterial() != material;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Material material;
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        Material material2 = (Material)this.d_material.get();
        MaterialDlg materialDlg = new MaterialDlg(PyroSim.getApp().getActiveFrame(), Intl.intl("Pick an Appearance"), pyroMod.getAppearances(), material2, this.d_allowNull);
        if (materialDlg.doModal() == 1 && this.isDifferent(material = materialDlg.getSelectedEntry(), false)) {
            this.setMaterial(material);
            this.setModified(true);
        }
    }

    protected void updateInfo() {
        if (this.isMultiple()) {
            this.setText(Intl.intl("<multiple>"));
            this.setToolTipText(null);
        } else {
            this.setText("");
            Material material = (Material)this.d_material.get();
            PyroGuiUtil.initButton((AbstractButton)this, material);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.d_multiple) {
            return;
        }
        if (graphics == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = Math.min(insets.left, insets.bottom);
        graphics2.setClip(n, n, dimension.width - n * 2, dimension.height - n * 2);
        PyroGuiUtil.paintComponent((Component)this, graphics2, this.getMaterial());
        graphics2.dispose();
    }
}

