/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import pyrosim.Accelerators;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ChangeOrderTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.SetActiveViewTask;
import pyrosim.domain.tasks.ViewPropTask;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.domain.view.ViewMgr;
import pyrosim.gui.actions.Actions;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ViewActions {
    private static Task taskNewView(PyroSim pyroSim, ViewList viewList, SectionBox sectionBox, boolean bl, boolean bl2) {
        PyroMod pyroMod = pyroSim.getMediator();
        View view = new View(pyroMod.getNames(View.class).generateName());
        PyroSim.getApp().getModelView().taskSaveViewState(pyroMod, Arrays.asList(view)).run();
        if (sectionBox != null) {
            view.set(View.PROP_SECTION_BOX, (SectionBox)sectionBox.clone());
        }
        CompositeTask compositeTask = bl ? new SelectTask(pyroMod, view) : new CompositeTask<PyroMod>(pyroMod);
        compositeTask.addTask(new AddTask((IPyroObject)viewList, (IPyroObject[])new View[]{view}));
        if (bl2) {
            compositeTask.addTask(Actions.SET_ACTIVE_VIEW_ACTION.setActiveView(pyroMod, view));
        }
        return compositeTask;
    }

    private static AABox getSectionBoxBounds(PyroSim pyroSim) {
        return ViewActions.finalizeSectionBounds(pyroSim.getModelView().getClipManager().getUnclippedBounds());
    }

    private static AABox getSelectionSectionBoxBounds(PyroSim pyroSim) {
        Collection<IPyroGeomSrc> collection = pyroSim.getMediator().getSelectionModel().flatten(IPyroGeomSrc.class);
        return ViewActions.getSectionBoxBounds(pyroSim, collection);
    }

    private static AABox getSectionBoxBounds(PyroSim pyroSim, Collection<? extends IPyroGeomSrc> collection) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>(collection.size());
        arrayList.addAll(theUtil.filter(pyroSim.getModelView().getDisplayManager().getDisplayObjs(collection), Object3D.class));
        BoundsCalculator boundsCalculator = new BoundsCalculator();
        boundsCalculator.add(theUtil.toArray(arrayList, Object3D.class));
        return ViewActions.finalizeSectionBounds(boundsCalculator.getBounds());
    }

    private static AABox finalizeSectionBounds(AABox aABox) {
        aABox = aABox.ensureValidSize(1.0, 1.0);
        aABox = aABox.scale(1.1);
        return aABox;
    }

    private static Task taskAddSectionBox(PyroSim pyroSim, PyroMod pyroMod, List<View> list, boolean bl) {
        AABox aABox = ViewActions.getSectionBoxBounds(pyroSim);
        AABoxGeom aABoxGeom = new AABoxGeom(aABox);
        ArrayList<SectionBox> arrayList = new ArrayList<SectionBox>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new SectionBox(aABoxGeom));
        }
        return ViewActions.taskAddSectionBox(pyroSim, pyroMod, list, arrayList, bl);
    }

    private static Task taskAddSectionBox(PyroSim pyroSim, PyroMod pyroMod, List<View> list, List<SectionBox> list2, boolean bl) {
        BiFunction<View, Integer, SectionBox> biFunction = (view, n) -> (SectionBox)list2.get((int)n);
        ViewPropTask<SectionBox> viewPropTask = ViewPropTask.set(list, View.PROP_SECTION_BOX, biFunction);
        if (bl) {
            SelectTask selectTask = new SelectTask(pyroMod, list2);
            selectTask.addTask(viewPropTask);
            return selectTask;
        }
        return viewPropTask;
    }

    public static class AddViewAction
    extends guiAction {
        private static final long serialVersionUID = 5701921527395540689L;
        private final boolean d_contextMenu;

        public AddViewAction(boolean bl) {
            super(Intl.intl("New View"));
            this.putValue("ShortDescription", Intl.intl("Adds a new view to the model."));
            this.d_contextMenu = bl;
            if (!this.d_contextMenu) {
                this.putValue("AcceleratorKey", Accelerators.NEW_VIEW);
            }
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (this.d_contextMenu && bl) {
                PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
                IFilteredCollection<ViewList> iFilteredCollection = pyroSimSelectionModel.getSelected(ViewList.class);
                this.setEnabled(!iFilteredCollection.isEmpty() && iFilteredCollection.isExclusive());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            ViewList viewList = !this.d_contextMenu ? pyroMod.getViews() : (ViewList)pyroMod.getSelectionModel().getSelected(ViewList.class).iterator().next();
            SectionBox sectionBox = pyroMod.getViews().getActiveView().get(View.PROP_SECTION_BOX);
            Task task = ViewActions.taskNewView(PyroSim.getApp(), viewList, sectionBox, true, true);
            pyroMod.getTaskManager().exec(task, Intl.intl("New View"));
        }
    }

    static class SetActiveViewAction
    extends guiAction {
        private static final long serialVersionUID = -2715114454323192460L;

        public SetActiveViewAction() {
            super(Intl.intl("Set Active"));
            this.putValue("ShortDescription", Intl.intl("Sets as the active view"));
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl || events.getEvents(ViewMgr.class, new Class[0]).containsChange(ViewMgr.EVT_ACTIVE_VIEW)) {
                this.setEnabled(this.getEnabled(pyroMod));
            }
        }

        private boolean getEnabled(PyroMod pyroMod) {
            IFilteredCollection<View> iFilteredCollection = pyroMod.getSelectionModel().getSelected(View.class);
            if (iFilteredCollection.isExclusive() && iFilteredCollection.size() == 1 && iFilteredCollection.iterator().next() != pyroMod.getViews().getActiveView()) {
                return true;
            }
            IFilteredCollection<CameraState> iFilteredCollection2 = pyroMod.getSelectionModel().getSelected(CameraState.class);
            return iFilteredCollection2.isExclusive() && iFilteredCollection2.size() == 1 && ((CameraState)iFilteredCollection2.iterator().next()).getParent() != pyroMod.getViews().getActiveView();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IFilteredCollection<CameraState> iFilteredCollection;
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            IPyroObject iPyroObject = null;
            IFilteredCollection<View> iFilteredCollection2 = pyroMod.getSelectionModel().getSelected(View.class);
            if (!iFilteredCollection2.isEmpty()) {
                iPyroObject = (IPyroObject)iFilteredCollection2.iterator().next();
            } else {
                iFilteredCollection = pyroMod.getSelectionModel().getSelected(CameraState.class);
                if (!iFilteredCollection.isEmpty()) {
                    iPyroObject = ((CameraState)iFilteredCollection.iterator().next()).getParent();
                }
            }
            if (!(iPyroObject instanceof View)) {
                return;
            }
            iFilteredCollection = (View)iPyroObject;
            Task task = this.setActiveView(pyroMod, (View)((Object)iFilteredCollection));
            int n = 16;
            pyroMod.getTaskManager().exec(task, Intl.intl("Set Active View"), n);
        }

        public Task setActiveView(PyroMod pyroMod, View view) {
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            compositeTask.addTask(new SetActiveViewTask(pyroMod, view));
            return compositeTask;
        }
    }

    private static class SetSectionBoxGeomTask
    extends AUndoableTask {
        private final List<SectionBox> d_boxes;
        private List<IGeom> d_geom;

        public SetSectionBoxGeomTask(List<SectionBox> list, List<IGeom> list2) {
            this.d_boxes = list;
            this.d_geom = list2;
        }

        @Override
        public void run() {
            this.setGeom();
        }

        @Override
        public void undo() {
            this.setGeom();
        }

        private void setGeom() {
            ((PyroMod)this.d_boxes.get(0).getDomain()).pauseUpdates();
            ArrayList<IGeom> arrayList = new ArrayList<IGeom>(this.d_boxes.size());
            for (int i = 0; i < this.d_boxes.size(); ++i) {
                SectionBox sectionBox = this.d_boxes.get(i);
                arrayList.add((IGeom)sectionBox.get());
                sectionBox.set(this.d_geom.get(i));
            }
            this.d_geom = arrayList;
            ((PyroMod)this.d_boxes.get(0).getDomain()).resumeUpdates();
        }
    }

    public static class DuplicateView
    extends guiAction {
        private static final long serialVersionUID = 4400422772447713039L;

        public DuplicateView() {
            super("");
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl) {
                Pair<String, String> pair = this.getEnabledText(pyroMod);
                if (pair != null) {
                    this.setName((String)pair.v1);
                    this.putValue("ShortDescription", pair.v2);
                }
                this.setEnabled(pair != null);
            }
        }

        private Pair<String, String> getEnabledText(PyroMod pyroMod) {
            Collection<View> collection = pyroMod.getSelectionModel().flatten(View.class);
            if (!collection.isEmpty()) {
                if (collection.size() == 1) {
                    return new Pair<String, String>(Intl.intl("Duplicate View"), Intl.intl("Duplicates the selected view."));
                }
                return new Pair<String, String>(Intl.intl("Duplicate Views"), Intl.intl("Duplicates the selected views."));
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            LinkedIdentityHashSet<View> linkedIdentityHashSet = new LinkedIdentityHashSet<View>(pyroMod.getSelectionModel().flatten(View.class));
            LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
            for (View object2 : linkedIdentityHashSet) {
                linkedIdentityHashSet2.add((ViewList)object2.getParent());
            }
            ArrayList arrayList = new ArrayList(linkedIdentityHashSet.size());
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            for (ViewList viewList : linkedIdentityHashSet2) {
                ArrayList<View> arrayList2 = new ArrayList<View>();
                ArrayList<IPyroObject> arrayList3 = new ArrayList<IPyroObject>(viewList.getChildren().size());
                for (IPyroObject iPyroObject : viewList.getMembers()) {
                    if (!linkedIdentityHashSet.contains(iPyroObject)) {
                        arrayList3.add(iPyroObject);
                        continue;
                    }
                    if (!(iPyroObject instanceof View)) continue;
                    View view = (View)iPyroObject;
                    View view2 = view.clone();
                    arrayList2.add(view2);
                    arrayList3.add(iPyroObject);
                    arrayList3.add(view2);
                    arrayList.add(view2);
                }
                compositeTask.addTask(new AddAutoRenameTask<View>((Composite<View>)viewList, (Collection<View>)arrayList2));
                compositeTask.addTask(new ChangeOrderTask(viewList, collection -> arrayList3));
            }
            compositeTask.addTask(new SelectTask(pyroMod, arrayList));
            pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Duplicate View"));
        }
    }

    public static class CreationSection
    extends guiAction {
        private static final long serialVersionUID = 64806327984810562L;
        private Object d_prevSel = null;

        public CreationSection() {
            super("");
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl || events.getEvents(View.class, new Class[0]).containsChange(View.PROP_SECTION_BOX) || events.getEvents(SectionBox.class, new Class[0]).hasAddedObjs() || events.getEvents(SectionBox.class, new Class[0]).hasRemovedObjs()) {
                Pair<String, String> pair = this.getEnabledText(pyroMod);
                if (pair != null) {
                    this.setName((String)pair.v1);
                    this.putValue("ShortDescription", pair.v2);
                }
                this.setEnabled(pair != null);
            }
        }

        private Pair<String, String> getEnabledText(PyroMod pyroMod) {
            if (!pyroMod.getSelectionModel().flatten(IPyroGeomSrc.class).isEmpty()) {
                String string = pyroMod.getViews().getActiveView().get(View.PROP_SECTION_BOX) != null ? Intl.intl("Create Section...") : Intl.intl("Create Section");
                String string2 = Intl.intl("Creates a section box surrounding the selected objects.");
                return new Pair<String, String>(string, string2);
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            int n = 0;
            View view = pyroMod.getViews().getActiveView();
            if (view.get(View.PROP_SECTION_BOX) != null) {
                object5 = Intl.intl("The active view already has a section box. How would\nyou like to proceed?");
                object4 = Intl.intl("Create a new view with the section box.");
                object3 = Intl.intl("Modify the section box in the active view.");
                object2 = this.d_prevSel != null ? this.d_prevSel : object3;
                object = JOptionPane.showInputDialog(pyroSim.getActiveFrame(), object5, Intl.intl("Section Box Exists"), 3, null, new Object[]{object3, object4}, object2);
                if (object == null) {
                    return;
                }
                this.d_prevSel = object;
                n = ((String)object4).equals(object) ? 1 : 2;
            }
            object5 = pyroMod.getSelectionModel().flatten(IPyroGeomSrc.class);
            object4 = ViewActions.getSectionBoxBounds(pyroSim, (Collection)object5);
            object3 = new AABoxGeom((AABox)object4);
            switch (n) {
                case 0: {
                    object2 = ViewActions.taskAddSectionBox(pyroSim, pyroMod, Arrays.asList(view), Arrays.asList(new SectionBox((IGeom)object3)), false);
                    break;
                }
                case 1: {
                    object = (ViewList)pyroMod.getViews().getActiveView().getParent();
                    object2 = ViewActions.taskNewView(pyroSim, (ViewList)object, new SectionBox((IGeom)object3), false, true);
                    break;
                }
                default: {
                    object2 = new SetSectionBoxGeomTask(Arrays.asList(view.get(View.PROP_SECTION_BOX)), Arrays.asList(object3));
                }
            }
            pyroMod.getTaskManager().exec((Task)object2, Intl.intl("Create Section"));
        }
    }

    public static class ResetSectionBox
    extends guiAction {
        private static final long serialVersionUID = 4332802972926192290L;
        private final boolean d_context;

        public ResetSectionBox(boolean bl) {
            super(Intl.intl("Reset Section Box"));
            this.d_context = bl;
            if (!this.d_context) {
                this.putValue("AcceleratorKey", Accelerators.RESET_SECTION_BOX);
            }
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl || events.getEvents(View.class, new Class[0]).containsChange(View.PROP_SECTION_BOX) || events.getEvents(SectionBox.class, new Class[0]).hasAddedObjs() || events.getEvents(SectionBox.class, new Class[0]).hasRemovedObjs()) {
                String string = this.getEnabledText(pyroMod);
                this.putValue("ShortDescription", string);
                this.setEnabled(string != null);
            }
        }

        private String getEnabledText(PyroMod pyroMod) {
            if (this.d_context) {
                if (!pyroMod.getSelectionModel().flatten(SectionBox.class).isEmpty()) {
                    return Intl.intl("Resets the selected section box(es) to the visible objects.");
                }
            } else if (pyroMod.getViews().getActiveView().get(View.PROP_SECTION_BOX) != null) {
                return Intl.intl("Reset the active view's section box to the visible objects.");
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            List<SectionBox> list = this.d_context ? new ArrayList<SectionBox>(pyroMod.getSelectionModel().flatten(SectionBox.class)) : Arrays.asList(pyroMod.getViews().getActiveView().get(View.PROP_SECTION_BOX));
            this.run(pyroSim, pyroMod, list);
        }

        private void run(PyroSim pyroSim, PyroMod pyroMod, List<SectionBox> list) {
            AABox aABox = ViewActions.getSectionBoxBounds(pyroSim);
            AABoxGeom aABoxGeom = new AABoxGeom(aABox);
            ArrayList<IGeom> arrayList = new ArrayList<IGeom>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(aABoxGeom);
            }
            SetSectionBoxGeomTask setSectionBoxGeomTask = new SetSectionBoxGeomTask(list, arrayList);
            pyroMod.getTaskManager().exec(setSectionBoxGeomTask, Intl.intl("Reset Section Box"));
        }
    }

    public static class AddSectionBox
    extends guiAction {
        private static final long serialVersionUID = 735067923511468190L;
        private final boolean d_context;

        public AddSectionBox(boolean bl) {
            super(Intl.intl("Add Section Box"));
            this.d_context = bl;
            if (!this.d_context) {
                this.putValue("AcceleratorKey", Accelerators.NEW_SECTION_BOX);
            }
        }

        private static Predicate<View> getViewFilter() {
            return view -> view.get(View.PROP_SECTION_BOX) == null;
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl || events.getEvents(View.class, new Class[0]).containsChange(View.PROP_SECTION_BOX)) {
                String string = this.getEnabledText(pyroMod);
                if (string != null) {
                    this.putValue("ShortDescription", string);
                }
                this.setEnabled(string != null);
            }
        }

        private String getEnabledText(PyroMod pyroMod) {
            if (this.d_context) {
                Collection<View> collection;
                if (pyroMod.getSelectionModel().getSelected(IPyroObject.class, View.class, ViewList.class).isExclusive() && !(collection = pyroMod.getSelectionModel().flatten(View.class, AddSectionBox.getViewFilter())).isEmpty()) {
                    String string = collection.size() == 1 ? Intl.intl("Add a section box to the selected view.") : Intl.intl("Add a section box to the selected views.");
                    return string;
                }
            } else if (AddSectionBox.getViewFilter().test(pyroMod.getViews().getActiveView())) {
                return Intl.intl("Add a section box to the active view.");
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            List<View> list = this.d_context ? new ArrayList<View>(pyroMod.getSelectionModel().flatten(View.class, AddSectionBox.getViewFilter())) : Arrays.asList(pyroMod.getViews().getActiveView());
            this.run(pyroSim, pyroMod, list);
        }

        private void run(PyroSim pyroSim, PyroMod pyroMod, List<View> list) {
            Task task = ViewActions.taskAddSectionBox(pyroSim, pyroMod, list, true);
            int n = 0;
            if (list.size() == 1 && list.contains(pyroMod.getViews().getActiveView())) {
                n |= 0x20;
            }
            pyroMod.getTaskManager().exec(task, Intl.intl("Add Section Box"), n);
        }
    }

    public static class ShowViewpoint
    extends guiAction {
        private static final long serialVersionUID = -8747821806111685304L;
        private final boolean d_context;

        public ShowViewpoint(boolean bl) {
            super(bl ? Intl.intl("Reset to Selected Viewpoint") : Intl.intl("Reset to Viewpoint"));
            this.d_context = bl;
            String string = this.d_context ? Intl.intl("Resets the scene camera to the selected viewpoint.") : Intl.intl("Resets the scene camera to the viewpoint of the active view.");
            this.putValue("ShortDescription", string);
            if (!this.d_context) {
                this.putValue("AcceleratorKey", Accelerators.SHOW_VIEWPOINT);
            }
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            this.setEnabled(this.getEnabled(pyroMod));
        }

        private boolean getEnabled(PyroMod pyroMod) {
            if (this.d_context) {
                IFilteredCollection<View> iFilteredCollection = pyroMod.getSelectionModel().getSelected(View.class);
                if (iFilteredCollection.size() == 1 && iFilteredCollection.isExclusive() && ((View)iFilteredCollection.iterator().next()).get(View.PROP_CAMERA) != null) {
                    return true;
                }
                IFilteredCollection<CameraState> iFilteredCollection2 = pyroMod.getSelectionModel().getSelected(CameraState.class);
                return iFilteredCollection2.size() == 1 && iFilteredCollection2.isExclusive();
            }
            return pyroMod.getViews().getActiveView().get(View.PROP_CAMERA) != null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            View view;
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            if (this.d_context) {
                IFilteredCollection<View> iFilteredCollection = pyroMod.getSelectionModel().getSelected(View.class);
                if (!iFilteredCollection.isEmpty()) {
                    view = (View)iFilteredCollection.iterator().next();
                } else {
                    CameraState cameraState = (CameraState)pyroMod.getSelectionModel().getSelected(CameraState.class).iterator().next();
                    if (!(cameraState.getParent() instanceof View)) {
                        return;
                    }
                    view = (View)cameraState.getParent();
                }
            } else {
                view = pyroMod.getViews().getActiveView();
            }
            this.run(pyroSim, view);
        }

        private void run(PyroSim pyroSim, View view) {
            CameraState cameraState = view.get(View.PROP_CAMERA);
            View.NavTool navTool = view.get(View.PROP_NAV_TOOL);
            pyroSim.setView(cameraState, navTool);
        }
    }

    public static class SaveViewpoint
    extends guiAction {
        private static final long serialVersionUID = 2377655270982195770L;
        private final boolean d_context;

        public SaveViewpoint(boolean bl) {
            super(Intl.intl("Save Viewpoint"));
            this.d_context = bl;
            if (!this.d_context) {
                this.putValue("ShortDescription", Intl.intl("Saves the current viewpoint to the active view."));
                this.putValue("AcceleratorKey", Accelerators.SAVE_VIEWPOINT);
            }
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (this.d_context && bl) {
                Pair<String, String> pair = this.getEnabledText(pyroMod);
                this.setEnabled(pair != null);
                if (pair != null) {
                    this.setName((String)pair.v1);
                    this.putValue("ShortDescription", pair.v2);
                }
            }
        }

        private Pair<String, String> getEnabledText(PyroMod pyroMod) {
            PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
            IFilteredCollection<View> iFilteredCollection = pyroSimSelectionModel.getSelected(View.class);
            if (iFilteredCollection.isExclusive() && iFilteredCollection.size() == 1) {
                return new Pair<String, String>(Intl.intl("Save Viewpoint"), Intl.intl("Saves the current viewpoint to the selected view."));
            }
            IFilteredCollection<CameraState> iFilteredCollection2 = pyroSimSelectionModel.getSelected(CameraState.class);
            if (!iFilteredCollection2.isEmpty()) {
                return new Pair<String, String>(Intl.intl("Save Viewpoint"), Intl.intl("Saves the current viewpoint to the selected viewpoint(s)."));
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<View> list;
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            if (this.d_context) {
                LinkedHashSet<View> linkedHashSet = new LinkedHashSet<View>(pyroMod.getSelectionModel().flatten(View.class));
                for (CameraState cameraState : pyroMod.getSelectionModel().flatten(CameraState.class)) {
                    linkedHashSet.add((View)cameraState.getParent());
                }
                list = new ArrayList<View>(linkedHashSet);
            } else {
                list = Arrays.asList(pyroMod.getViews().getActiveView());
            }
            this.run(pyroMod, list);
        }

        private void run(PyroMod pyroMod, List<View> list) {
            Task task = PyroSim.getApp().getModelView().taskSaveViewState(pyroMod, list);
            pyroMod.getTaskManager().exec(task, Intl.intl("Save Viewpoint"));
        }
    }
}

