/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.Vent;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.io.fds.EnabledFilter;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.units.UnitDouble;

public class VentCollapseValidation
extends ARunFDSValidation {
    @Override
    public Collection<IPyroObject> validateModel(PyroSim pyroSim, PyroMod pyroMod) {
        GeomLocator geomLocator = pyroMod.getGeomLocator();
        HashSet<IPyroObject> hashSet = new HashSet<IPyroObject>();
        Collection<Vent> collection = pyroMod.getObstructions().flatten(Vent.class, new EnabledFilter());
        for (Vent vent : collection) {
            AABoxTest aABoxTest = new AABoxTest(vent.getBounds(), 1.0E-6);
            CollResult collResult = new CollResult(Grid.class, new EnabledFilter());
            geomLocator.find(aABoxTest, collResult, true);
            boolean bl = collResult.coll.size() > 0;
            for (Grid grid : collResult.coll) {
                UnitDouble[] unitDoubleArray = grid.getXLinePositions();
                UnitDouble[] unitDoubleArray2 = grid.getYLinePositions();
                UnitDouble[] unitDoubleArray3 = grid.getZLinePositions();
                AABox aABox = vent.getBounds();
                double d = aABox.getMinX();
                double d2 = aABox.getMaxX();
                double d3 = aABox.getMinY();
                double d4 = aABox.getMaxY();
                double d5 = aABox.getMinZ();
                double d6 = aABox.getMaxZ();
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                switch (vent.getVentGeom().d_plane) {
                    case 0: {
                        d9 = this.getSnapMin(d3, unitDoubleArray2);
                        d10 = this.getSnapMax(d4, unitDoubleArray2);
                        d11 = this.getSnapMin(d5, unitDoubleArray3);
                        d12 = this.getSnapMax(d6, unitDoubleArray3);
                        bl &= d10 - d9 < 1.0E-9 || d12 - d11 < 1.0E-9;
                        break;
                    }
                    case 1: {
                        d7 = this.getSnapMin(d, unitDoubleArray);
                        d8 = this.getSnapMax(d2, unitDoubleArray);
                        d11 = this.getSnapMin(d5, unitDoubleArray3);
                        d12 = this.getSnapMax(d6, unitDoubleArray3);
                        bl &= d8 - d7 < 1.0E-9 || d12 - d11 < 1.0E-9;
                        break;
                    }
                    case 2: {
                        d9 = this.getSnapMin(d3, unitDoubleArray2);
                        d10 = this.getSnapMax(d4, unitDoubleArray2);
                        d7 = this.getSnapMin(d, unitDoubleArray);
                        d8 = this.getSnapMax(d2, unitDoubleArray);
                        bl &= d8 - d7 < 1.0E-9 || d10 - d9 < 1.0E-9;
                    }
                }
            }
            if (!bl) continue;
            hashSet.add(vent);
        }
        return hashSet;
    }

    private double getSnapMin(double d, UnitDouble[] unitDoubleArray) {
        double d2 = unitDoubleArray[0].get(Geometry.LU);
        if (d < unitDoubleArray[0].get(Geometry.LU)) {
            return d2;
        }
        for (int i = 0; i < unitDoubleArray.length - 1; ++i) {
            if (!(d >= unitDoubleArray[i].get(Geometry.LU)) || !(d < unitDoubleArray[i + 1].get(Geometry.LU))) continue;
            if (d < (unitDoubleArray[i + 1].get(Geometry.LU) + unitDoubleArray[i].get(Geometry.LU)) / 2.0) {
                d2 = unitDoubleArray[i].get(Geometry.LU);
                break;
            }
            d2 = unitDoubleArray[i + 1].get(Geometry.LU);
            break;
        }
        return d2;
    }

    private double getSnapMax(double d, UnitDouble[] unitDoubleArray) {
        double d2 = unitDoubleArray[unitDoubleArray.length - 1].get(Geometry.LU);
        if (d >= unitDoubleArray[unitDoubleArray.length - 1].get(Geometry.LU)) {
            return d2;
        }
        for (int i = unitDoubleArray.length - 1; i > 0; --i) {
            if (!(d >= unitDoubleArray[i - 1].get(Geometry.LU)) || !(d < unitDoubleArray[i].get(Geometry.LU))) continue;
            if (d < (unitDoubleArray[i - 1].get(Geometry.LU) + unitDoubleArray[i].get(Geometry.LU)) / 2.0) {
                d2 = unitDoubleArray[i - 1].get(Geometry.LU);
                break;
            }
            d2 = unitDoubleArray[i].get(Geometry.LU);
            break;
        }
        return d2;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window window, int n) {
        String string = String.format(Intl.intl("The model contains %d vents that will be collapsed to a point or\nline in FDS.\n\nClick OK to select the vents that will collapse.\n\nClick Ignore to continue.\n"), n);
        return new ARunFDSValidation.Prompt(window, string);
    }
}

