/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroDataContainer;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.theUtil;

public class TestCopyPaste
extends TestCase {
    private PyroMod d_src;
    private PyroMod d_tempSrc;
    private PyroMod d_sink;

    public TestCopyPaste(String string) {
        super(string);
        new PyroSim();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_sink = new PyroMod();
        this.d_src = new PyroMod();
        this.d_tempSrc = new PyroMod();
    }

    private static Set<IPyroObject> collectObjects(Collection<? extends IPyroObject> collection) {
        DepSnapshot depSnapshot = new DepSnapshot();
        for (IPyroObject iPyroObject : collection) {
            depSnapshot.takeSnapshot(iPyroObject);
        }
        IdentityHashSet<IPyroObject> identityHashSet = new IdentityHashSet<IPyroObject>(depSnapshot.getAllDependedOn());
        identityHashSet.addAll(collection);
        return identityHashSet;
    }

    private <T extends IPyroObject> void checkOverwritePaste(PyroMod pyroMod, PyroMod pyroMod2, Collection<? extends IPyroObject> collection, boolean bl, Map<IPyroObject, Actions.PasteOverwrite> map) {
        PerObjResponseGenerator perObjResponseGenerator = new PerObjResponseGenerator(map);
        Set<IPyroObject> set = TestCopyPaste.collectObjects(collection);
        try {
            Actions.pasteObjects(pyroMod, collection, "", perObjResponseGenerator);
        }
        catch (CancellationException cancellationException) {
            TestCopyPaste.assertFalse((boolean)bl);
            return;
        }
        TestCopyPaste.assertTrue((boolean)bl);
        for (IPyroObject iPyroObject : set) {
            Actions.PasteOverwrite pasteOverwrite;
            boolean bl2 = true;
            if (map != null && (pasteOverwrite = map.get(iPyroObject)) != null && pasteOverwrite == Actions.PasteOverwrite.KEEP_EXISTING) {
                bl2 = false;
            }
            if (bl2) {
                TestCopyPaste.assertSame((Object)TestCopyPaste.getConflict(pyroMod, iPyroObject), (Object)iPyroObject);
                continue;
            }
            TestCopyPaste.assertNotSame((Object)TestCopyPaste.getConflict(pyroMod, iPyroObject), (Object)iPyroObject);
        }
        if (map != null) {
            TestCopyPaste.assertEquals((int)perObjResponseGenerator.getNumOverwriteRequestResponses(), (int)map.size());
        }
    }

    private static <T extends IPyroObject> T getConflict(PyroMod pyroMod, T t) {
        Object object = TVEntryPoints.ep(t).getCategoryRoot(pyroMod, t);
        assert (object != null);
        return (T)((IPyroObject)TVEntryPoints.ep(object).getConflict(pyroMod, object, t));
    }

    private <T extends IPyroObject> void checkRenamePaste(PyroMod pyroMod, PyroMod pyroMod2, Collection<? extends IPyroObject> collection, boolean bl) {
        Set<IPyroObject> set = TestCopyPaste.collectObjects(collection);
        try {
            PerObjResponseGenerator perObjResponseGenerator = new PerObjResponseGenerator(Collections.EMPTY_MAP);
            Actions.pasteObjects(pyroMod, collection, "", perObjResponseGenerator);
        }
        catch (CancellationException cancellationException) {
            TestCopyPaste.assertFalse((boolean)bl);
            return;
        }
        TestCopyPaste.assertTrue((boolean)bl);
        for (IPyroObject iPyroObject : set) {
            TestCopyPaste.assertEquals((Object)TestCopyPaste.getConflict(pyroMod, iPyroObject), (Object)iPyroObject);
        }
    }

    public void test_GridPyroFlavor() {
        this.checkGrid(new SerializeCopyGenerator<Grid>(this.d_src, this.d_sink, true, false));
    }

    public void test_GridFDSFlavor() {
        this.checkGrid(new SerializeCopyGenerator<Grid>(this.d_src, this.d_sink, false, true));
    }

    public void test_GridClone() {
        this.checkGrid(new CloneCopyGenerator<Grid>(this.d_src));
    }

    private void checkGrid(ObjectCopyGenerator<Grid> objectCopyGenerator) {
        SIUS sIUS = new SIUS();
        Grid[] gridArray = new Grid[]{new Grid("Grid #1", new UnitPoint3D(0.0, 0.0, 0.0, sIUS.getLengthUnit()), new UnitPoint3D(1.0, 1.0, 1.0, sIUS.getLengthUnit()), 4, 5, 6), new Grid("Grid #2", new UnitPoint3D(1.0, 1.0, 1.0, sIUS.getLengthUnit()), new UnitPoint3D(2.0, 2.0, 2.0, sIUS.getLengthUnit()), 7, 8, 9)};
        List<Grid> list = Arrays.asList(gridArray);
        this.d_src.getGridManager().addAll(list);
        Collection<IPyroObject> collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkRenamePaste(this.d_sink, this.d_tempSrc, collection, true);
        TestCopyPaste.assertTrue((this.d_sink.getGridManager().get("Grid #1") != null ? 1 : 0) != 0);
        TestCopyPaste.assertTrue((this.d_sink.getGridManager().get("Grid #2") != null ? 1 : 0) != 0);
        this.d_tempSrc = new PyroMod();
        collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkRenamePaste(this.d_sink, this.d_tempSrc, collection, true);
        TestCopyPaste.assertEquals((int)this.d_sink.getGridManager().flatten().size(), (int)4);
    }

    public void test_IsofRecordPyroFlavor() {
        this.checkIsofRecord(new SerializeCopyGenerator<Isosurface>(this.d_src, this.d_sink, true, false));
    }

    public void test_IsofRecordFDSFlavor() {
        this.checkIsofRecord(new SerializeCopyGenerator<Isosurface>(this.d_src, this.d_sink, false, true));
    }

    public void test_IsofRecordClone() {
        this.checkIsofRecord(new CloneCopyGenerator<Isosurface>(this.d_src));
    }

    private void checkIsofRecord(ObjectCopyGenerator<Isosurface> objectCopyGenerator) {
        IdentityHashMap<IPyroObject, Actions.PasteOverwrite> identityHashMap = new IdentityHashMap<IPyroObject, Actions.PasteOverwrite>();
        SIUS sIUS = new SIUS();
        UnitDouble[] unitDoubleArray = new UnitDouble[]{new UnitDouble(1.0, sIUS.getTempUnit()), new UnitDouble(5.0, sIUS.getTempUnit())};
        UnitDouble[] unitDoubleArray2 = new UnitDouble[]{new UnitDouble(2.0, sIUS.getDensityUnit()), new UnitDouble(6.0, sIUS.getDensityUnit())};
        Isosurface[] isosurfaceArray = new Isosurface[]{new Isosurface((IQuantity)Quantity.TEMPERATURE.create(), Arrays.asList(unitDoubleArray)), new Isosurface((IQuantity)Quantity.DENSITY.create(), Arrays.asList(unitDoubleArray2))};
        List<Isosurface> list = Arrays.asList(isosurfaceArray);
        this.d_src.getIsofList().addAll(list);
        Collection<IPyroObject> collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkOverwritePaste(this.d_sink, this.d_tempSrc, collection, true, null);
        this.d_tempSrc = new PyroMod();
        collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        Set<IPyroObject> set = TestCopyPaste.collectObjects(collection);
        TestCopyPaste.assertEquals((int)set.size(), (int)isosurfaceArray.length);
        Iterator<IPyroObject> iterator = set.iterator();
        identityHashMap.put(iterator.next(), Actions.PasteOverwrite.REPLACE_EXISTING);
        identityHashMap.put(iterator.next(), Actions.PasteOverwrite.KEEP_EXISTING);
        this.checkOverwritePaste(this.d_sink, this.d_tempSrc, collection, true, identityHashMap);
    }

    public void test_PartRecordPyroFlavor() {
        this.checkPartRecord(new SerializeCopyGenerator<Particle>(this.d_src, this.d_sink, true, false));
    }

    public void test_PartRecordFDSFlavor() {
        this.checkPartRecord(new SerializeCopyGenerator<Particle>(this.d_src, this.d_sink, false, true));
    }

    public void test_PartRecordClone() {
        this.checkPartRecord(new CloneCopyGenerator<Particle>(this.d_src));
    }

    private void checkPartRecord(ObjectCopyGenerator<Particle> objectCopyGenerator) {
        Particle particle = new Particle("PartRecord #1", Particle.Type.LIQUID, new Output(10), null);
        Particle particle2 = new Particle("PartRecord #2", Particle.Type.SOLID, new Output(10), null);
        Surface surface = new Surface("SurfRecord");
        surface.setSurfDesc(new BurnerSurfDesc());
        ExSpec exSpec = new ExSpec(ExSpecList.PREDEFINED.get("PROPANE"));
        particle.setSpecies(exSpec);
        particle2.setSurface(surface);
        Particle[] particleArray = new Particle[]{particle, particle2};
        List<Particle> list = Arrays.asList(particleArray);
        this.d_src.getPartList().addAll(list);
        this.d_src.getSurfaceMgr().add(surface);
        this.d_src.getExSpecList().add(exSpec);
        Collection<IPyroObject> collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkRenamePaste(this.d_sink, this.d_tempSrc, collection, true);
        TestCopyPaste.assertTrue((this.d_sink.getPartList().get("PartRecord #1") != null ? 1 : 0) != 0);
        TestCopyPaste.assertTrue((this.d_sink.getPartList().get("PartRecord #2") != null ? 1 : 0) != 0);
        this.d_tempSrc = new PyroMod();
        collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkRenamePaste(this.d_sink, this.d_tempSrc, collection, true);
        TestCopyPaste.assertEquals((int)4, (int)this.d_sink.getPartList().flatten().size());
    }

    public void test_ReactionPyroFlavor() {
        this.checkReaction(new SerializeCopyGenerator<Reaction>(this.d_src, this.d_sink, true, false));
    }

    public void test_ReactionFDSFlavor() {
        this.checkReaction(new SerializeCopyGenerator<Reaction>(this.d_src, this.d_sink, false, true));
    }

    public void test_ReactionClone() {
        this.checkReaction(new CloneCopyGenerator<Reaction>(this.d_src));
    }

    private void checkReaction(ObjectCopyGenerator<Reaction> objectCopyGenerator) {
        Reaction[] reactionArray = new Reaction[]{new Reaction("Reaction #1", false, Reaction.ReacType.SIMPLE), new Reaction("Reaction #2", false, Reaction.ReacType.SIMPLE)};
        reactionArray[0].setYields(0.1, 0.2);
        reactionArray[0].setSootHFraction(0.4);
        reactionArray[1].setSuppression(false);
        reactionArray[1].setFuelComp(1.0, 2.0, 3.0, 4.0);
        List<Reaction> list = Arrays.asList(reactionArray);
        this.d_src.getReactions().addAll(list);
        Collection<IPyroObject> collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkRenamePaste(this.d_sink, this.d_tempSrc, collection, true);
        TestCopyPaste.assertTrue((this.d_sink.getReactions().get("Reaction #1") != null ? 1 : 0) != 0);
        TestCopyPaste.assertTrue((this.d_sink.getReactions().get("Reaction #2") != null ? 1 : 0) != 0);
        this.d_tempSrc = new PyroMod();
        collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkRenamePaste(this.d_sink, this.d_tempSrc, collection, true);
        TestCopyPaste.assertEquals((int)4, (int)this.d_sink.getReactions().flatten().size());
    }

    public void test_SlcfRecordPyroFlavor() {
        this.checkSlcfRecord(new SerializeCopyGenerator<Slice>(this.d_src, this.d_sink, true, false));
    }

    public void test_SlcfRecordFDSFlavor() {
        this.checkSlcfRecord(new SerializeCopyGenerator<Slice>(this.d_src, this.d_sink, false, true));
    }

    public void test_SlcfRecordClone() {
        this.checkSlcfRecord(new CloneCopyGenerator<Slice>(this.d_src));
    }

    private void checkSlcfRecord(ObjectCopyGenerator<Slice> objectCopyGenerator) {
        IdentityHashMap<IPyroObject, Actions.PasteOverwrite> identityHashMap = new IdentityHashMap<IPyroObject, Actions.PasteOverwrite>();
        SIUS sIUS = new SIUS();
        Slice[] sliceArray = new Slice[]{new PlanarSlice(0, new UnitDouble(3.4, sIUS.getLengthUnit()), Quantity.ABSORPTION_COEFFICIENT.create(), true, true), new PlanarSlice(1, new UnitDouble(3.6, sIUS.getLengthUnit()), Quantity.CONDUCTIVITY.create(), true, true)};
        List<Slice> list = Arrays.asList(sliceArray);
        this.d_src.getSlcfList().addAll(list);
        Collection<IPyroObject> collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        this.checkOverwritePaste(this.d_sink, this.d_tempSrc, collection, true, null);
        this.d_tempSrc = new PyroMod();
        collection = objectCopyGenerator.getObjectCopies(list, this.d_tempSrc);
        Set<IPyroObject> set = TestCopyPaste.collectObjects(collection);
        TestCopyPaste.assertEquals((int)set.size(), (int)sliceArray.length);
        Iterator<IPyroObject> iterator = set.iterator();
        identityHashMap.put(iterator.next(), Actions.PasteOverwrite.REPLACE_EXISTING);
        identityHashMap.put(iterator.next(), Actions.PasteOverwrite.KEEP_EXISTING);
        this.checkOverwritePaste(this.d_sink, this.d_tempSrc, collection, true, identityHashMap);
    }

    private static class CloneCopyGenerator<T extends IPyroObject>
    implements ObjectCopyGenerator<T> {
        final PyroMod d_src;

        public CloneCopyGenerator(PyroMod pyroMod) {
            this.d_src = pyroMod;
        }

        @Override
        public Collection<? extends IPyroObject> getObjectCopies(Collection<T> collection, PyroMod pyroMod) {
            IdentityHashSet<T> identityHashSet = new IdentityHashSet<T>(collection);
            try {
                return theUtil.serialCopy(identityHashSet);
            }
            catch (IOException iOException) {
                return Collections.EMPTY_LIST;
            }
        }
    }

    private static class SerializeCopyGenerator<T extends IPyroObject>
    implements ObjectCopyGenerator<T> {
        final PyroMod d_src;
        final PyroMod d_dest;
        final Set<DataFlavor> d_flavors;

        public SerializeCopyGenerator(PyroMod pyroMod, PyroMod pyroMod2, boolean bl, boolean bl2) {
            this.d_src = pyroMod;
            this.d_dest = pyroMod2;
            this.d_flavors = new IdentityHashSet<DataFlavor>(2);
            if (bl) {
                this.d_flavors.add(Actions.PYRO_DATA_FLAVOR);
            }
            if (bl2) {
                this.d_flavors.add(Actions.FDS_DATA_FLAVOR);
            }
        }

        @Override
        public Collection<? extends IPyroObject> getObjectCopies(Collection<T> collection, PyroMod pyroMod) {
            Object object;
            IdentityHashSet<T> identityHashSet = new IdentityHashSet<T>(collection);
            try {
                object = Actions.copyObjects(this.d_src, identityHashSet, false, theUtil.toArray(this.d_flavors, DataFlavor.class));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
            }
            catch (Throwable throwable) {
                Assert.assertTrue((boolean)false);
            }
            object = Actions.getClipboardObjects(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(PyroSim.getApp()), this.d_dest);
            return ((PyroDataContainer)object).getObjects();
        }
    }

    private static interface ObjectCopyGenerator<T extends IPyroObject> {
        public Collection<? extends IPyroObject> getObjectCopies(Collection<T> var1, PyroMod var2);
    }

    private static class PerObjResponseGenerator
    extends Actions.APasteCallback {
        private final Map<IPyroObject, Actions.PasteOverwrite> d_responses;
        private final Set<IPyroObject> d_objsPromptedForOverwrite;
        private int d_numOverwriteResponseRequests;

        public PerObjResponseGenerator(Map<IPyroObject, Actions.PasteOverwrite> map) {
            super(new Object[0]);
            this.d_responses = map;
            this.d_objsPromptedForOverwrite = map != null ? new IdentityHashSet(map.size()) : null;
            this.d_numOverwriteResponseRequests = 0;
        }

        @Override
        public Actions.PasteOverwrite getReplaceModelObject(IPyroObject iPyroObject, IPyroObject iPyroObject2) throws CancellationException {
            Assert.assertNotNull(this.d_responses);
            Actions.PasteOverwrite pasteOverwrite = this.d_responses.get(iPyroObject2);
            Assert.assertNotNull((Object)((Object)pasteOverwrite));
            this.d_objsPromptedForOverwrite.add(iPyroObject2);
            ++this.d_numOverwriteResponseRequests;
            return pasteOverwrite;
        }

        public Set<IPyroObject> getObjsPromptedForOverwrite() {
            return this.d_objsPromptedForOverwrite;
        }

        public int getNumOverwriteRequestResponses() {
            return this.d_numOverwriteResponseRequests;
        }

        @Override
        public List<Reaction> getActiveReactions(Collection<Reaction> collection, Map<Reaction, Actions.PasteCommand> map, List<Reaction> list) throws CancellationException {
            return list;
        }
    }
}

