/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.Floor;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialCache;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.geom.Geometry;
import pyrosim.gui.CancelledException;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.io.ImportFDSFile;
import pyrosim.io.STLReader;
import pyrosim.io.fds.INIReader;
import pyrosim.io.fds.SMVReader;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NewObjCache;
import thunderheadeng.cad.in.CadImportUI;
import thunderheadeng.cad.in.CadImporter;
import thunderheadeng.cad.in.IGeomImportSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.gui.wizard.WizardDlg;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsUtil;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.FileWarning;
import thunderheadeng.util.Global;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ImportAction
extends guiAction {
    private static final long serialVersionUID = 2465596277560605809L;
    private static final IPropertySet.Prop<MaterialCache> PROP_MAT_CACHE = new IPropertySet.Prop<Object>("ImportAction.MAT_CACHE", null);
    private static final IPropertySet.Prop<NewObjCache<SurfKey, Surface>> PROP_SURF_CACHE = new IPropertySet.Prop<Object>("ImportAction.SURF_CACHE", null);

    public ImportAction() {
        super(Intl.intl("Import FDS/CAD File..."), PyroGuiUtil.loadTeciIcon("Import16.gif"));
        this.putValue("ShortDescription", this.getName());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PyroSim pyroSim = PyroSim.getApp();
        JFrame jFrame = pyroSim.getMainFrame();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("fds", Intl.intl("FDS 5/6 Input Files"), "data", Intl.intl("FDS 4 Input Files"), "txt", Intl.intl("FDS 4 Input Files")));
        String[] stringArray = CadImporter.getSupportedFileFormats();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 2 == 0) {
                hashSet.add(stringArray[i].toLowerCase());
            }
            arrayList.add(stringArray[i]);
        }
        arrayList.addAll(Arrays.asList("stl", Intl.intl("STereoLithography"), "ini", Intl.intl("Smokeview INI Files")));
        File file = PyroSim.getFilenames().getOpenFile((Component)jFrame, theUtil.toArray(arrayList, String.class));
        if (file == null) {
            return;
        }
        pyroSim.savePreferences();
        String string = FilenameManager.getExtension(file.getAbsolutePath());
        if (string.equalsIgnoreCase("fds") || string.equalsIgnoreCase("data") || string.equalsIgnoreCase("txt")) {
            if (!pyroSim.promptSaveIfModified(true)) {
                return;
            }
            PyroMod pyroMod = pyroSim.getMediator();
            ImportFDSFile importFDSFile = new ImportFDSFile(pyroSim, pyroMod, file.getAbsolutePath());
            pyroMod.getTaskManager().exec((Task)importFDSFile, Intl.intl("Import FDS File"), 2);
        } else {
            Runnable runnable = () -> {
                block16: {
                    pyroSim.beginWaitCursor();
                    try {
                        if (string.equalsIgnoreCase("stl")) {
                            this.importSTL(pyroSim, file);
                            break block16;
                        }
                        if (string.equalsIgnoreCase("ini")) {
                            this.importINI(pyroSim, file);
                            break block16;
                        }
                        if (hashSet.contains(string.toLowerCase())) {
                            this.importCad(pyroSim, pyroSim.getMediator(), file);
                            break block16;
                        }
                        String string2 = String.format(Intl.intl("%s files are not supported."), string);
                        throw new IOException(string2);
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (CancelledException cancelledException) {
                    }
                    catch (ParseException parseException) {
                        PyroGuiUtil.showError(pyroSim, Intl.intl("File Error"), String.format(Intl.intl("Error on line %d."), parseException.getErrorOffset()), (Throwable)parseException);
                    }
                    catch (IOException iOException) {
                        PyroGuiUtil.showError(pyroSim, Intl.intl("File Error"), Intl.intl("Could not import file."), (Throwable)iOException);
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                throw new RuntimeException(throwable);
                            }
                        });
                    }
                    finally {
                        pyroSim.endWaitCursor();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setPriority(1);
            thread.start();
        }
    }

    private static AWizardCard<IPropertySet> getImportCard(PyroMod pyroMod, File file, IPropertySet iPropertySet) {
        MaterialCache materialCache = new MaterialCache(pyroMod.getAppearances().flatten());
        NewObjCache<SurfKey, Surface> newObjCache = new NewObjCache<SurfKey, Surface>(pyroMod.getSurfaceMgr().flatten(), surface -> new SurfKey((Surface)surface));
        iPropertySet.setIfNotDefault(PROP_SURF_CACHE, newObjCache);
        iPropertySet.setIfNotDefault(PROP_MAT_CACHE, materialCache);
        iPropertySet.setIfNotDefault(IGeomImportSession.DST_LENGTH_UNIT, Geometry.LU);
        iPropertySet.setIfNotDefault(CadImportUI.LENGTH_UNIT_SRC, UnitSystem.getSource(0));
        iPropertySet.setIfNotDefault(CadImportUI.MAT_FACTORY, (string, iMatAttrs) -> {
            String string2 = string.trim();
            Material material = new Material(string2, (IMatAttrs)iMatAttrs);
            material = materialCache.add(material);
            String string3 = string2;
            Surface surface = new Surface(string3, material.getAttributes().getDiffuseColorWithOpacity(), material);
            return iPropertySet.get(PROP_SURF_CACHE).add(surface);
        });
        Floor floor = PyroSim.getApp().get3DView().getCurrentFloor();
        if (floor != null) {
            iPropertySet.set(CadImportUI.DEF_Z_LOC, floor.getElevation());
        }
        iPropertySet.set(CadImportUI.FILE, file);
        return CadImportUI.getFirstWizardCard(iPropertySet);
    }

    private static void cleanupCad(IPropertySet iPropertySet) {
        iPropertySet.remove(PROP_SURF_CACHE);
        iPropertySet.remove(PROP_MAT_CACHE);
        iPropertySet.remove(IGeomImportSession.DST_LENGTH_UNIT);
        iPropertySet.remove(CadImportUI.FILE);
        iPropertySet.remove(CadImportUI.LENGTH_UNIT_SRC);
        iPropertySet.remove(CadImportUI.DEF_Z_LOC);
        iPropertySet.remove(CadImportUI.MAT_FACTORY);
        CadImportUI.cleanup(iPropertySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCad(PyroSim pyroSim, final PyroMod pyroMod, File file) throws IOException, CancelledException {
        final Semaphore semaphore = new Semaphore(0);
        PropertySet propertySet = new PropertySet();
        AWizardCard<IPropertySet> aWizardCard = ImportAction.getImportCard(pyroMod, file, propertySet);
        try {
            WizardDlg<IPropertySet> wizardDlg = new WizardDlg<IPropertySet>((Window)pyroSim.getActiveFrame(), Intl.intl("Import"), String.format(Intl.intl("Import %s"), file.getName()), aWizardCard);
            wizardDlg.init(propertySet);
            if (wizardDlg.doModal() != 1) {
                return;
            }
            ModelComposite modelComposite = this.convert(pyroMod, file, propertySet, CadImportUI.finalizeResult(propertySet));
            LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
            for (IObstruction object2 : ((APyroObject)modelComposite).flatten(IObstruction.class)) {
                Surface[] surfaceArray = object2.getSurfaces();
                linkedIdentityHashSet.addAll(Arrays.asList(surfaceArray));
            }
            linkedIdentityHashSet.retainAll(propertySet.get(PROP_SURF_CACHE).getAddedObjects());
            LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
            for (Surface surface : linkedIdentityHashSet) {
                Material material = surface.getAppearance();
                if (material == null) continue;
                linkedIdentityHashSet2.add(material);
            }
            for (GenericGeomSrc genericGeomSrc : ((APyroObject)modelComposite).flatten(GenericGeomSrc.class)) {
                PropsUtil.getReferencedMaterials(genericGeomSrc.getGeom(), genericGeomSrc.getDisplayProps(), linkedIdentityHashSet2);
            }
            linkedIdentityHashSet2.retainAll(propertySet.get(PROP_MAT_CACHE).getAddedMaterials());
            final CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            compositeTask.addTask(new AddAutoRenameTask<Material>((Composite<Material>)pyroMod.getAppearances(), (Collection<Material>)linkedIdentityHashSet2));
            compositeTask.addTask(new AddAutoRenameTask<Surface>((Composite<Surface>)pyroMod.getSurfaceMgr(), (Collection<Surface>)linkedIdentityHashSet));
            compositeTask.addTask(new AddTask((IPyroObject)pyroMod.getObstructions(), new IPyroObject[]{modelComposite}));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pyroMod.getTaskManager().exec((Task)compositeTask, Intl.intl("Import CAD"), 2);
                    semaphore.release();
                }
            });
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            ImportAction.cleanupCad(propertySet);
        }
    }

    private ModelComposite convert(PyroMod pyroMod, File file, IPropertySet iPropertySet, Collection<IGeomImportSession.Node> collection) throws IOException {
        if (collection.isEmpty()) {
            throw new IOException(Intl.intl("File contains no geometric data."));
        }
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        for (IGeomImportSession.Node object2 : collection) {
            arrayList.add(ImportAction.convert(pyroMod, TransformUtil.IDENTITY_INFO, object2));
        }
        DisplayGeom displayGeom = CadImportUI.createBackgroundQuad(iPropertySet, () -> {
            AABox aABox = new AABox();
            for (IPyroGeomSrc iPyroGeomSrc : Hierarchy.flatten(arrayList, IPyroGeomSrc.class)) {
                aABox.add(iPyroGeomSrc.getBounds());
            }
            return aABox;
        });
        if (displayGeom != null) {
            GenericGeomSrc genericGeomSrc = new GenericGeomSrc(Intl.intl("background"), displayGeom.node, displayGeom.props);
            arrayList.add(0, genericGeomSrc);
        }
        ModelComposite modelComposite = new ModelComposite(file.getName());
        modelComposite.addAll(arrayList);
        return modelComposite;
    }

    private static IPyroObject convert(PyroMod pyroMod, TransformInfo transformInfo, IGeomImportSession.Node node) {
        Object object;
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        TransformInfo transformInfo2 = transformInfo.concatenate(node.transform);
        if (node.dg != DisplayGeom.EMPTY) {
            NamedPyroObject namedPyroObject;
            object = node.dg.transform(transformInfo2);
            int n = ((DisplayGeom)object).node.getNumPrims(1);
            if (n > 0) {
                Pair<Color[], Surface[]> pair = ImportAction.getFaceProps(((DisplayGeom)object).props, n, pyroMod.getDefaultSurface());
                Obstruction obstruction = new Obstruction(node.name, ((DisplayGeom)object).node, (Surface[])pair.v2);
                obstruction.setColors((Color[])pair.v1);
                namedPyroObject = obstruction;
            } else {
                namedPyroObject = new GenericGeomSrc(node.name, ((DisplayGeom)object).node, ((DisplayGeom)object).props);
            }
            arrayList.add(namedPyroObject);
            if (node.children.isEmpty()) {
                return (IPyroObject)arrayList.get(0);
            }
        }
        for (IGeomImportSession.Node node2 : node.children) {
            arrayList.add(ImportAction.convert(pyroMod, transformInfo2, node2));
        }
        object = new ModelComposite(node.name);
        ((Composite)object).addAll(arrayList);
        return object;
    }

    private static Pair<Color[], Surface[]> getFaceProps(IPropsSrc iPropsSrc, int n, Surface surface) {
        if (n == 0) {
            return new Pair<Color[], Surface[]>(new Color[0], new Surface[0]);
        }
        if (iPropsSrc.getUniformCount(0, n) == n) {
            IPrimProps iPrimProps = iPropsSrc.get(0);
            Surface surface2 = (Surface)iPrimProps.getMaterial();
            if (surface2 == null) {
                surface2 = surface;
            }
            return new Pair<Color[], Surface[]>(new Color[]{iPrimProps.getColor()}, new Surface[]{surface2});
        }
        Color[] colorArray = new Color[n];
        Surface[] surfaceArray = new Surface[n];
        for (int i = 0; i < n; ++i) {
            IPrimProps iPrimProps = iPropsSrc.get(i);
            colorArray[i] = iPrimProps.getColor();
            surfaceArray[i] = iPrimProps.getMaterial() == null ? surface : (Surface)iPrimProps.getMaterial();
        }
        return new Pair<Color[], Surface[]>(ImportAction.finalizeColors(colorArray), ImportAction.finalizeSurfs(surfaceArray));
    }

    private static Color[] finalizeColors(Color[] colorArray) {
        Color[] colorArray2;
        if (colorArray.length > 0 && GeomUtil.isUniform(colorArray)) {
            Color[] colorArray3 = new Color[1];
            colorArray2 = colorArray3;
            colorArray3[0] = colorArray[0];
        } else {
            colorArray2 = colorArray;
        }
        return colorArray2;
    }

    private static Surface[] finalizeSurfs(Surface[] surfaceArray) {
        Surface[] surfaceArray2;
        if (surfaceArray.length > 0 && GeomUtil.isUniform(surfaceArray)) {
            Surface[] surfaceArray3 = new Surface[1];
            surfaceArray2 = surfaceArray3;
            surfaceArray3[0] = surfaceArray[0];
        } else {
            surfaceArray2 = surfaceArray;
        }
        return surfaceArray2;
    }

    private void importSTL(PyroSim pyroSim, File file) throws IOException {
        Serializable serializable;
        Object object;
        List<? extends IGeom> list;
        STLOptions sTLOptions = ImportAction.getSTLOptions(pyroSim);
        if (sTLOptions == null) {
            return;
        }
        STLReader sTLReader = new STLReader(file, sTLOptions.getReaderOptions());
        sTLReader.read();
        String string = sTLReader.getName();
        if (string.isEmpty()) {
            string = file.getName();
        }
        if ((list = sTLReader.getGeometry()).isEmpty()) {
            object = Intl.intl("Warning: The STL file contained no valid triangles.  The weld tolerance may be set too high.");
            JOptionPane.showMessageDialog(pyroSim.getActiveFrame(), object, Intl.intl("Warning"), 2);
        }
        object = new ArrayList();
        Object object2 = null;
        if (list.size() == 1) {
            try {
                serializable = list.get(0);
                object2 = ImportAction.constructObj(string, (IGeom)serializable, sTLOptions);
            }
            catch (GeomNotSolidifiableException geomNotSolidifiableException) {
                object.add(new Pair<IGeom, GeomNotSolidifiableException>(list.get(0), geomNotSolidifiableException));
            }
        } else {
            serializable = new ArrayList(list.size());
            for (IGeom iGeom : list) {
                try {
                    FDSObject fDSObject = ImportAction.constructObj(string, iGeom, sTLOptions);
                    serializable.add(fDSObject);
                }
                catch (GeomNotSolidifiableException geomNotSolidifiableException) {
                    object.add(new Pair<IGeom, GeomNotSolidifiableException>(iGeom, geomNotSolidifiableException));
                }
            }
            if (serializable.size() == 1) {
                object2 = (IPyroObject)serializable.get(0);
            } else if (serializable.size() > 1) {
                ModelComposite modelComposite = new ModelComposite(string);
                modelComposite.addAll((Collection<? extends IPyroObject>)((Object)serializable));
                object2 = modelComposite;
            }
        }
        serializable = object2;
        EventQueue.invokeLater(() -> ImportAction.lambda$importSTL$423((IPyroObject)serializable, pyroSim, (List)object));
    }

    private static FDSObject constructObj(String string, IGeom iGeom, STLOptions sTLOptions) throws GeomNotSolidifiableException {
        UniformProps uniformProps = new UniformProps(new IPrimProps.Face(Color.WHITE, sTLOptions.surf, 0));
        IElemSource<Boolean> iElemSource = Elements.generateCreasesFromFacets(iGeom, uniformProps, Elements.CCW);
        IPropertySet iPropertySet = Elements.newElements(Elements.CREASE, iElemSource);
        IGeomNode iGeomNode = GeomNodeUtil.newNode(iGeom, iPropertySet);
        if (sTLOptions.type == STLOptions.ObjType.OBSTRUCTION) {
            if (sTLOptions.solid) {
                IGeomNode iGeomNode2 = iGeomNode.flatten();
                iGeomNode = iGeomNode2.applyLocalGeom(ImportAction.toSolid(iGeomNode2.getLocalGeom()));
            }
            return new Obstruction(string, iGeomNode, new Surface[]{sTLOptions.surf});
        }
        if (sTLOptions.type == STLOptions.ObjType.HOLE) {
            IGeomNode iGeomNode3 = iGeomNode.flatten();
            iGeomNode = iGeomNode3.applyLocalGeom(ImportAction.toSolid(iGeomNode3.getLocalGeom()));
            return new Hole(string, iGeomNode);
        }
        return null;
    }

    private static IGeom toSolid(IGeom iGeom) throws GeomNotSolidifiableException {
        if (!(iGeom instanceof Mesh)) {
            throw new GeomNotSolidifiableException(Intl.intl("Geometry is not a mesh."));
        }
        Mesh mesh = (Mesh)iGeom;
        Pair<Mesh.ClosedTest, Object> pair = mesh.testClosed();
        if (pair.v1 != Mesh.ClosedTest.CLOSED) {
            String string = "";
            switch ((Mesh.ClosedTest)((Object)pair.v1)) {
                case ONE_FACE: {
                    string = Intl.intl("Geometry contains only one face.");
                    break;
                }
                case WRONG_TYPE: {
                    string = Intl.intl("Geometry is not composed of faces.");
                    break;
                }
                case EDGE_OPEN: {
                    Point3d[] point3dArray = (Point3d[])pair.v2;
                    string = String.format(Intl.intl("Geometry contains a hole next to edge %s -> %s.%nTry increasing the weld tolerance to properly close the solid."), ImportAction.format(point3dArray[0]), ImportAction.format(point3dArray[1]));
                    break;
                }
            }
            throw new GeomNotSolidifiableException(string);
        }
        return mesh.toSolid();
    }

    private static String format(Point3d point3d) {
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        return String.format("(%s, %s, %s) %s", Global.format(UnitDouble.convert(point3d.x, Geometry.LU, unit)), Global.format(UnitDouble.convert(point3d.y, Geometry.LU, unit)), Global.format(UnitDouble.convert(point3d.z, Geometry.LU, unit)), unit);
    }

    private static STLOptions getSTLOptions(PyroSim pyroSim) {
        guiDialog guiDialog2 = new guiDialog((Window)pyroSim.getActiveFrame(), Intl.intl("STL Import Options"), 9);
        guiPanel guiPanel2 = guiDialog2.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        guiComboBox<Object> guiComboBox2 = new guiComboBox<Object>((T[])new Object[]{SI.MILLI(SI.METER), SI.CENTI(SI.METER), SI.METER, SI.KILO(SI.METER), NonSI.INCH, NonSI.FOOT, NonSI.YARD});
        guiComboBox2.setSelectedItem(NonSI.INCH);
        ValueField<UnitDouble> valueField = ValueFields.udFld(1.0E-5, DoubleVR.above(0.0, true), SI.METER, UnitSystem.getSource(0));
        guiRadioButton guiRadioButton2 = new guiRadioButton(Intl.intl("Obstruction"));
        guiRadioButton guiRadioButton3 = new guiRadioButton(Intl.intl("Hole"));
        new guiButtonGroup(guiRadioButton2, guiRadioButton3);
        guiRadioButton2.setSelected(true);
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Obstruction Properties"));
        SurfaceComboBox surfaceComboBox = new SurfaceComboBox(pyroSim.getMediator().getSurfaceMgr(), pyroSim.getMediator().getDefaultSurface());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Surface:"));
        guiCheckBox guiCheckBox2 = new guiCheckBox(Intl.intl("Convert to solid obstructions."), true);
        LinkStatus.link((AbstractButton)guiRadioButton2, titleSeparator, surfaceComboBox, guiLabel2, guiCheckBox2);
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addRow(Intl.intl("File Units:"), guiComboBox2);
        gridBagHelper.addRow(Intl.intl("Vertex weld tolerance:"), valueField);
        gridBagHelper.addFilledRow(Intl.intl("What type of geometry should the STL data be imported as?"));
        gridBagHelper.addIdentRow(guiRadioButton2, GridBagHelper.REMAINING);
        gridBagHelper.addIdentRow(guiRadioButton3, GridBagHelper.REMAINING);
        gridBagHelper.addFilledRow(titleSeparator);
        gridBagHelper.addIdentRow(guiLabel2, surfaceComboBox);
        gridBagHelper.addIdentRow(guiCheckBox2, GridBagHelper.REMAINING);
        gridBagHelper.finalizeRows();
        if (guiDialog2.doModal() != 1) {
            return null;
        }
        STLOptions.ObjType objType = guiRadioButton2.isSelected() ? STLOptions.ObjType.OBSTRUCTION : STLOptions.ObjType.HOLE;
        return new STLOptions((Unit)guiComboBox2.getSelectedItem(), SI.METER, (UnitDouble)valueField.getValue(), objType, (Surface)surfaceComboBox.getSelectedItem(), guiCheckBox2.isSelected());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AABox readSMVBounds(File file) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            SMVReader sMVReader = new SMVReader();
            SMVReader.SMVInfo sMVInfo = sMVReader.read(bufferedInputStream);
            AABox aABox = new AABox();
            for (SMVReader.MeshInfo meshInfo : sMVInfo.meshes) {
                aABox.add(meshInfo.bounds);
            }
            System.out.printf("Read mesh bounds from SMV file, %s:%n%s%n", file.getAbsolutePath(), aABox);
            AABox aABox2 = aABox;
            return aABox2;
        }
        catch (Throwable throwable) {
            throw new IOException(String.format(Intl.intl("Could not read mesh bounds from \"%s\"."), file.getAbsolutePath(), throwable));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importINI(PyroSim pyroSim, File file) throws IOException, ParseException {
        int n;
        AABox aABox;
        Object object;
        Object object2;
        Object object3;
        PyroMod pyroMod = pyroSim.getMediator();
        File file2 = new File(FilenameManager.changeExtension(file.getAbsolutePath(), "smv"));
        if (!file2.exists()) {
            object3 = Intl.intl("Choose SMV File");
            int n2 = PyroGuiUtil.ui(() -> ImportAction.lambda$importINI$424(pyroSim, (String)object3, (String)(object2 = Intl.intl("Use model bounds"))));
            if (n2 == 0) {
                object = file2;
                if ((file2 = PyroGuiUtil.ui(() -> ImportAction.lambda$importINI$425(pyroSim, (File)object))) == null) {
                    return;
                }
                aABox = this.readSMVBounds(file2);
            } else {
                if (n2 != 1) return;
                aABox = new AABox();
                for (Grid grid2 : pyroMod.getGridManager().flatten(grid -> grid.isEnabled())) {
                    aABox.add(grid2.getBounds());
                }
            }
        } else {
            aABox = this.readSMVBounds(file2);
        }
        object3 = new BoundsCalculator();
        Stream.of(pyroSim.getModelView().getClipManager().getClippingScenes()).forEach(arg_0 -> ImportAction.lambda$importINI$427((BoundsCalculator)object3, arg_0));
        object2 = ((BoundsCalculator)object3).getBounds();
        if (!((AABox)object2).isValid()) {
            object2 = ((AABox)object2).ensureValidSize(5.0, 5.0);
        }
        INIReader iNIReader = new INIReader((AABox)object2, aABox);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Object object4 = null;
        try {
            object = iNIReader.read(bufferedInputStream);
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            if (bufferedInputStream != null) {
                if (object4 != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)bufferedInputStream).close();
                }
            }
        }
        int n3 = 0;
        object4 = new CompositeTask<PyroMod>(pyroMod);
        IFilteredCollection<View> iFilteredCollection = theUtil.filter(object, View.class);
        if (!iFilteredCollection.isEmpty()) {
            ViewList viewList = pyroMod.getViews().newGroup(file.getName());
            viewList.addAll(iFilteredCollection);
            ((CompositeTask)object4).addTask(new AddTask((IPyroObject)pyroMod.getViews(), (IPyroObject[])new ViewList[]{viewList}));
            ((CompositeTask)object4).addTask(new SelectTask(pyroMod, viewList));
            n = n3 + iFilteredCollection.size();
        }
        void var13_21 = n;
        EventQueue.invokeLater(() -> ImportAction.lambda$importINI$428(pyroMod, (CompositeTask)object4, iNIReader, pyroSim, (int)var13_21));
    }

    private static /* synthetic */ void lambda$importINI$428(PyroMod pyroMod, CompositeTask compositeTask, INIReader iNIReader, PyroSim pyroSim, int n) {
        pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Import INI File"));
        if (!iNIReader.getWarnings().isEmpty()) {
            WarningDlg<FileWarning> warningDlg = new WarningDlg<FileWarning>((Window)pyroSim.getActiveFrame(), Intl.intl("Import Warnings"), Intl.intl("There were some problems importing the INI file:"), iNIReader.getWarnings());
            warningDlg.doModal();
        }
        JOptionPane.showMessageDialog(pyroSim.getActiveFrame(), String.format(Intl.intl("Imported %d object(s)."), n), n == 0 ? Intl.intl("No Objects Imported") : Intl.intl("Objects Imported"), 1);
    }

    private static /* synthetic */ void lambda$importINI$427(BoundsCalculator boundsCalculator, ModelScene modelScene) {
        modelScene.getBounds(boundsCalculator);
    }

    private static /* synthetic */ File lambda$importINI$425(PyroSim pyroSim, File file) throws Exception {
        return PyroSim.getFilenames().getOpenFile((Component)pyroSim.getActiveFrame(), file, "smv", Intl.intl("Smokeview Files"));
    }

    private static /* synthetic */ Integer lambda$importINI$424(PyroSim pyroSim, String string, String string2) throws Exception {
        return JOptionPane.showOptionDialog(pyroSim.getActiveFrame(), Intl.intl("An SMV file is needed to calculate the mesh bounds, but one cannot\nbe found. What would you like to do?"), Intl.intl("Missing SMV File"), 2, 3, null, new Object[]{string, string2, Intl.intl("Cancel")}, string);
    }

    private static /* synthetic */ void lambda$importSTL$423(IPyroObject iPyroObject, PyroSim pyroSim, List list) {
        Object object;
        if (iPyroObject != null) {
            object = new SelectTask(pyroSim.getMediator(), iPyroObject);
            ((CompositeTask)object).addTask(new AddTask((IPyroObject)pyroSim.getMediator().getObstructions(), new IPyroObject[]{iPyroObject}));
            pyroSim.getMediator().getTaskManager().exec((Task)object, Intl.intl("Import STL File"), 2);
        }
        if (!list.isEmpty()) {
            object = (GeomNotSolidifiableException)((Pair)list.get((int)0)).v2;
            String string = String.format(Intl.intl("Warning: Could not construct a solid out of the geometry:%n%s"), ((Throwable)object).getLocalizedMessage());
            JOptionPane.showMessageDialog(pyroSim.getActiveFrame(), string, Intl.intl("Warning"), 2);
        }
    }

    private static class STLOptions {
        public final ObjType type;
        public final Surface surf;
        public final boolean solid;
        public final UnitDouble weldTol;
        public final Unit srcUnit;
        public final Unit dstUnit;

        public STLOptions(Unit unit, Unit unit2, UnitDouble unitDouble, ObjType objType, Surface surface, boolean bl) {
            this.srcUnit = unit;
            this.dstUnit = unit2;
            this.weldTol = unitDouble;
            this.type = objType;
            this.surf = surface;
            this.solid = bl;
        }

        public STLReader.Options getReaderOptions() {
            double d = this.srcUnit.getConverterTo(this.dstUnit).convert(1.0);
            Matrix4d matrix4d = d == 1.0 ? null : Util.scaleMat(d, d, d);
            double d2 = this.weldTol.getValue(this.dstUnit);
            return new STLReader.Options(matrix4d, d2);
        }

        public static enum ObjType {
            OBSTRUCTION,
            HOLE;

        }
    }

    private static class GeomNotSolidifiableException
    extends Exception {
        private static final long serialVersionUID = -7793338533512539995L;

        public GeomNotSolidifiableException(String string) {
            super(string);
        }
    }

    private static class SurfKey {
        public final Surface surface;
        public final int hash;

        public SurfKey(Surface surface) {
            this.surface = surface;
            this.hash = surface.getName().hashCode() + (surface.getAppearance() != null ? surface.getAppearance().pseudoHashCode() : 0);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof SurfKey && this.surface.getName().equals(((SurfKey)object).surface.getName()) && this.surface.getAppearance().pseudoEquals(((SurfKey)object).surface.getAppearance());
        }
    }
}

