/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.output.Slice;
import pyrosim.gui.actions.ARunFDSValidation;

public class FlameConditionValidation
extends ARunFDSValidation {
    @Override
    public Collection<IPyroObject> validateModel(PyroSim pyroSim, PyroMod pyroMod) {
        if (!pyroMod.getReactions().getActiveReactions().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IPyroObject> hashSet = new HashSet<IPyroObject>();
        for (IPyroObject iPyroObject : pyroMod.getSurfaceMgr().flatten()) {
            if (!(((Surface)iPyroObject).getSurfDesc() instanceof BurnerSurfDesc) && !(((Surface)iPyroObject).getSurfDesc() instanceof GeneralSurfDesc)) continue;
            hashSet.add(iPyroObject);
        }
        for (IPyroObject iPyroObject : pyroMod.getDevices().flatten()) {
            if (iPyroObject instanceof SmokeDetector || iPyroObject instanceof Aspirator || iPyroObject instanceof AspiratorSampler) {
                hashSet.add(iPyroObject);
                continue;
            }
            if (!(iPyroObject instanceof AMeasuringDevc) || !((AMeasuringDevc)iPyroObject).getQuantity().get().mixFracOnly) continue;
            hashSet.add(iPyroObject);
        }
        for (IPyroObject iPyroObject : pyroMod.getSlcfList().flatten()) {
            if (!((Slice)iPyroObject).getQuantity().get().mixFracOnly) continue;
            hashSet.add(iPyroObject);
        }
        for (IPyroObject iPyroObject : pyroMod.getSlcf3dList().flatten()) {
            if (!((Slice)iPyroObject).getQuantity().get().mixFracOnly) continue;
            hashSet.add(iPyroObject);
        }
        return hashSet;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window window, int n) {
        String string = Intl.intl("A reaction (&REAC) must be defined in order to simulate \nburning in FDS. This model currently includes objects that\nrequire a reaction, but no reaction has been specified.\n\nClick OK to select objects that require an active reaction.\n\nClick Ignore if you have defined a reaction in the Additional\nRecords section.");
        return new ARunFDSValidation.Prompt(window, string);
    }
}

