/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.gui.actions.ARunFDSValidation;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class ExposedOverlapValidation
extends ARunFDSValidation {
    public static Collection<IPyroObject> getExposedOverlapObst(PyroSim pyroSim, PyroMod pyroMod) {
        ArrayDeque<IObstruction> arrayDeque = new ArrayDeque<IObstruction>();
        block2: for (IObstruction cloneable22 : pyroMod.getObstructions().flatten(IObstruction.class, iObstruction -> iObstruction.isEnabled())) {
            for (Surface surface : cloneable22.getSurfaces()) {
                if (!(surface.getSurfDesc() instanceof LayeredSurfDesc)) continue;
                SurfComposition surfComposition = ((LayeredSurfDesc)surface.getSurfDesc()).d_surfComp;
                if (!(surfComposition.d_backing instanceof Backing.Exposed)) continue;
                arrayDeque.add(cloneable22);
                continue block2;
            }
        }
        if (arrayDeque.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        ArrayDeque<Grid> arrayDeque2 = new ArrayDeque<Grid>(pyroMod.getGridManager().flatten(grid -> grid.isEnabled()));
        ArrayDeque<AABox> arrayDeque3 = new ArrayDeque<AABox>();
        while (!arrayDeque2.isEmpty()) {
            Grid grid2 = (Grid)arrayDeque2.removeFirst();
            Iterator iterator = arrayDeque2.iterator();
            while (iterator.hasNext()) {
                Grid grid3 = (Grid)iterator.next();
                AABox aABox = ExposedOverlapValidation.getAdjacentRegion(grid2, grid3);
                if (aABox == null) continue;
                arrayDeque3.add(aABox);
            }
        }
        if (arrayDeque3.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        final HashSet<IPyroObject> hashSet = new HashSet<IPyroObject>();
        for (final IObstruction iObstruction2 : arrayDeque) {
            AABox aABox = iObstruction2.getBounds();
            for (AABox aABox2 : arrayDeque3) {
                if (!aABox.intersects(aABox2, 1.0E-6)) continue;
                try {
                    iObstruction2.getGeom().find(aABox2, (IResult<? super IPrimitive>)new IResult<IPrimitive>(){

                        @Override
                        public void mark(IPrimitive iPrimitive, Containment containment) {
                            if (containment.positive) {
                                hashSet.add(iObstruction2);
                                throw new CancellationException();
                            }
                        }
                    });
                }
                catch (CancellationException cancellationException) {}
            }
        }
        return hashSet;
    }

    private static AABox getAdjacentRegion(Grid grid, Grid grid2) {
        AABox aABox;
        AABox aABox2;
        Cloneable cloneable;
        if (grid.getBounds().test(grid2.getBounds(), 1.0E-6) == Containment.OUTSIDE) {
            return null;
        }
        Pair<Point3d, Point3d> pair = ExposedOverlapValidation.getOverlap(grid, grid2);
        Integer n = 0;
        Integer n2 = 1;
        Integer n3 = 2;
        ArrayList<Pair<Integer, Double>> arrayList = new ArrayList<Pair<Integer, Double>>();
        arrayList.add(new Pair<Integer, Double>(n, ((Point3d)pair.v2).x - ((Point3d)pair.v1).x));
        arrayList.add(new Pair<Integer, Double>(n2, ((Point3d)pair.v2).y - ((Point3d)pair.v1).y));
        arrayList.add(new Pair<Integer, Double>(n3, ((Point3d)pair.v2).z - ((Point3d)pair.v1).z));
        arrayList.sort(new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> pair, Pair<Integer, Double> pair2) {
                return Double.compare((Double)pair.v2, (Double)pair2.v2);
            }
        });
        int n4 = (Integer)((Pair)arrayList.get((int)0)).v1;
        if (n4 == n) {
            if (((Point3d)pair.v2).y - ((Point3d)pair.v1).y < 1.0E-6 || ((Point3d)pair.v2).z - ((Point3d)pair.v1).z < 1.0E-6) {
                return null;
            }
            cloneable = grid.getBounds().getCenter().x < grid2.getBounds().getCenter().x ? grid : grid2;
            Grid grid3 = grid.getBounds().getCenter().x < grid2.getBounds().getCenter().x ? grid2 : grid;
            List<Double> list = ExposedOverlapValidation.getLinesInRange(((Grid)cloneable).getYLinePositions(), ((Point3d)pair.v1).y, ((Point3d)pair.v2).y, 1.0E-6);
            List<Double> list2 = ExposedOverlapValidation.getLinesInRange(grid3.getYLinePositions(), ((Point3d)pair.v1).y, ((Point3d)pair.v2).y, 1.0E-6);
            List<Double> list3 = ExposedOverlapValidation.getLinesInRange(((Grid)cloneable).getZLinePositions(), ((Point3d)pair.v1).z, ((Point3d)pair.v2).z, 1.0E-6);
            List<Double> list4 = ExposedOverlapValidation.getLinesInRange(grid3.getZLinePositions(), ((Point3d)pair.v1).z, ((Point3d)pair.v2).z, 1.0E-6);
            if (ExposedOverlapValidation.getLinesMatch(list, list2, 1.0E-6) && ExposedOverlapValidation.getLinesMatch(list3, list4, 1.0E-6)) {
                return null;
            }
            aABox2 = new AABox(cloneable.getBounds().getMin(), new Point3d(cloneable.getBounds().getMaxX() + grid3.getXDivisions()[0].get(SI.METER), cloneable.getBounds().getMaxY(), cloneable.getBounds().getMaxZ()));
            aABox = new AABox(new Point3d(grid3.getBounds().getMinX() - ((Grid)cloneable).getXDivisions()[((Grid)cloneable).getXDivisions().length - 1].get(SI.METER), grid3.getBounds().getMinY(), grid3.getBounds().getMinZ()), grid3.getBounds().getMax());
        } else if (n4 == n2) {
            if (((Point3d)pair.v2).x - ((Point3d)pair.v1).x < 1.0E-6 || ((Point3d)pair.v2).z - ((Point3d)pair.v1).z < 1.0E-6) {
                return null;
            }
            cloneable = grid.getBounds().getCenter().y < grid2.getBounds().getCenter().y ? grid : grid2;
            Grid grid4 = grid.getBounds().getCenter().y < grid2.getBounds().getCenter().y ? grid2 : grid;
            List<Double> list = ExposedOverlapValidation.getLinesInRange(((Grid)cloneable).getXLinePositions(), ((Point3d)pair.v1).x, ((Point3d)pair.v2).x, 1.0E-6);
            List<Double> list5 = ExposedOverlapValidation.getLinesInRange(grid4.getXLinePositions(), ((Point3d)pair.v1).x, ((Point3d)pair.v2).x, 1.0E-6);
            List<Double> list6 = ExposedOverlapValidation.getLinesInRange(((Grid)cloneable).getZLinePositions(), ((Point3d)pair.v1).z, ((Point3d)pair.v2).z, 1.0E-6);
            List<Double> list7 = ExposedOverlapValidation.getLinesInRange(grid4.getZLinePositions(), ((Point3d)pair.v1).z, ((Point3d)pair.v2).z, 1.0E-6);
            if (ExposedOverlapValidation.getLinesMatch(list, list5, 1.0E-6) && ExposedOverlapValidation.getLinesMatch(list6, list7, 1.0E-6)) {
                return null;
            }
            aABox2 = new AABox(cloneable.getBounds().getMin(), new Point3d(cloneable.getBounds().getMaxX(), cloneable.getBounds().getMaxY() + grid4.getYDivisions()[0].get(SI.METER), cloneable.getBounds().getMaxZ()));
            aABox = new AABox(new Point3d(grid4.getBounds().getMinX(), grid4.getBounds().getMinY() - ((Grid)cloneable).getYDivisions()[((Grid)cloneable).getYDivisions().length - 1].get(SI.METER), grid4.getBounds().getMinZ()), grid4.getBounds().getMax());
        } else if (n4 == n3) {
            if (((Point3d)pair.v2).x - ((Point3d)pair.v1).x < 1.0E-6 || ((Point3d)pair.v2).y - ((Point3d)pair.v1).y < 1.0E-6) {
                return null;
            }
            cloneable = grid.getBounds().getCenter().z < grid2.getBounds().getCenter().z ? grid : grid2;
            Grid grid5 = grid.getBounds().getCenter().z < grid2.getBounds().getCenter().z ? grid2 : grid;
            List<Double> list = ExposedOverlapValidation.getLinesInRange(((Grid)cloneable).getXLinePositions(), ((Point3d)pair.v1).x, ((Point3d)pair.v2).x, 1.0E-6);
            List<Double> list8 = ExposedOverlapValidation.getLinesInRange(grid5.getXLinePositions(), ((Point3d)pair.v1).x, ((Point3d)pair.v2).x, 1.0E-6);
            List<Double> list9 = ExposedOverlapValidation.getLinesInRange(((Grid)cloneable).getYLinePositions(), ((Point3d)pair.v1).y, ((Point3d)pair.v2).y, 1.0E-6);
            List<Double> list10 = ExposedOverlapValidation.getLinesInRange(grid5.getYLinePositions(), ((Point3d)pair.v1).y, ((Point3d)pair.v2).y, 1.0E-6);
            if (ExposedOverlapValidation.getLinesMatch(list, list8, 1.0E-6) && ExposedOverlapValidation.getLinesMatch(list9, list10, 1.0E-6)) {
                return null;
            }
            aABox2 = new AABox(cloneable.getBounds().getMin(), new Point3d(cloneable.getBounds().getMaxX(), cloneable.getBounds().getMaxY(), cloneable.getBounds().getMaxZ() + grid5.getZDivisions()[0].get(SI.METER)));
            aABox = new AABox(new Point3d(grid5.getBounds().getMinX(), grid5.getBounds().getMinY(), grid5.getBounds().getMinZ() - ((Grid)cloneable).getZDivisions()[((Grid)cloneable).getZDivisions().length - 1].get(SI.METER)), grid5.getBounds().getMax());
        } else {
            throw new IllegalArgumentException("Error calculating mesh adjacency.");
        }
        cloneable = new AABox(Math.max(aABox2.getMinX(), aABox.getMinX()), Math.max(aABox2.getMinY(), aABox.getMinY()), Math.max(aABox2.getMinZ(), aABox.getMinZ()), Math.min(aABox2.getMaxX(), aABox.getMaxX()), Math.min(aABox2.getMaxY(), aABox.getMaxY()), Math.min(aABox2.getMaxZ(), aABox.getMaxZ()));
        return ((AABox)cloneable).isValid() ? cloneable : null;
    }

    private static List<Double> getLinesInRange(UnitDouble[] unitDoubleArray, double d, double d2, double d3) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (UnitDouble unitDouble : unitDoubleArray) {
            Double d4 = unitDouble.get(SI.METER);
            if (!(d - d3 <= d4) || !(d4 <= d2 + d3)) continue;
            arrayList.add(d4);
        }
        return arrayList;
    }

    private static boolean getLinesMatch(List<Double> list, List<Double> list2, double d) {
        if (list.size() != list2.size()) {
            return false;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(d < Math.abs(list.get(i) - list2.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static Pair<Point3d, Point3d> getOverlap(Grid grid, Grid grid2) {
        Point3d point3d = new Point3d(Math.max(grid.getMinPoint().x(SI.METER), grid2.getMinPoint().x(SI.METER)), Math.max(grid.getMinPoint().y(SI.METER), grid2.getMinPoint().y(SI.METER)), Math.max(grid.getMinPoint().z(SI.METER), grid2.getMinPoint().z(SI.METER)));
        Point3d point3d2 = new Point3d(Math.min(grid.getMaxPoint().x(SI.METER), grid2.getMaxPoint().x(SI.METER)), Math.min(grid.getMaxPoint().y(SI.METER), grid2.getMaxPoint().y(SI.METER)), Math.min(grid.getMaxPoint().z(SI.METER), grid2.getMaxPoint().z(SI.METER)));
        return new Pair<Point3d, Point3d>(point3d, point3d2);
    }

    @Override
    public Collection<IPyroObject> validateModel(PyroSim pyroSim, PyroMod pyroMod) {
        return ExposedOverlapValidation.getExposedOverlapObst(pyroSim, pyroMod);
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window window, int n) {
        String string = String.format(Intl.intl("Obstructions that use a layered surface with the backing type EXPOSED\ncan only occupy the boundary cells of a mesh when all adjacent mesh\ncells are one-to-one. This model contains %d obstructions that violate\nthis requirement.\n\nPress OK to select affected obstructions."), n);
        return new ARunFDSValidation.Prompt(window, string);
    }
}

