/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.swing.Action;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.INIWriter;
import pyrosim.io.fds.SMVReader;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.guiAction;
import thunderheadeng.io.FilenameManager;

public class ExportSmokeINIFileAction
extends guiAction {
    private static final long serialVersionUID = -4705790355070523899L;

    public ExportSmokeINIFileAction() {
        super(Intl.intl("Smokeview INI..."));
        this.putValue("ShortDescription", Intl.intl("Writes the Smokeview INI file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        File file;
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        File file2 = null;
        boolean bl = false;
        Action action = pyroSim.getFDSRunDropdown().getSelectedAction();
        if (action instanceof Actions.IRunFDSAction && pyroSim.getFilename() != null) {
            file = ((Actions.IRunFDSAction)((Object)action)).getFDSFile(new File(pyroSim.getFilename()), pyroMod);
            object = new FDSRenderer.Filenames(file);
            file2 = new File(((FDSRenderer.Filenames)object).dir, ((FDSRenderer.Filenames)object).ini);
            bl = new File(((FDSRenderer.Filenames)object).dir, ((FDSRenderer.Filenames)object).ge1).exists();
        }
        if (file2 == null) {
            file2 = pyroSim.suggestFile("ini");
        }
        if ((file = PyroSim.getFilenames().getSaveFile((Component)PyroSim.getApp().getMainFrame(), Intl.intl("Choose a Location to Save the INI File"), file2, "ini", Intl.intl("Smokeview INI Files"))) == null) {
            return;
        }
        object = new File(FilenameManager.changeExtension(file.getAbsolutePath(), "smv"));
        pyroSim.beginWaitCursor();
        try {
            Object object2;
            Object object3;
            FDS6Renderer fDS6Renderer = new FDS6Renderer(pyroMod, pyroSim.getFDSRenderProps());
            Collection<IPyroObject> collection = fDS6Renderer.collectPyroObjects();
            AABox aABox = null;
            try {
                object3 = new BufferedInputStream(new FileInputStream((File)object));
                Throwable serializable2 = null;
                try {
                    object2 = new SMVReader();
                    SMVReader.SMVInfo sMVInfo = ((SMVReader)object2).read((InputStream)object3);
                    if (!sMVInfo.meshes.isEmpty()) {
                        aABox = new AABox();
                        for (SMVReader.MeshInfo meshInfo : sMVInfo.meshes) {
                            aABox.add(meshInfo.bounds);
                        }
                        System.out.printf("Using mesh bounds in SMV file, %s%n%s%n", ((File)object).getAbsolutePath(), aABox);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (serializable2 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (Throwable throwable) {
                                serializable2.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object3).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                aABox = null;
            }
            if (aABox == null) {
                aABox = new AABox();
                for (Grid grid : Hierarchy.flatten(collection, Grid.class)) {
                    aABox.add(grid.getBounds());
                }
                aABox.ensureValidSize(5.0, 5.0);
            }
            object3 = new BufferedOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                object2 = new INIWriter(aABox);
                ((INIWriter)object2).write((OutputStream)object3, bl, PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1), !PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS), collection);
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
            finally {
                if (object3 != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)object3).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((OutputStream)object3).close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            PyroGuiUtil.showError(PyroSim.getApp(), Intl.intl("File Error"), Intl.intl("Could not write INI file"), throwable);
        }
        finally {
            pyroSim.endWaitCursor();
        }
    }
}

