/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import pyrosim.Intl;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.gui.actions.ExportMetaAction;
import pyrosim.io.IOUtil;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;

public class ExportPyroViewsAction
extends ExportMetaAction {
    private static final long serialVersionUID = 1L;
    public static final String EXT = "views";

    public ExportPyroViewsAction() {
        super(Intl.intl("PyroSim Viewpoints..."), Intl.intl("Exports View Data for 3D Results"), Intl.intl("Results View Files"), EXT, (pyroSim, file) -> {
            try {
                ExportPyroViewsAction.writeViewsFile(file, pyroSim.getMediator().getViews());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }

    public static void writeViewsFile(File file, ViewList viewList) throws IOException {
        try (PrintWriter printWriter = IOUtil.newPrintWriterUTF8(file);){
            JSONArray jSONArray = ExportPyroViewsAction.toJSONArray(viewList);
            printWriter.println(jSONArray.toJSONString());
        }
    }

    private static JSONArray toJSONArray(ViewList viewList) {
        JSONArray jSONArray = new JSONArray();
        for (View view : viewList.flatten()) {
            ExportPyroViewsAction.toJSON(view).ifPresent(jSONObject -> jSONArray.add(jSONObject));
        }
        return jSONArray;
    }

    private static Optional<JSONObject> toJSON(View view) {
        Object object;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"type", (Object)"camera_view");
        jSONObject.put((Object)"name", (Object)view.getName());
        CameraState cameraState = view.get(View.PROP_CAMERA);
        if (cameraState != null) {
            object = ExportPyroViewsAction.toJSON(cameraState.getCameraRecord());
            jSONObject.put((Object)"state", object);
        }
        if ((object = view.get(View.PROP_SECTION_BOX)) != null) {
            JSONArray jSONArray = ExportPyroViewsAction.toJSON(view.get(View.PROP_SECTION_BOX));
            jSONObject.put((Object)"sectionBox", (Object)jSONArray);
        }
        if (cameraState == null && object == null) {
            return Optional.empty();
        }
        return Optional.of(jSONObject);
    }

    private static JSONArray toJSON(SectionBox sectionBox) {
        JSONArray jSONArray = new JSONArray();
        IGeom iGeom = sectionBox.getGeom().flatten().getLocalGeom();
        List<IPlanarFace> list = GeomUtil.explode(iGeom, IPlanarFace.class);
        for (IPlanarFace iPlanarFace : list) {
            jSONArray.add((Object)ExportPyroViewsAction.toJSON(iPlanarFace));
        }
        return jSONArray;
    }

    private static JSONObject toJSON(IPlanarFace iPlanarFace) {
        JSONObject jSONObject = new JSONObject();
        Plane3d plane3d = iPlanarFace.getPlane(true);
        jSONObject.put((Object)"x", (Object)plane3d.x);
        jSONObject.put((Object)"y", (Object)plane3d.y);
        jSONObject.put((Object)"z", (Object)plane3d.z);
        jSONObject.put((Object)"w", (Object)plane3d.w);
        return jSONObject;
    }

    private static JSONObject toJSON(CameraRecord cameraRecord) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"loc", (Object)ExportPyroViewsAction.toArray(cameraRecord.loc));
        jSONObject.put((Object)"ref", (Object)ExportPyroViewsAction.toArray(cameraRecord.ref));
        jSONObject.put((Object)"up", (Object)ExportPyroViewsAction.toArray(cameraRecord.up));
        jSONObject.put((Object)"zoom", (Object)cameraRecord.zoom);
        jSONObject.put((Object)"zoomloc", (Object)ExportPyroViewsAction.toArray(cameraRecord.zoomLoc));
        jSONObject.put((Object)"near", (Object)cameraRecord.near);
        jSONObject.put((Object)"far", (Object)cameraRecord.far);
        if (cameraRecord.frustum instanceof PerspectiveCamera.FrustumRecord) {
            PerspectiveCamera.FrustumRecord frustumRecord = (PerspectiveCamera.FrustumRecord)cameraRecord.frustum;
            jSONObject.put((Object)"fov", (Object)frustumRecord.fov);
        } else {
            jSONObject.put((Object)"fov", (Object)Math.toRadians(45.0));
        }
        return jSONObject;
    }
}

