/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import javax.vecmath.Matrix4d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import pyrosim.Intl;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.ModelImage;
import pyrosim.gui.actions.ExportMetaAction;
import pyrosim.io.IOUtil;

public class ExportPyroFloorsAction
extends ExportMetaAction {
    private static final long serialVersionUID = 1L;
    public static final String EXT = "pyrofloors";

    public ExportPyroFloorsAction() {
        super(Intl.intl("PyroSim Floors..."), Intl.intl("Exports Floor Data for 3D Results"), Intl.intl("Results Floor Files"), EXT, (pyroSim, file) -> {
            try {
                ExportPyroFloorsAction.writeFloorsFile(file, pyroSim.getMediator().getFloorManager());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }

    public static void writeFloorsFile(File file, FloorManager floorManager) throws IOException {
        try (PrintWriter printWriter = IOUtil.newPrintWriterUTF8(file);){
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"version", (Object)Version.curr().ordinal());
            jSONObject.put((Object)"floors", (Object)ExportPyroFloorsAction.toJSONArray(floorManager));
            printWriter.println(jSONObject.toJSONString());
        }
    }

    private static JSONArray toJSONArray(FloorManager floorManager) {
        JSONArray jSONArray = new JSONArray();
        for (Floor floor : floorManager.flatten()) {
            ExportPyroFloorsAction.toJSON(floor).ifPresent(jSONObject -> jSONArray.add(jSONObject));
        }
        return jSONArray;
    }

    private static Optional<JSONObject> toJSON(Floor floor) {
        BaseUnit baseUnit = SI.METER;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"name", (Object)floor.getName());
        jSONObject.put((Object)"elevation", (Object)floor.getElevation().get(baseUnit));
        jSONObject.put((Object)"slabThickness", (Object)floor.getSlabThickness().get(baseUnit));
        jSONObject.put((Object)"wallHeight", (Object)floor.getWallHeight().get(baseUnit));
        jSONObject.put((Object)"color", (Object)ExportPyroFloorsAction.toArray(floor.getClipColor()));
        ModelImage modelImage = floor.getBgImage();
        if (modelImage != null) {
            jSONObject.put((Object)"image", (Object)ExportPyroFloorsAction.toJSON(modelImage));
        }
        return Optional.of(jSONObject);
    }

    private static JSONObject toJSON(ModelImage modelImage) {
        JSONObject jSONObject = new JSONObject();
        Matrix4d matrix4d = modelImage.getLWTransform().toMatrix(false);
        jSONObject.put((Object)"xform", (Object)ExportPyroFloorsAction.toArray(matrix4d));
        jSONObject.put((Object)"fn", (Object)modelImage.getImage().getFilename());
        jSONObject.put((Object)"opacity", (Object)Float.valueOf(modelImage.getOpacity()));
        return jSONObject;
    }

    public static enum Version {
        V00;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

