/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.function.BiConsumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import org.json.simple.JSONArray;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.gui.actions.Actions;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiUtil;

public class ExportMetaAction
extends guiAction {
    private static final long serialVersionUID = 1L;
    private final String EXT;
    private final String d_type;
    private final BiConsumer<PyroSim, File> d_writeFile;

    public ExportMetaAction(String string, String string2, String string3, String string4, BiConsumer<PyroSim, File> biConsumer) {
        super(string);
        this.putValue("ShortDescription", string2);
        this.EXT = string4;
        this.d_type = string3;
        this.d_writeFile = biConsumer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PyroSim pyroSim = PyroSim.getApp();
        File file = this.getSuggestFile(pyroSim.getFilename());
        File file2 = pyroSim.getFilenameManager().getSaveFile((Component)pyroSim.getMainFrame(), Intl.intl("Choose a location to save the file"), file, this.EXT, this.d_type);
        if (file2 == null) {
            return;
        }
        this.writeFile(pyroSim, file2);
    }

    private File getSuggestFile(String string) {
        if (string == null) {
            return new File(Intl.intl("untitled." + this.EXT));
        }
        File file = new File(string);
        String string2 = Actions.getResultsID(file);
        File file2 = new File(file.getParentFile(), string2);
        String string3 = String.format("%s.%s", string2, this.EXT);
        if (file2.exists()) {
            return new File(file2, string3);
        }
        return new File(file.getParentFile(), string3);
    }

    private boolean writeFile(PyroSim pyroSim, File file) {
        try {
            this.d_writeFile.accept(pyroSim, file);
            return true;
        }
        catch (Throwable throwable) {
            guiUtil.showError(pyroSim, Intl.intl("File Error"), String.format(Intl.intl("Could not write file: %s"), file.getAbsolutePath()), throwable);
            return false;
        }
    }

    protected static JSONArray toArray(Tuple3d tuple3d) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)tuple3d.x);
        jSONArray.add((Object)tuple3d.y);
        jSONArray.add((Object)tuple3d.z);
        return jSONArray;
    }

    protected static JSONArray toArray(Tuple2d tuple2d) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)tuple2d.x);
        jSONArray.add((Object)tuple2d.y);
        return jSONArray;
    }

    protected static JSONArray toArray(Color color) {
        JSONArray jSONArray = new JSONArray();
        float[] fArray = new float[4];
        color.getComponents(fArray);
        jSONArray.add((Object)Float.valueOf(fArray[0]));
        jSONArray.add((Object)Float.valueOf(fArray[1]));
        jSONArray.add((Object)Float.valueOf(fArray[2]));
        jSONArray.add((Object)Float.valueOf(fArray[3]));
        return jSONArray;
    }

    protected static JSONArray toArray(Matrix4d matrix4d) {
        JSONArray jSONArray = new JSONArray();
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            matrix4d.getRow(i, dArray);
            jSONArray.add((Object)dArray[0]);
            jSONArray.add((Object)dArray[1]);
            jSONArray.add((Object)dArray[2]);
            jSONArray.add((Object)dArray[3]);
        }
        return jSONArray;
    }
}

