/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.geom.Geometry;
import pyrosim.gui.comboboxes.GridComboBox;
import pyrosim.gui.grid.RefineMeshDlg;
import pyrosim.gui.grid.SplitMeshDlg;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ActionsMesh {
    private static final UnitDouble UD_ZERO = new UnitDouble(0.0, SI.METER);

    private static UnitDouble getExtent(UnitDouble[] unitDoubleArray) {
        UnitDouble unitDouble = UD_ZERO;
        for (UnitDouble unitDouble2 : unitDoubleArray) {
            unitDouble = unitDouble == UD_ZERO ? unitDouble2 : unitDouble.add(unitDouble2);
        }
        return unitDouble;
    }

    private static List<Grid> getSelectedMeshes(PyroSimSelectionModel pyroSimSelectionModel) {
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(pyroSimSelectionModel.getSelected(IPyroObject.class, Grid.class, GridList.class));
        ArrayList<Grid> arrayList2 = new ArrayList<Grid>();
        for (IPyroObject iPyroObject : arrayList) {
            if (iPyroObject instanceof Grid) {
                arrayList2.add((Grid)iPyroObject);
                continue;
            }
            if (!(iPyroObject instanceof GridList)) continue;
            arrayList2.addAll(((GridList)iPyroObject).flatten());
        }
        return arrayList2;
    }

    private static List<IMeasurementStat> getDependingStats(Grid grid, DepSnapshot depSnapshot) {
        ArrayList<IMeasurementStat> arrayList = new ArrayList<IMeasurementStat>();
        depSnapshot.takeSnapshot(grid);
        for (Dependency dependency : depSnapshot.getDependents(grid)) {
            IMeasurementStat iMeasurementStat;
            IDirectDependent iDirectDependent = dependency.source;
            if (!(iDirectDependent instanceof IMeasurementStat) || !((iMeasurementStat = (IMeasurementStat)((Object)iDirectDependent)).getMsrGeom() instanceof StatGeom.GridGeom)) continue;
            arrayList.add(iMeasurementStat);
        }
        return arrayList;
    }

    private static class MeshChooserDlg
    extends guiDialog {
        private static final long serialVersionUID = 7314096068036393842L;
        private GridComboBox d_cbMeshes;

        public MeshChooserDlg(Window window, String string, GridList gridList, final Collection<Grid> collection) {
            super(window, string, 9);
            this.d_cbMeshes = new GridComboBox(gridList);
            this.d_cbMeshes.setFilter(new Predicate<Grid>(){

                @Override
                public boolean test(Grid grid) {
                    return collection.contains(grid);
                }
            });
            GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
            gridBagHelper.addFilledRow(new guiLabel(Intl.intl("The selected meshes have different cell sizes.")));
            gridBagHelper.addRow(new guiLabel(Intl.intl("Use Cell Size from Mesh: ")), this.d_cbMeshes);
        }

        public Grid getSelectedMesh() {
            return (Grid)this.d_cbMeshes.getSelectedItem();
        }
    }

    private static class ReplaceGridReferenceTask
    extends AUndoableTask {
        private final IMeasurementStat d_stat;
        private final Grid d_grid;

        public ReplaceGridReferenceTask(IMeasurementStat iMeasurementStat, Grid grid) {
            this.d_stat = iMeasurementStat;
            this.d_grid = grid;
        }

        @Override
        public void undo() {
            this.d_stat.setGeom(GeomNodeUtil.newNode(new StatGeom.GridGeom(this.d_grid)));
        }

        @Override
        public void run() {
            this.d_stat.setGeom(GeomNodeUtil.newNode(new AABoxGeom(this.d_grid.getBounds())));
        }
    }

    public static class MergeMeshAction
    extends guiAction {
        private static final long serialVersionUID = -4791693111614498239L;
        private static final ImageIcon ICON = null;

        public MergeMeshAction() {
            super(Intl.intl("Merge Meshes"), ICON);
        }

        public static boolean isMergeOptionAvailable(PyroSimSelectionModel pyroSimSelectionModel) {
            IFilteredCollection<IPyroObject> iFilteredCollection = pyroSimSelectionModel.getSelected(IPyroObject.class, Grid.class, GridList.class);
            return iFilteredCollection.isExclusive() && 1 < ActionsMesh.getSelectedMeshes(pyroSimSelectionModel).size();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            UnitDouble[] unitDoubleArray;
            Object object32;
            Object object4;
            Cloneable cloneable;
            Serializable serializable;
            Object object52;
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
            List list = ActionsMesh.getSelectedMeshes(pyroSimSelectionModel);
            AABox aABox = null;
            for (Grid grid : list) {
                if (aABox == null) {
                    aABox = new AABox(grid.getBounds());
                    continue;
                }
                aABox.add(grid.getBounds());
            }
            double d = 1.0E-6;
            byte by = 0;
            for (Object object52 : list) {
                serializable = object52.getBounds();
                if (!theUtil.eq0(((AABox)serializable).getMinX() - aABox.getMinX(), d) || !theUtil.eq0(((AABox)serializable).getMaxX() - aABox.getMaxX(), d)) {
                    by = (byte)(by | 1);
                }
                if (!theUtil.eq0(((AABox)serializable).getMinY() - aABox.getMinY(), d) || !theUtil.eq0(((AABox)serializable).getMaxY() - aABox.getMaxY(), d)) {
                    by = (byte)(by | 2);
                }
                if (theUtil.eq0(((AABox)serializable).getMinZ() - aABox.getMinZ(), d) && theUtil.eq0(((AABox)serializable).getMaxZ() - aABox.getMaxZ(), d)) continue;
                by = (byte)(by | 4);
            }
            if (by != 0 && (by & by - 1) != 0) {
                JOptionPane.showMessageDialog(pyroSim.getMainFrame(), Intl.intl("Unable to merge meshes.\nMeshes differ in more than one axis."), Intl.intl("Error"), 2);
                return;
            }
            Object object6 = new boolean[]{true, true, true};
            object52 = new boolean[]{true, true, true};
            serializable = null;
            for (Grid grid : list) {
                if (serializable == null) {
                    serializable = this.getCellSize(grid, (boolean[])object52);
                    continue;
                }
                UnitPoint3D unitPoint3D = this.getCellSize(grid, (boolean[])object52);
                Object object7 = object6;
                object7[0] = object7[0] & (object52[0] != false && ((UnitPoint3D)serializable).xu().diff(unitPoint3D.xu()).getValue(SI.METER) <= d ? 1 : 0);
                Object object8 = object6;
                object8[1] = object8[1] & (object52[1] != false && ((UnitPoint3D)serializable).yu().diff(unitPoint3D.yu()).getValue(SI.METER) <= d ? 1 : 0);
                Object object9 = object6;
                object9[2] = object9[2] & (object52[2] != false && ((UnitPoint3D)serializable).zu().diff(unitPoint3D.zu()).getValue(SI.METER) <= d ? 1 : 0);
            }
            final byte by2 = by;
            Collections.sort(list, new Comparator<Grid>(){

                @Override
                public int compare(Grid grid, Grid grid2) {
                    if ((by2 & 1) != 0) {
                        return Double.compare(grid.getMinPoint().x(SI.METER), grid2.getMinPoint().x(SI.METER));
                    }
                    if ((by2 & 2) != 0) {
                        return Double.compare(grid.getMinPoint().y(SI.METER), grid2.getMinPoint().y(SI.METER));
                    }
                    if ((by2 & 4) != 0) {
                        return Double.compare(grid.getMinPoint().z(SI.METER), grid2.getMinPoint().z(SI.METER));
                    }
                    return 0;
                }
            });
            byte by3 = 0;
            for (int i = 1; i < list.size(); ++i) {
                cloneable = ((Grid)list.get(i - 1)).getBounds();
                AABox aABox2 = ((Grid)list.get(i)).getBounds();
                by3 = (byte)(by3 | (d < Math.abs(aABox2.getMinX() - ((AABox)cloneable).getMaxX()) ? (byte)1 : 0));
                by3 = (byte)(by3 | (d < Math.abs(aABox2.getMinY() - ((AABox)cloneable).getMaxY()) ? 2 : 0));
                by3 = (byte)(by3 | (d < Math.abs(aABox2.getMinZ() - ((AABox)cloneable).getMaxZ()) ? 4 : 0));
            }
            if ((by & by3) != 0) {
                JOptionPane.showMessageDialog(pyroSim.getMainFrame(), Intl.intl("Unable to merge meshes.\nMeshes must be adjacent."), Intl.intl("Error"), 2);
                return;
            }
            String string = String.format(Intl.intl("%s-merged"), ((Grid)list.get(0)).getName());
            cloneable = new Grid(string, (Grid.GridGeom)((Grid)list.get(0)).getGeom().getLocalGeom());
            for (int i = 1; i < list.size(); ++i) {
                object4 = cloneable;
                object32 = (Grid)list.get(i);
                unitDoubleArray = (by & 1) == 0 ? ((Grid)object4).getXDivisions() : this.merge(((Grid)object4).getXDivisions(), ((Grid)object32).getXDivisions());
                object2 = (by & 2) == 0 ? ((Grid)object4).getYDivisions() : this.merge(((Grid)object4).getYDivisions(), ((Grid)object32).getYDivisions());
                object = (by & 4) == 0 ? ((Grid)object4).getZDivisions() : this.merge(((Grid)object4).getZDivisions(), ((Grid)object32).getZDivisions());
                Cloneable cloneable2 = this.getUnifiedBounds(Arrays.asList(object4, object32));
                UnitPoint3D unitPoint3D = new UnitPoint3D(((AABox)cloneable2).getMin(), (Unit)SI.METER);
                UnitPoint3D unitPoint3D2 = new UnitPoint3D(((AABox)cloneable2).getMax(), (Unit)SI.METER);
                cloneable = new Grid(((NamedPyroObject)cloneable).getName(), unitPoint3D, unitPoint3D2, unitDoubleArray, (UnitDouble[])object2, (UnitDouble[])object);
            }
            LinkedHashSet<GridList> linkedHashSet = new LinkedHashSet<GridList>();
            for (Object object32 : list) {
                linkedHashSet.add((GridList)((APyroObject)object32).getParent());
            }
            object4 = (GridList)linkedHashSet.iterator().next();
            object32 = null;
            if (linkedHashSet.size() == 1 && ((Composite)object4).flatten().size() == list.size()) {
                object32 = object4;
            }
            unitDoubleArray = pyroMod.getDependencies(list);
            object2 = new ArrayList();
            for (Cloneable cloneable2 : list) {
                object2.addAll(ActionsMesh.getDependingStats((Grid)cloneable2, (DepSnapshot)unitDoubleArray));
            }
            object = new CompositeTask<PyroMod>(pyroMod);
            ((CompositeTask)object).addTask(Tasks.delete(list));
            if (object32 != null && object32 != pyroMod.getGridManager()) {
                if (pyroMod.getGridManager().getAll(((NamedPyroObject)object32).getName()).isEmpty()) {
                    ((NamedPyroObject)cloneable).setName(((NamedPyroObject)object32).getName());
                }
                ((CompositeTask)object).addTask(Tasks.delete(new IPyroObject[]{object32}));
            }
            ((CompositeTask)object).addTask(new AddTask((IPyroObject)pyroMod.getGridManager(), new IPyroObject[]{cloneable}));
            ((CompositeTask)object).addTask(new SelectTask(pyroMod, cloneable));
            object2.forEach(arg_0 -> MergeMeshAction.lambda$actionPerformed$412((CompositeTask)object, arg_0));
            pyroMod.getTaskManager().exec((Task)object, Intl.intl("Merge Meshes"));
        }

        private UnitDouble[] merge(UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2) {
            UnitDouble[] unitDoubleArray3 = new UnitDouble[unitDoubleArray.length + unitDoubleArray2.length];
            System.arraycopy(unitDoubleArray, 0, unitDoubleArray3, 0, unitDoubleArray.length);
            System.arraycopy(unitDoubleArray2, 0, unitDoubleArray3, unitDoubleArray.length, unitDoubleArray2.length);
            return unitDoubleArray3;
        }

        private UnitPoint3D getCellSize(Grid grid, boolean[] blArray) {
            return new UnitPoint3D(this.getDivisionSize(grid.getXDivisions(), blArray, 0), this.getDivisionSize(grid.getYDivisions(), blArray, 1), this.getDivisionSize(grid.getZDivisions(), blArray, 2));
        }

        private UnitDouble getDivisionSize(UnitDouble[] unitDoubleArray, boolean[] blArray, int n) {
            UnitDouble unitDouble = unitDoubleArray[0];
            for (UnitDouble unitDouble2 : unitDoubleArray) {
                if (!(1.0E-6 < unitDouble.diff(unitDouble2).getValue(SI.METER))) continue;
                blArray[n] = false;
                return unitDouble;
            }
            return unitDouble;
        }

        private AABox getUnifiedBounds(Collection<Grid> collection) {
            AABox aABox = null;
            for (Grid grid : collection) {
                if (aABox == null) {
                    aABox = grid.getBounds();
                    continue;
                }
                aABox.add(grid.getBounds());
            }
            return aABox;
        }

        private static /* synthetic */ void lambda$actionPerformed$412(CompositeTask compositeTask, IMeasurementStat iMeasurementStat) {
            compositeTask.addTask(new ReplaceGridReferenceTask(iMeasurementStat, ((StatGeom.GridGeom)iMeasurementStat.getMsrGeom()).grid));
        }
    }

    public static class RefineMeshAction
    extends guiAction {
        private static final long serialVersionUID = -2817785711358139596L;
        private static final ImageIcon ICON = null;

        public RefineMeshAction() {
            super(Intl.intl("Refine Mesh..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
            List list = ActionsMesh.getSelectedMeshes(pyroSimSelectionModel);
            LinkedHashSet<Grid> linkedHashSet = new LinkedHashSet<Grid>(pyroMod.getGridManager().flatten());
            linkedHashSet.removeAll(list);
            RefineMeshDlg refineMeshDlg = new RefineMeshDlg((Window)pyroSim.getMainFrame(), list, linkedHashSet);
            if (refineMeshDlg.doModal() == 1) {
                if (refineMeshDlg.isCoarsen()) {
                    int n;
                    boolean bl = true;
                    for (Grid grid : list) {
                        bl &= this.isUniform(grid, 1.0E-6);
                    }
                    if (!bl && (n = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to maintain non-uniform meshes after coarsen.\nMeshes will become uniform. Continue?"), Intl.intl("Warning"), 2)) != 0) {
                        return;
                    }
                }
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
                double d = refineMeshDlg.getValue();
                for (Grid grid : list) {
                    compositeTask.addTask(grid.taskRefine(d));
                }
                pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Refine Mesh"));
            }
        }

        private boolean isUniform(Grid grid, double d) {
            return this.isUniform(grid.getXDivisions(), d) && this.isUniform(grid.getYDivisions(), d) && this.isUniform(grid.getZDivisions(), d);
        }

        private boolean isUniform(UnitDouble[] unitDoubleArray, double d) {
            for (int i = 1; i < unitDoubleArray.length; ++i) {
                if (!(d < unitDoubleArray[i - 1].diff(unitDoubleArray[i]).getValue(SI.METER))) continue;
                return false;
            }
            return true;
        }
    }

    public static class SplitMeshAction
    extends guiAction {
        private static final long serialVersionUID = 4559122283493869453L;
        private static final ImageIcon ICON = null;

        public SplitMeshAction() {
            super(Intl.intl("Split Mesh..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Task task;
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
            List list = ActionsMesh.getSelectedMeshes(pyroSimSelectionModel);
            AABox aABox = GeomUtil.getBounds(list);
            SplitMeshDlg splitMeshDlg = new SplitMeshDlg((Window)pyroSim.getMainFrame(), pyroSim.getUnitSystem(), aABox);
            if (splitMeshDlg.doModal() == 1 && (task = SplitMeshAction.taskSplitMeshes(list, pyroMod.getDependencies(list), Arrays.asList(new Pair<Geometry.Axis, UnitDouble>(splitMeshDlg.getAxis(), splitMeshDlg.getValue())))) != null) {
                pyroMod.getTaskManager().exec(task, Intl.intl("Split Mesh"));
            }
        }

        public static Task taskSplit(List<Grid> list, List<Plane3d> list2, DepSnapshot depSnapshot) {
            ArrayList<Pair<Geometry.Axis, UnitDouble>> arrayList = new ArrayList<Pair<Geometry.Axis, UnitDouble>>(list2.size());
            for (Plane3d plane3d : list2) {
                Geometry.Axis axis = Geometry.Axis.values()[Util3D.getClosestAxis(plane3d.getNormal())];
                UnitDouble unitDouble = new UnitDouble(-plane3d.w, Geometry.LU);
                arrayList.add(new Pair<Geometry.Axis, UnitDouble>(axis, unitDouble));
            }
            return SplitMeshAction.taskSplitMeshes(list, depSnapshot, arrayList);
        }

        public static Task taskSplitMeshes(List<Grid> list, DepSnapshot depSnapshot, List<Pair<Geometry.Axis, UnitDouble>> list2) {
            boolean bl = false;
            ArrayList<NamedPyroObject> arrayList = new ArrayList<NamedPyroObject>();
            ArrayList<UnitDouble> arrayList2 = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> arrayList3 = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> arrayList4 = new ArrayList<UnitDouble>();
            for (Pair<Geometry.Axis, UnitDouble> object2 : list2) {
                switch ((Geometry.Axis)((Object)object2.v1)) {
                    case X: {
                        arrayList2.add((UnitDouble)object2.v2);
                        break;
                    }
                    case Y: {
                        arrayList3.add((UnitDouble)object2.v2);
                        break;
                    }
                    case Z: {
                        arrayList4.add((UnitDouble)object2.v2);
                    }
                }
            }
            Collections.sort(arrayList2);
            Collections.sort(arrayList3);
            Collections.sort(arrayList4);
            ArrayList arrayList5 = new ArrayList();
            for (Grid grid : list) {
                List<UnitDouble[]> list3 = Arrays.asList(new UnitDouble[][]{grid.getXDivisions()});
                if (!arrayList2.isEmpty()) {
                    list3 = SplitMeshAction.splitDivisions(grid.getXLinePositions(), arrayList2, 3);
                }
                List<UnitDouble[]> list4 = Arrays.asList(new UnitDouble[][]{grid.getYDivisions()});
                if (!arrayList3.isEmpty()) {
                    list4 = SplitMeshAction.splitDivisions(grid.getYLinePositions(), arrayList3, 3);
                }
                List<UnitDouble[]> list5 = Arrays.asList(new UnitDouble[][]{grid.getZDivisions()});
                if (!arrayList4.isEmpty()) {
                    list5 = SplitMeshAction.splitDivisions(grid.getZLinePositions(), arrayList4, 3);
                }
                List<Grid> list6 = SplitMeshAction.createMeshes(grid.getName(), grid.getMinPoint(), grid.getMaxPoint(), list3, list4, list5);
                assert (!list6.isEmpty());
                if (list6.size() == 1) {
                    arrayList.add(grid);
                    continue;
                }
                GridList gridList = new GridList(grid.getName());
                gridList.addAll(list6);
                arrayList.add(gridList);
                bl = true;
                arrayList5.addAll(ActionsMesh.getDependingStats(grid, depSnapshot));
            }
            if (bl) {
                PyroMod pyroMod = PyroSim.getApp().getMediator();
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
                compositeTask.addTask(Tasks.replace(list, arrayList, true));
                compositeTask.addTask(new SelectTask(pyroMod, arrayList));
                arrayList5.forEach(iMeasurementStat -> compositeTask.addTask(new ReplaceGridReferenceTask((IMeasurementStat)iMeasurementStat, ((StatGeom.GridGeom)iMeasurementStat.getMsrGeom()).grid)));
                return compositeTask;
            }
            JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to split mesh.\nEach side must have at least 3 cells."), Intl.intl("Warning"), 2);
            return null;
        }

        public static int getSplitIndex(UnitDouble[] unitDoubleArray, UnitDouble unitDouble) {
            int n = Arrays.binarySearch(unitDoubleArray, unitDouble);
            if (n < 0 && 0 < (n = -(n + 1)) && n < unitDoubleArray.length && unitDoubleArray[n - 1].diff(unitDouble).compareTo(unitDoubleArray[n].diff(unitDouble)) < 0) {
                --n;
            }
            return n;
        }

        private static List<UnitDouble[]> splitDivisions(UnitDouble[] unitDoubleArray, List<UnitDouble> list, int n) {
            ArrayList<UnitDouble[]> arrayList = new ArrayList<UnitDouble[]>();
            UnitDouble[] unitDoubleArray2 = unitDoubleArray;
            for (int i = 0; i < list.size(); ++i) {
                List<UnitDouble[]> list2 = SplitMeshAction.splitLines(unitDoubleArray2, list.get(i), n);
                if (list2.size() <= 1) continue;
                arrayList.add(SplitMeshAction.convertPositionsToDivs(list2.get(0)));
                unitDoubleArray2 = list2.get(1);
            }
            arrayList.add(SplitMeshAction.convertPositionsToDivs(unitDoubleArray2));
            return arrayList;
        }

        private static UnitDouble[] convertPositionsToDivs(UnitDouble[] unitDoubleArray) {
            if (unitDoubleArray.length < 2) {
                return new UnitDouble[0];
            }
            UnitDouble[] unitDoubleArray2 = new UnitDouble[unitDoubleArray.length - 1];
            for (int i = 0; i < unitDoubleArray.length - 1; ++i) {
                UnitDouble unitDouble = unitDoubleArray[i];
                UnitDouble unitDouble2 = unitDoubleArray[i + 1];
                unitDoubleArray2[i] = unitDouble2.sub(unitDouble);
            }
            return unitDoubleArray2;
        }

        private static List<UnitDouble[]> splitLines(UnitDouble[] unitDoubleArray, UnitDouble unitDouble, int n) {
            int n2 = SplitMeshAction.getSplitIndex(unitDoubleArray, unitDouble);
            if (n <= n2 && n2 <= unitDoubleArray.length - 1 - n) {
                UnitDouble[] unitDoubleArray2 = new UnitDouble[n2 + 1];
                UnitDouble[] unitDoubleArray3 = new UnitDouble[unitDoubleArray.length - n2];
                System.arraycopy(unitDoubleArray, 0, unitDoubleArray2, 0, unitDoubleArray2.length);
                System.arraycopy(unitDoubleArray, n2, unitDoubleArray3, 0, unitDoubleArray3.length);
                return Arrays.asList(unitDoubleArray2, unitDoubleArray3);
            }
            return Arrays.asList(new UnitDouble[][]{unitDoubleArray});
        }

        private static List<Grid> createMeshes(String string, UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, List<UnitDouble[]> list, List<UnitDouble[]> list2, List<UnitDouble[]> list3) {
            ArrayList<Grid> arrayList = new ArrayList<Grid>();
            int n = 0;
            UnitPoint3D unitPoint3D3 = unitPoint3D;
            for (UnitDouble[] unitDoubleArray : list) {
                UnitDouble unitDouble = ActionsMesh.getExtent(unitDoubleArray);
                for (UnitDouble[] unitDoubleArray2 : list2) {
                    UnitDouble unitDouble2 = ActionsMesh.getExtent(unitDoubleArray2);
                    for (UnitDouble[] unitDoubleArray3 : list3) {
                        UnitDouble unitDouble3 = ActionsMesh.getExtent(unitDoubleArray3);
                        UnitPoint3D unitPoint3D4 = unitPoint3D3.add(new UnitPoint3D(unitDouble, unitDouble2, unitDouble3));
                        String string2 = String.format("%s-%s", string, Character.valueOf((char)(97 + n++)));
                        arrayList.add(new Grid(string2, unitPoint3D3, unitPoint3D4, unitDoubleArray, unitDoubleArray2, unitDoubleArray3));
                        unitPoint3D3 = new UnitPoint3D(unitPoint3D3.xu(), unitPoint3D3.yu(), unitPoint3D3.zu().add(unitDouble3));
                    }
                    unitPoint3D3 = new UnitPoint3D(unitPoint3D3.xu(), unitPoint3D3.yu().add(unitDouble2), unitPoint3D.zu());
                }
                unitPoint3D3 = new UnitPoint3D(unitPoint3D3.xu().add(unitDouble), unitPoint3D.yu(), unitPoint3D.zu());
            }
            return arrayList;
        }
    }
}

