/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Accelerators;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimSelectionModel;
import pyrosim.WriteProtect;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.GridUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IImplicitGeomSrc;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.DepUtil;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.CableFailDetector;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.AddGridBoundaryVentsTask;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ExplodeTask;
import pyrosim.domain.tasks.FilterGeomTask;
import pyrosim.domain.tasks.GroupGeomTask;
import pyrosim.domain.tasks.InsertAdditionalRecordsTask;
import pyrosim.domain.tasks.RasterizeTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.domain.tasks.ReplacePreserveTask;
import pyrosim.domain.tasks.SelectByColorTask;
import pyrosim.domain.tasks.SelectReferencingObjTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.SetEnabledSomeObjsTask;
import pyrosim.domain.tasks.SetForceWriteTask;
import pyrosim.domain.tasks.ShowAllGeomTask;
import pyrosim.domain.tasks.ShowSomeGeomTask;
import pyrosim.domain.tasks.SortByNameTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.geom.Geometry;
import pyrosim.gui.CancelledException;
import pyrosim.gui.ClusterFDSDlg;
import pyrosim.gui.ConvertCadLinesDlg;
import pyrosim.gui.ExSpecManagerDlg;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.HvacManagerDlg;
import pyrosim.gui.LibraryDlg;
import pyrosim.gui.NewGroupDialog;
import pyrosim.gui.OpenMpDlg;
import pyrosim.gui.PyroFindDlg;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.ReplaceDlg;
import pyrosim.gui.SimulationPropertiesDlg;
import pyrosim.gui.TimeHistoryPlotDlg;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.gui.actions.ActionListBuilder;
import pyrosim.gui.actions.ActionsMesh;
import pyrosim.gui.actions.AspiratorSamplerValidation;
import pyrosim.gui.actions.ExposedOverlapValidation;
import pyrosim.gui.actions.FlameConditionValidation;
import pyrosim.gui.actions.ImportAction;
import pyrosim.gui.actions.VentCollapseValidation;
import pyrosim.gui.actions.ViewActions;
import pyrosim.gui.appearance.MaterialDlg;
import pyrosim.gui.boundcond.MaterialManagerDlg;
import pyrosim.gui.boundcond.SurfaceManagerDlg;
import pyrosim.gui.controls.ControlDlg;
import pyrosim.gui.devices.DevcEditorFactory;
import pyrosim.gui.devices.DeviceDlg;
import pyrosim.gui.devices.GasPointDevcEditor;
import pyrosim.gui.devices.HeatLinkModelManagerDlg;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.SmokeLinkModelMgrDlg;
import pyrosim.gui.devices.SprayModelManagerDlg;
import pyrosim.gui.devices.SprinklerLinkModelManagerDlg;
import pyrosim.gui.fds.ArchiveResultsDlg;
import pyrosim.gui.fds.RestoreResultsDlg;
import pyrosim.gui.geom.GroupChooserDlg;
import pyrosim.gui.geom.MirrorDialog;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.RasterizationPropsDlg;
import pyrosim.gui.geom.RotateDialog;
import pyrosim.gui.geom.ScaleDialog;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.gui.geom.TranslateDialog;
import pyrosim.gui.grid.GridManagerDlg;
import pyrosim.gui.output.BoundariesDlg;
import pyrosim.gui.output.IsofDialog;
import pyrosim.gui.output.Plot3dDlg;
import pyrosim.gui.output.ProfListDlg;
import pyrosim.gui.output.Slcf3dDialog;
import pyrosim.gui.output.SlcfDialog;
import pyrosim.gui.output.StatisticsDlg;
import pyrosim.gui.particle.ParticleManagerDlg;
import pyrosim.gui.reaction.ReactionManagerDlg;
import pyrosim.gui.reaction.SetNewActiveSimpleReacDlg;
import pyrosim.gui.tasks.SimulationTask;
import pyrosim.gui.view.SectionBoxDlg;
import pyrosim.gui.zones.ZoneDlg;
import pyrosim.io.IOUtil;
import pyrosim.io.PyroDataContainer;
import pyrosim.io.PyroSimObjectOutputStream;
import pyrosim.io.TimeHistoryData;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiExceptionError;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiSimpleError;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.Task;
import thunderheadeng.util.TaskManager;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class Actions {
    public static final int FDSFILE_INPUT = 0;
    public static final int FDSFILE_OUTPUT = 1;
    public static final int FDSFILE_SMOKEVIEW = 2;
    public static final int FDSFILE_HRR = 3;
    public static final int FDSFILE_DEVC = 4;
    public static final int FDSFILE_CTRL = 5;
    private static final Hashtable<String, ImageIcon> ICONS = new Hashtable();
    public static DataFlavor PYRO_DATA_FLAVOR = new DataFlavor(PyroDataContainer.class, "Mixed PyroSim Data");
    public static DataFlavor FDS_DATA_FLAVOR = DataFlavor.stringFlavor;
    public static final ProtectAction PROTECT_ACTION = new ProtectAction();
    public static final AddGroupAction CONTEXT_ADD_GROUP_ACTION = new AddGroupAction(true);
    public static final AddGroupAction GLOBAL_ADD_GROUP_ACTION = new AddGroupAction(false);
    public static final ChangeGroupAction CHANGE_GROUP = new ChangeGroupAction();
    public static final Action TRANSLATE_ACTION = new TranslateAction();
    public static final Action MIRROR_ACTION = new MirrorAction();
    public static final Action SCALE_ACTION = new ScaleAction();
    public static final Action ROTATE_ACTION = new RotateAction();
    public static final AddWallAction ADD_WALL_ACTION = new AddWallAction();
    public static final AddVentAction ADD_VENT_ACTION = new AddVentAction();
    public static final AddSlabAction ADD_SLAB_ACTION = new AddSlabAction();
    public static final AddHoleAction ADD_HOLE_ACTION = new AddHoleAction();
    public static final AddPartCloudAction ADD_PART_CLOUD_ACTION = new AddPartCloudAction();
    public static final AddPartLocationAction ADD_PART_LOC_ACTION = new AddPartLocationAction();
    public static final AddInitRegionAction ADD_INIT_REGION_ACTION = new AddInitRegionAction();
    public static final AddHvacDuctAction ADD_HVAC_DUCT_ACTION = new AddHvacDuctAction();
    public static final AddHvacNodeAction ADD_HVAC_NODE_ACTION = new AddHvacNodeAction();
    public static final RasterizeObjectsAction RASTERIZE_OBJECTS_ACTION = new RasterizeObjectsAction();
    public static final ExplodeAction EXPLODE_ACTION = new ExplodeAction();
    public static final GroupGeomAction GROUP_GEOM_ACTION = new GroupGeomAction();
    public static final AddHvacVentNode ADD_HVAC_VENT_NODES = new AddHvacVentNode();
    public static final ConnectWithHvac CONNECT_WITH_HVAC = new ConnectWithHvac();
    public static final ExtrudeLinesAction EXTRUDE_LINES = new ExtrudeLinesAction();
    public static final FindObjectsAction FIND_ACTION = new FindObjectsAction();
    public static final ViewActions.AddViewAction CONTEXT_ADD_VIEW = new ViewActions.AddViewAction(true);
    public static final ViewActions.AddViewAction GLOBAL_ADD_VIEW = new ViewActions.AddViewAction(false);
    public static final ViewActions.SetActiveViewAction SET_ACTIVE_VIEW_ACTION = new ViewActions.SetActiveViewAction();
    public static final ViewActions.AddSectionBox CONTEXT_ADD_SECTION_BOX = new ViewActions.AddSectionBox(true);
    public static final ViewActions.AddSectionBox GLOBAL_ADD_SECTION_BOX = new ViewActions.AddSectionBox(false);
    public static final ViewActions.ResetSectionBox CONTEXT_RESET_SECTION_BOX = new ViewActions.ResetSectionBox(true);
    public static final ViewActions.ResetSectionBox GLOBAL_RESET_SECTION_BOX = new ViewActions.ResetSectionBox(false);
    public static final ViewActions.SaveViewpoint CONTEXT_SAVE_VIEW_CAMERA = new ViewActions.SaveViewpoint(true);
    public static final ViewActions.SaveViewpoint GLOBAL_SAVE_VIEW_CAMERA = new ViewActions.SaveViewpoint(false);
    public static final ViewActions.ShowViewpoint CONTEXT_SHOW_VIEW_CAMERA = new ViewActions.ShowViewpoint(true);
    public static final ViewActions.ShowViewpoint GLOBAL_SHOW_VIEW_CAMERA = new ViewActions.ShowViewpoint(false);
    public static final ViewActions.CreationSection CREATE_SECTION = new ViewActions.CreationSection();
    public static final ViewActions.DuplicateView DUPLICATE_VIEW = new ViewActions.DuplicateView();
    public static final SetObstOptionAction WRITE_AS_GEOM = new SetObstOptionAction("Write as GEOM", 128, true);
    public static final SetObstOptionAction WRITE_AS_OBST = new SetObstOptionAction("Write as OBST", 128, false);
    public static final UndoAction UNDO_ACTION = new UndoAction();
    public static final RedoAction REDO_ACTION = new RedoAction();
    public static final CopyAction COPY_ACTION = new CopyAction();
    public static final CopyFDSRecordsAction COPY_FDS_ACTION = new CopyFDSRecordsAction();
    public static final GridAction GRID_ACTION = new GridAction();
    public static final ZonesAction ZONES_ACTION = new ZonesAction();
    public static final ControlsAction CONTROLS_ACTION = new ControlsAction();
    public static final CutAction CUT_ACTION = new CutAction();
    public static final EditSelectedNodeAction EDIT_SELECTED_NODE_ACTION = new EditSelectedNodeAction();
    public static final ChangeEnabledNodeAction ENABLE_NODE_ACTION = new ChangeEnabledNodeAction(Intl.intl("Enable Object(s)"), true);
    public static final ChangeEnabledNodeAction DISABLE_NODE_ACTION = new ChangeEnabledNodeAction(Intl.intl("Disable Object(s)"), false);
    public static final HideNodeAction HIDE_NODE_ACTION = new HideNodeAction();
    public static final HideUnselectedNodeAction HIDE_UNSELECTED_NODE_ACTION = new HideUnselectedNodeAction();
    public static final PasteAction PASTE_ACTION = new PasteAction();
    public static final RemoveSelectedNodeAction REMOVE_SELECTED_NODE_ACTION = new RemoveSelectedNodeAction();
    public static final ShowAllNodesAction SHOW_ALL_NODES_ACTION = new ShowAllNodesAction();
    public static final ShowNodeAction SHOW_NODE_ACTION = new ShowNodeAction();
    public static final AddFloorFromGeomAction ADD_FLOOR_FROM_GEOM_ACTION = new AddFloorFromGeomAction();
    public static final OpenGridsAction OPEN_GRIDS_ACTION = new OpenGridsAction();
    public static final MaterialManagerAction MATERIAL_MANAGER_ACTION = new MaterialManagerAction();
    public static final SurfaceManagerAction SURFACE_MANAGER_ACTION = new SurfaceManagerAction();
    public static final AppearanceManagerAction APPEARANCE_MANAGER_ACTION = new AppearanceManagerAction();
    public static final ReactionManagerAction REACTION_MANAGER_ACTION = new ReactionManagerAction();
    public static final SprayModelManagerAction SPRAY_MODEL_MANAGER_ACTION = new SprayModelManagerAction();
    public static final SprinklerLinkModelManagerAction SPRINKLER_LINK_MODEL_MANAGER_ACTION = new SprinklerLinkModelManagerAction();
    public static final HeatLinkModelManagerAction HEAT_LINK_MODEL_MANAGER_ACTION = new HeatLinkModelManagerAction();
    public static final SelectRefObjectsAction SELECT_REFERENCING_OBJECTS_ACTION = new SelectRefObjectsAction();
    public static final SelectByColorAction SELECT_BY_COLOR_ACTION = new SelectByColorAction();
    public static final EditSimulationPropertiesAction EDIT_SIMULATION_PROPERTIES_ACTION = new EditSimulationPropertiesAction();
    public static final ParticleAction PARTICLE_ACTION = new ParticleAction();
    public static final SmodLinkModelsAction SMOD_MODELS_ACTION = new SmodLinkModelsAction();
    public static final ExSpecListAction EXSPEC_LIST_ACTION = new ExSpecListAction();
    public static final RunFDSAction RUN_FDS_ACTION = new RunFDSAction();
    public static final ResumeFDSAction RESUME_FDS_ACTION = new ResumeFDSAction();
    public static final RunFDSmpiAction RUN_FDS_MPI_ACTION = new RunFDSmpiAction();
    public static final ResumeFDSmpiAction RESUME_FDS_MPI_ACTION = new ResumeFDSmpiAction();
    public static final RunFDSClusterAction RUN_FDS_CLUSTER_ACTION = new RunFDSClusterAction();
    public static final ResumeFDSClusterAction RESUME_FDS_CLUSTER_ACTION = new ResumeFDSClusterAction();
    public static final RunResultsAction RUN_SMOKEVIEW_ACTION = new RunResultsAction(Intl.intl("Run Smokeview..."), null, file -> FDSRunMonitor.showResults(FDSRunMonitor.ResultsApp.SMOKEVIEW, null, file));
    public static final RunResultsAction RUN_RESULTS_ACTION = new RunResultsAction(Intl.intl("Run Results..."), (Icon)PyroGuiUtil.loadPyroSimIcon("burn16.png"), file -> FDSRunMonitor.showResults(FDSRunMonitor.ResultsApp.RESULTS, null, file));
    public static final Results3dAction VIEW_RESULTS_ACTION = new Results3dAction();
    public static final TimeHistoryResultsAction VIEW_HRR_RESULTS_ACTION = new TimeHistoryResultsAction(Intl.intl("Plot Thermal Results"), (Icon)PyroGuiUtil.loadPyroSimIcon("burn16.png", 8), 3);
    public static final TimeHistoryResultsAction VIEW_DEVC_RESULTS_ACTION = new TimeHistoryResultsAction(Intl.intl("Plot Device Results"), (Icon)PyroGuiUtil.loadPyroSimIcon("smoke.png", 8), 4);
    public static final TimeHistoryResultsAction VIEW_CTRL_RESULTS_ACTION = new TimeHistoryResultsAction(Intl.intl("Plot Control Results"), (Icon)PyroGuiUtil.loadPyroSimIcon("or16.png", 8), 5);
    public static final ResultsPreviewAction RESULTS_PREVIEW_ACTION = new ResultsPreviewAction();
    public static final TCPlotsAction TC_PLOTS_ACTION = new TCPlotsAction();
    public static final ArchiveResultsAction ARCHIVE_RESULTS = new ArchiveResultsAction();
    public static final RestoreResultsAction RESTORE_RESULTS = new RestoreResultsAction();
    public static final SetReactionAction SET_REACTION_ACTION = new SetReactionAction();
    public static final ClearReactionAction CLEAR_REACTION_ACTION = new ClearReactionAction();
    public static final SetBackgroundSpecAction SET_BACKGROUND_ACTION = new SetBackgroundSpecAction();
    public static final ClearBackgroundSpecAction CLEAR_BACKGROUND_ACTION = new ClearBackgroundSpecAction();
    public static final SetAsDefaultSurfAction SET_DEFAULT_SURFACE_ACTION = new SetAsDefaultSurfAction();
    public static final EnableForceToWriteAction ENABLE_FORCE_TO_WRITE_ACTION = new EnableForceToWriteAction();
    public static final DisableForceToWriteAction DISABLE_FORCE_TO_WRITE_ACTION = new DisableForceToWriteAction();
    public static final EditHvac EDIT_HVAC = new EditHvac();
    public static final CrashAction CRASH_PYROSIM = new CrashAction();
    public static final EditOpenMpAction EDIT_OPENMP_ACTION = new EditOpenMpAction();
    public static final SelectHvacNetwork SELECT_HVAC_NETWORK = new SelectHvacNetwork();
    public static final guiAction SPLIT_MESH_ACTION = new ActionsMesh.SplitMeshAction();
    public static final guiAction REFINE_MESH_ACTION = new ActionsMesh.RefineMeshAction();
    public static final guiAction MERGE_MESH_ACTION = new ActionsMesh.MergeMeshAction();
    public static final EditLibAction EDIT_LIBRARIES_ACTION = new EditLibAction();
    public static final NewDeviceAction NEW_GAS_POINT_DEVICES_ACTION = new NewDeviceAction<GasPointMeasurer>(Intl.intl("New Gas-phase Device..."), GasPointMeasurer.class, 0);
    public static final NewDeviceAction NEW_SOLID_POINT_DEVICES_ACTION = new NewDeviceAction<SolidPointMeasurer>(Intl.intl("New Solid-phase Device..."), SolidPointMeasurer.class, 0);
    public static final NewDeviceAction NEW_THERMOCOUPLE_ACTION = new NewDeviceAction<Thermocouple>(Intl.intl("New Thermocouple..."), Thermocouple.class, 0);
    public static final NewDeviceAction<GasPointMeasurer> NEW_TIME_DEVC_ACTION = new NewDeviceAction<GasPointMeasurer>(Intl.intl("New Time Device..."), GasPointMeasurer.class, null, pyroMod -> new GasPointDevcEditor((PyroMod)pyroMod, Intl.intl("Time"), Intl.intl("Time"), Quantity.TIME.create(), IDevcEditor.Mode.CREATE));
    public static final NewDeviceAction NEW_PATH_OBSCURATION_MEASURER_ACTION = new NewDeviceAction<PathObscurationMeasurer>(Intl.intl("New Beam Detector Device..."), PathObscurationMeasurer.class, 0);
    public static final NewDeviceAction NEW_LAYER_INFORMATION_MEASURER_ACTION = new NewDeviceAction<LayerMeasurer>(Intl.intl("New Layer Zoning Device..."), LayerMeasurer.class, 0);
    public static final NewDeviceAction NEW_HEAT_RELEASE_RATE_MEASURER_ACTION = new NewDeviceAction<AABoxMeasurer>(Intl.intl("New Heat Release Rate Device..."), AABoxMeasurer.class, 0);
    public static final NewDeviceAction NEW_FLOW_MEASURER_ACTION = new NewDeviceAction<FlowMeasurer>(Intl.intl("New Flow Measuring Device..."), FlowMeasurer.class, 0);
    public static final NewDeviceAction NEW_ASPIRATOR_ACTION = new NewDeviceAction<Aspirator>(Intl.intl("New Aspirator..."), Aspirator.class, 0);
    public static final NewDeviceAction NEW_ASPIRATOR_SAMPLER_ACTION = new NewDeviceAction<AspiratorSampler>(Intl.intl("New Aspirator Sampler..."), AspiratorSampler.class, 0);
    public static final NewDeviceAction NEW_SMOKE_DETECTOR_ACTION = new NewDeviceAction<SmokeDetector>(Intl.intl("New Smoke Detector..."), SmokeDetector.class, (Icon)Actions.createIcon("pyrosim/icons/smoke.png"), 0);
    public static final NewDeviceAction NEW_HEAT_DETECTOR_DEVICE_ACTION = new NewDeviceAction<HeatDetector>(Intl.intl("New Heat Detector..."), HeatDetector.class, (Icon)Actions.createIcon("pyrosim/icons/heat.png"), 0);
    public static final NewDeviceAction NEW_SPRINKLER_LINK_ACTION = new NewDeviceAction<SprinklerLink>(Intl.intl("New Sprinkler Link..."), SprinklerLink.class, 0);
    public static final NewDeviceAction NEW_NOZZLE_ACTION = new NewDeviceAction<Nozzle>(Intl.intl("New Nozzle..."), Nozzle.class, 0);
    public static final NewDeviceAction NEW_SPRINKLER_DEVICE_ACTION = new NewDeviceAction<Sprinkler>(Intl.intl("New Sprinkler..."), Sprinkler.class, (Icon)Actions.createIcon("pyrosim/icons/sprk2.png"), 0);
    public static final NewDeviceAction NEW_DRY_PIPE_ACTION = new NewDeviceAction<DryPipe>(Intl.intl("New Dry Pipe..."), DryPipe.class, 0);
    @Deprecated
    public static final NewDeviceAction NEW_CABLE_MSR_ACTION = new NewDeviceAction<CableFailDetector>(Intl.intl("New Cable Failure Detector..."), CableFailDetector.class, 0);
    public static final NewDeviceAction NEW_SIMCTRL_ACTION = new NewDeviceAction<ASimCtrlDevice>(Intl.intl("New Sim Control Device..."), ASimCtrlDevice.class, 0);
    public static final NewDeviceAction NEW_HVAC_DUCT_DEVICE_ACTION = new NewDeviceAction<HvacDevice>(Intl.intl("New HVAC Duct Device..."), HvacDevice.class, 0);
    public static final NewDeviceAction NEW_HVAC_NODE_DEVICE_ACTION = new NewDeviceAction<HvacDevice>(Intl.intl("New HVAC Node Device..."), HvacDevice.class, 1);
    public static final BoundaryQuantityAction BOUNDARYQUANTITY_ACTION = new BoundaryQuantityAction();
    public static final Plot3DAction PLOT3D_ACTION = new Plot3DAction();
    public static final IsosurfaceAction ISOSURFACE_ACTION = new IsosurfaceAction();
    public static final SliceAction SLICE_ACTION = new SliceAction();
    public static final Slice3DAction SLICE3D_ACTION = new Slice3DAction();
    public static final ProfListAction PROF_ACTION = new ProfListAction();
    public static final MsrStatsAction MSR_STATS_ACTION = new MsrStatsAction();
    public static final Action SORT_ACTION = new SortAction();
    public static final Action IMPORT_ACTION = new ImportAction();
    private static ActionStateUpdater d_actionStateUpdater;
    private static final List<guiAction> DEFAULT_ACTIONS;
    public static final int PASTEOPT_SELECT_INSERTED_OBJS = 1;
    public static final int PASTEOPT_INSERT_ALL_AS_IMPLICIT = 2;
    public static final int PASTEOPT_INSERT_ALL_AS_EXPLICIT = 4;

    public static void init(PyroMod pyroMod) {
        d_actionStateUpdater = new ActionStateUpdater(pyroMod);
        pyroMod.getEvents().addObserver(d_actionStateUpdater);
        pyroMod.getTaskManager().addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                Actions.updateUndoRedoActions(((PyroSim)Application.getApp()).getMediator());
            }
        });
    }

    public static void applicationActivated(PyroSim pyroSim) {
    }

    public static void updatePasteAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        boolean bl = false;
        for (DataFlavor dataFlavor : Actions.getSupportedPasteFlavors()) {
            if (!clipboard.isDataFlavorAvailable(dataFlavor)) continue;
            bl = true;
            break;
        }
        PASTE_ACTION.setEnabled(bl);
    }

    public static final ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        if (!ICONS.containsKey(string)) {
            ICONS.put(string, new ImageIcon(Actions.class.getClassLoader().getResource(string)));
        }
        return ICONS.get(string);
    }

    private static boolean isExplodable(IGeomNode iGeomNode) {
        return !iGeomNode.getChildren().isEmpty() || Actions.isExplodable(iGeomNode.getLocalGeom());
    }

    private static boolean isExplodable(IGeom iGeom) {
        return iGeom instanceof GeomGroup;
    }

    private static void updateUndoRedoActions(PyroMod pyroMod) {
        UNDO_ACTION.update(pyroMod.getTaskManager());
        REDO_ACTION.update(pyroMod.getTaskManager());
    }

    private static JPopupMenu generateContextMenu(List<Action> list, Action action) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (Action action2 : list) {
            if (action2 != null) {
                JMenuItem jMenuItem = jPopupMenu.add(action2);
                if (action2 != action) continue;
                jMenuItem.setFont(jMenuItem.getFont().deriveFont(1));
                continue;
            }
            jPopupMenu.addSeparator();
        }
        return jPopupMenu;
    }

    public static JPopupMenu getContextMenu(Collection<?> collection) {
        ActionListBuilder actionListBuilder = new ActionListBuilder();
        actionListBuilder.add(CONTEXT_ADD_GROUP_ACTION);
        actionListBuilder.add(Actions.getAddFloorFromGeomAction());
        actionListBuilder.add(CREATE_SECTION);
        actionListBuilder.add(Actions.getSortAction());
        actionListBuilder.addSeparator();
        actionListBuilder.add(CHANGE_GROUP);
        actionListBuilder.add(EXPLODE_ACTION);
        actionListBuilder.add(GROUP_GEOM_ACTION);
        actionListBuilder.add(Actions.getRasterizeAction());
        if (PyroSim.FDS7) {
            actionListBuilder.add(WRITE_AS_GEOM);
            actionListBuilder.add(WRITE_AS_OBST);
        }
        actionListBuilder.add(SELECT_REFERENCING_OBJECTS_ACTION);
        actionListBuilder.add(Actions.getSelectByColorAction());
        actionListBuilder.add(ENABLE_FORCE_TO_WRITE_ACTION);
        actionListBuilder.add(DISABLE_FORCE_TO_WRITE_ACTION);
        actionListBuilder.add(SELECT_HVAC_NETWORK);
        actionListBuilder.add(ADD_HVAC_VENT_NODES);
        actionListBuilder.add(CONNECT_WITH_HVAC);
        actionListBuilder.add(EXTRUDE_LINES);
        actionListBuilder.add(SET_DEFAULT_SURFACE_ACTION);
        actionListBuilder.add(CLEAR_REACTION_ACTION);
        actionListBuilder.add(SET_REACTION_ACTION);
        actionListBuilder.add(CLEAR_BACKGROUND_ACTION);
        actionListBuilder.add(SET_BACKGROUND_ACTION);
        actionListBuilder.addSeparator();
        actionListBuilder.add(CONTEXT_ADD_VIEW);
        actionListBuilder.add(SET_ACTIVE_VIEW_ACTION);
        actionListBuilder.add(CONTEXT_ADD_SECTION_BOX);
        actionListBuilder.add(CONTEXT_RESET_SECTION_BOX);
        actionListBuilder.add(CONTEXT_SAVE_VIEW_CAMERA);
        actionListBuilder.add(CONTEXT_SHOW_VIEW_CAMERA);
        actionListBuilder.add(DUPLICATE_VIEW);
        if (collection.isEmpty()) {
            actionListBuilder.add(GLOBAL_ADD_VIEW);
            actionListBuilder.add(GLOBAL_ADD_SECTION_BOX);
            actionListBuilder.add(GLOBAL_RESET_SECTION_BOX);
            actionListBuilder.add(GLOBAL_SAVE_VIEW_CAMERA);
            actionListBuilder.add(GLOBAL_SHOW_VIEW_CAMERA);
        }
        actionListBuilder.add(Actions.getOpenGridsAction());
        actionListBuilder.add(Actions.getSubdivideMeshAction());
        actionListBuilder.add(Actions.getRefineMeshAction());
        actionListBuilder.add(Actions.getMergeMeshAction());
        actionListBuilder.addSeparator();
        actionListBuilder.add(Actions.getTranslateAction());
        actionListBuilder.add(Actions.getMirrorAction());
        actionListBuilder.add(Actions.getScaleAction());
        actionListBuilder.add(Actions.getRotateAction());
        actionListBuilder.addSeparator();
        actionListBuilder.add(Actions.getCutAction());
        actionListBuilder.add(Actions.getCopyAction());
        actionListBuilder.add(Actions.getCopyFDSAction());
        actionListBuilder.add(Actions.getPasteAction());
        actionListBuilder.add(Actions.getDeleteAction());
        actionListBuilder.addSeparator();
        actionListBuilder.add(Actions.getEnableNodeAction());
        actionListBuilder.add(Actions.getDisableNodeAction());
        actionListBuilder.addSeparator();
        actionListBuilder.add(Actions.getHideNodeAction());
        actionListBuilder.add(Actions.getShowNodeAction());
        actionListBuilder.add(Actions.getHideUnselectedNodeAction());
        actionListBuilder.add(Actions.getShowAllNodesAction());
        actionListBuilder.addSeparator();
        actionListBuilder.add(PyroSim.getApp().getTreeView().getRenameAction());
        actionListBuilder.add(Actions.getEditNodeAction());
        return Actions.generateContextMenu(actionListBuilder.finalizeList(), Actions.getDefaultAction(PyroSim.getApp().getMediator()));
    }

    private static Collection<IPyroObject> getSelectedGeom(PyroMod pyroMod) {
        Predicate<IPyroObject> predicate = new Predicate<IPyroObject>(){

            @Override
            public boolean test(IPyroObject iPyroObject) {
                if (iPyroObject instanceof IPyroGeomSrc) {
                    return true;
                }
                return !Hierarchy.flatten(iPyroObject.getMembers(), IPyroGeomSrc.class).isEmpty();
            }
        };
        return pyroMod.getSelectionModel().getSelected(IPyroObject.class, predicate);
    }

    public static Collection<IPyroObject> getTransformObjs(PyroSim pyroSim, PyroMod pyroMod, Collection<IPyroObject> collection) throws CancellationException {
        Serializable serializable;
        Collection<IImplicitGeomSrc> collection2 = Hierarchy.flatten(collection, IImplicitGeomSrc.class);
        if (collection2.isEmpty()) {
            return collection;
        }
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        ArrayDeque<IImplicitGeomSrc> arrayDeque = new ArrayDeque<IImplicitGeomSrc>(collection2);
        IdentityHashSet<IImplicitGeomSrc> identityHashSet = new IdentityHashSet<IImplicitGeomSrc>(collection2);
        ArrayList<IPyroGeomSrc> arrayList = new ArrayList<IPyroGeomSrc>();
        while (!arrayDeque.isEmpty()) {
            serializable = (IImplicitGeomSrc)arrayDeque.removeFirst();
            serializable.getDefiningObjs(arrayList);
            if (arrayList.isEmpty()) {
                linkedIdentityHashSet.add(serializable);
                continue;
            }
            for (IPyroGeomSrc cloneable2 : arrayList) {
                if (cloneable2 instanceof IImplicitGeomSrc) {
                    if (!identityHashSet.add(cloneable2)) continue;
                    arrayDeque.addLast((IImplicitGeomSrc)cloneable2);
                    continue;
                }
                linkedIdentityHashSet.add(cloneable2);
            }
            arrayList.clear();
        }
        if (linkedIdentityHashSet.isEmpty()) {
            return collection;
        }
        serializable = new IdentityHashSet<IPyroGeomSrc>(Hierarchy.flatten(collection, IPyroGeomSrc.class));
        IFilteredCollection<IPyroGeomSrc> iFilteredCollection = theUtil.filter(linkedIdentityHashSet, arg_0 -> Actions.lambda$getTransformObjs$138((Set)((Object)serializable), arg_0));
        if (iFilteredCollection.isEmpty()) {
            return collection;
        }
        ArrayList<IPyroObject> arrayList2 = new ArrayList<IPyroObject>(collection);
        arrayList2.addAll((Collection<IPyroObject>)iFilteredCollection);
        return arrayList2;
    }

    public static void editControls(ControlBridge controlBridge) {
        ControlDlg controlDlg = new ControlDlg(PyroSim.getApp().getMainFrame());
        controlDlg.init(PyroSim.getApp().getMediator().getControls(), controlBridge);
        controlDlg.doModal();
    }

    public static void editZones(Zone zone) {
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        ZoneDlg zoneDlg = new ZoneDlg(PyroSim.getApp().getMainFrame(), pyroMod);
        zoneDlg.init(pyroMod.getZoneMgr(), zone);
        zoneDlg.doModal();
    }

    public static void doEditGrids(Grid grid) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        GridList gridList = pyroMod.getGridManager();
        GridManagerDlg gridManagerDlg = new GridManagerDlg(pyroSim.getMainFrame());
        gridManagerDlg.init(gridList, grid);
        gridManagerDlg.doModal();
    }

    private static void editMaterials(Material material) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        MaterialManagerDlg materialManagerDlg = new MaterialManagerDlg(pyroSim.getMainFrame());
        materialManagerDlg.init(pyroMod.getMaterialMgr(), material);
        materialManagerDlg.doModal();
    }

    public static void editSurfaces(Surface surface) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        SurfaceManagerDlg surfaceManagerDlg = new SurfaceManagerDlg(pyroSim.getMainFrame());
        surfaceManagerDlg.init(pyroMod.getSurfaceMgr(), surface);
        surfaceManagerDlg.doModal();
    }

    public static void editAppearance(pyrosim.domain.appearance.Material material) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        MaterialDlg materialDlg = new MaterialDlg(pyroSim.getMainFrame(), Intl.intl("Appearances"), pyroMod.getAppearances(), material, false);
        materialDlg.doModal();
    }

    public static void doEditReactions(Reaction reaction) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        ReactionList reactionList = pyroMod.getReactions();
        ExSpecList exSpecList = pyroMod.getExSpecList();
        ReactionManagerDlg reactionManagerDlg = new ReactionManagerDlg(pyroSim.getMainFrame());
        reactionManagerDlg.init(reactionList, reaction, exSpecList);
        reactionManagerDlg.doModal();
    }

    public static void editSprayModel(SprayModel sprayModel) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        SprayModelManagerDlg sprayModelManagerDlg = new SprayModelManagerDlg(pyroSim.getMainFrame());
        sprayModelManagerDlg.init(pyroMod.getSprayModels(), sprayModel);
        sprayModelManagerDlg.doModal();
    }

    public static void editSprinklerLinkModels(SprinklerLinkModel sprinklerLinkModel) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        SprinklerLinkModelManagerDlg sprinklerLinkModelManagerDlg = new SprinklerLinkModelManagerDlg(pyroSim.getMainFrame());
        sprinklerLinkModelManagerDlg.init(pyroMod.getSprinklerLinkModels(), sprinklerLinkModel);
        sprinklerLinkModelManagerDlg.doModal();
    }

    public static void editHeatLinkModels(HeatLinkModel heatLinkModel) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        HeatLinkModelManagerDlg heatLinkModelManagerDlg = new HeatLinkModelManagerDlg(pyroSim.getMainFrame());
        heatLinkModelManagerDlg.init(pyroMod.getHeatLinkModels(), heatLinkModel);
        heatLinkModelManagerDlg.doModal();
    }

    protected static ModelComposite getModelInsertLoc() {
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
        if (!iFilteredCollection.isEmpty()) {
            IPyroObject iPyroObject = Hierarchy.getCommonParent(iFilteredCollection);
            if (Hierarchy.isDescendent(pyroMod.getObstructions(), iPyroObject)) {
                return (ModelComposite)iPyroObject;
            }
        }
        return pyroMod.getObstructions();
    }

    public static void doCopy(PyroMod pyroMod, Clipboard clipboard, DataFlavor ... dataFlavorArray) {
        System.out.println("Copying...");
        Application.getApp().beginWaitCursor();
        IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
        try {
            ObjectSelection objectSelection = Actions.copyObjects(pyroMod, iFilteredCollection, true, dataFlavorArray);
            clipboard.setContents(objectSelection, objectSelection);
        }
        catch (IllegalStateException illegalStateException) {
            PyroGuiUtil.showError(Application.getApp(), Intl.intl("Clipboard Unavailable"), Intl.intl("The clipboard is unavailable."), (Throwable)illegalStateException);
        }
        catch (IOException iOException) {
            PyroGuiUtil.showError(Application.getApp(), Intl.intl("Cannot Copy Objects"), Intl.intl("Cannot copy selected objects."), (Throwable)iOException);
        }
        Application.getApp().endWaitCursor();
    }

    public static Set<DataFlavor> getSupportedCopyFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{PYRO_DATA_FLAVOR, FDS_DATA_FLAVOR};
        return new IdentityHashSet<DataFlavor>(Arrays.asList(dataFlavorArray));
    }

    public static Set<DataFlavor> getSupportedPasteFlavors() {
        return Actions.getSupportedCopyFlavors();
    }

    public static ObjectSelection copyObjects(PyroMod pyroMod, Collection<? extends IPyroObject> collection2, boolean bl, DataFlavor ... dataFlavorArray) throws IOException {
        Collection<Object> collection3;
        IdentityHashSet<? extends IPyroObject> identityHashSet;
        if (bl) {
            identityHashSet = null;
            if (collection2 instanceof Set) {
                identityHashSet = (Set)collection2;
            }
            boolean bl2 = false;
            collection3 = new ArrayList();
            for (Object object : pyroMod.getBridges().flatten()) {
                collection3.clear();
                object.getBridgedObjects(collection3);
                if (collection3.isEmpty()) continue;
                if (object instanceof Leak) {
                    collection3.remove(pyroMod.getZoneMgr().getOuter());
                }
                if (identityHashSet == null) {
                    identityHashSet = new IdentityHashSet<IPyroObject>(collection2);
                }
                if (!identityHashSet.containsAll(collection3)) continue;
                if (!bl2) {
                    collection2 = new ArrayList<IPyroObject>(collection2);
                }
                bl2 = true;
                ((List)collection2).add(object);
            }
        }
        identityHashSet = null;
        if (theUtil.contains(PYRO_DATA_FLAVOR, dataFlavorArray)) {
            if (!(collection2 instanceof Serializable)) {
                collection2 = new ArrayList<IPyroObject>(collection2);
            }
            Collection<? extends IPyroObject> collection4 = theUtil.serialCopy(collection2);
            identityHashSet = new PyroDataContainer(collection4);
        }
        String string = null;
        if (theUtil.contains(FDS_DATA_FLAVOR, dataFlavorArray)) {
            Object object;
            collection3 = Hierarchy.flatten(collection2, IPyroObject.class);
            FDSRenderer fDSRenderer = FDS.newRenderer(pyroMod, PyroSim.getApp().getFDSRenderProps());
            fDSRenderer.getProps().setRasterGridSupplier(collection -> theUtil.filter(pyroMod.getGridManager().flatten(), new EnabledFilter()));
            object = new FDSStringRenderer(fDSRenderer.getProps());
            fDSRenderer.renderObjects((IFDSRecordRenderer)object, collection3, Collections.EMPTY_MAP);
            string = ((FDSStringRenderer)object).toString();
        }
        return new ObjectSelection(identityHashSet, string, PYRO_DATA_FLAVOR);
    }

    public static void doCut(PyroMod pyroMod, Clipboard clipboard) {
        Application.getApp().beginWaitCursor();
        Actions.doCopy(pyroMod, clipboard, PYRO_DATA_FLAVOR);
        Actions.doDelete(pyroMod);
        Application.getApp().endWaitCursor();
    }

    public static guiAction getDefaultAction(PyroMod pyroMod) {
        for (guiAction guiAction2 : DEFAULT_ACTIONS) {
            if (!guiAction2.isEnabled()) continue;
            return guiAction2;
        }
        return null;
    }

    private static int countNonZero(int ... nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 <= 0) continue;
            ++n;
        }
        return n;
    }

    private static int countNonEmpty(Collection<?> ... collectionArray) {
        int n = 0;
        for (Collection<?> collection : collectionArray) {
            if (collection.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public static void editSelectedNode() {
        PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
        PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
        IFilteredCollection<IPyroObject> iFilteredCollection = pyroSimSelectionModel.getSelected(IPyroObject.class, IModelObj.class, ModelComposite.class);
        int n = pyroSimSelectionModel.getNum(Grid.class);
        int n2 = pyroSimSelectionModel.getNum(GridList.class);
        int n3 = pyroSimSelectionModel.getNum(Zone.class);
        int n4 = pyroSimSelectionModel.getNum(ZoneMgr.class);
        int n5 = pyroSimSelectionModel.getNum(Surface.class);
        int n6 = pyroSimSelectionModel.getNum(SurfaceManager.class);
        int n7 = pyroSimSelectionModel.getNum(ExSpec.class);
        int n8 = pyroSimSelectionModel.getNum(ExSpecList.class);
        int n9 = pyroSimSelectionModel.getNum(Particle.class);
        int n10 = pyroSimSelectionModel.getNum(ParticleList.class);
        int n11 = pyroSimSelectionModel.getNum(Reaction.class);
        int n12 = pyroSimSelectionModel.getNum(ReactionList.class);
        int n13 = pyroSimSelectionModel.getNum(Material.class);
        int n14 = pyroSimSelectionModel.getNum(MaterialManager.class);
        int n15 = pyroSimSelectionModel.getNum(IDevice.class);
        int n16 = pyroSimSelectionModel.getNum(ControlBridge.class);
        int n17 = pyroSimSelectionModel.getNum(ControlMgr.class);
        int n18 = pyroSimSelectionModel.getNum(StatisticMgr.class);
        int n19 = pyroSimSelectionModel.getNum(IMeasurementStat.class);
        int n20 = pyroSimSelectionModel.getNum(SliceList.class);
        int n21 = pyroSimSelectionModel.getNum(PlanarSlice.class);
        int n22 = pyroSimSelectionModel.getNum(Slice3dList.class);
        int n23 = pyroSimSelectionModel.getNum(VolumeSlice.class);
        int n24 = pyroSimSelectionModel.getNum(HvacList.class);
        int n25 = pyroSimSelectionModel.getNum(IHvacObject.class);
        int n26 = pyroSimSelectionModel.getNum(SectionBox.class);
        int n27 = Actions.countNonZero(iFilteredCollection.size(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21, n22, n23, n25, n24, n26);
        if (n27 != 1) {
            return;
        }
        if (n > 0) {
            Actions.doEditGrids((Grid)pyroSimSelectionModel.getSelected(Grid.class).iterator().next());
        } else if (n2 > 0) {
            Actions.doEditGrids(null);
        } else if (n3 > 0) {
            Actions.editZones((Zone)pyroSimSelectionModel.getSelected(Zone.class).iterator().next());
        } else if (n4 > 0) {
            Actions.editZones(null);
        } else if (n5 > 0) {
            Actions.editSurfaces((Surface)pyroSimSelectionModel.getSelected(Surface.class).iterator().next());
        } else if (n6 > 0) {
            Actions.editSurfaces(null);
        } else if (n7 > 0) {
            Actions.editSpecies((ExSpec)pyroSimSelectionModel.getSelected(ExSpec.class).iterator().next());
        } else if (n8 > 0) {
            Actions.editSpecies(null);
        } else if (n9 > 0) {
            Actions.editParticles((Particle)pyroSimSelectionModel.getSelected(Particle.class).iterator().next());
        } else if (n10 > 0) {
            Actions.editParticles(null);
        } else if (n13 > 0) {
            Actions.editMaterials((Material)pyroSimSelectionModel.getSelected(Material.class).iterator().next());
        } else if (n14 > 0) {
            Actions.editMaterials(null);
        } else if (n11 > 0) {
            Actions.doEditReactions((Reaction)pyroSimSelectionModel.getSelected(Reaction.class).iterator().next());
        } else if (n12 > 0) {
            Actions.doEditReactions(null);
        } else if (n15 == 1) {
            Actions.editDevice((IDevice)pyroSimSelectionModel.getSelected(IDevice.class).iterator().next(), 0);
        } else if (n17 > 0) {
            Actions.editControls(null);
        } else if (n16 > 0) {
            Actions.editControls((ControlBridge)pyroSimSelectionModel.getSelected(ControlBridge.class).iterator().next());
        } else if (n18 > 0) {
            Actions.editStats(Collections.EMPTY_LIST);
        } else if (n19 > 0) {
            Actions.editStats(pyroSimSelectionModel.getSelected(IMeasurementStat.class));
        } else if (n20 > 0) {
            Actions.editSlices(Collections.EMPTY_LIST);
        } else if (n21 > 0) {
            Actions.editSlices(pyroSimSelectionModel.getSelected(PlanarSlice.class));
        } else if (n22 > 0) {
            Actions.edit3DSlices(Collections.EMPTY_LIST);
        } else if (n23 > 0) {
            Actions.edit3DSlices(pyroSimSelectionModel.getSelected(VolumeSlice.class));
        } else if (n24 > 0) {
            Actions.editHvac(Collections.emptyList());
        } else if (n25 > 0) {
            Actions.editHvac(pyroSimSelectionModel.getSelected(IHvacObject.class));
        } else if (n26 > 0) {
            Actions.editSectionBoxes(pyroSimSelectionModel.getSelected(SectionBox.class));
        } else if (!iFilteredCollection.isEmpty()) {
            IPyroObject iPyroObject = ((IPyroObject)iFilteredCollection.iterator().next()).getParent();
            if (!(iPyroObject instanceof ModelComposite)) {
                iPyroObject = pyroMod.getObstructions();
            }
            ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(iFilteredCollection);
            ModelObjectDialog modelObjectDialog = new ModelObjectDialog(Application.getApp().getMainFrame(), pyroMod, arrayList, (ModelComposite)iPyroObject, 1);
            if (modelObjectDialog.doModal() == 1) {
                modelObjectDialog.saveValues(iFilteredCollection);
            }
        }
    }

    public static void editSimulationProperties() {
        SimulationPropertiesDlg simulationPropertiesDlg = new SimulationPropertiesDlg(Application.getApp().getMainFrame());
        if (simulationPropertiesDlg.doModal() == 1) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            SimulationTask simulationTask = new SimulationTask(pyroMod, simulationPropertiesDlg);
            pyroMod.getTaskManager().exec(simulationTask, Intl.intl("Edit Sim Params"));
        }
    }

    public static File exportToFile(Component component, File file, PyroMod pyroMod, Collection<? extends IPyroObject> collection, String string) {
        PyroSim pyroSim = PyroSim.getApp();
        File file2 = Actions.getValidLibraryFileFromUser(component, file, string);
        if (file2 == null) {
            return null;
        }
        if (string != null) {
            PyroSim.getApp().setLastDir(string, file2);
        }
        pyroSim.beginWaitCursor();
        try {
            FDSRenderer fDSRenderer = FDS.newRenderer(pyroMod, PyroSim.getApp().getFDSRenderProps());
            fDSRenderer.renderFile(file2, collection);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(component, Intl.intl("The library file could not be written."), Intl.intl("Error"), 0);
            pyroSim.endWaitCursor();
            return null;
        }
        pyroSim.endWaitCursor();
        return file2;
    }

    private static File getValidLibraryFileFromUser(Component component, File file, String string) {
        if (file == null) {
            file = new File("untitled.fds");
        } else if (file.getName().equals("database3.data") || file.getName().equals("database4.data")) {
            file = new File(file.getParent(), "untitled.fds");
        }
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("fds", "Database File");
        guiFileChooser guiFileChooser2 = new guiFileChooser(exampleFileFilter);
        guiFileChooser2.setAcceptAllFileFilterUsed(true);
        if (file == null || file.exists() && string != null) {
            guiFileChooser2.setCurrentDirectory(((PyroSim)Application.getApp()).getLastDir(string));
        }
        guiFileChooser2.setSelectedFile(file);
        guiFileChooser2.setFileFilter(exampleFileFilter);
        int n = guiFileChooser2.showSaveDialog(component);
        if (n != 0) {
            return null;
        }
        File file2 = guiFileChooser2.getSelectedFile();
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(component, Intl.intl("The library file could not be written."), Intl.intl("Error"), 0);
                return null;
            }
        }
        return file2;
    }

    public static boolean isObjectInUse(PyroMod pyroMod, final Collection<IPyroObject> collection, DepSnapshot depSnapshot) {
        if (depSnapshot == null) {
            depSnapshot = pyroMod.getDependencies(new IPyroObject[0]);
        }
        IdentityHashSet identityHashSet = new IdentityHashSet();
        Predicate<Object> predicate = new Predicate<Object>(){

            @Override
            public boolean test(Object object) {
                if (object instanceof IPyroObject) {
                    return ((IPyroObject)object).isEnabled() && !collection.contains(object) && object instanceof IDirectDependent;
                }
                return false;
            }
        };
        for (IPyroObject iPyroObject : collection) {
            depSnapshot.findAllDependents(predicate, iPyroObject, identityHashSet);
        }
        return !identityHashSet.isEmpty();
    }

    public static PyroDataContainer getClipboardObjects(Transferable transferable, PyroMod pyroMod) {
        PyroDataContainer pyroDataContainer = null;
        try {
            pyroDataContainer = (PyroDataContainer)transferable.getTransferData(PYRO_DATA_FLAVOR);
            try {
                if (!pyroDataContainer.isCurrentVersion()) {
                    pyroDataContainer = null;
                    JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Cannot paste between dissimilar versions of PyroSim."), Intl.intl("Paste Error"), 2);
                }
            }
            catch (Exception exception) {
                pyroDataContainer = null;
                JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Cannot paste between dissimilar versions of PyroSim."), Intl.intl("Paste Error"), 2);
            }
        }
        catch (IOException iOException) {
            Application.getApp().error(new guiExceptionError(iOException));
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            try {
                String string = (String)transferable.getTransferData(FDS_DATA_FLAVOR);
                PyroMod pyroMod2 = new PyroMod();
                FDSParser fDSParser = FDS.newParser(6);
                FDSParseResult fDSParseResult = fDSParser.parseBuffer((CharSequence)string, pyroMod2, pyroMod);
                if (!fDSParseResult.warningReport.showWarnings(false) && fDSParseResult.extractedObjs.isEmpty()) {
                    Toolkit.getDefaultToolkit().beep();
                    return null;
                }
                String string2 = pyroMod2.getUnprocessedRecords();
                pyroDataContainer = new PyroDataContainer(fDSParseResult.extractedObjs, string2);
            }
            catch (IOException iOException) {
                Application.getApp().error(new guiExceptionError(iOException));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException2) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (FDSParseException fDSParseException) {
                Application.getApp().error(new guiExceptionError(fDSParseException));
            }
        }
        return pyroDataContainer;
    }

    public static void doTransfer(PyroMod pyroMod, PyroMod pyroMod2, Collection<? extends IPyroObject> collection) throws IOException {
        try {
            UIPasteCallback uIPasteCallback = new UIPasteCallback(pyroMod2);
            if (!(collection instanceof Serializable)) {
                collection = new ArrayList<IPyroObject>(collection);
            }
            Collection<? extends IPyroObject> collection2 = theUtil.serialCopy(collection);
            Actions.pasteObjects(pyroMod2, collection2, "", uIPasteCallback);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public static void doPaste(PyroMod pyroMod, Clipboard clipboard, IPasteCallback iPasteCallback) {
        try {
            PyroDataContainer pyroDataContainer = Actions.getClipboardObjects(clipboard.getContents(PyroSim.getApp()), pyroMod);
            if (pyroDataContainer != null) {
                Actions.pasteObjects(pyroMod, pyroDataContainer.getObjects(), pyroDataContainer.getUnprocessedRecords(), iPasteCallback);
            }
        }
        catch (CancellationException cancellationException) {
            return;
        }
        catch (IllegalStateException illegalStateException) {
            guiUtil.showError(PyroSim.getApp(), Intl.intl("Clipboard Unavailable."), Intl.intl("The clipboard is unavailable."), (Throwable)illegalStateException);
        }
    }

    public static void pasteObjects(PyroMod pyroMod, Collection<? extends IPyroObject> collection, String string, IPasteCallback iPasteCallback) {
        Task task = Actions.taskPasteObjects((PyroMod)pyroMod, collection, (String)string, (int)1, (IPasteCallback)iPasteCallback).task;
        boolean bl = pyroMod.getAllGeom().isEmpty();
        int n = bl ? 2 : 0;
        pyroMod.getTaskManager().exec(task, Intl.intl("Paste"), n);
    }

    public static PasteInfo taskPasteObjects(PyroMod pyroMod, Collection<? extends IPyroObject> collection, String string, int n, IPasteCallback iPasteCallback) {
        PasteInfo pasteInfo = Actions.taskInsertObjects(pyroMod, collection, iPasteCallback, n);
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
        compositeTask.addTask(pasteInfo.task);
        compositeTask.addTask(new InsertAdditionalRecordsTask(pyroMod, string));
        return new PasteInfo(compositeTask, pasteInfo.commands);
    }

    private static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    public static PasteInfo taskInsertObjects(PyroMod pyroMod, Collection<? extends IPyroObject> collection, IPasteCallback iPasteCallback, int n) {
        if (collection.isEmpty()) {
            return new PasteInfo(EmptyTask.INSTANCE, Collections.EMPTY_MAP);
        }
        DepSnapshot depSnapshot = new DepSnapshot();
        for (IPyroObject cloneable2 : collection) {
            depSnapshot.takeSnapshot(cloneable2);
        }
        Set<IPyroObject> set = depSnapshot.getAllDependedOn();
        LinkedIdentityHashMap<IPyroObject, PasteCommand> linkedIdentityHashMap = new LinkedIdentityHashMap<IPyroObject, PasteCommand>();
        boolean bl = Actions.test(n, 2);
        boolean bl2 = !Actions.test(n, 4);
        Actions.queueInsertTasks(pyroMod, collection, bl, iPasteCallback, linkedIdentityHashMap);
        Actions.queueInsertTasks(pyroMod, (Collection<? extends Object>)set, bl2, iPasteCallback, linkedIdentityHashMap);
        PasteReactionCommand pasteReactionCommand = Actions.queueSetReactionTask(pyroMod, linkedIdentityHashMap, iPasteCallback);
        Object object = Actions.convertInsertCommandsToTask(depSnapshot, pyroMod, linkedIdentityHashMap);
        Task task = Actions.convertReactionSelectionToTask(pasteReactionCommand, pyroMod);
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
        compositeTask.addTask((Task)object);
        compositeTask.addTask(task);
        if (Actions.test(n, 1)) {
            ArrayDeque arrayDeque = new ArrayDeque();
            for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
                if (((PasteCommand)entry.getValue()).command == 1) continue;
                arrayDeque.add(entry.getKey());
            }
            SelectTask selectTask = new SelectTask(pyroMod, arrayDeque);
            selectTask.addTask(compositeTask);
            object = selectTask;
        }
        return new PasteInfo((Task)object, linkedIdentityHashMap);
    }

    private static Task convertInsertCommandsToTask(DepSnapshot depSnapshot, PyroMod pyroMod, Map<IPyroObject, PasteCommand> map) {
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
        for (IPyroObject cloneable2 : depSnapshot.getAllDependedOn()) {
            PasteCommand pasteCommand = map.get(cloneable2);
            if (pasteCommand == null || pasteCommand.command != 1) continue;
            for (Dependency dependency : depSnapshot.getDependents(cloneable2)) {
                compositeTask.addTask(DepUtil.getReplacementTask(depSnapshot, dependency.source, cloneable2, (IPyroObject)pasteCommand.param));
            }
        }
        DepSnapshot depSnapshot2 = pyroMod.getDependencies(new IPyroObject[0]);
        ArrayList<Task> arrayList = new ArrayList<Task>();
        for (Map.Entry entry : map.entrySet()) {
            IPyroObject iPyroObject = (IPyroObject)entry.getKey();
            PasteCommand pasteCommand = (PasteCommand)entry.getValue();
            switch (pasteCommand.command) {
                case 2: {
                    TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(pasteCommand.pasteLoc);
                    IPyroObject iPyroObject2 = (IPyroObject)pasteCommand.param;
                    arrayList.add(tVEntryPoint.paste(pyroMod, pasteCommand.pasteLoc, iPyroObject, iPyroObject2, TVEntryPoint.ConflictResolution.RENAME_NEW, depSnapshot2));
                    break;
                }
                case 0: {
                    TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(pasteCommand.pasteLoc);
                    IPyroObject iPyroObject2 = (IPyroObject)pasteCommand.param;
                    compositeTask.addTask(tVEntryPoint.paste(pyroMod, pasteCommand.pasteLoc, iPyroObject, iPyroObject2, TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING, depSnapshot2));
                    break;
                }
            }
        }
        for (Task task : arrayList) {
            compositeTask.addTask(task);
        }
        return compositeTask;
    }

    private static Task convertReactionSelectionToTask(PasteReactionCommand pasteReactionCommand, PyroMod pyroMod) {
        return pyroMod.getReactions().taskSetActiveReactions(pasteReactionCommand.newActives);
    }

    private static void getPasteLocs(PyroMod pyroMod, Object object, Collection<?> collection, IPasteCallback iPasteCallback, Map<Object, Object> map, List<Object> list) {
        for (Object object2 : collection) {
            if (object2 == null || map.containsKey(object2)) continue;
            Object object3 = object;
            if (object3 == null && (object3 = iPasteCallback.getPasteLocation(pyroMod, object2)) == null) {
                System.err.println("Nowhere to paste " + object2.getClass());
                continue;
            }
            if (object2 instanceof Composite) {
                Composite composite = (Composite)object2;
                Collection<IPyroObject> collection2 = composite.getMembers();
                object2 = composite.clone(false);
                list.add(object2);
                Actions.getPasteLocs(pyroMod, (Composite)object2, collection2, iPasteCallback, map, list);
            } else {
                list.add(object2);
            }
            map.put(object2, object3);
        }
    }

    private static void queueInsertTasks(PyroMod pyroMod, Collection<? extends Object> collection, boolean bl, IPasteCallback iPasteCallback, Map<IPyroObject, PasteCommand> map) {
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>(collection.size());
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Actions.getPasteLocs(pyroMod, null, collection, iPasteCallback, identityHashMap, arrayList);
        for (Object e : arrayList) {
            Actions.queueInsertTasks(pyroMod, identityHashMap.get(e), e, bl, iPasteCallback, map);
        }
    }

    private static void queueInsertTasks(PyroMod pyroMod, Object object, Object object2, boolean bl, IPasteCallback iPasteCallback, Map<IPyroObject, PasteCommand> map) {
        TVEntryPoint<Object> tVEntryPoint;
        IPyroObject iPyroObject;
        if (map.containsKey(object2)) {
            return;
        }
        assert (object2 instanceof IPyroObject);
        IPyroObject iPyroObject2 = (IPyroObject)object2;
        TVEntryPoint<IPyroObject> tVEntryPoint2 = TVEntryPoints.ep(iPyroObject2);
        Object object3 = tVEntryPoint2.getCategoryRoot(pyroMod, iPyroObject2);
        if (object3 == null) {
            System.err.println("No category root for " + iPyroObject2.getClass());
        }
        IPyroObject iPyroObject3 = iPyroObject = (tVEntryPoint = TVEntryPoints.ep(object3)) != null ? (IPyroObject)tVEntryPoint.getConflict(pyroMod, object3, iPyroObject2) : null;
        if (iPyroObject == null) {
            map.put(iPyroObject2, new PasteCommand(0, object, null));
        } else if (bl && tVEntryPoint.isEquivalent(pyroMod, object3, iPyroObject, iPyroObject2)) {
            map.put(iPyroObject2, new PasteCommand(1, object, iPyroObject));
        } else if (tVEntryPoint2.canRename(pyroMod, iPyroObject2)) {
            map.put(iPyroObject2, new PasteCommand(2, object, iPyroObject));
        } else {
            Object object4;
            if (tVEntryPoint2.canMerge(pyroMod, iPyroObject2) && (object4 = tVEntryPoint2.mergeToRoot(pyroMod, iPyroObject2)) != null) {
                map.put((IPyroObject)object4, new PasteCommand(0, object, iPyroObject));
                return;
            }
            object4 = iPasteCallback.getReplaceModelObject(iPyroObject, iPyroObject2);
            switch (5.$SwitchMap$pyrosim$gui$actions$Actions$PasteOverwrite[((Enum)object4).ordinal()]) {
                case 1: {
                    map.put(iPyroObject2, new PasteCommand(1, object, iPyroObject));
                    break;
                }
                case 2: {
                    map.put(iPyroObject2, new PasteCommand(0, object, iPyroObject));
                }
            }
        }
    }

    private static PasteReactionCommand queueSetReactionTask(PyroMod pyroMod, Map<IPyroObject, PasteCommand> map, IPasteCallback iPasteCallback) {
        Map<Reaction, PasteCommand> map2 = map.entrySet().stream().filter(entry -> entry.getKey() instanceof Reaction).filter(entry -> ((PasteCommand)entry.getValue()).command != 1).collect(Collectors.toMap(entry -> (Reaction)entry.getKey(), Map.Entry::getValue));
        List<Reaction> list = pyroMod.getReactions().getActiveReactions();
        List<Reaction> list2 = iPasteCallback.getActiveReactions(pyroMod.getReactions().flatten(), map2, list);
        return new PasteReactionCommand(list, list2);
    }

    public static void doDelete(PyroMod pyroMod) {
        System.out.println("Deleting...");
        IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
        Task task = Actions.getDeleteTask(pyroMod, iFilteredCollection);
        if (task == null) {
            return;
        }
        pyroMod.getTaskManager().exec(task, Intl.intl("Delete"));
    }

    private static <T> List<T> newFilteredList(Collection<?> collection, Class<T> clazz) {
        return new ArrayList<T>(theUtil.filter(collection, clazz));
    }

    private static void markNonDeletes(PyroMod pyroMod, Collection<? extends IPyroObject> collection, Set<IPyroObject> set) {
        for (IPyroObject iPyroObject : Hierarchy.flatten(collection, IPyroObject.class)) {
            if (Util.canDelete(pyroMod, iPyroObject)) continue;
            while (iPyroObject != null) {
                set.add(iPyroObject);
                iPyroObject = iPyroObject.getParent();
            }
        }
    }

    private static void collectDeletes(IPyroObject iPyroObject, Set<IPyroObject> set, Set<IPyroObject> set2) {
        if (set.contains(iPyroObject)) {
            for (IPyroObject iPyroObject2 : iPyroObject.getMembers()) {
                Actions.collectDeletes(iPyroObject2, set, set2);
            }
        } else {
            set2.add(iPyroObject);
        }
    }

    private static Set<IPyroObject> collectDeletesDeep(Collection<IPyroObject> collection, Collection<IPyroObject> collection2) {
        IdentityHashSet<IPyroObject> identityHashSet = new IdentityHashSet<IPyroObject>();
        for (IPyroObject iPyroObject : collection2) {
            Actions.collectDeletesDeep(iPyroObject, identityHashSet, collection);
        }
        return identityHashSet;
    }

    private static void collectDeletesDeep(IPyroObject iPyroObject, Collection<IPyroObject> collection, Collection<IPyroObject> collection2) {
        if (iPyroObject instanceof Composite) {
            for (IPyroObject iPyroObject2 : ((Composite)iPyroObject).flatten()) {
                Actions.collectDeletesDeep(iPyroObject2, collection, collection2);
            }
        } else {
            collection.add(iPyroObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Task getDeleteTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Application.getApp().beginWaitCursor();
        try {
            void var5_8;
            Object object;
            Object object2;
            IdentityHashSet<IPyroObject> identityHashSet = new IdentityHashSet<IPyroObject>();
            identityHashSet.addAll(pyroMod.getMembers());
            Actions.markNonDeletes(pyroMod, collection, identityHashSet);
            LinkedIdentityHashSet<IPyroObject> linkedIdentityHashSet = new LinkedIdentityHashSet<IPyroObject>();
            for (IPyroObject object32 : collection) {
                Actions.collectDeletes(object32, identityHashSet, linkedIdentityHashSet);
            }
            assert (!linkedIdentityHashSet.contains(null)) : "Attempting to delete null object. See case 28897.";
            if (linkedIdentityHashSet.isEmpty()) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("Cannot delete selected objects."), Intl.intl("Cannot Delete"), 0);
                object2 = null;
                return object2;
            }
            object2 = Actions.collectDeletesDeep(identityHashSet, linkedIdentityHashSet);
            Object var5_6 = null;
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (IPyroObject)object3.next();
                if (!TVEntryPoints.ep(object).mayBeReferenced(pyroMod, (IPyroObject)object)) continue;
                DepSnapshot depSnapshot = pyroMod.getDependencies(new IPyroObject[0]);
                break;
            }
            if ((object3 = Actions.getReplacementsFor(pyroMod, (DepSnapshot)var5_8, (Set<IPyroObject>)object2)) == null) {
                object = null;
                return object;
            }
            object = new CompositeTask<PyroMod>(pyroMod);
            for (Map.Entry entry : object3.entrySet()) {
                assert (var5_8 != null);
                Set<Dependency> set = var5_8.getDependents((IPyroObject)entry.getKey());
                for (Dependency dependency : set) {
                    if (linkedIdentityHashSet.contains(dependency.source)) continue;
                    ((CompositeTask)object).addTask(DepUtil.getReplacementTask((DepSnapshot)var5_8, dependency.source, (IPyroObject)entry.getKey(), (IPyroObject)entry.getValue()));
                }
            }
            ((CompositeTask)object).addTask(Tasks.delete(linkedIdentityHashSet));
            Object object4 = object;
            return object4;
        }
        finally {
            PyroSim.getApp().endWaitCursor();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Map<IPyroObject, IPyroObject> getReplacementsFor(PyroMod pyroMod, DepSnapshot depSnapshot, Set<IPyroObject> set) {
        if (set.isEmpty() || depSnapshot == null) {
            return Collections.EMPTY_MAP;
        }
        Set<IPyroObject> set2 = set;
        LinkedIdentityHashMap<IPyroObject, IPyroObject> linkedIdentityHashMap = new LinkedIdentityHashMap<IPyroObject, IPyroObject>();
        while (!set.isEmpty()) {
            LinkedIdentityHashSet<IPyroObject> linkedIdentityHashSet = new LinkedIdentityHashSet<IPyroObject>();
            for (IPyroObject iPyroObject : set) {
                void object22;
                Object object;
                Set<Dependency> set3 = depSnapshot.getDependents(iPyroObject);
                if (set3.isEmpty()) continue;
                IPyroObject iPyroObject2 = Hierarchy.getCategoryRoot(iPyroObject);
                assert (iPyroObject2 != null);
                LinkedIdentityHashSet<IPyroObject> linkedIdentityHashSet2 = new LinkedIdentityHashSet<IPyroObject>(Hierarchy.flattenComposites(Arrays.asList(iPyroObject2)));
                linkedIdentityHashSet2.add(null);
                linkedIdentityHashSet2.removeAll(set);
                for (Dependency dependency : set3) {
                    if (dependency.link == DLink.REQUIRED) {
                        linkedIdentityHashSet2.remove(null);
                    }
                    dependency.source.removeInvalidReplacements(iPyroObject, linkedIdentityHashSet2);
                }
                if (linkedIdentityHashSet2.isEmpty()) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), String.format(Intl.intl("Cannot delete %s.  It is currently in use."), Util.getName(iPyroObject)), Intl.intl("Delete Error"), 2);
                    return null;
                }
                String string = TVEntryPoints.ep(iPyroObject).getCategoryName();
                Object var12_15 = null;
                if (linkedIdentityHashSet2.size() == 1) {
                    IPyroObject iPyroObject3 = (IPyroObject)linkedIdentityHashSet2.iterator().next();
                    object = iPyroObject3 == null ? String.format(Intl.intl("%s references will be removed.  Would you like to continue?"), Util.getName(iPyroObject)) : String.format(Intl.intl("References to %s will be replaced with %s.  Would you like to continue?"), Util.getName(iPyroObject), Util.getName(iPyroObject3));
                    int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), object, String.format(Intl.intl("%s Replacement"), string), 0);
                    if (n != 0) {
                        return null;
                    }
                } else {
                    object = new ReplaceDlg<IPyroObject>(string, iPyroObject, linkedIdentityHashSet2);
                    if (((guiDialog)object).doModal() != 1) {
                        return null;
                    }
                    IPyroObject iPyroObject4 = ((ReplaceDlg)object).getReplacer();
                }
                linkedIdentityHashMap.put(iPyroObject, (IPyroObject)object22);
                if (object22 != null) continue;
                for (Dependency dependency : set3) {
                    if (dependency.link != DLink.STRONG || set.contains(dependency.source) || !Util.canDelete(pyroMod, dependency.source)) continue;
                    linkedIdentityHashSet.add((IPyroObject)((Object)dependency.source));
                }
            }
            set2.addAll(linkedIdentityHashSet);
            set = linkedIdentityHashSet;
        }
        return linkedIdentityHashMap;
    }

    private static void showBoundaryConditionsDialog() {
        PyroMod pyroMod;
        JFrame jFrame = Application.getApp().getMainFrame();
        BoundariesDlg boundariesDlg = new BoundariesDlg(jFrame, pyroMod = PyroSim.getApp().getMediator());
        if (boundariesDlg.doModal() == 1) {
            pyroMod.getTaskManager().exec(boundariesDlg.taskSaveValues(), Intl.intl("Edit Boundary Quantities"));
        }
    }

    private static void showPlot3DDialog() {
        JFrame jFrame = Application.getApp().getMainFrame();
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        Plot3dDlg plot3dDlg = new Plot3dDlg(jFrame, Intl.intl("Plot3D Data"), pyroMod.getPlot3d(), 5, PyroPrefs.LastPl3dDlgSizeX, PyroPrefs.LastPl3dDlgSizeY);
        if (plot3dDlg.doModal() == 1) {
            pyroMod.getTaskManager().exec(plot3dDlg.taskSaveValues(), Intl.intl("Edit Plot3D Output"));
        }
    }

    private static void edit3DSlices(Collection<? extends VolumeSlice> collection) {
        Slcf3dDialog slcf3dDialog = new Slcf3dDialog(Application.getApp().getMainFrame());
        slcf3dDialog.setInitialSel(collection);
        slcf3dDialog.doModal();
    }

    private static void editSlices(Collection<? extends PlanarSlice> collection) {
        SlcfDialog slcfDialog = new SlcfDialog(Application.getApp().getMainFrame());
        slcfDialog.setInitialSel(collection);
        slcfDialog.doModal();
    }

    private static void editHvac(Collection<? extends IHvacObject> collection) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        HvacManagerDlg hvacManagerDlg = new HvacManagerDlg(pyroSim.getMainFrame(), pyroMod, pyroSim.getUnitSystem());
        IHvacObject iHvacObject = !collection.isEmpty() ? collection.iterator().next() : null;
        hvacManagerDlg.init(pyroMod.getHvacList(), iHvacObject);
        hvacManagerDlg.doModal();
    }

    private static void editSectionBoxes(Collection<? extends SectionBox> collection) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        SectionBoxDlg sectionBoxDlg = new SectionBoxDlg((Window)pyroSim.getMainFrame(), collection);
        if (sectionBoxDlg.doModal() == 1) {
            Task task = sectionBoxDlg.taskSave(collection);
            pyroMod.getTaskManager().exec(task, Intl.intl("Edit Section Boxes"));
        }
    }

    public static void editParticles(Particle particle) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        ParticleManagerDlg particleManagerDlg = new ParticleManagerDlg(pyroSim.getMainFrame());
        particleManagerDlg.init(pyroMod.getPartList(), particle);
        particleManagerDlg.doModal();
    }

    public static void editSmokeLinkModels(SmokeLinkModel smokeLinkModel) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        JFrame jFrame = pyroSim.getMainFrame();
        PyroMod pyroMod = pyroSim.getMediator();
        SmokeLinkModelMgrDlg smokeLinkModelMgrDlg = new SmokeLinkModelMgrDlg(jFrame);
        smokeLinkModelMgrDlg.init(pyroMod.getSmokeLinkModels(), smokeLinkModel);
        smokeLinkModelMgrDlg.doModal();
    }

    public static void editSpecies(ExSpec exSpec) {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        JFrame jFrame = pyroSim.getMainFrame();
        PyroMod pyroMod = pyroSim.getMediator();
        ExSpecList exSpecList = pyroMod.getExSpecList();
        ExSpecManagerDlg exSpecManagerDlg = new ExSpecManagerDlg(jFrame);
        exSpecManagerDlg.init(exSpecList, exSpec);
        exSpecManagerDlg.doModal();
    }

    public static boolean isValidSpecies(ExSpec exSpec) {
        if (exSpec == null) {
            return false;
        }
        ExSpecList exSpecList = ((PyroSim)Application.getApp()).getMediator().getExSpecList();
        if (exSpecList.get(exSpec.getName()) != null) {
            return true;
        }
        return ExSpecList.isPredefinedSpecies(exSpec.getName());
    }

    private static void editStats(Collection<? extends IMeasurementStat> collection) {
        PyroSim pyroSim = PyroSim.getApp();
        JFrame jFrame = pyroSim.getMainFrame();
        PyroMod pyroMod = pyroSim.getMediator();
        StatisticsDlg statisticsDlg = new StatisticsDlg(jFrame);
        IMeasurementStat iMeasurementStat = collection.isEmpty() ? null : collection.iterator().next();
        statisticsDlg.init(pyroMod.getMsrStatMgr(), iMeasurementStat);
        statisticsDlg.doModal();
    }

    public static boolean validateModel(PyroSim pyroSim, PyroMod pyroMod) {
        ArrayList<ARunFDSValidation> arrayList = new ArrayList<ARunFDSValidation>();
        arrayList.add(new ExposedOverlapValidation());
        arrayList.add(new FlameConditionValidation());
        arrayList.add(new VentCollapseValidation());
        arrayList.add(new AspiratorSamplerValidation());
        for (ARunFDSValidation aRunFDSValidation : arrayList) {
            ARunFDSValidation.Prompt prompt;
            Collection<IPyroObject> collection = aRunFDSValidation.validateModel(pyroSim, pyroMod);
            if (collection.isEmpty() || (prompt = aRunFDSValidation.getPrompt(pyroSim.getMainFrame(), collection.size())).doModal() != 1) continue;
            SelectTask selectTask = new SelectTask(pyroMod, collection);
            EventQueue.invokeLater(() -> pyroMod.getTaskManager().exec(selectTask, null));
            return false;
        }
        return true;
    }

    public static String getResultsID(File file) {
        return FDS6Renderer.getProperCHID(file.getName());
    }

    public static File getResultsDir() {
        File file = Actions.getFDSFile();
        return file == null ? null : file.getParentFile();
    }

    public static File getFDSFile() {
        FDSRun fDSRun = PyroSim.getApp().getMediator().getLastFDSRun();
        if (fDSRun.fdsFilepath != null) {
            return new File(fDSRun.fdsFilepath);
        }
        if (PyroSim.getApp().getFilename() != null) {
            File file = new File(PyroSim.getApp().getFilename());
            return Actions.getDefaultFDSInputFile(file);
        }
        return null;
    }

    public static File[] getFDSFiles() {
        File file = Actions.getFDSFile();
        if (file == null) {
            return null;
        }
        return Actions.getFDSFiles(file);
    }

    public static File getDefaultResultsDir(File file) {
        return Actions.getDefaultFDSInputFile(file).getParentFile();
    }

    public static File getDefaultFDSInputFile(File file) {
        String string = Actions.getResultsID(file);
        File file2 = new File(file.getParentFile(), string);
        return new File(file2, string + ".fds");
    }

    public static File[] getFDSFiles(File file) {
        String string = file.getName();
        string = FilenameManager.splitFilename(string)[0];
        File file2 = file.getParentFile();
        return new File[]{file, new File(file2, string + ".out"), new File(file2, string + ".smv"), new File(file2, string + "_hrr.csv"), new File(file2, string + "_devc.csv"), new File(file2, string + "_ctrl.csv")};
    }

    public static boolean hasResults(File file) {
        return file != null && file.exists() && file.isDirectory() && IOUtil.listFiles(file).size() > 0;
    }

    private static void archiveResults(File file) throws CancelledException {
        if (!Actions.hasResults(file)) {
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("There are no results to archive."), Intl.intl("No results"), 2);
            return;
        }
        String string = PyroSim.getApp().getFilename();
        ArchiveResultsDlg archiveResultsDlg = new ArchiveResultsDlg((Window)PyroSim.getApp().getActiveFrame());
        String string2 = Actions.suggestArchiveName(string);
        archiveResultsDlg.setName(string2);
        if (archiveResultsDlg.doModal() != 1) {
            throw new CancelledException();
        }
        String string3 = archiveResultsDlg.getName();
        ResultsArchive.IMethod iMethod = archiveResultsDlg.getMethod();
        boolean bl = archiveResultsDlg.getRetainCurrentResults();
        Object object = archiveResultsDlg.getOptions();
        try {
            File file2 = new File(string);
            iMethod.archive(file, file2.getParentFile(), string3, bl, object);
            ResultsArchive.Record record = new ResultsArchive.Record(string3, iMethod, Calendar.getInstance().getTimeInMillis());
            PyroSim.getApp().getMediator().getResultsArchive().addArchive(record);
        }
        catch (IOException iOException) {
            Actions.showArchiveIOException(iOException);
            throw new CancelledException();
        }
    }

    private static void showArchiveIOException(IOException iOException) {
        Actions.showIOException(iOException, Intl.intl("Could not create archive."));
    }

    private static void showRestoreIOException(IOException iOException) {
        Actions.showIOException(iOException, Intl.intl("Could not restore archive."));
    }

    private static void showIOException(IOException iOException, String string) {
        JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), string + "\n" + iOException.getClass().getSimpleName() + ": " + iOException.getLocalizedMessage(), Intl.intl("File Error"), 0);
    }

    private static String suggestArchiveName(String string) {
        String string2;
        String string3 = Actions.getResultsID(new File(string));
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        String string4 = string2 = String.format("%s_results_%d_%02d_%02d", string3, n, n2 + 1, n3);
        File file = new File(string).getParentFile();
        int n4 = 1;
        while (Actions.archiveNameExists(file, string4)) {
            string4 = string2 + "_" + n4++;
        }
        return string4;
    }

    private static boolean archiveNameExists(File file, String string) {
        for (ResultsArchive.IMethod iMethod : ResultsArchive.ALL_METHODS) {
            if (!iMethod.exists(file, string)) continue;
            return true;
        }
        return false;
    }

    private static <T extends IDevice> DeviceDlg<T> newDevcDlg(Class<T> clazz, Function<PyroMod, ? extends IDevcEditor<T>> function) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        IDevcEditor<T> iDevcEditor = function.apply(pyroMod);
        if (iDevcEditor == null) {
            System.err.println("No device editor for " + clazz);
            return null;
        }
        return new DeviceDlg<T>(pyroSim.getActiveFrame(), pyroMod, clazz, iDevcEditor);
    }

    public static <T extends IDevice> void editDevice(final T t, int n) {
        final DeviceDlg<?> deviceDlg = Actions.newDevcDlg(t.getClass(), pyroMod -> {
            IDevcEditor<?> iDevcEditor = DevcEditorFactory.create(pyroMod, t.getClass(), IDevcEditor.Mode.EDIT, n);
            return iDevcEditor;
        });
        if (deviceDlg == null) {
            return;
        }
        PyroSim pyroSim = PyroSim.getApp();
        final PyroMod pyroMod2 = pyroSim.getMediator();
        deviceDlg.load(t);
        if (deviceDlg.doModal() == 1) {
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    pyroMod2.pauseUpdates();
                    deviceDlg.save(t);
                    pyroMod2.resumeUpdates();
                }
            };
            pyroMod2.getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Device"));
        }
    }

    private static Task uiConvertToHvac(PyroSim pyroSim, PyroMod pyroMod, Collection<? extends Vent> collection, Supplier<Boolean> supplier) {
        boolean bl = collection.stream().anyMatch(vent -> !vent.getSurface().isPredefined(PredefSurf.HVAC));
        if (bl) {
            boolean bl2 = supplier.get();
            Surface surface = pyroMod.getSurfaceMgr().get(PredefSurf.HVAC);
            if (bl2) {
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(PyroSim.getApp().getMediator());
                VentSurfSnapshot ventSurfSnapshot = new VentSurfSnapshot(surface, null);
                for (Vent vent2 : collection) {
                    if (vent2.getSurface().isPredefined(PredefSurf.HVAC)) continue;
                    compositeTask.addTask(new ConvertToHvacTask(vent2, ventSurfSnapshot));
                }
                return compositeTask;
            }
        }
        return EmptyTask.INSTANCE;
    }

    public static Action getImportDXFAction() {
        return IMPORT_ACTION;
    }

    public static Action getProtectAction() {
        return PROTECT_ACTION;
    }

    public static Action getTranslateAction() {
        return TRANSLATE_ACTION;
    }

    public static Action getMirrorAction() {
        return MIRROR_ACTION;
    }

    public static Action getScaleAction() {
        return SCALE_ACTION;
    }

    public static Action getRotateAction() {
        return ROTATE_ACTION;
    }

    public static Action getGridAction() {
        return GRID_ACTION;
    }

    public static Action getSubdivideMeshAction() {
        return SPLIT_MESH_ACTION;
    }

    public static Action getRefineMeshAction() {
        return REFINE_MESH_ACTION;
    }

    public static Action getMergeMeshAction() {
        return MERGE_MESH_ACTION;
    }

    public static AddWallAction getAddWallAction() {
        return ADD_WALL_ACTION;
    }

    public static AddVentAction getAddVentAction() {
        return ADD_VENT_ACTION;
    }

    public static AddSlabAction getAddSlabAction() {
        return ADD_SLAB_ACTION;
    }

    public static AAddPartCloudAction getAddPartCloudAction() {
        return ADD_PART_CLOUD_ACTION;
    }

    public static AddHoleAction getAddHoleAction() {
        return ADD_HOLE_ACTION;
    }

    public static RasterizeObjectsAction getRasterizeAction() {
        return RASTERIZE_OBJECTS_ACTION;
    }

    public static Action getUndoAction() {
        return UNDO_ACTION;
    }

    public static Action getRedoAction() {
        return REDO_ACTION;
    }

    public static guiAction getCopyAction() {
        return COPY_ACTION;
    }

    public static Action getCopyFDSAction() {
        return COPY_FDS_ACTION;
    }

    public static guiAction getCutAction() {
        return CUT_ACTION;
    }

    public static RemoveSelectedNodeAction getDeleteAction() {
        return REMOVE_SELECTED_NODE_ACTION;
    }

    public static EditSelectedNodeAction getEditNodeAction() {
        return EDIT_SELECTED_NODE_ACTION;
    }

    public static Action getEnableNodeAction() {
        return ENABLE_NODE_ACTION;
    }

    public static Action getDisableNodeAction() {
        return DISABLE_NODE_ACTION;
    }

    public static Action getHideNodeAction() {
        return HIDE_NODE_ACTION;
    }

    public static Action getHideUnselectedNodeAction() {
        return HIDE_UNSELECTED_NODE_ACTION;
    }

    public static guiAction getPasteAction() {
        return PASTE_ACTION;
    }

    public static Action getShowAllNodesAction() {
        return SHOW_ALL_NODES_ACTION;
    }

    public static Action getShowNodeAction() {
        return SHOW_NODE_ACTION;
    }

    public static AddFloorFromGeomAction getAddFloorFromGeomAction() {
        return ADD_FLOOR_FROM_GEOM_ACTION;
    }

    public static OpenGridsAction getOpenGridsAction() {
        return OPEN_GRIDS_ACTION;
    }

    public static MaterialManagerAction getMaterialManagerAction() {
        return MATERIAL_MANAGER_ACTION;
    }

    public static SurfaceManagerAction getSurfaceManagerAction() {
        return SURFACE_MANAGER_ACTION;
    }

    public static ReactionManagerAction getReactionManagerAction() {
        return REACTION_MANAGER_ACTION;
    }

    public static SprayModelManagerAction getSprayModelManagerAction() {
        return SPRAY_MODEL_MANAGER_ACTION;
    }

    public static SprinklerLinkModelManagerAction getSprinklerLinkModelManagerAction() {
        return SPRINKLER_LINK_MODEL_MANAGER_ACTION;
    }

    public static HeatLinkModelManagerAction getHeatLinkModelManagerAction() {
        return HEAT_LINK_MODEL_MANAGER_ACTION;
    }

    public static SelectByColorAction getSelectByColorAction() {
        return SELECT_BY_COLOR_ACTION;
    }

    public static Action getRunFDSAction() {
        return RUN_FDS_ACTION;
    }

    public static Action getResumeFDSAction() {
        return RESUME_FDS_ACTION;
    }

    public static Action getRunFDSmpiAction() {
        return RUN_FDS_MPI_ACTION;
    }

    public static Action getResumeFDSmpiAction() {
        return RESUME_FDS_MPI_ACTION;
    }

    public static Action getRunFDSClusterAction() {
        return RUN_FDS_CLUSTER_ACTION;
    }

    public static Action getResumeFDSClusterAction() {
        return RESUME_FDS_CLUSTER_ACTION;
    }

    public static Action getResultsPreviewAction() {
        return RESULTS_PREVIEW_ACTION;
    }

    public static Action getEditSimulationPropertiesAction() {
        return EDIT_SIMULATION_PROPERTIES_ACTION;
    }

    public static BoundaryQuantityAction getBoundaryConditionAction() {
        return BOUNDARYQUANTITY_ACTION;
    }

    public static IsosurfaceAction getIsosurfaceAction() {
        return ISOSURFACE_ACTION;
    }

    public static Plot3DAction getPlot3DAction() {
        return PLOT3D_ACTION;
    }

    public static SliceAction getSliceAction() {
        return SLICE_ACTION;
    }

    public static Slice3DAction getSlice3DAction() {
        return SLICE3D_ACTION;
    }

    public static ProfListAction getProfListAction() {
        return PROF_ACTION;
    }

    public static ParticleAction getParticleAction() {
        return PARTICLE_ACTION;
    }

    public static SmodLinkModelsAction getSmokeDetectorModelsAction() {
        return SMOD_MODELS_ACTION;
    }

    public static Action getSortAction() {
        return SORT_ACTION;
    }

    public static Action getTCPlotsAction() {
        return TC_PLOTS_ACTION;
    }

    public static Action getExSpecListAction() {
        return EXSPEC_LIST_ACTION;
    }

    public static Action getHvacListAction() {
        return EDIT_HVAC;
    }

    public static Action getCrashAction() {
        return CRASH_PYROSIM;
    }

    public static Action getEditOpenMpAction() {
        return EDIT_OPENMP_ACTION;
    }

    public static Action getFindAction() {
        return FIND_ACTION;
    }

    private static /* synthetic */ boolean lambda$getTransformObjs$138(Set set, IPyroGeomSrc iPyroGeomSrc) {
        return !set.contains(iPyroGeomSrc);
    }

    static {
        DEFAULT_ACTIONS = Arrays.asList(SET_ACTIVE_VIEW_ACTION, CONTEXT_SHOW_VIEW_CAMERA, EDIT_SELECTED_NODE_ACTION);
    }

    private static class EditOpenMpAction
    extends guiAction {
        private static final long serialVersionUID = 1903040629493204595L;

        public EditOpenMpAction() {
            super(Intl.intl("OpenMP Environment..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            SimParams simParams = pyroMod.getSimParams();
            OpenMpDlg openMpDlg = new OpenMpDlg((Window)PyroSim.getApp().getMainFrame());
            openMpDlg.initFrom(simParams.getOpenMp());
            if (openMpDlg.doModal() == 1) {
                Task task = openMpDlg.getSaveTask(simParams.getOpenMp());
                pyroMod.getTaskManager().exec(task, Intl.intl("Edit OpenMP Environment"));
            }
        }
    }

    private static class FindObjectsAction
    extends guiAction {
        private static final long serialVersionUID = -6112121873537434014L;

        public FindObjectsAction() {
            super(Intl.intl("Find Objects"), PyroGuiUtil.loadPyroSimIcon(null));
            this.putValue("ShortDescription", Intl.intl("Find objects matching a search string"));
            this.putValue("AcceleratorKey", Accelerators.FIND);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroFindDlg pyroFindDlg = new PyroFindDlg((Window)pyroSim.getActiveFrame(), pyroSim.getMediator());
            pyroFindDlg.doModeless();
        }
    }

    private static class SetObstOptionAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public SetObstOptionAction(String string, int n, boolean bl) {
            super(string, (ActionEvent actionEvent) -> {
                PyroMod pyroMod = PyroSim.getApp().getMediator();
                ArrayList<IObstruction> arrayList = new ArrayList<IObstruction>(pyroMod.getSelectionModel().flatten(IObstruction.class));
                SetObstOptionsTask setObstOptionsTask = new SetObstOptionsTask(arrayList, n, bl);
                pyroMod.getTaskManager().exec(setObstOptionsTask, string);
            });
            this.setEnabledUpdator(() -> {
                PyroMod pyroMod = PyroSim.getApp().getMediator();
                Collection<IObstruction> collection = pyroMod.getSelectionModel().flatten(IObstruction.class);
                return collection.stream().anyMatch(iObstruction -> iObstruction.getOptions(n) != bl);
            });
        }
    }

    private static class SetObstOptionsTask
    extends AUndoableTask {
        public final Collection<? extends IObstruction> obsts;
        public final int options;
        public final boolean state;
        private int[] d_prevOptions = null;

        public SetObstOptionsTask(Collection<? extends IObstruction> collection, int n, boolean bl) {
            this.obsts = collection;
            this.options = n;
            this.state = bl;
        }

        @Override
        public void run() {
            if (this.obsts.isEmpty()) {
                return;
            }
            PyroMod pyroMod = (PyroMod)this.obsts.iterator().next().getDomain();
            if (pyroMod != null) {
                pyroMod.pauseUpdates();
            }
            this.d_prevOptions = new int[this.obsts.size()];
            int n = 0;
            for (IObstruction iObstruction : this.obsts) {
                this.d_prevOptions[n++] = iObstruction.getSetOptions();
                iObstruction.setOptions(this.options, this.state);
            }
            if (pyroMod != null) {
                pyroMod.resumeUpdates();
            }
        }

        @Override
        public void undo() {
            if (this.obsts.isEmpty()) {
                return;
            }
            PyroMod pyroMod = (PyroMod)this.obsts.iterator().next().getDomain();
            if (pyroMod != null) {
                pyroMod.pauseUpdates();
            }
            int n = 0;
            for (IObstruction iObstruction : this.obsts) {
                iObstruction.setOptions(253, false);
                iObstruction.setOptions(this.d_prevOptions[n++], true);
            }
            this.d_prevOptions = null;
            if (pyroMod != null) {
                pyroMod.resumeUpdates();
            }
        }
    }

    private static class ConnectWithHvac
    extends guiAction {
        private static final long serialVersionUID = -3466016507346646669L;

        public ConnectWithHvac() {
            super(Intl.intl("Connect with HVAC..."));
            this.putValue("ShortDescription", Intl.intl("Adds HVAC nodes and connects with an HVAC duct"));
        }

        public Collection<Vent> getObjs(PyroMod pyroMod) {
            return pyroMod.getSelectionModel().getSelected(Vent.class);
        }

        public void updateEnabled(PyroMod pyroMod) {
            IFilteredCollection<Vent> iFilteredCollection = pyroMod.getSelectionModel().getSelected(Vent.class);
            boolean bl = iFilteredCollection.isExclusive() && iFilteredCollection.size() == 2;
            this.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            ArrayList<Vent> arrayList = new ArrayList<Vent>(this.getObjs(pyroMod));
            assert (arrayList.size() == 2);
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(PyroSim.getApp().getMediator());
            try {
                object = Actions.uiConvertToHvac(PyroSim.getApp(), pyroMod, arrayList, () -> {
                    String string = Intl.intl("The vents in the selection will be converted to compatible HVAC vents.");
                    int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), string, Intl.intl("Convert to HVAC Vents"), 2, 2);
                    if (n == 0) {
                        return true;
                    }
                    throw new CancellationException();
                });
                compositeTask.addTask((Task)object);
            }
            catch (CancellationException cancellationException) {
                return;
            }
            object = pyroMod.getNames(HvacNode.class);
            List<String> list = ((NameGenerator)object).generateNames(2);
            HvacNode hvacNode = ConnectWithHvac.newNode(list.get(0), (Vent)arrayList.get(0));
            HvacNode hvacNode2 = ConnectWithHvac.newNode(list.get(1), (Vent)arrayList.get(1));
            HvacDuct hvacDuct = new HvacDuct(pyroMod.getNames(HvacDuct.class).generateName());
            hvacDuct.setNodes(hvacNode, hvacNode2);
            IPyroObject iPyroObject = Hierarchy.getCommonParent(arrayList);
            Composite composite = iPyroObject instanceof Composite ? (Composite)iPyroObject : pyroMod.getObstructions();
            compositeTask.addTask(new AddAutoRenameTask(composite, new IPyroObject[]{hvacNode, hvacNode2, hvacDuct}));
            compositeTask.addTask(new SelectTask(pyroMod, hvacDuct));
            pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Connect with HVAC"));
            Actions.editSelectedNode();
        }

        private static HvacNode newNode(String string, Vent vent) {
            HvacNode hvacNode = new HvacNode(string);
            hvacNode.setVent(vent);
            return hvacNode;
        }
    }

    private static class VentSurfSnapshot {
        private final Surface d_surf;
        private final Vent.OpenProps d_openProps;

        public VentSurfSnapshot(Vent vent) {
            this.d_surf = vent.getSurface();
            this.d_openProps = vent.getOpenProps();
        }

        public VentSurfSnapshot(Surface surface, Vent.OpenProps openProps) {
            this.d_surf = surface;
            this.d_openProps = openProps;
        }

        public void apply(Vent vent) {
            vent.setSurface(this.d_surf);
            vent.setOpenProps(this.d_openProps);
        }
    }

    private static class ConvertToHvacTask
    extends AReplaceRefTask<VentSurfSnapshot> {
        private final Vent d_vent;

        public ConvertToHvacTask(Vent vent, VentSurfSnapshot ventSurfSnapshot) {
            super(new VentSurfSnapshot(vent), ventSurfSnapshot);
            this.d_vent = vent;
        }

        @Override
        protected void set(VentSurfSnapshot ventSurfSnapshot) {
            ventSurfSnapshot.apply(this.d_vent);
        }
    }

    private static class AddHvacVentNode
    extends guiAction {
        private static final long serialVersionUID = 3934500793661271882L;

        public AddHvacVentNode() {
            super(Intl.intl("Add HVAC Nodes..."));
            this.putValue("ShortDescription", Intl.intl("Add an HVAC vent node"));
        }

        @Override
        public void updateEnabled() {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.setEnabled(!pyroMod.getSelectionModel().flatten(Vent.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NamedPyroObject namedPyroObject2;
            Object object;
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            Collection<Vent> collection = pyroMod.getSelectionModel().flatten(Vent.class);
            if (collection.isEmpty()) {
                return;
            }
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(PyroSim.getApp().getMediator());
            try {
                object = Actions.uiConvertToHvac(PyroSim.getApp(), pyroMod, collection, () -> {
                    String string = Intl.intl("Nodes can only be added for HVAC vents. Would you like to\nconvert all vents in the selection to compatible vents?");
                    int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), string, Intl.intl("Convert to HVAC Vents?"), 1, 3);
                    if (n == 0) {
                        return true;
                    }
                    if (n == 1) {
                        return false;
                    }
                    throw new CancellationException();
                });
                if (object == EmptyTask.INSTANCE) {
                    collection = new ArrayList<Vent>(theUtil.filter(collection, new Predicate<Vent>(){

                        @Override
                        public boolean test(Vent vent) {
                            return vent.getSurface().isPredefined(PredefSurf.HVAC);
                        }
                    }));
                } else {
                    compositeTask.addTask((Task)object);
                }
            }
            catch (CancellationException cancellationException) {
                return;
            }
            object = new ArrayList(collection.size());
            List<String> list = pyroMod.getNames(HvacNode.class).generateNames(collection.size());
            int n = 0;
            for (NamedPyroObject namedPyroObject2 : collection) {
                String string = list.get(n++);
                HvacNode hvacNode = new HvacNode(string);
                hvacNode.setVent((Vent)namedPyroObject2);
                object.add(hvacNode);
            }
            IPyroObject iPyroObject = Hierarchy.getCommonParent(collection);
            namedPyroObject2 = iPyroObject instanceof Composite ? (Composite)iPyroObject : pyroMod.getObstructions();
            compositeTask.addTask(new AddAutoRenameTask(namedPyroObject2, object));
            pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Add HVAC Vent Nodes"));
        }
    }

    private static class EditHvac
    extends guiAction {
        private static final long serialVersionUID = 7114950057820074299L;
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("hvac_fan16.png");

        public EditHvac() {
            super(Intl.intl("Edit HVAC..."), ICON);
            this.putValue("ShortDescription", Intl.intl("Edit an HVAC Component"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editHvac(Collections.EMPTY_LIST);
        }
    }

    private static class NewDeviceAction<T extends IDevice>
    extends guiAction {
        private static final long serialVersionUID = -2753847817063318197L;
        private final Class<T> d_class;
        private final Function<PyroMod, ? extends IDevcEditor<T>> d_editor;

        public NewDeviceAction(String string, Class<T> clazz, int n) {
            this(string, clazz, null, n);
        }

        public NewDeviceAction(String string, Class<T> clazz, Icon icon, int n) {
            this(string, clazz, icon, pyroMod -> {
                IDevcEditor iDevcEditor = DevcEditorFactory.create(pyroMod, clazz, IDevcEditor.Mode.CREATE, n);
                return iDevcEditor;
            });
        }

        public NewDeviceAction(String string, Class<T> clazz, Icon icon, Function<PyroMod, ? extends IDevcEditor<T>> function) {
            super(string, icon);
            this.d_class = clazz;
            this.d_editor = function;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            DeviceDlg deviceDlg = Actions.newDevcDlg(this.d_class, this.d_editor);
            if (deviceDlg == null) {
                return;
            }
            if (deviceDlg.doModal() == 1) {
                Object var5_5 = deviceDlg.save(null);
                SelectTask selectTask = new SelectTask(pyroMod, (Object)var5_5);
                selectTask.addTask(new AddTask((IPyroObject)pyroMod.getDevices(), new IPyroObject[]{var5_5}));
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Device"));
            }
        }
    }

    private static class SelectHvacNetwork
    extends guiAction {
        private static final long serialVersionUID = 6100450032999815574L;

        public SelectHvacNetwork() {
            super(Intl.intl("Select HVAC Network"));
            this.putValue("ShortDescription", Intl.intl("Select the entire HVAC network containing the selected objects."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            pyroSim.beginWaitCursor();
            Collection<IPyroObject> collection = this.getSelection(pyroSim.getMediator());
            IdentityHashMap<IPyroObject, Collection> identityHashMap = new IdentityHashMap<IPyroObject, Collection>();
            Function<IPyroObject, Collection> function = iPyroObject -> new ArrayList();
            for (HvacDuct cloneable2 : ((APyroObject)pyroMod.getObstructions()).flatten(HvacDuct.class)) {
                for (HvacNode hvacNode : cloneable2.getNodes()) {
                    if (hvacNode == null) continue;
                    object2 = identityHashMap.computeIfAbsent(hvacNode, function);
                    object2.add(cloneable2);
                }
            }
            for (HvacNode hvacNode : ((APyroObject)pyroMod.getObstructions()).flatten(HvacNode.class)) {
                if (hvacNode.getNodeType() != HvacNode.NodeType.VENT || hvacNode.getVent() == null) continue;
                object = identityHashMap.computeIfAbsent(hvacNode.getVent(), function);
                object.add(hvacNode);
            }
            ArrayList arrayList = new ArrayList();
            ArrayDeque<IPyroObject> arrayDeque = new ArrayDeque<IPyroObject>(collection);
            object = new IdentityHashSet<IPyroObject>(collection);
            while (!arrayDeque.isEmpty()) {
                Object object32;
                IPyroObject iPyroObject2 = (IPyroObject)arrayDeque.removeFirst();
                arrayList.add(iPyroObject2);
                for (Object object32 : (Collection)identityHashMap.getOrDefault(iPyroObject2, Collections.emptyList())) {
                    if (!object.add(object32)) continue;
                    arrayDeque.addLast((IPyroObject)object32);
                }
                if (iPyroObject2 instanceof HvacNode) {
                    object2 = (HvacNode)iPyroObject2;
                    if (((HvacNode)object2).getNodeType() != HvacNode.NodeType.VENT || (object32 = ((HvacNode)object2).getVent()) == null || !object.add(object32)) continue;
                    arrayDeque.addLast((IPyroObject)object32);
                    continue;
                }
                if (!(iPyroObject2 instanceof HvacDuct)) continue;
                object2 = (HvacDuct)iPyroObject2;
                object32 = ((HvacDuct)object2).getNodes().iterator();
                while (object32.hasNext()) {
                    HvacNode hvacNode = (HvacNode)object32.next();
                    if (hvacNode == null || !object.add(hvacNode)) continue;
                    arrayDeque.addLast(hvacNode);
                }
            }
            pyroMod.getTaskManager().exec(new SelectTask(pyroMod, arrayList), Intl.intl("Select HVAC Network"));
            pyroSim.endWaitCursor();
            String string = arrayList.isEmpty() ? Intl.intl("No objects selected") : String.format(Intl.intl("%d objects selected"), arrayList.size());
            JOptionPane.showMessageDialog(pyroSim.getActiveFrame(), string);
        }

        public void updateState(PyroMod pyroMod) {
            boolean bl = !this.getSelection(pyroMod).isEmpty();
            this.setEnabled(bl);
        }

        private Collection<IPyroObject> getSelection(PyroMod pyroMod) {
            return pyroMod.getSelectionModel().flatten(IPyroObject.class, iPyroObject -> iPyroObject instanceof IHvacGeomComp || iPyroObject instanceof Vent && ((Vent)iPyroObject).getSurface().isPredefined(PredefSurf.HVAC));
        }
    }

    private static class DisableForceToWriteAction
    extends AForceToWriteAction {
        private static final long serialVersionUID = 7970169758889109186L;

        public DisableForceToWriteAction() {
            super(Intl.intl("Disable Always Write"));
        }

        @Override
        boolean getEnabled() {
            return false;
        }
    }

    private static class EnableForceToWriteAction
    extends AForceToWriteAction {
        private static final long serialVersionUID = 2883115053592738359L;

        public EnableForceToWriteAction() {
            super(Intl.intl("Enable Always Write"));
        }

        @Override
        boolean getEnabled() {
            return true;
        }
    }

    private static abstract class AForceToWriteAction
    extends guiAction {
        private static final long serialVersionUID = 5798507937509893201L;

        public AForceToWriteAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            pyroSim.beginWaitCursor();
            Collection<NamedPyroObject> collection = this.getSelection(pyroMod);
            NamedPyroObject[] namedPyroObjectArray = new NamedPyroObject[collection.size()];
            collection.toArray(namedPyroObjectArray);
            pyroMod.getTaskManager().exec(new SetForceWriteTask(this.getEnabled(), namedPyroObjectArray), "Set Force Write");
            pyroSim.endWaitCursor();
        }

        private Collection<NamedPyroObject> getSelection(PyroMod pyroMod) {
            return pyroMod.getSelectionModel().getSelected(NamedPyroObject.class);
        }

        abstract boolean getEnabled();

        public void updateState(PyroMod pyroMod) {
            Collection<NamedPyroObject> collection = this.getSelection(pyroMod);
            boolean bl = false;
            for (NamedPyroObject namedPyroObject : collection) {
                if (namedPyroObject.isForceWrite() == this.getEnabled() || namedPyroObject instanceof Surface && ((Surface)namedPyroObject).isPredefined() || namedPyroObject instanceof AFDSObject || namedPyroObject instanceof Composite) continue;
                bl = true;
                break;
            }
            this.setEnabled(bl);
        }
    }

    private static class SetAsDefaultSurfAction
    extends guiAction {
        private static final long serialVersionUID = 7406551533016012983L;

        public SetAsDefaultSurfAction() {
            super(Intl.intl("Set as the Default Surface"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            SimParams.Misc misc = pyroMod.getSimParams().getMisc();
            IFilteredCollection<Surface> iFilteredCollection = pyroMod.getSelectionModel().getSelected(Surface.class);
            if (iFilteredCollection.size() != 1) {
                return;
            }
            Surface surface = (Surface)iFilteredCollection.iterator().next();
            pyroMod.getTaskManager().exec(misc.taskSetSurfDefault(surface), Intl.intl("Set Default Surface"));
        }
    }

    private static class ClearBackgroundSpecAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ClearBackgroundSpecAction() {
            super(Intl.intl("Set Species as Non-Background"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            Task task = pyroMod.getExSpecList().taskSetBackgroundSpecies(null);
            pyroMod.getTaskManager().exec(task, this.getName());
        }
    }

    private static class SetBackgroundSpecAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public SetBackgroundSpecAction() {
            super(Intl.intl("Set as Background Species"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            IFilteredCollection<ExSpec> iFilteredCollection = pyroMod.getSelectionModel().getSelected(ExSpec.class);
            if (iFilteredCollection.size() != 1) {
                return;
            }
            Task task = pyroMod.getExSpecList().taskSetBackgroundSpecies((ExSpec)iFilteredCollection.iterator().next());
            pyroMod.getTaskManager().exec(task, Intl.intl("Set Background Species"));
        }
    }

    private static class ClearReactionAction
    extends guiAction {
        private static final long serialVersionUID = 2848291704782496755L;

        public ClearReactionAction() {
            super(Intl.intl("Set Reaction Inactive"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            IFilteredCollection<Reaction> iFilteredCollection = pyroMod.getSelectionModel().getSelected(Reaction.class);
            if (iFilteredCollection.size() != 1) {
                return;
            }
            Task task = pyroMod.getReactions().taskClearActiveReaction((Reaction)iFilteredCollection.iterator().next());
            pyroMod.getTaskManager().exec(task, Intl.intl("Set Reaction Inactive"));
        }
    }

    private static class SetReactionAction
    extends guiAction {
        private static final long serialVersionUID = -440688445518228251L;

        public SetReactionAction() {
            super(Intl.intl("Set as Active Reaction"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            IFilteredCollection<Reaction> iFilteredCollection = pyroMod.getSelectionModel().getSelected(Reaction.class);
            if (iFilteredCollection.size() != 1) {
                return;
            }
            Task task = pyroMod.getReactions().taskSetActiveReaction((Reaction)iFilteredCollection.iterator().next());
            pyroMod.getTaskManager().exec(task, Intl.intl("Set Active Reaction"));
        }
    }

    private static class ExtrudeLinesAction
    extends guiAction {
        private static final long serialVersionUID = -4524190554003085090L;

        public ExtrudeLinesAction() {
            super(Intl.intl("Convert CAD lines into Walls"));
            this.putValue("ShortDescription", Intl.intl("Convert CAD lines into walls by extruding up."));
        }

        private Collection<GenericGeomSrc> getObjects() {
            return PyroSim.getApp().getMediator().getSelectionModel().flatten(GenericGeomSrc.class, new Predicate<GenericGeomSrc>(){

                @Override
                public boolean test(GenericGeomSrc genericGeomSrc) {
                    int n = genericGeomSrc.getGeom().getNumPrims(2);
                    return n != 0 && n == genericGeomSrc.getGeom().getNumPrims(7);
                }
            });
        }

        @Override
        public void updateEnabled() {
            this.setEnabled(!this.getObjects().isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection<GenericGeomSrc> collection = this.getObjects();
            if (collection.isEmpty()) {
                return;
            }
            ConvertCadLinesDlg convertCadLinesDlg = new ConvertCadLinesDlg(PyroSim.getApp().getMainFrame());
            if (convertCadLinesDlg.doModal() != 1) {
                return;
            }
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            double d = convertCadLinesDlg.getWallThickness().get(SI.METER);
            double d2 = convertCadLinesDlg.getWallHeight().get(SI.METER);
            WallGeom.Alignment alignment = WallGeom.Alignment.CENTER;
            Surface[] surfaceArray = new Surface[]{pyroMod.getDefaultSurface()};
            ArrayList<GenericGeomSrc> arrayList = new ArrayList<GenericGeomSrc>(collection.size());
            ArrayList<Obstruction> arrayList2 = new ArrayList<Obstruction>(collection.size());
            for (GenericGeomSrc genericGeomSrc : collection) {
                IGeomNode iGeomNode = genericGeomSrc.getGeom();
                IPropsSrc iPropsSrc = genericGeomSrc.getDisplayProps();
                List list = GeomUtil.explode(iGeomNode.flatten().getLocalGeom(), ICurve.class);
                ArrayList<WallGeom> arrayList3 = new ArrayList<WallGeom>(list.size());
                ArrayList<Color> arrayList4 = new ArrayList<Color>();
                for (int i = 0; i < list.size(); ++i) {
                    IPrimProps iPrimProps = iPropsSrc.get(i);
                    ICurve iCurve = (ICurve)list.get(i);
                    WallGeom wallGeom = new WallGeom(iCurve, alignment, d, d2);
                    arrayList3.add(wallGeom);
                    for (int j = 0; j < wallGeom.getNumPrims(7); ++j) {
                        arrayList4.add(iPrimProps.getColor());
                    }
                }
                iGeomNode = GeomNodeUtil.newNode(GeomUtil.group(arrayList3));
                Obstruction obstruction = new Obstruction(genericGeomSrc.getName(), iGeomNode, surfaceArray);
                obstruction.setColors(pyrosim.domain.GeomUtil.optimize(theUtil.toArray(arrayList4, Color.class)));
                arrayList.add(genericGeomSrc);
                arrayList2.add(obstruction);
            }
            SelectTask selectTask = new SelectTask(pyroMod, arrayList2);
            selectTask.addTask(new ReplacePreserveTask(arrayList, arrayList2));
            pyroMod.getTaskManager().exec(selectTask, Intl.intl("Convert Lines to Walls"));
        }
    }

    private static class TCPlotsAction
    extends guiAction {
        private static final long serialVersionUID = 2337901439261898105L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/results2D16.gif");

        public TCPlotsAction() {
            super(Intl.intl("Plot Time History Results") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            JFrame jFrame = pyroSim.getMainFrame();
            File[] fileArray = Actions.getFDSFiles();
            File file = fileArray == null ? null : fileArray[3];
            File file2 = pyroSim.getFilenameManager().getOpenFile((Component)jFrame, Intl.intl("Choose a Time History Plot"), file, "csv", Intl.intl("CSV Data"));
            if (file2 == null) {
                return;
            }
            try {
                TimeHistoryData timeHistoryData = new TimeHistoryData(file2);
                TimeHistoryPlotDlg timeHistoryPlotDlg = new TimeHistoryPlotDlg(jFrame, timeHistoryData);
                timeHistoryPlotDlg.setVisible(true);
            }
            catch (Throwable throwable) {
                guiUtil.showError(jFrame, Intl.intl("CSV Error"), String.format(Intl.intl("Error Reading %s"), file2.getName()), throwable);
            }
        }
    }

    private static class TimeHistoryResultsAction
    extends ViewResultsAction {
        private static final long serialVersionUID = 3455292903861794750L;
        private final int d_fileIx;

        public TimeHistoryResultsAction(String string, Icon icon, int n) {
            super(string, new DecoratedIcon(PyroGuiUtil.loadPyroSimIcon("results2D16.gif"), icon, 3));
            this.d_fileIx = n;
        }

        @Override
        protected File getResultsFile() {
            File[] fileArray = Actions.getFDSFiles();
            if (fileArray != null) {
                return fileArray[this.d_fileIx];
            }
            return null;
        }

        @Override
        protected void showResults(File file) {
            JFrame jFrame = PyroSim.getApp().getActiveFrame();
            try {
                TimeHistoryData timeHistoryData = new TimeHistoryData(file);
                TimeHistoryPlotDlg timeHistoryPlotDlg = new TimeHistoryPlotDlg(jFrame, timeHistoryData);
                timeHistoryPlotDlg.setVisible(true);
            }
            catch (Throwable throwable) {
                guiUtil.showError(jFrame, Intl.intl("CSV Error"), String.format(Intl.intl("Error Reading %s"), file.getName()), throwable);
            }
        }
    }

    private static class SortAction
    extends guiAction {
        private static final long serialVersionUID = -3609795906592900294L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/sorttree.gif");

        public SortAction() {
            super(Intl.intl("Sort by Name"), ICON);
            this.putValue("ShortDescription", Intl.intl("Sort by Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<Composite> iFilteredCollection = pyroMod.getSelectionModel().getSelected(Composite.class);
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            for (Composite composite : iFilteredCollection) {
                compositeTask.addTask(new SortByNameTask(composite));
            }
            pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Sort by Name"));
        }
    }

    private static class ResultsPreviewAction
    extends guiAction
    implements Runnable {
        private static final long serialVersionUID = -8495001270655031766L;
        private static final ImageIcon ICON = null;

        public ResultsPreviewAction() {
            super(Intl.intl("Preview Model in Results") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(this).start();
        }

        @Override
        public void run() {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            pyroMod.pauseUpdates(false);
            UnitDouble unitDouble = pyroMod.getSimParams().getTime().getStartTime();
            pyroMod.getSimParams().getTime().setStartTime(new UnitDouble(0.0, SI.SECOND));
            UnitDouble unitDouble2 = pyroMod.getSimParams().getTime().getStopTime();
            pyroMod.getSimParams().getTime().setStopTime(new UnitDouble(0.0, SI.SECOND));
            File file = null;
            try {
                file = File.createTempFile("pyrosim", ".data");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(Application.getApp().getMainFrame(), Intl.intl("An error occurred trying to create a temporary file."), Intl.intl("Temporary File Error"), 0);
                pyroMod.resumeUpdates();
                return;
            }
            boolean bl = pyroSim.writeFDSFile(file, false);
            pyroMod.getSimParams().getTime().setStartTime(unitDouble);
            pyroMod.getSimParams().getTime().setStopTime(unitDouble2);
            pyroMod.resumeUpdates();
            if (bl) {
                FDSRunMonitor fDSRunMonitor = new FDSRunMonitor(Intl.intl("Preview") + " - " + file.getName(), file.getAbsolutePath());
                fDSRunMonitor.previewResults(pyroMod.getSimParams().getOpenMp());
            }
        }
    }

    private static class RestoreResultsAction
    extends guiAction {
        private static final long serialVersionUID = -7446116802125072040L;

        public RestoreResultsAction() {
            super(Intl.intl("Restore FDS Results..."));
        }

        private List<ResultsArchive.Record> getActiveRecords() {
            String string = PyroSim.getApp().getFilename();
            if (string == null) {
                return Collections.EMPTY_LIST;
            }
            ResultsArchive resultsArchive = PyroSim.getApp().getMediator().getResultsArchive();
            return resultsArchive.getActiveArchives(new File(string).getParentFile());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.getApp().beginWaitCursor();
            try {
                this.run();
            }
            finally {
                PyroSim.getApp().endWaitCursor();
            }
        }

        private void run() {
            List<ResultsArchive.Record> list = this.getActiveRecords();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("There are currently no archived results."), Intl.intl("No Archived Results"), 2);
                return;
            }
            File file = Actions.getResultsDir();
            if (!file.exists()) {
                file = Actions.getDefaultResultsDir(new File(PyroSim.getApp().getFilename()));
            }
            RestoreResultsDlg restoreResultsDlg = new RestoreResultsDlg((Window)PyroSim.getApp().getActiveFrame());
            restoreResultsDlg.setDefaultDestination(file);
            restoreResultsDlg.load(list);
            if (restoreResultsDlg.doModal() != 1) {
                return;
            }
            file = restoreResultsDlg.getDestinationDir();
            File file2 = new File(PyroSim.getApp().getFilename()).getParentFile();
            boolean bl = restoreResultsDlg.getRetainArchive();
            ResultsArchive.Record record = restoreResultsDlg.getSelectedRecord();
            File file3 = RestoreResultsAction.getTempResultsDir(file);
            try {
                record.method.restore(file2, record.name, file3, bl);
                for (File file4 : IOUtil.listFiles(file)) {
                    if (file4.getName().equals(file3.getName())) continue;
                    IOUtil.delete(file4);
                }
                for (File file4 : IOUtil.listFiles(file3)) {
                    File file5;
                    if (file4.renameTo(file5 = new File(file, file4.getName()))) continue;
                    String string = String.format(Intl.intl("Cannot rename %1$s to %2$s."), file3.getAbsolutePath(), file.getAbsolutePath());
                    throw new IOException(string);
                }
                IOUtil.delete(file3);
            }
            catch (IOException iOException) {
                Actions.showRestoreIOException(iOException);
                try {
                    if (file3.exists()) {
                        IOUtil.delete(file3);
                    }
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                    return;
                }
                return;
            }
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("Archive, \"%1$s,\" successfully restored to%n%2$s."), record.name, file.getAbsolutePath()), Intl.intl("Archive Restored"), 1);
        }

        private static File getTempResultsDir(File file) {
            File file2 = file;
            String string = file.getName();
            File file3 = new File(file2, "~" + string);
            int n = 1;
            while (file3.exists()) {
                file3 = new File(file2, "~" + string + "_" + n++);
            }
            return file3;
        }
    }

    private static class ArchiveResultsAction
    extends guiAction {
        private static final long serialVersionUID = 8423782582048981884L;

        public ArchiveResultsAction() {
            super(Intl.intl("Archive FDS Results..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.getApp().beginWaitCursor();
            try {
                Actions.archiveResults(Actions.getResultsDir());
            }
            catch (CancelledException cancelledException) {
            }
            finally {
                PyroSim.getApp().endWaitCursor();
            }
        }
    }

    private static class RunResultsAction
    extends guiAction
    implements Runnable {
        private static final long serialVersionUID = 3775970234632272022L;
        private final Consumer<File> d_run;
        private volatile File d_tempFile;

        public RunResultsAction(String string, Icon icon, Consumer<File> consumer) {
            super(string, icon);
            this.d_run = consumer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            File[] fileArray = Actions.getFDSFiles();
            File file = fileArray == null ? null : fileArray[2];
            this.d_tempFile = pyroSim.getFilenameManager().getOpenFile((Component)pyroSim.getMainFrame(), Intl.intl("Open"), file, "smv", Intl.intl("Smokeview Files"));
            if (this.d_tempFile == null) {
                return;
            }
            new Thread(this).start();
        }

        @Override
        public void run() {
            File file = this.d_tempFile;
            if (file != null) {
                this.d_run.accept(file);
            }
        }
    }

    private static class Results3dAction
    extends ViewResultsAction {
        private static final long serialVersionUID = 6453125073690686274L;

        public Results3dAction() {
            super(Intl.intl("View Results"), PyroGuiUtil.loadPyroSimIcon("burn16.png"));
        }

        @Override
        protected File getResultsFile() {
            File[] fileArray = Actions.getFDSFiles();
            if (fileArray != null) {
                return fileArray[2];
            }
            return null;
        }

        @Override
        protected void showResults(final File file) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    this.runResults(file);
                }
            };
            new Thread(runnable).start();
        }

        private void runResults(File file) {
            FDSRunMonitor.showResults(FDSRunMonitor.ResultsApp.RESULTS, null, file);
        }
    }

    private static abstract class ViewResultsAction
    extends guiAction
    implements IEventObserver {
        private static final long serialVersionUID = -2275722072265128579L;

        public ViewResultsAction(String string, Icon icon) {
            super(string, icon);
            this.putValue("ShortDescription", this.getName());
            PyroSim.getApp().getMediator().getEvents().addObserver(this);
            this.setEnabledUpdator(() -> {
                File file = this.getResultsFile();
                return file != null && file.exists();
            });
            ActionListener actionListener = actionEvent -> this.updateEnabled();
            Timer timer = new Timer(2000, actionListener);
            timer.setCoalesce(true);
            timer.start();
        }

        protected abstract File getResultsFile();

        protected abstract void showResults(File var1);

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = this.getResultsFile();
            if (file != null && file.exists()) {
                this.showResults(file);
            } else {
                String string = file == null ? Intl.intl("Results do not exist.") : String.format(Intl.intl("Cannot find %s."), file.getAbsolutePath());
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), string, Intl.intl("Missing Results"), 2);
            }
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_FILENAME_CHANGED)) {
                this.updateEnabled();
            }
        }
    }

    public static abstract class ARunFDSAction
    extends guiAction
    implements IRunFDSAction {
        private static final long serialVersionUID = -6295012538846486394L;
        private final FDSRun.Mode d_mode;
        protected File d_outFile;

        public ARunFDSAction(String string, Icon icon, FDSRun.Mode mode) {
            super(string, icon);
            this.putValue("ShortDescription", this.getName());
            this.d_mode = mode;
        }

        protected abstract File[] getFDSFiles(File var1) throws CancelledException;

        protected void makeModelChanges(PyroMod pyroMod) throws CancelledException {
        }

        protected boolean showOverwriteWarn() {
            return true;
        }

        private void getOverwriteWarning(File file, File[] fileArray, PyroSim pyroSim) throws CancelledException {
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = file.getName().split("\\.")[0];
            String string2 = "";
            if (string.length() > 40) {
                string2 = Intl.intl("Warning: Your filename is longer than 40 characters.\nDifferences in filename past the 40th character will be dropped in the CHID parameter.\nThis may result in overwriting of existing data if the first 40 characters are the same as existing output data filenames.\n\n");
            }
            for (File file2 : fileArray) {
                if (!file2.exists()) continue;
                arrayList.add(file2);
            }
            if (!arrayList.isEmpty() && this.showOverwriteWarn()) {
                string2 = string2.concat(String.format(Intl.intl("Output already exists in %s.%nWould you like to overwrite and continue?"), fileArray[0].getParent()));
                int n = JOptionPane.showConfirmDialog(pyroSim.getActiveFrame(), string2, Intl.intl("Overwrite Output?"), 0);
                if (n != 0) {
                    throw new CancelledException();
                }
            }
        }

        private void prepare() throws IOException, CancelledException {
            PyroSim pyroSim = PyroSim.getApp();
            File file = null;
            if (pyroSim.getPromptOnNextSave()) {
                file = pyroSim.promptSaveFile();
                if (file == null) {
                    throw new CancelledException();
                }
            } else {
                file = new File(pyroSim.getFilename());
            }
            File[] fileArray = this.getFDSFiles(file);
            this.getOverwriteWarning(file, fileArray, pyroSim);
            this.d_outFile = fileArray[0];
            File file2 = this.d_outFile.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                JOptionPane.showMessageDialog(pyroSim.getActiveFrame(), String.format(Intl.intl("Could not create directory, \"%s\"."), file2.getAbsolutePath()), Intl.intl("Error"), 0);
                throw new CancelledException();
            }
            String string = FilenameManager.equal(this.d_outFile, Actions.getDefaultFDSInputFile(file)) ? null : this.d_outFile.getAbsolutePath();
            FDSRun fDSRun = new FDSRun(this.d_mode, string);
            pyroSim.getMediator().pauseUpdates();
            pyroSim.getMediator().setLastFDSRun(fDSRun);
            this.makeModelChanges(pyroSim.getMediator());
            pyroSim.getMediator().resumeUpdates();
            if (pyroSim.getPromptOnNextSave() && !pyroSim.doSave(file)) {
                throw new CancelledException();
            }
            File file3 = new File(this.d_outFile.getParentFile(), file.getName());
            if (PyroPrefs.getBoolean(PyroPrefs.AUTOSAVE_ON_RUN_FDS)) {
                if (!pyroSim.saveIfModified()) {
                    throw new CancelledException();
                }
                try {
                    CopyFile.copyFileStream(file, file3);
                }
                catch (IOException iOException) {
                    Actions.showIOException(iOException, Intl.intl("Could not copy PyroSim file to FDS output directory."));
                    throw new CancelledException();
                }
            }
            try (PyroSimObjectOutputStream pyroSimObjectOutputStream = new PyroSimObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file3)));){
                PyroSim.getApp().writeModel(PyroSim.getApp().getMediator(), pyroSimObjectOutputStream);
            }
            catch (IOException iOException) {
                Actions.showIOException(iOException, Intl.intl("Could not write PyroSim file to FDS output directory."));
                throw new CancelledException();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.prepare();
            }
            catch (CancelledException cancelledException) {
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                PyroSim.getApp().error(Intl.intl("Unknown Error"), String.format("%s: %s", Intl.intl("Message:"), exception.getLocalizedMessage()));
                return;
            }
            new Thread(this).start();
        }
    }

    public static interface IRunFDSAction
    extends Runnable {
        public File getFDSFile(File var1, PyroMod var2);
    }

    private static class RunFDSClusterAction
    extends ARunFDSAction {
        private static final long serialVersionUID = -5511615526467851768L;
        private Map<String, Integer> d_hosts;

        public RunFDSClusterAction() {
            super(Intl.intl("Run FDS Cluster..."), (Icon)PyroGuiUtil.loadPyroSimIcon("runcluster.png"), FDSRun.Mode.CLUSTER);
        }

        private List<Grid> getActiveGrids(PyroMod pyroMod) {
            Collection<Grid> collection = pyroMod.getGridManager().flatten(new Predicate<Grid>(){

                @Override
                public boolean test(Grid grid) {
                    return grid.isEnabled();
                }
            });
            return new ArrayList<Grid>(collection);
        }

        @Override
        public File getFDSFile(File file, PyroMod pyroMod) {
            FDSClusterOptions fDSClusterOptions = pyroMod.getClusterOptions();
            if (fDSClusterOptions != null) {
                return new File(fDSClusterOptions.lastFDSLocation);
            }
            return pyroMod.getLastFDSRun().fdsFilepath != null ? new File(pyroMod.getLastFDSRun().fdsFilepath) : Actions.getDefaultFDSInputFile(file);
        }

        @Override
        protected File[] getFDSFiles(File file) throws CancelledException {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            List<Grid> list = this.getActiveGrids(pyroMod);
            ClusterFDSDlg clusterFDSDlg = new ClusterFDSDlg(pyroSim.getMainFrame(), list, pyroMod);
            File file2 = this.getFDSFile(file, pyroMod);
            clusterFDSDlg.setFDSFile(file2);
            FDSClusterOptions fDSClusterOptions = pyroMod.getClusterOptions();
            if (fDSClusterOptions != null) {
                clusterFDSDlg.setHosts(fDSClusterOptions.hosts);
            }
            if (clusterFDSDlg.doModal() != 1) {
                throw new CancelledException();
            }
            this.d_hosts = clusterFDSDlg.getHosts();
            return Actions.getFDSFiles(clusterFDSDlg.getOutFile());
        }

        @Override
        protected void makeModelChanges(PyroMod pyroMod) throws CancelledException {
            if (pyroMod.getClusterOptions() != null) {
                pyroMod.getEvents().removeObserver(pyroMod.getClusterOptions());
            }
            FDSClusterOptions fDSClusterOptions = new FDSClusterOptions(this.d_outFile.getAbsolutePath(), this.d_hosts);
            pyroMod.getEvents().addObserver(fDSClusterOptions);
            pyroMod.setClusterOptions(fDSClusterOptions);
        }

        private Map<String, Integer> limitHosts(Map<String, Integer> map) {
            List<Grid> list = this.getActiveGrids(PyroSim.getApp().getMediator());
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>(map.size());
            int n = list.size();
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                int n2 = Math.min(n, entry.getValue());
                if (n2 == 0) continue;
                linkedHashMap.put(entry.getKey(), n2);
                if ((n -= n2) != 0) continue;
                break;
            }
            return linkedHashMap;
        }

        @Override
        public void run() {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            if (!PyroSim.getApp().writeFDSFile(this.d_outFile, false)) {
                JOptionPane.showMessageDialog(pyroSim.getMainFrame(), Intl.intl("Unable to write FDS file."));
                return;
            }
            File file = new File(PyroPrefs.getFDSLocation());
            PyroMod pyroMod = pyroSim.getMediator();
            int n = Math.max(1, pyroMod.getGridManager().flatten().size());
            if (!Actions.validateModel(pyroSim, pyroMod)) {
                return;
            }
            FDSRunMonitor fDSRunMonitor = new FDSRunMonitor(Intl.intl("FDS Cluster") + " - " + this.d_outFile.getName(), this.d_outFile.getAbsolutePath());
            fDSRunMonitor.startClusterFDS(this.limitHosts(this.d_hosts), n, file, pyroMod.getSimParams().getOpenMp());
        }
    }

    private static class RunFDSmpiAction
    extends ARunFDSAction {
        private static final long serialVersionUID = -7891598376681965087L;

        public RunFDSmpiAction() {
            super(Intl.intl("Run FDS Parallel") + "...", (Icon)PyroGuiUtil.loadPyroSimIcon("runparallel16.png"), FDSRun.Mode.PARALLEL);
        }

        @Override
        public File getFDSFile(File file, PyroMod pyroMod) {
            return Actions.getDefaultFDSInputFile(file);
        }

        @Override
        protected File[] getFDSFiles(File file) throws CancelledException {
            return Actions.getFDSFiles(this.getFDSFile(file, PyroSim.getApp().getMediator()));
        }

        @Override
        public void run() {
            Serializable serializable2;
            PyroMod pyroMod;
            PyroSim pyroSim = (PyroSim)Application.getApp();
            if (!Actions.validateModel(pyroSim, pyroMod = pyroSim.getMediator())) {
                return;
            }
            int n = 0;
            for (Serializable serializable2 : pyroMod.getGridManager().flatten()) {
                if (!((APyroObject)serializable2).isEnabled()) continue;
                ++n;
            }
            int n2 = Math.max(1, n);
            serializable2 = this.d_outFile;
            if (serializable2 == null || !PyroSim.getApp().writeFDSFile((File)serializable2, false)) {
                return;
            }
            FDSRunMonitor fDSRunMonitor = new FDSRunMonitor(Intl.intl("FDS Parallel") + " - " + ((File)serializable2).getName(), ((File)serializable2).getAbsolutePath());
            fDSRunMonitor.startFDSmpi(n2, pyroMod.getSimParams().getOpenMp());
        }
    }

    private static class RunFDSAction
    extends ARunFDSAction {
        private static final long serialVersionUID = 6124293910171361477L;

        public RunFDSAction() {
            super(Intl.intl("Run FDS") + "...", (Icon)PyroGuiUtil.loadPyroSimIcon("run16.png"), FDSRun.Mode.SINGLE);
        }

        @Override
        public File getFDSFile(File file, PyroMod pyroMod) {
            return Actions.getDefaultFDSInputFile(file);
        }

        @Override
        protected File[] getFDSFiles(File file) throws CancelledException {
            return Actions.getFDSFiles(this.getFDSFile(file, PyroSim.getApp().getMediator()));
        }

        @Override
        public void run() {
            PyroMod pyroMod;
            PyroSim pyroSim = (PyroSim)Application.getApp();
            if (!Actions.validateModel(pyroSim, pyroMod = pyroSim.getMediator())) {
                return;
            }
            File file = this.d_outFile;
            if (file == null || !pyroSim.writeFDSFile(file, false)) {
                return;
            }
            FDSRunMonitor fDSRunMonitor = new FDSRunMonitor(Intl.intl("FDS Simulation") + " - " + file.getName(), file.getAbsolutePath());
            fDSRunMonitor.startFDS(pyroMod.getSimParams().getOpenMp());
        }
    }

    private static class ResumeFDSClusterAction
    extends RunFDSClusterAction {
        private static final long serialVersionUID = 1834321905800219436L;
        private static final ImageIcon ICON = null;

        public ResumeFDSClusterAction() {
            this.putValue("Name", Intl.intl("Resume FDS Cluster..."));
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void run() {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            SimParams simParams = pyroMod.getSimParams();
            SimParams.Misc misc = simParams.getMisc();
            misc.setResume(true);
            super.run();
        }

        @Override
        protected boolean showOverwriteWarn() {
            return false;
        }
    }

    private static class ResumeFDSmpiAction
    extends RunFDSmpiAction {
        private static final long serialVersionUID = 9184979190758384730L;
        private static final ImageIcon ICON = null;

        public ResumeFDSmpiAction() {
            this.putValue("Name", Intl.intl("Resume FDS Parallel..."));
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void run() {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            SimParams simParams = pyroMod.getSimParams();
            SimParams.Misc misc = simParams.getMisc();
            misc.setResume(true);
            super.run();
        }

        @Override
        protected boolean showOverwriteWarn() {
            return false;
        }
    }

    private static class ResumeFDSAction
    extends RunFDSAction {
        private static final long serialVersionUID = -6901847619976469970L;
        private static final ImageIcon ICON = null;

        public ResumeFDSAction() {
            this.putValue("Name", Intl.intl("Resume FDS..."));
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void run() {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            SimParams simParams = pyroMod.getSimParams();
            SimParams.Misc misc = simParams.getMisc();
            misc.setResume(true);
            super.run();
        }

        @Override
        protected boolean showOverwriteWarn() {
            return false;
        }
    }

    public static class MsrStatsAction
    extends guiAction {
        private static final long serialVersionUID = 2526136464453806397L;

        public MsrStatsAction() {
            super(Intl.intl("Statistics..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editStats(Collections.EMPTY_LIST);
        }
    }

    private static class ProfListAction
    extends guiAction {
        private static final long serialVersionUID = -7698826729950460193L;

        public ProfListAction() {
            super(Intl.intl("Edit Solid &Profiles..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            JFrame jFrame = pyroSim.getMainFrame();
            PyroMod pyroMod = pyroSim.getMediator();
            ProfList profList = pyroMod.getProfList();
            Unit unit = pyroSim.getUnitSystem().getLengthUnit();
            ProfListDlg profListDlg = new ProfListDlg(jFrame, unit);
            profListDlg.init(profList);
            if (profListDlg.doModal() == 1) {
                Task task = profListDlg.taskSaveTo(pyroMod, profList);
                pyroMod.getTaskManager().exec(task, Intl.intl("Edit Solid Profiles"));
            }
        }
    }

    private static class SmodLinkModelsAction
    extends guiAction {
        private static final long serialVersionUID = -8587146107133497882L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/smod.png");

        public SmodLinkModelsAction() {
            super(Intl.intl("Edit Smoke Detector Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSmokeLinkModels(null);
        }
    }

    private static class ExSpecListAction
    extends guiAction {
        private static final long serialVersionUID = 7833174983211536934L;
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("molecule16.png");

        public ExSpecListAction() {
            super(Intl.intl("Edit Species") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSpecies(null);
        }
    }

    private static class ParticleAction
    extends guiAction {
        private static final long serialVersionUID = -3975184438299663937L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/particles16.gif");

        public ParticleAction() {
            super(Intl.intl("Edit Particles") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editParticles(null);
        }
    }

    private static class SliceAction
    extends guiAction {
        private static final long serialVersionUID = -8590951427978755498L;

        public SliceAction() {
            super(Intl.intl("2D Slices") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSlices(Collections.EMPTY_LIST);
        }
    }

    private static class Slice3DAction
    extends guiAction {
        private static final long serialVersionUID = -3237070857767239656L;

        public Slice3DAction() {
            super(Intl.intl("3D Slices") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.edit3DSlices(Collections.EMPTY_LIST);
        }
    }

    private static class IsosurfaceAction
    extends guiAction {
        private static final long serialVersionUID = -4828198042434923247L;

        public IsosurfaceAction() {
            super(Intl.intl("Isosurfaces") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IsofDialog isofDialog = new IsofDialog(Application.getApp().getMainFrame());
            isofDialog.doModal();
        }
    }

    private static class Plot3DAction
    extends guiAction {
        private static final long serialVersionUID = 2213082634444477130L;

        public Plot3DAction() {
            super(Intl.intl("Plot3D Data") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.showPlot3DDialog();
        }
    }

    private static class BoundaryQuantityAction
    extends guiAction {
        private static final long serialVersionUID = -2048961257887920858L;

        public BoundaryQuantityAction() {
            super(Intl.intl("Boundary Quantities") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.showBoundaryConditionsDialog();
        }
    }

    private static class OpenGridsAction
    extends guiAction {
        private static final long serialVersionUID = 1449682465607102043L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/boundary16.gif");

        public OpenGridsAction() {
            super(Intl.intl("Open Mesh Boundaries"), ICON);
            this.putValue("ShortDescription", Intl.intl("Create open boundary vents for the selected, enabled meshes"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            Collection<Grid> collection = pyroMod.getSelectionModel().flatten(Grid.class, new EnabledFilter());
            if (collection.isEmpty()) {
                return;
            }
            Surface surface = pyroMod.getSurfaceMgr().get(PredefSurf.OPEN);
            assert (surface != null);
            if (surface == null) {
                return;
            }
            Map<Grid, GridMergeUtil.BoundaryInfo> map = GridMergeUtil.mergeGrids(pyroMod.getGridManager().flatten(new EnabledFilter<T>()), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces;
            List<Pair<Grid, List<Vent>>> list = GridUtil.constructVents(collection, map, surface, GridUtil.GridFace.values());
            if (list.isEmpty()) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            for (Pair<Grid, List<Vent>> pair : list) {
                arrayList.addAll((Collection)pair.v2);
            }
            SelectTask selectTask = new SelectTask(pyroMod, arrayList);
            selectTask.addTask(new AddGridBoundaryVentsTask(pyroMod, list));
            pyroMod.getTaskManager().exec(selectTask, Intl.intl("Add Vents"));
        }
    }

    private static class AddFloorFromGeomAction
    extends guiAction {
        private static final long serialVersionUID = 7757685971048096646L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/managefloors16_2.gif");

        public AddFloorFromGeomAction() {
            super(Intl.intl("Add Floor to Fit Objects"), ICON);
            this.putValue("ShortDescription", Intl.intl("Add Floor to Fit Objects"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            Collection<IPyroGeomSrc> collection = pyroMod.getSelectionModel().flatten(IPyroGeomSrc.class);
            if (collection.isEmpty()) {
                return;
            }
            AABox aABox = pyrosim.util.GeomUtil.getBounds(collection);
            if (aABox.isValid() && !aABox.isInfinite()) {
                Floor floor = new Floor(pyroMod.getNames(Floor.class).generateName(), new UnitDouble(aABox.getMinZ(), Geometry.LU), new UnitDouble(0.0, SI.METER), new UnitDouble(aABox.getHeight(), Geometry.LU), null, Floor.DEFAULT_COLOR);
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
                compositeTask.addTask(new AddTask((IPyroObject)pyroMod.getFloorManager(), new IPyroObject[]{floor}));
                pyroMod.getTaskManager().exec(compositeTask, Intl.intl("New Floor"));
            }
        }
    }

    private static class ShowNodeAction
    extends guiAction {
        private static final long serialVersionUID = -5077749889862006752L;

        public ShowNodeAction() {
            super(Intl.intl("Show Object(s)"));
            this.putValue("AcceleratorKey", Accelerators.SHOW);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            ShowSomeGeomTask showSomeGeomTask = new ShowSomeGeomTask(pyroMod, pyroMod.getSelectionModel().flatten(IPyroGeomSrc.class), true);
            pyroMod.getTaskManager().exec(showSomeGeomTask, this.getName());
        }
    }

    private static class ShowAllNodesAction
    extends guiAction {
        private static final long serialVersionUID = 7710554227825807626L;

        public ShowAllNodesAction() {
            super(Intl.intl("Show All Objects"));
            this.putValue("AcceleratorKey", Accelerators.SHOW_ALL);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            ShowAllGeomTask showAllGeomTask = new ShowAllGeomTask(pyroMod);
            pyroMod.getTaskManager().exec(showAllGeomTask, this.getName());
        }
    }

    public static class RemoveSelectedNodeAction
    extends guiAction {
        private static final long serialVersionUID = -5504045286867996285L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Delete16.gif");

        public RemoveSelectedNodeAction() {
            super(Intl.intl("Delete"), ICON);
            this.addAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.addAccelerator(KeyStroke.getKeyStroke(8, 0));
            this.putValue("ShortDescription", Intl.intl("Delete"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            Actions.doDelete(pyroMod);
        }
    }

    public static class UIPasteCallback
    extends APasteCallback {
        private PasteOverwrite d_replace = null;

        public UIPasteCallback(PyroMod pyroMod) {
            super(UIPasteCallback.getDefaultPasteLocs(pyroMod));
        }

        private static Object[] getDefaultPasteLocs(PyroMod pyroMod) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Set<?> set = pyroMod.getSelectionModel().getSelection();
            if (set.size() == 1) {
                arrayList.add(set.iterator().next());
            } else {
                IPyroObject iPyroObject = Hierarchy.getCommonParent(theUtil.filter(set, IPyroObject.class));
                if (iPyroObject != null) {
                    arrayList.add(iPyroObject);
                }
            }
            return theUtil.toArray(arrayList, Object.class);
        }

        @Override
        public PasteOverwrite getReplaceModelObject(IPyroObject iPyroObject, IPyroObject iPyroObject2) throws CancellationException {
            String string = Util.getName(iPyroObject2);
            String string2 = String.format(Intl.intl("%s already exists in the model.\nWould you like to replace it?"), string);
            return this.getReplaceModelObject(iPyroObject, iPyroObject2, string2);
        }

        public PasteOverwrite getReplaceModelObject(IPyroObject iPyroObject, IPyroObject iPyroObject2, String string) throws CancellationException {
            PasteOverwrite pasteOverwrite;
            if (this.d_replace != null) {
                return this.d_replace;
            }
            String string2 = Intl.intl("Yes");
            String string3 = Intl.intl("Yes to All");
            String string4 = Intl.intl("No");
            String string5 = Intl.intl("No to All");
            String string6 = Intl.intl("Cancel");
            Object[] objectArray = new String[]{string2, string3, string4, string5, string6};
            JOptionPane jOptionPane = new JOptionPane(string, 3, 0, null, objectArray, string2);
            JDialog jDialog = jOptionPane.createDialog(Application.getApp().getActiveFrame(), Intl.intl("Object Exists"));
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (string2.equals(object)) {
                pasteOverwrite = PasteOverwrite.REPLACE_EXISTING;
            } else if (string3.equals(object)) {
                this.d_replace = pasteOverwrite = PasteOverwrite.REPLACE_EXISTING;
            } else if (string4.equals(object)) {
                pasteOverwrite = PasteOverwrite.KEEP_EXISTING;
            } else if (string5.equals(object)) {
                this.d_replace = pasteOverwrite = PasteOverwrite.KEEP_EXISTING;
            } else {
                throw new CancellationException();
            }
            return pasteOverwrite;
        }

        @Override
        public List<Reaction> getActiveReactions(Collection<Reaction> collection, Map<Reaction, PasteCommand> map, List<Reaction> list) throws CancellationException {
            if (map.size() == 0) {
                return new ArrayList<Reaction>(list);
            }
            Set set = map.keySet().stream().map(reaction -> reaction.getReacType()).distinct().collect(Collectors.toSet());
            if (set.size() != 1) {
                return new ArrayList<Reaction>(list);
            }
            if (collection.size() == 0) {
                if (map.size() == 1) {
                    return new ArrayList<Reaction>(map.keySet());
                }
                if (set.size() == 1 && set.contains((Object)Reaction.ReacType.COMPLEX)) {
                    return new ArrayList<Reaction>(map.keySet());
                }
            }
            if (set.contains((Object)Reaction.ReacType.SIMPLE)) {
                Function<Reaction, String> function = reaction -> {
                    if (map.containsKey(reaction)) {
                        return String.format(Intl.intl("%s (Pasted Object)"), reaction.getName());
                    }
                    return reaction.getName();
                };
                SetNewActiveSimpleReacDlg setNewActiveSimpleReacDlg = new SetNewActiveSimpleReacDlg(new ArrayList<Reaction>(map.keySet()), function, list);
                if (setNewActiveSimpleReacDlg.doModal() == 1) {
                    return setNewActiveSimpleReacDlg.getSelectedReacs();
                }
                throw new CancellationException();
            }
            if (set.contains((Object)Reaction.ReacType.COMPLEX)) {
                int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("Would you like to set pasted complex reactions as 'Active'?"), Intl.intl("Set Reactions Active"), 1, 3);
                if (n == 0) {
                    return new ArrayList<Reaction>(map.keySet());
                }
                if (n == 1) {
                    return new ArrayList<Reaction>(list);
                }
                if (n == 2) {
                    throw new CancellationException();
                }
            }
            return list;
        }
    }

    public static abstract class APasteCallback
    implements IPasteCallback {
        private final Object[] d_preferredPasteLocs;

        public APasteCallback(Object ... objectArray) {
            this.d_preferredPasteLocs = objectArray;
        }

        @Override
        public Object getPasteLocation(PyroMod pyroMod, Object object) {
            for (Object object2 : this.d_preferredPasteLocs) {
                if (!TVEntryPoints.ep(object2).canPaste(pyroMod, object2, object)) continue;
                return object2;
            }
            return TVEntryPoints.ep(object).getPasteLocation(pyroMod, object);
        }
    }

    public static interface IPasteCallback {
        public PasteOverwrite getReplaceModelObject(IPyroObject var1, IPyroObject var2) throws CancellationException;

        public Object getPasteLocation(PyroMod var1, Object var2);

        public List<Reaction> getActiveReactions(Collection<Reaction> var1, Map<Reaction, PasteCommand> var2, List<Reaction> var3) throws CancellationException;
    }

    public static enum PasteOverwrite {
        REPLACE_EXISTING,
        KEEP_EXISTING;

    }

    public static class PasteCommand {
        public static final int OVERWRITE = 0;
        public static final int SUBSTITUTE = 1;
        public static final int RENAME = 2;
        public final int command;
        public final Object pasteLoc;
        public final Object param;

        public PasteCommand(int n, Object object, Object object2) {
            this.command = n;
            this.pasteLoc = object;
            this.param = object2;
        }
    }

    public static class PasteReactionCommand {
        public final List<Reaction> prevActives;
        public final List<Reaction> newActives;

        public PasteReactionCommand(List<Reaction> list, List<Reaction> list2) {
            this.prevActives = list;
            this.newActives = list2;
        }
    }

    public static class PasteInfo {
        public final Task task;
        public final Map<IPyroObject, PasteCommand> commands;

        public PasteInfo(Task task, Map<IPyroObject, PasteCommand> map) {
            this.task = task;
            this.commands = map;
        }
    }

    private static class PasteAction
    extends guiAction {
        private static final long serialVersionUID = -8752980443667274078L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Paste16.gif");

        public PasteAction() {
            super(Intl.intl("Paste"), ICON);
            this.putValue("AcceleratorKey", Accelerators.PASTE);
            this.putValue("ShortDescription", Intl.intl("Paste"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            Application.getApp().beginWaitCursor();
            try {
                Actions.doPaste(pyroMod, clipboard, new UIPasteCallback(pyroMod));
            }
            catch (CancellationException cancellationException) {
            }
            finally {
                Application.getApp().endWaitCursor();
            }
        }
    }

    private static class HideUnselectedNodeAction
    extends guiAction {
        private static final long serialVersionUID = 2847617481608042700L;

        public HideUnselectedNodeAction() {
            super(Intl.intl("Filter Object(s)"));
            this.putValue("AcceleratorKey", Accelerators.FILTER);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            FilterGeomTask filterGeomTask = new FilterGeomTask(pyroMod, pyroMod.getSelectionModel().flatten(IPyroGeomSrc.class));
            pyroMod.getTaskManager().exec(filterGeomTask, this.getName());
        }
    }

    private static class HideNodeAction
    extends guiAction {
        private static final long serialVersionUID = -121363112383909202L;

        public HideNodeAction() {
            super(Intl.intl("Hide Object(s)"));
            this.putValue("AcceleratorKey", Accelerators.HIDE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            ShowSomeGeomTask showSomeGeomTask = new ShowSomeGeomTask(pyroMod, pyroMod.getSelectionModel().flatten(IPyroGeomSrc.class), false);
            pyroMod.getTaskManager().exec(showSomeGeomTask, this.getName());
        }
    }

    private static class ChangeEnabledNodeAction
    extends guiAction {
        private static final long serialVersionUID = -5664988163492864743L;
        private boolean d_enabled;

        public ChangeEnabledNodeAction(String string, boolean bl) {
            super(string);
            this.d_enabled = bl;
        }

        protected Collection<IPyroObject> getSelection() {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            Hierarchy.CompositeFilter<IPyroObject> compositeFilter = new Hierarchy.CompositeFilter<IPyroObject>();
            Predicate<IPyroObject> predicate = new Predicate<IPyroObject>(){

                @Override
                public boolean test(IPyroObject iPyroObject) {
                    return !(iPyroObject instanceof Reaction) && iPyroObject.isEnabled() != d_enabled;
                }
            };
            Predicate<IPyroObject> predicate2 = compositeFilter.and(predicate);
            return pyroMod.getSelectionModel().flatten(IPyroObject.class, predicate2);
        }

        public void updateState() {
            Collection<IPyroObject> collection = this.getSelection();
            boolean bl = !collection.isEmpty();
            this.setEnabled(bl);
        }

        private void enable(PyroMod pyroMod, Collection<IPyroObject> collection) {
            Object object;
            DepSnapshot depSnapshot = new DepSnapshot();
            for (IPyroObject object22 : collection) {
                depSnapshot.takeSnapshot(object22);
            }
            depSnapshot.removeMappings(collection);
            Set<IPyroObject> set = depSnapshot.getAllDependedOn();
            Predicate<IPyroObject> predicate = new Predicate<IPyroObject>(){

                @Override
                public boolean test(IPyroObject iPyroObject) {
                    return !iPyroObject.isEnabled();
                }
            };
            IFilteredCollection<IPyroObject> iFilteredCollection = theUtil.filter(set, IPyroObject.class, predicate);
            LinkedHashSet<IPyroObject> linkedHashSet = new LinkedHashSet<IPyroObject>(collection);
            boolean bl = iFilteredCollection.isEmpty();
            if (!bl) {
                object = String.format(Intl.intl("Enable %s additional object(s)?"), iFilteredCollection.size());
                int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), object, Intl.intl("Enable Dependencies"), 2);
                if (n == 0) {
                    bl = true;
                    linkedHashSet.addAll(iFilteredCollection);
                }
            }
            if (bl) {
                object = new SetEnabledSomeObjsTask(pyroMod, linkedHashSet, true);
                pyroMod.getTaskManager().exec((Task)object, this.getName());
            }
        }

        private void disable(PyroMod pyroMod, Collection<IPyroObject> collection) {
            if (!Actions.isObjectInUse(pyroMod, collection, null)) {
                SetEnabledSomeObjsTask setEnabledSomeObjsTask = new SetEnabledSomeObjsTask(pyroMod, collection, false);
                pyroMod.getTaskManager().exec(setEnabledSomeObjsTask, this.getName());
            } else {
                String string = null;
                string = collection.size() <= 1 ? Intl.intl("The selected object is in use.") : Intl.intl("One or more of the selected objects is in use.");
                JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), string, Intl.intl("Error: In Use"), 0);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            pyroMod.pauseUpdates();
            Collection<IPyroObject> collection = this.getSelection();
            if (this.d_enabled) {
                this.enable(pyroMod, collection);
            } else {
                this.disable(pyroMod, collection);
            }
            pyroMod.resumeUpdates();
        }
    }

    private static class EditLibAction
    extends guiAction {
        private static final long serialVersionUID = -8900685277728987112L;

        public EditLibAction() {
            super(Intl.intl("Edit Libraries..."), Actions.createIcon(null));
            this.putValue("ShortDescription", Intl.intl("Edit Libraries"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            LibraryDlg libraryDlg = new LibraryDlg(pyroSim.getMainFrame(), null);
            libraryDlg.doModal();
        }
    }

    private static class EditSimulationPropertiesAction
    extends guiAction {
        private static final long serialVersionUID = -7243756585802759467L;
        private static final ImageIcon ICON = null;

        public EditSimulationPropertiesAction() {
            super(Intl.intl("Simulation Parameters") + "...", ICON);
            this.putValue("ShortDescription", Intl.intl("Simulation Parameters"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSimulationProperties();
        }
    }

    private static class EditSelectedNodeAction
    extends guiAction {
        private static final long serialVersionUID = -564450018016717491L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Edit16.gif");
        private static final Set<Class> NONEDIT_TYPES = Sets.fromArrayHS(CameraState.class, View.class, ViewList.class);
        private static final Set<Class> EDIT_TYPES = Sets.fromArrayHS(new Class[0]);
        private static final Map<Class, Boolean> EDIT_CACHE = new HashMap<Class, Boolean>();
        private static final Function<Class, Boolean> EDIT_FUNC;
        private static Predicate<Object> EDIT_FILTER;

        public EditSelectedNodeAction() {
            super(Intl.intl("Properties") + "...", ICON);
            this.putValue("ShortDescription", Intl.intl("Properties"));
        }

        public void updateEnabled(PyroMod pyroMod) {
            PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
            IPyroObject iPyroObject = null;
            for (Object obj : pyroSimSelectionModel.getSelection()) {
                if (!EDIT_FILTER.test(obj)) {
                    iPyroObject = null;
                    break;
                }
                IPyroObject iPyroObject2 = Hierarchy.getCategoryRoot((IPyroObject)obj);
                if (iPyroObject == null) {
                    iPyroObject = iPyroObject2;
                    continue;
                }
                if (iPyroObject2 == iPyroObject) continue;
                iPyroObject = null;
                break;
            }
            EDIT_SELECTED_NODE_ACTION.setEnabled(iPyroObject != null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSelectedNode();
        }

        static {
            for (Class clazz2 : NONEDIT_TYPES) {
                EDIT_CACHE.put(clazz2, false);
            }
            for (Class clazz2 : EDIT_TYPES) {
                EDIT_CACHE.put(clazz2, true);
            }
            EDIT_FUNC = clazz -> {
                if (!IPyroObject.class.isAssignableFrom((Class<?>)clazz)) {
                    return false;
                }
                Boolean bl = theUtil.findObjectForClass(EDIT_CACHE, clazz);
                return bl == null ? true : bl;
            };
            EDIT_FILTER = object -> EDIT_CACHE.computeIfAbsent(object.getClass(), EDIT_FUNC);
        }
    }

    private static class CutAction
    extends guiAction {
        private static final long serialVersionUID = -6546742384472571267L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Cut16.gif");

        public CutAction() {
            super(Intl.intl("Cut"), ICON);
            this.putValue("AcceleratorKey", Accelerators.CUT);
            this.putValue("ShortDescription", Intl.intl("Cut"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            Actions.doCut(pyroMod, Toolkit.getDefaultToolkit().getSystemClipboard());
        }
    }

    private static class CopyFDSRecordsAction
    extends guiAction {
        private static final long serialVersionUID = -827474727532744310L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Copy16.gif");

        public CopyFDSRecordsAction() {
            super(Intl.intl("Copy FDS Records"), ICON);
            this.putValue("ShortDescription", Intl.intl("Copy FDS Records"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            Actions.doCopy(pyroMod, Toolkit.getDefaultToolkit().getSystemClipboard(), FDS_DATA_FLAVOR);
        }
    }

    private static class CopyAction
    extends guiAction {
        private static final long serialVersionUID = -7907213396355322043L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Copy16.gif");

        public CopyAction() {
            super(Intl.intl("Copy"), ICON);
            this.putValue("AcceleratorKey", Accelerators.COPY);
            this.putValue("ShortDescription", Intl.intl("Copy"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            Actions.doCopy(pyroMod, Toolkit.getDefaultToolkit().getSystemClipboard(), PYRO_DATA_FLAVOR);
        }
    }

    private static class RedoAction
    extends guiAction {
        private static final long serialVersionUID = -6347326337464097037L;
        private static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Redo16.gif");

        public RedoAction() {
            super(Intl.intl("Redo"), ICON);
            this.putValue("AcceleratorKey", Accelerators.REDO);
            this.putValue("ShortDescription", Intl.intl("Redo"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            pyroMod.getTaskManager().redo();
        }

        public void update(TaskManager taskManager) {
            this.setEnabled(taskManager.canRedo());
            String string = taskManager.describeRedo();
            this.setName(string);
            this.putValue("ShortDescription", string);
        }
    }

    private static class UndoAction
    extends guiAction {
        private static final long serialVersionUID = -2894482227587354644L;
        public static final ImageIcon ICON = Actions.createIcon("thunderheadeng/gui/graphics/Undo16.gif");

        public UndoAction() {
            super(Intl.intl("Undo"), ICON);
            this.putValue("AcceleratorKey", Accelerators.UNDO);
            this.putValue("ShortDescription", Intl.intl("Undo"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            pyroMod.getTaskManager().undo();
        }

        public void update(TaskManager taskManager) {
            this.setEnabled(taskManager.canUndo());
            String string = taskManager.describeUndo();
            this.setName(string);
            this.putValue("ShortDescription", string);
        }
    }

    private static class CrashAction
    extends guiAction {
        private static final long serialVersionUID = 1519871291030549471L;

        public CrashAction() {
            super("x_x", (ActionEvent actionEvent) -> {
                throw new RuntimeException();
            });
        }
    }

    private static class ProtectAction
    extends guiAction {
        private static final long serialVersionUID = -7803068167094385248L;
        public static final ImageIcon ICON = null;

        public ProtectAction() {
            super(Intl.intl("Write Protection..."), ICON);
            this.putValue("ShortDescription", Intl.intl("Prevent changes to the model."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            if (pyroMod.isWriteProtected()) {
                boolean bl = WriteProtect.isPasswordProtected(pyroMod);
                WriteProtect.RemoveProtectionDlg removeProtectionDlg = new WriteProtect.RemoveProtectionDlg(pyroSim.getMainFrame(), bl);
                if (removeProtectionDlg.doModal() == 1) {
                    WriteProtect.removeProtection(pyroMod);
                    pyroMod.getEvents().changed(pyroMod, PyroMod.EVT_CHANGED);
                }
            } else {
                WriteProtect.AddProtectionDlg addProtectionDlg = new WriteProtect.AddProtectionDlg(pyroSim.getMainFrame());
                if (addProtectionDlg.doModal() == 1) {
                    String string = null;
                    if (addProtectionDlg.getPasswordProtection()) {
                        string = addProtectionDlg.getPassword();
                    }
                    WriteProtect.addProtection(pyroMod, string);
                    pyroMod.getEvents().changed(pyroMod, PyroMod.EVT_CHANGED);
                }
            }
        }
    }

    private static class RasterizeObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 8380453107532657945L;
        private static final ImageIcon ICON = null;

        public RasterizeObjectsAction() {
            super(Intl.intl("Convert to Blocks") + "...", ICON);
        }

        @Override
        public void updateEnabled() {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.setEnabled(!pyroMod.getSelectionModel().flatten(FDSObject.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            if (pyroMod.getGridManager().flatten().isEmpty()) {
                PyroSim.getApp().error(new guiSimpleError(Intl.intl("There are currently no grids to rasterize the selected objects against.")));
                return;
            }
            RasterizationPropsDlg rasterizationPropsDlg = new RasterizationPropsDlg();
            rasterizationPropsDlg.load(pyroMod.getRasterizations().getRastOptions());
            if (rasterizationPropsDlg.doModal() != 1) {
                return;
            }
            RasterizationOptions rasterizationOptions = rasterizationPropsDlg.save();
            Collection<FDSObject> collection = pyroMod.getSelectionModel().flatten(FDSObject.class);
            RasterizeTask rasterizeTask = new RasterizeTask(pyroMod, collection, rasterizationOptions);
            pyroMod.getTaskManager().exec(rasterizeTask, Intl.intl("Convert to Blocks"));
        }
    }

    private static class AddModelObjAction<T extends IModelObj>
    extends guiAction {
        private static final long serialVersionUID = -620358460530122662L;
        private final Function<PyroMod, T> d_factory;

        public AddModelObjAction(String string, String string2, String string3, Function<PyroMod, T> function) {
            this(string, string2, PyroGuiUtil.createNewObjIcon(string3), function);
        }

        public AddModelObjAction(String string, String string2, Icon icon, Function<PyroMod, T> function) {
            super(string, icon);
            this.putValue("ShortDescription", string2);
            this.d_factory = function;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            Set<T> set = Collections.singleton(this.d_factory.apply(pyroSim.getMediator()));
            ModelObjectDialog modelObjectDialog = new ModelObjectDialog(pyroSim.getActiveFrame(), pyroSim.getMediator(), set, Actions.getModelInsertLoc(), 0);
            if (modelObjectDialog.doModal() == 1) {
                modelObjectDialog.saveValues(set);
            }
        }
    }

    private static class AddHvacDuctAction
    extends AddModelObjAction<HvacDuct> {
        private static final long serialVersionUID = 3024479750424912479L;

        public AddHvacDuctAction() {
            super(Intl.intl("New HVAC Duct..."), Intl.intl("New HVAC Duct"), "hvac_duct16.png", (PyroMod pyroMod) -> new HvacDuct(pyroMod.getNames(HvacDuct.class).generateName()));
        }
    }

    private static class AddHvacNodeAction
    extends AddModelObjAction<HvacNode> {
        private static final long serialVersionUID = -4893294826997045376L;

        public AddHvacNodeAction() {
            super(Intl.intl("New HVAC Node..."), Intl.intl("New HVAC Node"), "hvac_node16.png", (PyroMod pyroMod) -> new HvacNode(pyroMod.getNames(HvacNode.class).generateName()));
        }
    }

    private static class AddInitRegionAction
    extends AddModelObjAction<InitRegion> {
        private static final long serialVersionUID = -8850048267472473386L;

        public AddInitRegionAction() {
            super(Intl.intl("New Init Region") + "...", Intl.intl("New Init Region"), PyroGuiUtil.createNewObjIcon("init16.png"), (PyroMod pyroMod) -> {
                AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
                return new InitRegion(Intl.intl("Init Region"), aABoxGeom);
            });
        }
    }

    private static class AddPartLocationAction
    extends AAddPartCloudAction {
        private static final long serialVersionUID = -3300751757155564813L;

        public AddPartLocationAction() {
            super(Intl.intl("New Particle Location"), PyroGuiUtil.createNewObjIcon("single_part16.gif"), () -> new Point(new Point3d(0.0, 0.0, 0.0)));
        }
    }

    private static class AddPartCloudAction
    extends AAddPartCloudAction {
        private static final long serialVersionUID = 6485134319840189877L;

        public AddPartCloudAction() {
            super(Intl.intl("New Particle Cloud"), (Icon)PyroGuiUtil.loadPyroSimIcon("newpartCloud16.gif"), () -> new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        }
    }

    private static class AAddPartCloudAction
    extends AddModelObjAction<PartCloud> {
        private static final long serialVersionUID = 1125160956409643531L;

        public AAddPartCloudAction(String string, Icon icon, Supplier<IGeom> supplier) {
            super(string + "...", string, icon, (PyroMod pyroMod) -> {
                IGeom iGeom = (IGeom)supplier.get();
                return new PartCloud(Intl.intl("Particle Cloud"), AAddPartCloudAction.getDefaultParticle(pyroMod), iGeom);
            });
        }

        private static Particle getDefaultParticle(PyroMod pyroMod) {
            ParticleList particleList = pyroMod.getPartList();
            Particle particle = (Particle)particleList.get(ParticleList.WATER);
            if (particle == null && !particleList.flatten().isEmpty()) {
                particle = (Particle)particleList.flatten().iterator().next();
            }
            return particle;
        }
    }

    private static class AddHoleAction
    extends AddModelObjAction<Hole> {
        private static final long serialVersionUID = -4133691410946173213L;

        public AddHoleAction() {
            super(Intl.intl("New Hole") + "...", Intl.intl("New Hole"), PyroGuiUtil.loadPyroSimIcon("newhole16.gif"), (PyroMod pyroMod) -> {
                AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
                return new Hole(Intl.intl("Hole"), GeomNodeUtil.newNode(aABoxGeom));
            });
        }
    }

    private static class AddVentAction
    extends AddModelObjAction<Vent> {
        private static final long serialVersionUID = 2560652193221572890L;

        public AddVentAction() {
            super(Intl.intl("New Vent") + "...", Intl.intl("New Vent"), PyroGuiUtil.loadPyroSimIcon("newvent16.gif"), (PyroMod pyroMod) -> new Vent(pyroMod.getNames(Vent.class).generateName(), pyroMod.getDefaultSurface(), new AARectangle()));
        }
    }

    private static class AddSlabAction
    extends AddModelObjAction<Obstruction> {
        private static final long serialVersionUID = 647205419302082191L;

        public AddSlabAction() {
            super(Intl.intl("New Slab") + "...", Intl.intl("New Slab"), PyroGuiUtil.loadPyroSimIcon("new_triangle.png"), (PyroMod pyroMod) -> {
                ExtrudedPoly extrudedPoly = new ExtrudedPoly(new Quad(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 0.0, 0.0), new Point3d(1.0, 1.0, 0.0), new Point3d(0.0, 1.0, 0.0)), new Vector3d(0.0, 0.0, -0.2));
                return new Obstruction(Intl.intl("Slab"), GeomNodeUtil.newNode(extrudedPoly), new Surface[]{pyroMod.getDefaultSurface()});
            });
        }
    }

    private static class AddWallAction
    extends AddModelObjAction<Obstruction> {
        private static final long serialVersionUID = -4722144147954253932L;

        public AddWallAction() {
            super(Intl.intl("New Obstruction") + "...", Intl.intl("New Obstruction"), PyroGuiUtil.loadPyroSimIcon("newblock16_2.gif"), (PyroMod pyroMod) -> {
                AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
                return new Obstruction(Intl.intl("Obstruction"), GeomNodeUtil.newNode(aABoxGeom), new Surface[]{pyroMod.getDefaultSurface()});
            });
        }
    }

    private static class SelectByColorAction
    extends AModelObjAction {
        private static final long serialVersionUID = 3466837901925077037L;

        public SelectByColorAction() {
            super(Intl.intl("Select by Color"), Intl.intl("Select All Visible Objects with the Same Color"), AFDSObject.class);
        }

        @Override
        public void updateEnabled() {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            this.setEnabled(!pyroMod.getSelectionModel().flatten(FDSObject.class).isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<AFDSObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(AFDSObject.class);
            SelectByColorTask selectByColorTask = new SelectByColorTask(pyroMod, iFilteredCollection);
            pyroMod.getTaskManager().exec(selectByColorTask, Intl.intl("Select by Color"));
        }
    }

    private static class SelectRefObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 8621399013459559802L;

        public SelectRefObjectsAction() {
            super(Intl.intl("Select Referencing Objects"));
            this.putValue("ShortDescription", Intl.intl("Select all referencing objects"));
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl) {
                this.setEnabled(!pyroMod.getSelectionModel().flatten(IPyroObject.class).isEmpty());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
            SelectReferencingObjTask selectReferencingObjTask = new SelectReferencingObjTask(pyroMod, iFilteredCollection);
            selectReferencingObjTask.run();
        }
    }

    private static class HeatLinkModelManagerAction
    extends guiAction {
        private static final long serialVersionUID = -4139995227218552645L;

        public HeatLinkModelManagerAction() {
            super(Intl.intl("Edit Heat Detector Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editHeatLinkModels(null);
        }
    }

    private static class SprinklerLinkModelManagerAction
    extends guiAction {
        private static final long serialVersionUID = -6297257725709429957L;

        public SprinklerLinkModelManagerAction() {
            super(Intl.intl("Edit Sprinkler Link Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSprinklerLinkModels(null);
        }
    }

    private static class SprayModelManagerAction
    extends guiAction {
        private static final long serialVersionUID = 33312413867539079L;

        public SprayModelManagerAction() {
            super(Intl.intl("Edit Spray Models") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editSprayModel(null);
        }
    }

    private static class ReactionManagerAction
    extends guiAction {
        private static final long serialVersionUID = -6547490850786824553L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/reaction16.gif");

        public ReactionManagerAction() {
            super(Intl.intl("Edit Reactions") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.doEditReactions(null);
        }
    }

    private static class AppearanceManagerAction
    extends guiAction {
        private static final long serialVersionUID = 6756339722458509542L;
        private static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("textures.png");

        public AppearanceManagerAction() {
            super(Intl.intl("Edit Appearances..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            MaterialDB materialDB = pyroMod.getAppearances();
            Collection collection = materialDB.flatten();
            pyrosim.domain.appearance.Material material = !collection.isEmpty() ? (pyrosim.domain.appearance.Material)collection.iterator().next() : null;
            Actions.editAppearance(material);
        }
    }

    private static class SurfaceManagerAction
    extends guiAction {
        private static final long serialVersionUID = -5838150951911141872L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/surf2a.gif");

        public SurfaceManagerAction() {
            super(Intl.intl("Edit Surfaces") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            SurfaceManager surfaceManager = pyroMod.getSurfaceMgr();
            Actions.editSurfaces(surfaceManager.get(PredefSurf.INERT));
        }
    }

    private static class MaterialManagerAction
    extends guiAction {
        private static final long serialVersionUID = 1944586403465706691L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/surfacedb16.gif");

        public MaterialManagerAction() {
            super(Intl.intl("Edit Materials") + "...", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editMaterials(null);
        }
    }

    public static class GridAction
    extends guiAction {
        private static final long serialVersionUID = -4771890178672966907L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/3dgrid_smooth16.gif");

        public GridAction() {
            super(Intl.intl("Edit Meshes..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.doEditGrids(null);
        }
    }

    private static class ZonesAction
    extends guiAction {
        private static final long serialVersionUID = 4370852229085106087L;
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("zones16.png");

        public ZonesAction() {
            super(Intl.intl("Edit Zones..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editZones(null);
        }
    }

    private static class ControlsAction
    extends guiAction {
        private static final long serialVersionUID = -1353840320433837535L;
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("or16.png");

        public ControlsAction() {
            super(Intl.intl("Edit Activation Controls..."), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Actions.editControls(null);
        }
    }

    private static class RotateAction
    extends TransformAction {
        private static final long serialVersionUID = -5606456857221272593L;

        public RotateAction() {
            super(Intl.intl("Rotate") + "...", Intl.intl("Rotate"), (PyroMod pyroMod, Collection<IPyroObject> collection) -> new RotateDialog((PyroMod)pyroMod, (Collection<? extends IPyroObject>)collection));
        }
    }

    private static class ScaleAction
    extends TransformAction {
        private static final long serialVersionUID = -3336637975398614805L;

        public ScaleAction() {
            super(Intl.intl("Scale") + "...", Intl.intl("Scale"), (PyroMod pyroMod, Collection<IPyroObject> collection) -> new ScaleDialog((PyroMod)pyroMod, (Collection<? extends IPyroObject>)collection));
        }
    }

    private static class MirrorAction
    extends TransformAction {
        private static final long serialVersionUID = -462716911275992089L;

        public MirrorAction() {
            super(Intl.intl("Mirror") + "...", Intl.intl("Mirror"), (PyroMod pyroMod, Collection<IPyroObject> collection) -> new MirrorDialog((PyroMod)pyroMod, (Collection<? extends IPyroObject>)collection));
        }
    }

    private static class TranslateAction
    extends TransformAction {
        private static final long serialVersionUID = 7738165452601928234L;

        public TranslateAction() {
            super(Intl.intl("Copy/Move") + "...", Intl.intl("Copy or move an obstruction"), (PyroMod pyroMod, Collection<IPyroObject> collection) -> new TranslateDialog((PyroMod)pyroMod, (Collection<? extends IPyroObject>)collection));
        }
    }

    private static class TransformAction
    extends guiAction {
        private static final long serialVersionUID = 5352086256413199064L;
        private final BiFunction<PyroMod, Collection<IPyroObject>, TransformDialog> d_dlgProducer;

        public TransformAction(String string, String string2, BiFunction<PyroMod, Collection<IPyroObject>, TransformDialog> biFunction) {
            super(string);
            this.putValue("ShortDescription", string2);
            this.d_dlgProducer = biFunction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = (PyroSim)Application.getApp();
            PyroMod pyroMod = pyroSim.getMediator();
            Collection collection = Actions.getSelectedGeom(pyroMod);
            Collection<IPyroObject> collection2 = Actions.getTransformObjs(pyroSim, pyroMod, collection);
            TransformDialog transformDialog = this.d_dlgProducer.apply(pyroMod, collection2);
            transformDialog.doModal();
        }
    }

    public static class GroupGeomAction
    extends AModelObjAction {
        private static final long serialVersionUID = -2865070841485475727L;

        public GroupGeomAction() {
            super(Intl.intl("Merge into Composite..."), Intl.intl("Merge multiple objects into one composite object"), IObstruction.class, IHole.class, GenericGeomSrc.class);
        }

        @Override
        public void updateEnabled() {
            Collection<IModelObj> collection = this.getSelObjs();
            boolean bl = collection.size() >= 2 && (Util.isExclusive(collection, FDSObject.class) || Util.isExclusive(collection, GenericGeomSrc.class));
            this.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            GroupGeomTask.ConvertType convertType;
            Collection<IModelObj> collection = this.getSelObjs();
            if (collection.isEmpty()) {
                return;
            }
            if (Util.isExclusive(collection, IObstruction.class)) {
                convertType = GroupGeomTask.ConvertType.OBSTRUCTION;
            } else if (Util.isExclusive(collection, IHole.class)) {
                convertType = GroupGeomTask.ConvertType.HOLE;
            } else if (Util.isExclusive(collection, GenericGeomSrc.class)) {
                convertType = GroupGeomTask.ConvertType.GENERIC;
            } else {
                assert (theUtil.filter(collection, GenericGeomSrc.class).isEmpty());
                object = Intl.intl("Obstruction");
                String string = Intl.intl("Hole");
                int n = JOptionPane.showOptionDialog(PyroSim.getApp().getMainFrame(), Intl.intl("The selection has mixed object types. What type of object\nwould you like to turn the selection into?"), Intl.intl("Object Type"), 2, 1, null, new Object[]{object, string, Intl.intl("Cancel")}, object);
                if (n != 0 && n != 1) {
                    return;
                }
                convertType = n == 0 ? GroupGeomTask.ConvertType.OBSTRUCTION : GroupGeomTask.ConvertType.HOLE;
            }
            object = new GroupGeomTask(PyroSim.getApp().getMediator(), collection, convertType);
            PyroSim.getApp().getMediator().getTaskManager().exec((Task)object, Intl.intl("Group"));
        }
    }

    public static class ExplodeAction
    extends AModelObjAction {
        private static final long serialVersionUID = 530618320977170151L;

        public ExplodeAction() {
            super(Intl.intl("Explode Composites"), Intl.intl("Explode composite objects into multiple sub-objects"), IObstruction.class, IHole.class, GenericGeomSrc.class);
        }

        @Override
        protected Collection<IModelObj> getSelObjs() {
            return theUtil.filter(super.getSelObjs(), new Predicate<IModelObj>(){

                @Override
                public boolean test(IModelObj iModelObj) {
                    return Actions.isExplodable(iModelObj.getGeom());
                }
            });
        }

        @Override
        public void updateEnabled() {
            this.setEnabled(!this.getSelObjs().isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection<IModelObj> collection = this.getSelObjs();
            if (collection.isEmpty()) {
                return;
            }
            ExplodeTask explodeTask = new ExplodeTask(PyroSim.getApp().getMediator(), collection);
            PyroSim.getApp().getMediator().getTaskManager().exec(explodeTask, Intl.intl("Explode"));
        }
    }

    private static abstract class AModelObjAction
    extends guiAction {
        private static final long serialVersionUID = 4665029373358628882L;
        private TypeFilter<IModelObj> d_filter;

        public AModelObjAction(String string, String string2, Class<? extends IModelObj> ... classArray) {
            super(string);
            this.putValue("ShortDescription", string2);
            this.d_filter = new TypeFilter(classArray);
        }

        protected Collection<IModelObj> getSelObjs() {
            return PyroSim.getApp().getMediator().getSelectionModel().flatten(IModelObj.class, this.d_filter);
        }
    }

    private static class ChangeGroupAction
    extends guiAction {
        private static final long serialVersionUID = -8844052856105830129L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/composite16_2.gif");

        public ChangeGroupAction() {
            super(Intl.intl("Change Group") + "...", ICON);
            this.putValue("ShortDescription", Intl.intl("Change Group"));
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (bl) {
                this.setEnabled(this.getEnabled(pyroMod));
            }
        }

        private boolean getEnabled(PyroMod pyroMod) {
            IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
            return this.getMoveInfo(iFilteredCollection) != null;
        }

        private Pair<Composite, Composite> getMoveInfo(Collection<IPyroObject> collection) {
            IPyroObject iPyroObject = Hierarchy.getCommonParent(collection);
            if (!(iPyroObject instanceof Composite)) {
                return null;
            }
            IPyroObject iPyroObject2 = Hierarchy.getCategoryRoot(iPyroObject);
            if (!(iPyroObject2 instanceof Composite)) {
                return null;
            }
            return new Pair<Composite, Composite>((Composite)iPyroObject2, (Composite)iPyroObject);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
            Pair<Composite, Composite> pair = this.getMoveInfo(iFilteredCollection);
            assert (pair != null);
            JFrame jFrame = Application.getApp().getMainFrame();
            GroupChooserDlg<IPyroObject> groupChooserDlg = new GroupChooserDlg<IPyroObject>((Window)jFrame, (Composite)pair.v1, (Composite)pair.v2, iFilteredCollection);
            if (groupChooserDlg.doModal() == 1) {
                Composite composite = groupChooserDlg.getGroup();
                boolean bl = groupChooserDlg.isCreateNew();
                String string = groupChooserDlg.getNewText();
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
                if (bl) {
                    Composite composite2 = composite.newGroup(string);
                    compositeTask.addTask(new AddTask(composite, new IPyroObject[]{composite2}));
                    composite = composite2;
                }
                compositeTask.addTask(new ReorderObjectsTask(composite, composite.getMembers().size(), iFilteredCollection));
                pyroMod.getTaskManager().exec(compositeTask, Intl.intl("Change Group"));
            }
        }
    }

    private static class AddGroupAction
    extends guiAction {
        private static final long serialVersionUID = -5753214153164506236L;
        private static final ImageIcon ICON = Actions.createIcon("pyrosim/icons/newcomposite16_2.gif");
        private final boolean d_context;

        public AddGroupAction(boolean bl) {
            super(Intl.intl("New Group") + "...", ICON);
            this.d_context = bl;
            String string = Intl.intl("Adds a new group to the model.");
            this.putValue("ShortDescription", string);
        }

        public void updateEnabled(PyroMod pyroMod, Events events, boolean bl) {
            if (this.d_context && bl) {
                this.setEnabled(!pyroMod.getSelectionModel().getSelected(IPyroObject.class).isEmpty());
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Serializable serializable;
            PyroMod pyroMod = PyroSim.getApp().getMediator();
            IFilteredCollection<IPyroObject> iFilteredCollection = pyroMod.getSelectionModel().getSelected(IPyroObject.class);
            Composite composite = pyroMod.getObstructions();
            Composite composite2 = pyroMod.getObstructions();
            if (!iFilteredCollection.isEmpty()) {
                Serializable serializable2 = serializable = iFilteredCollection.size() == 1 && iFilteredCollection.iterator().next() instanceof Composite ? (IPyroObject)iFilteredCollection.iterator().next() : Hierarchy.getCommonParent(iFilteredCollection);
                if (serializable instanceof Composite && (object = Hierarchy.getCategoryRoot(serializable)) instanceof Composite) {
                    composite = (Composite)object;
                    composite2 = (Composite)serializable;
                }
            }
            if (((guiDialog)(serializable = new NewGroupDialog<IModelObj>(Application.getApp().getMainFrame(), composite, composite2))).doModal() == 1) {
                composite2 = ((NewGroupDialog)serializable).getParentComposite();
                object = ((NewGroupDialog)serializable).getCompositeDescription();
                Composite composite3 = composite2.newGroup((String)object);
                SelectTask selectTask = new SelectTask(pyroMod, composite3);
                selectTask.addTask(new AddTask((IPyroObject)composite2, new IPyroObject[]{composite3}));
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Group"));
            }
        }
    }

    public static class ActionStateUpdater
    implements IEventObserver {
        public ActionStateUpdater(PyroMod pyroMod) {
            this.updateActions(pyroMod);
        }

        @Override
        public void update(Events events) {
            boolean bl = false;
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            IEventRecord<PyroMod> iEventRecord = events.getEvents(PyroMod.class, new Class[0]);
            boolean bl2 = bl = bl || iEventRecord.isModified();
            if (iEventRecord.containsChange(PyroMod.EVT_MODEL_CHANGED)) {
                pyroMod.getTaskManager().clearHistory();
            }
            IEventRecord<Object> iEventRecord2 = events.getEvents(Object.class, PyroMod.class, Grid.class);
            bl = bl || iEventRecord2.hasAddedObjs() || iEventRecord2.hasRemovedObjs() || iEventRecord2.containsChange(PyroMod.EVT_SEL) || iEventRecord2.containsChange(PyroMod.EVT_FDS_EVAC_CHANGED);
            bl = bl || events.isAffected(Grid.class) || events.isAffected(Reaction.class) || events.isAffected(ExSpec.class) || events.isAffected(SimParams.Misc.class) || events.isAffected(IObstruction.class);
            this.updateActions(pyroMod, events, bl);
            if (!bl) {
                if (iEventRecord2.containsChange(PyroMod.EVT_ENABLED_CHANGED)) {
                    ENABLE_NODE_ACTION.updateState();
                    DISABLE_NODE_ACTION.updateState();
                }
                if (iEventRecord2.containsChange(PyroMod.EVT_FORCEWRITE_CHANGED)) {
                    ENABLE_FORCE_TO_WRITE_ACTION.updateState(pyroMod);
                    DISABLE_FORCE_TO_WRITE_ACTION.updateState(pyroMod);
                }
            }
            Actions.updateUndoRedoActions(pyroMod);
        }

        private void updateActions(PyroMod pyroMod) {
            this.updateActions(pyroMod, null, true);
        }

        private void updateActions(PyroMod pyroMod, Events events, boolean bl) {
            PyroSimSelectionModel pyroSimSelectionModel = pyroMod.getSelectionModel();
            if (bl) {
                SELECT_HVAC_NETWORK.updateState(pyroMod);
                SELECT_BY_COLOR_ACTION.setEnabled(true);
                ENABLE_NODE_ACTION.updateState();
                DISABLE_NODE_ACTION.updateState();
                IFilteredCollection<Composite> iFilteredCollection = pyroSimSelectionModel.getSelected(Composite.class);
                Actions.getSortAction().setEnabled(!iFilteredCollection.isEmpty());
                Collection<IPyroGeomSrc> collection = pyroSimSelectionModel.flatten(IPyroGeomSrc.class);
                Actions.getAddFloorFromGeomAction().setEnabled(!collection.isEmpty());
                RASTERIZE_OBJECTS_ACTION.updateEnabled();
                WRITE_AS_GEOM.updateEnabled();
                WRITE_AS_OBST.updateEnabled();
                EXPLODE_ACTION.updateEnabled();
                GROUP_GEOM_ACTION.updateEnabled();
                SELECT_BY_COLOR_ACTION.updateEnabled();
                ADD_HVAC_VENT_NODES.updateEnabled();
                CONNECT_WITH_HVAC.updateEnabled(pyroMod);
                EXTRUDE_LINES.updateEnabled();
                IFilteredCollection<Surface> iFilteredCollection2 = pyroSimSelectionModel.getSelected(Surface.class);
                SET_DEFAULT_SURFACE_ACTION.setEnabled(iFilteredCollection2.isExclusive() && iFilteredCollection2.size() == 1 && iFilteredCollection2.iterator().next() != pyroMod.getSimParams().getMisc().getSurfDefault());
                IFilteredCollection<Reaction> iFilteredCollection3 = pyroSimSelectionModel.getSelected(Reaction.class);
                CLEAR_REACTION_ACTION.setEnabled(iFilteredCollection3.isExclusive() && iFilteredCollection3.size() == 1 && ((Reaction)iFilteredCollection3.iterator().next()).isActive());
                SET_REACTION_ACTION.setEnabled(iFilteredCollection3.isExclusive() && iFilteredCollection3.size() == 1 && !((Reaction)iFilteredCollection3.iterator().next()).isActive());
                IFilteredCollection<ExSpec> iFilteredCollection4 = pyroSimSelectionModel.getSelected(ExSpec.class);
                CLEAR_BACKGROUND_ACTION.setEnabled(iFilteredCollection4.isExclusive() && iFilteredCollection4.size() == 1 && ((ExSpec)iFilteredCollection4.iterator().next()).isBackgroundSpec());
                SET_BACKGROUND_ACTION.setEnabled(iFilteredCollection4.isExclusive() && iFilteredCollection4.size() == 1 && !((ExSpec)iFilteredCollection4.iterator().next()).isBackgroundSpec());
                ENABLE_FORCE_TO_WRITE_ACTION.updateState(pyroMod);
                DISABLE_FORCE_TO_WRITE_ACTION.updateState(pyroMod);
                IFilteredCollection<IPyroObject> iFilteredCollection5 = pyroSimSelectionModel.getSelected(IPyroObject.class, Grid.class, GridList.class);
                Actions.getOpenGridsAction().setEnabled(!iFilteredCollection5.isEmpty() && iFilteredCollection5.isExclusive());
                Actions.getSubdivideMeshAction().setEnabled(!iFilteredCollection5.isEmpty() && iFilteredCollection5.isExclusive());
                Actions.getRefineMeshAction().setEnabled(!iFilteredCollection5.isEmpty() && iFilteredCollection5.isExclusive());
                Actions.getMergeMeshAction().setEnabled(ActionsMesh.MergeMeshAction.isMergeOptionAvailable(pyroSimSelectionModel));
                Actions.getTranslateAction().setEnabled(!collection.isEmpty());
                Actions.getMirrorAction().setEnabled(!collection.isEmpty());
                Actions.getScaleAction().setEnabled(!collection.isEmpty());
                Actions.getRotateAction().setEnabled(!collection.isEmpty());
                HIDE_NODE_ACTION.setEnabled(!collection.isEmpty());
                SHOW_NODE_ACTION.setEnabled(!collection.isEmpty());
                HIDE_UNSELECTED_NODE_ACTION.setEnabled(!collection.isEmpty());
                SHOW_ALL_NODES_ACTION.setEnabled(true);
                IFilteredCollection<IPyroObject> iFilteredCollection6 = pyroSimSelectionModel.getSelected(IPyroObject.class);
                boolean bl2 = !iFilteredCollection6.isEmpty();
                boolean bl3 = !iFilteredCollection6.isEmpty();
                boolean bl4 = !iFilteredCollection6.isEmpty();
                CUT_ACTION.setEnabled(bl2);
                COPY_ACTION.setEnabled(bl3);
                COPY_FDS_ACTION.setEnabled(bl3);
                REMOVE_SELECTED_NODE_ACTION.setEnabled(bl4);
                EDIT_SELECTED_NODE_ACTION.updateEnabled(pyroMod);
                PASTE_ACTION.setEnabled(true);
                Actions.updateUndoRedoActions(pyroMod);
            }
            CONTEXT_ADD_GROUP_ACTION.updateEnabled(pyroMod, events, bl);
            GLOBAL_ADD_GROUP_ACTION.updateEnabled(pyroMod, events, bl);
            SELECT_REFERENCING_OBJECTS_ACTION.updateEnabled(pyroMod, events, bl);
            CHANGE_GROUP.updateEnabled(pyroMod, events, bl);
            CONTEXT_ADD_VIEW.updateEnabled(pyroMod, events, bl);
            SET_ACTIVE_VIEW_ACTION.updateEnabled(pyroMod, events, bl);
            CONTEXT_ADD_SECTION_BOX.updateEnabled(pyroMod, events, bl);
            GLOBAL_ADD_SECTION_BOX.updateEnabled(pyroMod, events, bl);
            CONTEXT_RESET_SECTION_BOX.updateEnabled(pyroMod, events, bl);
            GLOBAL_RESET_SECTION_BOX.updateEnabled(pyroMod, events, bl);
            CONTEXT_SAVE_VIEW_CAMERA.updateEnabled(pyroMod, events, bl);
            GLOBAL_SAVE_VIEW_CAMERA.updateEnabled(pyroMod, events, bl);
            CONTEXT_SHOW_VIEW_CAMERA.updateEnabled(pyroMod, events, bl);
            GLOBAL_SHOW_VIEW_CAMERA.updateEnabled(pyroMod, events, bl);
            CREATE_SECTION.updateEnabled(pyroMod, events, bl);
            DUPLICATE_VIEW.updateEnabled(pyroMod, events, bl);
        }
    }
}

