/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.FractionalRampProfile;
import pyrosim.domain.variant.IRampProfile;
import pyrosim.domain.variant.IVarTypeProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.gui.RampFuncDlg;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class VariantEditor {
    public static final String DEFAULT = "Default :";
    public static final String RAMP = "Custom :";
    public static final String TANH = "Tanh";
    public static final String TSQUARED = "<html>t<sup>2</sup></html>";
    private guiComboBox<String> d_combo;
    private guiLabel d_rampLab;
    private String d_valDesc;
    private guiCheckBox d_cb;
    private Hashtable d_tipTable = null;
    private final guiPanel d_cardPanel;
    private Map<String, ValueField> d_fldMap;
    private Map<String, IVarTypeProfile> d_varProfiles;
    private Map<String, RampAction> d_rampMap;
    private Map<String, FracRampAction> d_fracRampMap;
    private Map<String, JButton> d_buttons;
    private final CardLayout d_cards;
    private final String d_strId;
    private final VariantProfile d_varProfile;

    public VariantEditor(String string, String string2, VariantProfile variantProfile) {
        this(string, string2, variantProfile, false);
    }

    public VariantEditor(String string, VariantProfile variantProfile, boolean bl) {
        this(string, string, variantProfile, bl);
    }

    public VariantEditor(String string, String string2, VariantProfile variantProfile, boolean bl) {
        this.d_strId = string;
        this.d_valDesc = string2;
        this.d_varProfile = variantProfile;
        this.d_combo = new guiComboBox();
        final ListCellRenderer listCellRenderer = this.d_combo.getRenderer();
        this.d_combo.setRenderer(new ListCellRenderer<String>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends String> jList, String string, int n, boolean bl, boolean bl2) {
                String string2 = Intl.intl(string);
                return listCellRenderer.getListCellRendererComponent(jList, string2, n, bl, bl2);
            }
        });
        this.d_combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                VariantEditor.this.d_cards.show(VariantEditor.this.d_cardPanel, (String)VariantEditor.this.d_combo.getSelectedItem());
            }
        });
        this.d_fldMap = new HashMap<String, ValueField>();
        this.d_varProfiles = new HashMap<String, IVarTypeProfile>();
        this.d_rampMap = new HashMap<String, RampAction>();
        this.d_fracRampMap = new HashMap<String, FracRampAction>();
        this.d_buttons = new HashMap<String, JButton>();
        this.d_rampLab = new guiLabel(string + ":");
        this.d_cards = new CardLayout();
        this.d_cardPanel = new guiPanel(this.d_cards);
        if (bl) {
            this.d_cb = new guiCheckBox(string);
            LinkStatus.link((AbstractButton)this.d_cb, this.getComponents());
        }
        for (IVarTypeProfile iVarTypeProfile : variantProfile.getAllowableTypes()) {
            this.addComboOption(iVarTypeProfile);
        }
        this.d_combo.setMinimumSize(this.d_combo.getPreferredSize());
    }

    private void addComboOption(IVarTypeProfile iVarTypeProfile) {
        guiPanel guiPanel2;
        String string = iVarTypeProfile.getDisplayName();
        Variant variant = iVarTypeProfile.getDefaultValue();
        this.d_combo.add(string);
        if (iVarTypeProfile instanceof DefaultProfile) {
            guiPanel2 = new guiPanel();
        } else if (iVarTypeProfile instanceof ConstProfile) {
            UnitDouble unitDouble = (UnitDouble)variant.val;
            IUnitSrc iUnitSrc = UnitSystem.getSource(((ConstProfile)iVarTypeProfile).unitType);
            ValueField<UnitDouble> valueField = ValueFields.udFld(iUnitSrc);
            valueField.setValue(unitDouble);
            guiPanel2 = new guiPanel(new GridBagLayout());
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2, false);
            gridBagHelper.addRow(valueField);
            if (this.d_cb != null) {
                LinkStatus.link((AbstractButton)this.d_cb, valueField);
            }
            this.d_fldMap.put(string, valueField);
        } else if (iVarTypeProfile instanceof IRampProfile) {
            RampBtn rampBtn;
            Object object;
            guiPanel2 = new guiPanel(new GridBagLayout());
            if (iVarTypeProfile instanceof FractionalRampProfile) {
                object = new FracRampAction(this.d_strId + ":", this.d_valDesc, (FractionalRampProfile)iVarTypeProfile);
                this.d_fracRampMap.put(string, (FracRampAction)object);
                rampBtn = new RampBtn(guiPanel2.getComm(), (Action)object);
            } else {
                object = new RampAction(this.d_valDesc, (IRampProfile)iVarTypeProfile);
                this.d_rampMap.put(string, (RampAction)object);
                rampBtn = new RampBtn(guiPanel2.getComm(), (Action)object);
            }
            object = new GridBagHelper(guiPanel2, false);
            ((GridBagHelper)object).addRow(rampBtn);
            if (this.d_cb != null) {
                LinkStatus.link((AbstractButton)this.d_cb, rampBtn);
            }
            this.d_buttons.put(string, rampBtn);
            rampBtn.addActionListener(guiPanel2.getComm());
        } else {
            guiPanel2 = new guiPanel();
        }
        this.d_cardPanel.add((Component)guiPanel2, string);
        this.d_varProfiles.put(string, iVarTypeProfile);
    }

    public void addToPanel(guiPanel guiPanel2, int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagUtil.add(guiPanel2, this.getVisLabel(), n + 0, n2, 1, 1, n3, n4, n5, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getCombo(), n + 1, n2, 1, 1, n3, 0, n5, 6, 2, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getEditor(), n + 2, n2, 1, 1, n3, 0, n5, n6, 2, 0.0, 0.0, 17);
        guiPanel2.validate();
    }

    public void addToPanel(guiPanel guiPanel2) {
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2, true);
        this.addToPanel(gridBagHelper);
        gridBagHelper.finalizeRows();
    }

    public void addToPanel(GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(this.getLabel(), this.getCombo(), this.getEditor());
    }

    public void addToPanel(GridBagHelper gridBagHelper, GridBagHelper.Fill fill, GridBagHelper.Fill fill2, GridBagHelper.Fill fill3) {
        gridBagHelper.addRow(new Object[]{this.getLabel(), fill, this.getCombo(), fill2, this.getEditor(), fill3, 0});
    }

    public String getStrLabel() {
        return this.d_strId;
    }

    public boolean validateData(boolean bl, boolean bl2) {
        String string = this.d_combo.getSelectedItem();
        IVarTypeProfile iVarTypeProfile = this.d_varProfiles.get(string);
        if (iVarTypeProfile instanceof FractionalRampProfile) {
            Ramp ramp;
            FracRampAction fracRampAction = this.d_fracRampMap.get(string);
            JButton jButton = this.d_buttons.get(string);
            JComponent jComponent = jButton != null ? jButton : this.d_combo;
            if (!this.validateRamp(bl, bl2, jComponent, ramp = fracRampAction.getRamp())) {
                return false;
            }
        } else if (iVarTypeProfile instanceof IRampProfile) {
            Ramp ramp;
            RampAction rampAction = this.d_rampMap.get(string);
            JButton jButton = this.d_buttons.get(string);
            JComponent jComponent = jButton != null ? jButton : this.d_combo;
            if (!this.validateRamp(bl, bl2, jComponent, ramp = rampAction.getRamp())) {
                return false;
            }
        }
        return true;
    }

    private boolean validateRamp(boolean bl, boolean bl2, Component component, Ramp ramp) {
        if (ramp.isEmpty() && component.isEnabled() && component.isVisible()) {
            if (bl) {
                Window window = SwingUtilities.getWindowAncestor(component);
                String string = String.format(Intl.intl("Custom %s table must not be empty."), this.d_valDesc);
                JOptionPane.showMessageDialog(window, string, Intl.intl("Ramp Error"), 0);
            }
            if (bl2) {
                component.requestFocus();
            }
            return false;
        }
        return true;
    }

    public Variant getValue() {
        Variant variant = null;
        String string = this.d_combo.getSelectedItem();
        IVarTypeProfile iVarTypeProfile = this.d_varProfiles.get(string);
        if (iVarTypeProfile instanceof DefaultProfile) {
            variant = Variant.DEFAULT;
        } else if (iVarTypeProfile instanceof ConstProfile) {
            ValueField valueField = this.d_fldMap.get(string);
            variant = Variant.constant((UnitDouble)valueField.getValue());
        } else if (iVarTypeProfile instanceof FractionalRampProfile) {
            FracRampAction fracRampAction = this.d_fracRampMap.get(string);
            variant = Variant.fracRamp(fracRampAction.getConst(), fracRampAction.getRamp());
        } else if (iVarTypeProfile instanceof IRampProfile) {
            RampAction rampAction = this.d_rampMap.get(string);
            variant = Variant.ramp(rampAction.getRamp());
        }
        return variant;
    }

    private void init(String string) {
        this.init(string, true);
    }

    private void init(String string, boolean bl) {
        this.d_combo.setSelectedItem(string);
        if (this.d_cb != null) {
            this.d_cb.setSelected(bl);
        }
    }

    public boolean init(Variant variant) {
        return this.init(variant, true);
    }

    public boolean init(Variant variant, boolean bl) {
        Variant.Type type = variant.getType();
        for (Map.Entry<String, IVarTypeProfile> entry : this.d_varProfiles.entrySet()) {
            if (entry.getValue().getType() != type) continue;
            this.editComboOption(entry.getKey(), variant);
            this.init(entry.getKey(), bl);
            return true;
        }
        return false;
    }

    private void editComboOption(String string, Variant variant) {
        this.d_varProfiles.get(string);
        if (variant.isConstant()) {
            ValueField valueField = this.d_fldMap.get(string);
            valueField.setValue((UnitDouble)variant.val);
        } else if (variant.isRamp()) {
            RampAction rampAction = this.d_rampMap.get(string);
            rampAction.setRamp((Ramp)variant.val);
        } else if (variant.isFractionalRamp()) {
            FracRampAction fracRampAction = this.d_fracRampMap.get(string);
            Variant.FractionalRamp fractionalRamp = (Variant.FractionalRamp)variant.val;
            fracRampAction.setRamp(fractionalRamp.fractionalRamp);
            fracRampAction.setConst(fractionalRamp.constInput);
        }
    }

    public Component getVisLabel() {
        return this.d_cb == null ? this.getLabel() : this.getCheckBox();
    }

    public guiLabel getLabel() {
        return this.d_rampLab;
    }

    public guiCheckBox getCheckBox() {
        return this.d_cb;
    }

    public guiComboBox getCombo() {
        return this.d_combo;
    }

    public guiPanel getEditor() {
        return this.d_cardPanel;
    }

    public boolean isEnabled() {
        if (this.d_cb == null) {
            return true;
        }
        return this.d_cb.isSelected();
    }

    public void setToolTipLookUp(Hashtable hashtable) {
        this.d_tipTable = hashtable;
    }

    public Component[] getComponents() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(this.d_combo);
        arrayList.add(this.d_rampLab);
        arrayList.addAll(this.d_fldMap.values());
        arrayList.addAll(this.d_buttons.values());
        Component[] componentArray = new Component[arrayList.size()];
        return arrayList.toArray(componentArray);
    }

    private static class FracRampAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private static final String PROP_RAMP = "ramp";
        private static final String PROP_CONST = "const";
        private final String d_rampValDesc;
        private final String d_constValDesc;
        private final FractionalRampProfile d_rampProfile;

        public FracRampAction(String string, String string2, FractionalRampProfile fractionalRampProfile) {
            super(Intl.intl("Edit Values") + "...");
            this.d_constValDesc = string;
            this.d_rampValDesc = string2;
            this.d_rampProfile = fractionalRampProfile;
            Variant.FractionalRamp fractionalRamp = (Variant.FractionalRamp)this.d_rampProfile.getDefaultValue().val;
            this.setRamp(fractionalRamp.fractionalRamp);
            this.setConst(fractionalRamp.constInput);
        }

        public void setRamp(Ramp ramp) {
            this.putValue(PROP_RAMP, ramp);
        }

        public Ramp getRamp() {
            return (Ramp)this.getValue(PROP_RAMP);
        }

        public void setConst(UnitDouble unitDouble) {
            this.putValue(PROP_CONST, unitDouble);
        }

        public UnitDouble getConst() {
            return (UnitDouble)this.getValue(PROP_CONST);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UnitDouble unitDouble = this.getConst();
            Ramp ramp = this.getRamp();
            RampFuncDlg rampFuncDlg = new RampFuncDlg(ramp.getDefaultInput(), ramp.getFUnitType(), this.d_rampValDesc, this.d_rampProfile.getRampInputs(PyroSim.getApp().getMediator()), this.d_rampProfile.constUnitType, this.d_constValDesc);
            rampFuncDlg.loadData(ramp);
            rampFuncDlg.loadData(unitDouble);
            if (rampFuncDlg.doModal() == 1) {
                UnitDouble unitDouble2;
                Ramp ramp2 = rampFuncDlg.getRamp();
                if (!theUtil.equal(ramp, ramp2)) {
                    this.setRamp(ramp2);
                }
                if (!theUtil.equal(unitDouble, unitDouble2 = rampFuncDlg.getConstVal())) {
                    this.setConst(unitDouble2);
                }
            }
        }
    }

    private static class RampAction
    extends AbstractAction {
        private static final long serialVersionUID = 961933547288309311L;
        private static final String PROP_RAMP = "ramp";
        private final String d_valDesc;
        private final IRampProfile d_rampType;

        public RampAction(String string, IRampProfile iRampProfile) {
            super(Intl.intl("Edit Values") + "...");
            this.d_valDesc = string;
            this.d_rampType = iRampProfile;
            this.setRamp((Ramp)iRampProfile.getDefaultValue().val);
        }

        public void setRamp(Ramp ramp) {
            this.putValue(PROP_RAMP, ramp);
        }

        public Ramp getRamp() {
            return (Ramp)this.getValue(PROP_RAMP);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Ramp ramp;
            Ramp ramp2 = this.getRamp();
            RampFuncDlg rampFuncDlg = new RampFuncDlg(ramp2.getDefaultInput(), ramp2.getFUnitType(), this.d_valDesc, this.d_rampType.getRampInputs(PyroSim.getApp().getMediator()));
            rampFuncDlg.loadData(ramp2);
            if (rampFuncDlg.doModal() == 1 && !theUtil.equal(ramp2, ramp = rampFuncDlg.getRamp())) {
                this.setRamp(ramp);
            }
        }
    }

    private static class RampBtn
    extends JButton
    implements Modifiable,
    PropertyChangeListener {
        private static final long serialVersionUID = -3340702741932652669L;
        private final Comm d_comm;
        private boolean d_modified = false;

        public RampBtn(Comm comm, Action action) {
            super(action);
            this.d_comm = comm;
            action.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("ramp")) {
                this.setModified(true);
                this.d_comm.touch(propertyChangeEvent);
            }
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean bl) {
            this.d_modified = bl;
        }
    }
}

