/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.io.TimeHistoryData;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.Series;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiUtil;

public class TimeHistoryPlotDlg
extends guiFrame {
    private static final long serialVersionUID = -3930005600781236822L;
    private static final Color LINE_COLOR = new Color(0, 64, 128);
    private TimeHistoryData d_data;
    private final Graph d_graph;
    private final JList d_list;
    private int d_showindex;

    public TimeHistoryPlotDlg(JFrame jFrame, TimeHistoryData timeHistoryData) {
        super("Time History Plots");
        super.setResizable(true);
        this.d_showindex = 0;
        this.d_data = timeHistoryData;
        this.d_list = new JList(new ListData());
        this.d_list.addListSelectionListener(new ListReactor());
        this.d_graph = new Graph();
        this.d_graph.setPreferredSize(new Dimension(500, 400));
        Container container = super.getContentPane();
        container.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, this.buildNav(), this.buildVis());
        container.add((Component)jSplitPane, "Center");
        this.setJMenuBar(this.buildMenuBar());
        this.d_list.setSelectedIndex(0);
        this.pack();
        this.center();
    }

    private JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        guiMenu guiMenu2 = new guiMenu(Intl.intl("File"));
        guiMenu2.add(new RefreshAction());
        guiMenu2.add(new ExportAction());
        jMenuBar.add(guiMenu2);
        return jMenuBar;
    }

    private Container buildNav() {
        JScrollPane jScrollPane = new JScrollPane(this.d_list);
        jScrollPane.setVerticalScrollBarPolicy(22);
        Dimension dimension = jScrollPane.getPreferredSize();
        jScrollPane.setMinimumSize(new Dimension(dimension));
        dimension.width = Math.max(100, dimension.width);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private Container buildVis() {
        return this.d_graph;
    }

    public void showDataFor(int n) {
        this.d_graph.reset();
        String string = this.d_data.getLabels().get(n + 1);
        String string2 = this.d_data.getQuantities().get(n + 1);
        String string3 = this.d_data.getUnits().get(n + 1);
        this.d_graph.setTitle(string);
        this.d_graph.setXTitle(Intl.intl("Time") + " (s)");
        this.d_graph.setYTitle(string2 + " (" + string3 + ")");
        int n2 = this.d_data.getNumValues();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.d_data.getValues(i).get(0);
            dArray2[i] = this.d_data.getValues(i).get(n + 1);
            d = Math.min(d, dArray[i]);
            d2 = Math.max(d2, dArray[i]);
            d3 = Math.min(d3, dArray2[i]);
            d4 = Math.max(d4, dArray2[i]);
        }
        Series series = new Series(dArray, dArray2, string, LINE_COLOR, 13, 0, 3);
        this.d_graph.addSeries(series);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeHistoryPlotDlg.this.d_graph.repaint();
            }
        });
    }

    private class ExportAction
    extends guiAction {
        private static final long serialVersionUID = 4043590402228677578L;

        public ExportAction() {
            super(Intl.intl("Image Capture..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = PyroSim.getFilenames().getSaveFile((Component)TimeHistoryPlotDlg.this, new File("untitled.png"), "png", Intl.intl("Portable Network Graphics Images"));
            if (file == null) {
                return;
            }
            BufferedImage bufferedImage = new BufferedImage(TimeHistoryPlotDlg.this.d_graph.getWidth(), TimeHistoryPlotDlg.this.d_graph.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            TimeHistoryPlotDlg.this.d_graph.paint(graphics2D);
            graphics2D.dispose();
            try {
                if (file.getName().toLowerCase().endsWith(".png")) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                } else {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(file.getPath() + ".png"));
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(TimeHistoryPlotDlg.this, Intl.intl("Error saving image: ") + exception.getMessage());
            }
        }
    }

    private class RefreshAction
    extends guiAction {
        private static final long serialVersionUID = -4835775713376103652L;

        public RefreshAction() {
            super(Intl.intl("Refresh"));
            this.addAccelerator(KeyStroke.getKeyStroke(116, 0));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TimeHistoryData timeHistoryData = TimeHistoryPlotDlg.this.d_data.refresh();
                TimeHistoryPlotDlg.this.d_data = timeHistoryData;
                TimeHistoryPlotDlg.this.showDataFor(TimeHistoryPlotDlg.this.d_list.getSelectedIndex());
            }
            catch (Throwable throwable) {
                guiUtil.showError(TimeHistoryPlotDlg.this, Intl.intl("CSV Error"), Intl.intl("Error Reading CSV File"), throwable);
            }
        }
    }

    private class ListData
    extends AbstractListModel {
        private static final long serialVersionUID = -1892703556290673639L;

        private ListData() {
        }

        @Override
        public int getSize() {
            return TimeHistoryPlotDlg.this.d_data.getLabels().size() - 1;
        }

        @Override
        public Object getElementAt(int n) {
            return TimeHistoryPlotDlg.this.d_data.getLabels().get(n + 1);
        }
    }

    private class ListReactor
    implements ListSelectionListener {
        private ListReactor() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            TimeHistoryPlotDlg.this.d_showindex = TimeHistoryPlotDlg.this.d_list.getSelectedIndex();
            TimeHistoryPlotDlg.this.showDataFor(TimeHistoryPlotDlg.this.d_showindex);
        }
    }
}

