/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.gui.RampFuncDlg;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.theUtil;

public class TimeFunctionEditor {
    public final int IX_DEFAULT;
    public final int IX_AUTO;
    public final int IX_TANH;
    public final int IX_TSQUARED;
    public final int IX_FROM_TABLE;
    public static final int DEFAULT = 1;
    public static final int AUTO = 2;
    public static final int TANH = 4;
    public static final int TSQUARED = 8;
    public static final int CUSTOM = 16;
    public static final String STR_DEFAULT = Intl.intl("Default");
    public static final String STR_AUTO = Intl.intl("Automatic");
    public static final String STR_TANH = Intl.intl("Tanh");
    public static final String STR_TSQUARED = Intl.intl("<html>t<sup>2</sup></html>");
    public static final String STR_CUSTOM = Intl.intl("Custom");
    private guiComboBox<String> d_combo;
    private final String d_label;
    private guiLabel d_rampLab;
    private ValueField<UnitDouble> d_tanhFld;
    private ValueField<UnitDouble> d_tsquaredFld;
    private ValueField<UnitDouble> d_defaultFld;
    private ValueField<UnitDouble> d_autoFld;
    private JButton d_button;
    private guiPanel d_panel;
    private Hashtable d_tipTable = null;
    private RampAction d_rampAction;

    public TimeFunctionEditor(String string, int n) {
        int n2 = 0;
        this.d_label = string;
        this.d_combo = new PreFireComboBox();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.d_rampLab = new guiLabel(string + ":");
        this.d_tanhFld = ValueFields.udFld(UnitSystem.getSource(2), UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_tsquaredFld = ValueFields.udFld(UnitSystem.getSource(2), UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_defaultFld = ValueFields.udFld(UnitSystem.getSource(2));
        this.d_autoFld = ValueFields.udFld(UnitSystem.getSource(2));
        this.d_defaultFld.setEditable(false);
        this.d_autoFld.setEditable(false);
        this.d_button = new JButton(Intl.intl("Edit Values") + "...");
        this.d_defaultFld.setValue((UnitDouble)TimeFunction.newDefault().val);
        this.d_tanhFld.setValue(new TimeFunction.TanH().val);
        this.d_tsquaredFld.setValue(new TimeFunction.TSquared().val);
        Dimension dimension = this.d_defaultFld.getPreferredSize();
        dimension.width = this.d_button.getPreferredSize().width;
        this.d_tanhFld.setPreferredSize(dimension);
        this.d_tsquaredFld.setPreferredSize(dimension);
        this.d_defaultFld.setPreferredSize(dimension);
        this.d_autoFld.setPreferredSize(dimension);
        this.d_button.setPreferredSize(dimension);
        this.d_panel = new guiPanel(gridBagLayout);
        this.d_rampAction = new RampAction(this.d_panel);
        this.d_button.addActionListener(this.d_rampAction);
        if ((n & 1) != 0) {
            this.d_defaultFld.setVisible(n2 == 0);
            this.d_combo.addItem((String)STR_DEFAULT);
            this.IX_DEFAULT = n2++;
            this.d_panel.add(this.d_defaultFld, gridBagConstraints);
        } else {
            this.IX_DEFAULT = -1;
        }
        if ((n & 2) != 0) {
            this.d_autoFld.setVisible(n2 == 0);
            this.d_combo.addItem((String)STR_AUTO);
            this.IX_AUTO = n2++;
            this.d_panel.add(this.d_autoFld, gridBagConstraints);
        } else {
            this.IX_AUTO = -1;
        }
        if ((n & 4) != 0) {
            this.d_tanhFld.setVisible(n2 == 0);
            this.d_combo.addItem((String)STR_TANH);
            this.IX_TANH = n2++;
            this.d_panel.add(this.d_tanhFld, gridBagConstraints);
        } else {
            this.IX_TANH = -1;
        }
        if ((n & 8) != 0) {
            this.d_tsquaredFld.setVisible(n2 == 0);
            this.d_combo.addItem((String)STR_TSQUARED);
            this.IX_TSQUARED = n2++;
            this.d_panel.add(this.d_tsquaredFld, gridBagConstraints);
        } else {
            this.IX_TSQUARED = -1;
        }
        if ((n & 0x10) != 0) {
            this.d_button.setVisible(n2 == 0);
            this.d_combo.addItem((String)STR_CUSTOM);
            this.IX_FROM_TABLE = n2++;
            this.d_panel.add((Component)this.d_button, gridBagConstraints);
        } else {
            this.IX_FROM_TABLE = -1;
        }
        this.d_combo.setMinimumSize(this.d_combo.getPreferredSize());
        this.loadFunction(TimeFunction.newDefault());
    }

    public void addToPanel(guiPanel guiPanel2, int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagUtil.add(guiPanel2, this.getLabel(), n + 0, n2, 1, 1, n3, n4, n5, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getCombo(), n + 1, n2, 1, 1, n3, 0, n5, 6, 2, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getEditor(), n + 2, n2, 1, 1, n3, 0, n5, n6, 2, 0.0, 0.0, 17);
    }

    public void setEnabled(boolean bl) {
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        for (Component component : this.getComponents()) {
            if (!component.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void updateComponents() {
        boolean bl = this.d_combo.getSelectedIndex() == this.IX_DEFAULT;
        boolean bl2 = this.d_combo.getSelectedIndex() == this.IX_AUTO;
        boolean bl3 = this.d_combo.getSelectedIndex() == this.IX_TANH;
        boolean bl4 = this.d_combo.getSelectedIndex() == this.IX_TSQUARED;
        boolean bl5 = this.d_combo.getSelectedIndex() == this.IX_FROM_TABLE;
        this.d_defaultFld.setVisible(bl);
        this.d_autoFld.setVisible(bl2);
        this.d_tanhFld.setVisible(bl3);
        this.d_tsquaredFld.setVisible(bl4);
        this.d_button.setVisible(bl5);
        if (this.d_tipTable != null && this.d_tipTable.containsKey(new Integer(this.d_combo.getSelectedIndex()))) {
            this.d_rampLab.setToolTipText((String)this.d_tipTable.get(new Integer(this.d_combo.getSelectedIndex())));
        } else {
            this.d_rampLab.setToolTipText(null);
        }
        this.d_panel.revalidate();
    }

    public TimeFunction<?> saveFunction() {
        TimeFunction timeFunction = null;
        String string = this.d_combo.getSelectedItem();
        if (string == STR_CUSTOM) {
            timeFunction = new TimeFunction.Custom(this.d_rampAction.d_ramp);
        } else if (string == STR_TSQUARED) {
            timeFunction = new TimeFunction.TSquared((UnitDouble)this.d_tsquaredFld.getValue());
        } else if (string == STR_TANH) {
            timeFunction = new TimeFunction.TanH((UnitDouble)this.d_tanhFld.getValue());
        } else if (string == STR_DEFAULT) {
            timeFunction = TimeFunction.newDefault();
        }
        return timeFunction;
    }

    public void loadFunction(TimeFunction timeFunction) {
        TimeFunction timeFunction2 = TimeFunction.newDefault();
        if (timeFunction2.equals(timeFunction)) {
            this.d_combo.setSelectedItem(STR_DEFAULT);
        } else if (timeFunction instanceof TimeFunction.TanH) {
            this.d_tanhFld.setValue((UnitDouble)timeFunction.val);
            this.d_combo.setSelectedItem(STR_TANH);
        } else if (timeFunction instanceof TimeFunction.TSquared) {
            this.d_tsquaredFld.setValue((UnitDouble)timeFunction.val);
            this.d_combo.setSelectedItem(STR_TSQUARED);
        } else if (timeFunction instanceof TimeFunction.Custom) {
            this.d_rampAction.d_ramp = (Ramp)timeFunction.val;
            this.d_combo.setSelectedItem(STR_CUSTOM);
        } else {
            this.d_combo.setSelectedIndex(-1);
        }
    }

    public Component[] getComponents() {
        return new Component[]{this.d_panel, this.d_combo, this.d_rampLab};
    }

    public guiLabel getLabel() {
        return this.d_rampLab;
    }

    public guiComboBox getCombo() {
        return this.d_combo;
    }

    public guiPanel getEditor() {
        return this.d_panel;
    }

    public JButton getButton() {
        return this.d_button;
    }

    public ValueField getTanhField() {
        return this.d_tanhFld;
    }

    public ValueField getTsquaredField() {
        return this.d_tsquaredFld;
    }

    public ValueField getAutoField() {
        return this.d_autoFld;
    }

    public void setToolTipLookUp(Hashtable hashtable) {
        this.d_tipTable = hashtable;
    }

    public boolean validateData(boolean bl, boolean bl2) {
        Ramp ramp;
        Window window = SwingUtilities.getWindowAncestor(this.d_combo);
        String string = this.d_combo.getSelectedItem();
        if (string == STR_CUSTOM && this.d_button.isEnabled() && this.d_button.isVisible() && (ramp = this.d_rampAction.getRamp()).isEmpty()) {
            if (bl) {
                String string2 = String.format(Intl.intl("Custom %s table must not be empty."), this.d_label);
                JOptionPane.showMessageDialog(window, string2, Intl.intl("Ramp Error"), 0);
            }
            if (bl2) {
                this.d_button.requestFocus();
            }
            return false;
        }
        return true;
    }

    public static class RampAction
    implements ActionListener {
        private Modifiable d_owner;
        private Ramp d_ramp;

        public RampAction(Modifiable modifiable) {
            this.d_owner = modifiable;
            this.d_ramp = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
        }

        public Ramp getRamp() {
            return this.d_ramp;
        }

        public void setRamp(Ramp ramp) {
            this.d_ramp = ramp;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Ramp ramp;
            RampFuncDlg rampFuncDlg = RampFuncDlg.newTimeFracDlg(this.d_ramp);
            if (rampFuncDlg.doModal() == 1 && !theUtil.equal(this.d_ramp, ramp = rampFuncDlg.getRamp())) {
                this.d_ramp = ramp;
                this.rampEdited(true);
                return;
            }
            this.rampEdited(false);
        }

        protected void rampEdited(boolean bl) {
            if (bl) {
                this.d_owner.setModified(true);
            }
        }
    }

    private class PreFireComboBox
    extends guiComboBox {
        private static final long serialVersionUID = 1111741296664998502L;

        private PreFireComboBox() {
        }

        @Override
        protected void fireActionEvent() {
            TimeFunctionEditor.this.updateComponents();
            super.fireActionEvent();
        }
    }
}

