/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.io.POVRayWriter;
import pyrosim.mv.ModelView;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.IntVR;

public class SnapshotDialog
extends guiDialog {
    private static final long serialVersionUID = -246230779389540893L;
    private static final String nl = System.getProperty("line.separator");
    private final File d_outFile;
    private final ModelView d_mv;
    private final PyroSim d_pyro;
    private final JRadioButton d_snapshotButton;
    private final JRadioButton d_povrayButton;
    private final JCheckBox d_antiAlias;
    private final JCheckBox d_shadows;
    private final JCheckBox d_povFile;
    private final TitleSeparator d_exportTypeTitle;
    private final guiPanel d_dlgPanel;
    private ValueField<Integer> d_widthField;
    private ValueField<Integer> d_heightField;
    private final JButton d_useWindowSizeButton;

    public SnapshotDialog(JFrame jFrame, PyroSim pyroSim, ModelView modelView, File file) {
        super((Window)jFrame, Intl.intl("Snapshot Properties"), 9);
        this.d_outFile = file;
        this.d_mv = modelView;
        this.d_pyro = pyroSim;
        this.d_dlgPanel = super.getDialogPane();
        this.d_dlgPanel.setLayout(new GridBagLayout());
        this.d_snapshotButton = new JRadioButton(Intl.intl("PyroSim"));
        this.d_povrayButton = new JRadioButton(Intl.intl("POV-Ray"));
        this.d_antiAlias = new JCheckBox(Intl.intl("Anti-alias"));
        this.d_shadows = new JCheckBox(Intl.intl("Shadows"));
        this.d_povFile = new JCheckBox(Intl.intl("Export POV File"));
        this.d_exportTypeTitle = new TitleSeparator(Intl.intl("Render Program"));
        this.d_widthField = ValueFields.intFld();
        this.d_heightField = ValueFields.intFld();
        this.d_useWindowSizeButton = new JButton(Intl.intl("Use window size"));
        new guiButtonGroup(this.d_snapshotButton, this.d_povrayButton);
        LinkStatus.link((AbstractButton)this.d_povrayButton, this.d_antiAlias, this.d_shadows, this.d_povFile);
        this.setInitialProperties();
        this.buildPanel();
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        if (n == 1) {
            this.d_pyro.beginWaitCursor();
            if (this.d_snapshotButton.isSelected()) {
                this.takeShot();
            } else {
                this.runPOV();
            }
            this.d_pyro.endWaitCursor();
        }
        return n;
    }

    private void buildPanel() {
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Size") + ":");
        guiLabel guiLabel3 = new guiLabel(Intl.intl("(fast, medium quality)"));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("(slow, high quality)"));
        guiLabel guiLabel5 = new guiLabel("x");
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel2, guiLabel2, 0, ++n, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_widthField, 1, n, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel5, 2, n, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_heightField, 3, n, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_useWindowSizeButton, 4, n, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        n = 0;
        GridBagUtil.add(guiPanel3, this.d_exportTypeTitle, 0, n, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_snapshotButton, 0, ++n, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, guiLabel3, 1, n, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_povrayButton, 0, ++n, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, guiLabel4, 1, n, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        guiPanel guiPanel4 = new guiPanel(new GridBagLayout());
        n = 0;
        GridBagUtil.add(guiPanel4, this.d_antiAlias, 0, n, 1, 1, 0, 24, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel4, this.d_shadows, 1, n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel4, this.d_povFile, 2, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        n = 0;
        GridBagUtil.add(this.d_dlgPanel, guiPanel2, 0, ++n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
    }

    private void setInitialProperties() {
        if (PyroPrefs.getBoolean(PyroPrefs.LastScreenShotPyroButton)) {
            Dimension dimension = this.d_mv.getScreenshotGenerator().getMaximumSize();
            this.d_widthField.setFilter(IntVR.between(1, dimension.width, true, true));
            this.d_heightField.setFilter(IntVR.between(1, dimension.height, true, true));
        } else {
            this.d_widthField.setFilter(IntVR.between(1, 5000000, true, true));
            this.d_heightField.setFilter(IntVR.between(1, 5000000, true, true));
        }
        this.d_widthField.setColumns(5);
        this.d_heightField.setColumns(5);
        this.fillSizeFromView();
        try {
            int n = PyroPrefs.getInt(PyroPrefs.LastScreenShotWidth);
            int n2 = PyroPrefs.getInt(PyroPrefs.LastScreenShotHeight);
            this.d_widthField.setValue(n);
            this.d_heightField.setValue(n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.d_useWindowSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotDialog.this.fillSizeFromView();
            }
        });
        boolean bl = PyroPrefs.getBoolean(PyroPrefs.LastScreenShotPyroButton);
        this.d_snapshotButton.setSelected(bl);
        this.d_povrayButton.setSelected(!bl);
        this.d_antiAlias.setSelected(PyroPrefs.getBoolean(PyroPrefs.POVScreenShotAntiAlias));
        this.d_antiAlias.setEnabled(!bl);
        this.d_shadows.setSelected(PyroPrefs.getBoolean(PyroPrefs.POVScreenShotShadows));
        this.d_shadows.setEnabled(!bl);
        this.d_povFile.setSelected(PyroPrefs.getBoolean(PyroPrefs.POVScreenShotPOVFile));
        this.d_povFile.setEnabled(!bl);
        this.d_snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dimension dimension = SnapshotDialog.this.d_mv.getScreenshotGenerator().getMaximumSize();
                SnapshotDialog.this.d_widthField.setFilter(IntVR.between(1, dimension.width, true, true));
                SnapshotDialog.this.d_heightField.setFilter(IntVR.between(1, dimension.height, true, true));
            }
        });
        this.d_povrayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PyroPrefs.getString(PyroPrefs.PREF_MPOVLOCATION);
                if (string == null || !new File(string).exists()) {
                    JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location specified for MegaPOV is invalid.  Please specify a valid file by\ngoing to \"File->Preferences.\""), Intl.intl("Invalid MegaPOV File Specified"), 0);
                    SnapshotDialog.this.d_snapshotButton.setSelected(true);
                    return;
                }
                String string2 = FilenameManager.getExtension(SnapshotDialog.this.d_outFile.getName());
                if (!(string2.equalsIgnoreCase("png") || string2.equalsIgnoreCase("tga") || string2.equalsIgnoreCase("targa") || string2.equalsIgnoreCase("ppm"))) {
                    JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Only PNG, TGA, and PPM files may be output by MegaPOV."), Intl.intl("Invalid File Type"), 0);
                    SnapshotDialog.this.d_snapshotButton.setSelected(true);
                    return;
                }
                SnapshotDialog.this.d_widthField.setFilter(IntVR.above(1, true));
                SnapshotDialog.this.d_heightField.setFilter(IntVR.above(1, true));
            }
        });
    }

    private void fillSizeFromView() {
        this.d_widthField.setValue(this.d_mv.getRenderComponent().getWidth());
        this.d_heightField.setValue(this.d_mv.getRenderComponent().getHeight());
    }

    private void runPOV() {
        int n = (Integer)this.d_widthField.getValue();
        int n2 = (Integer)this.d_heightField.getValue();
        boolean bl = this.d_antiAlias.isSelected();
        boolean bl2 = this.d_shadows.isSelected();
        boolean bl3 = this.d_povFile.isSelected();
        POVRayWriter.writePOVRayFile(this.d_pyro, this.d_outFile.getAbsolutePath(), n, n2, bl, bl2, bl3);
        PyroPrefs.set(PyroPrefs.LastScreenShotWidth, this.d_widthField.getValue(), false);
        PyroPrefs.set(PyroPrefs.LastScreenShotHeight, this.d_heightField.getValue(), false);
        PyroPrefs.set(PyroPrefs.POVScreenShotAntiAlias, bl, false);
        PyroPrefs.set(PyroPrefs.POVScreenShotShadows, bl2, false);
        PyroPrefs.set(PyroPrefs.POVScreenShotPOVFile, bl3, false);
        PyroPrefs.set(PyroPrefs.LastScreenShotPyroButton, false, true);
    }

    private boolean takeShot() {
        this.d_mv.getScreenshotGenerator().setSize((Integer)this.d_widthField.getValue(), (Integer)this.d_heightField.getValue());
        this.d_mv.getScreenshotGenerator().writeFile(this.d_outFile.getAbsolutePath());
        PyroPrefs.set(PyroPrefs.LastScreenShotWidth, this.d_widthField.getValue(), false);
        PyroPrefs.set(PyroPrefs.LastScreenShotHeight, this.d_heightField.getValue(), false);
        PyroPrefs.set(PyroPrefs.LastScreenShotPyroButton, true, true);
        this.d_mv.getRenderComponent().repaint();
        return true;
    }
}

