/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.FDSRecordPreviewPanel;
import pyrosim.gui.VariantEditor;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.geom.RastOptionsPnl;
import pyrosim.io.fds.FDS;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SimulationPropertiesDlg
extends guiDialog {
    private static final long serialVersionUID = 888724414754473579L;
    private final PyroMod d_mediator = ((PyroSim)Application.getApp()).getMediator();
    private final guiPanel d_dlgPanel = super.getDialogPane();
    private final TimePanel d_timePanel;
    private final EnvironmentPanel d_envPanel;
    private final ParticlePanel d_particlePanel;
    private final SimulatorPanel d_simPanel;
    private final RadPanel d_radPanel;
    private final OutputPanel d_outputPanel;
    private final MiscPanel d_miscPanel;
    private final guiTextField d_tfSimTitle;
    private final AngledGeomPanel d_angledGeomPnl;
    private final FDSRecordPreviewPanel d_preview;
    private boolean d_previewLock;
    private SimParams d_tempParams;

    public SimulationPropertiesDlg(JFrame jFrame) {
        super((Window)jFrame, Intl.intl("Simulation Parameters"), 9);
        this.d_dlgPanel.setLayout(new GridBagLayout());
        this.d_timePanel = new TimePanel(this.d_mediator);
        this.d_envPanel = new EnvironmentPanel(this.d_mediator);
        this.d_particlePanel = new ParticlePanel(this.d_mediator);
        this.d_simPanel = new SimulatorPanel(this.d_mediator);
        this.d_radPanel = new RadPanel(this.d_mediator);
        this.d_outputPanel = new OutputPanel(this.d_mediator);
        this.d_miscPanel = new MiscPanel(this.d_mediator);
        this.d_tfSimTitle = new guiTextField();
        this.d_angledGeomPnl = new AngledGeomPanel();
        this.d_preview = PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW) ? new FDSRecordPreviewPanel(FDS.newRenderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps())) : null;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Intl.intl("Time"), this.d_timePanel.getPanel());
        jTabbedPane.addTab(Intl.intl("Output"), this.d_outputPanel.getPanel());
        jTabbedPane.addTab(Intl.intl("Environment"), this.d_envPanel.getPanel());
        jTabbedPane.addTab(Intl.intl("Particles"), this.d_particlePanel.getPanel());
        jTabbedPane.addTab(Intl.intl("Simulator"), this.d_simPanel.getPanel());
        jTabbedPane.addTab(Intl.intl("Radiation"), this.d_radPanel.getPanel());
        jTabbedPane.addTab(Intl.intl("Angled Geometry"), this.d_angledGeomPnl);
        jTabbedPane.addTab(Intl.intl("Misc."), this.d_miscPanel.getPanel());
        Dimension dimension = this.d_tfSimTitle.getPreferredSize();
        this.d_tfSimTitle.setPreferredSize(new Dimension(280, dimension.height));
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Simulation Title") + ":");
        GridBagUtil.add(this.d_dlgPanel, guiLabel2, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPanel, this.d_tfSimTitle, 1, 0, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_dlgPanel, jTabbedPane, 0, 1, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        if (this.d_preview != null) {
            GridBagUtil.add(this.d_dlgPanel, this.d_preview, 0, 2, 2, 1, 12, 0, 0, 0, 2, 1.0, 0.0, 17);
        }
        this.d_previewLock = true;
        this.d_timePanel.loadData();
        this.d_envPanel.loadData();
        this.d_particlePanel.loadData();
        this.d_simPanel.loadData();
        this.d_radPanel.loadData();
        this.d_outputPanel.loadData();
        this.d_miscPanel.loadData();
        this.d_angledGeomPnl.load(this.d_mediator.getRastOptions());
        this.loadData();
        this.d_previewLock = false;
        if (this.d_preview != null) {
            this.d_tempParams = (SimParams)this.d_mediator.getSimParams().clone();
            this.d_mediator.pauseUpdates(false);
            this.d_tempParams.setDomain(this.d_mediator, this.d_mediator);
            try {
                this.d_preview.setRecord(this.d_tempParams, false);
            }
            catch (Throwable throwable) {
                System.err.println("[0x923843] FDS Preview Failed: " + throwable.getMessage());
                throwable.printStackTrace();
            }
            this.d_tempParams.setDomain(null, null);
            this.d_mediator.resumeUpdates();
            this.d_dlgPanel.addObserver((observable, object) -> {
                if (this.d_previewLock) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    try {
                        if (this.validateData(false, false)) {
                            this.saveData(this.d_tempParams);
                            this.d_mediator.pauseUpdates(false);
                            this.d_tempParams.setDomain(this.d_mediator, this.d_mediator);
                            this.d_preview.setRecord(this.d_tempParams, true);
                            this.d_tempParams.setDomain(null, null);
                            this.d_mediator.resumeUpdates();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                });
            });
        }
    }

    public void saveData() {
        this.d_mediator.pauseUpdates();
        this.saveData(this.d_mediator.getSimParams());
        this.d_mediator.setRastProps(this.d_angledGeomPnl.save());
        this.d_mediator.resumeUpdates();
    }

    public void saveData(SimParams simParams) {
        String string = this.d_tfSimTitle.getText();
        if (string != null) {
            if (!(string = string.trim()).equals("")) {
                simParams.setJobTitle(string);
            } else {
                simParams.setJobTitle(null);
            }
        } else {
            simParams.setJobTitle(null);
        }
        this.d_timePanel.saveData(simParams.getTime(), simParams.getOpenMp());
        this.d_envPanel.saveData(simParams.getEnvironment(), simParams.getWind());
        this.d_particlePanel.saveData(simParams.getParticles());
        this.d_simPanel.saveData(simParams.getCalculations());
        this.d_radPanel.saveData(simParams.getRadiTransport());
        this.d_outputPanel.saveData(simParams.getFileOutput());
        this.d_miscPanel.saveData(simParams, simParams.getMisc());
    }

    private void loadData() {
        String string = this.d_mediator.getSimParams().getJobTitle();
        if (string != null) {
            this.d_tfSimTitle.setText(string);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        return this.d_simPanel.validateData(bl, bl2) && this.d_envPanel.validateData(bl, bl2);
    }

    private void addDefault() {
    }

    private static void addVariantToPanel(GridBagHelper gridBagHelper, VariantEditor variantEditor) {
        variantEditor.addToPanel(gridBagHelper, GridBagHelper.Fill.NONE, GridBagHelper.Fill.BOTH, GridBagHelper.Fill.NONE);
    }

    public static boolean validateVariant(Component component, VariantEditor variantEditor, boolean bl, String string) {
        if (variantEditor.getValue().isRamp() && ((Ramp)variantEditor.getValue().val).isEmpty()) {
            if (bl) {
                String string2 = String.format(Intl.intl("Ramp, %s, is empty."), string);
                guiDialog.showInvalidEntryMessage(component, string2);
            }
            return false;
        }
        return true;
    }

    private static class WindPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final CustomWindProfile d_customProfile;
        private final SimilarityWindProfile d_simProfile;
        private final guiComboBox<IWindProfile> d_windProfile;
        private final guiRadioButton d_speedDirTRB;
        private final guiRadioButton d_speedCompsTRB;
        private final VariantEditor d_speedRamp;
        private final VariantEditor d_dirRamp;
        private final VariantEditor d_u0t;
        private final VariantEditor d_v0t;
        private final VariantEditor d_w0t;
        private final VariantEditor d_forceX;
        private final VariantEditor d_forceY;
        private final VariantEditor d_forceZ;
        private final JTabbedPane d_tabPane = new JTabbedPane();

        public WindPanel() {
            guiPanel guiPanel2 = new guiPanel();
            this.d_tabPane.addTab(Intl.intl("Wind Profile"), guiPanel2);
            guiPanel guiPanel3 = new guiPanel();
            this.d_tabPane.addTab(Intl.intl("Speed Change over Time"), guiPanel3);
            guiPanel guiPanel4 = new guiPanel();
            this.d_tabPane.addTab(Intl.intl("Natural Wind"), guiPanel4);
            this.d_customProfile = new CustomWindProfile();
            this.d_simProfile = new SimilarityWindProfile();
            this.d_windProfile = guiUtil.newCombo(iWindProfile -> new Pair<String, Object>(iWindProfile.getName(), null), this.d_customProfile, this.d_simProfile);
            CardLayout cardLayout = new CardLayout();
            guiPanel guiPanel5 = new guiPanel(cardLayout);
            guiPanel5.add((Component)this.d_customProfile, this.d_customProfile.getName());
            guiPanel5.add((Component)this.d_simProfile, this.d_simProfile.getName());
            this.d_windProfile.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                cardLayout.show(guiPanel5, this.d_windProfile.getSelectedItem().getName());
            });
            this.d_speedDirTRB = new guiRadioButton(Intl.intl("Horizontal Speed"));
            this.d_speedCompsTRB = new guiRadioButton(Intl.intl("UV Components"));
            guiUtil.group(new AbstractButton[]{this.d_speedDirTRB, this.d_speedCompsTRB});
            this.d_speedDirTRB.setSelected(true);
            String string = Intl.intl("Speed Fraction");
            this.d_dirRamp = new VariantEditor(Intl.intl("Direction"), Intl.intl("Direction"), SimParams.Wind.DIRECTION_RAMP_PROFILE);
            this.d_speedRamp = new VariantEditor(Intl.intl("Speed"), string, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            this.d_u0t = new VariantEditor(Intl.intl("X Velocity"), string, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            this.d_v0t = new VariantEditor(Intl.intl("Y Velocity"), string, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            this.d_w0t = new VariantEditor(Intl.intl("Z Velocity"), string, SimParams.Wind.SPEED_TIME_RAMP_PROFILE);
            String string2 = Intl.intl("X Force");
            String string3 = Intl.intl("Y Force");
            String string4 = Intl.intl("Z Force");
            this.d_forceX = new VariantEditor(string2, Intl.intl("Force Fraction"), SimParams.Wind.FORCE_PROFILE);
            this.d_forceY = new VariantEditor(string3, Intl.intl("Force Fraction"), SimParams.Wind.FORCE_PROFILE);
            this.d_forceZ = new VariantEditor(string4, Intl.intl("Force Fraction"), SimParams.Wind.FORCE_PROFILE);
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2, true);
            gridBagHelper.addRow(Intl.intl("Wind Profile:"), this.d_windProfile);
            gridBagHelper.addFilledRow(guiPanel5);
            gridBagHelper.finalizeRows();
            gridBagHelper = new GridBagHelper(guiPanel3, true);
            gridBagHelper.addRow(this.d_speedDirTRB, 0);
            gridBagHelper.indent();
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_speedRamp);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_dirRamp);
            gridBagHelper.unindent();
            gridBagHelper.addRow(this.d_speedCompsTRB, 0);
            gridBagHelper.indent();
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_u0t);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_v0t);
            gridBagHelper.unindent();
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_w0t);
            gridBagHelper.finalizeRows();
            gridBagHelper = new GridBagHelper(guiPanel4, true);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_forceX);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_forceY);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_forceZ);
            gridBagHelper.finalizeRows();
            gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(this.d_tabPane);
            gridBagHelper.finalizeRows();
            guiUtil.link((AbstractButton)this.d_speedDirTRB, this.d_speedRamp.getComponents());
            guiUtil.link((AbstractButton)this.d_speedDirTRB, this.d_dirRamp.getComponents());
            guiUtil.link((AbstractButton)this.d_speedCompsTRB, this.d_u0t.getComponents());
            guiUtil.link((AbstractButton)this.d_speedCompsTRB, this.d_v0t.getComponents());
            this.load(new SimParams.Wind());
        }

        public void load(SimParams.Wind wind) {
            boolean bl;
            UnitDouble unitDouble = wind.get(SimParams.Wind.L);
            boolean bl2 = bl = !unitDouble.epsilonEquals(new UnitDouble(0.0, SI.METER), 1.0E-10);
            if (bl) {
                this.d_windProfile.setSelectedItem(this.d_simProfile);
            } else {
                this.d_windProfile.setSelectedItem(this.d_customProfile);
            }
            this.d_simProfile.load(wind);
            this.d_customProfile.load(wind);
            this.d_speedRamp.init(wind.get(SimParams.Wind.SPEED_RAMP));
            this.d_dirRamp.init(wind.get(SimParams.Wind.DIRECTION_RAMP));
            Variant variant = wind.get(SimParams.Wind.U0T);
            Variant variant2 = wind.get(SimParams.Wind.V0T);
            if (!variant.equals(SimParams.Wind.U0T.defVal) || !variant2.equals(SimParams.Wind.V0T.defVal)) {
                this.d_speedCompsTRB.setSelected(true);
            } else {
                this.d_speedDirTRB.setSelected(true);
            }
            this.d_u0t.init(variant);
            this.d_v0t.init(variant2);
            this.d_w0t.init(wind.get(SimParams.Wind.W0T));
            this.d_forceX.init(wind.get(SimParams.Wind.FORCEX));
            this.d_forceY.init(wind.get(SimParams.Wind.FORCEY));
            this.d_forceZ.init(wind.get(SimParams.Wind.FORCEZ));
        }

        public void save(SimParams.Wind wind) {
            SimParams.Wind wind2 = wind;
            wind = new SimParams.Wind();
            this.d_windProfile.getSelectedItem().save(wind);
            if (this.d_speedDirTRB.isSelected()) {
                wind.set(SimParams.Wind.SPEED_RAMP, this.d_speedRamp.getValue());
                wind.set(SimParams.Wind.DIRECTION_RAMP, this.d_dirRamp.getValue());
                wind.set(SimParams.Wind.U0T, SimParams.Wind.U0T.defVal);
                wind.set(SimParams.Wind.V0T, SimParams.Wind.V0T.defVal);
            } else {
                wind.set(SimParams.Wind.SPEED_RAMP, SimParams.Wind.SPEED_RAMP.defVal);
                wind.set(SimParams.Wind.DIRECTION_RAMP, SimParams.Wind.DIRECTION_RAMP.defVal);
                wind.set(SimParams.Wind.U0T, this.d_u0t.getValue());
                wind.set(SimParams.Wind.V0T, this.d_v0t.getValue());
            }
            wind.set(SimParams.Wind.W0T, this.d_w0t.getValue());
            wind.set(SimParams.Wind.FORCEX, this.d_forceX.getValue());
            wind.set(SimParams.Wind.FORCEY, this.d_forceY.getValue());
            wind.set(SimParams.Wind.FORCEZ, this.d_forceZ.getValue());
            wind2.copyVals(wind);
        }
    }

    private static class CustomWindProfile
    extends guiPanel
    implements IWindProfile {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<LandscapeClass> d_landscape;
        private final ValueField<UnitDouble> d_z0;
        private final ValueField<UnitDouble> d_zref;
        private final ValueField<UnitDouble> d_groundLevel = ValueFields.udFld(UnitSystem.getSource(0));
        private final ValueField<UnitDouble> d_lapseRate = ValueFields.udFld(UnitSystem.getSource(5));
        private final VariantEditor d_tmp0zRamp = new VariantEditor(Intl.intl("Z Temperature Profile"), Intl.intl("Ratio of Ambient Temperature"), SimParams.Wind.TMP0_Z_RAMP_PROFILE);
        private final guiRadioButton d_initSpeedUStar = new guiRadioButton("<html>" + Intl.intl("Friction Velocity (u*):"));
        private final guiRadioButton d_initSpeedConstant = new guiRadioButton(Intl.intl("Speed:"));
        private final guiRadioButton d_initSpeedComps = new guiRadioButton(Intl.intl("UV Components"));
        private final ValueField<UnitDouble> d_uStar;
        private final ValueField<UnitDouble> d_directionUStar;
        private final ValueField<UnitDouble> d_speed;
        private final ValueField<UnitDouble> d_directionSpeed;
        private final ValueField<UnitDouble> d_u0;
        private final ValueField<UnitDouble> d_v0;
        private final ValueField<UnitDouble> d_w0;
        private final VariantEditor d_u0z;
        private final VariantEditor d_v0z;
        private final VariantEditor d_w0z;

        public CustomWindProfile() {
            guiUtil.group(new AbstractButton[]{this.d_initSpeedUStar, this.d_initSpeedConstant, this.d_initSpeedComps});
            this.d_initSpeedConstant.setSelected(true);
            this.d_landscape = guiUtil.newCombo(landscapeClass -> new Pair<String, String>(landscapeClass.classDesc, landscapeClass.landscape), LandscapeClass.values());
            this.d_z0 = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            this.d_uStar = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(8), UnitSystem.getSource(8));
            String string3 = Intl.intl("Speed Fraction");
            this.d_speed = ValueFields.udFld(0.0, SIUS.getInstance().getVelocityUnit());
            this.d_directionSpeed = ValueFields.udFld(0.0, NonSI.DEGREE_ANGLE, UnitSystem.getSource(29));
            this.d_directionUStar = ValueFields.udFld(0.0, NonSI.DEGREE_ANGLE, UnitSystem.getSource(29));
            this.d_u0 = ValueFields.udFld(0.0, SIUS.unit(8));
            this.d_v0 = ValueFields.udFld(0.0, SIUS.unit(8));
            this.d_w0 = ValueFields.udFld(0.0, SIUS.unit(8));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Z Velocity:"));
            this.d_u0z = new VariantEditor(Intl.intl("X Velocity"), string3, SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_v0z = new VariantEditor(Intl.intl("Y Velocity"), string3, SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_w0z = new VariantEditor(Intl.intl("Z Velocity"), string3, SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_zref = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            Supplier<guiLabel> supplier = () -> {
                guiLabel guiLabel2 = new guiLabel(Intl.intl("Direction:"));
                guiLabel2.setToolTipText("<html>" + Intl.intl("Specifies the speed direction.<br>0&deg; indicates a northerly wind (blows toward the south)<br>90&deg; indicates an easterly wind (blows toward the west)"));
                return guiLabel2;
            };
            BiFunction<String, String, guiLabel> biFunction = (string, string2) -> {
                guiLabel guiLabel2 = new guiLabel((String)string);
                guiLabel2.setToolTipText((String)string2);
                return guiLabel2;
            };
            guiLabel guiLabel3 = biFunction.apply("<html>" + Intl.intl("z<sub>0</sub> ="), Intl.intl("Aerodynamic Roughness Length"));
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addTitle(Intl.intl("Initial Wind Velocity"));
            gridBagHelper.indent();
            gridBagHelper.addRow(this.d_initSpeedConstant, this.d_speed, 1.0);
            gridBagHelper.indent();
            String string4 = "SPEED_GROUP";
            gridBagHelper.beginGroup(string4);
            gridBagHelper.addRow(supplier.get(), this.d_directionSpeed, 1.0);
            gridBagHelper.endGroup();
            gridBagHelper.unindent();
            gridBagHelper.addRow(this.d_initSpeedUStar, this.d_uStar, 1.0);
            gridBagHelper.indent();
            String string5 = "USTAR_GROUP";
            gridBagHelper.beginGroup(string5);
            gridBagHelper.addRow(supplier.get(), this.d_directionUStar, 1.0);
            gridBagHelper.addRow(Intl.intl("Landscape:"), this.d_landscape, guiLabel3, this.d_z0, 1.0);
            gridBagHelper.addRow("<html>" + Intl.intl("Reference Height (z<sub>ref</sub>):"), this.d_zref, 1.0);
            gridBagHelper.endGroup();
            gridBagHelper.unindent();
            gridBagHelper.addRow(this.d_initSpeedComps, 0);
            gridBagHelper.indent();
            String string6 = "VCOMPS";
            gridBagHelper.beginGroup(string6);
            gridBagHelper.addRow(Intl.intl("X Velocity:"), this.d_u0, 1.0);
            gridBagHelper.addRow(Intl.intl("Y Velocity:"), this.d_v0, 1.0);
            gridBagHelper.endGroup();
            gridBagHelper.unindent();
            gridBagHelper.addRow(guiLabel2, this.d_w0, 1.0);
            gridBagHelper.unindent();
            gridBagHelper.addTitle(Intl.intl("Speed Profile"));
            gridBagHelper.indent();
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_u0z);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_v0z);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_w0z);
            gridBagHelper.unindent();
            gridBagHelper.addTitle(Intl.intl("Temperature Profile"));
            gridBagHelper.indent();
            gridBagHelper.addRow(Intl.intl("Ground Level:"), this.d_groundLevel, 1.0);
            gridBagHelper.addRow(Intl.intl("Lapse Rate:"), this.d_lapseRate, 1.0);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_tmp0zRamp);
            gridBagHelper.unindent();
            gridBagHelper.finalizeRows();
            Runnable runnable = () -> {
                this.d_uStar.setEnabled(this.d_initSpeedUStar.isSelected());
                this.getGroup(string5).setEnabled(this.d_initSpeedUStar.isSelected());
                this.d_z0.setEnabled(this.d_initSpeedUStar.isSelected() && this.d_landscape.getSelectedItem() == LandscapeClass.CUSTOM);
            };
            this.d_landscape.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                if (this.d_landscape.getSelectedItem() != LandscapeClass.CUSTOM) {
                    this.d_z0.setValue(this.d_landscape.getSelectedItem().value);
                }
                runnable.run();
            });
            guiUtil.link((AbstractButton)this.d_initSpeedConstant, this.d_speed);
            guiUtil.link((AbstractButton)this.d_initSpeedComps, this.getGroup(string6));
            guiUtil.link((AbstractButton)this.d_initSpeedConstant, this.getGroup(string4));
            this.d_initSpeedUStar.addItemListener(itemEvent -> runnable.run());
            this.load(new SimParams.Wind());
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public String getName() {
            return Intl.intl("Custom");
        }

        @Override
        public void load(SimParams.Wind wind) {
            if (wind.get(SimParams.Wind.USTAR) != null) {
                this.d_initSpeedUStar.setSelected(true);
            } else {
                switch (wind.get(SimParams.Wind.INITSPEEDOPT)) {
                    case SPEED: {
                        this.d_initSpeedConstant.setSelected(true);
                        break;
                    }
                    case UV: {
                        this.d_initSpeedComps.setSelected(true);
                    }
                }
            }
            LandscapeClass landscapeClass = LandscapeClass.CUSTOM;
            for (LandscapeClass landscapeClass2 : LandscapeClass.values()) {
                if (landscapeClass2 == LandscapeClass.CUSTOM || !landscapeClass2.value.epsilonEquals(wind.get(SimParams.Wind.Z0), 1.0E-9)) continue;
                landscapeClass = landscapeClass2;
                break;
            }
            this.d_landscape.setSelectedItem((Object)landscapeClass);
            this.d_z0.setValue(wind.get(SimParams.Wind.Z0));
            UnitDouble unitDouble = wind.get(SimParams.Wind.USTAR);
            this.d_initSpeedUStar.setSelected(unitDouble != null);
            if (unitDouble != null) {
                this.d_uStar.setValue(unitDouble);
            }
            this.d_directionSpeed.setValue(wind.get(SimParams.Wind.DIRECTION));
            this.d_directionUStar.setValue(wind.get(SimParams.Wind.DIRECTION));
            this.d_groundLevel.setValue(wind.get(SimParams.Wind.GROUND_LEVEL));
            this.d_lapseRate.setValue(wind.get(SimParams.Wind.LAPSE_RATE));
            this.d_tmp0zRamp.init(wind.get(SimParams.Wind.TMP0Z_RAMP));
            this.d_speed.setValue(wind.get(SimParams.Wind.SPEED));
            this.d_u0.setValue(wind.get(SimParams.Wind.U0));
            this.d_v0.setValue(wind.get(SimParams.Wind.V0));
            this.d_w0.setValue(wind.get(SimParams.Wind.W0));
            this.d_u0z.init(wind.get(SimParams.Wind.U0Z));
            this.d_v0z.init(wind.get(SimParams.Wind.V0Z));
            this.d_w0z.init(wind.get(SimParams.Wind.W0Z));
            this.d_zref.setValue(wind.get(SimParams.Wind.ZREF));
        }

        @Override
        public void save(SimParams.Wind wind) {
            wind.set(SimParams.Wind.L, new UnitDouble(0.0, SI.METER));
            wind.set(SimParams.Wind.GROUND_LEVEL, this.d_groundLevel.getValue());
            wind.set(SimParams.Wind.LAPSE_RATE, this.d_lapseRate.getValue());
            wind.set(SimParams.Wind.TMP0Z_RAMP, this.d_tmp0zRamp.getValue());
            if (this.d_initSpeedConstant.isSelected()) {
                wind.set(SimParams.Wind.INITSPEEDOPT, SimParams.Wind.InitSpeedOptions.SPEED);
                wind.set(SimParams.Wind.SPEED, this.d_speed.getValue());
                wind.set(SimParams.Wind.DIRECTION, this.d_directionSpeed.getValue());
            } else if (this.d_initSpeedUStar.isSelected()) {
                wind.set(SimParams.Wind.USTAR, this.d_uStar.getValue());
                wind.set(SimParams.Wind.Z0, this.d_z0.getValue());
                wind.set(SimParams.Wind.DIRECTION, this.d_directionUStar.getValue());
                wind.set(SimParams.Wind.ZREF, this.d_zref.getValue());
            } else if (this.d_initSpeedComps.isSelected()) {
                wind.set(SimParams.Wind.INITSPEEDOPT, SimParams.Wind.InitSpeedOptions.UV);
                wind.set(SimParams.Wind.U0, this.d_u0.getValue());
                wind.set(SimParams.Wind.V0, this.d_v0.getValue());
            }
            wind.set(SimParams.Wind.W0, this.d_w0.getValue());
            wind.set(SimParams.Wind.U0Z, this.d_u0z.getValue());
            wind.set(SimParams.Wind.V0Z, this.d_v0z.getValue());
            wind.set(SimParams.Wind.W0Z, this.d_w0z.getValue());
        }
    }

    private static class SimilarityWindProfile
    extends guiPanel
    implements IWindProfile {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<Stability> d_stability;
        private final guiComboBox<LandscapeClass> d_landscape;
        private final ValueField<UnitDouble> d_l;
        private final ValueField<UnitDouble> d_z0;
        private final ValueField<UnitDouble> d_zref;
        private final ValueField<UnitDouble> d_uStar;
        private final guiCheckBox d_thetaStarCB;
        private final ValueField<UnitDouble> d_thetaStar;
        private final ValueField<UnitDouble> d_groundLevel = ValueFields.udFld(UnitSystem.getSource(0));
        private final ValueField<UnitDouble> d_lapseRate = ValueFields.udFld(UnitSystem.getSource(5));
        private final guiRadioButton d_uStarRB;
        private final guiRadioButton d_speedRB;
        private final ValueField<UnitDouble> d_speed;
        private final ValueField<UnitDouble> d_direction;
        private final ValueField<UnitDouble> d_w0;
        private final VariantEditor d_w0z;

        public SimilarityWindProfile() {
            this.d_stability = guiUtil.newCombo(stability -> new Pair<String, String>(stability.desc, stability.getTooltip()), Stability.values());
            this.d_landscape = guiUtil.newCombo(landscapeClass -> new Pair<String, String>(landscapeClass.classDesc, landscapeClass.landscape), LandscapeClass.values());
            this.d_l = ValueFields.udFld(new UnitDouble(0.0, SI.METER), new NotZero("L", SI.METER), UnitSystem.getSource(0));
            this.d_z0 = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            this.d_thetaStarCB = new guiCheckBox("<html>" + Intl.intl("Scaling Potential Temperature (&Theta;*):"));
            this.d_thetaStar = ValueFields.udFld(new UnitDouble(0.0, SI.KELVIN), new NotZero("&Theta;*", SI.KELVIN), UnitSystem.getSource(93));
            LinkStatus.link((AbstractButton)this.d_thetaStarCB, this.d_thetaStar);
            this.d_uStarRB = new guiRadioButton("<html>" + Intl.intl("Friction Velocity (u*):"));
            this.d_uStar = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(8), UnitSystem.getSource(8));
            this.d_speedRB = new guiRadioButton(Intl.intl("Speed:"));
            this.d_speed = ValueFields.udFld(DoubleVR.above(0.0, false), SIUS.unit(8), UnitSystem.getSource(8));
            this.d_direction = ValueFields.udFld(0.0, NonSI.DEGREE_ANGLE, UnitSystem.getSource(29));
            this.d_w0 = ValueFields.udFld(0.0, SIUS.unit(8));
            this.d_w0z = new VariantEditor(Intl.intl("Z Speed Change with Elevation"), Intl.intl("Speed Fraction"), SimParams.Wind.SPEED_Z_RAMP_PROFILE);
            this.d_zref = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.METER, UnitSystem.getSource(0));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Direction:"));
            guiLabel2.setToolTipText("<html>" + Intl.intl("Specifies the speed direction.<br>0&deg; indicates a northerly wind (blows toward the south)<br>90&deg; indicates an easterly wind (blows toward the west)"));
            BiFunction<String, String, guiLabel> biFunction = (string, string2) -> {
                guiLabel guiLabel2 = new guiLabel((String)string);
                guiLabel2.setToolTipText((String)string2);
                return guiLabel2;
            };
            guiLabel guiLabel3 = biFunction.apply(Intl.intl("L ="), Intl.intl("Obukhov Length"));
            guiLabel guiLabel4 = biFunction.apply("<html>" + Intl.intl("z<sub>0</sub> ="), Intl.intl("Aerodynamic Roughness Length"));
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addSeparator();
            gridBagHelper.addRow(Intl.intl("Thermal Stability:"), this.d_stability, guiLabel3, this.d_l, 1.0);
            gridBagHelper.addRow(Intl.intl("Landscape"), this.d_landscape, guiLabel4, this.d_z0, 1.0);
            gridBagHelper.addRow("<html>" + Intl.intl("Reference Height (z<sub>ref</sub>):"), this.d_zref, 1.0);
            gridBagHelper.addRow(this.d_thetaStarCB, this.d_thetaStar, 1.0);
            gridBagHelper.addTitle(Intl.intl("Initial Horizontal Velocity"));
            gridBagHelper.indent();
            gridBagHelper.addRow(this.d_speedRB, this.d_speed, 1.0);
            gridBagHelper.addRow(this.d_uStarRB, this.d_uStar, 1.0);
            gridBagHelper.addRow(guiLabel2, this.d_direction, 1.0);
            gridBagHelper.unindent();
            gridBagHelper.addRow(Intl.intl("Initial Z Velocity:"), this.d_w0, 1.0);
            SimulationPropertiesDlg.addVariantToPanel(gridBagHelper, this.d_w0z);
            gridBagHelper.addTitle(Intl.intl("Temperature Profile"));
            gridBagHelper.indent();
            gridBagHelper.addRow(Intl.intl("Ground Level:"), this.d_groundLevel, 1.0);
            gridBagHelper.addRow(Intl.intl("Lapse Rate:"), this.d_lapseRate, 1.0);
            gridBagHelper.unindent();
            gridBagHelper.finalizeRows();
            Runnable runnable = () -> {
                this.d_l.setEnabled(this.d_stability.getSelectedItem() == Stability.CUSTOM);
                this.d_z0.setEnabled(this.d_landscape.getSelectedItem() == LandscapeClass.CUSTOM);
            };
            this.d_stability.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                if (this.d_stability.getSelectedItem() != Stability.CUSTOM) {
                    this.d_l.setValue(this.d_stability.getSelectedItem().value);
                }
                runnable.run();
            });
            this.d_landscape.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                if (this.d_landscape.getSelectedItem() != LandscapeClass.CUSTOM) {
                    this.d_z0.setValue(this.d_landscape.getSelectedItem().value);
                }
                runnable.run();
            });
            guiUtil.group(new AbstractButton[]{this.d_uStarRB, this.d_speedRB});
            guiUtil.link((AbstractButton)this.d_uStarRB, this.d_uStar);
            guiUtil.link((AbstractButton)this.d_speedRB, this.d_speed);
            this.load(new SimParams.Wind());
        }

        @Override
        public String getName() {
            return Intl.intl("Monin-Obukhov Similarity");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void load(SimParams.Wind wind) {
            UnitDouble unitDouble;
            void var4_7;
            UnitDouble unitDouble2 = wind.get(SimParams.Wind.L);
            if (unitDouble2.epsilonEquals(new UnitDouble(0.0, SI.METER), 1.0E-10)) {
                unitDouble2 = Stability.STABLE.value;
            }
            Stability stability = Stability.CUSTOM;
            for (Stability stability2 : Stability.values()) {
                if (stability2 == Stability.CUSTOM || !stability2.value.epsilonEquals(unitDouble2, 1.0E-6)) continue;
                stability = stability2;
                break;
            }
            this.d_stability.setSelectedItem((Object)stability);
            this.d_l.setValue(unitDouble2);
            LandscapeClass landscapeClass = LandscapeClass.CUSTOM;
            for (LandscapeClass landscapeClass2 : LandscapeClass.values()) {
                if (landscapeClass2 == LandscapeClass.CUSTOM || !landscapeClass2.value.epsilonEquals(wind.get(SimParams.Wind.Z0), 1.0E-9)) continue;
                LandscapeClass landscapeClass3 = landscapeClass2;
                break;
            }
            this.d_landscape.setSelectedItem(var4_7);
            this.d_z0.setValue(wind.get(SimParams.Wind.Z0));
            UnitDouble unitDouble3 = wind.get(SimParams.Wind.USTAR);
            this.d_uStarRB.setSelected(unitDouble3 != null);
            if (unitDouble3 != null) {
                this.d_uStar.setValue(unitDouble3);
            }
            this.d_thetaStarCB.setSelected((unitDouble = wind.get(SimParams.Wind.THETASTAR)) != null);
            if (unitDouble != null) {
                this.d_thetaStar.setValue(unitDouble);
            }
            this.d_uStarRB.setSelected(wind.get(SimParams.Wind.USTAR) != null);
            this.d_speedRB.setSelected(wind.get(SimParams.Wind.USTAR) == null);
            this.d_groundLevel.setValue(wind.get(SimParams.Wind.GROUND_LEVEL));
            this.d_lapseRate.setValue(wind.get(SimParams.Wind.LAPSE_RATE));
            this.d_speed.setValue(wind.get(SimParams.Wind.SPEED));
            this.d_direction.setValue(wind.get(SimParams.Wind.DIRECTION));
            this.d_w0.setValue(wind.get(SimParams.Wind.W0));
            this.d_w0z.init(wind.get(SimParams.Wind.W0Z));
            this.d_zref.setValue(wind.get(SimParams.Wind.ZREF));
        }

        @Override
        public void save(SimParams.Wind wind) {
            wind.set(SimParams.Wind.L, this.d_l.getValue());
            wind.set(SimParams.Wind.Z0, this.d_z0.getValue());
            wind.set(SimParams.Wind.USTAR, this.d_uStarRB.isSelected() ? (UnitDouble)this.d_uStar.getValue() : null);
            wind.set(SimParams.Wind.THETASTAR, this.d_thetaStarCB.isSelected() ? (UnitDouble)this.d_thetaStar.getValue() : null);
            wind.set(SimParams.Wind.GROUND_LEVEL, this.d_groundLevel.getValue());
            wind.set(SimParams.Wind.LAPSE_RATE, this.d_lapseRate.getValue());
            if (this.d_speedRB.isSelected()) {
                wind.set(SimParams.Wind.SPEED, this.d_speed.getValue());
            }
            wind.set(SimParams.Wind.DIRECTION, this.d_direction.getValue());
            wind.set(SimParams.Wind.W0, this.d_w0.getValue());
            wind.set(SimParams.Wind.W0Z, this.d_w0z.getValue());
            wind.set(SimParams.Wind.ZREF, this.d_zref.getValue());
        }

        private static class NotZero
        implements Predicate<UnitDouble> {
            public final String x;
            public final Unit zeroUnit;

            public NotZero(String string, Unit unit) {
                this.x = string;
                this.zeroUnit = unit;
            }

            @Override
            public boolean test(UnitDouble unitDouble) {
                return !unitDouble.epsilonEquals(new UnitDouble(0.0, this.zeroUnit), 1.0E-10);
            }

            public String toString() {
                return "<html>" + String.format(Intl.intl("%s must not be 0."), this.x);
            }
        }
    }

    private static interface IWindProfile {
        public String getName();

        public guiPanel getPanel();

        public void load(SimParams.Wind var1);

        public void save(SimParams.Wind var1);
    }

    private static enum LandscapeClass {
        SEA(2.0E-4, Intl.intl("Sea"), Intl.intl("Sea, paved areas, snow-covered flat plain, tidal flats, smooth desert")),
        SMOOTH(0.005, Intl.intl("Smooth"), Intl.intl("Beaches, pack ice, snow-covered fields")),
        OPEN(0.03, Intl.intl("Open"), Intl.intl("Grass prairie, farm fields, tundra, airports, heather")),
        ROUGHLY_OPEN(0.1, Intl.intl("Roughly Open"), Intl.intl("Low crops and occasional obstacles (single bushes)")),
        ROUGH(0.25, Intl.intl("Rough"), Intl.intl("High crops, scattered obstacles such as trees or hedgerows, vineyards")),
        VERY_ROUGH(0.5, Intl.intl("Very Rough"), Intl.intl("Mixed farm fields and forest clumps, orchards, scattered buildings")),
        CLOSED(1.0, Intl.intl("Closed"), Intl.intl("Suburbs, villages, forests")),
        CHAOTIC(2.0, Intl.intl("Chaotic"), Intl.intl("Large towns and cities, irregular forests")),
        CUSTOM(null, Intl.intl("<custom>"), null);

        public final String classDesc;
        public final String landscape;
        public final UnitDouble value;

        private LandscapeClass(double d, String string2, String string3) {
            this(new UnitDouble(d, SI.METER), string2, string3);
        }

        private LandscapeClass(UnitDouble unitDouble, String string2, String string3) {
            this.value = unitDouble;
            this.classDesc = string2;
            this.landscape = string3;
        }
    }

    private static enum Stability {
        VERY_UNSTABLE(Intl.intl("Very Unstable"), DoubleVR.between(-200.0, 0.0, true, false), -100.0),
        UNSTABLE(Intl.intl("Unstable"), DoubleVR.between(-500.0, -200.0, true, false), -350.0),
        NEUTRAL(Intl.intl("Neutral"), DoubleVR.above(500.0, false), 1000000.0),
        STABLE(Intl.intl("Stable"), DoubleVR.between(200.0, 500.0, false, true), 350.0),
        VERY_STABLE(Intl.intl("Very Stable"), DoubleVR.between(0.0, 200.0, false, true), 100.0),
        CUSTOM(Intl.intl("<custom>"), null, null);

        public final String desc;
        public final UnitDoubleVR range;
        public final UnitDouble value;

        private Stability(String string2, DoubleVR doubleVR, double d) {
            this(string2, UnitDoubleVR.from(doubleVR, SI.METER), new UnitDouble(d, SI.METER));
        }

        private Stability(String string2, UnitDoubleVR unitDoubleVR, UnitDouble unitDouble) {
            this.desc = string2;
            this.range = unitDoubleVR;
            this.value = unitDouble;
        }

        public String getTooltip() {
            return null;
        }
    }

    private static class AngledGeomPanel
    extends guiPanel {
        private static final long serialVersionUID = -1528674367031251720L;
        private final guiCheckBox d_immersedBoundaryCB = new guiCheckBox(Intl.intl("Use the Immersed Boundary Method (does not require conversion to blocks)"));
        private final RastOptionsPnl d_rastOptions = new RastOptionsPnl(29);

        public AngledGeomPanel() {
            LinkStatus.link((AbstractButton)this.d_immersedBoundaryCB, true, this.d_rastOptions);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            if (PyroSim.FDS7) {
                gridBagHelper.addRow(this.d_immersedBoundaryCB);
                gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Block Conversion")));
                gridBagHelper.addIdentRow(this.d_rastOptions, new double[]{1.0, 1.0});
            } else {
                gridBagHelper.addRow(this.d_rastOptions, new double[]{1.0, 1.0});
            }
            gridBagHelper.finalizeRows();
        }

        public void load(RasterizationOptions rasterizationOptions) {
            this.d_rastOptions.load(rasterizationOptions);
            this.d_immersedBoundaryCB.setSelected(rasterizationOptions.immersedBoundary);
        }

        public RasterizationOptions save() {
            RasterizationOptions rasterizationOptions = this.d_rastOptions.save();
            return rasterizationOptions.setImmersedBoundary(this.d_immersedBoundaryCB.isSelected());
        }
    }

    public class CheckedListener<T>
    implements ActionListener {
        private ValueField<T> d_field;

        public CheckedListener(ValueField<T> valueField) {
            this.d_field = valueField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.d_field.requestFocusInWindow();
        }
    }

    private class MiscPanel
    extends guiPanel {
        private static final long serialVersionUID = 6305527014838058481L;
        private final PyroMod d_pyroMod;
        private final guiCheckBox d_cbTexOrigin;
        private final guiComboBox<Surface> d_surfCombo;
        private final guiComboBox<SimParams.Misc.SUPPRESSION> d_suppressionCombo;
        private final ValueField<UnitDouble> d_dfTexOriginX;
        private final ValueField<UnitDouble> d_dfTexOriginY;
        private final ValueField<UnitDouble> d_dfTexOriginZ;
        private final CustomFDSPanel d_customPnl;

        public MiscPanel(PyroMod pyroMod) {
            Serializable serializable2;
            this.d_pyroMod = pyroMod;
            SimParams.Misc misc = this.d_pyroMod.getSimParams().getMisc();
            this.d_cbTexOrigin = new guiCheckBox(Intl.intl("Specify Texture Origin"));
            ArrayList<Surface> arrayList = new ArrayList<Surface>();
            for (Serializable serializable2 : this.d_pyroMod.getSurfaceMgr().flatten()) {
                if (((Surface)serializable2).isPredefined() && !((Surface)serializable2).equals(this.d_pyroMod.getSurfaceMgr().get(PredefSurf.INERT.name())) && !((Surface)serializable2).equals(this.d_pyroMod.getSurfaceMgr().get(PredefSurf.ADIABATIC.name()))) continue;
                arrayList.add((Surface)serializable2);
            }
            SurfaceComboBox surfaceComboBox = new SurfaceComboBox(this.d_pyroMod.getSurfaceMgr(), misc.getSurfDefault());
            this.d_surfCombo = new guiComboBox(arrayList);
            this.d_surfCombo.setRenderer(surfaceComboBox.getRenderer());
            this.d_suppressionCombo = new guiComboBox();
            this.d_suppressionCombo.addItem((SimParams.Misc.SUPPRESSION)SimParams.Misc.SUPPRESSION.AUTO);
            this.d_suppressionCombo.addItem((SimParams.Misc.SUPPRESSION)SimParams.Misc.SUPPRESSION.TRUE);
            this.d_suppressionCombo.addItem((SimParams.Misc.SUPPRESSION)SimParams.Misc.SUPPRESSION.FALSE);
            this.d_suppressionCombo.setRenderer(this.getSuppressionRenderer());
            serializable2 = new JTextField(6);
            IUnitSrc iUnitSrc = UnitSystem.getSource(0);
            this.d_dfTexOriginX = ValueFields.udFld(misc.getTextureOrigin().xu(), iUnitSrc);
            this.d_dfTexOriginY = ValueFields.udFld(misc.getTextureOrigin().yu(), iUnitSrc);
            this.d_dfTexOriginZ = ValueFields.udFld(misc.getTextureOrigin().zu(), iUnitSrc);
            this.d_dfTexOriginX.setPreferredSize(((JTextField)serializable2).getPreferredSize());
            this.d_dfTexOriginY.setPreferredSize(((JTextField)serializable2).getPreferredSize());
            this.d_dfTexOriginZ.setPreferredSize(((JTextField)serializable2).getPreferredSize());
            this.d_cbTexOrigin.addActionListener(new CheckedListener<UnitDouble>(this.d_dfTexOriginX));
            this.d_customPnl = new CustomFDSPanel(2);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("X dir") + ":");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Y dir") + ":");
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Z dir") + ":");
            LinkStatus.link((AbstractButton)this.d_cbTexOrigin, guiLabel2, guiLabel3, guiLabel4, this.d_dfTexOriginX, this.d_dfTexOriginY, this.d_dfTexOriginZ);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(Intl.intl("Default Surface Type:"), this.d_surfCombo, 0);
            gridBagHelper.addRow(Intl.intl("Reaction Suppression:"), this.d_suppressionCombo, 0);
            gridBagHelper.addRow(this.d_cbTexOrigin, 0);
            gridBagHelper.indent();
            gridBagHelper.addRow(guiLabel2, this.d_dfTexOriginX);
            gridBagHelper.addRow(guiLabel3, this.d_dfTexOriginY);
            gridBagHelper.addRow(guiLabel4, this.d_dfTexOriginZ);
            gridBagHelper.unindent();
            gridBagHelper.addRow(this.d_customPnl, new double[]{1.0, 1.0}, new int[]{0, 0});
            gridBagHelper.finalizeRows();
        }

        private ListCellRenderer getSuppressionRenderer() {
            return new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof SimParams.Misc.SUPPRESSION) {
                        this.setText(((SimParams.Misc.SUPPRESSION)((Object)object)).dispName);
                    }
                    return this;
                }
            };
        }

        public void saveData(SimParams simParams, SimParams.Misc misc) {
            SimParams.Misc misc2 = new SimParams(this.d_pyroMod.getSurfaceMgr()).getMisc();
            Surface surface = this.d_surfCombo.getSelectedItem();
            if (surface != null && !surface.equals(misc2.getSurfDefault())) {
                misc.setSurfDefault(this.d_surfCombo.getSelectedItem());
            } else {
                misc.setSurfDefault(misc2.getSurfDefault());
            }
            SimParams.Misc.SUPPRESSION sUPPRESSION = this.d_suppressionCombo.getSelectedItem();
            if (sUPPRESSION != null && !sUPPRESSION.equals((Object)misc2.getSuppression())) {
                misc.setSuppression(this.d_suppressionCombo.getSelectedItem());
            } else {
                misc.setSuppression(misc2.getSuppression());
            }
            UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)this.d_dfTexOriginX.getValue(), (UnitDouble)this.d_dfTexOriginY.getValue(), (UnitDouble)this.d_dfTexOriginZ.getValue());
            if (this.d_cbTexOrigin.isSelected() && !unitPoint3D.equals(misc2.getTextureOrigin())) {
                misc.setTextureOrigin(unitPoint3D);
            } else {
                misc.setTextureOrigin(misc2.getTextureOrigin());
            }
            this.d_customPnl.save(Collections.singleton(simParams));
        }

        public void loadData() {
            UnitPoint3D unitPoint3D;
            SimParams.Misc misc = new SimParams(this.d_pyroMod.getSurfaceMgr()).getMisc();
            SimParams.Misc misc2 = this.d_pyroMod.getSimParams().getMisc();
            Surface surface = misc2.getSurfDefault();
            if (surface != null) {
                this.d_surfCombo.setSelectedItem(surface);
            } else {
                this.d_surfCombo.setSelectedItem(this.d_pyroMod.getDefaultSurface());
            }
            SimParams.Misc.SUPPRESSION sUPPRESSION = misc2.getSuppression();
            if (!sUPPRESSION.equals((Object)misc.getSuppression())) {
                this.d_suppressionCombo.setSelectedItem((Object)sUPPRESSION);
            }
            if ((unitPoint3D = misc2.getTextureOrigin()) != null && !unitPoint3D.equals(misc.getTextureOrigin())) {
                this.d_cbTexOrigin.setSelected(true);
                this.d_dfTexOriginX.setValue(unitPoint3D.xu());
                this.d_dfTexOriginY.setValue(unitPoint3D.yu());
                this.d_dfTexOriginZ.setValue(unitPoint3D.zu());
            } else {
                this.d_cbTexOrigin.setSelected(false);
            }
            this.d_customPnl.load(Collections.singleton(this.d_pyroMod.getSimParams()));
        }

        public guiPanel getPanel() {
            return SimulationPropertiesDlg.this.d_miscPanel;
        }

        public void setDefaults() {
        }
    }

    private class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 3432198331510818638L;
        private final guiCheckBox d_cbBoundaryFile;
        private final guiCheckBox d_cbDeviceFiles;
        private final guiCheckBox d_cbHeatReleaseRateFiles;
        private final guiCheckBox d_cbIsofFiles;
        private final guiCheckBox d_cbParticleFiles;
        private final guiCheckBox d_cbProfileDumpInterval;
        private final guiCheckBox d_cbRestartFile;
        private final guiCheckBox d_cbSliceFiles;
        private final guiCheckBox d_cbSlice3dFiles;
        private final guiCheckBox d_cbMassFiles;
        private final guiCheckBox d_cbSmokeView;
        private final guiCheckBox d_cbSpeciesMassFile;
        private final guiCheckBox d_cbColDumpLimit;
        private final guiCheckBox d_cbSuppressDiagnostics;
        private final guiCheckBox d_cbNumFrames;
        private final ValueField<UnitDouble> d_dfBoundaryFile;
        private final ValueField<UnitDouble> d_dfDeviceFiles;
        private final ValueField<UnitDouble> d_dfHeatReleaseRateFiles;
        private final ValueField<UnitDouble> d_dfIsofFiles;
        private final ValueField<UnitDouble> d_dfParticleFiles;
        private final ValueField<UnitDouble> d_dfProfileDumpInterval;
        private final ValueField<UnitDouble> d_dfRestartFile;
        private final ValueField<UnitDouble> d_dfSliceFiles;
        private final ValueField<UnitDouble> d_dfSlice3dFiles;
        private final ValueField<UnitDouble> d_dfMassFiles;
        private final ValueField<Integer> d_ifNumFrames;
        private final guiLabel d_timeLabel1;
        private final guiLabel d_timeLabel2;
        private final TitleSeparator d_fileWriteInterval;
        private final UnitSystem d_system;
        private final Unit d_timeUnit;
        private final PyroMod d_pyroMod;
        private final guiPanel d_outputPanel;
        private final guiPanel d_massPanel;
        private final guiPanel d_plotPanel;
        private final QuantityComboBox d_smokeQuantity;

        public OutputPanel(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
            this.d_system = ((PyroSim)Application.getApp()).getUnitSystem();
            this.d_outputPanel = new guiPanel();
            this.d_massPanel = new guiPanel();
            this.d_plotPanel = new guiPanel();
            this.d_timeUnit = this.d_system.getTimeUnit();
            this.d_timeLabel1 = new guiLabel(this.d_timeUnit + "");
            this.d_timeLabel2 = new guiLabel(this.d_timeUnit + "");
            this.d_cbSmokeView = new guiCheckBox(Intl.intl("Enable 3D Smoke Visualization"));
            this.d_cbColDumpLimit = new guiCheckBox(Intl.intl("Limit Text Output to 255 Columns"));
            this.d_cbSuppressDiagnostics = new guiCheckBox(Intl.intl("Suppress Diagnostics"));
            this.d_cbNumFrames = new guiCheckBox(Intl.intl("Number of Output Data Frames") + ":");
            this.d_cbSpeciesMassFile = new guiCheckBox(Intl.intl("Write Gas Species Mass File"));
            this.d_fileWriteInterval = new TitleSeparator(Intl.intl("Output File Write Intervals"));
            this.d_cbBoundaryFile = new guiCheckBox(Intl.intl("Boundary") + ":");
            this.d_cbDeviceFiles = new guiCheckBox(Intl.intl("Device") + ":");
            this.d_cbHeatReleaseRateFiles = new guiCheckBox(Intl.intl("Heat Release Rate") + ":");
            this.d_cbIsofFiles = new guiCheckBox(Intl.intl("Isosurface") + ":");
            this.d_cbParticleFiles = new guiCheckBox(Intl.intl("Particles") + ":");
            this.d_cbProfileDumpInterval = new guiCheckBox(Intl.intl("Profile") + ":");
            this.d_cbRestartFile = new guiCheckBox(Intl.intl("Restart") + ":");
            this.d_cbSliceFiles = new guiCheckBox(Intl.intl("2D Slice") + ":");
            this.d_cbSlice3dFiles = new guiCheckBox(Intl.intl("3D Slice") + ":");
            this.d_cbMassFiles = new guiCheckBox(Intl.intl("Specify Write Interval") + ":");
            SimParams.FileOutput fileOutput = this.d_pyroMod.getSimParams().getFileOutput();
            this.d_ifNumFrames = ValueFields.intFld(fileOutput.getNumOutputFrames(), SimParams.FileOutput.NUM_FRAMES_RANGE);
            this.d_dfBoundaryFile = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfDeviceFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfHeatReleaseRateFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfIsofFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfParticleFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfProfileDumpInterval = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfRestartFile = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfSliceFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfSlice3dFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_dfMassFiles = ValueFields.udFld(UnitSystem.getSource(2), SimParams.FileOutput.TIME_RANGE_FILE_OUT);
            this.d_cbSpeciesMassFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    OutputPanel.this.d_cbMassFiles.setEnabled(OutputPanel.this.d_cbSpeciesMassFile.isSelected());
                    OutputPanel.this.d_dfMassFiles.setEnabled(OutputPanel.this.d_cbMassFiles.isSelected() && OutputPanel.this.d_cbSpeciesMassFile.isSelected());
                }
            });
            this.d_cbNumFrames.addActionListener(new CheckedListener<Integer>(this.d_ifNumFrames));
            this.d_cbMassFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfMassFiles));
            this.d_cbBoundaryFile.addActionListener(new CheckedListener<UnitDouble>(this.d_dfBoundaryFile));
            this.d_cbDeviceFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfDeviceFiles));
            this.d_cbHeatReleaseRateFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfHeatReleaseRateFiles));
            this.d_cbIsofFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfIsofFiles));
            this.d_cbParticleFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfParticleFiles));
            this.d_cbProfileDumpInterval.addActionListener(new CheckedListener<UnitDouble>(this.d_dfProfileDumpInterval));
            this.d_cbRestartFile.addActionListener(new CheckedListener<UnitDouble>(this.d_dfRestartFile));
            this.d_cbSliceFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfSliceFiles));
            this.d_cbSlice3dFiles.addActionListener(new CheckedListener<UnitDouble>(this.d_dfSlice3dFiles));
            this.d_smokeQuantity = new QuantityComboBox(Intl.intl("Soot Mass Fraction") + " (" + Intl.intl("Default") + ")", SimParams.FileOutput.getSmokeQuantityFilter());
            this.d_smokeQuantity.setObjectMsrsExpanded(true);
            this.buildOutputPanel();
        }

        private void buildOutputPanel() {
            this.d_outputPanel.setLayout(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Smoke Quantity:"));
            int n = 0;
            GridBagUtil.add(this.d_outputPanel, this.d_cbSmokeView, 0, n++, 1, 1, 12, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, guiLabel2, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_smokeQuantity, 1, n++, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSuppressDiagnostics, 0, n++, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbColDumpLimit, 0, n++, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbNumFrames, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_ifNumFrames, 1, n++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSpeciesMassFile, 0, n++, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbMassFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfMassFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_fileWriteInterval, 0, n++, 3, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbBoundaryFile, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfBoundaryFile, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbDeviceFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfDeviceFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbHeatReleaseRateFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfHeatReleaseRateFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbIsofFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfIsofFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbParticleFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfParticleFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbProfileDumpInterval, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfProfileDumpInterval, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbRestartFile, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfRestartFile, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSliceFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfSliceFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_cbSlice3dFiles, 0, n, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_outputPanel, this.d_dfSlice3dFiles, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_outputPanel);
            LinkStatus.link((AbstractButton)this.d_cbNumFrames, this.d_ifNumFrames);
            LinkStatus.link((AbstractButton)this.d_cbBoundaryFile, this.d_dfBoundaryFile);
            LinkStatus.link((AbstractButton)this.d_cbDeviceFiles, this.d_dfDeviceFiles);
            LinkStatus.link((AbstractButton)this.d_cbHeatReleaseRateFiles, this.d_dfHeatReleaseRateFiles);
            LinkStatus.link((AbstractButton)this.d_cbIsofFiles, this.d_dfIsofFiles);
            LinkStatus.link((AbstractButton)this.d_cbMassFiles, this.d_dfMassFiles);
            LinkStatus.link((AbstractButton)this.d_cbParticleFiles, this.d_dfParticleFiles);
            LinkStatus.link((AbstractButton)this.d_cbProfileDumpInterval, this.d_dfProfileDumpInterval);
            LinkStatus.link((AbstractButton)this.d_cbRestartFile, this.d_dfRestartFile);
            LinkStatus.link((AbstractButton)this.d_cbSliceFiles, this.d_dfSliceFiles);
            LinkStatus.link((AbstractButton)this.d_cbSlice3dFiles, this.d_dfSlice3dFiles);
            LinkStatus.link((AbstractButton)this.d_cbSpeciesMassFile, this.d_cbMassFiles);
            LinkStatus.link((AbstractButton)this.d_cbSmokeView, guiLabel2, this.d_smokeQuantity);
        }

        private void saveData(SimParams.FileOutput fileOutput) {
            SimParams.FileOutput fileOutput2 = new SimParams(this.d_pyroMod.getSurfaceMgr()).getFileOutput();
            fileOutput.setSmokeQuantity((IQuantity)this.d_smokeQuantity.getSelectedItem());
            if (this.d_cbBoundaryFile.isSelected()) {
                fileOutput.setDtBoundaryFile((UnitDouble)this.d_dfBoundaryFile.getValue());
            } else {
                fileOutput.setDtBoundaryFile(fileOutput2.getDtBoundaryFile());
            }
            if (this.d_cbDeviceFiles.isSelected()) {
                fileOutput.setDtDeviceFiles((UnitDouble)this.d_dfDeviceFiles.getValue());
            } else {
                fileOutput.setDtDeviceFiles(fileOutput2.getDtDeviceFiles());
            }
            if (this.d_cbHeatReleaseRateFiles.isSelected()) {
                fileOutput.setDtHeatReleaseRateFiles((UnitDouble)this.d_dfHeatReleaseRateFiles.getValue());
            } else {
                fileOutput.setDtHeatReleaseRateFiles(fileOutput2.getDtHeatReleaseRateFiles());
            }
            if (this.d_cbIsofFiles.isSelected()) {
                fileOutput.setDtIsofFiles((UnitDouble)this.d_dfIsofFiles.getValue());
            } else {
                fileOutput.setDtIsofFiles(fileOutput2.getDtIsofFiles());
            }
            if (this.d_cbParticleFiles.isSelected()) {
                fileOutput.setDtParticleFiles((UnitDouble)this.d_dfParticleFiles.getValue());
            } else {
                fileOutput.setDtParticleFiles(fileOutput2.getDtParticleFiles());
            }
            if (this.d_cbSliceFiles.isSelected()) {
                fileOutput.setDtSliceFiles((UnitDouble)this.d_dfSliceFiles.getValue());
            } else {
                fileOutput.setDtSliceFiles(fileOutput2.getDtSliceFiles());
            }
            if (this.d_cbSlice3dFiles.isSelected()) {
                fileOutput.setDtSlice3dFiles((UnitDouble)this.d_dfSlice3dFiles.getValue());
            } else {
                fileOutput.setDtSlice3dFiles(fileOutput2.getDtSliceFiles());
            }
            if (this.d_cbProfileDumpInterval.isSelected()) {
                fileOutput.setDtProfileDumpInterval((UnitDouble)this.d_dfProfileDumpInterval.getValue());
            } else {
                fileOutput.setDtProfileDumpInterval(fileOutput2.getDtProfileDumpInterval());
            }
            if (this.d_cbRestartFile.isSelected()) {
                fileOutput.setDtRestartFile((UnitDouble)this.d_dfRestartFile.getValue());
            } else {
                fileOutput.setDtRestartFile(null);
            }
            fileOutput.setVisualize3dSmoke(this.d_cbSmokeView.isSelected());
            fileOutput.setSuppressDiagnostics(this.d_cbSuppressDiagnostics.isSelected());
            fileOutput.setLimitCSVColumns(this.d_cbColDumpLimit.isSelected());
            if (this.d_cbNumFrames.isSelected()) {
                fileOutput.setNumOutputFrames((Integer)this.d_ifNumFrames.getValue());
            } else {
                fileOutput.setNumOutputFrames(fileOutput2.getNumOutputFrames());
            }
            fileOutput.setWriteSpeciesMassFile(this.d_cbSpeciesMassFile.isSelected());
            if (this.d_cbSpeciesMassFile.isSelected() && this.d_cbMassFiles.isSelected()) {
                fileOutput.setDtMassFiles((UnitDouble)this.d_dfMassFiles.getValue());
            } else {
                fileOutput.setDtMassFiles(fileOutput2.getDtMassFiles());
            }
        }

        private void loadData() {
            SimParams.FileOutput fileOutput = this.d_pyroMod.getSimParams().getFileOutput();
            SimParams.FileOutput fileOutput2 = new SimParams(this.d_pyroMod.getSurfaceMgr()).getFileOutput();
            this.d_cbSmokeView.setSelected(fileOutput.isVisualize3dSmoke());
            this.d_smokeQuantity.setSelectedItem(fileOutput.getSmokeQuantity());
            this.d_cbSuppressDiagnostics.setSelected(fileOutput.isSuppressDiagnostics());
            this.d_cbColDumpLimit.setSelected(fileOutput.isLimitCSVColumns());
            int n = fileOutput.getNumOutputFrames();
            if (n != fileOutput2.getNumOutputFrames()) {
                this.d_cbNumFrames.setSelected(true);
                this.d_ifNumFrames.setValue(n);
            } else {
                this.d_cbNumFrames.setSelected(false);
            }
            this.d_cbSpeciesMassFile.setSelected(fileOutput.isWriteSpeciesMassFile());
            this.d_cbMassFiles.setEnabled(this.d_cbSpeciesMassFile.isSelected());
            this.d_dfMassFiles.setEnabled(this.d_cbMassFiles.isSelected() && this.d_cbSpeciesMassFile.isSelected());
            UnitDouble unitDouble = fileOutput.getDtBoundaryFile();
            this.d_dfBoundaryFile.setValue(unitDouble);
            if (unitDouble != null && !unitDouble.equals(fileOutput2.getDtBoundaryFile())) {
                this.d_cbBoundaryFile.setSelected(true);
            } else {
                this.d_cbBoundaryFile.setSelected(false);
            }
            UnitDouble unitDouble2 = fileOutput.getDtDeviceFiles();
            this.d_dfDeviceFiles.setValue(unitDouble2);
            if (unitDouble2 != null && !unitDouble2.equals(fileOutput2.getDtDeviceFiles())) {
                this.d_cbDeviceFiles.setSelected(true);
            } else {
                this.d_cbDeviceFiles.setSelected(false);
            }
            UnitDouble unitDouble3 = fileOutput.getDtHeatReleaseRateFiles();
            this.d_dfHeatReleaseRateFiles.setValue(unitDouble3);
            if (unitDouble3 != null && !unitDouble3.equals(fileOutput2.getDtHeatReleaseRateFiles())) {
                this.d_cbHeatReleaseRateFiles.setSelected(true);
            } else {
                this.d_cbHeatReleaseRateFiles.setSelected(false);
            }
            UnitDouble unitDouble4 = fileOutput.getDtIsofFiles();
            this.d_dfIsofFiles.setValue(unitDouble4);
            if (unitDouble4 != null && !unitDouble4.equals(fileOutput2.getDtIsofFiles())) {
                this.d_cbIsofFiles.setSelected(true);
            } else {
                this.d_cbIsofFiles.setSelected(false);
            }
            UnitDouble unitDouble5 = fileOutput.getDtMassFiles();
            this.d_dfMassFiles.setValue(unitDouble5);
            if (unitDouble5 != null && !unitDouble5.equals(fileOutput2.getDtMassFiles())) {
                this.d_cbMassFiles.setSelected(true);
            } else {
                this.d_cbMassFiles.setSelected(false);
            }
            UnitDouble unitDouble6 = fileOutput.getDtParticleFiles();
            this.d_dfParticleFiles.setValue(unitDouble6);
            if (unitDouble6 != null && !unitDouble6.equals(fileOutput2.getDtParticleFiles())) {
                this.d_cbParticleFiles.setSelected(true);
            } else {
                this.d_cbParticleFiles.setSelected(false);
            }
            UnitDouble unitDouble7 = fileOutput.getDtProfileDumpInterval();
            this.d_dfProfileDumpInterval.setValue(unitDouble7);
            if (unitDouble7 != null && !unitDouble7.equals(fileOutput2.getDtProfileDumpInterval())) {
                this.d_cbProfileDumpInterval.setSelected(true);
            } else {
                this.d_cbProfileDumpInterval.setSelected(false);
            }
            UnitDouble unitDouble8 = fileOutput.getDtRestartFile();
            this.d_dfRestartFile.setValue(unitDouble8);
            if (unitDouble8 != null) {
                this.d_cbRestartFile.setSelected(true);
            } else {
                this.d_cbRestartFile.setSelected(false);
            }
            UnitDouble unitDouble9 = fileOutput.getDtSliceFiles();
            this.d_dfSliceFiles.setValue(unitDouble9);
            if (unitDouble9 != null && !unitDouble9.equals(fileOutput2.getDtSliceFiles())) {
                this.d_cbSliceFiles.setSelected(true);
            } else {
                this.d_cbSliceFiles.setSelected(false);
            }
            UnitDouble unitDouble10 = fileOutput.getDtSlice3dFiles();
            this.d_dfSlice3dFiles.setValue(unitDouble10);
            if (unitDouble10 != null) {
                this.d_cbSlice3dFiles.setSelected(true);
            } else {
                this.d_cbSlice3dFiles.setSelected(false);
            }
        }

        private guiPanel getPanel() {
            return this.d_outputPanel;
        }
    }

    private class RadPanel {
        private final PyroMod d_pyroMod;
        private final UnitSystem d_uSys;
        private final guiPanel d_panel;
        private final guiCheckBox d_radi;
        private final guiCheckBox d_wideBand;
        private final ValueField<Integer> d_radSolidAngs;
        private final ValueField<Integer> d_radPolarAngs;
        private final ValueField<Integer> d_tsInc;
        private final ValueField<Integer> d_angInc;
        private final ValueField<Double> d_srcTemp;
        private final ValueField<Double> d_absorbC;
        private final ValueField<UnitDouble> d_dfPathLen;

        public RadPanel(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
            this.d_uSys = PyroSim.getApp().getUnitSystem();
            this.d_radi = new guiCheckBox(Intl.intl("Enable Radiation Transport Solver"));
            this.d_wideBand = new guiCheckBox(Intl.intl("Use Wide Band Model (slower)"));
            SimParams.RadiationTransport radiationTransport = new SimParams(this.d_pyroMod.getSurfaceMgr()).getRadiTransport();
            this.d_tsInc = ValueFields.intFld(radiationTransport.getTimeStepInc(), SimParams.RadiationTransport.TIME_STEP_RANGE);
            this.d_radSolidAngs = ValueFields.intFld(radiationTransport.getNumSolidAngles(), SimParams.RadiationTransport.ANGLE_NUM_RANGE);
            this.d_radPolarAngs = ValueFields.intFld(radiationTransport.getNumPolarAngles(), SimParams.RadiationTransport.ANGLE_NUM_RANGE);
            this.d_angInc = ValueFields.intFld(radiationTransport.getAngleIncrement(), SimParams.RadiationTransport.ANGLE_INCREMENT_RANGE);
            this.d_srcTemp = ValueFields.doubleFld(radiationTransport.getAssumedRadSourceTemp().getValue(this.d_uSys.getTempUnit()), SimParams.RadiationTransport.TEMPERATURE_RANGE.getDoubleRange(this.d_uSys.getTempUnit()));
            this.d_absorbC = ValueFields.doubleFld(radiationTransport.getConstAbsorptionCoef().getValue(this.d_uSys.getAbsorptionCoefficientUnit()));
            this.d_dfPathLen = ValueFields.udFld(UnitSystem.getSource(0));
            this.d_dfPathLen.setNullAllowed(true);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Time Step Increment") + ":");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Angle Increment") + ":");
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Number of Solid Angles") + ":");
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Number of Polar Angles") + ":");
            guiLabel guiLabel6 = new guiLabel(Intl.intl("Assumed Radiative Source Temp.") + ":");
            guiLabel guiLabel7 = new guiLabel(Intl.intl("Constant Absorption Coefficient") + ":");
            guiLabel guiLabel8 = new guiLabel(Intl.intl("Path Length") + ":");
            LinkStatus.link((AbstractButton)this.d_radi, this.d_wideBand, this.d_tsInc, this.d_angInc, this.d_radSolidAngs, this.d_radPolarAngs, this.d_srcTemp, this.d_absorbC, this.d_dfPathLen, guiLabel2, guiLabel3, guiLabel4, guiLabel5, guiLabel6, guiLabel7, guiLabel8);
            this.d_panel = new guiPanel(new GridBagLayout());
            int n = 0;
            GridBagUtil.add(this.d_panel, this.d_radi, 0, n++, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_wideBand, 0, n++, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel2, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_tsInc, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel3, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_angInc, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel4, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_radSolidAngs, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel5, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_radPolarAngs, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel6, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_srcTemp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel7, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_absorbC, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, guiLabel8, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_panel, this.d_dfPathLen, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_panel);
        }

        public guiPanel getPanel() {
            return this.d_panel;
        }

        public void saveData(SimParams.RadiationTransport radiationTransport) {
            Unit unit = this.d_uSys.getTempUnit();
            Unit unit2 = this.d_uSys.getKappa0Unit();
            radiationTransport.setRadiationOn(this.d_radi.isSelected());
            radiationTransport.setNonGrayGasAssumption(this.d_wideBand.isSelected());
            radiationTransport.setNumSolidAngles((Integer)this.d_radSolidAngs.getValue());
            radiationTransport.setTimeStepInc((Integer)this.d_tsInc.getValue());
            radiationTransport.setAngleIncrement((Integer)this.d_angInc.getValue());
            radiationTransport.setAssumedRadSourceTemp(this.ud(this.d_srcTemp, unit));
            radiationTransport.setNumPolarAngles((Integer)this.d_radPolarAngs.getValue());
            radiationTransport.setConstAbsorptionCoef(this.ud(this.d_absorbC, unit2));
            radiationTransport.setRadCalcPathLen((UnitDouble)this.d_dfPathLen.getValue());
        }

        private UnitDouble ud(ValueField<Double> valueField, Unit unit) {
            return new UnitDouble((Double)valueField.getValue(), unit);
        }

        public void loadData() {
            Unit unit = this.d_uSys.getTempUnit();
            Unit unit2 = this.d_uSys.getKappa0Unit();
            SimParams.RadiationTransport radiationTransport = this.d_pyroMod.getSimParams().getRadiTransport();
            this.d_radi.setSelected(radiationTransport.isRadiationOn());
            this.d_wideBand.setSelected(radiationTransport.isNonGrayGasAssumption());
            this.d_radSolidAngs.setValue(radiationTransport.getNumSolidAngles());
            this.d_tsInc.setValue(radiationTransport.getTimeStepInc());
            this.d_angInc.setValue(radiationTransport.getAngleIncrement());
            this.d_srcTemp.setValue(radiationTransport.getAssumedRadSourceTemp().getValue(unit));
            this.d_radPolarAngs.setValue(radiationTransport.getNumPolarAngles());
            this.d_absorbC.setValue(radiationTransport.getConstAbsorptionCoef().getValue(unit2));
            this.d_dfPathLen.setValue(radiationTransport.getRadCalcPathLen());
        }
    }

    private class SimulatorPanel
    extends guiPanel {
        private static final long serialVersionUID = -8192826770145073049L;
        private final PyroMod d_pyroMod;
        private final guiCheckBox d_cbSmag;
        private final guiCheckBox d_cbCFLStability;
        private final guiCheckBox d_cbVNStability;
        private final guiCheckBox d_cbSchmidt;
        private final guiCheckBox d_cbPrandtl;
        private final guiCheckBox d_cbInitUnmixedFraction;
        private final ValueField<Double> d_dfSmag;
        private final ValueField<Double> d_dfCFLMin;
        private final ValueField<Double> d_dfCFLMax;
        private final ValueField<Double> d_dfVNMin;
        private final ValueField<Double> d_dfVNMax;
        private final ValueField<Double> d_dfSchmidt;
        private final ValueField<Double> d_dfInitUnmixedFraction;
        private final ValueField<Double> d_dfPrandtl;
        private final guiComboBox<SimParams.Calculations.SimulationMode> d_cbSimulations;
        private final guiComboBox<SimParams.Calculations.BaroclinicState> d_cbBaroclinic;
        private final guiPanel d_simPanel;
        private final guiPanel d_cardPanel;
        private final guiPanel d_lesParamCard;
        private final guiPanel d_dnsParamCard;
        private final JPanel d_cflPanel;
        private final JPanel d_vonNeumannPanel;
        private final CardLayout d_cards;
        private final String LES;
        private final String DNS;
        private final Map<SimParams.Calculations.SimulationMode, String> d_simKeyLookup;

        public SimulatorPanel(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
            this.LES = "LES";
            this.DNS = "DNS";
            this.d_simKeyLookup = new HashMap<SimParams.Calculations.SimulationMode, String>();
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.LES, this.LES);
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.VLES, this.LES);
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.SVLES, this.LES);
            this.d_simKeyLookup.put(SimParams.Calculations.SimulationMode.DNS, this.DNS);
            this.d_cards = new CardLayout();
            this.d_lesParamCard = new guiPanel(new GridBagLayout());
            this.d_dnsParamCard = new guiPanel();
            this.d_simPanel = new guiPanel();
            this.d_cflPanel = new JPanel(new GridBagLayout());
            this.d_vonNeumannPanel = new JPanel(new GridBagLayout());
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_cbSmag = new guiCheckBox(Intl.intl("Specify Smagorinsky Constant") + ":");
            this.d_cbCFLStability = new guiCheckBox(Intl.intl("Specify CFL Region"));
            this.d_cbVNStability = new guiCheckBox(Intl.intl("Specify Von Neumann Region"));
            this.d_cbSchmidt = new guiCheckBox(Intl.intl("Specify Schmidt Number:"));
            this.d_cbPrandtl = new guiCheckBox(Intl.intl("Specify Prandtl Number:"));
            this.d_cbInitUnmixedFraction = new guiCheckBox(Intl.intl("Initial Unmixed Fraction:"));
            this.d_cbBaroclinic = new guiComboBox();
            this.d_cbBaroclinic.setRenderer(this.getBaroclinicRenderer());
            this.d_cbBaroclinic.add(SimParams.Calculations.BaroclinicState.AUTO);
            this.d_cbBaroclinic.add(SimParams.Calculations.BaroclinicState.TRUE);
            this.d_cbBaroclinic.add(SimParams.Calculations.BaroclinicState.FALSE);
            SimParams.Calculations calculations = new SimParams(this.d_pyroMod.getSurfaceMgr()).getCalculations();
            this.d_dfSmag = ValueFields.doubleFld(calculations.getCsmag(), SimParams.Calculations.CSMAG_RANGE);
            this.d_dfCFLMin = ValueFields.doubleFld(calculations.getCflRange()[0]);
            this.d_dfCFLMax = ValueFields.doubleFld(calculations.getCflRange()[1]);
            this.d_dfVNMin = ValueFields.doubleFld(calculations.getVnRange()[0]);
            this.d_dfVNMax = ValueFields.doubleFld(calculations.getVnRange()[1]);
            this.d_dfSchmidt = ValueFields.doubleFld(calculations.getSchmidtNum(), SimParams.Calculations.SC_RANGE);
            this.d_dfPrandtl = ValueFields.doubleFld(calculations.getPrandtlNum(), SimParams.Calculations.PR_RANGE);
            this.d_dfInitUnmixedFraction = ValueFields.doubleFld(1.0, DoubleVR.between(0.0, 1.0, true, true));
            JTextField jTextField = new JTextField(6);
            this.d_dfCFLMin.setPreferredSize(jTextField.getPreferredSize());
            this.d_dfCFLMax.setPreferredSize(jTextField.getPreferredSize());
            this.d_dfVNMin.setPreferredSize(jTextField.getPreferredSize());
            this.d_dfVNMax.setPreferredSize(jTextField.getPreferredSize());
            this.d_cbSimulations = new guiComboBox();
            this.d_cbSimulations.setRenderer(this.getSimulationTypeRenderer());
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.LES);
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.VLES);
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.SVLES);
            this.d_cbSimulations.addItem((SimParams.Calculations.SimulationMode)SimParams.Calculations.SimulationMode.DNS);
            this.d_cbSimulations.addItemListener(itemEvent -> {
                SimParams.Calculations.SimulationMode simulationMode = this.d_cbSimulations.getSelectedItem();
                this.d_cards.show(this.d_cardPanel, this.d_simKeyLookup.get((Object)simulationMode));
            });
            this.d_cbSmag.addActionListener(new CheckedListener<Double>(this.d_dfSmag));
            this.d_cbCFLStability.addActionListener(new CheckedListener<Double>(this.d_dfCFLMin));
            this.d_cbVNStability.addActionListener(new CheckedListener<Double>(this.d_dfVNMin));
            this.d_cbSchmidt.addActionListener(new CheckedListener<Double>(this.d_dfSchmidt));
            this.d_cbPrandtl.addActionListener(new CheckedListener<Double>(this.d_dfPrandtl));
            this.d_cbInitUnmixedFraction.addActionListener(new CheckedListener<Double>(this.d_dfInitUnmixedFraction));
            this.buildSimPanel();
        }

        private ListCellRenderer getSimulationTypeRenderer() {
            return new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof SimParams.Calculations.SimulationMode) {
                        this.setText(((SimParams.Calculations.SimulationMode)((Object)object)).getDisplayName());
                    }
                    return this;
                }
            };
        }

        private ListCellRenderer getBaroclinicRenderer() {
            return new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof SimParams.Calculations.SimulationMode) {
                        this.setText(((SimParams.Calculations.BaroclinicState)((Object)object)).displayName);
                    }
                    return this;
                }
            };
        }

        private void buildSimPanel() {
            this.d_simPanel.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.add(this.d_simPanel, this.d_cbSmag, 0, n, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_simPanel, this.d_dfSmag, 2, n++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_simPanel, this.d_cbCFLStability, 0, n, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_cflPanel, new guiLabel(Intl.intl("Min:")), 0, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_cflPanel, this.d_dfCFLMin, 1, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_cflPanel, new guiLabel(Intl.intl("Max:")), 0, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_cflPanel, this.d_dfCFLMax, 1, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_simPanel, this.d_cflPanel, 1, n, 2, 2, 0, -1, 12, 6, 0, 0.0, 0.0, 18);
            GridBagUtil.add(this.d_simPanel, this.d_cbVNStability, 0, n += 2, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_vonNeumannPanel, new guiLabel(Intl.intl("Min") + ":"), 0, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_vonNeumannPanel, this.d_dfVNMin, 1, 0, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_vonNeumannPanel, new guiLabel(Intl.intl("Max") + ":"), 0, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_vonNeumannPanel, this.d_dfVNMax, 1, 1, 1, 1, 3, 6, 3, 6, 0, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_simPanel, this.d_vonNeumannPanel, 1, n, 2, 2, 0, -1, 12, 6, 0, 0.0, 0.0, 18);
            GridBagUtil.add(this.d_simPanel, new guiLabel(Intl.intl("Simulation Type") + ":"), 0, n += 2, 1, 1, 6, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_simPanel, this.d_cbSimulations, 1, n++, 2, 1, 6, 0, 6, 12, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_simPanel, new JSeparator(0), 0, n++, 3, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 10);
            GridBagUtil.add(this.d_lesParamCard, new guiLabel(Intl.intl("Include Baroclinic Torque:")), 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbBaroclinic, 2, n++, 1, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbSchmidt, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_dfSchmidt, 2, n++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbPrandtl, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_dfPrandtl, 2, n++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
            GridBagUtil.add(this.d_lesParamCard, this.d_cbInitUnmixedFraction, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_lesParamCard, this.d_dfInitUnmixedFraction, 2, n++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 13);
            this.d_cardPanel.add((Component)this.d_lesParamCard, this.LES);
            this.d_cardPanel.add((Component)this.d_dnsParamCard, this.DNS);
            GridBagUtil.add(this.d_simPanel, this.d_cardPanel, 0, n, 3, 3, 0, 0, 0, 0, 0, 0.0, 0.0, 18);
            GridBagUtil.addGlue(this.d_simPanel);
            LinkStatus.link((AbstractButton)this.d_cbSmag, this.d_dfSmag);
            LinkStatus.link((AbstractButton)this.d_cbSchmidt, this.d_dfSchmidt);
            LinkStatus.link((AbstractButton)this.d_cbPrandtl, this.d_dfPrandtl);
            LinkStatus.link((AbstractButton)this.d_cbInitUnmixedFraction, this.d_dfInitUnmixedFraction);
            LinkStatus.link((AbstractButton)this.d_cbCFLStability, this.d_cflPanel);
            LinkStatus.link((AbstractButton)this.d_cbVNStability, this.d_vonNeumannPanel);
        }

        public void saveData(SimParams.Calculations calculations) {
            SimParams.Calculations calculations2 = new SimParams(this.d_pyroMod.getSurfaceMgr()).getCalculations();
            if (this.d_cbSmag.isSelected()) {
                calculations.setCsmag((Double)this.d_dfSmag.getValue());
            } else {
                calculations.setCsmag(calculations2.getCsmag());
            }
            if (this.d_cbCFLStability.isSelected()) {
                calculations.setCflRange((Double)this.d_dfCFLMin.getValue(), (Double)this.d_dfCFLMax.getValue());
            } else {
                calculations.setCflRange(calculations2.getCflRange()[0], calculations2.getCflRange()[1]);
            }
            if (this.d_cbVNStability.isSelected()) {
                calculations.setVnRange((Double)this.d_dfVNMin.getValue(), (Double)this.d_dfVNMax.getValue());
            } else {
                calculations.setVnRange(calculations2.getVnRange()[0], calculations2.getVnRange()[1]);
            }
            if (this.d_cbSchmidt.isVisible() && this.d_cbSchmidt.isSelected()) {
                calculations.setSchmidtNum((Double)this.d_dfSchmidt.getValue());
            } else {
                calculations.setSchmidtNum(calculations2.getSchmidtNum());
            }
            if (this.d_cbPrandtl.isVisible() && this.d_cbPrandtl.isSelected()) {
                calculations.setPrandtlNum((Double)this.d_dfPrandtl.getValue());
            } else {
                calculations.setPrandtlNum(calculations2.getPrandtlNum());
            }
            if (this.d_cbInitUnmixedFraction.isVisible() && this.d_cbInitUnmixedFraction.isSelected()) {
                calculations.setInitUnmixedFraction((Double)this.d_dfInitUnmixedFraction.getValue());
            } else {
                calculations.setInitUnmixedFraction(calculations2.getInitUnmixedFraction());
            }
            calculations.setSimMode(this.d_cbSimulations.getSelectedItem());
            calculations.setBaroclinicState(this.d_cbBaroclinic.getSelectedItem());
        }

        public void loadData() {
            SimParams.Calculations calculations = new SimParams(this.d_pyroMod.getSurfaceMgr()).getCalculations();
            SimParams.Calculations calculations2 = this.d_pyroMod.getSimParams().getCalculations();
            this.d_cbSimulations.setSelectedItem((Object)calculations2.getSimMode());
            this.d_cbBaroclinic.setSelectedItem((Object)calculations2.getBaroclinicState());
            double d = calculations2.getCsmag();
            if (d != calculations.getCsmag()) {
                this.d_cbSmag.setSelected(true);
                this.d_dfSmag.setValue(d);
            } else {
                this.d_cbSmag.setSelected(false);
            }
            double[] dArray = calculations2.getCflRange();
            if (dArray[0] != calculations.getCflRange()[0] || dArray[1] != calculations.getCflRange()[1]) {
                this.d_cbCFLStability.setSelected(true);
                this.d_dfCFLMin.setValue(dArray[0]);
                this.d_dfCFLMax.setValue(dArray[1]);
            } else {
                this.d_cbCFLStability.setSelected(false);
            }
            double[] dArray2 = calculations2.getVnRange();
            if (dArray2[0] != calculations.getVnRange()[0] || dArray2[1] != calculations.getVnRange()[1]) {
                this.d_cbVNStability.setSelected(true);
                this.d_dfVNMin.setValue(dArray2[0]);
                this.d_dfVNMax.setValue(dArray2[1]);
            } else {
                this.d_cbVNStability.setSelected(false);
            }
            double d2 = calculations2.getPrandtlNum();
            if (d2 != calculations.getPrandtlNum()) {
                this.d_cbPrandtl.setSelected(true);
                this.d_dfPrandtl.setValue(d2);
            } else {
                this.d_cbPrandtl.setSelected(false);
            }
            double d3 = calculations2.getInitUnmixedFraction();
            if (d3 != calculations.getInitUnmixedFraction()) {
                this.d_cbInitUnmixedFraction.setSelected(true);
                this.d_dfInitUnmixedFraction.setValue(d3);
            } else {
                this.d_cbInitUnmixedFraction.setSelected(false);
            }
            double d4 = calculations2.getSchmidtNum();
            if (d4 != calculations.getSchmidtNum()) {
                this.d_cbSchmidt.setSelected(true);
                this.d_dfSchmidt.setValue(d4);
            } else {
                this.d_cbSchmidt.setSelected(false);
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!this.d_dfCFLMax.isEmpty() && !this.d_dfCFLMin.isEmpty() && (Double)this.d_dfCFLMin.getValue() > (Double)this.d_dfCFLMax.getValue()) {
                return SimulationPropertiesDlg.this.invalidateFormattedFld(bl, bl2, this.d_dfCFLMin, Intl.intl("Min must be less than or equal to Max") + ".");
            }
            if (!this.d_dfVNMax.isEmpty() && !this.d_dfVNMin.isEmpty() && (Double)this.d_dfVNMin.getValue() > (Double)this.d_dfVNMax.getValue()) {
                return SimulationPropertiesDlg.this.invalidateFormattedFld(bl, bl2, this.d_dfVNMin, Intl.intl("Min must be less than or equal to Max") + ".");
            }
            return true;
        }

        public guiPanel getPanel() {
            return this.d_simPanel;
        }
    }

    private class ParticlePanel
    extends guiPanel {
        private static final long serialVersionUID = -3492088206321508526L;
        private final guiCheckBox d_cbPorousFloor;
        private final guiCheckBox d_cbMaxPartPerMesh;
        private final guiCheckBox d_cbAllowUndersideDroplets;
        private final ValueField<Integer> d_ifMaxPartPerMesh;
        private final PyroMod d_pyroMod;
        private final guiPanel d_partPanel;

        public ParticlePanel(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
            this.d_partPanel = new guiPanel();
            this.d_cbMaxPartPerMesh = new guiCheckBox(Intl.intl("Max Particles per Mesh") + ":");
            this.d_cbPorousFloor = new guiCheckBox(Intl.intl("Droplets Disappear at Floor"));
            this.d_cbAllowUndersideDroplets = new guiCheckBox(Intl.intl("Allow Underside Droplets"));
            this.d_ifMaxPartPerMesh = ValueFields.intFld(new SimParams(this.d_pyroMod.getSurfaceMgr()).getParticles().getMaxParticlesPerMesh(), SimParams.Particles.MAX_PARTICLES_PER_MESH);
            this.d_cbMaxPartPerMesh.addActionListener(new CheckedListener<Integer>(this.d_ifMaxPartPerMesh));
            this.buildParticlePanel();
        }

        private void buildParticlePanel() {
            this.d_partPanel.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.add(this.d_partPanel, this.d_cbPorousFloor, 0, n++, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_partPanel, this.d_cbAllowUndersideDroplets, 0, n++, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_partPanel, this.d_cbMaxPartPerMesh, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_partPanel, this.d_ifMaxPartPerMesh, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 18);
            GridBagUtil.addGlue(this.d_partPanel);
            LinkStatus.link((AbstractButton)this.d_cbMaxPartPerMesh, this.d_ifMaxPartPerMesh);
        }

        public guiPanel getPanel() {
            return this.d_partPanel;
        }

        public void saveData(SimParams.Particles particles) {
            particles.setPourousFloor(this.d_cbPorousFloor.isSelected());
            particles.setAllowUndersideDroplets(this.d_cbAllowUndersideDroplets.isSelected());
            if (this.d_cbMaxPartPerMesh.isSelected()) {
                particles.setMaxParticlesPerMesh((Integer)this.d_ifMaxPartPerMesh.getValue());
            } else {
                particles.setMaxParticlesPerMesh(new SimParams(this.d_pyroMod.getSurfaceMgr()).getParticles().getMaxParticlesPerMesh());
            }
        }

        public void loadData() {
            SimParams.Particles particles = this.d_pyroMod.getSimParams().getParticles();
            this.d_cbPorousFloor.setSelected(particles.isPourousFloor());
            this.d_cbAllowUndersideDroplets.setSelected(particles.getAllowUndersideDroplets());
            int n = particles.getMaxParticlesPerMesh();
            if (n != new SimParams(this.d_pyroMod.getSurfaceMgr()).getParticles().getMaxParticlesPerMesh()) {
                this.d_cbMaxPartPerMesh.setSelected(true);
                this.d_ifMaxPartPerMesh.setValue(n);
            } else {
                this.d_cbMaxPartPerMesh.setSelected(false);
            }
        }
    }

    private class EnvironmentPanel
    extends guiPanel {
        private static final long serialVersionUID = -6127356283272895039L;
        private final guiCheckBox d_cbSpecTMPA;
        private final guiCheckBox d_cbSpecPRESSAMB;
        private final guiCheckBox d_cbAmbMFO2;
        private final guiCheckBox d_cbAmbMFCO2;
        private final guiCheckBox d_cbRelHum;
        private final guiCheckBox d_cbGroundLevel;
        private final guiCheckBox d_cbMaxVis;
        private final guiCheckBox d_cbVisFactor;
        private final guiCheckBox d_cbSpecGravity;
        private final guiCheckBox d_cbWind;
        private final ValueField<UnitDouble> d_vfTMPA;
        private final ValueField<UnitDouble> d_vfPRESSAMB;
        private final ValueField<UnitDouble> d_vfAmbMFO2;
        private final ValueField<UnitDouble> d_vfAmbMFCO2;
        private final ValueField<UnitDouble> d_vfRelHum;
        private final ValueField<UnitDouble> d_vfGroundLevel;
        private final ValueField<UnitDouble> d_vfMaxVis;
        private final ValueField<Double> d_dfVisFactor;
        private final UnitSystem d_system;
        private final PyroMod d_pyroMod;
        private final guiPanel d_envPanel;
        private final guiPanel d_gravpan;
        private final VariantEditor d_veX;
        private final VariantEditor d_veY;
        private final VariantEditor d_veZ;
        private final JButton d_editWindBtn;
        private final String d_gravString = Intl.intl("Gravity");
        private SimParams.Wind d_tempWind;

        public EnvironmentPanel(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
            this.d_system = ((PyroSim)Application.getApp()).getUnitSystem();
            this.d_gravpan = new guiPanel(new GridBagLayout());
            this.d_envPanel = new guiPanel();
            this.d_cbSpecTMPA = new guiCheckBox(Intl.intl("Ambient Temperature:"));
            this.d_cbSpecPRESSAMB = new guiCheckBox(Intl.intl("Ambient Pressure:"));
            this.d_cbAmbMFO2 = new guiCheckBox(Intl.intl("Ambient Oxygen Mass Fraction:"));
            this.d_cbAmbMFCO2 = new guiCheckBox(Intl.intl("Ambient Carbon Dioxide Mass Fraction:"));
            this.d_cbRelHum = new guiCheckBox(Intl.intl("Relative Humidity:"));
            this.d_cbGroundLevel = new guiCheckBox(Intl.intl("Ground Level:"));
            this.d_cbMaxVis = new guiCheckBox(Intl.intl("Maximum Visibility:"));
            this.d_cbVisFactor = new guiCheckBox(Intl.intl("Visibility Factor:"));
            this.d_cbSpecGravity = new guiCheckBox(Intl.intl("Specify Gravity"));
            this.d_cbWind = new guiCheckBox(Intl.intl("Configure Wind"));
            SimParams.Environment environment = this.d_pyroMod.getSimParams().getEnvironment();
            this.d_vfTMPA = ValueFields.udFld(environment.getAmbTemp(), SimParams.Environment.TEMPERATURE_RANGE, UnitSystem.getSource(1));
            this.d_vfPRESSAMB = ValueFields.udFld(environment.getAmbPressure(), SimParams.Environment.AMBIENT_PRESSURE_RANGE, UnitSystem.getSource(39));
            this.d_vfAmbMFO2 = ValueFields.udFld(environment.getAmbMFO2(), UnitSystem.getSource(18));
            this.d_vfAmbMFCO2 = ValueFields.udFld(environment.getAmbMFCO2(), UnitSystem.getSource(18));
            this.d_vfRelHum = ValueFields.udFld(environment.getRelHumidity(), SimParams.Environment.RELATIVE_HUMIDITY_RANGE, UnitSystem.getSource(64));
            this.d_vfGroundLevel = ValueFields.udFld(environment.getGroundLevel(), UnitSystem.getSource(0));
            this.d_vfMaxVis = ValueFields.udFld(environment.getMaxVisibility(), UnitSystem.getSource(0));
            this.d_dfVisFactor = ValueFields.doubleFld(environment.getVisibilityFactor());
            this.d_editWindBtn = new JButton(Intl.intl("Edit..."));
            this.d_tempWind = new SimParams.Wind();
            this.d_cbSpecTMPA.addActionListener(new CheckedListener<UnitDouble>(this.d_vfTMPA));
            this.d_cbSpecPRESSAMB.addActionListener(new CheckedListener<UnitDouble>(this.d_vfPRESSAMB));
            this.d_cbRelHum.addActionListener(new CheckedListener<UnitDouble>(this.d_vfRelHum));
            this.d_veX = new VariantEditor(Intl.intl("X"), Intl.intl("Gravity[X]"), SimParams.Environment.GRAVX_PROFILE);
            this.d_veY = new VariantEditor(Intl.intl("Y"), Intl.intl("Gravity[Y]"), SimParams.Environment.GRAVY_PROFILE);
            this.d_veZ = new VariantEditor(Intl.intl("Z"), Intl.intl("Gravity[Z]"), SimParams.Environment.GRAVZ_PROFILE);
            this.d_editWindBtn.addActionListener(actionEvent -> {
                guiDialog guiDialog2 = new guiDialog((Window)SimulationPropertiesDlg.this, Intl.intl("Wind Parameters"), 9);
                WindPanel windPanel = new WindPanel();
                guiDialog2.getDialogPane().add(windPanel);
                windPanel.load(this.d_tempWind);
                if (guiDialog2.doModal() == 1) {
                    windPanel.save(this.d_tempWind);
                    SimulationPropertiesDlg.this.d_dlgPanel.setModified(true);
                }
            });
            this.buildEnvironmentPanel();
        }

        public boolean validateGravity(VariantEditor variantEditor, VariantEditor variantEditor2, VariantEditor variantEditor3, boolean bl) {
            return SimulationPropertiesDlg.validateVariant(this.getParent(), variantEditor, bl, Intl.intl("Specify Gravity (X)")) && SimulationPropertiesDlg.validateVariant(this.getParent(), variantEditor2, bl, Intl.intl("Specify Gravity (Y)")) && SimulationPropertiesDlg.validateVariant(this.getParent(), variantEditor3, bl, Intl.intl("Specify Gravity (Z)"));
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.validateGravity(this.d_veX, this.d_veY, this.d_veZ, bl)) {
                return false;
            }
            SurfaceManager surfaceManager = this.d_pyroMod.getSurfaceMgr();
            for (Surface surface : surfaceManager.flatten()) {
                String string;
                int n;
                UnitDouble unitDouble;
                UnitDouble unitDouble2;
                ISurfDesc iSurfDesc = surface.getSurfDesc();
                AirFlow airFlow = null;
                if (iSurfDesc instanceof BlowerSurfDesc) {
                    airFlow = ((BlowerSurfDesc)iSurfDesc).d_airFlow;
                } else if (iSurfDesc instanceof InFlowSurfDesc) {
                    airFlow = ((InFlowSurfDesc)iSurfDesc).d_airFlow;
                }
                if (airFlow == null || !(airFlow.d_profile instanceof AirFlow.AtmosphericProf) || !(unitDouble2 = ((AirFlow.AtmosphericProf)airFlow.d_profile).d_origin).lt(unitDouble = (UnitDouble)this.d_vfGroundLevel.getValue(), 1.0E-6) || (n = JOptionPane.showConfirmDialog(this, string = String.format(Intl.intl("Warning: Ground Level above lowest atmospheric\nvelocity profile (%1$s, %2$s)."), surface.getName(), unitDouble2.toString()), Intl.intl("Warning"), 2, 2)) != 2) continue;
                return false;
            }
            return true;
        }

        private void buildEnvironmentPanel() {
            this.d_envPanel.setLayout(new GridBagLayout());
            int n = 0;
            GridBagUtil.add(this.d_envPanel, this.d_cbSpecTMPA, 0, n, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfTMPA, 1, n++, 1, 1, 12, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbSpecPRESSAMB, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfPRESSAMB, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbAmbMFO2, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfAmbMFO2, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbAmbMFCO2, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfAmbMFCO2, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbWind, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_editWindBtn, 1, n++, 1, 1, 0, 0, 6, 3, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbRelHum, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfRelHum, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbGroundLevel, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfGroundLevel, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbMaxVis, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_vfMaxVis, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbVisFactor, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_dfVisFactor, 1, n++, 1, 1, 0, 0, 6, 3, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_envPanel, this.d_cbSpecGravity, 0, n, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            this.d_veX.addToPanel(this.d_gravpan, 0, 0, 0, 0, 0, 0);
            this.d_veY.addToPanel(this.d_gravpan, 0, 1, 0, 0, 0, 0);
            this.d_veZ.addToPanel(this.d_gravpan, 0, 2, 0, 0, 0, 0);
            GridBagUtil.add(this.d_envPanel, this.d_gravpan, 1, n, 2, 3, 0, 5, 12, 6, 0, 0.0, 0.0, 18);
            GridBagUtil.addGlue(this.d_envPanel);
            LinkStatus.link((AbstractButton)this.d_cbSpecTMPA, this.d_vfTMPA);
            LinkStatus.link((AbstractButton)this.d_cbSpecPRESSAMB, this.d_vfPRESSAMB);
            LinkStatus.link((AbstractButton)this.d_cbAmbMFO2, this.d_vfAmbMFO2);
            LinkStatus.link((AbstractButton)this.d_cbAmbMFCO2, this.d_vfAmbMFCO2);
            LinkStatus.link((AbstractButton)this.d_cbRelHum, this.d_vfRelHum);
            LinkStatus.link((AbstractButton)this.d_cbGroundLevel, this.d_vfGroundLevel);
            LinkStatus.link((AbstractButton)this.d_cbMaxVis, this.d_vfMaxVis);
            LinkStatus.link((AbstractButton)this.d_cbVisFactor, this.d_dfVisFactor);
            LinkStatus.link((AbstractButton)this.d_cbSpecGravity, this.d_gravpan);
            LinkStatus.link((AbstractButton)this.d_cbWind, this.d_editWindBtn);
        }

        public void saveData(SimParams.Environment environment, SimParams.Wind wind) {
            SimParams simParams = new SimParams(this.d_pyroMod.getSurfaceMgr());
            SimParams.Environment environment2 = simParams.getEnvironment();
            if (this.d_cbSpecTMPA.isSelected()) {
                environment.setAmbTemp((UnitDouble)this.d_vfTMPA.getValue());
            } else {
                environment.setAmbTemp(environment2.getAmbTemp());
            }
            if (this.d_cbSpecPRESSAMB.isSelected()) {
                environment.setAmbPressure((UnitDouble)this.d_vfPRESSAMB.getValue());
            } else {
                environment.setAmbPressure(environment2.getAmbPressure());
            }
            if (this.d_cbAmbMFO2.isSelected()) {
                environment.setAmbMFO2((UnitDouble)this.d_vfAmbMFO2.getValue());
            } else {
                environment.setAmbMFO2(environment2.getAmbMFO2());
            }
            if (this.d_cbAmbMFCO2.isSelected()) {
                environment.setAmbMFCO2((UnitDouble)this.d_vfAmbMFCO2.getValue());
            } else {
                environment.setAmbMFCO2(environment2.getAmbMFCO2());
            }
            if (this.d_cbRelHum.isSelected()) {
                environment.setRelHumidity((UnitDouble)this.d_vfRelHum.getValue());
            } else {
                environment.setRelHumidity(environment2.getRelHumidity());
            }
            if (this.d_cbGroundLevel.isSelected()) {
                environment.setGroundLevel((UnitDouble)this.d_vfGroundLevel.getValue());
            } else {
                environment.setGroundLevel(environment2.getGroundLevel());
            }
            if (this.d_cbMaxVis.isSelected()) {
                environment.setMaxVisibility((UnitDouble)this.d_vfMaxVis.getValue());
            } else {
                environment.setMaxVisibility(environment2.getMaxVisibility());
            }
            if (this.d_cbVisFactor.isSelected()) {
                environment.setVisibilityFactor((Double)this.d_dfVisFactor.getValue());
            } else {
                environment.setVisibilityFactor(environment2.getVisibilityFactor());
            }
            if (this.d_cbSpecGravity.isSelected()) {
                environment.setGravityAccel(this.d_veX.getValue(), this.d_veY.getValue(), this.d_veZ.getValue());
            } else {
                environment.setGravityAccel(environment2.getGravityX(), environment2.getGravityY(), environment2.getGravityZ());
            }
            if (this.d_cbWind.isSelected()) {
                wind.copyVals(this.d_tempWind);
            } else {
                wind.copyVals(simParams.getWind());
            }
        }

        public void loadData() {
            UnitDouble unitDouble;
            SimParams.Environment environment = this.d_pyroMod.getSimParams().getEnvironment();
            SimParams.Wind wind = this.d_pyroMod.getSimParams().getWind();
            SimParams simParams = new SimParams(this.d_pyroMod.getSurfaceMgr());
            SimParams.Environment environment2 = simParams.getEnvironment();
            Variant variant = environment.getGravityX();
            Variant variant2 = environment.getGravityY();
            Variant variant3 = environment.getGravityZ();
            if (variant != null && !variant.equals(environment2.getGravityX()) || variant2 != null && !variant2.equals(environment2.getGravityY()) || variant3 != null && !variant3.equals(environment2.getGravityZ())) {
                this.d_veX.init(variant);
                this.d_veY.init(variant2);
                this.d_veZ.init(variant3);
                this.d_cbSpecGravity.setSelected(true);
            } else {
                this.d_cbSpecGravity.setSelected(false);
            }
            UnitDouble unitDouble2 = environment.getAmbTemp();
            if (unitDouble2 != null && !unitDouble2.equals(environment2.getAmbTemp())) {
                this.d_cbSpecTMPA.setSelected(true);
                this.d_vfTMPA.setValue(unitDouble2);
            } else {
                this.d_cbSpecTMPA.setSelected(false);
            }
            UnitDouble unitDouble3 = environment.getAmbPressure();
            if (unitDouble3 != null && !unitDouble3.equals(environment2.getAmbPressure())) {
                this.d_cbSpecPRESSAMB.setSelected(true);
                this.d_vfPRESSAMB.setValue(unitDouble3);
            } else {
                this.d_cbSpecPRESSAMB.setSelected(false);
            }
            UnitDouble unitDouble4 = environment.getAmbMFO2();
            if (unitDouble4 != null && !unitDouble4.equals(environment2.getAmbMFO2())) {
                this.d_cbAmbMFO2.setSelected(true);
                this.d_vfAmbMFO2.setValue(unitDouble4);
            } else {
                this.d_cbAmbMFO2.setSelected(false);
            }
            UnitDouble unitDouble5 = environment.getAmbMFCO2();
            if (unitDouble5 != null && !unitDouble5.equals(environment2.getAmbMFCO2())) {
                this.d_cbAmbMFCO2.setSelected(true);
                this.d_vfAmbMFCO2.setValue(unitDouble5);
            }
            if (!(unitDouble = environment.getRelHumidity()).equals(environment2.getRelHumidity())) {
                this.d_cbRelHum.setSelected(true);
                this.d_vfRelHum.setValue(unitDouble);
            } else {
                this.d_cbRelHum.setSelected(false);
            }
            UnitDouble unitDouble6 = environment.getGroundLevel();
            if (!theUtil.equal(unitDouble6, environment2.getGroundLevel())) {
                this.d_cbGroundLevel.setSelected(true);
                this.d_vfGroundLevel.setValue(unitDouble6);
            } else {
                this.d_cbGroundLevel.setSelected(false);
            }
            UnitDouble unitDouble7 = environment.getMaxVisibility();
            if (unitDouble7 != null && !unitDouble7.equals(environment2.getMaxVisibility())) {
                this.d_cbMaxVis.setSelected(true);
                this.d_vfMaxVis.setValue(unitDouble7);
            } else {
                this.d_cbMaxVis.setSelected(false);
            }
            double d = environment.getVisibilityFactor();
            if (d != environment2.getVisibilityFactor()) {
                this.d_cbVisFactor.setSelected(true);
                this.d_dfVisFactor.setValue(d);
            }
            if (wind.isDefault()) {
                this.d_cbWind.setSelected(false);
            } else {
                this.d_cbWind.setSelected(true);
            }
            this.d_tempWind.copyVals(wind);
        }

        public guiPanel getPanel() {
            return this.d_envPanel;
        }
    }

    private class TimePanel
    extends guiPanel {
        private static final long serialVersionUID = -6852541345028055481L;
        private final guiCheckBox d_cbSpecTimeStep;
        private final guiCheckBox d_lockTimeStep;
        private final guiCheckBox d_restrictTimeStep;
        private final ValueField<UnitDouble> d_dfStartTime;
        private final ValueField<UnitDouble> d_dfEndTime;
        private final ValueField<UnitDouble> d_dfTimeStep;
        private final ValueField<Integer> d_wallIncFld;
        private final UnitSystem d_system;
        private final Unit d_timeUnit;
        private final PyroMod d_pyroMod;
        private final guiPanel d_timePanel;

        public TimePanel(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
            this.d_system = ((PyroSim)Application.getApp()).getUnitSystem();
            this.d_timeUnit = this.d_system.getTimeUnit();
            SimParams.Time time = new SimParams.Time();
            this.d_timePanel = new guiPanel();
            this.d_lockTimeStep = new guiCheckBox(Intl.intl("Do not allow time step changes"));
            this.d_restrictTimeStep = new guiCheckBox(Intl.intl("Do not allow time step to exceed initial"));
            this.d_cbSpecTimeStep = new guiCheckBox(Intl.intl("Initial Time Step:"));
            this.d_dfEndTime = ValueFields.udFld(time.getStopTime(), UnitSystem.getSource(2));
            this.d_dfStartTime = ValueFields.udFld(time.getStartTime(), UnitSystem.getSource(2));
            this.d_dfTimeStep = ValueFields.udFld(UnitSystem.getSource(2), SimParams.Time.TIME_STEP_RANGE);
            this.d_wallIncFld = ValueFields.intFld(2, SimParams.Time.WALL_INC_RANGE);
            this.d_cbSpecTimeStep.addActionListener(new CheckedListener<UnitDouble>(this.d_dfTimeStep));
            this.buildTimePanel();
        }

        private void buildTimePanel() {
            this.d_timePanel.setLayout(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Start Time:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("End Time:"));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Wall Update Increment:"));
            guiLabel guiLabel5 = new guiLabel(Intl.intl("frames"));
            int n = 0;
            GridBagUtil.add(this.d_timePanel, guiLabel2, 0, n, 1, 1, 12, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_dfStartTime, 1, n++, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, guiLabel3, 0, n, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_dfEndTime, 1, n++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_cbSpecTimeStep, 0, n, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_dfTimeStep, 1, n++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_lockTimeStep, 0, n++, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_restrictTimeStep, 0, n++, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, guiLabel4, 0, n, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, this.d_wallIncFld, 1, n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_timePanel, guiLabel5, 2, n++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_timePanel);
            LinkStatus.link((AbstractButton)this.d_cbSpecTimeStep, this.d_dfTimeStep);
        }

        public void saveData(SimParams.Time time, SimParams.OpenMp openMp) {
            SimParams.Time time2 = new SimParams(this.d_pyroMod.getSurfaceMgr()).getTime();
            time.setTimeStepLocks(this.d_lockTimeStep.isSelected(), this.d_restrictTimeStep.isSelected());
            time.setStartTime((UnitDouble)this.d_dfStartTime.getValue());
            time.setStopTime((UnitDouble)this.d_dfEndTime.getValue());
            if (this.d_cbSpecTimeStep.isSelected()) {
                time.setInitTimeStep((UnitDouble)this.d_dfTimeStep.getValue());
            } else {
                time.setInitTimeStep(time2.getInitTimeStep());
            }
            time.setWallIncrement((Integer)this.d_wallIncFld.getValue());
        }

        public void loadData() {
            SimParams.Time time = this.d_pyroMod.getSimParams().getTime();
            SimParams.Time time2 = new SimParams(this.d_pyroMod.getSurfaceMgr()).getTime();
            this.d_lockTimeStep.setSelected(time.lockTimeSteps());
            this.d_restrictTimeStep.setSelected(time.restrictTimeSteps());
            this.d_dfStartTime.setValue(time.getStartTime());
            this.d_dfEndTime.setValue(time.getStopTime());
            UnitDouble unitDouble = time.getInitTimeStep();
            this.d_dfTimeStep.setValue(unitDouble);
            if (unitDouble != null && !unitDouble.equals(time2.getInitTimeStep())) {
                this.d_cbSpecTimeStep.setSelected(true);
            } else {
                this.d_cbSpecTimeStep.setSelected(false);
            }
            this.d_wallIncFld.setValue(time.getWallIncrement());
        }

        public guiPanel getPanel() {
            return this.d_timePanel;
        }
    }
}

