/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalBorders;

public class ResizableWindow
extends JWindow {
    private static final long serialVersionUID = -2161231002898733963L;
    private static final int RZ_NORTH = 1;
    private static final int RZ_WEST = 2;
    private static final int RZ_SOUTH = 4;
    private static final int RZ_EAST = 8;

    public ResizableWindow() {
        this((Window)null);
    }

    public ResizableWindow(Window window) {
        super(window);
        Border border = UIManager.getBorder("InternalFrame.border");
        if (border == null) {
            border = new MetalBorders.InternalFrameBorder();
        }
        this.getRootPane().setBorder(border);
        ResizeListener resizeListener = new ResizeListener();
        this.addMouseListener(resizeListener);
        this.addMouseMotionListener(resizeListener);
    }

    @Override
    public Cursor getCursor() {
        int n;
        Point point = MouseInfo.getPointerInfo().getLocation();
        Point point2 = this.getLocation();
        point = (Point)point.clone();
        point.x -= point2.x;
        point.y -= point2.y;
        int n2 = this.getResize(point);
        switch (n2) {
            case 3: {
                n = 6;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 12: {
                n = 5;
                break;
            }
            case 9: {
                n = 7;
                break;
            }
            case 2: {
                n = 10;
                break;
            }
            case 4: {
                n = 9;
                break;
            }
            case 8: {
                n = 11;
                break;
            }
            case 1: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return Cursor.getPredefinedCursor(n);
    }

    private int getResize(Point point) {
        Dimension dimension = this.getSize();
        Border border = this.getRootPane().getBorder();
        Insets insets = border.getBorderInsets(this);
        int n = 0;
        if (point.getX() <= (double)insets.left && point.getX() >= 0.0) {
            n |= 2;
        } else if (point.getX() >= (double)(dimension.width - insets.right) && point.getX() <= (double)dimension.width) {
            n |= 8;
        }
        if (point.getY() <= (double)insets.top && point.getY() >= 0.0) {
            n |= 1;
        } else if (point.getY() >= (double)(dimension.height - insets.bottom) && point.getY() <= (double)dimension.height) {
            n |= 4;
        }
        return n;
    }

    private class ResizeListener
    extends MouseAdapter {
        private int d_resizeFlags = 0;
        private Point d_resizeLoc = null;
        private Rectangle d_originalBounds = null;

        private ResizeListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ResizableWindow.this.setCursor(ResizableWindow.this.getCursor());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.isClicked()) {
                ResizableWindow.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                this.d_resizeFlags = ResizableWindow.this.getResize(mouseEvent.getPoint());
                if (this.d_resizeFlags != 0) {
                    this.d_originalBounds = (Rectangle)ResizableWindow.this.getBounds().clone();
                    this.d_resizeLoc = mouseEvent.getLocationOnScreen();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                this.d_resizeFlags = 0;
                this.d_originalBounds = null;
                this.d_resizeLoc = null;
            }
        }

        private boolean testFlag(int n, int n2) {
            return (n & n2) == n2;
        }

        private boolean isClicked() {
            return this.d_originalBounds != null;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.d_originalBounds != null && this.d_resizeFlags != 0) {
                Insets insets = ResizableWindow.this.getRootPane().getBorder().getBorderInsets(ResizableWindow.this);
                int n = insets.left + insets.right;
                int n2 = insets.bottom + insets.top;
                int n3 = this.d_originalBounds.x;
                int n4 = this.d_originalBounds.x + this.d_originalBounds.width;
                int n5 = this.d_originalBounds.y;
                int n6 = this.d_originalBounds.y + this.d_originalBounds.height;
                Point point = mouseEvent.getLocationOnScreen();
                int n7 = point.x - this.d_resizeLoc.x;
                int n8 = point.y - this.d_resizeLoc.y;
                if (this.testFlag(this.d_resizeFlags, 1) && n6 - (n5 += n8) < n2) {
                    n5 = n6 - n2;
                }
                if (this.testFlag(this.d_resizeFlags, 4) && (n6 += n8) - n5 < n2) {
                    n6 = n5 + n2;
                }
                if (this.testFlag(this.d_resizeFlags, 2) && n4 - (n3 += n7) < n) {
                    n3 = n4 - n;
                }
                if (this.testFlag(this.d_resizeFlags, 8) && (n4 += n7) - n3 < n) {
                    n4 = n3 + n;
                }
                ResizableWindow.this.setBounds(new Rectangle(n3, n5, n4 - n3, n6 - n5));
            }
        }
    }
}

