/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.util.Util;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.guiAction;

public class RenameAction<T extends INamed, MgrT extends Composite<T>>
extends guiAction {
    private static final long serialVersionUID = -3997701728956750319L;
    private final ManagerDlg<T, MgrT> d_owner;
    private MgrT d_mgr;
    private final String d_desc;

    public RenameAction(ManagerDlg<T, MgrT> managerDlg, String string) {
        super(Intl.intl("Rename") + "...");
        this.d_owner = managerDlg;
        this.d_desc = string;
    }

    public void init(MgrT MgrT) {
        this.d_mgr = MgrT;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (!this.d_owner.preSave()) {
            return;
        }
        PyroMod pyroMod = (PyroMod)((ADomainObject)this.d_mgr).getDomain();
        int n = this.d_owner.getList().getSelectedIx();
        INamed iNamed = (INamed)this.d_owner.getList().getItem(n);
        while (true) {
            if ((string = JOptionPane.showInputDialog(this.d_owner, Intl.intl("Name") + ": ", iNamed.getName())) == null) {
                return;
            }
            try {
                string = Util.validateName(pyroMod, iNamed, string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.d_owner, exception.getLocalizedMessage(), Intl.intl("Invalid Entry"), 0);
                continue;
            }
            break;
        }
        pyroMod.getTaskManager().exec(new SetNameTask(iNamed, string), Intl.intl("Rename"));
        this.d_owner.initItem(iNamed);
        this.d_owner.getList().updateModelView(this.d_mgr);
    }
}

