/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class RampFuncDlg
extends guiDialog {
    private static final long serialVersionUID = 8555427952325986796L;
    private guiTableEditor d_editor;
    private final guiComboBox<IRampInput> d_rampInputs;
    private final int d_fUnitType;
    private final IRampInput d_defRampInput;
    private ValueField<UnitDouble> d_constEditor;

    public RampFuncDlg(IRampInput iRampInput, int n, String string, Collection<IRampInput> collection) {
        this(iRampInput, n, string, collection, UnitSystem.getUndefinedUnit(), "");
    }

    public RampFuncDlg(IRampInput iRampInput, int n, String string, Collection<IRampInput> collection, int n2, String string2) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Ramping Function Values"), 9);
        this.d_defRampInput = iRampInput;
        if (collection == null) {
            collection = this.getRampInputs(this.d_defRampInput);
        }
        this.d_rampInputs = this.createInputCombo(collection);
        this.d_fUnitType = n;
        String[] stringArray = new String[]{"", this.formatColHeader(string, n)};
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        this.d_editor = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, new Class[]{Double.class, Double.class}), 30);
        this.d_editor.getTable().setNullValuesAllowed(false);
        this.d_editor.setPreferredSize(new Dimension(410, 250));
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        if (UnitSystem.isValidUnit(n2)) {
            guiLabel guiLabel2 = new guiLabel(string2);
            this.d_constEditor = ValueFields.udFld(UnitSystem.getSource(n2));
            gridBagHelper.addRow(guiLabel2, this.d_constEditor);
            gridBagHelper.addFilledRow(new JSeparator());
        } else {
            this.d_constEditor = null;
        }
        gridBagHelper.addRow(Intl.intl("Function Input:"), this.d_rampInputs);
        gridBagHelper.addRow(this.d_editor, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        this.d_editor.getTable().autoSizeColumns(200);
        this.d_rampInputs.setSelectedItem(this.d_defRampInput);
        this.updateInputHeader();
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
    }

    public static RampFuncDlg newTimeFracDlg(Ramp ramp) {
        RampFuncDlg rampFuncDlg = new RampFuncDlg(ramp.getDefaultInput(), 28, Intl.intl("Fraction"), null);
        rampFuncDlg.loadData(ramp);
        return rampFuncDlg;
    }

    private guiComboBox<IRampInput> createInputCombo(Collection<IRampInput> collection) {
        guiComboBox<IRampInput> guiComboBox2 = new guiComboBox<IRampInput>(collection);
        guiComboBox2.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -2828821800298865042L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                IRampInput iRampInput = (IRampInput)object;
                String string = iRampInput.getName();
                if (iRampInput instanceof SignalInput) {
                    SignalInput signalInput = (SignalInput)iRampInput;
                    string = signalInput.getUnitType() == 2 && (signalInput.input.getAttachedSource() instanceof RampInputs.TimeInput || signalInput.input.getAttachedSource() instanceof Clock) ? RampInputs.TIME.getName() : String.format(Intl.intl("Device: %s"), iRampInput.getName());
                }
                this.setText(string);
                return component;
            }
        });
        guiComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    RampFuncDlg.this.updateInputHeader();
                }
            }
        });
        return guiComboBox2;
    }

    private Collection<IRampInput> getRampInputs(IRampInput iRampInput) {
        Cloneable cloneable22;
        ArrayList<SignalInput> arrayList = new ArrayList<SignalInput>();
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        for (Cloneable cloneable22 : pyroMod.getDevices().flatten()) {
            if (!(cloneable22 instanceof ISignalSource)) continue;
            for (IOutPin iOutPin : ((ISignalSource)cloneable22).getOutputPins()) {
                if (!(iOutPin instanceof IDoubleOutPin)) continue;
                SignalInput signalInput = new SignalInput((IDoubleOutPin)iOutPin);
                arrayList.add(signalInput);
            }
        }
        IRampInput[] iRampInputArray = arrayList.toArray(new IRampInput[arrayList.size()]);
        Arrays.sort(iRampInputArray, new Comparator<IRampInput>(){

            @Override
            public int compare(IRampInput iRampInput, IRampInput iRampInput2) {
                return iRampInput.getName().compareToIgnoreCase(iRampInput2.getName());
            }
        });
        cloneable22 = new ArrayList();
        cloneable22.add(iRampInput);
        if (iRampInput.getUnitType() != 2) {
            IDoubleOutPin iDoubleOutPin = (IDoubleOutPin)Clock.INSTANCE.getOutputPins().get(0);
            cloneable22.add(new SignalInput(iDoubleOutPin));
        }
        for (IRampInput iRampInput2 : iRampInputArray) {
            cloneable22.add(iRampInput2);
        }
        return cloneable22;
    }

    private void updateInputHeader() {
        IRampInput iRampInput = this.d_rampInputs.getSelectedItem();
        String string = this.formatColHeader(iRampInput.getName(), iRampInput.getUnitType());
        this.d_editor.getTable().getColumnModel().getColumn(0).setHeaderValue(string);
        this.repaint();
    }

    private String formatColHeader(String string, int n) {
        Unit unit = this.getUnit(n);
        String string2 = unit.toString();
        return string2.isEmpty() ? string : String.format("%s (%s)", string, string2);
    }

    private Unit getTUnit() {
        IRampInput iRampInput = this.d_rampInputs.getSelectedItem();
        return this.getUnit(iRampInput.getUnitType());
    }

    private Unit getFUnit() {
        return this.getUnit(this.d_fUnitType);
    }

    private Unit getUnit(int n) {
        return PyroSim.getApp().getUnitSystem().getUnit(n);
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        this.savePreferredSize(PyroPrefs.LastRampDlgSizeX.key.toString(), PyroPrefs.LastRampDlgSizeY.key.toString());
        return n;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        TableModel tableModel = this.d_editor.getTable().getModel();
        if (tableModel.getRowCount() == 0) {
            String string = Intl.intl("Error: At least one point must be entered for the function.");
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        if (!this.noDuplicates(tableModel)) {
            String string = Intl.intl("Error: Duplicate function time points are not permitted.");
            this.showMessageBox(string);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    private boolean noDuplicates(TableModel tableModel) {
        int n = tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (guiTableUtil.getDouble(tableModel, i, 0) != guiTableUtil.getDouble(tableModel, j, 0) || guiTableUtil.getDouble(tableModel, i, 1) != guiTableUtil.getDouble(tableModel, j, 1)) continue;
                return false;
            }
        }
        return true;
    }

    public void loadData(Ramp ramp) {
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_editor.getTable().getModel();
        if (ramp != null) {
            this.d_rampInputs.setSelectedItem(ramp.getInput());
            Unit unit = this.getTUnit();
            Unit unit2 = this.getFUnit();
            int n = 0;
            List<Ramp.Entry> list = ramp.getRecords();
            for (Ramp.Entry entry : list) {
                UnitDouble unitDouble = entry.t;
                UnitDouble unitDouble2 = entry.f;
                guiDefaultTableModel2.setValueAt(unitDouble.getValue(unit), n, 0);
                guiDefaultTableModel2.setValueAt(unitDouble2.getValue(unit2), n, 1);
                ++n;
            }
        }
        this.updateInputHeader();
    }

    public Ramp getRamp() {
        TableModel tableModel = this.d_editor.getTable().getModel();
        int n = tableModel.getRowCount();
        if (n > 0) {
            Vector<Ramp.Entry> vector = new Vector<Ramp.Entry>(n);
            IRampInput iRampInput = this.d_rampInputs.getSelectedItem();
            Unit unit = this.getTUnit();
            Unit unit2 = this.getFUnit();
            for (int i = 0; i < n; ++i) {
                UnitDouble unitDouble = new UnitDouble((Double)tableModel.getValueAt(i, 0), unit);
                UnitDouble unitDouble2 = new UnitDouble((Double)tableModel.getValueAt(i, 1), unit2);
                Ramp.Entry entry = new Ramp.Entry(unitDouble, unitDouble2);
                vector.add(entry);
            }
            Ramp ramp = new Ramp(vector, this.d_defRampInput, iRampInput, this.d_fUnitType);
            return ramp;
        }
        return null;
    }

    public void loadData(UnitDouble unitDouble) {
        if (this.d_constEditor == null) {
            assert (false) : "No editor specified for constant fields.";
            return;
        }
        this.d_constEditor.setValue(unitDouble);
    }

    public UnitDouble getConstVal() {
        if (this.d_constEditor == null) {
            assert (false) : "No editor specified for constant fields.";
            return null;
        }
        return (UnitDouble)this.d_constEditor.getValue();
    }
}

