/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.Material;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class PyroGuiUtil
extends guiUtil {
    public static final Icon WARNING_ICON = UIManager.getIcon("OptionPane.warningIcon");
    public static final Icon ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
    public static final Icon INFORMATION_ICON = UIManager.getIcon("OptionPane.informationIcon");
    public static final Icon QUESTION_ICON = UIManager.getIcon("OptionPane.questionIcon");
    public static final Icon PLAIN_ICON = UIManager.getIcon("OptionPane.plainIcon");
    public static final ImageIcon NEW = PyroGuiUtil.loadPyroSimIcon("newobj.png");
    public static final int FS_OPTIONS = 3;

    public static boolean invalidateFld(Component component, boolean bl, boolean bl2, guiField guiField2, String string) {
        if (bl) {
            guiDialog.showInvalidEntryMessage(component, string);
        }
        if (bl2) {
            guiField2.requestFocus();
        }
        return false;
    }

    public static boolean invalidateFld(Component component, boolean bl, boolean bl2, ValueField valueField, String string) {
        if (bl) {
            guiDialog.showInvalidEntryMessage(component, string);
        }
        if (bl2) {
            valueField.requestFocus();
        }
        return false;
    }

    public static guiLabel label(String string, String string2) {
        guiLabel guiLabel2 = new guiLabel(string);
        guiLabel2.setToolTipText(string2);
        return guiLabel2;
    }

    public static Icon createNewObjIcon(String string) {
        return new DecoratedIcon(PyroGuiUtil.loadPyroSimIcon(string), NEW, 3);
    }

    public static ImageIcon loadPyroSimIcon(String string) {
        return guiUtil.loadIcon("pyrosim/icons/" + string);
    }

    public static ImageIcon loadPyroSimIcon(String string, int n) {
        return guiUtil.loadIcon("pyrosim/icons/" + string, n);
    }

    public static void pack(Component component) {
        JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, component);
        if (jDialog != null) {
            jDialog.pack();
        }
    }

    public static IImage loadTeciImage(String string) {
        return ImageManager.getImage(string, 3, 0);
    }

    public static void initButton(AbstractButton abstractButton, Material material) {
        if (material != null) {
            abstractButton.setToolTipText(material.getName());
        } else {
            abstractButton.setToolTipText(null);
        }
    }

    public static void initButton(AbstractButton abstractButton, Material material, int n, int n2) {
        guiUtil.initButton(abstractButton, material, n, n2);
        PyroGuiUtil.initButton(abstractButton, material);
    }

    public static String format(UnitDouble unitDouble, int n) {
        UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
        Unit unit = unitSystem.getUnit(n);
        return Global.format(unitDouble.convert(unit));
    }

    public static Window getWindow(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    public static ButtonGroup groupButtons(Collection<? extends AbstractButton> collection) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : collection) {
            buttonGroup.add(abstractButton);
        }
        return buttonGroup;
    }

    public static String encodeToHtmlLabel(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return "<html>" + string.replace("\n", "<br>");
    }

    public static <T> T ui(Callable<T> callable) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                return callable.call();
            }
            Object[] objectArray = new Object[1];
            EventQueue.invokeAndWait(() -> {
                objectArray[0] = PyroGuiUtil.call(callable);
            });
            return (T)objectArray[0];
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Throwable throwable) {
            PyroGuiUtil.crash(throwable);
            return null;
        }
    }

    public static void ui(Runnable runnable) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Throwable throwable) {
            PyroGuiUtil.crash(throwable);
        }
    }

    private static <T> T call(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Throwable throwable) {
            PyroGuiUtil.crash(throwable);
            return null;
        }
    }

    public static void crash(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throw new RuntimeException(throwable);
    }

    public static Dimension determineMinimumTabbedPaneSize(guiPanel ... guiPanelArray) {
        Dimension dimension = new Dimension(0, 0);
        for (guiPanel guiPanel2 : guiPanelArray) {
            Dimension dimension2 = guiPanel2.getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(null, "MMMM");
        Dimension dimension3 = jTabbedPane.getPreferredSize();
        dimension.width += dimension3.width;
        dimension.height += dimension3.height;
        return dimension;
    }

    public static class ActionCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null && object instanceof guiAction) {
                this.setIcon(((guiAction)object).getIcon());
                this.setText(((guiAction)object).getName());
            }
            return this;
        }
    }
}

