/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.io.fds.FDSRenderProps;

public class PromptingFDSRenderProps
extends FDSRenderProps {
    private final PyroMod d_model;
    private boolean d_expandPrompted;
    private boolean d_linkPyroGeomPrompted;

    public PromptingFDSRenderProps(PyroMod pyroMod, FDSRenderProps fDSRenderProps) {
        this.imprint(fDSRenderProps);
        this.d_model = pyroMod;
        this.d_expandPrompted = false;
        this.d_linkPyroGeomPrompted = false;
    }

    @Override
    public boolean expandBoundaryHoles() {
        if (!this.d_expandPrompted) {
            String string = Intl.intl("PyroSim has detected a hole touching a mesh boundary, which\nmay cause cutting problems in FDS.  Would you like to slightly\nexpand these types of holes?");
            int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), string, Intl.intl("Expand Boundary Holes?"), 0);
            boolean bl = n == 0;
            super.setExpandBoundaryHoles(bl);
            this.d_expandPrompted = true;
        }
        return super.expandBoundaryHoles();
    }

    @Override
    public boolean getLinkPyroGeom() {
        boolean bl = super.getLinkPyroGeom();
        if (!this.d_linkPyroGeomPrompted && !bl) {
            JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("The additional records section contains OBST, VENT, and/or HOLE records.\nThese objects will not appear in the PyroSim Geometry file and will prevent\nthe geometry file from containing activation logic."), Intl.intl("Geometry in Additional Records"), 2);
            this.d_linkPyroGeomPrompted = true;
        }
        return bl;
    }
}

