/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public class ProcessUtil {
    public static ProcessResult run(Process process) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Thread thread = new Thread(ProcessUtil.createOutputConsumer(stringBuffer, process.getErrorStream()));
        Thread thread2 = new Thread(ProcessUtil.createOutputConsumer(stringBuffer2, process.getInputStream()));
        thread.start();
        thread2.start();
        int n = process.waitFor();
        thread.join();
        thread2.join();
        return new ProcessResult(n, stringBuffer2.toString(), stringBuffer.toString(), true);
    }

    public static ProcessResult run(Process process, int n) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Thread thread = new Thread(ProcessUtil.createOutputConsumer(stringBuffer, process.getErrorStream()));
        Thread thread2 = new Thread(ProcessUtil.createOutputConsumer(stringBuffer2, process.getInputStream()));
        thread.start();
        thread2.start();
        boolean bl = process.waitFor(n, TimeUnit.SECONDS);
        int n2 = 0;
        try {
            n2 = process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            n2 = -1;
        }
        thread.join((n + 1) * 1000);
        thread2.join((n + 1) * 1000);
        return new ProcessResult(n2, stringBuffer2.toString(), stringBuffer.toString(), bl);
    }

    private static Runnable createOutputConsumer(StringBuffer stringBuffer, InputStream inputStream) {
        return () -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(string + System.lineSeparator());
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
    }

    public static void main(String[] stringArray) {
        ProcessBuilder processBuilder = new ProcessBuilder("C:/Users/thornton/Documents/p4root/PyroSim/fds/mpiexec.exe", "hostname");
        processBuilder.directory(new File("C:/Users/thornton/Documents/p4root/PyroSim/fds/"));
        ProcessResult processResult = null;
        try {
            processResult = ProcessUtil.run(processBuilder.start());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (processResult != null) {
            System.out.println(processResult);
        }
    }

    public static class ProcessResult {
        public final int exitCode;
        public final String stdout;
        public final String stderr;
        public final boolean success;

        public ProcessResult(int n, String string, String string2, boolean bl) {
            this.exitCode = n;
            this.stdout = string;
            this.stderr = string2;
            this.success = bl;
        }

        public String toString() {
            return String.format("ProcessResult[exitCode=%s, stdout=\"%s\", stderr=\"%s\"]", this.exitCode, this.stdout, this.stderr);
        }
    }
}

