/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.NonSI;
import pyrosim.FDSVersion;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.Version;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TypedProp;

public class PreferencesDialog
extends guiDialog {
    private static final long serialVersionUID = -6104217703945371899L;
    private final Map<Tabs, PrefsPanel> d_tabPanels;
    private final PyroMod d_pyroMod;

    public PreferencesDialog(Supplier<IPropertySet> supplier, Supplier<IPropertySet> supplier2) {
        this(supplier, supplier2, Tabs.PYROSIM);
    }

    public PreferencesDialog(Supplier<IPropertySet> supplier, Supplier<IPropertySet> supplier2, Tabs tabs2) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Preferences"), 9);
        PyroSim pyroSim = (PyroSim)Application.getApp();
        this.d_pyroMod = pyroSim.getMediator();
        JTabbedPane jTabbedPane = new JTabbedPane();
        HashMap hashMap = new HashMap();
        this.d_tabPanels = new LinkedHashMap<Tabs, PrefsPanel>();
        BiConsumer<Tabs, PrefsPanel> biConsumer = (tabs, prefsPanel) -> {
            this.d_tabPanels.put((Tabs)((Object)tabs), (PrefsPanel)prefsPanel);
            prefsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            int n = jTabbedPane.getTabCount();
            jTabbedPane.add(tabs.desc, (Component)prefsPanel);
            hashMap.put(tabs, n);
        };
        biConsumer.accept(Tabs.PYROSIM, new PyroSimPanel());
        biConsumer.accept(Tabs.RECORDVIEW, new RecordViewPanel());
        biConsumer.accept(Tabs.FDS, new FDSPanel());
        biConsumer.accept(Tabs.RESULTS, new ResultsPanel());
        PyroSim pyroSim2 = PyroSim.getApp();
        Supplier<IRenderSurface.OpenGLInfo> supplier3 = () -> pyroSim2.get3DView().getRenderComp().getOpenGLInfo();
        biConsumer.accept(Tabs.RENDERING, new DisplayPanel(supplier, supplier2, supplier3));
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.add((Component)jTabbedPane, "Center");
        this.loadValues();
        jTabbedPane.setSelectedIndex((Integer)hashMap.get((Object)tabs2));
    }

    public void loadValues() {
        for (PrefsPanel prefsPanel : this.d_tabPanels.values()) {
            prefsPanel.loadData();
        }
    }

    public void saveData() {
        this.d_pyroMod.pauseUpdates();
        for (PrefsPanel prefsPanel : this.d_tabPanels.values()) {
            prefsPanel.saveData();
        }
        PyroSim.getApp().superSavePreferences();
        this.d_pyroMod.resumeUpdates();
    }

    public static <T> void setPref(TypedProp<T> typedProp, T t) {
        PyroSim.setPref(typedProp, t, false);
    }

    public static void setPref(PyroPrefs.UDProp uDProp, UnitDouble unitDouble) {
        PyroSim.setPref(uDProp, unitDouble.getValue(uDProp.d_storeUnit), false);
    }

    private static class ExeFileChooserPanel {
        private static final Icon OPEN_ICON = PyroGuiUtil.loadTeciIcon("Open16.gif");
        private final guiPanel d_parent;
        private final String d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private final JButton d_locationBtn;
        private final guiLabel d_versionLbl;

        public ExeFileChooserPanel(guiPanel guiPanel2, String string, String string2) {
            this(guiPanel2, string, string2, false);
        }

        public ExeFileChooserPanel(final guiPanel guiPanel2, String string, String string2, final boolean bl) {
            this.d_parent = guiPanel2;
            this.d_preferenceKey = string;
            this.d_label = new guiLabel(string2);
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(35);
            this.d_locationBtn = new JButton(OPEN_ICON);
            this.d_locationBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.getFile(guiPanel2);
                    if (bl) {
                        this.detectFDSVersion(d_locationTF.getText());
                    }
                }
            });
            if (bl) {
                this.d_versionLbl = new guiLabel(Version.FDS_DESIGN.toString());
                Dimension dimension = this.d_versionLbl.getPreferredSize();
                this.d_versionLbl.setPreferredSize(new Dimension(dimension.width * 11 / 10, dimension.height));
                this.d_versionLbl.setToolTipText(this.d_versionLbl.getText());
                this.d_versionLbl.setText("");
            } else {
                this.d_versionLbl = null;
            }
        }

        private void detectFDSVersion(String string) {
            if (this.d_versionLbl != null) {
                this.d_parent.beginWaitCursor();
                File file = new File(string);
                try {
                    FDSVersion fDSVersion = FDSVersion.detectCompability(file, 1000);
                    this.d_versionLbl.setText(fDSVersion.toString());
                    this.d_versionLbl.setToolTipText(this.d_versionLbl.getText());
                }
                catch (IOException iOException) {
                    this.d_versionLbl.setText(Intl.intl("Version: ?"));
                    this.d_versionLbl.setToolTipText(iOException.getClass().getSimpleName() + ": " + iOException.getLocalizedMessage());
                }
                this.d_parent.endWaitCursor();
            }
        }

        public void addToPanel(GridBagHelper gridBagHelper) {
            gridBagHelper.addIdentRow(this.d_label, this.d_locationTF, 1.0, this.d_locationBtn, this.d_versionLbl);
        }

        public void load(PyroSim pyroSim) {
            String string = PyroPrefs.getFDSLoc(this.d_preferenceKey, true);
            if (string == null) {
                string = "";
            }
            this.d_locationTF.setText(string);
            this.detectFDSVersion(string);
        }

        public void save(PyroSim pyroSim) {
            String string = this.d_locationTF.getText();
            PyroPrefs.setFDSLoc(this.d_preferenceKey, string);
            PyroSim.getApp().getMediator().changedEvt(PyroMod.EVT_PREFS_CHANGED);
        }

        public void getFile(guiPanel guiPanel2) {
            File file = PyroSim.getFilenames().getOpenFile((Component)guiPanel2, new File(this.d_locationTF.getText()), "exe", Intl.intl("Executable Files"));
            if (file == null) {
                return;
            }
            this.d_locationTF.setText(file.getAbsolutePath());
        }
    }

    private static class ResultsPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 3807312583474227091L;
        private final guiCheckBox d_showInCad;
        private final guiCheckBox d_showMesh;
        private final guiCheckBox d_writePyroGeom;
        private final guiCheckBox d_writeGE1;
        private final guiCheckBox d_writeIni;
        private final guiCheckBox d_writeViews;

        public ResultsPanel() {
            super(new GridBagLayout());
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Initialization"));
            this.d_showInCad = new guiCheckBox(Intl.intl("Show GE1 file by default"));
            this.d_showInCad.setToolTipText(Intl.intl("Shows the GE1 file immediately when Smokeview is launched"));
            this.d_showMesh = new guiCheckBox(Intl.intl("Include mesh boundaries in CAD files"));
            this.d_showMesh.setToolTipText(Intl.intl("Whether to include the mesh boundaries in exported CAD files (GE1, PyroGeom)"));
            this.d_writePyroGeom = new guiCheckBox(Intl.intl("Output PyroGeom file"));
            this.d_writePyroGeom.setToolTipText("<html>" + Intl.intl("Outputs a CAD data file for the PyroSim 3D Results"));
            this.d_writeGE1 = new guiCheckBox(Intl.intl("Output GE1 file"));
            this.d_writeGE1.setToolTipText("<html>" + Intl.intl("Outputs a CAD data file for Smokeview (also viewable in the PyroSim 3D Results)."));
            this.d_writeIni = new guiCheckBox(Intl.intl("Output INI file"));
            this.d_writeIni.setToolTipText("<html>" + Intl.intl("Writes the Smokeview INI file (NOTE: view information is only<br>included if the Views file is turned off)."));
            this.d_writeViews = new guiCheckBox(Intl.intl("Output Views file"));
            this.d_writeViews.setToolTipText(Intl.intl("Writes the Views file for PyroSim 3D Results, containing view information."));
            guiUtil.link((AbstractButton)this.d_writeGE1, this.d_showInCad);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(titleSeparator);
            gridBagHelper.addIdentRow(this.d_showMesh);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("PyroSim 3D Results Files")));
            gridBagHelper.indent();
            gridBagHelper.addRow(this.d_writeViews);
            gridBagHelper.addRow(this.d_writePyroGeom);
            gridBagHelper.unindent();
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Smokeview Files")));
            gridBagHelper.indent();
            gridBagHelper.addRow(this.d_writeIni);
            gridBagHelper.addRow(this.d_writeGE1);
            gridBagHelper.addIdentRow(this.d_showInCad);
            gridBagHelper.unindent();
            gridBagHelper.finalizeRows();
        }

        @Override
        public void loadData() {
            this.d_showInCad.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1));
            this.d_showMesh.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS));
            this.d_writePyroGeom.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM));
            this.d_writeGE1.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEGE1));
            this.d_writeIni.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITESMVINI));
            this.d_writeViews.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS));
        }

        @Override
        public void saveData() {
            PreferencesDialog.setPref(PyroPrefs.RESULTS_DISPLAYGE1, this.d_showInCad.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_MESHBOUNDS, this.d_showMesh.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEPYROGEOM, this.d_writePyroGeom.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEGE1, this.d_writeGE1.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITESMVINI, this.d_writeIni.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEVIEWS, this.d_writeViews.isSelected());
        }
    }

    private static class FDSPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 2220889344058346621L;
        private final guiComboBox<FDSVersion> d_fdsCompCB;
        private final ExeFileChooserPanel d_svExe;
        private final ExeFileChooserPanel d_fdsExe;
        private final guiCheckBox d_autosaveFileOnRun;
        private final guiCheckBox d_runSV;

        public FDSPanel() {
            super(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel("FDS Compability:");
            this.d_fdsCompCB = new guiComboBox<FDSVersion>(FDSVersion.getSupported());
            boolean bl = PyroSim.is64Bit();
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Executable Locations") + (bl ? " (x64)" : ""));
            TitleSeparator titleSeparator2 = new TitleSeparator(Intl.intl("Execution"));
            this.d_autosaveFileOnRun = new guiCheckBox(Intl.intl("Auto-save PyroSim model before running FDS"), false);
            this.d_runSV = new guiCheckBox(Intl.intl("Run Results when FDS simulation completes"), true);
            guiLabel guiLabel3 = new guiLabel(String.format(Intl.intl("NOTE: PyroSim is designed to work with FDS %s and later."), Version.FDS_DESIGN));
            guiLabel3.setFont(guiLabel3.getFont().deriveFont(1));
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(titleSeparator);
            this.d_svExe = new ExeFileChooserPanel(this, "sv.location", Intl.intl("Smokeview:"));
            this.d_fdsExe = new ExeFileChooserPanel(this, "location", Intl.intl("FDS:"), true);
            this.d_fdsExe.addToPanel(gridBagHelper);
            this.d_svExe.addToPanel(gridBagHelper);
            gridBagHelper.addIdentRow(guiLabel3, GridBagHelper.REMAINING);
            gridBagHelper.addFilledRow(titleSeparator2);
            gridBagHelper.addIdentRow(this.d_autosaveFileOnRun, 0);
            if (this.d_fdsCompCB.getModel().getSize() > 1) {
                gridBagHelper.addIdentRow(guiLabel2, this.d_fdsCompCB);
            }
            gridBagHelper.addIdentRow(this.d_runSV, 0);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void loadData() {
            PyroSim pyroSim = PyroSim.getApp();
            this.d_fdsCompCB.setSelectedItem(pyroSim.getFDSCompability());
            this.d_fdsExe.load(pyroSim);
            this.d_svExe.load(pyroSim);
            this.d_autosaveFileOnRun.setSelected(PyroPrefs.getBoolean(PyroPrefs.AUTOSAVE_ON_RUN_FDS));
            boolean bl = PyroPrefs.getBoolean(PyroPrefs.PREF_RUNSV);
            this.d_runSV.setSelected(bl);
        }

        @Override
        public void saveData() {
            PyroSim pyroSim = PyroSim.getApp();
            pyroSim.setFDSCompability(this.d_fdsCompCB.getSelectedItem());
            this.d_fdsExe.save(pyroSim);
            this.d_svExe.save(pyroSim);
            PreferencesDialog.setPref(PyroPrefs.AUTOSAVE_ON_RUN_FDS, this.d_autosaveFileOnRun.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_RUNSV, this.d_runSV.isSelected());
        }
    }

    private static class RecordViewPanel
    extends PrefsPanel {
        private static final long serialVersionUID = -6926992930099772676L;
        private guiComboBox d_fontSizeCombo;
        private guiCheckBox d_enableSyntaxHi;

        public RecordViewPanel() {
            super(new GridBagLayout());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Font Size:"));
            String[] stringArray = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36"};
            this.d_fontSizeCombo = new guiComboBox(Arrays.asList(stringArray)){
                private static final long serialVersionUID = -3857544167298911010L;

                @Override
                public boolean validateData(boolean bl, boolean bl2) {
                    super.validateData(bl, bl2);
                    try {
                        float f = Float.parseFloat(this.getSelectedItem() + "");
                        if ((double)f < 1.0) {
                            throw new Exception("Invalid font size.");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (bl) {
                            String string = String.format(Intl.intl("Invalid font size."), new Object[0]);
                            this.showMessageBox(string);
                            this.requestFocusHack();
                        }
                        return false;
                    }
                    return true;
                }
            };
            this.d_fontSizeCombo.setEditable(true);
            gridBagHelper.addRow(guiLabel2, 2, this.d_fontSizeCombo);
            this.d_enableSyntaxHi = new guiCheckBox(Intl.intl("Enable Syntax Highlighting"));
            gridBagHelper.addRow(this.d_enableSyntaxHi, 3);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void loadData() {
            float f = PyroPrefs.getFloat(PyroPrefs.RECORD_VIEW_FONTSIZE);
            this.d_fontSizeCombo.setSelectedItem(Float.valueOf(f));
            boolean bl = PyroPrefs.getBoolean(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE);
            this.d_enableSyntaxHi.setSelected(bl);
        }

        @Override
        public void saveData() {
            PreferencesDialog.setPref(PyroPrefs.RECORD_VIEW_FONTSIZE, Float.valueOf(Float.parseFloat("" + this.d_fontSizeCombo.getSelectedItem())));
            PreferencesDialog.setPref(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE, this.d_enableSyntaxHi.isSelected());
        }
    }

    private static class PyroSimPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 2460256735511807191L;
        private final guiCheckBox d_easyReadFormatBox;
        private final ValueField<Integer> d_easyReadPrecision;
        private final ValueField<Integer> d_numMRUFiles;
        private final guiCheckBox d_autosave;
        private final ValueField<UnitDouble> d_autosaveInterval;
        private final guiCheckBox d_createBackupOnOpen;
        private final guiCheckBox d_recordPreview;
        private final guiCheckBox d_showSplash;

        public PyroSimPanel() {
            super(new GridBagLayout());
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("FDS File Format"));
            this.d_easyReadFormatBox = new guiCheckBox(Intl.intl("Format FDS file for easy reading"));
            this.d_easyReadPrecision = ValueFields.intFld(IntVR.above(2, true));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Max precision:"));
            LinkStatus.link((AbstractButton)this.d_easyReadFormatBox, this.d_easyReadPrecision, guiLabel2);
            TitleSeparator titleSeparator2 = new TitleSeparator(Intl.intl("Options"));
            this.d_numMRUFiles = ValueFields.intFld(IntVR.between(1, 30, true, true));
            this.d_autosave = new guiCheckBox(Intl.intl("Autosave:"));
            UnitDouble unitDouble = new UnitDouble(10.0, NonSI.MINUTE);
            UnitDoubleVR unitDoubleVR = UnitDoubleVR.above(new UnitDouble(0.0, NonSI.MINUTE), false);
            this.d_autosaveInterval = ValueFields.udFld(unitDouble, unitDoubleVR, UnitSystem.getSource(2));
            LinkStatus.link((AbstractButton)this.d_autosave, this.d_autosaveInterval);
            this.d_createBackupOnOpen = new guiCheckBox(Intl.intl("Create Backup on Open"));
            this.d_recordPreview = new guiCheckBox(Intl.intl("Record Preview"));
            this.d_showSplash = new guiCheckBox(Intl.intl("Show Splash Screen on Startup"));
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(titleSeparator);
            gridBagHelper.addIdentRow(this.d_easyReadFormatBox, 0);
            gridBagHelper.indent();
            gridBagHelper.addIdentRow(guiLabel2, this.d_easyReadPrecision);
            gridBagHelper.unindent();
            gridBagHelper.addFilledRow(titleSeparator2);
            gridBagHelper.addIdentRow(new guiLabel(Intl.intl("Number of Recent Files:")), this.d_numMRUFiles);
            gridBagHelper.addIdentRow(this.d_autosave, this.d_autosaveInterval);
            gridBagHelper.addIdentRow(this.d_createBackupOnOpen, 0);
            gridBagHelper.addIdentRow(this.d_recordPreview, 0);
            gridBagHelper.addIdentRow(this.d_showSplash, 0);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void loadData() {
            PyroSim pyroSim = PyroSim.getApp();
            FDSRenderProps fDSRenderProps = pyroSim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter iDecimalFormatter = fDSRenderProps.getDecimalFormatter();
            this.d_easyReadFormatBox.setSelected(iDecimalFormatter instanceof FDSRenderProps.GeneralFormatter);
            if (iDecimalFormatter instanceof FDSRenderProps.GeneralFormatter) {
                this.d_easyReadPrecision.setValue(((FDSRenderProps.GeneralFormatter)iDecimalFormatter).precision);
            } else {
                this.d_easyReadPrecision.setValue(PyroPrefs.getInt(PyroPrefs.FDSFormatGenPrecision));
            }
            this.d_numMRUFiles.setValue(pyroSim.getMRUMenu().getNumMenuItems());
            this.d_autosave.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_USEAUTOSAVE));
            this.d_autosaveInterval.setValue(PyroPrefs.getUnitDouble(PyroPrefs.PREF_AUTOSAVE_INTERVAL));
            this.d_createBackupOnOpen.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN));
            this.d_recordPreview.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW));
            this.d_showSplash.setSelected(pyroSim.getPrefs().getBoolean(Application.PROP_SHOWSPLASH));
        }

        @Override
        public void saveData() {
            PyroSim pyroSim = PyroSim.getApp();
            FDSRenderProps fDSRenderProps = pyroSim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter iDecimalFormatter = this.d_easyReadFormatBox.isSelected() ? new FDSRenderProps.GeneralFormatter((Integer)this.d_easyReadPrecision.getValue()) : new FDSRenderProps.ScientificFormatter();
            fDSRenderProps.setDecimalFormatter(iDecimalFormatter);
            pyroSim.getMRUMenu().setNumMenuItems((Integer)this.d_numMRUFiles.getValue());
            PreferencesDialog.setPref(PyroPrefs.PREF_USEAUTOSAVE, this.d_autosave.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_AUTOSAVE_INTERVAL, (UnitDouble)this.d_autosaveInterval.getValue());
            PreferencesDialog.setPref(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN, this.d_createBackupOnOpen.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_RECORD_PREVIEW, this.d_recordPreview.isSelected());
            PreferencesDialog.setPref(Application.PROP_SHOWSPLASH, this.d_showSplash.isSelected());
        }
    }

    private static class DisplayPanel
    extends PrefsPanel {
        private static final long serialVersionUID = -1830210112889756964L;
        private final guiCheckBox d_useFastColorRedraws = new guiCheckBox(Intl.intl("Hardware accelerated cursor"), false);
        private final guiCheckBox d_useFastDepthRedraws;
        private final guiCheckBox d_useVertexBuffers;
        private final guiComboBox<Boolean> d_sceneGeomRender;

        public DisplayPanel(Supplier<IPropertySet> supplier, Supplier<IPropertySet> supplier2, Supplier<IRenderSurface.OpenGLInfo> supplier3) {
            super(new GridBagLayout());
            this.d_useFastColorRedraws.setToolTipText(Intl.intl("Accelerates drawing and editing objects in complex models."));
            this.d_useFastDepthRedraws = new guiCheckBox(Intl.intl("Hardware accelerated 3D editing (only available on some hardware)"), false);
            this.d_useVertexBuffers = new guiCheckBox(Intl.intl("Hardware accelerated vertex buffers"));
            this.d_useVertexBuffers.setToolTipText(Intl.intl("Can greatly improve performance in the 3D and 2D Views"));
            this.d_sceneGeomRender = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Use Hardware Shaders"), false, Intl.intl("Use Compatibility Renderer"));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Scene Geometry:"));
            guiLabel2.setToolTipText("<html>" + Intl.intl("Determines how scene geometry is rendered.<br><b>Use Hardware Shaders</b>: Improves shading quality and may improve rendering performance with some GPUs.<br><b>Use Compatibility Renderer</b>: For use on older GPUs."));
            LinkStatus.link((AbstractButton)this.d_useFastColorRedraws, this.d_useFastDepthRedraws);
            this.d_useFastColorRedraws.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!d_useFastColorRedraws.isSelected()) {
                        d_useFastDepthRedraws.setSelected(false);
                    }
                }
            });
            Consumer<IPropertySet> consumer = iPropertySet -> this.loadData((IPropertySet)iPropertySet, true);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addTitle(Intl.intl("GPU Information"));
            gridBagHelper.addIdentRow(new GPUInfoPnl(supplier3, true), 1.0, 0);
            gridBagHelper.addSeparator();
            gridBagHelper.addRow(new Object[]{guiUtil.getRenderPrefsBtns(supplier, supplier2, consumer), 1.0, 0, GridBagHelper.Anchor.CENTER});
            gridBagHelper.addIdentRow(this.d_useFastColorRedraws, 0);
            gridBagHelper.addIdentRow(this.d_useVertexBuffers, 0);
            gridBagHelper.addIdentRow(guiLabel2, this.d_sceneGeomRender);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void loadData() {
            this.loadData(PyroPrefs.instance(), false);
        }

        private void loadData(IPropertySet iPropertySet, boolean bl) {
            guiUtil.loadPref(iPropertySet, bl, this.d_useFastColorRedraws, PyroPrefs.PREF_DRAWCOLORBUFFER);
            guiUtil.loadPref(iPropertySet, bl, this.d_useFastDepthRedraws, PyroPrefs.PREF_DRAWDEPTHBUFFER);
            guiUtil.loadPref(iPropertySet, bl, this.d_useVertexBuffers, PyroPrefs.PREF_USEVERTEXBUFFERS);
            guiUtil.loadPref(iPropertySet, bl, this.d_sceneGeomRender, PyroPrefs.PREF_SCENESHADERS);
        }

        @Override
        public void saveData() {
            PreferencesDialog.setPref(PyroPrefs.PREF_DRAWCOLORBUFFER, this.d_useFastColorRedraws.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_DRAWDEPTHBUFFER, this.d_useFastDepthRedraws.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_USEVERTEXBUFFERS, this.d_useVertexBuffers.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_SCENESHADERS, this.d_sceneGeomRender.getSelectedItem());
        }
    }

    public static enum Tabs {
        PYROSIM(Intl.intl("PyroSim")),
        RECORDVIEW(Intl.intl("Record View")),
        FDS(Intl.intl("FDS")),
        RESULTS(Intl.intl("Results")),
        RENDERING(Intl.intl("Rendering"));

        public final String desc;

        private Tabs(String string2) {
            this.desc = string2;
        }
    }

    private static abstract class PrefsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1906931603730818333L;

        public PrefsPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public abstract void loadData();

        public abstract void saveData();
    }
}

