/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.SimParams;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Task;

public class OpenMpDlg
extends guiDialog {
    private static final long serialVersionUID = -1847785594784618830L;
    private final guiCheckBox d_ompThreadsCk = new guiCheckBox(Intl.intl("OpenMP Threads:"));
    private final guiTextField d_ompThreads;
    private final guiCheckBox d_ompThreadsMPICk;
    private final guiTextField d_ompThreadsMPI;
    private final guiCheckBox d_ompStackCk;
    private final guiTextField d_ompStack;

    public OpenMpDlg(Window window) {
        super(window, Intl.intl("OpenMP Environment"), 9);
        String string = String.format(Intl.intl("OMP_NUM_THREADS - When running single-process (non-MPI) simulations."), new Object[0]);
        this.d_ompThreadsCk.setToolTipText(string);
        this.d_ompThreads = new guiTextField();
        this.d_ompThreads.setMinChars(1);
        this.d_ompThreads.setRangeCheck(true);
        LinkStatus.link((AbstractButton)this.d_ompThreadsCk, this.d_ompThreads);
        this.d_ompThreadsMPICk = new guiCheckBox(Intl.intl("OpenMP Threads MPI:"));
        this.d_ompThreadsMPICk.setToolTipText(Intl.intl("OMP_NUM_THREADS - When running multi-process (MPI) simulations."));
        this.d_ompThreadsMPI = new guiTextField();
        this.d_ompThreadsMPI.setMinChars(1);
        this.d_ompThreadsMPI.setRangeCheck(true);
        LinkStatus.link((AbstractButton)this.d_ompThreadsMPICk, this.d_ompThreadsMPI);
        this.d_ompStackCk = new guiCheckBox(Intl.intl("OpenMP Stack:"));
        this.d_ompStackCk.setToolTipText(Intl.intl("OMP_STACKSIZE - Limit thread stack size."));
        this.d_ompStack = new guiTextField();
        this.d_ompStack.setMinChars(1);
        this.d_ompStack.setRangeCheck(true);
        LinkStatus.link((AbstractButton)this.d_ompStackCk, this.d_ompStack);
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, this.d_ompThreadsCk, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_ompThreads, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_ompThreadsMPICk, 0, 1, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_ompThreadsMPI, 1, 1, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_ompStackCk, 0, 2, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_ompStack, 1, 2, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(guiPanel2);
    }

    public Task getSaveTask(final SimParams.OpenMp openMp) {
        return new AOneTimeTask(){

            @Override
            public void run() {
                openMp.setOmpNumThreadsFlag(OpenMpDlg.this.d_ompThreadsCk.isSelected());
                openMp.setOmpNumThreads(OpenMpDlg.this.d_ompThreads.getValue());
                openMp.setOmpNumThreadsMPIFlag(OpenMpDlg.this.d_ompThreadsMPICk.isSelected());
                openMp.setOmpNumThreadsMPI(OpenMpDlg.this.d_ompThreadsMPI.getValue());
                openMp.setOmpStacksizeFlag(OpenMpDlg.this.d_ompStackCk.isSelected());
                openMp.setOmpStacksize(OpenMpDlg.this.d_ompStack.getValue());
            }
        };
    }

    public void initFrom(SimParams.OpenMp openMp) {
        this.d_ompThreadsCk.setSelected(openMp.getOmpNumThreadsFlag());
        this.d_ompThreads.setValue(openMp.getOmpNumThreads());
        this.d_ompThreadsMPICk.setSelected(openMp.getOmpNumThreadsMPIFlag());
        this.d_ompThreadsMPI.setValue(openMp.getOmpNumThreadsMPI());
        this.d_ompStackCk.setSelected(openMp.getOmpStacksizeFlag());
        this.d_ompStack.setValue(openMp.getOmpStacksize());
    }
}

