/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewTypeDlg<ObjT extends IPyroObject, TypeT>
extends guiDialog {
    private static final long serialVersionUID = 2559290931720333058L;
    private final Composite<ObjT> d_mgr;
    private final guiTextField d_nameFld;
    private final guiComboBox<TypeT> d_typeCB;
    private final ItemListener d_suggestNameListener;
    private final DocumentListener d_nameListener;

    public NewTypeDlg(Window window, String string, Composite<ObjT> composite, String string2, guiComboBox<TypeT> guiComboBox2) {
        super(window, string, 9);
        this.d_mgr = composite;
        this.d_nameFld = new guiTextField();
        this.d_typeCB = guiComboBox2;
        this.d_suggestNameListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NewTypeDlg.this.suggestName();
            }
        };
        this.d_nameListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            public void changed() {
                NewTypeDlg.this.d_typeCB.removeItemListener(NewTypeDlg.this.d_suggestNameListener);
                NewTypeDlg.this.d_nameFld.getDocument().removeDocumentListener(this);
            }
        };
        this.d_nameFld.getDocument().addDocumentListener(this.d_nameListener);
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Name:"));
        guiLabel guiLabel3 = new guiLabel(string2);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, 0, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_typeCB, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel2, 0, 1, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_nameFld, 1, 1, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
    }

    public Composite<ObjT> getManager() {
        return this.d_mgr;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.d_typeCB.addItemListener(this.d_suggestNameListener);
            this.suggestName();
        } else {
            this.d_typeCB.removeItemListener(this.d_suggestNameListener);
        }
        super.setVisible(bl);
    }

    protected void suggestName() {
        this.d_nameFld.getDocument().removeDocumentListener(this.d_nameListener);
        TypeT TypeT = this.d_typeCB.getSelectedItem();
        String string = this.getNameSuggestion((PyroMod)this.d_mgr.getDomain(), TypeT);
        this.d_nameFld.setText(string);
        this.d_nameFld.getDocument().addDocumentListener(this.d_nameListener);
    }

    protected String getNameSuggestion(PyroMod pyroMod, TypeT TypeT) {
        return TypeT.toString();
    }

    protected void validateName(PyroMod pyroMod, TypeT TypeT, String string) throws Exception {
    }

    public String getSelectedName() {
        return this.d_nameFld.getText().trim();
    }

    public TypeT getSelectedType() {
        return this.d_typeCB.getSelectedItem();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        String string = this.d_nameFld.getText();
        if (string.length() < 1) {
            String string2 = Intl.intl("A name must be specified.");
            this.showMessageBox(string2);
            this.requestFocusHack();
            return false;
        }
        try {
            this.validateName((PyroMod)this.d_mgr.getDomain(), this.d_typeCB.getSelectedItem(), string);
        }
        catch (Exception exception) {
            String string3 = exception.getLocalizedMessage();
            this.showMessageBox(string3);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    protected static class NameInUseException
    extends Exception {
        private static final long serialVersionUID = -7782920107540813641L;

        public NameInUseException() {
            super(Intl.intl("Name already in use. Each name must be unique."));
        }
    }
}

