/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewDlg<T extends INamed>
extends guiDialog {
    private static final long serialVersionUID = 5381656238273106373L;
    private final IPyroObject d_mgr;
    private final Class<T> d_type;
    private final guiTextField d_name;
    private final String d_typeDesc;
    private Set<String> d_reservedNames;

    public NewDlg(IPyroObject iPyroObject, Class<T> clazz, String string) {
        super((Window)Application.getApp().getActiveFrame(), String.format(Intl.intl("New %s"), string), 9);
        this.d_mgr = iPyroObject;
        this.d_typeDesc = string;
        this.d_type = clazz;
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Name") + ":"), 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_name, 1, 0, 1, 1, 0, 0, 6, 0);
    }

    public void addReservedName(String string) {
        if (this.d_reservedNames == null) {
            this.d_reservedNames = new HashSet<String>();
        }
        this.d_reservedNames.add(string);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        String string = this.d_name.getText();
        if (this.d_name.getText().length() < 1) {
            String string2 = String.format(Intl.intl("You must name the %s."), this.d_typeDesc);
            this.showMessageBox(string2);
            this.d_name.requestFocus();
            this.d_name.selectAll();
            return false;
        }
        if (((PyroMod)this.d_mgr.getDomain()).getNames(this.d_type).isRegistered(string)) {
            String string3 = Intl.intl("Name already in use.") + "\n" + String.format(Intl.intl("Each %s must have a unique name."), this.d_typeDesc);
            this.showMessageBox(string3);
            this.d_name.requestFocus();
            this.d_name.selectAll();
            return false;
        }
        if (this.d_reservedNames != null && this.d_reservedNames.contains(string)) {
            String string4 = Intl.intl("This name is reserved.  Please choose another.");
            this.showMessageBox(string4);
            this.d_name.requestFocus();
            this.d_name.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_mgr.getDomain()).getNames(this.d_type).generateName();
    }

    private boolean nameInUse(String string) {
        return ((PyroMod)this.d_mgr.getDomain()).getNames(this.d_type).isRegistered(string);
    }
}

