/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import pyrosim.Intl;
import pyrosim.gui.ProcessUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class MpiUtil {
    public static void scrubEnvMpi(Map<String, String> map) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"MPIEXEC_PORT_RANGE", "MPICH_PORT_RANGE"}) {
            if (!map.containsKey(string)) continue;
            map.remove(string);
        }
    }

    public static int testHydraServiceReady(Window window, File file) {
        File file2 = new File(file.getParentFile(), "hydra_service.exe");
        ProcessBuilder processBuilder = new ProcessBuilder(file2.getPath(), "-status");
        MpiUtil.scrubEnvMpi(processBuilder.environment());
        try {
            ProcessUtil.ProcessResult processResult = ProcessUtil.run(processBuilder.start());
            if (processResult.stderr.isEmpty()) {
                return 0;
            }
            throw new Exception(processResult.stderr);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Intl.intl("Error connecting to MPI process manager (hydra service):"));
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(exception.getLocalizedMessage());
            exception.printStackTrace();
            return JOptionPane.showOptionDialog(window, stringBuffer.toString(), Intl.intl("Hydra Service Warning"), 2, 2, null, new String[]{Intl.intl("Ignore"), Intl.intl("Cancel")}, Intl.intl("Ignore"));
        }
    }

    public static boolean testMpiCredentialsPresent(Window window, File file) {
        ProcessBuilder processBuilder = new ProcessBuilder(file.getPath(), "-validate");
        MpiUtil.scrubEnvMpi(processBuilder.environment());
        try {
            ProcessUtil.ProcessResult processResult = ProcessUtil.run(processBuilder.start());
            if (processResult.stderr.isEmpty() && processResult.stdout.startsWith("SUCCESS")) {
                return true;
            }
            if (processResult.stderr.isEmpty() && processResult.stdout.startsWith("FAIL")) {
                return false;
            }
            throw new Exception(processResult.stderr + System.lineSeparator() + processResult.stdout);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Intl.intl("Error validating stored credentials:"));
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(exception.getLocalizedMessage());
            exception.printStackTrace();
            JOptionPane.showMessageDialog(window, stringBuffer.toString(), "MPIEXEC -VALIDATE", 0);
            return false;
        }
    }

    public static boolean validateMpiAuth(Window window, File file) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(file.getPath(), "hostname");
        MpiUtil.scrubEnvMpi(processBuilder.environment());
        try {
            ProcessUtil.ProcessResult processResult = ProcessUtil.run(processBuilder.start(), 20);
            if (!processResult.success) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Intl.intl("Error: mpiexec hostname took too long to execute"));
                stringBuffer.append(System.lineSeparator());
                stringBuffer.append(processResult.stdout.trim());
                stringBuffer.append(System.lineSeparator());
                stringBuffer.append(processResult.stderr.trim());
                throw new Exception(stringBuffer.toString());
            }
            if (processResult.stdout.contains("Credentials") && processResult.stdout.contains("rejected")) {
                throw new FailedLoginException(processResult.stdout);
            }
            if (processResult.stdout.contains("bind error") || processResult.stderr.contains("bind error")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Intl.intl("Error starting test process using stored credentials:"));
                stringBuffer.append(System.lineSeparator());
                stringBuffer.append(processResult.stdout.trim());
                stringBuffer.append(System.lineSeparator());
                stringBuffer.append(processResult.stderr.trim());
                stringBuffer.append(System.lineSeparator());
                stringBuffer.append(Intl.intl("This error usually indicates multiple conflicting MPI installations."));
                throw new Exception(stringBuffer.toString());
            }
            if (!processResult.stdout.isEmpty()) {
                return true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Intl.intl("Error starting test process using stored credentials:"));
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(processResult.stdout.trim());
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(processResult.stderr.trim());
            throw new Exception(stringBuffer.toString());
        }
        catch (FailedLoginException failedLoginException) {
            failedLoginException.printStackTrace();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Intl.intl("Error starting test process using stored credentials:"));
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(failedLoginException.getLocalizedMessage().trim());
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append(Intl.intl("Click Cancel to re-enter credentials."));
            return 0 == JOptionPane.showOptionDialog(window, stringBuffer.toString(), Intl.intl("MPI Authentication Test"), 2, 2, null, new String[]{Intl.intl("Ignore"), Intl.intl("Cancel")}, Intl.intl("Ignore"));
        }
    }

    public static boolean mpiAuth(Window window, File file) {
        try {
            String string;
            Object object;
            if (MpiUtil.testMpiCredentialsPresent(window, file) && MpiUtil.validateMpiAuth(window, file)) {
                return true;
            }
            List<String> list = MpiUtil.listInput(file, MpiUtil.getMPIArgs(file, "-whoami"));
            String string2 = list.isEmpty() ? "" : list.get(list.size() - 1);
            int n = string2.indexOf(92);
            if (0 <= n) {
                object = string2.substring(0, n);
                string = string2.substring(n + 1);
                string2 = String.format("%s\\%s", ((String)object).toUpperCase(), string);
            }
            while (true) {
                if (((guiDialog)(object = new PasswordDlg(window, string2))).doModal() != 1) {
                    return false;
                }
                string = ((PasswordDlg)object).getUser();
                if (string.isEmpty()) {
                    MpiUtil.authError(window, Intl.intl("MPI requires a user name."));
                    continue;
                }
                char[] cArray = ((PasswordDlg)object).getPassword();
                if (cArray.length == 0) {
                    MpiUtil.authError(window, Intl.intl("MPI requires a non-blank password."));
                    continue;
                }
                String[] stringArray = MpiUtil.getMPIArgs(file, "-register");
                Process process = Runtime.getRuntime().exec(stringArray, null, file.getParentFile());
                PrintWriter printWriter = new PrintWriter(process.getOutputStream());
                printWriter.println(string);
                printWriter.println(cArray);
                printWriter.println(cArray);
                printWriter.flush();
                Arrays.fill(cArray, '0');
                MpiUtil.listInput(process);
                if (MpiUtil.validateMpiAuth(window, file)) break;
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = MpiUtil.formatException(iOException);
            MpiUtil.authError(window, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(window, exception.getLocalizedMessage(), Intl.intl("MPI Authentication Test"), 0);
            return false;
        }
        return false;
    }

    private static String formatException(Exception exception) {
        return String.format(Intl.intl("An unknown error ocurred running mpiexec:%n%s"), exception.getClass().getSimpleName() + ": " + exception.getLocalizedMessage());
    }

    private static void authError(Window window, String string) {
        JOptionPane.showMessageDialog(window, string, Intl.intl("Authorization Error"), 0);
    }

    private static List<String> listInput(File file, String[] stringArray) throws IOException {
        File file2 = file.getParentFile();
        Process process = Runtime.getRuntime().exec(stringArray, null, file2);
        return MpiUtil.listInput(process);
    }

    private static List<String> listInput(Process process) throws IOException {
        InputCatcher inputCatcher = new InputCatcher(process.getInputStream());
        Thread thread = new Thread(inputCatcher);
        Thread thread2 = new Thread(new InputCatcher(process.getErrorStream()));
        thread.start();
        thread2.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            thread2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (inputCatcher.d_caughtError != null) {
            throw inputCatcher.d_caughtError;
        }
        return inputCatcher.d_input;
    }

    private static String[] getMPIArgs(File file, String string) {
        return new String[]{file.getAbsolutePath(), string};
    }

    private static class PasswordDlg
    extends guiDialog {
        private static final long serialVersionUID = 8419347243881908319L;
        private final JPasswordField d_password;
        private final guiTextField d_user;

        public PasswordDlg(Window window, String string) {
            super(window, Intl.intl("Enter Password"), 9);
            MultiLineLabel multiLineLabel = new MultiLineLabel(Intl.intl("Please enter a password for MPI to start processes on your computer."));
            multiLineLabel.setColumns(30);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Username:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Password:"));
            this.d_user = new guiTextField(string);
            this.d_password = new JPasswordField();
            this.d_password.setEchoChar('*');
            guiPanel guiPanel2 = this.getDialogPane();
            guiPanel2.setLayout(new GridBagLayout());
            GridBagUtil.add(guiPanel2, multiLineLabel, 0, 0, 2, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiLabel2, 0, 1, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_user, 1, 1, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiLabel3, 0, 2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_password, 1, 2, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    d_user.requestFocusInWindow();
                }
            });
        }

        public char[] getPassword() {
            return this.d_password.getPassword();
        }

        public String getUser() {
            return this.d_user.getValue();
        }
    }

    private static class InputCatcher
    implements Runnable {
        private final List<String> d_input;
        private final InputStream d_stream;
        private IOException d_caughtError = null;

        public InputCatcher(InputStream inputStream) {
            this.d_stream = inputStream;
            this.d_input = new ArrayList<String>();
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.d_stream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.d_input.add(string);
                }
            }
            catch (IOException iOException) {
                this.d_caughtError = iOException;
            }
        }
    }

    private static class MPIAuthException
    extends Exception {
        private static final long serialVersionUID = 3130114192243799206L;

        public MPIAuthException(String string) {
            super(string);
        }
    }
}

