/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JPopupMenu;
import pyrosim.PyroMod;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.actions.Actions;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class MouseSelectionLogic {
    private final PyroMod d_mediator;
    private final Component d_parentComp;
    private static final Predicate<Object> s_selectFilter = new Predicate<Object>(){

        @Override
        public boolean test(Object object) {
            return MouseSelectionLogic.isSelectable(object);
        }
    };

    public MouseSelectionLogic(PyroMod pyroMod, Component component) {
        this.d_mediator = pyroMod;
        this.d_parentComp = component;
    }

    public void handleSelectionSingle(MouseEvent mouseEvent, Collection<Integer> collection, Object ... objectArray) {
        this.handleSelectionSingle(mouseEvent, collection, Arrays.asList(objectArray));
    }

    public void handleSelectionSingle(MouseEvent mouseEvent, Collection<Integer> collection, Collection<?> collection2) {
        Object var4_4 = null;
        if (!(collection2 = theUtil.filter(collection2, s_selectFilter)).isEmpty()) {
            var4_4 = collection2.iterator().next();
        }
        if (mouseEvent.getButton() == 1) {
            this.handleSelectionClick(mouseEvent, collection, var4_4 == null ? Collections.EMPTY_LIST : Arrays.asList(var4_4));
            if (mouseEvent.getClickCount() == 2) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Actions.editSelectedNode();
                    }
                });
            }
        } else if (mouseEvent.isMetaDown()) {
            if (var4_4 == null || !this.d_mediator.getSelectionModel().isSelected(var4_4)) {
                this.handleSelectionClick(mouseEvent, collection, Arrays.asList(var4_4));
            }
            Set<?> set = this.d_mediator.getSelectionModel().getSelection();
            this.showPopup(mouseEvent, set);
        }
    }

    public void handleSelectionMultiple(MouseEvent mouseEvent, Collection<Integer> collection, Object ... objectArray) {
        this.handleSelectionMultiple(mouseEvent, collection, Arrays.asList(objectArray));
    }

    public void handleSelectionMultiple(MouseEvent mouseEvent, Collection<Integer> collection, Collection<?> collection2) {
        collection2 = theUtil.filter(collection2, s_selectFilter);
        this.handleSelectionClick(mouseEvent, collection, collection2);
        if (mouseEvent.isMetaDown()) {
            this.showPopup(mouseEvent, collection2);
        }
    }

    private void showPopup(MouseEvent mouseEvent, Collection<?> collection) {
        JPopupMenu jPopupMenu = Actions.getContextMenu(collection);
        if (jPopupMenu != null) {
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void handleSelectionClick(MouseEvent mouseEvent, Collection<Integer> collection, Collection<?> collection2) {
        Object object22;
        PyroSimSelectionModel pyroSimSelectionModel = this.d_mediator.getSelectionModel();
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
        for (Object object22 : collection2) {
            boolean bl;
            if (mouseEvent.isAltDown() && object22 instanceof IPyroObject) {
                object22 = ((IPyroObject)object22).getParent();
                assert (object22 != null && !(object22 instanceof PyroMod));
            }
            boolean bl2 = bl = !mouseEvent.isControlDown() || !pyroSimSelectionModel.isSelected(object22);
            if (bl && object22 != null) {
                linkedIdentityHashSet.add(object22);
                continue;
            }
            if (object22 == null) continue;
            linkedIdentityHashSet2.add(object22);
        }
        LinkedIdentityHashSet linkedIdentityHashSet3 = new LinkedIdentityHashSet();
        for (IPyroObject iPyroObject : theUtil.filter(linkedIdentityHashSet2, IPyroObject.class)) {
            for (Object object3 = iPyroObject.getParent(); object3 != null && pyroSimSelectionModel.isSelected(object3); object3 = object3.getParent()) {
                linkedIdentityHashSet3.add(object3);
            }
        }
        linkedIdentityHashSet2.addAll(linkedIdentityHashSet3);
        object22 = linkedIdentityHashSet3.iterator();
        while (object22.hasNext()) {
            IPyroObject iPyroObject = (IPyroObject)object22.next();
            for (IPyroObject iPyroObject2 : iPyroObject.getMembers()) {
                if (linkedIdentityHashSet2.contains(iPyroObject2)) continue;
                linkedIdentityHashSet.add(iPyroObject2);
            }
        }
        this.d_mediator.pauseUpdates();
        if (!mouseEvent.isControlDown()) {
            pyroSimSelectionModel.clearSelection();
        }
        pyroSimSelectionModel.deselectAll(linkedIdentityHashSet2);
        pyroSimSelectionModel.selectAll(linkedIdentityHashSet);
        this.d_mediator.resumeUpdates();
    }

    private static boolean isSelectable(Object object) {
        return object instanceof IPyroObject;
    }
}

