/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.FDSRecordPreviewPanel;
import pyrosim.gui.InvisibleSplitPane;
import pyrosim.gui.LibraryDlg;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.util.Util;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Sets;
import thunderheadeng.util.Task;

public class ManagerDlg<T extends IPyroObject, MgrT extends Composite<T>>
extends guiDialog
implements ListSelectionListener,
DlgListener,
Observer,
ActionListener {
    private static final long serialVersionUID = -7711774257867902856L;
    private final JFrame d_owner;
    private final guiPanel d_mgrEdPanel;
    private final guiPanel d_actPanel;
    private final guiPanel d_edPanel;
    private ListCellRenderer d_ren;
    public static final String KEY = "KEY";
    private MgrT d_mgr;
    private RecordList d_recs;
    private IEditor<T> d_editor;
    private IEditor<MgrT> d_mgrEditor;
    private FDSRecordPreviewPanel d_preview;
    private T d_tempRecord;
    private boolean d_previewLock = false;
    protected int d_edix;

    protected ManagerDlg(JFrame jFrame, String string) {
        this(jFrame, string, false);
    }

    protected ManagerDlg(JFrame jFrame, String string, boolean bl) {
        super((Window)jFrame, string, 11);
        this.d_owner = jFrame;
        this.d_mgr = null;
        this.d_editor = null;
        this.d_mgrEditor = null;
        this.d_ren = new ManagedListCellRen();
        this.d_recs = new RecordList();
        this.d_recs.addListener(this);
        this.d_tempRecord = null;
        this.d_preview = null;
        if (bl && PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW)) {
            this.d_preview = new FDSRecordPreviewPanel(FDS.newRenderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps()));
            this.d_preview.setEnabled(false);
        }
        this.d_edix = -1;
        this.addDlgListener(this);
        CloseListener closeListener = new CloseListener();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(keyStroke);
        this.getRootPane().registerKeyboardAction(closeListener, keyStroke, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeListener);
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new BorderLayout());
        this.d_mgrEdPanel = new guiPanel(new GridBagLayout());
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        this.d_edPanel = new guiPanel(new GridBagLayout());
        this.d_actPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(this.d_actPanel, Box.createGlue(), 0, 100, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0);
        GridBagUtil.add(guiPanel3, this.d_recs, 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0);
        GridBagUtil.add(guiPanel3, this.d_actPanel, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0);
        InvisibleSplitPane invisibleSplitPane = new InvisibleSplitPane(1, true, guiPanel3, this.d_edPanel);
        invisibleSplitPane.setDividerSize(12);
        guiPanel2.add((Component)this.d_mgrEdPanel, "North");
        guiPanel2.add((Component)invisibleSplitPane, "Center");
        this.setResizable(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.d_status = 16;
        this.fireButtonPressed(16);
    }

    public RecordList getList() {
        return this.d_recs;
    }

    public IEditor<T> getEditor() {
        return this.d_editor;
    }

    protected void setRenderer(ListCellRenderer listCellRenderer) {
        this.d_ren = listCellRenderer;
    }

    protected final boolean preSave() {
        if (this.d_editor.isModified()) {
            int n = this.showConfirm();
            if (n == 1) {
                this.initItem(this.getList().getItem(this.d_edix));
            } else if (n == 0) {
                if (!this.handleYes()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.getList().getSelectedIx();
        if (this.d_edix == n) {
            return;
        }
        if (-1 < this.d_edix && this.d_edix < ((Composite)this.d_mgr).flatten().size() && this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    boolean bl = this.handleYes();
                    if (!bl) {
                        this.handleCancel();
                        break;
                    }
                }
                case 1: {
                    this.handleNo(n);
                    this.d_edix = n;
                    break;
                }
                default: {
                    this.handleCancel();
                    break;
                }
            }
        } else if (n > -1) {
            this.d_edix = n;
            this.handleNo(n);
        } else {
            this.d_edix = n;
            this.initItem(null);
        }
    }

    protected boolean handleYes() {
        Object t = this.getList().getItem(this.d_edix);
        this.d_previewLock = true;
        boolean bl = this.d_editor.getEditorPanel().validateData(true, true);
        this.d_previewLock = false;
        if (!bl) {
            this.d_recs.select(this.d_edix);
            return false;
        }
        this.commit(t);
        return true;
    }

    protected void handleNo(int n) {
        this.d_edix = n;
        Object var2_2 = this.d_edix > -1 ? this.getList().getItem(this.d_edix) : null;
        this.initItem(var2_2);
    }

    protected void handleCancel() {
        this.d_recs.select(this.d_edix);
    }

    public int showConfirm() {
        Object t = this.getList().getItem(this.d_edix);
        String string = String.format(Intl.intl("Save changes to %s?"), Util.getName(t));
        return JOptionPane.showConfirmDialog(this, string);
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.handleNo(this.d_edix);
                        this.setVisible(false);
                        break;
                    }
                    this.handleCancel();
                    break;
                }
                case 1: {
                    this.handleNo(this.d_edix);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.handleCancel();
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    private void commit(T t) {
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).pauseUpdates();
        this.d_editor.commit(t);
        if (this.d_preview != null) {
            this.setPreview(t, false);
        }
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).resumeUpdates();
    }

    @Override
    public void applyPressed() {
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).pauseUpdates();
        if (this.d_editor.isModified()) {
            int n = this.getList().getSelectedIx();
            Object t = this.getList().getItem(n);
            this.commit((IPyroObject)t);
            this.getList().repaint();
        }
        if (this.d_mgrEditor != null && this.d_mgrEditor.isModified()) {
            this.d_mgrEditor.commit(this.d_mgr);
        }
        ((PyroMod)((ADomainObject)this.d_mgr).getDomain()).resumeUpdates();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        this.d_previewLock = true;
        boolean bl3 = this.d_editor.getEditorPanel().validateData(bl, bl2) && (this.d_mgrEditor == null || this.d_mgrEditor.getEditorPanel().validateData(bl, bl2));
        this.d_previewLock = false;
        return bl3;
    }

    protected void init(MgrT MgrT, IEditor<T> iEditor, Action[] actionArray) {
        this.init(MgrT, iEditor, actionArray, null);
    }

    protected void init(MgrT MgrT, IEditor<T> iEditor, Action[] actionArray, T t) {
        this.init(MgrT, iEditor, null, actionArray, t);
    }

    protected void init(MgrT MgrT, IEditor<T> iEditor, IEditor<MgrT> iEditor2, Action[] actionArray) {
        this.init(MgrT, iEditor, iEditor2, actionArray, null);
    }

    protected void init(MgrT MgrT, IEditor<T> iEditor, IEditor<MgrT> iEditor2, Action[] actionArray, T t) {
        if (this.d_editor != null) {
            this.d_editor.removeObserver(this);
        }
        this.d_mgr = MgrT;
        this.d_editor = iEditor;
        this.d_mgrEditor = iEditor2;
        this.d_recs.setModel(MgrT, this.d_ren);
        if (this.d_mgrEditor != null) {
            this.d_mgrEditor.init(this.d_mgr);
        }
        this.d_edix = -1;
        if (((Composite)this.d_mgr).flatten().size() > 0) {
            this.d_recs.select(0);
        }
        this.d_actPanel.removeAll();
        for (int i = 0; i < actionArray.length; ++i) {
            KeyStroke keyStroke = (KeyStroke)actionArray[i].getValue(KEY);
            if (keyStroke != null) {
                this.d_recs.d_list.getInputMap().put(keyStroke, "released");
                this.d_recs.d_list.getActionMap().put("released", actionArray[i]);
            }
            JButton jButton = new JButton(actionArray[i]);
            int n = i == actionArray.length - 1 ? 0 : 6;
            GridBagUtil.add(this.d_actPanel, jButton, 0, i, 1, 1, 0, 0, n, 0, 2, 1.0, 0.0);
        }
        this.d_mgrEdPanel.removeAll();
        if (this.d_mgrEditor != null) {
            GridBagUtil.add(this.d_mgrEdPanel, this.d_mgrEditor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 18);
        }
        this.d_edPanel.removeAll();
        if (this.d_preview == null) {
            GridBagUtil.add(this.d_edPanel, this.d_editor.getEditorPanel(), 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        } else {
            InvisibleSplitPane invisibleSplitPane = new InvisibleSplitPane(0, true, this.d_editor.getEditorPanel(), this.d_preview);
            invisibleSplitPane.setDividerSize(12);
            GridBagUtil.add(this.d_edPanel, invisibleSplitPane, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
        }
        this.d_editor.addObserver(this);
        this.pack();
        if (t != null) {
            this.getList().select(t);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.d_preview != null && this.d_tempRecord != null && !this.d_previewLock) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IPyroObject iPyroObject = ManagerDlg.this.d_editor.preview(ManagerDlg.this.d_tempRecord);
                        if (iPyroObject != null) {
                            ManagerDlg.this.setPreview(iPyroObject, true);
                            ManagerDlg.this.d_tempRecord = iPyroObject;
                        }
                    }
                    catch (Throwable throwable) {
                        System.err.println("[2293fa] FDS Preview Failed: " + throwable.getMessage());
                        throwable.printStackTrace();
                    }
                }
            });
        }
        this.d_recs.repaint();
    }

    public void setPreview(T t, boolean bl) {
        this.d_preview.setRecord((IPyroObject)t, bl);
    }

    protected Collection<? extends T> getModelColl(MgrT MgrT) {
        return Util.sort(MgrT);
    }

    protected void initItem(T t) {
        this.d_previewLock = true;
        this.d_editor.init(t);
        this.d_previewLock = false;
        if (this.d_preview != null) {
            this.d_preview.setEnabled(t != null);
            if (t != null) {
                this.d_tempRecord = (IPyroObject)t.clone();
                this.setPreview(this.d_tempRecord, false);
            }
        }
        if (t != null) {
            PyroSim.getApp().getMediator().getSelectionModel().setSelection(t);
        }
    }

    public FDSRecordPreviewPanel getPreviewPnl() {
        return this.d_preview;
    }

    public void setPreviewTypes(String ... stringArray) {
        this.setPreviewTypes(Sets.fromArrayHS(stringArray));
    }

    public void setPreviewTypes(Collection<String> collection) {
        FDSRecordPreviewPanel fDSRecordPreviewPanel = this.getPreviewPnl();
        if (fDSRecordPreviewPanel != null) {
            fDSRecordPreviewPanel.setRenderDeps(true);
            fDSRecordPreviewPanel.setRecordFilter(fDSRenderRecord -> collection.contains(fDSRenderRecord.getType()));
        }
    }

    protected class LibraryAction
    extends guiAction {
        private static final long serialVersionUID = -5364133990644521647L;
        private final Class<T> d_type;

        public LibraryAction(Class<T> clazz) {
            super(Intl.intl("Add From Library") + "...");
            this.d_type = clazz;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ManagerDlg.this.preSave()) {
                return;
            }
            int n = ManagerDlg.this.getList().getSelectedIx();
            LibraryDlg libraryDlg = new LibraryDlg(ManagerDlg.this.d_owner, this.d_type);
            libraryDlg.doModal();
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
            int n2 = n - 1 < 0 && !ManagerDlg.this.d_mgr.flatten().isEmpty() ? 0 : n - 1;
            if (n >= 0) {
                ManagerDlg.this.getList().select(n2);
                if (n2 == n) {
                    ManagerDlg.this.initItem(ManagerDlg.this.getList().getItem(n2));
                }
            }
        }
    }

    protected class DeleteAction
    extends guiAction {
        private static final long serialVersionUID = 8607244730954836742L;

        public DeleteAction() {
            super(Intl.intl("Delete..."));
            this.putValue(ManagerDlg.KEY, KeyStroke.getKeyStroke(127, 0, true));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ManagerDlg.this.getList().getSelectedIx();
            Object t = ManagerDlg.this.getList().getItem(n);
            PyroMod pyroMod = (PyroMod)ManagerDlg.this.d_mgr.getDomain();
            Task task = Actions.getDeleteTask(pyroMod, Arrays.asList(t));
            if (task == null) {
                return;
            }
            ManagerDlg.this.d_editor.getEditorPanel().setModified(false);
            pyroMod.getTaskManager().exec(task, Intl.intl("Delete"));
            ManagerDlg.this.getList().updateModelView(ManagerDlg.this.d_mgr);
            int n2 = n - 1 < 0 && !ManagerDlg.this.d_mgr.flatten().isEmpty() ? 0 : n - 1;
            ManagerDlg.this.getList().select(n2);
            if (n2 == n) {
                ManagerDlg.this.initItem(ManagerDlg.this.getList().getItem(n2));
            }
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.close();
        }

        private void close() {
            ManagerDlg.this.d_status = 16;
            ManagerDlg.this.fireButtonPressed(16);
        }
    }

    private class ManagedListCellRen
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7609602000218412444L;
        private Font d_italic = new Font("SansSerif", 2, 11);
        private Font d_plain = new Font("SansSerif", 0, 11);

        private ManagedListCellRen() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, Util.getName((IPyroObject)object), n, bl, bl2);
            component.setEnabled(((IPyroObject)object).isEnabled());
            if (n == ManagerDlg.this.d_edix && ManagerDlg.this.d_editor.isModified()) {
                component.setFont(this.d_italic);
            } else {
                component.setFont(this.d_plain);
            }
            return component;
        }
    }

    public class RecordList
    extends guiPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = -579898510570858990L;
        private final JList d_list = new JList();
        private final JScrollPane d_jsp;
        private final List d_listeners;
        private boolean d_suppressNotify;

        public RecordList() {
            this.d_list.addListSelectionListener(this);
            this.d_list.setSelectionMode(0);
            this.d_jsp = new JScrollPane(this.d_list);
            this.d_jsp.setVerticalScrollBarPolicy(22);
            this.d_jsp.setPreferredSize(new Dimension(120, 180));
            this.setLayout(new BorderLayout());
            this.add((Component)this.d_jsp, "Center");
            this.d_suppressNotify = false;
            this.d_listeners = new ArrayList();
        }

        public int getSelectedIx() {
            return this.d_list.getSelectedIndex();
        }

        public T getItem(int n) {
            return (IPyroObject)this.d_list.getModel().getElementAt(n);
        }

        public void select(int n) {
            this.d_list.setSelectedIndex(n);
            this.valueChanged();
        }

        public void select(T t) {
            this.d_list.setSelectedValue(t, true);
            this.valueChanged();
        }

        public void setModel(MgrT MgrT, ListCellRenderer listCellRenderer) {
            this.d_list.setCellRenderer(listCellRenderer);
            this.d_list.setModel(new DefaultListModel());
            this.updateModelView(MgrT);
        }

        public void updateModelView(MgrT MgrT) {
            DefaultListModel defaultListModel = (DefaultListModel)this.d_list.getModel();
            Object e = this.d_list.getSelectedValue();
            int n = this.d_jsp.getVerticalScrollBar().getValue();
            this.d_suppressNotify = true;
            defaultListModel.clear();
            for (IPyroObject iPyroObject : ManagerDlg.this.getModelColl(MgrT)) {
                defaultListModel.addElement(iPyroObject);
            }
            this.d_suppressNotify = false;
            int n2 = Math.min(n, this.d_jsp.getVerticalScrollBar().getMaximum());
            this.d_jsp.getVerticalScrollBar().setValue(n2);
            if (defaultListModel.contains(e)) {
                this.d_list.setSelectedValue(e, false);
            } else {
                this.d_list.setSelectedIndex(0);
            }
        }

        public void addListener(ListSelectionListener listSelectionListener) {
            this.d_listeners.add(listSelectionListener);
        }

        public void removeListener(Object object) {
            this.d_listeners.remove(object);
        }

        private void valueChanged() {
            int n = this.d_list.getSelectedIndex();
            ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n, false);
            this.valueChanged(listSelectionEvent);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.d_suppressNotify) {
                return;
            }
            for (Object e : this.d_listeners) {
                ((ListSelectionListener)e).valueChanged(listSelectionEvent);
            }
        }

        public int getNumItems() {
            return this.d_list.getModel().getSize();
        }
    }
}

